/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dflyobj.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 22:43:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _DFLYOBJ_HXX
#define	_DFLYOBJ_HXX

#ifndef _SVDOVIRT_HXX //autogen
#include <bf_svx/svdovirt.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <bf_svx/svdobj.hxx>
#endif
namespace binfilter {

class SwFlyFrm;
class SwFrmFmt;
class SdrObjMacroHitRec;

const UINT32 SWGInventor =	UINT32('S')*0x00000001+
							UINT32('W')*0x00000100+
							UINT32('G')*0x00010000;

const UINT16 SwFlyDrawObjIdentifier = 0x0001;
const UINT16 SwDrawFirst			= 0x0001;

//---------------------------------------
//SwFlyDrawObj, Die DrawObjekte fuer Flys.

class SwFlyDrawObj : public SdrObject
{
	SfxItemSet*					mpLocalItemSet;

public:
	TYPEINFO();

	SwFlyDrawObj();
	~SwFlyDrawObj();


	// ItemSet access

	//Damit eine Instanz dieser Klasse beim laden erzeugt werden kann
	//(per Factory).
	virtual UINT32 GetObjInventor()		const;
	virtual UINT16 GetObjIdentifier()	const;
};

//---------------------------------------
//SwVirtFlyDrawObj, die virtuellen Objekte fuer Flys.
//Flys werden immer mit virtuellen Objekten angezeigt. Nur so koennen sie
//ggf. mehrfach angezeigt werden (Kopf-/Fusszeilen).

class SwVirtFlyDrawObj : public SdrVirtObj
{
	SwFlyFrm *pFlyFrm;

public:
	TYPEINFO();

	SwVirtFlyDrawObj(SdrObject& rNew, SwFlyFrm* pFly);
	~SwVirtFlyDrawObj();

	//Ueberladene Methoden der Basisklasse SdrVirtObj

	//Wir nehemen die Groessenbehandlung vollstaendig selbst in die Hand.
	virtual const Rectangle& GetBoundRect() const;
	virtual const Rectangle& GetSnapRect()	const;

		  SwFrmFmt *GetFmt();

	// Get Methoden fuer die Fly Verpointerung
		  SwFlyFrm* GetFlyFrm()			{ return pFlyFrm; }
	const SwFlyFrm* GetFlyFrm() const	{ return pFlyFrm; }

	void SetRect() const;
	void _SetRectsDirty()				{ SetRectsDirty(); }

	// ist eine URL an einer Grafik gesetzt, dann ist das ein Makro-Object
};


} //namespace binfilter
#endif
