/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_docst.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 23:59:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include <hintids.hxx>

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_TEMPLDLG_HXX //autogen
#include <bf_sfx2/templdlg.hxx>
#endif
#ifndef _SFX_TPLPITEM_HXX //autogen
#include <bf_sfx2/tplpitem.hxx>
#endif
#ifndef _OFA_HTMLCFG_HXX //autogen
#include <bf_offmgr/htmlcfg.hxx>
#endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

#include "view.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#include "wrtsh.hxx"
#include "docsh.hxx"
#include "cmdid.h"
#include "globals.hrc"
#include "doc.hxx"
#include "swstyle.h"
#include "charfmt.hxx"
#include "poolfmt.hxx"
#include "uiitems.hxx"
#include "fmtcol.hxx"
#include "edtwin.hxx"

#include "app.hrc"
namespace binfilter {


/*N*/ void  SwDocShell::StateStyleSheet(SfxItemSet& rSet, SwWrtShell* pSh)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT 	nWhich 	= aIter.FirstWhich();
/*N*/ 	USHORT nActualFamily = USHRT_MAX;
/*N*/ 
/*N*/ 	SwWrtShell* pShell = pSh ? pSh : GetWrtShell();
/*N*/     if(!pShell)
/*N*/ 	{
/*?*/ 		while (nWhich)
/*?*/ 		{
/*?*/ 			rSet.DisableItem(nWhich);
/*?*/ 			nWhich = aIter.NextWhich();
/*?*/ 		}
/*?*/ 		return;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SfxViewFrame* pFrame = pShell->GetView().GetViewFrame();
/*N*/ 		const ISfxTemplateCommon* pCommon = SFX_APP()->GetCurrentTemplateCommon(pFrame->GetBindings());
/*N*/ 		if( pCommon )
/*N*/ 			nActualFamily = pCommon->GetActualFamily();
/*N*/ 	}

/*N*/ 	while (nWhich)
/*N*/ 	{
/*N*/ 		// aktuelle Vorlage zu jeder Familie ermitteln
/*N*/ 		//
/*N*/ 		String aName;
/*N*/ 		switch (nWhich)
/*N*/ 		{
/*N*/ 			case SID_STYLE_APPLY:
/*N*/ 			{//hier wird die Vorlage und ihre Familie an die StyleBox
/*N*/ 			 //uebergeben, damit diese Familie angezeigt wird
/*N*/ 				if(pShell->IsFrmSelected())
/*N*/ 				{
/*?*/ 					SwFrmFmt* pFmt = pShell->GetCurFrmFmt();
/*?*/ 					if( pFmt )
/*?*/ 						aName = pFmt->GetName();
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					SwTxtFmtColl* pColl = pShell->GetCurTxtFmtColl();
/*N*/ 					if(pColl)
/*N*/ 						aName = pColl->GetName();
/*N*/ 				}
/*N*/ 				rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_STYLE_FAMILY1:
/*N*/ 				if( !pShell->IsFrmSelected() )
/*N*/ 				{
/*N*/ 					SwCharFmt* pFmt = pShell->GetCurCharFmt();
/*N*/ 					if(pFmt)
/*N*/ 						aName = pFmt->GetName();
/*N*/ 					else
/*N*/ 						aName = *SwStyleNameMapper::GetTextUINameArray()[
/*N*/ 							RES_POOLCOLL_STANDARD - RES_POOLCOLL_TEXT_BEGIN ];
/*N*/                     rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/                 }
/*N*/                 break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY2:
/*N*/ 				if(!pShell->IsFrmSelected())
/*N*/ 				{
/*N*/ 					SwTxtFmtColl* pColl = pShell->GetCurTxtFmtColl();
/*N*/ 					if(pColl)
/*N*/ 						aName = pColl->GetName();
/*N*/ 
/*N*/ 					SfxTemplateItem aItem(nWhich, aName);
/*N*/ 
/*N*/ 					USHORT nMask = 0;
/*N*/ 					if( pDoc->IsHTMLMode() )
/*N*/ 						nMask = SWSTYLEBIT_HTML;
/*N*/ 					else
/*N*/ 					{
/*N*/ 						const int nSelection = pShell->GetFrmType(0,TRUE);
/*N*/ 						if(pShell->GetCurTOX())
/*N*/ 							nMask = SWSTYLEBIT_IDX	;
/*N*/ 						else if(nSelection & FRMTYPE_HEADER 	||
/*N*/ 								nSelection & FRMTYPE_FOOTER 	||
/*N*/ 								nSelection & FRMTYPE_TABLE 		||
/*N*/ 								nSelection & FRMTYPE_FLY_ANY 	||
/*N*/ 								nSelection & FRMTYPE_FOOTNOTE 	||
/*N*/ 								nSelection & FRMTYPE_FTNPAGE)
/*N*/ 							nMask = SWSTYLEBIT_EXTRA;
/*N*/ 						else
/*N*/ 							nMask = SWSTYLEBIT_TEXT;
/*N*/ 					}
/*N*/ 
/*N*/ 					aItem.SetValue(nMask);
/*N*/ 					rSet.Put(aItem);
/*N*/ 				}
/*N*/ 
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY3:
/*N*/ 
/*N*/ 				if( pDoc->IsHTMLMode() )
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					SwFrmFmt* pFmt = pShell->GetCurFrmFmt();
/*N*/ 					if(pFmt && pShell->IsFrmSelected())
/*N*/                     {
/*?*/ 						aName = pFmt->GetName();
/*?*/                         rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/                     }
/*N*/                 }
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY4:
/*N*/ 			{
/*N*/ 				OfaHtmlOptions* pHtmlOpt = OFF_APP()->GetHtmlOptions();
/*N*/ 				if( pDoc->IsHTMLMode() && !pHtmlOpt->IsPrintLayoutExtension())
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					USHORT n = pShell->GetCurPageDesc( FALSE );
/*N*/ 					if( n < pShell->GetPageDescCnt() )
/*N*/ 						aName = pShell->GetPageDesc( n ).GetName();
/*N*/ 
/*N*/ 					rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_STYLE_FAMILY5:
/*N*/ 				{
/*N*/ 					const SwNumRule* pRule = pShell->GetCurNumRule();
/*N*/ 					if( pRule )
/*N*/ 						aName = pRule->GetName();
/*N*/ 
/*N*/ 					rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_WATERCAN:
/*N*/ 			{
/*N*/                 SwEditWin& rEdtWin = pShell->GetView().GetEditWin();
/*N*/                 SwApplyTemplate* pApply = rEdtWin.GetApplyTemplate();
/*N*/                 rSet.Put(SfxBoolItem(nWhich, pApply && pApply->eType != 0));
/*N*/ 			}
/*N*/             break;
/*N*/ 			case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 				if( pShell->IsFrmSelected()
/*N*/ 						? SFX_STYLE_FAMILY_FRAME != nActualFamily
/*N*/ 						: ( SFX_STYLE_FAMILY_FRAME == nActualFamily ||
/*N*/ 							SFX_STYLE_FAMILY_PAGE == nActualFamily ||
/*N*/ 							(SFX_STYLE_FAMILY_PSEUDO == nActualFamily && !pShell->GetCurNumRule())) )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_NEW_BY_EXAMPLE:
/*N*/ 				if( (pShell->IsFrmSelected()
/*N*/ 						? SFX_STYLE_FAMILY_FRAME != nActualFamily
/*N*/ 						: SFX_STYLE_FAMILY_FRAME == nActualFamily) ||
/*N*/ 					(SFX_STYLE_FAMILY_PSEUDO == nActualFamily && !pShell->GetCurNumRule()) )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			default:
/*?*/ 				DBG_ERROR( "Invalid SlotId");
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }


/*N*/ void SwDocShell::ExecStyleSheet( SfxRequest& rReq )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	USHORT 	nSlot 	= rReq.GetSlot();
/*N*/ }

}
