/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fsetvwsh.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:00:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXFSETVIW_HXX
#define _SFXFSETVIW_HXX

#include <bf_sfx2/viewsh.hxx>
class SplitWindow;
namespace binfilter {

class SfxFrameSetDescriptor;
class SfxFrame;
class SfxURLFrame;
struct SfxFrameSet_Impl;

//===========================================================================
// Die SfxFrameSetViewShell ist die zur SfxFrameSetObjectShell geh"orende
// DefaultView. Sie erzeugt ein SfxFrameSet und benutzt dessen SplitWindow
// als EditWindow.
// "Uber die SfxFrameSetViewShell k"onnen alls Slots ausgef"uhrt werden, die
// die splitbare View betreffen.
//===========================================================================

class SfxFrameSetViewShell: public SfxViewShell
{
	SfxFrameSetDescriptor*	pDescriptor;
	BOOL					bEditMode;
	SfxFrameSet_Impl*		pImp;

private:

protected:
	virtual void    OuterResizePixel( const Point &rOfs, const Size &rSize ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void    OuterResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    InnerResizePixel( const Point &rOfs, const Size &rSize ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void    InnerResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 const SfxHint& rHint, const TypeId& rHintType );
public:
					TYPEINFO();
					SfxFrameSetViewShell( SfxViewFrame *pFrame,
										  const SfxFrameSetViewShell& rWin,
										  USHORT nFlags = SFX_VIEW_MAXIMIZE_FIRST );
					SfxFrameSetViewShell( SfxViewFrame *pFrame,
										  SfxViewShell *pOld,
										  USHORT nFlags = SFX_VIEW_MAXIMIZE_FIRST );
					~SfxFrameSetViewShell();

	virtual void    Activate( BOOL bMDI ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void    Activate( BOOL bMDI );

#if _SOLAR__PRIVATE
#endif
};

}//end of namespace binfilter
#endif

