/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxctrl.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:10:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXTBXCTRL_HXX
#define _SFXTBXCTRL_HXX

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif
#include <bf_sfx2/ctrlitem.hxx>
namespace binfilter {

//------------------------------------------------------------------

class SfxUnoToolBoxControl;
class SfxToolBoxControl;
class SfxBindings;
class SfxModule;
class SfxUnoControllerItem;

typedef SfxToolBoxControl* (*SfxToolBoxControlCtor)( USHORT nId, ToolBox &rTbx, SfxBindings & );

struct SfxTbxCtrlFactory
{
	SfxToolBoxControlCtor	pCtor;
	TypeId					nTypeId;
	USHORT					nSlotId;

	SfxTbxCtrlFactory( SfxToolBoxControlCtor pTheCtor,
			TypeId nTheTypeId, USHORT nTheSlotId ):
		pCtor(pTheCtor),
		nTypeId(nTheTypeId),
		nSlotId(nTheSlotId)
	{}
};

//------------------------------------------------------------------

enum SfxPopupWindowType
{
	SFX_POPUPWINDOW_NONE,
	SFX_POPUPWINDOW_ONCLICK,
	SFX_POPUPWINDOW_ONTIMEOUT,
	SFX_POPUPWINDOW_ONCLICKANDMOVE,
	SFX_POPUPWINDOW_ONTIMEOUTANDMOVE,
	SFX_POPUPWINDOW_CONTEXTMENU
};

//------------------------------------------------------------------

/*	FloatingWindows, die aus ToolBoxen abgerissen werden k"onnen, sollten
	dieser Klasse abgeleitet werden. Da sie ebenfalls von SfxControllerItem
	abgeleitet ist, erhalten ihre Instanzen auch die StateChanged Aufrufe.
*/

class SfxPopupWindow: public FloatingWindow, public SfxControllerItem
{
friend class SfxToolBox_Impl;
	BOOL					bFloating;
	ULONG					nEventId;
	BOOL					bCascading;
	Link					aDeleteLink;

	private:
#if _SOLAR__PRIVATE
#endif

protected:

public:
							SfxPopupWindow( USHORT nId, WinBits nBits, SfxBindings & );
							SfxPopupWindow( USHORT nId, const ResId &rId, SfxBindings & );
                            ~SfxPopupWindow();

#if _SOLAR__PRIVATE
#endif
};

//------------------------------------------------------------------

#define SFX_DECL_TOOLBOX_CONTROL() \
		static SfxToolBoxControl* CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ); \
		static void RegisterControl(USHORT nSlotId = 0, SfxModule *pMod=NULL)

#define SFX_IMPL_TOOLBOX_CONTROL(Class, nItemClass) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

#define SFX_IMPL_TOOLBOX_CONTROL_ARG(Class, nItemClass, Arg) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings, Arg); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

//------------------------------------------------------------------

/*	F"ur spezielle ToolBox-Controls, z.B. eine Font-Auswahl-Box oder
	aus ToolBoxen abrei"sbare FloatingWindows mu"s passend zur Item-Subclass
	eine Subclass von SfxTooBoxControl implementiert werden.

	Diese Klasse mu"s in SfxApplication::Init() mit der statischen Methode
	RegisterControl() registriert werden. Der SFx erzeugt dann automatisch
	diese Controls in ToolBoxen, wenn die dazugeh"origen Slots von dem
	angegebenen Typ sind.
 */

class SfxToolBoxControl: public SfxControllerItem
{
friend class SfxToolBoxManager;
	ToolBox*				pBox;
	BOOL					bShowString;
	USHORT                  nSelectModifier;
	SfxTbxCtrlFactory*		pFact;

protected:
	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState );
	virtual void			Select( BOOL bMod1 = FALSE );
	virtual void			Select( USHORT nModifier );

	virtual void			DoubleClick();
	virtual void			Click();
	virtual SfxPopupWindowType
							GetPopupWindowType() const;
	virtual Window*         CreateItemWindow( Window *pParent );

public:
							SFX_DECL_TOOLBOX_CONTROL();

							SfxToolBoxControl( USHORT nId, ToolBox& rBox,
											   SfxBindings &,
											   BOOL bShowStrings = FALSE );
	virtual 				~SfxToolBoxControl();

	ToolBox&				GetToolBox() const
							{ return *pBox; }

	static SfxToolBoxControl* CreateControl( USHORT nId, ToolBox *pBox,
											 SfxBindings&, SfxModule *pMod );

	static SfxUnoToolBoxControl* CreateControl( const String&, USHORT nId,
											 ToolBox *pBox,
											 SfxBindings& );
#if _SOLAR__PRIVATE
	SfxToolBoxControl*		ReInit_Impl();
#endif
};


//=========================================================================

#if _SOLAR__PRIVATE


/*  [Beschreibung]

*/


//------------------------------------------------------------------------

class SfxAppToolBoxControl_Impl : public SfxToolBoxControl

/*  [Beschreibung]

	Interne Hilfsklasse f"ur um das Popup-Menu <AppMenu_Impl> unter Neu
	im SDT zu starten.
*/

{
    String                  aLastURL;
	Timer					aTimer;
	BOOL					bBigImages;
    PopupMenu*              pMenu;
	BOOL					m_bWasHiContrastMode;
	BOOL					m_bShowMenuImages;

private:
							DECL_LINK( Timeout, Timer * );

protected:
    virtual void            Click();
	virtual void			Select( BOOL );
    virtual void            StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
							DECL_LINK( Activate, Menu * ); // Needed to support high contrast images
public:
							SFX_DECL_TOOLBOX_CONTROL();
                            SfxAppToolBoxControl_Impl( USHORT nId, ToolBox& rBox,  SfxBindings& );
                            ~SfxAppToolBoxControl_Impl();
	void					SetImage( const String& rFacName );
};



class SfxPopupMenuManager;
class SfxAddonsToolBoxControl_Impl : public SfxToolBoxControl

/*  [Description]

	Internal helper class to provide the addons popup menu through the addons
	toolbox button.
*/

{
	BOOL					bBigImages;
    SfxPopupMenuManager*    pMenu;
	BOOL					m_bWasHiContrastMode;
	BOOL					m_bShowMenuImages;

protected:
    virtual void            Click();
	virtual void			Select( BOOL );
    virtual void            StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
							DECL_LINK( Activate, Menu * ); // Needed to support high contrast images
public:
							SFX_DECL_TOOLBOX_CONTROL();
                            SfxAddonsToolBoxControl_Impl( USHORT nId, ToolBox& rBox,  SfxBindings& );
                            ~SfxAddonsToolBoxControl_Impl();

                            void RefreshMenuImages( Menu* pMenu );
};

#endif

}//end of namespace binfilter
#endif
