/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewfrm.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:11:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXVIEWFRM_HXX
#define _SFXVIEWFRM_HXX

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <bf_sfx2/module.hxx>
#endif
#include <bf_sfx2/frame.hxx>
#include <bf_sfx2/shell.hxx>
namespace so3 {
class SvLinkSource;
};
class SvBorder;
class SvPseudoObject;
class SfxCancelManager;
class SystemWindow;
class Fraction;
class Point;
class Size;
namespace binfilter {

class SfxMacro;
class SfxDispatcher;
class SfxObjectShell;
class SfxBindings;
class SfxProgress;
class SvData;
class SfxViewShell;
#ifdef ENABLE_INIMANAGER//MUSTINI
class SfxIniManager;
#endif
class SfxInPlaceFrame;
class SfxChildWindow;

//STRIP008 namespace so3 {
//STRIP008 class SvLinkSource;
//STRIP008 };

#ifndef SFX_DECL_OBJECTSHELL_DEFINED
#define SFX_DECL_OBJECTSHELL_DEFINED
SV_DECL_REF(SfxObjectShell)
SV_DECL_LOCK(SfxObjectShell)
#endif

//========================================================================
class SfxImageManager;
class SfxViewFrame: public SfxShell, public SfxListener
{
	struct SfxViewFrame_Impl*	pImp;

	SfxObjectShellRef			xObjSh;
	SfxDispatcher*				pDispatcher;
	SfxBindings*				pBindings;
	USHORT						nAdjustPosPixelLock;

private:
#ifndef _SFX_HXX
	void					Construct_Impl( SfxObjectShell *pObjSh=NULL );
#endif

protected:
	virtual void            SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );

	void					SetWindow_Impl( Window *pWin );

#ifndef _SFX_HXX
	BOOL					SwitchToViewShell_Impl( USHORT nNo, BOOL bIsIndex = FALSE );
	void                    KillDispatcher_Impl();
#endif

	virtual                 ~SfxViewFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXVIEWFRM);

							SfxViewFrame() {}
							SfxViewFrame( SfxBindings&, SfxFrame*, SfxObjectShell *pDoc=0, sal_uInt32 nType = 0 );


	static SfxViewFrame*    Current();
	static SfxViewFrame*	GetFirst( const SfxObjectShell* pDoc = 0,
								   TypeId aType = 0,
								   BOOL bOnlyVisible = TRUE );
	static SfxViewFrame*    GetNext( const SfxViewFrame& rPrev,
									const SfxObjectShell* pDoc = 0,
									TypeId aType = 0 ,
									BOOL bOnlyVisible = TRUE );

			void            DoActivate(BOOL bMDI, SfxViewFrame *pOld=NULL);
			void            DoDeactivate(BOOL bMDI, SfxViewFrame *pOld=NULL);

	SfxViewFrame*			GetParentViewFrame() const;

	SfxDispatcher*          GetDispatcher() { return pDispatcher; }
	SfxBindings&            GetBindings() { return *pBindings; }
	const SfxBindings&      GetBindings() const  { return *pBindings; }
	Window&         		GetWindow() const;
	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY ) = 0;

	SfxProgress*            GetProgress() const;
#ifdef ENABLE_INIMANAGER//MUSTINI
	SfxIniManager*          GetIniManager() const;
#endif

#if SUPD<604
    SfxViewShell*           GetViewShell() const;
#endif
	SfxObjectShell* 		GetObjectShell() const
							{ return xObjSh; }

	void                    LockAdjustPosSizePixel()
							{ nAdjustPosPixelLock++; }
	void                    UnlockAdjustPosSizePixel()
							{ nAdjustPosPixelLock--; }
	void                    DoAdjustPosSizePixel( SfxViewShell * pSh,
										const Point &rPos, const Size &rSize );
	void					Show();
	BOOL					IsVisible() const;
	void					Enable( BOOL bEnable );
	virtual BOOL            Close();

	// DDE-Interface
	virtual long			DdeExecute( const String& rCmd );
	virtual long			DdeGetData( const String& rItem,
										const String& rMimeType,
										::com::sun::star::uno::Any & rValue );
	virtual long			DdeSetData( const String& rItem,
										const String& rMimeType,
								const ::com::sun::star::uno::Any & rValue );
	virtual ::so3::SvLinkSource* DdeCreateLinkSource( const String& rItem );

	virtual void            ShowStatusText( const String& rText ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void            ShowStatusText( const String& rText );
	virtual void            HideStatusText(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void            HideStatusText();

	virtual String			UpdateTitle();

	// interne Handler
	virtual BOOL            SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual const SvBorder& GetBorderPixelImpl( const SfxViewShell *pSh ) const;
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );

	virtual SfxObjectShell*	GetObjectShell();
	USHORT					GetCurViewId() const;
	SfxFrame*				GetFrame() const;
	SfxViewFrame*			GetTopViewFrame() const;

	BOOL					DoClose();
	ULONG					GetFrameType() const
							{ return GetFrame()->GetFrameType(); }
	SfxCancelManager*		GetCancelManager() const;

    BOOL                    IsInModalMode() const;
    void                    Resize(BOOL bForce=FALSE);

    //void                        SetChildWindow(USHORT nId, BOOL bVisible );
    void                        SetChildWindow(USHORT nId, BOOL bVisible, BOOL bSetFocus=TRUE);
    BOOL                        HasChildWindow(USHORT);
    BOOL                        KnowsChildWindow(USHORT);
    SfxChildWindow*             GetChildWindow(USHORT);
    void                        ChildWindowExecute(SfxRequest&);
    void                        ChildWindowState(SfxItemSet&);

    SfxImageManager*        GetImageManager();

#if _SOLAR__PRIVATE
	void					SetFrame_Impl( SfxFrame* );
	void                    SetDowning_Impl();
	void                    GetDocNumber_Impl();
	BOOL                    IsDowning_Impl() const;
	BOOL                    IsSetViewFrameAllowed_Impl() const;
	void                    SetViewShell_Impl( SfxViewShell *pVSh );
	void                    ReleaseObjectShell_Impl( BOOL bStoreView = FALSE );

	void                    GetState_Impl( SfxItemSet &rSet );
	void                    ExecReload_Impl( SfxRequest &rReq );
	void                    ExecReload_Impl( SfxRequest &rReq, BOOL bAsync );
	void                    StateReload_Impl( SfxItemSet &rSet );
	void                    ExecView_Impl( SfxRequest &rReq );
	void                    StateView_Impl( SfxItemSet &rSet );
	void                    PropState_Impl( SfxItemSet &rSet );
	void                    ExecHistory_Impl( SfxRequest &rReq );
	void                    StateHistory_Impl( SfxItemSet &rSet );
	SfxViewFrame*			GetParentViewFrame_Impl() const;
	BOOL					IsResizeInToOut_Impl() const;
	BOOL					IsAdjustPosSizePixelLocked_Impl() const
							{ return nAdjustPosPixelLock != 0; }
	void					ForceInnerResize_Impl( BOOL bOn );

	void					LockObjectShell_Impl(BOOL bLock=TRUE);

    void                    MakeActive_Impl( BOOL bActivate );
	const Size&				GetMargin_Impl() const;
	SfxViewFrame*			GetActiveChildFrame_Impl() const;
	void					SetRestoreView_Impl( BOOL );
	String					GetActualPresentationURL_Impl() const;
    void                        ToolboxExec_Impl(SfxRequest &);
    void                        ToolboxState_Impl(SfxItemSet &);
    void                        MiscExec_Impl(SfxRequest &);
    void                        MiscState_Impl(SfxItemSet &);
    SfxWorkWindow*          GetWorkWindow_Impl( USHORT nId );
#endif
};

//--------------------------------------------------------------------

class SfxViewFrameItem: public SfxPoolItem
{
	SfxViewFrame*			pFrame;

public:
							SfxViewFrameItem( SfxViewFrame *pViewFrame ):
								SfxPoolItem( 0 ),
								pFrame( pViewFrame)
							{}
							SfxViewFrameItem( USHORT nWhich, SfxViewFrame *pViewFrame ):
								SfxPoolItem( nWhich ),
								pFrame( pViewFrame)
							{}

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual String			GetValueText() const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const{DBG_BF_ASSERT(0, "STRIP"); return NULL;} //STRIP001 virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

	SfxViewFrame*			GetFrame() const
							{ return pFrame; }
};

}//end of namespace binfilter
#endif

