/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_canvascustomsprite.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:25:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_CANVASCUSTOMSPRITE_HXX
#define _DXCANVAS_CANVASCUSTOMSPRITE_HXX

#ifndef _CPPUHELPER_COMPBASE4_HXX_
#include <cppuhelper/compbase4.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#ifndef _COMPHELPER_UNO3_HXX
#include <comphelper/uno3.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_RENDERING_XCUSTOMSPRITE_HPP_
#include <com/sun/star/rendering/XCustomSprite.hpp>
#endif

#ifndef _BGFX_POINT_B2DPOINT_HXX
#include <basegfx/point/b2dpoint.hxx>
#endif
#ifndef _BGFX_VECTOR_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif

#include <bitmapcanvasbase.hxx>
#include <dx_canvashelper.hxx>
#include <dx_windowgraphicdevice.hxx>
#include <dx_spritecanvas.hxx>
#include <dx_sprite.hxx>

#define CANVASCUSTOMSPRITE_IMPLEMENTATION_NAME "DXCanvas::CanvasCustomSprite"

namespace dxcanvas
{
    typedef ::cppu::WeakComponentImplHelper4< ::com::sun::star::rendering::XCustomSprite,
									 		  ::com::sun::star::rendering::XBitmapCanvas,
											  ::com::sun::star::rendering::XIntegerBitmap,
                         			 		  ::com::sun::star::lang::XServiceInfo >  			CanvasCustomSpriteBase_Base;
    typedef ::canvas::internal::BitmapCanvasBase< CanvasCustomSpriteBase_Base, CanvasHelper > 	CanvasCustomSprite_Base;

	/* Definition of CanvasCustomSprite class */

    class CanvasCustomSprite : public Sprite,
                               public CanvasCustomSprite_Base
    {
    public:
        /** Create a custom sprite

			@param rSpriteSize
            Size of the sprite in pixel

            @param rRefDevice
            Associated output device

            @param rSpriteCanvas
            Target canvas

            @param rDevice
            Target DX device
         */
        CanvasCustomSprite( const ::com::sun::star::geometry::RealSize2D& 	rSpriteSize,
                            const WindowGraphicDevice::ImplRef&						rRefDevice,
                            const SpriteCanvas::ImplRef&							rSpriteCanvas,
                            const DeviceSharedPtr&									rDevice );

		// XInterface

        // Need to implement that, because Sprite comes with an
        // unimplemented version of XInterface.

        // Forwarding the XInterface implementation to the
        // cppu::ImplHelper templated base, which does the refcounting and
        // queryInterface for us:  Classname     Base doing refcount and handling queryInterface
        //                             |                 |
        //                             V                 V
        DECLARE_UNO3_AGG_DEFAULTS( CanvasCustomSprite, CanvasCustomSpriteBase_Base );

        // this function is called upon disposing the component
        virtual void SAL_CALL disposing();

        // XSprite
        virtual void SAL_CALL setAlpha( double alpha ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL move( const ::com::sun::star::geometry::RealPoint2D& aNewPos, const ::com::sun::star::rendering::ViewState& viewState, const ::com::sun::star::rendering::RenderState& renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL transform( const ::com::sun::star::geometry::AffineMatrix2D& aTransformation ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL clip( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& aClip ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL setPriority( double nPriority ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL show(  ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL hide(  ) throw (::com::sun::star::uno::RuntimeException);

        // XCustomSprite
        virtual ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCanvas > SAL_CALL 
        	getContentCanvas(  ) throw (::com::sun::star::uno::RuntimeException);

        // XServiceInfo
        virtual ::rtl::OUString SAL_CALL getImplementationName() throw( ::com::sun::star::uno::RuntimeException );
        virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw( ::com::sun::star::uno::RuntimeException );
        virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames()  throw( ::com::sun::star::uno::RuntimeException );

        // Sprite
        virtual void redraw( const DeviceSharedPtr& 	rTarget ) const;
        virtual void redraw( const DeviceSharedPtr& 	rTarget, 
                             const ::basegfx::B2DPoint& rOutputPosition ) const;
        virtual ::basegfx::B2DPoint getPos() const;
        virtual ::basegfx::B2DSize 	getSize() const;

    protected:
        ~CanvasCustomSprite(); // we're a ref-counted UNO class. _We_ destroy ourselves.

    private:
        // default: disabled copy/assignment
        CanvasCustomSprite(const CanvasCustomSprite&);
        CanvasCustomSprite& operator=( const CanvasCustomSprite& );

        /// Internal! Only call with locked object mutex!
        ::basegfx::B2DRectangle getSpriteRect() const;

        WindowGraphicDevice::ImplRef								mxRefDevice;
        SpriteCanvas::ImplRef										mpSpriteCanvas;

        BitmapSharedPtr												mpBitmap;
        DeviceSharedPtr												mpDXDevice;
        mutable TextureSharedPtr									mpDXTexture;

        const ::basegfx::B2ISize									maOutputOffset;			// offset sprite on screen by this amount
        const ::basegfx::B2ISize									maOriginalSize;			// as given at the constructor
        const ::basegfx::B2ISize									maSize;					// actual size, also including AA border	

        // sprite state
        ::basegfx::B2DPoint											maPosition;
        ::com::sun::star::uno::Reference< 
              ::com::sun::star::rendering::XPolyPolygon2D >	mxClipPoly;
        double														mfAlpha;
        bool														mbActive;

        mutable bool												mbClipDirty;

        /** Texture-based clip optimization.

        	When true, this flag denotes that the current mpBitmap
        	content is fully opaque, thus, that changes to the clip
        	need not take the original alpha channel into account.
         */
        mutable bool												mbIsContentFullyOpaque;
    };
}

#endif /* _DXCANVAS_CANVASCUSTOMSPRITE_HXX */
