/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_plainsurface.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:29:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <dx_plainsurface.hxx>

namespace dxcanvas
{
	/* Implementation of Dx_Surface class */

    PlainSurface::PlainSurface( const COMReference<IDirectDrawSurface>& 	rDDSurface,
                                const ::basegfx::B2ISize&					rSize ) :
        mpSurface( rDDSurface ),
        maSize( rSize )
    {
    }
    
    PlainSurface::~PlainSurface()
    {
    }

    SurfaceGraphicsSharedPtr PlainSurface::getGraphics()
    {
        return SurfaceGraphicsSharedPtr( new SurfaceGraphics( mpSurface ) );
    }
    
    bool PlainSurface::contentLost() const
    {
        if( mpSurface.is() )
            return const_cast<PlainSurface*>(this)->mpSurface->IsLost() == DDERR_SURFACELOST;

        // TODO(F1): Somehow, try to handle the case 'desktop resolution
        // change' in windowed mode. We then have to recreate all
        // surfaces

        return false;
    }

}
