/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: task.cxx,v $
 *
 *  $Revision: 1.26 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:46:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_TASK_HXX_
#include <services/task.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TARGETFINDER_HXX_
#include <classes/targetfinder.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif
//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_MOZILLA_XPLUGININSTANCE_HPP_
#include <com/sun/star/mozilla/XPluginInstance.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#include <svtools/moduleoptions.hxx>
#include <vcl/syswin.hxx>
#include <vcl/svapp.hxx>
#include <toolkit/helper/vclunohelper.hxx>

//#include <services/documentlist.hxx>
//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//using namespace ::com::sun::star::awt                       ;
using namespace ::com::sun::star::beans						;
using namespace ::com::sun::star::container					;
using namespace ::com::sun::star::frame						;
using namespace ::com::sun::star::lang						;
using namespace ::com::sun::star::task						;
using namespace ::com::sun::star::uno						;
using namespace ::com::sun::star::util						;
using namespace ::cppu										;
using namespace ::osl										;
using namespace ::rtl										;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

#define	PROPERTYNAME_ISALWAYSVISIBLE			OUString(RTL_CONSTASCII_USTRINGPARAM("IsAlwaysVisible"	))
#define	PROPERTYNAME_ISFLOATING					OUString(RTL_CONSTASCII_USTRINGPARAM("IsFloating"		))
#define	PROPERTYNAME_ISPLUGIN					OUString(RTL_CONSTASCII_USTRINGPARAM("IsPlugIn"			))
#define	PROPERTYNAME_POSITION					OUString(RTL_CONSTASCII_USTRINGPARAM("Position"			))
#define	PROPERTYNAME_SIZE						OUString(RTL_CONSTASCII_USTRINGPARAM("Size"				))
#define	PROPERTYNAME_TITLE						OUString(RTL_CONSTASCII_USTRINGPARAM("Title"			))

#define PROPERTYHANDLE_ISALWAYSVISIBLE			1
#define PROPERTYHANDLE_ISFLOATING				2
#define PROPERTYHANDLE_ISPLUGIN					3
#define PROPERTYHANDLE_POSITION					4
#define PROPERTYHANDLE_SIZE						5
#define PROPERTYHANDLE_TITLE					6

#define	PROPERTYCOUNT							6

#define	DEFAULT_BISALWAYSVISIBLE				sal_False
#define	DEFAULT_BISFLOATING						sal_False
#define	DEFAULT_BISPLUGIN						sal_False
#define DEFAULT_APOSITION                       css::awt::Point(0,0)
#define DEFAULT_ASIZE                           css::awt::Size(0,0)
#define	DEFAULT_STITLE							OUString()

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
//        ,   OBroadcastHelper        ( ((ThreadHelpBase*)this)->m_aMutex                                                       )
//        ,   OPropertySetHelper      ( *SAL_STATIC_CAST( OBroadcastHelper *, this )  )
Task::Task( const Reference< XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
		//	Attention:
		//		Don't change order of initialization!
		//      tIMPLMutexContainer is a struct with a mutex as member. We can't use a mutex as member, while
		//		we must garant right initialization and a valid value of this! First initialize
		//		baseclasses and then members. And we need the mutex for other baseclasses !!!
		:	Frame					( xFactory																				)
		// Init member
		,	m_bIsAlwaysVisible		( DEFAULT_BISALWAYSVISIBLE																)
		,	m_bIsFloating			( DEFAULT_BISFLOATING																	)
//        ,   m_bIsPlugIn             ( DEFAULT_BISPLUGIN                                                                     )
		,	m_aPosition				( DEFAULT_APOSITION																		)
		,	m_aSize					( DEFAULT_ASIZE																			)
//        ,   m_sTitle                ( DEFAULT_STITLE                                                                        )
        ,   m_aPoster               ( LINK( this, Task, Close_Impl )                                                        )
{
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
Task::~Task()
{
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_4						(	Task								,
											Frame								,
											DIRECT_INTERFACE(XTask				),
											DIRECT_INTERFACE(XPropertySet		),
											DIRECT_INTERFACE(XFastPropertySet	),
											DIRECT_INTERFACE(XMultiPropertySet	)
										)

DEFINE_XTYPEPROVIDER_3_WITH_BASECLASS   (   Task                ,
											Frame				,
											XPropertySet		,
											XFastPropertySet	,
											XMultiPropertySet
										)

DEFINE_XSERVICEINFO_MULTISERVICE		(	Task					,
                                            ::cppu::OWeakObject     ,
											SERVICENAME_TASK		,
											IMPLEMENTATIONNAME_TASK
										)

DEFINE_INIT_SERVICE_WITH_BASECLASS( Task, Frame,
    {
    }
)

//*****************************************************************************************************************
//	XTask
//*****************************************************************************************************************
sal_Bool SAL_CALL Task::close() throw( RuntimeException )
{
    LOG_WARNING("Task::close()", "obsolete")

    sal_Bool bCanClose = sal_False;
    try
    {
        Frame::close(sal_True);
        bCanClose = sal_True;
    }
    catch( css::util::CloseVetoException& )
    {
        bCanClose = sal_False;
    }

    return bCanClose;

    /*
    Reference < XTask > xThis( this );

    // Set default result of this question to NO ...
    // and look for current running proccesses by using this task!
	sal_Bool bIAmClosed = sal_False;
    sal_Bool bCanClose  = (Frame::isActionLocked()==sal_False);

    LOG_ASSERT2( bCanClose==sal_False, "Task::close()", "Lock problem detected!" )

    // If no proccesses could be detected ... ask controller for his agreement.
    Reference< XController > xController = getController();
    if(
        ( bCanClose        == sal_True )    &&
        ( xController.is() == sal_True )
      )
	{
		bCanClose = xController->suspend( sal_True );
        if ( bCanClose )
            Frame.implts_saveWindowAttributes();
	}

    // If closing is allowed ... dispose these task!
    if( bCanClose == sal_True )
	{
		dispose();
		bIAmClosed = sal_True;
	}

	return bIAmClosed;
    */
}

//*****************************************************************************************************************
//	XTask
//*****************************************************************************************************************
void SAL_CALL Task::tileWindows() throw( RuntimeException )
{
}

//*****************************************************************************************************************
//	XTask
//*****************************************************************************************************************
void SAL_CALL Task::arrangeWindowsVertical() throw( RuntimeException )
{
}

//*****************************************************************************************************************
//	XTask
//*****************************************************************************************************************
void SAL_CALL Task::arrangeWindowsHorizontal() throw( RuntimeException )
{
}
/*
//*****************************************************************************************************************
//	 XFrame
//*****************************************************************************************************************
Reference< XFrame > SAL_CALL Task::findFrame(	const	OUString&	sTargetFrameName	,
														sal_Int32	nSearchFlags		) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	//LOG_ASSERT( impldbg_checkParameter_findFrame( sTargetFrameName, nSearchFlags ), "Task::findFrame()\nInvalid parameter detected.\n" )

	// Set default return value if method failed.
	Reference< XFrame > xSearchedFrame;

		LOG_PARAMETER_FINDFRAME( "Task", m_sName, sTargetFrameName, nSearchFlags )

		// Use helper to classify search direction.
        css::uno::Reference< css::frame::XFrame > xParent( impl_getParent(), css::uno::UNO_QUERY );
        TargetInfo   aInfo   ( sTargetFrameName, nSearchFlags, E_TASK, m_aChildFrameContainer.hasElements(), xParent.is(), impl_getName(), ::rtl::OUString() );
        ETargetClass eResult = TargetFinder::classifyFindFrame( aInfo );
		switch( eResult )
		{
			case E_SELF			:	{
										xSearchedFrame = Reference< XFrame >( static_cast< OWeakObject* >( this ), UNO_QUERY );
									}
									break;
			case E_BEAMER		:	{
											Creation not supported yet!
											Wait for new layout manager service.
											But we can find it if he alrady exist ... created by special mode of our sfx ...
											see ODispatchProvider for further informations
										xSearchedFrame = m_aChildFrameContainer.searchDirectChildren( SPECIALTARGET_BEAMER );
										//if( xSearchedFrame.is() == sal_False )
										//{
										//	xSearchedFrame = ...
										//}
									}
									break;
			case E_FORWARD_UP	:	{
										xSearchedFrame = xParent->findFrame( sTargetFrameName, nSearchFlags );
									}
									break;
			case E_DEEP_DOWN	:	{
										xSearchedFrame = m_aChildFrameContainer.searchDeepDown( sTargetFrameName );
									}
									break;
			case E_FLAT_DOWN	:	{
										xSearchedFrame = m_aChildFrameContainer.searchFlatDown( sTargetFrameName );
									}
									break;
			case E_DEEP_BOTH	:	{
										xSearchedFrame = m_aChildFrameContainer.searchDeepDown( sTargetFrameName );
										if( xSearchedFrame.is() == sal_False )
										{
											xSearchedFrame = xParent->findFrame( sTargetFrameName, nSearchFlags );
										}
									}
									break;
			case E_FLAT_BOTH	:	{
										xSearchedFrame = m_aChildFrameContainer.searchFlatDown( sTargetFrameName );
										if( xSearchedFrame.is() == sal_False )
										{
											xSearchedFrame = xParent->findFrame( sTargetFrameName, nSearchFlags );
										}
									}
									break;
        #ifdef ENABLE_WARNINGS
        default                 :   {
                                        if( eResult != E_UNKNOWN )
                                        {
                                            LOG_ERROR( "Task::findFrame()", "Unexpected result of TargetFinder::classify() detected!" )
                                        }
                                    }
                                    break;
        #endif
		}
        LOG_RESULT_FINDFRAME( "Task", impl_getName(), xSearchedFrame )

	// Return result of operation.
	return xSearchedFrame;
}
*/
/*
//*****************************************************************************************************************
//	 XTopWindowListener
//*****************************************************************************************************************
void SAL_CALL Task::windowClosing( const EventObject& aEvent ) throw( RuntimeException )
{
	deactivate();
    m_aPoster.Post( 0 );
}

IMPL_LINK( Task, Close_Impl, void*, pVoid )
{
//    ModifiedDocumentsWindow* pWnd = ModifiedDocumentsWindow::Get();
//    pWnd->CheckForAdding( Reference < XFrame > ( (XTask*) this, UNO_QUERY ) );
    close();
    return 0;
}

//*****************************************************************************************************************
//	 XTopWindowListener
//*****************************************************************************************************************
void SAL_CALL Task::windowActivated( const EventObject& aEvent ) throw( RuntimeException )
{
    Frame::windowActivated( aEvent );
}

//*****************************************************************************************************************
//	 XTopWindowListener
//*****************************************************************************************************************
void SAL_CALL Task::windowDeactivated( const EventObject& aEvent ) throw( RuntimeException )
{
    // always one task must be active
    // transferring focus outside the task windows must not deactivate the task
    // so this event will never be evaluated
    Frame::windowDeactivated( aEvent );
}
//*****************************************************************************************************************
//	 XEventListener
//*****************************************************************************************************************
void SAL_CALL Task::disposing( const EventObject& aEvent ) throw( RuntimeException )
{
	// Reset ouer member to default values.
	m_bIsAlwaysVisible	=	DEFAULT_BISALWAYSVISIBLE;
	m_bIsFloating		=	DEFAULT_BISFLOATING		;
//    m_bIsPlugIn         =   DEFAULT_BISPLUGIN       ;
	m_aPosition			=	DEFAULT_APOSITION		;
	m_aSize				=	DEFAULT_ASIZE			;

	// Don't forget to call baseclass!
	Frame::disposing( aEvent );

}
*/

/*
//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
sal_Bool SAL_CALL Task::convertFastPropertyValue(			Any&		aConvertedValue	,
				  											Any&		aOldValue		,
															sal_Int32	nHandle			,
													const	Any&		aValue			) throw( IllegalArgumentException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	//	Safe impossible cases
//	LOG_ASSERT ( impl_debug_checkParameter ( rConvertedValue, rOldValue, nHandle, rValue ), "Task::convertFastPropertyValue()\nInvalid parameter detected.\n" )

	//	Check, if value of property will changed in method "setFastPropertyValue_NoBroadcast()".
	//	Return TRUE, if changed - else return FALSE.
	//	Attention:
	//		Method "impl_tryToChangeProperty()" can throw the IllegalArgumentException !!!

	//	Initialize state with FALSE !!!
	//	(Handle can be invalid)
	sal_Bool bReturn = sal_False;

	switch ( nHandle )
	{
		case PROPERTYHANDLE_ISPLUGIN			:
		case PROPERTYHANDLE_TITLE				:	bReturn = sal_False; // These variables are readonly(!) and can't change.
													break;
		case PROPERTYHANDLE_ISALWAYSVISIBLE		:	bReturn = impl_tryToChangeProperty( m_bIsAlwaysVisible	, aValue, aOldValue, aConvertedValue );
													break;
		case PROPERTYHANDLE_ISFLOATING	   		:	bReturn = impl_tryToChangeProperty( m_bIsFloating		, aValue, aOldValue, aConvertedValue );
													break;
		case PROPERTYHANDLE_POSITION			:	bReturn = impl_tryToChangeProperty( m_aPosition			, aValue, aOldValue, aConvertedValue );
													break;
		case PROPERTYHANDLE_SIZE				:	bReturn = impl_tryToChangeProperty( m_aSize				, aValue, aOldValue, aConvertedValue );
													break;
	}

	// Return state of operation.
	return bReturn ;
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
void SAL_CALL Task::setFastPropertyValue_NoBroadcast(			sal_Int32	nHandle	,
			  											const	Any&		aValue	) throw( Exception )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	//	Safe impossible cases
	//	OprpertySetHelper say	: "Handle and type of any value are valid at everyway!".
	//	But I say				: "It's better to control this."
//	LOG_ASSERT ( impl_debug_checkParameter ( nHandle, rValue ), "Task::setFastPropertyValue_NoBroadcast()\nInvalid parameter detected.\n" )

	// Search for right handle ... and try to set property value.
	switch ( nHandle )
	{
		case PROPERTYHANDLE_ISPLUGIN			:	//TODO: We can use XVCLWindowPeer and our container window with setProperty("Text") do support TITLE!
		case PROPERTYHANDLE_TITLE				:	LOG_ASSERT( sal_False, "Task::setFastPropertyValue_NoBroadcast()\nSet of readonly property not allowed.\n" )
													break;
		case PROPERTYHANDLE_ISALWAYSVISIBLE		:	aValue >>= m_bIsAlwaysVisible	;
													break;
		case PROPERTYHANDLE_ISFLOATING	   		:	aValue >>= m_bIsFloating		;
													break;
		case PROPERTYHANDLE_POSITION			:	aValue >>= m_aPosition			;
													break;
		case PROPERTYHANDLE_SIZE				:	aValue >>= m_aSize				;
													break;
	}
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
void SAL_CALL Task::getFastPropertyValue(	Any&		aValue	,
			  								sal_Int32	nHandle ) const
{
	// Ready for multithreading
	LOCK_GLOBALMUTEX( aGuard, "Task::getFastPropertyValue()" )

	//	Safe impossible cases
	//	OprpertySetHelper say	: "Handle and type of any value are valid at everyway!".
	//	But I say				: "It's better to control this."
//	LOG_ASSERT ( impl_debug_checkParameter ( nHandle, rValue ), "Task::setFastPropertyValue_NoBroadcast()\nInvalid parameter detected.\n" )

	// Search for right handle ... and try to set property value.
	switch ( nHandle )
	{
		case PROPERTYHANDLE_ISALWAYSVISIBLE		:	aValue <<= m_bIsAlwaysVisible	;
													break;
		case PROPERTYHANDLE_ISFLOATING	   		:	aValue <<= m_bIsFloating		;
													break;
		case PROPERTYHANDLE_ISPLUGIN			:	aValue <<= m_bIsPlugIn			;
													break;
		case PROPERTYHANDLE_POSITION			:	aValue <<= m_aPosition			;
													break;
		case PROPERTYHANDLE_SIZE				:	aValue <<= m_aSize				;
													break;
		case PROPERTYHANDLE_TITLE				:	aValue <<= m_sTitle				;
													break;
	}
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
IPropertyArrayHelper& SAL_CALL Task::getInfoHelper()
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfoHelper is NULL - for the second call pInfoHelper is different from NULL!
	static OPropertyArrayHelper* pInfoHelper = NULL;

	if ( pInfoHelper == NULL )
	{
		// Ready for multithreading
		LOCK_GLOBALMUTEX( aGuard, "Task::getInfoHelper()" )
		// Control this pointer again, another instance can be faster then these!
		if ( pInfoHelper == NULL )
		{
			// Define static member to give structure of properties to baseclass "OPropertySetHelper".
			// "impl_getStaticPropertyDescriptor" is a non exported and static funtion, who will define a static propertytable.
			// "sal_True" say: Table is sorted by name.
			static OPropertyArrayHelper aInfoHelper( impl_getStaticPropertyDescriptor(), sal_True );
			pInfoHelper = &aInfoHelper;
		}
	}

	return (*pInfoHelper);
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
Reference< XPropertySetInfo > SAL_CALL Task::getPropertySetInfo ()
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfo is NULL - for the second call pInfo is different from NULL!
	static Reference< XPropertySetInfo >* pInfo = NULL ;

	if ( pInfo == NULL )
	{
		// Ready for multithreading
		LOCK_GLOBALMUTEX( aGuard, "Task::getPropertySetInfo()" )
		// Control this pointer again, another instance can be faster then these!
		if ( pInfo == NULL )
		{
			// Create structure of propertysetinfo for baseclass "OPropertySetHelper".
			// (Use method "getInfoHelper()".)
			static Reference< XPropertySetInfo > xInfo( createPropertySetInfo( getInfoHelper() ) );
			pInfo = &xInfo;
		}
	}

	return (*pInfo);
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool Task::impl_tryToChangeProperty(			sal_Bool	bProperty		,
											const	Any&		aValue			,
													Any&		aOldValue		,
													Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_Bool bNewValue;
	convertPropertyValue( bNewValue, aValue );

	// If value change ...
	if ( bNewValue != bProperty )
	{
		// ... set information of change.
		// Attention:	Use setValue and getCppuBooleanType to set value in any!
		//				It's necessary, if BOOL can be int or char.
		aOldValue.setValue		( &bProperty, ::getCppuBooleanType() );
		aConvertedValue.setValue( &bNewValue, ::getCppuBooleanType() );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool Task::impl_tryToChangeProperty(	const	OUString&	sProperty		,
											const	Any&		aValue			,
													Any&		aOldValue		,
													Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	OUString sNewValue;
	convertPropertyValue( sNewValue, aValue );

	// If value change ...
	if ( sNewValue != sProperty )
	{
		// ... set information of change.
		aOldValue.setValue		( &sProperty, ::getCppuType((const OUString*)NULL) );
		aConvertedValue.setValue( &sNewValue, ::getCppuType((const OUString*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool Task::impl_tryToChangeProperty(	const	Point&		aProperty		,
											const	Any&		aValue			,
													Any&		aOldValue		,
													Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	Point aNewValue;
	convertPropertyValue( aNewValue, aValue );

	// If value change ...
	if	(
			( aNewValue.X	!=	aProperty.X	)	||
			( aNewValue.Y	!=	aProperty.Y	)
		)
	{
		// ... set information of change.
		aOldValue.setValue		( &aProperty, ::getCppuType((const Point*)NULL) );
		aConvertedValue.setValue( &aNewValue, ::getCppuType((const Point*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool Task::impl_tryToChangeProperty(	const	Size&		aProperty		,
											const	Any&		aValue			,
													Any&		aOldValue		,
													Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	Size aNewValue;
	convertPropertyValue( aNewValue, aValue );

	// If value change ...
	if	(
			( aNewValue.Width	!=	aProperty.Width		)	||
			( aNewValue.Height	!=	aProperty.Height	)
		)
	{
		// ... set information of change.
		aOldValue.setValue		( &aProperty, ::getCppuType((const Size*)NULL) );
		aConvertedValue.setValue( &aNewValue, ::getCppuType((const Size*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
const Sequence< Property > Task::impl_getStaticPropertyDescriptor()
{
	// Create a new static property array to initialize sequence!
	// Table of all predefined properties of this class. Its used from OPropertySetHelper-class!
	// Don't forget to change the defines (see begin of this file), if you add, change or delete a property in this list!!!
	// It's necessary for methods of OPropertySetHelper.
	// ATTENTION:
	//		YOU MUST SORT FOLLOW TABLE BY NAME !!!

	static const Property pPropertys[] =
	{
		Property( PROPERTYNAME_ISALWAYSVISIBLE	, PROPERTYHANDLE_ISALWAYSVISIBLE, ::getBooleanCppuType()				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_ISFLOATING		, PROPERTYHANDLE_ISFLOATING		, ::getBooleanCppuType()				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_ISPLUGIN			, PROPERTYHANDLE_ISPLUGIN		, ::getBooleanCppuType()				, PropertyAttribute::TRANSIENT | PropertyAttribute::READONLY	),
		Property( PROPERTYNAME_POSITION			, PROPERTYHANDLE_POSITION		, ::getCppuType((const Point*	)NULL)	, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_SIZE				, PROPERTYHANDLE_SIZE			, ::getCppuType((const Size*	)NULL)	, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_TITLE			, PROPERTYHANDLE_TITLE			, ::getCppuType((const OUString*)NULL)	, PropertyAttribute::TRANSIENT									),
	};
	// Use it to initialize sequence!
	static const Sequence< Property > seqPropertyDescriptor( pPropertys, PROPERTYCOUNT );
	// Return static "PropertyDescriptor"
	return seqPropertyDescriptor ;
}
*/
//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS
/*
//*****************************************************************************************************************
sal_Bool Task::impldbg_checkParameter_append( const Reference< XTask >& xTask )
{
	// Set default return value.
	sal_Bool bOK = sal_True;

	// Check parameter.
	if	(
			( &xTask		==	NULL		)	||
			( xTask.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}

	// Return result of check.
	return bOK ;
}
*/
#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
