/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: excrecds.cxx,v $
 *
 *  $Revision: 1.79 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:56:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#include "excrecds.hxx"

#include <map>

#ifndef INCLUDED_SVX_COUNTRYID_HXX
#include <svx/countryid.hxx>
#endif

#include "scitems.hxx"
#include <svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <sfx2/objsh.hxx>

#include <svx/editdata.hxx>
#include <svx/editeng.hxx>
#include <svx/editobj.hxx>
#include <svx/editstat.hxx>

#include <svx/flditem.hxx>
#include <svx/flstitem.hxx>

#include <svx/algitem.hxx>
#include <svx/boxitem.hxx>
#include <svx/brshitem.hxx>
#include <svx/pageitem.hxx>
#include <svx/paperinf.hxx>
#include <svx/sizeitem.hxx>
#include <svx/ulspitem.hxx>
#include <svx/fhgtitem.hxx>
#ifndef _SVX_ESCPITEM_HXX
#include <svx/escpitem.hxx>
#endif
#include <svtools/intitem.hxx>
#include <svtools/zforlist.hxx>
#include <svtools/zformat.hxx>
#include <svtools/ctrltool.hxx>

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#include <string.h>

#include "global.hxx"
#include "globstr.hrc"
#include "docpool.hxx"
#include "patattr.hxx"
#include "cell.hxx"
#include "document.hxx"
#include "scextopt.hxx"
#include "patattr.hxx"
#include "attrib.hxx"
#include "progress.hxx"
#include "dociter.hxx"
#include "rangenam.hxx"
#include "dbcolect.hxx"
#include "stlsheet.hxx"
#include "stlpool.hxx"
#include "editutil.hxx"
#include "errorcodes.hxx"

#include "excdoc.hxx"

#ifndef SC_XEFORMULA_HXX
#include "xeformula.hxx"
#endif
#ifndef SC_XELINK_HXX
#include "xelink.hxx"
#endif
#ifndef SC_XENAME_HXX
#include "xename.hxx"
#endif
#ifndef SC_XECONTENT_HXX
#include "xecontent.hxx"
#endif

#include "xcl97rec.hxx"



//--------------------------------------------------------- class ExcDummy_00 -
const BYTE		ExcDummy_00::pMyData[] = {
	0xe1, 0x00, 0x00, 0x00,									// INTERFACEHDR
	0xc1, 0x00, 0x02, 0x00, 0x00, 0x00,						// MMS
	0xbf, 0x00, 0x00, 0x00,									// TOOLBARHDR
	0xc0, 0x00, 0x00, 0x00,									// TOOLBAREND
	0xe2, 0x00, 0x00, 0x00,									// INTERFACEEND
	0x5c, 0x00, 0x20, 0x00, 0x04, 0x4d, 0x72, 0x20, 0x58,	// WRITEACCESS
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x42, 0x00, 0x02, 0x00, 0xe4, 0x04,						// CODEPAGE
	0x9c, 0x00, 0x02, 0x00, 0x0e, 0x00						// FNGROUPCOUNT
};
const ULONG ExcDummy_00::nMyLen = sizeof( ExcDummy_00::pMyData );

//-------------------------------------------------------- class ExcDummy_04x -
const BYTE		ExcDummy_040::pMyData[] = {
	0x40, 0x00, 0x02, 0x00, 0x00, 0x00,						// BACKUP
	0x8d, 0x00, 0x02, 0x00, 0x00, 0x00,						// HIDEOBJ
};
const ULONG ExcDummy_040::nMyLen = sizeof( ExcDummy_040::pMyData );

const BYTE		ExcDummy_041::pMyData[] = {
	0x0e, 0x00, 0x02, 0x00, 0x01, 0x00,						// PRECISION
	0xda, 0x00, 0x02, 0x00, 0x00, 0x00						// BOOKBOOL
};
const ULONG ExcDummy_041::nMyLen = sizeof( ExcDummy_041::pMyData );

//-------------------------------------------------------- class ExcDummy_02a -
const BYTE      ExcDummy_02a::pMyData[] = {
	0x0d, 0x00, 0x02, 0x00, 0x01, 0x00,						// CALCMODE
	0x0c, 0x00, 0x02, 0x00, 0x64, 0x00,						// CALCCOUNT
	0x0f, 0x00, 0x02, 0x00, 0x01, 0x00,						// REFMODE
	0x11, 0x00, 0x02, 0x00, 0x00, 0x00,						// ITERATION
	0x10, 0x00, 0x08, 0x00, 0xfc, 0xa9, 0xf1, 0xd2, 0x4d,	// DELTA
	0x62, 0x50, 0x3f,
    0x5f, 0x00, 0x02, 0x00, 0x01, 0x00                      // SAVERECALC
};
const ULONG ExcDummy_02a::nMyLen = sizeof( ExcDummy_02a::pMyData );

//----------------------------------------------------------- class ExcRecord -

void ExcRecord::Save( XclExpStream& rStrm )
{
    SetRecId( GetNum() );
    SetRecSize( GetLen() );
    XclExpRecord::Save( rStrm );
}

void ExcRecord::SaveCont( XclExpStream& rStrm )
{
}

void ExcRecord::WriteBody( XclExpStream& rStrm )
{
    SaveCont( rStrm );
}


//--------------------------------------------------------- class ExcEmptyRec -

void ExcEmptyRec::Save( XclExpStream& rStrm )
{
}


UINT16 ExcEmptyRec::GetNum() const
{
	return 0;
}


ULONG ExcEmptyRec::GetLen() const
{
	return 0;
}



//------------------------------------------------------- class ExcRecordList -

ExcRecordList::~ExcRecordList()
{
	for( ExcRecord* pRec = First(); pRec; pRec = Next() )
		delete pRec;
}


void ExcRecordList::Save( XclExpStream& rStrm )
{
	for( ExcRecord* pRec = First(); pRec; pRec = Next() )
		pRec->Save( rStrm );
}



//--------------------------------------------------------- class ExcDummyRec -

void ExcDummyRec::Save( XclExpStream& rStrm )
{
	rStrm.Write( GetData(), GetLen() );		// raw write mode
}


UINT16 ExcDummyRec::GetNum( void ) const
{
	return 0x0000;
}



//------------------------------------------------------- class ExcBoolRecord -

ExcBoolRecord::ExcBoolRecord( SfxItemSet* pItemSet, USHORT nWhich, BOOL bDefault )
{
	bVal = pItemSet? ( ( const SfxBoolItem& ) pItemSet->Get( nWhich ) ).GetValue() : bDefault;
}


void ExcBoolRecord::SaveCont( XclExpStream& rStrm )
{
	rStrm << (UINT16)(bVal ? 0x0001 : 0x0000);
}


ULONG ExcBoolRecord::GetLen( void ) const
{
	return 2;
}




//--------------------------------------------------------- class ExcBof_Base -

ExcBof_Base::ExcBof_Base() :
	nRupBuild( 0x096C ),	// copied from Excel
	nRupYear( 0x07C9 )		// copied from Excel
{
}



//-------------------------------------------------------------- class ExcBof -

ExcBof::ExcBof( void )
{
	nDocType = 0x0010;
	nVers = 0x0500;
}


void ExcBof::SaveCont( XclExpStream& rStrm )
{
	rStrm << nVers << nDocType << nRupBuild << nRupYear;
}


UINT16 ExcBof::GetNum( void ) const
{
	return 0x0809;
}


ULONG ExcBof::GetLen( void ) const
{
	return 8;
}



//------------------------------------------------------------- class ExcBofW -

ExcBofW::ExcBofW( void )
{
	nDocType = 0x0005;
	nVers = 0x0500;
}


void ExcBofW::SaveCont( XclExpStream& rStrm )
{
	rStrm << nVers << nDocType << nRupBuild << nRupYear;
}



UINT16 ExcBofW::GetNum( void ) const
{
	return 0x0809;
}



ULONG ExcBofW::GetLen( void ) const
{
	return 8;
}



//-------------------------------------------------------------- class ExcEof -

UINT16 ExcEof::GetNum( void ) const
{
	return 0x000A;
}


ULONG ExcEof::GetLen( void ) const
{
	return 0;
}



//----------------------------------------------------- class ExcFngroupcount -

void ExcFngroupcount::SaveCont( XclExpStream& rStrm )
{
	rStrm << ( UINT16 ) 0x000E;		// copied from Excel
}


UINT16 ExcFngroupcount::GetNum( void ) const
{
	return 0x009C;
}


ULONG ExcFngroupcount::GetLen( void ) const
{
	return 2;
}



//--------------------------------------------------------- class ExcDummy_00 -

ULONG ExcDummy_00::GetLen( void ) const
{
	return nMyLen;
}


const BYTE* ExcDummy_00::GetData( void ) const
{
	return pMyData;
}



//-------------------------------------------------------- class ExcDummy_04x -

ULONG ExcDummy_040::GetLen( void ) const
{
	return nMyLen;
}


const BYTE* ExcDummy_040::GetData( void ) const
{
	return pMyData;
}




ULONG ExcDummy_041::GetLen( void ) const
{
	return nMyLen;
}


const BYTE* ExcDummy_041::GetData( void ) const
{
	return pMyData;
}



//------------------------------------------------------------- class Exc1904 -

Exc1904::Exc1904( ScDocument& rDoc )
{
	Date* pDate = rDoc.GetFormatTable()->GetNullDate();
	bVal = pDate ? (*pDate == Date( 1, 1, 1904 )) : FALSE;
}


UINT16 Exc1904::GetNum( void ) const
{
	return 0x0022;
}



//------------------------------------------------------ class ExcBundlesheet -

ExcBundlesheetBase::ExcBundlesheetBase( RootData& rRootData, SCTAB nTab ) :
    nGrbit( rRootData.pER->GetTabInfo().IsVisibleTab( nTab ) ? 0x0000 : 0x0001 ),
	nOwnPos( STREAM_SEEK_TO_END ),
	nStrPos( STREAM_SEEK_TO_END )
{
}


ExcBundlesheetBase::ExcBundlesheetBase() :
	nGrbit( 0x0000 ),
	nOwnPos( STREAM_SEEK_TO_END ),
	nStrPos( STREAM_SEEK_TO_END )
{
}


void ExcBundlesheetBase::UpdateStreamPos( XclExpStream& rStrm )
{
	rStrm.SetStreamPos( nOwnPos );
	rStrm << nStrPos;
}


UINT16 ExcBundlesheetBase::GetNum( void ) const
{
	return 0x0085;
}




ExcBundlesheet::ExcBundlesheet( RootData& rRootData, SCTAB nTab ) :
	ExcBundlesheetBase( rRootData, nTab )
{
    String sTabName = rRootData.pER->GetTabInfo().GetScTabName( nTab );
	DBG_ASSERT( sTabName.Len() < 256, "ExcBundlesheet::ExcBundlesheet - table name too long" );
    aName = ByteString( sTabName, rRootData.pER->GetCharSet() );
}


void ExcBundlesheet::SaveCont( XclExpStream& rStrm )
{
	nOwnPos = rStrm.GetStreamPos();
	rStrm	<< (UINT32)	0x00000000				// dummy (stream position of the sheet)
			<< nGrbit;
	rStrm.WriteByteString( aName );				// 8 bit length, max 255 chars
}


ULONG ExcBundlesheet::GetLen() const
{
	return 7 + Min( aName.Len(), (xub_StrLen) 255 );
}


//--------------------------------------------------------- class ExcDummy_02 -

ULONG ExcDummy_02a::GetLen( void ) const
{
	return nMyLen;
}

const BYTE* ExcDummy_02a::GetData( void ) const
{
	return pMyData;
}
//--------------------------------------------------------- class ExcDummy_02 -

XclExpCountry::XclExpCountry( const XclExpRoot& rRoot ) :
    XclExpRecord( EXC_ID_COUNTRY, 4 )
{
    /*  #i31530# set document country as UI country too -
        needed for correct behaviour of number formats. */
    mnUICountry = mnDocCountry = static_cast< sal_uInt16 >(
        ::svx::ConvertLanguageToCountry( rRoot.GetDocLanguage() ) );
}

void XclExpCountry::WriteBody( XclExpStream& rStrm )
{
    rStrm << mnUICountry << mnDocCountry;
}

// XclExpWsbool ===============================================================

XclExpWsbool::XclExpWsbool( bool bFitToPages ) :
    XclExpUInt16Record( EXC_ID_WSBOOL, EXC_WSBOOL_DEFAULTFLAGS )
{
    if( bFitToPages )
        SetValue( GetValue() | EXC_WSBOOL_FITTOPAGE );
}


// XclExpWindowProtection ===============================================================

XclExpWindowProtection::XclExpWindowProtection(bool bValue) :
	XclExpBoolRecord(EXC_ID_WINDOWPROTECT,bValue)
{
}

// XclExpDocProtection ===============================================================

XclExpDocProtection::XclExpDocProtection(bool bValue) :
	XclExpBoolRecord(EXC_ID_PROTECT,bValue)
{
}

// ============================================================================

XclExpFiltermode::XclExpFiltermode() :
    XclExpEmptyRecord( EXC_ID_FILTERMODE )
{
}

// ----------------------------------------------------------------------------

XclExpAutofilterinfo::XclExpAutofilterinfo( const ScAddress& rStartPos, SCCOL nScCol ) :
    XclExpUInt16Record( EXC_ID_AUTOFILTERINFO, static_cast< sal_uInt16 >( nScCol ) ),
    maStartPos( rStartPos )
{
}

// ----------------------------------------------------------------------------

ExcFilterCondition::ExcFilterCondition() :
		nType( EXC_AFTYPE_NOTUSED ),
		nOper( EXC_AFOPER_EQUAL ),
		fVal( 0.0 ),
		pText( NULL )
{
}

ExcFilterCondition::~ExcFilterCondition()
{
	if( pText )
		delete pText;
}

ULONG ExcFilterCondition::GetTextBytes() const
{
    return pText ? 1 + pText->GetBufferSize() : 0;
}

void ExcFilterCondition::SetCondition( UINT8 nTp, UINT8 nOp, double fV, String* pT )
{
	nType = nTp;
	nOper = nOp;
	fVal = fV;

    delete pText;
    pText = pT ? new XclExpString( *pT, EXC_STR_8BITLENGTH ) : NULL;
}

void ExcFilterCondition::Save( XclExpStream& rStrm )
{
	rStrm << nType << nOper;
	switch( nType )
	{
		case EXC_AFTYPE_DOUBLE:
			rStrm << fVal;
		break;
		case EXC_AFTYPE_STRING:
			DBG_ASSERT( pText, "ExcFilterCondition::Save() -- pText is NULL!" );
            rStrm << (UINT32)0 << (UINT8) pText->Len() << (UINT16)0 << (UINT8)0;
		break;
		case EXC_AFTYPE_BOOLERR:
			rStrm << (UINT8)0 << (UINT8)((fVal != 0) ? 1 : 0) << (UINT32)0 << (UINT16)0;
		break;
		default:
			rStrm << (UINT32)0 << (UINT32)0;
	}
}

void ExcFilterCondition::SaveText( XclExpStream& rStrm )
{
	if( nType == EXC_AFTYPE_STRING )
	{
		DBG_ASSERT( pText, "ExcFilterCondition::SaveText() -- pText is NULL!" );
        pText->WriteFlagField( rStrm );
		pText->WriteBuffer( rStrm );
	}
}

// ----------------------------------------------------------------------------

XclExpAutofilter::XclExpAutofilter( const XclExpRoot& rRoot, UINT16 nC ) :
    XclExpRecord( EXC_ID_AUTOFILTER, 24 ),
    XclExpRoot( rRoot ),
    nCol( nC ),
    nFlags( 0 )
{
}

BOOL XclExpAutofilter::AddCondition( ScQueryConnect eConn, UINT8 nType, UINT8 nOp,
									double fVal, String* pText, BOOL bSimple )
{
	if( !aCond[ 1 ].IsEmpty() )
		return FALSE;

	UINT16 nInd = aCond[ 0 ].IsEmpty() ? 0 : 1;

	if( nInd == 1 )
		nFlags |= (eConn == SC_OR) ? EXC_AFFLAG_OR : EXC_AFFLAG_AND;
	if( bSimple )
		nFlags |= (nInd == 0) ? EXC_AFFLAG_SIMPLE1 : EXC_AFFLAG_SIMPLE2;

	aCond[ nInd ].SetCondition( nType, nOp, fVal, pText );

    AddRecSize( aCond[ nInd ].GetTextBytes() );

	return TRUE;
}

BOOL XclExpAutofilter::AddEntry( const ScQueryEntry& rEntry )
{
	BOOL	bConflict = FALSE;
	String	sText;

	if( rEntry.pStr )
		sText.Assign( *rEntry.pStr );

    BOOL bLen = sText.Len() > 0;

	// empty/nonempty fields
	if( !bLen && (rEntry.nVal == SC_EMPTYFIELDS) )
		bConflict = !AddCondition( rEntry.eConnect, EXC_AFTYPE_EMPTY, EXC_AFOPER_NONE, 0.0, NULL, TRUE );
	else if( !bLen && (rEntry.nVal == SC_NONEMPTYFIELDS) )
		bConflict = !AddCondition( rEntry.eConnect, EXC_AFTYPE_NOTEMPTY, EXC_AFOPER_NONE, 0.0, NULL, TRUE );
	// other conditions
	else
	{
		double	fVal	= 0.0;
		ULONG	nIndex	= 0;
        BOOL    bIsNum  = bLen ? GetFormatter().IsNumberFormat( sText, nIndex, fVal ) : TRUE;
		String*	pText	= bIsNum ? NULL : &sText;

		// top10 flags
		UINT16 nNewFlags = 0x0000;
		switch( rEntry.eOp )
		{
			case SC_TOPVAL:
				nNewFlags = (EXC_AFFLAG_TOP10 | EXC_AFFLAG_TOP10TOP);
			break;
			case SC_BOTVAL:
				nNewFlags = EXC_AFFLAG_TOP10;
			break;
			case SC_TOPPERC:
				nNewFlags = (EXC_AFFLAG_TOP10 | EXC_AFFLAG_TOP10TOP | EXC_AFFLAG_TOP10PERC);
			break;
			case SC_BOTPERC:
				nNewFlags = (EXC_AFFLAG_TOP10 | EXC_AFFLAG_TOP10PERC);
			break;
		}
        BOOL bNewTop10 = ::get_flag( nNewFlags, EXC_AFFLAG_TOP10 );

		bConflict = HasTop10() && bNewTop10;
		if( !bConflict )
		{
			if( bNewTop10 )
			{
				if( fVal < 0 )		fVal = 0;
				if( fVal >= 501 )	fVal = 500;
				nFlags |= (nNewFlags | (UINT16)(fVal) << 7);
			}
			// normal condition
			else
			{
				UINT8 nType = bIsNum ? EXC_AFTYPE_DOUBLE : EXC_AFTYPE_STRING;
				UINT8 nOper = EXC_AFOPER_NONE;

				switch( rEntry.eOp )
				{
					case SC_EQUAL:			nOper = EXC_AFOPER_EQUAL;			break;
					case SC_LESS:			nOper = EXC_AFOPER_LESS;			break;
					case SC_GREATER:		nOper = EXC_AFOPER_GREATER;			break;
					case SC_LESS_EQUAL:		nOper = EXC_AFOPER_LESSEQUAL;		break;
					case SC_GREATER_EQUAL:	nOper = EXC_AFOPER_GREATEREQUAL;	break;
					case SC_NOT_EQUAL:		nOper = EXC_AFOPER_NOTEQUAL;		break;
				}
				bConflict = !AddCondition( rEntry.eConnect, nType, nOper, fVal, pText );
			}
		}
	}
	return bConflict;
}

void XclExpAutofilter::WriteBody( XclExpStream& rStrm )
{
	rStrm << nCol << nFlags;
	aCond[ 0 ].Save( rStrm );
	aCond[ 1 ].Save( rStrm );
	aCond[ 0 ].SaveText( rStrm );
	aCond[ 1 ].SaveText( rStrm );
}

// ----------------------------------------------------------------------------

ExcAutoFilterRecs::ExcAutoFilterRecs( const XclExpRoot& rRoot, SCTAB nTab ) :
    XclExpRoot( rRoot ),
    pFilterMode( NULL ),
    pFilterInfo( NULL )
{
    ScDBCollection& rDBColl = GetDatabaseRanges();
    XclExpNameManager& rNameMgr = GetNameManager();

	// search for first DB-range with filter
	UINT16		nIndex	= 0;
	BOOL		bFound	= FALSE;
	BOOL		bAdvanced = FALSE;
	ScDBData*	pData	= NULL;
	ScRange		aRange;
	ScRange		aAdvRange;
	while( (nIndex < rDBColl.GetCount()) && !bFound )
	{
		pData = rDBColl[ nIndex ];
		if( pData )
		{
			pData->GetArea( aRange );
			bAdvanced = pData->GetAdvancedQuerySource( aAdvRange );
			bFound = (aRange.aStart.Tab() == nTab) &&
				(pData->HasQueryParam() || pData->HasAutoFilter() || bAdvanced);
		}
		if( !bFound )
			nIndex++;
	}

	if( pData && bFound )
	{
		ScQueryParam	aParam;
		pData->GetQueryParam( aParam );

		ScRange	aRange( aParam.nCol1, aParam.nRow1, aParam.nTab,
						aParam.nCol2, aParam.nRow2, aParam.nTab );
		SCCOL	nColCnt = aParam.nCol2 - aParam.nCol1 + 1;

        // #i2394# #100489# built-in defined names must be sorted by containing sheet name
        rNameMgr.InsertBuiltInName( EXC_BUILTIN_FILTERDATABASE, aRange );

		// advanced filter
		if( bAdvanced )
		{
			// filter criteria, excel allows only same table
			if( aAdvRange.aStart.Tab() == nTab )
                rNameMgr.InsertBuiltInName( EXC_BUILTIN_CRITERIA, aAdvRange );

			// filter destination range, excel allows only same table
			if( !aParam.bInplace )
			{
				ScRange aDestRange( aParam.nDestCol, aParam.nDestRow, aParam.nDestTab );
				aDestRange.aEnd.IncCol( nColCnt - 1 );
				if( aDestRange.aStart.Tab() == nTab )
                    rNameMgr.InsertBuiltInName( EXC_BUILTIN_EXTRACT, aDestRange );
			}

            pFilterMode = new XclExpFiltermode;
		}
		// AutoFilter
		else
		{
			BOOL	bConflict	= FALSE;
			BOOL	bContLoop	= TRUE;
			BOOL	bHasOr		= FALSE;
			SCCOLROW nFirstField = aParam.GetEntry( 0 ).nField;

			// create AUTOFILTER records for filtered columns
			for( SCSIZE nEntry = 0; !bConflict && bContLoop && (nEntry < aParam.GetEntryCount()); nEntry++ )
			{
				const ScQueryEntry& rEntry	= aParam.GetEntry( nEntry );

				bContLoop = rEntry.bDoQuery;
				if( bContLoop )
				{
                    XclExpAutofilter* pFilter = GetByCol( static_cast<SCCOL>(rEntry.nField) - aRange.aStart.Col() );

					if( nEntry > 0 )
						bHasOr |= (rEntry.eConnect == SC_OR);

					bConflict = (nEntry > 1) && bHasOr;
					if( !bConflict )
						bConflict = (nEntry == 1) && (rEntry.eConnect == SC_OR) &&
									(nFirstField != rEntry.nField);
					if( !bConflict )
                        bConflict = pFilter->AddEntry( rEntry );
				}
			}

			// additional tests for conflicts
            for( size_t nPos = 0, nSize = maFilterList.Size(); !bConflict && (nPos < nSize); ++nPos )
            {
                XclExpAutofilterRef xFilter = maFilterList.GetRecord( nPos );
                bConflict = xFilter->HasCondition() && xFilter->HasTop10();
            }

			if( bConflict )
                maFilterList.RemoveAllRecords();

            if( !maFilterList.Empty() )
                pFilterMode = new XclExpFiltermode;
            pFilterInfo = new XclExpAutofilterinfo( aRange.aStart, nColCnt );
		}
	}
}

ExcAutoFilterRecs::~ExcAutoFilterRecs()
{
    delete pFilterMode;
    delete pFilterInfo;
}

XclExpAutofilter* ExcAutoFilterRecs::GetByCol( SCCOL nCol )
{
    XclExpAutofilterRef xFilter;
    for( size_t nPos = 0, nSize = maFilterList.Size(); nPos < nSize; ++nPos )
    {
        xFilter = maFilterList.GetRecord( nPos );
        if( xFilter->GetCol() == static_cast<sal_uInt16>(nCol) )
            return xFilter.get();
    }
    xFilter.reset( new XclExpAutofilter( GetRoot(), static_cast<sal_uInt16>(nCol) ) );
    maFilterList.AppendRecord( xFilter );
    return xFilter.get();
}

BOOL ExcAutoFilterRecs::IsFiltered( SCCOL nCol )
{
    for( size_t nPos = 0, nSize = maFilterList.Size(); nPos < nSize; ++nPos )
        if( maFilterList.GetRecord( nPos )->GetCol() == static_cast<sal_uInt16>(nCol) )
			return TRUE;
	return FALSE;
}

void ExcAutoFilterRecs::AddObjRecs()
{
    if( pFilterInfo )
    {
        ScAddress aAddr( pFilterInfo->GetStartPos() );
        for( SCCOL nObj = 0, nCount = pFilterInfo->GetColCount(); nObj < nCount; nObj++ )
        {
            XclObjDropDown* pObj = new XclObjDropDown( GetRoot(), aAddr, IsFiltered( nObj ) );
            GetOldRoot().pObjRecs->Add( pObj );
            aAddr.IncCol( 1 );
        }
    }
}

void ExcAutoFilterRecs::Save( XclExpStream& rStrm )
{
	if( pFilterMode )
		pFilterMode->Save( rStrm );
	if( pFilterInfo )
		pFilterInfo->Save( rStrm );
    maFilterList.Save( rStrm );
}

// ----------------------------------------------------------------------------

XclExpFilterManager::XclExpFilterManager( const XclExpRoot& rRoot ) :
    XclExpRoot( rRoot )
{
}

void XclExpFilterManager::InitTabFilter( SCTAB nScTab )
{
    maFilterMap[ nScTab ].reset( new ExcAutoFilterRecs( GetRoot(), nScTab ) );
}

XclExpRecordRef XclExpFilterManager::CreateRecord( SCTAB nScTab )
{
    XclExpTabFilterRef xRec;
    XclExpTabFilterMap::iterator aIt = maFilterMap.find( nScTab );
    if( aIt != maFilterMap.end() )
    {
        xRec = aIt->second;
        xRec->AddObjRecs();
    }
    return xRec;
}

// ============================================================================

