/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: beanfrm.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:55:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_BEANFRM_HXX
#define _SFX_BEANFRM_HXX

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HPP_
#include <com/sun/star/loader/XImplementationLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HPP_
#include <com/sun/star/loader/CannotActivateFactoryException.hpp>
#endif
#include <vcl/wrkwin.hxx>
#include "viewfrm.hxx"
#include "frame.hxx"

class SfxJavaBeanWorkWindow : public WorkWindow
{
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > 				xFrame;
public:
							SfxJavaBeanWorkWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > & rFrame, WinBits nWinStyle = 0 );
	virtual sal_Bool 			Close();
};

class SfxExternalTopFrame_Impl;
class SfxExternalTopFrame: public SfxFrame
{
	SfxExternalTopFrame_Impl*	pImp;
	Window*						pWindow;

public:

	TYPEINFO();
							SfxExternalTopFrame( Window *pExternal=0 );
	virtual 				~SfxExternalTopFrame();

	virtual Window&			GetWindow() const;
	virtual sal_Bool			Close();
	virtual	sal_Bool			InsertDocument( SfxObjectShell *pDoc );
};

#if _SOLAR__PRIVATE

class SfxExternalViewFrameWindow_Impl;
class SfxExternalTopViewFrame_Impl : public SfxViewFrame
{
	sal_Bool					bActive;
	SfxExternalViewFrameWindow_Impl *pImp;

protected:

	virtual void            Activate( sal_Bool bUI );
	virtual void            Deactivate( sal_Bool bUI );
	virtual sal_Bool            Close();
	virtual void            Notify(SfxBroadcaster& rBC,  const SfxHint& rHint);

public:
	TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXEXTERNALVIEWFRM);
							SfxExternalTopViewFrame_Impl( SfxFrame* pFrame,
								SfxObjectShell* pDoc=NULL, sal_uInt16 nViewId=0 );
	virtual 				~SfxExternalTopViewFrame_Impl();

	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY );
	virtual sal_Bool			SetBorderPixelImpl( const SfxViewShell *pSh,
									const SvBorder &rBorder );
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );
	virtual	void			MakeActive_Impl();
	void					Exec_Impl(SfxRequest &);
	void                    GetState_Impl(SfxItemSet &);
	void					INetExecute_Impl(SfxRequest &);
	void					INetState_Impl(SfxItemSet &);
};

#endif

#endif


