/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intn.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:44:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _TOOLS_INTN_HXX
#define _TOOLS_INTN_HXX

#ifndef INCLUDED_TOOLSDLLAPI_H
#include "tools/toolsdllapi.h"
#endif

#ifndef _SOLAR_H
#include <solar.h>
#endif
#ifndef _STRING_HXX
#include <string.hxx>
#endif
#ifndef _TIME_HXX
#include <time.hxx>
#endif
#ifndef _DATE_HXX
#include <date.hxx>
#endif
#ifndef _LANG_HXX
#include <lang.hxx>
#endif

class ResId;
class BigInt;

// -----------------------
// - International-Types -
// -----------------------

#define LANGUAGE_COUNT                  125
#define LANGUAGE_USER_COUNT             9

enum DateFormat { MDY, DMY, YMD };
enum TimeFormat { HOUR_12, HOUR_24 };
enum DayOfWeekFormat { DAYOFWEEK_NONE, DAYOFWEEK_SHORT, DAYOFWEEK_LONG };
enum MonthFormat { MONTH_NORMAL, MONTH_ZERO, MONTH_SHORT, MONTH_LONG };
enum FollowingText { FOLLOWTEXT_PAGE, FOLLOWTEXT_PAGES };
enum MeasurementSystem { MEASURE_METRIC, MEASURE_US };
enum QuotationMark { QUOTATION_MARK = 0x0022,
                     APOSTOPHE_QUOTE = 0x0027,
                     LEFT_POINTING_GUILLEMET = 0x00AB,
                     RIGHT_POINTING_GUILLEMET = 0x00BB,
                     SINGLE_TURNED_COMMA_QUOTATION_MARK = 0x2018,
                     SINGLE_COMMA_QUOTATION_MARK = 0x2019,
                     LOW_SINGLE_COMMA_QUOTATION_MARK = 0x201A,
                     DOUBLE_TURNED_COMMA_QUOTATION_MARK = 0x201C,
                     DOUBLE_COMMA_QUOTATION_MARK = 0x201D,
                     LOW_DOUBLE_COMMA_QUOTATION_MARK = 0x201E };

#define DAYOFWEEK_COUNT                 7
#define MONTH_COUNT                     12
#define FOLLOWTEXT_COUNT                2

#define INTN_CHAR_ALPHA                 ((BYTE)0x01)
#define INTN_CHAR_NUMERIC               ((BYTE)0x02)
#define INTN_CHAR_NOTALPHANUMERIC       ((BYTE)0x04)
#define INTN_CHAR_LOWER                 ((BYTE)0x08)
#define INTN_CHAR_UPPER                 ((BYTE)0x10)

#define INTN_COMPARE_IGNORECASE         ((USHORT)0x0001)

#define INTN_INDEX_DONTKNOW             ((char)0)
#define INTN_INDEX_SYMBOL               ((char)1)

// ------------------------
// - International-Tables -
// ------------------------

typedef BYTE (*LanguageTypeProc)( sal_Unicode c, LanguageType eLang );
typedef sal_Unicode (*LanguageUpLowProc)( sal_Unicode c, LanguageType eLang );
typedef StringCompare (*LanguageCompareProc)( const UniString& rStr1, const UniString& rStr2,
                                              USHORT nFlags, LanguageType eLang );
typedef sal_Unicode (*LanguageIndexProc)( const UniString& rStr, USHORT nFlags, LanguageType eLang );

#ifndef _TL_LANG_SPECIAL

class LanguageTable
{
private:
    USHORT              nRefCount;
    LanguageType        eLanguage;
    LanguageTypeProc    pTypeProc;
    LanguageUpLowProc   pLowerProc;
    LanguageUpLowProc   pUpperProc;
    LanguageCompareProc pCompareProc;
    LanguageIndexProc   pIndexProc;
    XubString*          pDayText[DAYOFWEEK_COUNT];
    XubString*          pAbbrevDayText[DAYOFWEEK_COUNT];
    XubString*          pMonthText[MONTH_COUNT];
    XubString*          pAbbrevMonthText[MONTH_COUNT];
    XubString*          pFollowingText[FOLLOWTEXT_COUNT];
    QuotationMark       meQuotationMarkStart;
    QuotationMark       meQuotationMarkEnd;
    QuotationMark       meQuotationMarkStart2;
    QuotationMark       meQuotationMarkEnd2;
    QuotationMark       meDoubleQuotationMarkStart;
    QuotationMark       meDoubleQuotationMarkEnd;
    QuotationMark       meDoubleQuotationMarkStart2;
    QuotationMark       meDoubleQuotationMarkEnd2;

public:
                        LanguageTable();
                        LanguageTable( const LanguageTable& rTable );
                        ~LanguageTable();

    void                SetLanguage( LanguageType eLang )
                            { eLanguage = eLang; }
    LanguageType        GetLanguage() const
                            { return eLanguage; }
    void                SetTypeProc( LanguageTypeProc pProc )
                            { pTypeProc = pProc; }
    LanguageTypeProc    GetTypeProc() const
                            { return pTypeProc; }
    void                SetLowerProc( LanguageUpLowProc pProc )
                            { pLowerProc = pProc; }
    LanguageUpLowProc   GetLowerProc() const
                            { return pLowerProc; }
    void                SetUpperProc( LanguageUpLowProc pProc )
                            { pUpperProc = pProc; }
    LanguageUpLowProc   GetUpperProc() const
                            { return pUpperProc; }
    void                SetCompareProc( LanguageCompareProc pProc )
                            { pCompareProc = pProc; }
    LanguageCompareProc GetCompareProc() const
                            { return pCompareProc; }
    void                SetIndexProc( LanguageIndexProc pProc )
                            { pIndexProc = pProc; }
    LanguageIndexProc   GetIndexProc() const
                            { return pIndexProc; }

    void                SetDayText( DayOfWeek eDay, const XubString& rText )
                            { *pDayText[(USHORT)eDay] = rText; }
    const XubString&    GetDayText( DayOfWeek eDay ) const
                            { return *pDayText[(USHORT)eDay]; }
    void                SetAbbrevDayText( DayOfWeek eDay, const XubString& rText )
                            { *pAbbrevDayText[(USHORT)eDay] = rText; }
    const XubString&    GetAbbrevDayText( DayOfWeek eDay ) const
                            { return *pAbbrevDayText[(USHORT)eDay]; }
    void                SetMonthText( USHORT nMonth, const XubString& rText )
                            { *pMonthText[nMonth-1] = rText; }
    const XubString&    GetMonthText( USHORT nMonth ) const
                            { return *pMonthText[nMonth-1]; }
    void                SetAbbrevMonthText( USHORT nMonth, const XubString& rText )
                            { *pAbbrevMonthText[nMonth-1] = rText; }
    const XubString&    GetAbbrevMonthText( USHORT nMonth ) const
                            { return *pAbbrevMonthText[nMonth-1]; }
    void                SetFollowingText( FollowingText eText, const XubString& rText )
                            { *pFollowingText[(USHORT)eText] = rText; }
    const XubString&    GetFollowingText( FollowingText eText ) const
                            { return *pFollowingText[(USHORT)eText]; }

    void                SetQuotationMarkStart( QuotationMark eQuotationMark )
                            { meQuotationMarkStart = eQuotationMark; }
    QuotationMark       GetQuotationMarkStart() const
                            { return meQuotationMarkStart; }
    void                SetQuotationMarkEnd( QuotationMark eQuotationMark )
                            { meQuotationMarkEnd = eQuotationMark; }
    QuotationMark       GetQuotationMarkEnd() const
                            { return meQuotationMarkEnd; }
    void                SetQuotationMarkStart2( QuotationMark eQuotationMark )
                            { meQuotationMarkStart2 = eQuotationMark; }
    QuotationMark       GetQuotationMarkStart2() const
                            { return meQuotationMarkStart2; }
    void                SetQuotationMarkEnd2( QuotationMark eQuotationMark )
                            { meQuotationMarkEnd2 = eQuotationMark; }
    QuotationMark       GetQuotationMarkEnd2() const
                            { return meQuotationMarkEnd2; }

    void                SetDoubleQuotationMarkStart( QuotationMark eQuotationMark )
                            { meDoubleQuotationMarkStart = eQuotationMark; }
    QuotationMark       GetDoubleQuotationMarkStart() const
                            { return meDoubleQuotationMarkStart; }
    void                SetDoubleQuotationMarkEnd( QuotationMark eQuotationMark )
                            { meDoubleQuotationMarkEnd = eQuotationMark; }
    QuotationMark       GetDoubleQuotationMarkEnd() const
                            { return meDoubleQuotationMarkEnd; }
    void                SetDoubleQuotationMarkStart2( QuotationMark eQuotationMark )
                            { meDoubleQuotationMarkStart2 = eQuotationMark; }
    QuotationMark       GetDoubleQuotationMarkStart2() const
                            { return meDoubleQuotationMarkStart2; }
    void                SetDoubleQuotationMarkEnd2( QuotationMark eQuotationMark )
                            { meDoubleQuotationMarkEnd2 = eQuotationMark; }
    QuotationMark       GetDoubleQuotationMarkEnd2() const
                            { return meDoubleQuotationMarkEnd2; }

    LanguageTable&      operator=( const LanguageTable& rTable );

    BOOL                operator==( const LanguageTable& rTable ) const;
    BOOL                operator!=( const LanguageTable& rTable ) const
                            { return !LanguageTable::operator==( rTable ); }
};

class FormatTable
{
private:
    USHORT              nRefCount;
    LanguageType        eLanguage;
    DayOfWeek           eWeekStart;
    WeekCountStart      eWeekCountStart;
    DateFormat          eDateFormat;
    xub_Unicode         cDateSep;
    BOOL                bDateDayLeadingZero;
    BOOL                bDateMonthLeadingZero;
    BOOL                bDateCentury;
    DateFormat          eLongDateFormat;
    DayOfWeekFormat     eLongDateDayOfWeekFormat;
    BOOL                bLongDateDayLeadingZero;
    XubString           aLongDateDayOfWeekSep;
    XubString           aLongDateDaySep;
    XubString           aLongDateMonthSep;
    XubString           aLongDateYearSep;
    MonthFormat         eLongDateMonthFormat;
    BOOL                bLongDateCentury;
    TimeFormat          eTimeFormat;
    xub_Unicode         cTimeSep;
    xub_Unicode         cTime100SecSep;
    BOOL                bTimeLeadingZero;
    XubString           aTimeAM;
    XubString           aTimePM;
    XubString           aTimeStr;
    xub_Unicode         cNumThousandSep;
    BOOL                bNumThousandSep;
    xub_Unicode         cNumDecimalSep;
    BOOL                bNumLeadingZero;
    USHORT              nNumDigits;
    BOOL                bNumTrailingZeros;
    USHORT              nCurrPositiveFormat;
    USHORT              nCurrNegativeFormat;
    XubString           aCurrSymbol;
    XubString           aCurrBankSymbol;
    XubString           aCurrSymbol2;
    XubString           aCurrBankSymbol2;
    USHORT              nCurrDigits;
    xub_Unicode         cCurrZeroChar;
    xub_Unicode         cListSep;
    USHORT              nPercentFormat;
    MeasurementSystem   eMeasurementSystem;

public:
                        FormatTable();
                        FormatTable( const FormatTable& rTable );
                        ~FormatTable();

    void                SetLanguage( LanguageType eLang )
                            { eLanguage = eLang; }
    LanguageType        GetLanguage() const
                            { return eLanguage; }
    void                SetWeekStart( DayOfWeek eDay )
                            { eWeekStart = eDay; }
    DayOfWeek           GetWeekStart() const
                            { return eWeekStart; }
    void                SetWeekCountStart( WeekCountStart eStart )
                            { eWeekCountStart = eStart; }
    WeekCountStart      GetWeekCountStart() const
                            { return eWeekCountStart; }
    void                SetDateFormat( DateFormat eFormat )
                            { eDateFormat = eFormat; }
    DateFormat          GetDateFormat() const
                            { return eDateFormat; }
    void                SetDateSep( xub_Unicode cSep )
                            { cDateSep = cSep; }
    xub_Unicode         GetDateSep() const
                            { return cDateSep; }
    void                SetDateDayLeadingZero( BOOL bLeading )
                            { bDateDayLeadingZero = bLeading; }
    BOOL                IsDateDayLeadingZero() const
                            { return bDateDayLeadingZero; }
    void                SetDateMonthLeadingZero( BOOL bLeading )
                            { bDateMonthLeadingZero = bLeading; }
    BOOL                IsDateMonthLeadingZero() const
                            { return bDateMonthLeadingZero; }
    void                SetDateCentury( BOOL bCentury )
                            { bDateCentury = bCentury; }
    BOOL                IsDateCentury() const
                            { return bDateCentury; }
    void                SetLongDateFormat( DateFormat eFormat )
                            { eLongDateFormat = eFormat; }
    DateFormat          GetLongDateFormat() const
                            { return eLongDateFormat; }
    void                SetLongDateDayOfWeekFormat( DayOfWeekFormat eFormat )
                            { eLongDateDayOfWeekFormat = eFormat; }
    DayOfWeekFormat     GetLongDateDayOfWeekFormat() const
                            { return eLongDateDayOfWeekFormat; }
    void                SetLongDateDayOfWeekSep( const XubString& rStr )
                            { aLongDateDayOfWeekSep = rStr; }
    const XubString&    GetLongDateDayOfWeekSep() const
                            { return aLongDateDayOfWeekSep; }
    void                SetLongDateDaySep( const XubString& rStr )
                            { aLongDateDaySep = rStr; }
    const XubString&    GetLongDateDaySep() const
                            { return aLongDateDaySep; }
    void                SetLongDateDayLeadingZero( BOOL bLeading )
                            { bLongDateDayLeadingZero = bLeading; }
    BOOL                IsLongDateDayLeadingZero() const
                            { return bLongDateDayLeadingZero; }
    void                SetLongDateMonthFormat( MonthFormat eFormat )
                            { eLongDateMonthFormat = eFormat; }
    MonthFormat         GetLongDateMonthFormat() const
                            { return eLongDateMonthFormat; }
    void                SetLongDateMonthSep( const XubString& rStr )
                            { aLongDateMonthSep = rStr; }
    const XubString&    GetLongDateMonthSep() const
                            { return aLongDateMonthSep; }
    void                SetLongDateYearSep( const XubString& rStr )
                            { aLongDateYearSep = rStr; }
    const XubString&    GetLongDateYearSep() const
                            { return aLongDateYearSep; }
    void                SetLongDateCentury( BOOL bCentury )
                            { bLongDateCentury = bCentury; }
    BOOL                IsLongDateCentury() const
                            { return bLongDateCentury; }
    void                SetTimeFormat( TimeFormat eFormat )
                            { eTimeFormat = eFormat; }
    TimeFormat          GetTimeFormat() const
                            { return eTimeFormat; }
    void                SetTimeSep( xub_Unicode cSep )
                            { cTimeSep = cSep; }
    xub_Unicode         GetTimeSep() const
                            { return cTimeSep; }
    void                SetTime100SecSep( xub_Unicode cSep )
                            { cTime100SecSep = cSep; }
    xub_Unicode         GetTime100SecSep() const
                            { return cTime100SecSep; }
    void                SetTimeLeadingZero( BOOL bLeading )
                            { bTimeLeadingZero = bLeading; }
    BOOL                IsTimeLeadingZero() const
                            { return bTimeLeadingZero; }
    void                SetTimeAM( const XubString& rStr )
                            { aTimeAM = rStr; }
    const XubString&    GetTimeAM() const
                            { return aTimeAM; }
    void                SetTimePM( const XubString& rStr )
                            { aTimePM = rStr; }
    const XubString&    GetTimePM() const
                            { return aTimePM; }
    void                SetTimeStr( const XubString& rStr )
                            { aTimeStr = rStr; }
    const XubString&    GetTimeStr() const
                            { return aTimeStr; }
    void                SetNumThousandSep( xub_Unicode cSep )
                            { cNumThousandSep = cSep; }
    xub_Unicode         GetNumThousandSep() const
                            { return cNumThousandSep; }
    void                SetNumDecimalSep( xub_Unicode cSep )
                            { cNumDecimalSep = cSep; }
    xub_Unicode         GetNumDecimalSep() const
                            { return cNumDecimalSep; }
    void                EnableNumThousandSep( BOOL bSep = TRUE )
                            { bNumThousandSep = bSep; }
    BOOL                IsNumThousandSep() const
                            { return bNumThousandSep; }
    void                SetNumLeadingZero( BOOL bLeading )
                            { bNumLeadingZero = bLeading; }
    BOOL                IsNumLeadingZero() const
                            { return bNumLeadingZero; }
    void                SetNumDigits( USHORT nDigits )
                            { nNumDigits = nDigits; }
    USHORT              GetNumDigits() const
                            { return nNumDigits; }
    void                SetNumTrailingZeros( BOOL bTrailingZeros = TRUE )
                            { bNumTrailingZeros = bTrailingZeros; }
    BOOL                IsNumTrailingZeros() const
                            { return bNumTrailingZeros; }
    void                SetCurrPositiveFormat( USHORT nFormat )
                            { nCurrPositiveFormat = nFormat; }
    USHORT              GetCurrPositiveFormat() const
                            { return nCurrPositiveFormat; }
    void                SetCurrNegativeFormat( USHORT nFormat )
                            { nCurrNegativeFormat = nFormat; }
    USHORT              GetCurrNegativeFormat() const
                            { return nCurrNegativeFormat; }
    void                SetCurrSymbol( const XubString& rStr )
                            { aCurrSymbol = rStr; }
    const XubString&    GetCurrSymbol() const
                            { return aCurrSymbol; }
    void                SetCurrBankSymbol( const XubString& rStr )
                            { aCurrBankSymbol = rStr; }
    const XubString&    GetCurrBankSymbol() const
                            { return aCurrBankSymbol; }
    void                SetCurrSymbol2( const XubString& rStr )
                            { aCurrSymbol2 = rStr; }
    const XubString&    GetCurrSymbol2() const
                            { return aCurrSymbol2; }
    void                SetCurrBankSymbol2( const XubString& rStr )
                            { aCurrBankSymbol2 = rStr; }
    const XubString&    GetCurrBankSymbol2() const
                            { return aCurrBankSymbol2; }
    void                SetCurrDigits( USHORT nDigits )
                            { nCurrDigits = nDigits; }
    USHORT              GetCurrDigits() const
                            { return nCurrDigits; }
    void                SetCurrZeroChar( xub_Unicode cZeroChar )
                            { cCurrZeroChar = cZeroChar; }
    xub_Unicode         GetCurrZeroChar() const
                            { return cCurrZeroChar; }
    void                SetListSep( xub_Unicode cSep )
                            { cListSep = cSep; }
    xub_Unicode         GetListSep() const
                            { return cListSep; }
    void                SetPercentFormat( USHORT nFormat )
                            { nPercentFormat = nFormat; }
    USHORT              GetPercentFormat() const
                            { return nPercentFormat; }

    void                SetMeasurementSystem( MeasurementSystem eSystem )
                            { eMeasurementSystem = eSystem; }
    MeasurementSystem   GetMeasurementSystem() const
                            { return eMeasurementSystem; }

    FormatTable&        operator=( const FormatTable& rTable );

    BOOL                operator==( const FormatTable& rTable ) const;
    BOOL                operator!=( const FormatTable& rTable ) const
                            { return !FormatTable::operator==( rTable ); }
};

// Positive Currency Format
//  0 : $1
//  1 : 1$
//  2 : $ 1
//  3 : 1 $
// Negative Currency Format
//  0 : ($1)
//  1 : -$1
//  2 : $-1
//  3 : $1-
//  4 : (1$)
//  5 : -1$
//  6 : 1-$
//  7 : 1$-
//  8 : -1 $
//  9 : -$ 1
// 10 : 1 $-
// 11 : $ -1
// 12 : $ 1-
// 13 : 1- $
// 14 : ($ 1)
// 15 : (1 $)
// Percent Format
//  0 : 37%
//  1 : 37 %
//  2 : %37

#endif

class LanguageTable;
class FormatTable;

struct InternationalData
{
    LanguageTable*  pLanguage;
    FormatTable*    pFormat;
    USHORT          nRefCount;
    BOOL            bStaticLang;
    BOOL            bStaticFormat;
};

// Implementation, um von StarView auf die internen Funktionen zuzugreifen
#define      INTERNATIONAL_SYSTEM_DEFAULT   0xFFFF
void         UpdateInternationalSystemTables();
/** Language/locale of category LC_CTYPE (on Unix, else the system language).
    Evaluation order: LC_ALL, LC_CTYPE, LANG */
TOOLS_DLLPUBLIC LanguageType GetSystemLanguage( USHORT nIndex = INTERNATIONAL_SYSTEM_DEFAULT );
/** Language/locale of category LC_MESSAGES (on Unix, else same as GetSystemLanguage()).
    Evaluation order: LC_ALL, LC_MESSAGES, LANG */
TOOLS_DLLPUBLIC LanguageType GetSystemUILanguage( USHORT nIndex = INTERNATIONAL_SYSTEM_DEFAULT );
/** This could be language/locale of category LC_NUMERIC.
    However, currently it is not, but the same as GetSystemLanguage() instead. */
LanguageType GetSystemFormatLanguage( USHORT nIndex = INTERNATIONAL_SYSTEM_DEFAULT );
/** Deprecated method to override language/locale memorized internally.
    Don't use, it has no positive effect and will not be used by the
    i18n framework (as is nothing from here). */
void         SetSystemLanguage( LanguageType eLang );

// -----------------
// - International -
// -----------------

class TOOLS_DLLPUBLIC International
{
    void Init( LanguageType eLang, LanguageType eFormat );

private:
    InternationalData*  pData;

public:
                        International()
                            { Init( LANGUAGE_SYSTEM, LANGUAGE_SYSTEM ); }
                        International( const International& rIntn );
                        International( const ResId& rResId );
                        International( LanguageType eLanguage )
                            { Init( eLanguage, eLanguage ); }
                        International( LanguageType eLanguage,
                                       LanguageType eFormat )
                            { Init( eLanguage, eFormat ); }
                        ~International();

#ifndef _TL_LANG_SPECIAL
    LanguageType        GetLanguage() const
                            { return pData->pLanguage->GetLanguage(); }
    LanguageType        GetFormatLanguage() const
                            { return pData->pFormat->GetLanguage(); }

    void                SetQuotationMarkStart( QuotationMark eQuotationMark );
    QuotationMark       GetQuotationMarkStart() const
                            { return pData->pLanguage->GetQuotationMarkStart(); }
    void                SetQuotationMarkEnd( QuotationMark eQuotationMark );
    QuotationMark       GetQuotationMarkEnd() const
                            { return pData->pLanguage->GetQuotationMarkEnd(); }
    void                SetQuotationMarkStart2( QuotationMark eQuotationMark );
    QuotationMark       GetQuotationMarkStart2() const
                            { return pData->pLanguage->GetQuotationMarkStart2(); }
    void                SetQuotationMarkEnd2( QuotationMark eQuotationMark );
    QuotationMark       GetQuotationMarkEnd2() const
                            { return pData->pLanguage->GetQuotationMarkEnd2(); }
    void                SetDoubleQuotationMarkStart( QuotationMark eQuotationMark );
    QuotationMark       GetDoubleQuotationMarkStart() const
                            { return pData->pLanguage->GetDoubleQuotationMarkStart(); }
    void                SetDoubleQuotationMarkEnd( QuotationMark eQuotationMark );
    QuotationMark       GetDoubleQuotationMarkEnd() const
                            { return pData->pLanguage->GetDoubleQuotationMarkEnd(); }
    void                SetDoubleQuotationMarkStart2( QuotationMark eQuotationMark );
    QuotationMark       GetDoubleQuotationMarkStart2() const
                            { return pData->pLanguage->GetDoubleQuotationMarkStart2(); }
    void                SetDoubleQuotationMarkEnd2( QuotationMark eQuotationMark );
    QuotationMark       GetDoubleQuotationMarkEnd2() const
                            { return pData->pLanguage->GetDoubleQuotationMarkEnd2(); }

    void                SetDayText( DayOfWeek eDay, const XubString& rStr );
    const XubString&    GetDayText( DayOfWeek eDay ) const
                            { return pData->pLanguage->GetDayText( eDay ); }
    void                SetAbbrevDayText( DayOfWeek eDay, const XubString& rStr );
    const XubString&    GetAbbrevDayText( DayOfWeek eDay ) const
                            { return pData->pLanguage->GetAbbrevDayText( eDay ); }
    void                SetMonthText( USHORT nMonth, const XubString& rStr );
    const XubString&    GetMonthText( USHORT nMonth ) const
                            { return pData->pLanguage->GetMonthText( nMonth ); }
    void                SetAbbrevMonthText( USHORT nMonth, const XubString& rStr );
    const XubString&    GetAbbrevMonthText( USHORT nMonth ) const
                            { return pData->pLanguage->GetAbbrevMonthText( nMonth ); }
    void                SetFollowingText( FollowingText eText, const XubString& rStr );
    const XubString&    GetFollowingText( FollowingText eText ) const
                            { return pData->pLanguage->GetFollowingText( eText ); }

#ifdef I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

    sal_Unicode         Lower( sal_Unicode c ) const;
    sal_Unicode         Upper( sal_Unicode c ) const;
    BYTE                GetCharType( sal_Unicode c ) const;
    BOOL                IsLower( sal_Unicode c ) const
                            { return ((GetCharType( c ) & (INTN_CHAR_LOWER | INTN_CHAR_NUMERIC | INTN_CHAR_NOTALPHANUMERIC)) != 0); }
    BOOL                IsUpper( sal_Unicode c ) const
                            { return ((GetCharType( c ) & (INTN_CHAR_UPPER | INTN_CHAR_NUMERIC | INTN_CHAR_NOTALPHANUMERIC)) != 0); }
    BOOL                IsAlpha( sal_Unicode c ) const
                            { return ((GetCharType( c ) & INTN_CHAR_ALPHA) != 0); }
    BOOL                IsNumeric( sal_Unicode c ) const
                            { return ((GetCharType( c ) & INTN_CHAR_NUMERIC) != 0); }
    BOOL                IsAlphaNumeric( sal_Unicode c ) const
                            { return ((GetCharType( c ) & (INTN_CHAR_ALPHA | INTN_CHAR_NUMERIC)) != 0); }

    void                ToLower( UniString& rStr ) const;
    void                ToUpper( UniString& rStr ) const;
    UniString           Lower( const UniString& rStr ) const;
    UniString           Upper( const UniString& rStr ) const;
    BOOL                IsStringType( const UniString& rStr, BYTE nType ) const;
    BOOL                IsLower( const UniString& rStr ) const
                            { return IsStringType( rStr, INTN_CHAR_LOWER | INTN_CHAR_NUMERIC | INTN_CHAR_NOTALPHANUMERIC ); }
    BOOL                IsUpper( const UniString& rStr ) const
                            { return IsStringType( rStr, INTN_CHAR_UPPER | INTN_CHAR_NUMERIC | INTN_CHAR_NOTALPHANUMERIC ); }
    BOOL                IsAlpha( const UniString& rStr ) const
                            { return IsStringType( rStr, INTN_CHAR_ALPHA ); }
    BOOL                IsNumeric( const UniString& rStr ) const
                            { return IsStringType( rStr, INTN_CHAR_NUMERIC ); }
    BOOL                IsAlphaNumeric( const UniString& rStr ) const
                            { return IsStringType( rStr, INTN_CHAR_ALPHA | INTN_CHAR_NUMERIC ); }

#endif // I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

    StringCompare       Compare( const UniString& rStr1, const UniString& rStr2,
                                 USHORT nFlags = 0 ) const;
    BOOL                CompareEqual( const UniString& rStr1, const UniString& rStr2,
                                      USHORT nFlags = 0 ) const;

    sal_Unicode         GetIndexChar( const UniString& rStr1, USHORT nFlags = 0 ) const;
    sal_Unicode         GetQuotationMarkStartChar() const { return (sal_Unicode)pData->pLanguage->GetQuotationMarkStart(); }
    sal_Unicode         GetQuotationMarkEndChar() const { return (sal_Unicode)pData->pLanguage->GetQuotationMarkEnd(); }
    sal_Unicode         GetDoubleQuotationMarkStartChar() const { return (sal_Unicode)pData->pLanguage->GetDoubleQuotationMarkStart(); }
    sal_Unicode         GetDoubleQuotationMarkEndChar() const { return (sal_Unicode)pData->pLanguage->GetDoubleQuotationMarkEnd(); }

    // only optional! If we have a complete unicode version, than these functions are obsolete
    sal_Char            GetQuotationMarkStartChar( rtl_TextEncoding eEncoding,
                                                   rtl_TextEncoding eOptionalEncoding = RTL_TEXTENCODING_DONTKNOW,
                                                   BOOL* pOptionalUsed = NULL ) const;
    sal_Char            GetQuotationMarkEndChar( rtl_TextEncoding eEncoding,
                                                 rtl_TextEncoding eOptionalEncoding = RTL_TEXTENCODING_DONTKNOW,
                                                 BOOL* pOptionalUsed = NULL ) const;
    sal_Char            GetDoubleQuotationMarkStartChar( rtl_TextEncoding eEncoding,
                                                         rtl_TextEncoding eOptionalEncoding = RTL_TEXTENCODING_DONTKNOW,
                                                         BOOL* pOptionalUsed = NULL ) const;
    sal_Char            GetDoubleQuotationMarkEndChar( rtl_TextEncoding eEncoding,
                                                       rtl_TextEncoding eOptionalEncoding = RTL_TEXTENCODING_DONTKNOW,
                                                       BOOL* pOptionalUsed = NULL ) const;

    void                SetWeekStart( DayOfWeek eDay );
    DayOfWeek           GetWeekStart() const
                            { return pData->pFormat->GetWeekStart(); }
    void                SetWeekCountStart( WeekCountStart eStart );
    WeekCountStart      GetWeekCountStart() const
                            { return pData->pFormat->GetWeekCountStart(); }

    void                SetDateFormat( DateFormat eFormat );
    DateFormat          GetDateFormat() const
                            { return pData->pFormat->GetDateFormat(); }
    void                SetDateSep( xub_Unicode cSep );
    xub_Unicode         GetDateSep() const
                            { return pData->pFormat->GetDateSep(); }
    void                SetDateDayLeadingZero( BOOL bLeading );
    BOOL                IsDateDayLeadingZero() const
                            { return pData->pFormat->IsDateDayLeadingZero(); }
    void                SetDateMonthLeadingZero( BOOL bLeading );
    BOOL                IsDateMonthLeadingZero() const
                            { return pData->pFormat->IsDateMonthLeadingZero(); }
    void                SetDateCentury( BOOL bCentury );
    BOOL                IsDateCentury() const
                            { return pData->pFormat->IsDateCentury(); }
    XubString           GetDate( const Date& rDate ) const;

    void                SetLongDateFormat( DateFormat eFormat );
    DateFormat          GetLongDateFormat() const
                            { return pData->pFormat->GetLongDateFormat(); }
    void                SetLongDateDayOfWeekFormat( DayOfWeekFormat eFormat );
    DayOfWeekFormat     GetLongDateDayOfWeekFormat() const
                            { return pData->pFormat->GetLongDateDayOfWeekFormat(); }
    void                SetLongDateDayOfWeekSep( const XubString& rStr );
    const XubString&    GetLongDateDayOfWeekSep() const
                            { return pData->pFormat->GetLongDateDayOfWeekSep(); }
    void                SetLongDateDayLeadingZero( BOOL bLeading );
    BOOL                IsLongDateDayLeadingZero() const
                            { return pData->pFormat->IsLongDateDayLeadingZero(); }
    void                SetLongDateDaySep( const XubString& rStr );
    const XubString&    GetLongDateDaySep() const
                            { return pData->pFormat->GetLongDateDaySep(); }
    void                SetLongDateMonthFormat( MonthFormat eFormat );
    MonthFormat         GetLongDateMonthFormat() const
                            { return pData->pFormat->GetLongDateMonthFormat(); }
    void                SetLongDateMonthSep( const XubString& rStr );
    const XubString&    GetLongDateMonthSep() const
                            { return pData->pFormat->GetLongDateMonthSep(); }
    void                SetLongDateCentury( BOOL bCentury );
    BOOL                IsLongDateCentury() const
                            { return pData->pFormat->IsLongDateCentury(); }
    void                SetLongDateYearSep( const XubString& rStr );
    const XubString&    GetLongDateYearSep() const
                            { return pData->pFormat->GetLongDateYearSep(); }
    XubString           GetLongDate( const Date& rDate ) const;

    void                SetTimeLeadingZero( BOOL bLeading );
    BOOL                IsTimeLeadingZero() const
                            { return pData->pFormat->IsTimeLeadingZero(); }
    void                SetTimeFormat( TimeFormat eFormat );
    TimeFormat          GetTimeFormat() const
                            { return pData->pFormat->GetTimeFormat(); }
    void                SetTimeSep( xub_Unicode cSep );
    xub_Unicode         GetTimeSep() const
                            { return pData->pFormat->GetTimeSep(); }
    void                SetTime100SecSep( xub_Unicode cSep );
    xub_Unicode         GetTime100SecSep() const
                            { return pData->pFormat->GetTime100SecSep(); }
    void                SetTimeAM( const XubString& rStr );
    const XubString&    GetTimeAM() const
                            { return pData->pFormat->GetTimeAM(); }
    void                SetTimePM( const XubString& rStr );
    const XubString&    GetTimePM() const
                            { return pData->pFormat->GetTimePM(); }
    void                SetTimeStr( const XubString& rStr );
    const XubString&    GetTimeStr() const
                            { return pData->pFormat->GetTimeStr(); }
    XubString           GetDuration( const Time& rTime,
                                     BOOL bSec = TRUE, BOOL b100Sec = FALSE ) const;
    XubString           GetTime( const Time& rTime,
                                 BOOL bSec = TRUE, BOOL b100Sec = FALSE ) const;

    void                EnableNumThousandSep( BOOL bSep = TRUE );
    BOOL                IsNumThousandSep() const
                            { return pData->pFormat->IsNumThousandSep(); }
    void                SetNumThousandSep( xub_Unicode cSep );
    xub_Unicode         GetNumThousandSep() const
                            { return pData->pFormat->GetNumThousandSep(); }
    void                SetNumDecimalSep( xub_Unicode cSep );
    xub_Unicode         GetNumDecimalSep() const
                            { return pData->pFormat->GetNumDecimalSep(); }
    void                SetNumLeadingZero( BOOL bLeading );
    BOOL                IsNumLeadingZero() const
                            { return pData->pFormat->IsNumLeadingZero(); }
    void                SetNumDigits( USHORT nDigits );
    USHORT              GetNumDigits() const
                            { return pData->pFormat->GetNumDigits(); }
    void                SetNumTrailingZeros( BOOL bTrailingZeros = TRUE );
    BOOL                IsNumTrailingZeros() const
                            { return pData->pFormat->IsNumTrailingZeros(); }
    XubString           GetNum( long nNumber, USHORT nDigits ) const;
    XubString           GetNum( long nNumber ) const
                            { return GetNum( nNumber, GetNumDigits() ); }

    void                SetCurrPositiveFormat( USHORT nFormat );
    USHORT              GetCurrPositiveFormat() const
                            { return pData->pFormat->GetCurrPositiveFormat(); }
    void                SetCurrNegativeFormat( USHORT nFormat );
    USHORT              GetCurrNegativeFormat() const
                            { return pData->pFormat->GetCurrNegativeFormat(); }
    void                SetCurrDigits( USHORT nDigits );
    USHORT              GetCurrDigits() const
                            { return pData->pFormat->GetCurrDigits(); }
    void                SetCurrSymbol( const XubString& rSymbol );
    const XubString&    GetCurrSymbol() const
                            { return pData->pFormat->GetCurrSymbol(); }
    void                SetCurrBankSymbol( const XubString& rSymbol );
    const XubString&    GetCurrBankSymbol() const
                            { return pData->pFormat->GetCurrBankSymbol(); }
    void                SetCurrSymbol2( const XubString& rSymbol2 );
    const XubString&    GetCurrSymbol2() const
                            { return pData->pFormat->GetCurrSymbol2(); }
    void                SetCurrBankSymbol2( const XubString& rSymbol2 );
    const XubString&    GetCurrBankSymbol2() const
                            { return pData->pFormat->GetCurrBankSymbol2(); }
    void                SetCurrZeroChar( xub_Unicode cZeroChar );
    xub_Unicode         GetCurrZeroChar() const
                            { return pData->pFormat->GetCurrZeroChar(); }
    XubString           GetCurr( long nNumber, USHORT nDigits ) const;
    XubString           GetCurr( long nNumber ) const
                            { return GetCurr( nNumber, GetCurrDigits() ); }

    void                SetListSep( xub_Unicode cSep );
    xub_Unicode         GetListSep() const
                            { return pData->pFormat->GetListSep(); }

    void                SetPercentFormat( USHORT nFormat );
    USHORT              GetPercentFormat() const
                            { return pData->pFormat->GetPercentFormat(); }
    XubString           GetPercent( long nPercent ) const;

    void                SetMeasurementSystem( MeasurementSystem eSystem );
    MeasurementSystem   GetMeasurementSystem() const
                            { return pData->pFormat->GetMeasurementSystem(); }
#endif

    International&      operator=( const International& rIntn );

    BOOL                operator==( const International& rIntn ) const;
    BOOL                operator!=( const International& rIntn ) const
                            { return !International::operator==( rIntn ); }

    static LanguageType GetNeutralLanguage( LanguageType eLang );
    static LanguageType GetRealLanguage( LanguageType eLang );

    static void         RegisterLanguage( const LanguageTable& rTable );
    static BOOL         IsLanguageAvailable( LanguageType eLanguage );
    static USHORT       GetAvailableLanguageCount();
    static LanguageType GetAvailableLanguage( USHORT nIndex );
    static void         RegisterFormat( const FormatTable& rTable );
    static BOOL         IsFormatAvailable( LanguageType eLang );
    static USHORT       GetAvailableFormatCount();
    static LanguageType GetAvailableFormat( USHORT nIndex );
};

#endif //_TOOLS_INTN_HXX
