
/**
 * Title:        Help Content Provider<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Andreas Bille ( abi )<p>
 * Company:      Sun Microsystems. Inc<p>
 * @author Andreas Bille ( abi )
 * @version 1.0
 */
package com.sun.star.help;

import java.io.UnsupportedEncodingException;
import com.sleepycat.db.*;

public class StringDbt extends Dbt
{
	private String _Title = null;
	private String _Database = null;
	private String _File = null;
	private String _Hash = null;


    public StringDbt()
    {
        set_flags(Db.DB_DBT_MALLOC); // tell Db to allocate on retrieval
    }


    public StringDbt(String value)
    {
        setString(value);
        set_flags(Db.DB_DBT_MALLOC); // tell Db to allocate on retrieval
    }


    public final void setString(String value)
    {
		byte[] b;
		try
		{
			b = value.getBytes("UTF8");
		}
		catch( UnsupportedEncodingException e )
		{
			b = value.getBytes();
		}
		set_size( b.length );
		set_data( b );
    }


    public final String getString()
    {
		byte[] b = get_data();
		if( b != null )
		{
			try
			{
				return new String( b,0,get_size(),"UTF8" );
			}
			catch( UnsupportedEncodingException e )
			{
				return new String( b,0,get_size() );
			}
		}
		else
			return new String( "" );
    }


    public final boolean isHelptextEntry()
    {
    	return ! getHash().equals("");
    }


    public final String getHash()
    {
	    byte[] b =get_data();
 		if( b != null )
   		{
			int sizeOfFile = ( int ) b[0];
			try
			{
				_Hash = new String( b,1,sizeOfFile,"UTF8" );
			}
			catch( UnsupportedEncodingException e )
			{
				_Hash = new String( b,1,sizeOfFile );
			}
   			int idx = _Hash.indexOf( '#' );
   			if( idx != -1 )
      			_Hash = _Hash.substring( 1+idx );
         	else
          		_Hash = "";
   		}
     	else
      		_Hash = "";
        return _Hash;
    }


	public final String getFile()
	{
	    byte[] b = get_data();
 		if( b != null )
   		{
			int sizeOfFile = ( int ) b[0];
			try
			{
				_File = new String( b,1,sizeOfFile,"UTF8" );
			}
			catch( UnsupportedEncodingException e )
			{
				_File = new String( b,1,sizeOfFile );
			}
			
   			int idx = _File.indexOf( '#' );
   			if( idx != -1 )
          		_File = _File.substring( 0,idx );
   		}
     	else
      		_File = "";
		
        return _File;
	}


	
	public final String getDatabase()
	{
	    byte[] b = get_data();
		if( b != null )
  		{
			int sizeOfDatabase = ( int ) b[ 1+ ( int ) b[0] ];
			try
			{
				_Database = new String( b,2 + ( int ) b[0],sizeOfDatabase,"UTF8" );
			}
			catch( UnsupportedEncodingException e )
			{
				_Database = new String( b,2 + ( int ) b[0],sizeOfDatabase );
			}
   		}
     	else
			_Database = "";
		
		return _Database;
	}


	
	public final String getTitle()
	{
		if( isHelptextEntry() )
  			return "";

		byte[] b = get_data();
     	if( b != null )
      	{
			int sizeOfTitle = ( int ) b[  2 + b[0] +  ( int ) b[ 1+ ( int ) b[0] ] ];

  			try
			{
                _Title = new String( b,  3 + b[0] +  ( int ) b[ 1+ ( int ) b[0] ] ,sizeOfTitle,"UTF8" );
			}
     		catch( UnsupportedEncodingException e )
      		{
				_Title = new String( b,  3 + b[0] +  ( int ) b[ 1+ ( int ) b[0] ] ,sizeOfTitle );
       		}
   		}
     	else
      		_Title = "";

		return _Title;
	}
}





