/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appimp.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:44:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _OFF_APPIMP_HXX
#define _OFF_APPIMP_HXX

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#include <tools/string.hxx>
class Config; 
class SfxBroadcaster; 
class SvtAccessibilityOptions; 
namespace binfilter {

class OfaHtmlOptions;
class OfaAutoCorrCfg;
//class BasicIDE;
class XColorTable;
class XOutdevItemPool;
class SpellNotifier;
class OfaFilterOptions;
class OfaTabAppearanceCfg;


// struct OfficeData_Impl ------------------------------------------------

class OfficeData_Impl : public SfxListener
{
private:
	friend class OfficeApplication;

	OfaHtmlOptions*				pHtmlOptions;
	OfaAutoCorrCfg*				pAutoCorrCfg;
    SvtAccessibilityOptions*    pAccessibilityOptions;
    Config*             		pSearchEngCfg;
	Config*						pFontSubstCfg;
	XColorTable*				pStdColorTable;
	XOutdevItemPool*			pXOutdevItemPool;
	OfaTabAppearanceCfg*		pTabAppearanceConfig;
	SpellNotifier*				pSpellNote;
	OfaFilterOptions*			pFilterOptions;
	void						(*pWordDeInitFct)();
	sal_uInt32					nChangeUserDataEvent;
	sal_Bool					bDoSearchCfg;
	String						aMailTempPath;

	virtual void				Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
    void                		SetVCLSettings();

public:
	OfficeData_Impl( SfxBroadcaster& rBroadcast );
    ~OfficeData_Impl();
};

} //namespace binfilter
#endif // #ifndef _OFF_APPIMP_HXX

