/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SearchClient.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:34:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.util.*;
import java.io.*;
import java.net.*;
import com.sun.xmlsearch.util.*;

public class SearchClient extends Thread {
  private String _query;

  public SearchClient(String[] args) {
    StringBuffer buf = new StringBuffer();
    for (int i = 0; i < args.length; i++) {
      buf.append(args[i]);
      buf.append(' ');
    }
    _query = buf.toString();
  }

  public void run() {
    while (true) {
      queryServer();
    }
  }

  public void queryServer() {
    try {
      long start = System.currentTimeMillis();
      Socket serverSocket = new Socket("bigblock.east.sun.com", 6789);
      OutputStream serverOutput = serverSocket.getOutputStream();
      LineInput lineInput = new LineInput(serverSocket.getInputStream());
      serverOutput.write(_query.getBytes());
      serverOutput.write('\n');
      serverOutput.flush();
      int count = 0;
      String line = null;
      do {
	line = lineInput.readLine();
	++count;
      }
      while (line.equals("**END**") == false);
      System.out.println(count + " lines");
      serverSocket.close();
      System.out.println((System.currentTimeMillis()-start)
			 +" msec total");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    (new SearchClient(args)).start();
  }
}
