/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: crwg_def.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:04:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CRWG_DEF_HXX
#define ARY_CPP_CRWG_DEF_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS


namespace ary
{
namespace cpp
{
    class InputContext;
    class Define;
    class Macro;

class RwGate_Defines
{
  public:
    // LIFECYCLE
    virtual             ~RwGate_Defines() {}

	// OPERATIONS
	Define &            Store_Define(
                            const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rDefinition );
	Macro &             Store_Macro(
							const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rParams,
                            const StringVector &
                                                i_rDefinition );
  private:
	virtual Define &    do_Store_Define(
                            const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rDefinition ) = 0;
	virtual Macro &     do_Store_Macro(
							const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rParams,
                            const StringVector &
                                                i_rDefinition ) = 0;
};



// IMPLEMENTATION

inline Define &
RwGate_Defines::Store_Define( const InputContext &          i_rContext,
							  const udmstri &               i_sName,
                              const StringVector &  i_rDefinition )
    { return do_Store_Define(i_rContext, i_sName, i_rDefinition); }
inline Macro &
RwGate_Defines::Store_Macro( const InputContext&            i_rContext,
							 const udmstri &                i_sName,
                             const StringVector &   i_rParams,
                            const StringVector &    i_rDefinition )
    { return do_Store_Macro(i_rContext, i_sName, i_rParams, i_rDefinition); }


}   // namespace cpp
}   // namespace ary



#endif

