/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: datetime.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:49:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COMPHELPER_DATETIME_HXX_
#include <comphelper/datetime.hxx>
#endif

//.........................................................................
namespace comphelper
{
//.........................................................................

//-------------------------------------------------------------------------
sal_Bool	operator ==(const starutil::DateTime& _rLeft, const starutil::DateTime& _rRight)
{
	return ( _rLeft.HundredthSeconds == _rRight.HundredthSeconds) &&
	( _rLeft.Seconds == _rRight.Seconds) &&
	( _rLeft.Minutes == _rRight.Minutes) &&
	( _rLeft.Hours == _rRight.Hours) &&
	( _rLeft.Day == _rRight.Day) &&
	( _rLeft.Month == _rRight.Month) &&
	( _rLeft.Year == _rRight.Year) ;
}

//-------------------------------------------------------------------------
sal_Bool	operator ==(const starutil::Date& _rLeft, const starutil::Date& _rRight)
{
	return ( _rLeft.Day == _rRight.Day) &&
	( _rLeft.Month == _rRight.Month) &&
	( _rLeft.Year == _rRight.Year) ;
}

//-------------------------------------------------------------------------
sal_Bool	operator ==(const starutil::Time& _rLeft, const starutil::Time& _rRight)
{
	return ( _rLeft.HundredthSeconds == _rRight.HundredthSeconds) &&
	( _rLeft.Seconds == _rRight.Seconds) &&
	( _rLeft.Minutes == _rRight.Minutes) &&
	( _rLeft.Hours == _rRight.Hours) ;
}

//.........................................................................
}	// namespace comphelper
//.........................................................................

