/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: nodeaddress.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:51:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CONFIGMGR_NODEADDRESS_HXX
#define CONFIGMGR_NODEADDRESS_HXX

#ifndef CONFIGMGR_POINTER_HXX
#include "pointer.hxx"
#endif

#ifndef INCLUDED_SHARABLE_NODE_HXX
#include "node.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory { class Accessor; }
// -----------------------------------------------------------------------------	
    namespace data
    {
    // -------------------------------------------------------------------------	
        using memory::Accessor;
    // -------------------------------------------------------------------------	
        class NodeAddress
	    {
            friend class NodeAccess;
            friend class NodeAccessRef;
        public:
            typedef sharable::Node      DataType;
            typedef memory::Pointer     AddressType;

        public:
            NodeAddress() : m_pData() {}

            explicit
            NodeAddress(AddressType _aNodeData) : m_pData(_aNodeData) {}

            bool is()       const { return m_pData.is(); }
            bool isNull()   const { return m_pData.isNull(); }

            AddressType::RawAddress addressValue() const { return m_pData.value(); }

            friend bool operator == (NodeAddress const& lhs, NodeAddress const& rhs)
            { return lhs.m_pData == rhs.m_pData; }

            friend bool operator != (NodeAddress const& lhs, NodeAddress const& rhs)
            { return lhs.m_pData != rhs.m_pData; }

        private:
		    AddressType                 m_pData;
        };
    // -------------------------------------------------------------------------

        class ValueNodeAddress
	    {
            friend class ValueNodeAccess;
        public:
            typedef sharable::ValueNode DataType;
            typedef memory::Pointer     AddressType;

            bool is()       const { return m_pData.is(); }
            bool isNull()   const { return m_pData.isNull(); }

            operator NodeAddress() const { return NodeAddress(m_pData); }
        private:
            explicit
            ValueNodeAddress(AddressType _aNodeData) : m_pData(_aNodeData) {}

		    AddressType m_pData;
        };
    // -------------------------------------------------------------------------

        class GroupNodeAddress
	    {
            friend class GroupNodeAccess;
        public:
            typedef sharable::GroupNode DataType;
            typedef memory::Pointer     AddressType;

            bool is()       const { return m_pData.is(); }
            bool isNull()   const { return m_pData.isNull(); }

            operator NodeAddress()        const { return NodeAddress(m_pData); }
        private:
            explicit
            GroupNodeAddress(AddressType _aNodeData) : m_pData(_aNodeData) {}

		    AddressType m_pData;
        };
    // -------------------------------------------------------------------------

        class SetNodeAddress
	    {
            friend class SetNodeAccess;
        public:
            typedef sharable::SetNode   DataType;
            typedef memory::Pointer     AddressType;

            bool is()       const { return m_pData.is(); }
            bool isNull()   const { return m_pData.isNull(); }

            operator NodeAddress()        const { return NodeAddress(m_pData); }
        private:
            explicit
            SetNodeAddress(AddressType _aNodeData) : m_pData(_aNodeData) {}

		    AddressType m_pData;
        };
    // -------------------------------------------------------------------------
    } 

// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_NODEADDRESS_HXX

