/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slideshow.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:21:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

#ifndef _CPPUHELPER_COMPBASE3_HXX_
#include <cppuhelper/compbase3.hxx>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _CPPUHELPER_IMPLEMENTATIONENTRY_HXX_
#include <cppuhelper/implementationentry.hxx>
#endif

#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#include <com/sun/star/presentation/XSlideShow.hpp>
#include <com/sun/star/presentation/XSlideShowView.hpp>

#include <presentation.hxx>


using namespace ::com::sun::star;

#define IMPLEMENTATION_NAME "Slideshow::SlideShow"
#define SERVICE_NAME "com.sun.star.presentation.SlideShow"

namespace
{
    static ::rtl::OUString SAL_CALL getImplementationName_SlideShow()
    {
        return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( IMPLEMENTATION_NAME ) );
    }

    static uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames_SlideShow()
    {
        uno::Sequence< ::rtl::OUString > aRet(1);
        aRet[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME ) );
        
        return aRet;
    }

}

namespace presentation
{
    typedef ::cppu::WeakComponentImplHelper3< ::com::sun::star::presentation::XSlideShow,
                                              lang::XServiceInfo,
                                              lang::XServiceName >  SlideShow_Base;

    // TODO
    class SlideShow : public ::comphelper::OBaseMutex,
                      public SlideShow_Base
    {
    public:
        static uno::Reference< uno::XInterface > SAL_CALL createInstance( const uno::Reference< uno::XComponentContext >& xContext ) throw ( uno::Exception )
        {
            return uno::Reference< uno::XInterface >( static_cast<cppu::OWeakObject*>(new SlideShow( xContext )) );
        }

	    /// Dispose all internal references
        virtual void SAL_CALL disposing();

        // XSlideShow
        virtual sal_Bool SAL_CALL nextEffect(  ) throw (uno::RuntimeException);
		virtual sal_Bool SAL_CALL startShapeActivity( const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException);
		virtual sal_Bool SAL_CALL stopShapeActivity( const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL previousSlide(  ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL nextSlide(  ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL displaySlide( sal_Int32 nSlideIndex ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL pause( sal_Bool bPauseShow ) throw (uno::RuntimeException);
		virtual sal_Int32 SAL_CALL getCurrentSlideIndex(  ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL show( const uno::Sequence< uno::Reference< drawing::XDrawPage > >& aSlideSequence, const uno::Sequence< uno::Reference< animations::XAnimationNode > >& aRootNodeSequence, ::sal_Int32 nStartSlideIndex, const uno::Sequence< beans::PropertyValue >& aShowProperties ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL setProperty( const beans::PropertyValue& aShowProperty ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL addView( const uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL removeView( const uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView ) throw (uno::RuntimeException);
        virtual sal_Bool SAL_CALL update( double& nNextTimeout ) throw (uno::RuntimeException);
        virtual void SAL_CALL addSlideShowListener( const uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener ) throw (uno::RuntimeException);
        virtual void SAL_CALL removeSlideShowListener( const uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener ) throw (uno::RuntimeException);
        virtual void SAL_CALL addShapeEventListener( const uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& xListener, const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException);
        virtual void SAL_CALL removeShapeEventListener( const uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& xListener, const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException);
        virtual void SAL_CALL setShapeCursor( const uno::Reference< drawing::XShape >& xShape, sal_Int16 nPointerShape ) throw (uno::RuntimeException);

        // XServiceInfo
        virtual ::rtl::OUString SAL_CALL getImplementationName() throw( uno::RuntimeException );
        virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw( uno::RuntimeException );
        virtual uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames()  throw( uno::RuntimeException );

        // XServiceName
        virtual ::rtl::OUString SAL_CALL getServiceName(  ) throw (uno::RuntimeException);

    protected:
        ~SlideShow(); // we're a ref-counted UNO class. _We_ destroy ourselves.

    private:
        // default: disabled copy/assignment
        SlideShow(const SlideShow&);
        SlideShow& operator=( const SlideShow& );

        SlideShow( const uno::Reference< uno::XComponentContext >& rxContext );

        Presentation maPresentation;
    };

    SlideShow::SlideShow( const uno::Reference< uno::XComponentContext >& rxContext ) :
        SlideShow_Base( m_aMutex ),
        maPresentation( rxContext )
    {
    }

    SlideShow::~SlideShow()
    {
        SHARED_PTR_LEFTOVERS( "SlideShow::~SlideShow()" );
    }

	void SAL_CALL SlideShow::disposing()
	{
		maPresentation.dispose();

        SHARED_PTR_LEFTOVERS( "SlideShow::disposing() done" );		
	}

    // XSlideShow
    sal_Bool SAL_CALL SlideShow::nextEffect(  ) throw (uno::RuntimeException)
    {        
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.nextEffect();
    }

	sal_Bool SAL_CALL SlideShow::startShapeActivity( const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException)
	{
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.startShapeActivity( xShape );
	}

	sal_Bool SAL_CALL SlideShow::stopShapeActivity( const uno::Reference< drawing::XShape >& xShape ) throw (uno::RuntimeException)
	{
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.stopShapeActivity( xShape );
	}

    sal_Bool SAL_CALL SlideShow::previousSlide(  ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.previousSlide();
    }

    sal_Bool SAL_CALL SlideShow::nextSlide(  ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.nextSlide();
    }

    sal_Bool SAL_CALL SlideShow::displaySlide( sal_Int32 nSlideIndex ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.displaySlide( nSlideIndex );
    }

	sal_Bool SAL_CALL SlideShow::pause( sal_Bool bPauseShow ) throw (uno::RuntimeException)
	{
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.pause( bPauseShow );
	}

    sal_Int32 SAL_CALL SlideShow::getCurrentSlideIndex(  ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.getCurrentSlideIndex();
    }

    sal_Bool SAL_CALL SlideShow::show( const uno::Sequence< uno::Reference< drawing::XDrawPage > >& 		aSlideSequence, 
                                       const uno::Sequence< uno::Reference< animations::XAnimationNode > >& aRootNodeSequence, 
                                       ::sal_Int32 															nStartSlideIndex, 
                                       const uno::Sequence< beans::PropertyValue >& 						aShowProperties ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        if( !maPresentation.prefetch( aSlideSequence,
                                      aRootNodeSequence,
                                      aShowProperties ) )
        {
            return false;
        }

        return maPresentation.displaySlide( nStartSlideIndex );
    }

    sal_Bool SAL_CALL SlideShow::setProperty( const beans::PropertyValue& aShowProperty ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.setProperty( aShowProperty );
    }

    sal_Bool SAL_CALL SlideShow::addView( const uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.addView( xView );
    }

    sal_Bool SAL_CALL SlideShow::removeView( const uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.removeView( xView );
    }

    sal_Bool SAL_CALL SlideShow::update( double& nNextTimeout ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        return maPresentation.update( &nNextTimeout );
    }

    void SAL_CALL SlideShow::addSlideShowListener( const uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        maPresentation.addSlideShowListener( xListener );
    }

    void SAL_CALL SlideShow::removeSlideShowListener( const uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        maPresentation.removeSlideShowListener( xListener );
    }

    void SAL_CALL SlideShow::addShapeEventListener( const uno::Reference< ::com::sun::star::presentation::XShapeEventListener >&	xListener, 
                                                    const uno::Reference< drawing::XShape >& 										xShape ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        maPresentation.addShapeEventListener( xListener,
                                              xShape );
    }

    void SAL_CALL SlideShow::removeShapeEventListener( const uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& xListener, 
                                                       const uno::Reference< drawing::XShape >& 									xShape ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        maPresentation.removeShapeEventListener( xListener,
                                                 xShape );
    }

    void SAL_CALL SlideShow::setShapeCursor( const uno::Reference< drawing::XShape >& xShape, sal_Int16 nPointerId ) throw (uno::RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        maPresentation.setShapeCursor( xShape, nPointerId );
    }

    // XServiceInfo
    ::rtl::OUString SAL_CALL SlideShow::getImplementationName() throw( uno::RuntimeException )
    {
        return getImplementationName_SlideShow();
    }

    sal_Bool SAL_CALL SlideShow::supportsService( const ::rtl::OUString& ServiceName ) throw( uno::RuntimeException )
    {
        return ServiceName.equalsIgnoreAsciiCaseAscii( SERVICE_NAME );
    }

    uno::Sequence< ::rtl::OUString > SAL_CALL SlideShow::getSupportedServiceNames()  throw( uno::RuntimeException )
    {
        return getSupportedServiceNames_SlideShow();
    }

    // XServiceName
    ::rtl::OUString SAL_CALL SlideShow::getServiceName(  ) throw (uno::RuntimeException)
    {
        return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( SERVICE_NAME ) );
    }
}

namespace
{
	/* shared lib exports implemented with helpers */
    static struct ::cppu::ImplementationEntry s_component_entries [] =
    {
        {
            ::presentation::SlideShow::createInstance, getImplementationName_SlideShow,
            getSupportedServiceNames_SlideShow, ::cppu::createSingleComponentFactory,
            0, 0
        },
        { 0, 0, 0, 0, 0, 0 }
    };
}


/* Exported UNO methods for registration and object creation.
   ==========================================================
 */
extern "C"
{
    void SAL_CALL component_getImplementationEnvironment( const sal_Char** 	ppEnvTypeName, 
                                                          uno_Environment** ppEnv )
    {
        *ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
    }

    sal_Bool SAL_CALL component_writeInfo( lang::XMultiServiceFactory* 	xMgr, 
                                           registry::XRegistryKey* 		xRegistry )
    {
        return ::cppu::component_writeInfoHelper(
            xMgr, xRegistry, s_component_entries );
    }

    void * SAL_CALL component_getFactory( sal_Char const* 				implName, 
                                          lang::XMultiServiceFactory* 	xMgr,
                                          registry::XRegistryKey* 		xRegistry )
    {
        return ::cppu::component_getFactoryHelper(
            implName, xMgr, xRegistry, s_component_entries );
    }
}
