/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shapeimporter.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:29:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>

#ifndef _COM_SUN_STAR_DOCUMENT_XEXPORTER_HPP_
#include <com/sun/star/document/XExporter.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XFILTER_HPP_
#include <com/sun/star/document/XFilter.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGESSUPPLIER_HPP_
#include <com/sun/star/drawing/XDrawPagesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGE_HPP_
#include <com/sun/star/drawing/XDrawPage.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XMASTERPAGETARGET_HPP_
#include <com/sun/star/drawing/XMasterPageTarget.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_CLICKACTION_HPP_
#include <com/sun/star/presentation/ClickAction.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _SV_GDIMTF_HXX 
#include <vcl/gdimtf.hxx>
#endif
#ifndef _SV_METAACT_HXX 
#include <vcl/metaact.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_CVTGRF_HXX
#include <vcl/cvtgrf.hxx>
#endif
#ifndef _GRFMGR_HXX 
#include <goodies/grfmgr.hxx>
#endif
#ifndef _COM_SUN_STAR_DRAWING_COLORMODE_HPP_
#include <com/sun/star/drawing/ColorMode.hpp>
#endif 
#ifndef _COM_SUN_STAR_TEXT_GRAPHICCROP_HPP_
#include <com/sun/star/text/GraphicCrop.hpp>
#endif 
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX 
#include <unotools/ucbstreamhelper.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <vector>
#include <iterator>
#include <algorithm>

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif
#ifndef BOOST_SCOPED_PTR_HPP_INCLUDED 
#include <boost/scoped_ptr.hpp>
#endif

#include <drawshape.hxx>
#include <mediashape.hxx>
#include <shapeimporter.hxx>
#include <slideshowexceptions.hxx>
#include <gdimtftools.hxx>


using namespace ::com::sun::star;

// -----------------------------------------------------------------------------

namespace presentation
{
    namespace internal
    {
        ShapeImporter::ShapeImporter( const uno::Reference< drawing::XDrawPage >&	xPage, 
                                      const uno::Reference< drawing::XDrawPage >&	xActualPage, 
                                      sal_Int32										nOrdNumStart,
                                      bool 											bConvertingMasterPage ) :
            mxPage( xActualPage ),
            mxShapes( xPage,
                      uno::UNO_QUERY_THROW ),
            mnCurrShape( 0 ),
            mnNumShapes( mxShapes->getCount() ),
            mnOrdNumStart( nOrdNumStart ),
            mbConvertingMasterPage( bConvertingMasterPage )
        {
        }

        bool ShapeImporter::isSkip( const uno::Reference< drawing::XShape >&     xCurrShape,
                                    const uno::Reference< beans::XPropertySet >& xPropSet ) const
        {
            // skip empty presentation objects
            sal_Bool bEmpty;
            xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("IsEmptyPresentationObject") ) ) >>= bEmpty;
            if( bEmpty )
                return true;

            // don't export presentation placeholders on masterpage
            // they can be non empty when user edits the default texts
            if( mbConvertingMasterPage )
            {
                ::rtl::OUString aShapeType( xCurrShape->getShapeType() );
                if( (0 == aShapeType.reverseCompareToAsciiL( RTL_CONSTASCII_STRINGPARAM( "com.sun.star.presentation.TitleTextShape" ))) ||
                    (0 == aShapeType.reverseCompareToAsciiL( RTL_CONSTASCII_STRINGPARAM( "com.sun.star.presentation.OutlinerShape" ))))
                {
                    return true;
                }
            }

            return false;
        }

        namespace
        {
            bool importShapeGraphic( GraphicObject&									o_rGraphic,
                                     const uno::Reference< beans::XPropertySet >& 	rPropSet	)
            {
                ::rtl::OUString aURL;

                if( !(rPropSet->getPropertyValue( 
                          ::rtl::OUString( 
                              RTL_CONSTASCII_USTRINGPARAM("GraphicURL") ) ) >>= aURL) ||
                    aURL.getLength() == 0 )
                {
                    // no or empty property - cannot import shape graphic
                    return false;
                }

                ::rtl::OUString aVndUrl( 
                    RTL_CONSTASCII_USTRINGPARAM( "vnd.sun.star.GraphicObject:" ) );
                sal_Int32 nIndex( aURL.indexOf( aVndUrl ) );

                if( nIndex != -1 )
                {
                    // skip past the end of the "vnd..." prefix
                    nIndex += aVndUrl.getLength();

                    ENSURE_AND_RETURN( aURL.getLength() > nIndex,
                                       "ShapeImporter::importShape(): embedded graphic has no graphic ID" );

                    // unique ID string found in URL, extract
                    // to separate string
                    const ::rtl::OUString aUniqueId( aURL.copy( nIndex, 
                                                                aURL.getLength() - nIndex ) );

                    // TODO(T2): Creating a GraphicObject is not
                    // thread safe (internally calls VCL, and has
                    // unguarded internal singleton mpGlobalMgr)

                    // fetch already loaded graphic from graphic manager.
                    const ByteString aOldString( (String)aUniqueId,
                                                 RTL_TEXTENCODING_UTF8 );
                    o_rGraphic = GraphicObject( aOldString );
                }
                else
                {
                    // no special string found, graphic must be
                    // external. Load via GraphicImporter
                    INetURLObject   			  aTmp( aURL );
                    ::boost::scoped_ptr<SvStream> pGraphicStream( ::utl::UcbStreamHelper::CreateStream(
                                                                      aTmp.GetMainURL( INetURLObject::NO_DECODE ), 
                                                                      STREAM_READ ) );
                    ENSURE_AND_RETURN( pGraphicStream.get(),
                                       "ShapeImporter::importShape(): cannot create input stream for graphic" );

                    Graphic aTmpGraphic;
                    ENSURE_AND_RETURN( ERRCODE_NONE == GraphicConverter::Import( *pGraphicStream, 
                                                                                 aTmpGraphic ),
                                       "ShapeImporter::importShape(): Failed to import shape graphic from given URL" );

                    o_rGraphic = GraphicObject( aTmpGraphic );
                }

                return true;
            }

            template< typename ValueType > bool getProp( ValueType& 									o_rValue, 
                                                         const uno::Reference< beans::XPropertySet >&	rPropSet, 
                                                         const ::rtl::OUString&							rPropName )
            {
                try
                {
                    return (rPropSet->getPropertyValue( rPropName ) >>= o_rValue);
                }
                catch( uno::Exception& )
                {
                    return false;
                }
            }

        }

        ShapeSharedPtr ShapeImporter::importShape() // throw (ImportFailedException)
        {
            uno::Reference< drawing::XShape > 		xCurrShape;
            uno::Reference< beans::XPropertySet > 	xPropSet;
                
            do
            {
                // avoid accessing beyond the end of the shapes
                if( isImportDone() )
                    return ShapeSharedPtr();

                mxShapes->getByIndex( mnCurrShape++ ) >>= xCurrShape;

                xPropSet.set( xCurrShape, uno::UNO_QUERY );

                if( !xPropSet.is() )
                    throw ImportFailedException(); 	   // we definitely need the properties of 
                									   // the shape here. This will also fail,
                									   // if getByIndex did not return a valid
                									   // shape
            }
            // is this shape presentation-invisible?
            while( isSkip( xCurrShape, xPropSet ) );


            // create actual shape implementation, depending on shape
            // type
            // ------------------------------------------------------

			if( 0 == xCurrShape->getShapeType().reverseCompareToAsciiL( 
					RTL_CONSTASCII_STRINGPARAM("com.sun.star.drawing.MediaShape") ) )
			{
                // Media shape (video etc.). This is a special object
            	return ShapeSharedPtr( new MediaShape( xCurrShape, 
                                                       mxPage,
                	                                   mnOrdNumStart+mnCurrShape ) );
			}
            else if( 0 == xCurrShape->getShapeType().reverseCompareToAsciiL(
                         RTL_CONSTASCII_STRINGPARAM("com.sun.star.drawing.GraphicObjectShape") ) )
            {
                GraphicObject aGraphicObject;

                // to get hold of GIF animations, inspect Graphic
                // objects more thoroughly (the plain-jane shape
                // metafile of course would only contain the first
                // animation frame)
                if( !importShapeGraphic( aGraphicObject,
                                         xPropSet ) ||
                    !aGraphicObject.IsAnimated() )
                {
                    // import failed or no animation - fallback to
                    // plain draw shape import

                    // import shape as bitmap - either its a bitmap
                    // anyway, or its a metafile, which currently the
                    // metafile renderer might not display correctly.
                    return ShapeSharedPtr( new DrawShape( xCurrShape, 
                                                          mxPage,
                                                          mnOrdNumStart+mnCurrShape,
                                                          true ) );
                }


                // now extract relevant shape attributes via API
                // ---------------------------------------------

                drawing::ColorMode eColorMode( drawing::ColorMode_STANDARD );
                sal_Int16 nLuminance(0);
                sal_Int16 nContrast(0);
                sal_Int16 nRed(0);
                sal_Int16 nGreen(0);
                sal_Int16 nBlue(0);
                double 	  nGamma(1.0);
                sal_Int16 nTransparency(0);
                sal_Int32 nRotation(0);

                getProp( eColorMode, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "GraphicColorMode" ) ) );
                getProp( nLuminance, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AdjustLuminance" ) ) );
                getProp( nContrast, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AdjustContrast" ) ) );
                getProp( nRed, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AdjustRed" ) ) );
                getProp( nGreen, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AdjustGreen" ) ) );
                getProp( nBlue, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AdjustBlue" ) ) );
                getProp( nGamma, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Gamma" ) ) );
                getProp( nTransparency, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Transparency" ) ) );
                getProp( nRotation, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "RotateAngle" ) ) );

                GraphicAttr aGraphAttrs;
                aGraphAttrs.SetDrawMode( (GraphicDrawMode)eColorMode );
                aGraphAttrs.SetLuminance( nLuminance );
                aGraphAttrs.SetContrast( nContrast );
                aGraphAttrs.SetChannelR( nRed );
                aGraphAttrs.SetChannelG( nGreen );
                aGraphAttrs.SetChannelB( nBlue );
                aGraphAttrs.SetGamma( nGamma );
                aGraphAttrs.SetTransparency( static_cast<BYTE>(nTransparency) );
                aGraphAttrs.SetRotation( static_cast<USHORT>(nRotation*10) );

                text::GraphicCrop aGraphCrop;
                if( getProp( aGraphCrop, xPropSet, ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "GraphicCrop" ) ) ) )
				{
                    aGraphAttrs.SetCrop( aGraphCrop.Left,
                                         aGraphCrop.Top,
                                         aGraphCrop.Right,
                                         aGraphCrop.Bottom );
				} 

                // fetch readily transformed and color-modified
                // graphic
                // ---------------------------------------------

                Graphic aGraphic( 
                    aGraphicObject.GetTransformedGraphic( aGraphicObject.GetPrefSize(),
                                                          aGraphicObject.GetPrefMapMode(),
                                                          aGraphAttrs ) );

            	return ShapeSharedPtr( new DrawShape( xCurrShape, 
                                                      mxPage,
                	                                  mnOrdNumStart+mnCurrShape,
                                                      aGraphic ) );
            }
            else if( 0 == xCurrShape->getShapeType().reverseCompareToAsciiL(
                         RTL_CONSTASCII_STRINGPARAM("com.sun.star.drawing.OLE2Shape") ) )
            {
                // #i46224# Import OLE shapes as a single bitmap;
                // currently, the metafile-to-canvas converted has a
                // few deficiencies (most important: no raster ops)
            	return ShapeSharedPtr( new DrawShape( xCurrShape, 
                                                      mxPage,
                	                                  mnOrdNumStart+mnCurrShape,
                                                      true ) );
            }
			else
			{
            	return ShapeSharedPtr( new DrawShape( xCurrShape, 
                                                      mxPage,
                	                                  mnOrdNumStart+mnCurrShape,
                                                      false ) );
			}
        }

        bool ShapeImporter::isImportDone() const
        {
            return mnCurrShape >= mnNumShapes;
        }

    }
}
