/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shapeeventbroadcaster.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:18:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_SHAPEEVENTBROADCASTER_HXX
#define _SLIDESHOW_SHAPEEVENTBROADCASTER_HXX

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <shape.hxx>
#include <eventmultiplexer.hxx>

namespace com { namespace sun { namespace star { namespace presentation
{
    class XShapeEventListener;
} } } }

/* Definition of ShapeEventBroadcaster class */

namespace presentation
{
    namespace internal
    {
        class ShapeClickHandler;
        class MoveHandler;

		/** Listener class for shape events

			This helper class registers itself on each view, and 
			broadcasts the XShapeEventListener events. The mouse motion
			events are needed for setting the shape cursor.
		*/
		class ShapeEventBroadcaster
		{
		public:
            /** Create a shape event broadcaster

            	@param rEventMultiplexer
                The slideshow-global event source, where this class
                registeres its event handlers.
            */
			ShapeEventBroadcaster( EventMultiplexer& rMultiplexer );
            ~ShapeEventBroadcaster(); // outline, because of shared_ptr forward decl

            void addShapeEventListener( const ::com::sun::star::uno::Reference< 
                                        		::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                        const ::com::sun::star::uno::Reference< 
                                        			::com::sun::star::drawing::XShape >& 				xShape,
                                        const ShapeSharedPtr&											rShape );

            void removeShapeEventListener( const ::com::sun::star::uno::Reference< 
                                           			::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                           const ::com::sun::star::uno::Reference< 
                                           			::com::sun::star::drawing::XShape >& 					xShape,
                                           const ShapeSharedPtr&											rShape );

            void setShapeCursor( const ShapeSharedPtr&	rShape, 
                                 sal_Int16 				nPointerShape );

            /** Set a new current slide index.

            	The slide index is used when notifying shape clicks,
            	as a parameter of the XShapeEventListener::click() call.
             */
            void setSlideIndex( sal_Int32 nNewIndex );

		private:
            ::boost::shared_ptr<ShapeClickHandler>	mpShapeClickHandler;
            ::boost::shared_ptr<MoveHandler>		mpMoveHandler;
            EventMultiplexer& 						mrMultiplexer;
            sal_Int32								mnSlideIndex;
		};

        typedef ::boost::shared_ptr< ShapeEventBroadcaster > ShapeEventBroadcasterSharedPtr;
    }
}

#endif /* _SLIDESHOW_SHAPEEVENTBROADCASTER_HXX */
