/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vclxaccessibletoolbox.cxx,v $
 *
 *  $Revision: 1.36 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:11:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#ifndef _TOOLKIT_AWT_VCLXACCESSIBLETOOLBOX_HXX_
#include <toolkit/awt/vclxaccessibletoolbox.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXACCESSIBLETOOLBOXITEM_HXX_
#include <toolkit/awt/vclxaccessibletoolboxitem.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif

#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef COMPHELPER_ACCESSIBLE_WRAPPER_HXX
#include <comphelper/accessiblewrapper.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

using namespace ::comphelper;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::accessibility;

namespace
{
	// =========================================================================
	// = OToolBoxWindowItemContext
	// =========================================================================
	/** XAccessibleContext implementation for a toolbox item which is represented by a VCL Window
	*/
	class OToolBoxWindowItemContext : public OAccessibleContextWrapper
	{
		sal_Int32 m_nIndexInParent;
	public:
		OToolBoxWindowItemContext(sal_Int32 _nIndexInParent,
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext >& _rxInnerAccessibleContext,
			const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxOwningAccessible,
			const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxParentAccessible
			) : OAccessibleContextWrapper(
			_rxORB,
			_rxInnerAccessibleContext,
			_rxOwningAccessible,
			_rxParentAccessible		)
			,m_nIndexInParent(_nIndexInParent)
		{
		}
		virtual sal_Int32 SAL_CALL getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException);
	};

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OToolBoxWindowItemContext::getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );
		return m_nIndexInParent;
	}

	// =========================================================================
	// = OToolBoxWindowItem
	// =========================================================================
	typedef ::cppu::ImplHelper1	<	XUnoTunnel
								>	OToolBoxWindowItem_Base;

	/** XAccessible implementation for a toolbox item which is represented by a VCL Window
	*/
	class OToolBoxWindowItem
			:public OAccessibleWrapper
			,public OToolBoxWindowItem_Base
	{
	private:
		sal_Int32 m_nIndexInParent;

	public:
		inline sal_Int32	getIndexInParent() const					{ return m_nIndexInParent; }
		inline void			setIndexInParent( sal_Int32 _nNewIndex )	{ m_nIndexInParent = _nNewIndex; }

        static	sal_Bool	isWindowItem( const Reference< XAccessible >& _rxAcc, OToolBoxWindowItem** /* [out] */ _ppImplementation = NULL );

	public:
		OToolBoxWindowItem(sal_Int32 _nIndexInParent,
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxInnerAccessible,
			const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxParentAccessible
			) : OAccessibleWrapper(
			_rxORB,
			_rxInnerAccessible,
			_rxParentAccessible)
			,m_nIndexInParent(_nIndexInParent)
		{
		}

	protected:
		// XInterface
		DECLARE_XINTERFACE( )
		DECLARE_XTYPEPROVIDER( )

		// OAccessibleWrapper
		virtual OAccessibleContextWrapper* createAccessibleContext(
				const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext >& _rxInnerContext
			);

		// XUnoTunnel
		virtual sal_Int64 SAL_CALL getSomething( const Sequence< sal_Int8 >& aIdentifier ) throw (RuntimeException);
		static Sequence< sal_Int8 > getUnoTunnelImplementationId();
	};

	// -------------------------------------------------------------------------
	IMPLEMENT_FORWARD_XINTERFACE2( OToolBoxWindowItem, OAccessibleWrapper, OToolBoxWindowItem_Base )
	IMPLEMENT_FORWARD_XTYPEPROVIDER2( OToolBoxWindowItem, OAccessibleWrapper, OToolBoxWindowItem_Base )

	// -------------------------------------------------------------------------
	OAccessibleContextWrapper* OToolBoxWindowItem::createAccessibleContext(
			const Reference< XAccessibleContext >& _rxInnerContext )
	{
		return new OToolBoxWindowItemContext( m_nIndexInParent,getORB(), _rxInnerContext, this, getParent() );
	}

	//--------------------------------------------------------------------
	sal_Bool OToolBoxWindowItem::isWindowItem( const Reference< XAccessible >& _rxAcc, OToolBoxWindowItem** /* [out] */ _ppImplementation )
	{
		OToolBoxWindowItem* pImplementation = NULL;

		Reference< XUnoTunnel > xTunnel( _rxAcc, UNO_QUERY );
		if ( xTunnel.is() )
			pImplementation = reinterpret_cast< OToolBoxWindowItem* >( xTunnel->getSomething( getUnoTunnelImplementationId() ) );

		if ( _ppImplementation )
			*_ppImplementation = pImplementation;

		return NULL != pImplementation;
	}

	//--------------------------------------------------------------------
	Sequence< sal_Int8 > OToolBoxWindowItem::getUnoTunnelImplementationId()
	{
		static ::cppu::OImplementationId * pId = 0;
		if (! pId)
		{
			::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
			if (! pId)
			{
				static ::cppu::OImplementationId aId;
				pId = &aId;
			}
		}
		return pId->getImplementationId();
	}

	//--------------------------------------------------------------------
	sal_Int64 SAL_CALL OToolBoxWindowItem::getSomething( const Sequence< sal_Int8 >& _rId ) throw (RuntimeException)
	{
		if	(	( 16 == _rId.getLength() )
			&&	( 0 == rtl_compareMemory( getUnoTunnelImplementationId().getConstArray(),  _rId.getConstArray(), 16 ) )
			)
			return reinterpret_cast< sal_Int64>( this );

		return 0;
	}
}

DBG_NAME(VCLXAccessibleToolBox)

// -----------------------------------------------------------------------------
// VCLXAccessibleToolBox
// -----------------------------------------------------------------------------
VCLXAccessibleToolBox::VCLXAccessibleToolBox( VCLXWindow* pVCLXWindow ) :

	VCLXAccessibleComponent( pVCLXWindow )

{
	DBG_CTOR(VCLXAccessibleToolBox,NULL);
}
// -----------------------------------------------------------------------------
VCLXAccessibleToolBox::~VCLXAccessibleToolBox()
{
	DBG_DTOR(VCLXAccessibleToolBox,NULL);
}
// -----------------------------------------------------------------------------
VCLXAccessibleToolBoxItem* VCLXAccessibleToolBox::GetItem_Impl( sal_Int32 _nPos, bool _bMustHaveFocus )
{
	VCLXAccessibleToolBoxItem* pItem = NULL;
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox && ( !_bMustHaveFocus || pToolBox->HasFocus() ) )
	{
		ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.find( _nPos );
		// returns only toolbox buttons, not windows
		if ( aIter != m_aAccessibleChildren.end()  && !aIter->second.is())
			pItem =	static_cast< VCLXAccessibleToolBoxItem* >( aIter->second.get() );
	}

	return pItem;
}
// -----------------------------------------------------------------------------

void VCLXAccessibleToolBox::UpdateFocus_Impl()
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox && pToolBox->HasFocus() )
	{
		USHORT nHighlightItemId = pToolBox->GetHighlightItemId();
		USHORT nFocusCount = 0;
        for ( ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.begin();
			  aIter != m_aAccessibleChildren.end(); ++aIter )
		{
            USHORT nItemId = pToolBox->GetItemId( (USHORT)aIter->first );

            if ( aIter->second.is() )
            {
                VCLXAccessibleToolBoxItem* pItem =
                    static_cast< VCLXAccessibleToolBoxItem* >( aIter->second.get() );
                if ( pItem->HasFocus() && nItemId != nHighlightItemId )
                {
                    // reset the old focused item
                    pItem->SetFocus( sal_False );
                    nFocusCount++;
                }
                if ( nItemId == nHighlightItemId )
                {
                    // set the new focused item
                    pItem->SetFocus( sal_True );
                    nFocusCount++;
                }
            }
        // both items changed?
        if ( nFocusCount > 1 )
            break;
        }
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::ReleaseFocus_Impl( sal_Int32 _nPos )
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox ) // #107124#, do not check for focus because this message is also handled in losefocus
	{
		USHORT nItemId = pToolBox->GetItemId( (USHORT)_nPos );

        ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.find( _nPos );
        if ( aIter != m_aAccessibleChildren.end() && aIter->second.is() )
        {
            VCLXAccessibleToolBoxItem* pItem =
                static_cast< VCLXAccessibleToolBoxItem* >( aIter->second.get() );
            if ( pItem->HasFocus() )
                pItem->SetFocus( sal_False );
        }
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateChecked_Impl( sal_Int32 _nPos )
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
	    for ( ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.begin();
			  aIter != m_aAccessibleChildren.end(); ++aIter )
		{
				USHORT nItemId = pToolBox->GetItemId( (USHORT)aIter->first );

                VCLXAccessibleToolBoxItem* pItem =
                    static_cast< VCLXAccessibleToolBoxItem* >( aIter->second.get() );
                pItem->SetChecked( pToolBox->IsItemChecked( nItemId ) );
        }
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateIndeterminate_Impl( sal_Int32 _nPos )
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
		USHORT nItemId = pToolBox->GetItemId( (USHORT)_nPos );

        ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.find( _nPos );
        if ( aIter != m_aAccessibleChildren.end() && aIter->second.is() )
        {
            VCLXAccessibleToolBoxItem* pItem =
                static_cast< VCLXAccessibleToolBoxItem* >( aIter->second.get() );
            if ( pItem )
                pItem->SetIndeterminate( pToolBox->GetItemState( nItemId ) == STATE_DONTKNOW );
        }
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::implReleaseToolboxItem( ToolBoxItemsMap::iterator& _rMapPos,
		bool _bNotifyRemoval, bool _bDispose )
{
	Reference< XAccessible > xItemAcc( _rMapPos->second );
	if ( !xItemAcc.is() )
		return;

	if ( _bNotifyRemoval )
	{
		NotifyAccessibleEvent( AccessibleEventId::CHILD, makeAny( xItemAcc ), Any() );
	}

    OToolBoxWindowItem* pWindowItem = NULL;
    if ( !OToolBoxWindowItem::isWindowItem( xItemAcc, &pWindowItem ) )
	{
		static_cast< VCLXAccessibleToolBoxItem* >( xItemAcc.get() )->ReleaseToolBox();
		if ( _bDispose )
			::comphelper::disposeComponent( xItemAcc );
	}
	else
	{
		if ( _bDispose )
		{
			if ( pWindowItem )
			{
				Reference< XAccessibleContext > xContext( pWindowItem->getContextNoCreate() );
				::comphelper::disposeComponent( xContext );
			}
		}
	}
}

// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateItem_Impl( sal_Int32 _nPos, sal_Bool _bItemAdded )
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
		if ( !_bItemAdded )
		{	// the item was removed
			// -> destroy the old item
			ToolBoxItemsMap::iterator aItemPos = m_aAccessibleChildren.find( _nPos );
			if ( m_aAccessibleChildren.end() != aItemPos )
			{
				implReleaseToolboxItem( aItemPos, true, true );
				m_aAccessibleChildren.erase( aItemPos );
			}
		}

		// adjust the "index-in-parent"s
		ToolBoxItemsMap::iterator aIndexAdjust = m_aAccessibleChildren.upper_bound( _nPos );
		while ( m_aAccessibleChildren.end() != aIndexAdjust )
		{
			Reference< XAccessible > xItemAcc( aIndexAdjust->second );

            OToolBoxWindowItem* pWindowItem = NULL;
            if ( !OToolBoxWindowItem::isWindowItem( xItemAcc, &pWindowItem ) )
			{
				VCLXAccessibleToolBoxItem* pItem = static_cast< VCLXAccessibleToolBoxItem* >( xItemAcc.get() );
				if ( pItem )
				{
					sal_Int32 nIndex = pItem->getIndexInParent( );
					nIndex += _bItemAdded ? +1 : -1;
					pItem->setIndexInParent( nIndex );
				}
			}
			else
			{
				if ( pWindowItem )
				{
					sal_Int32 nIndex = pWindowItem->getIndexInParent( );
					nIndex += _bItemAdded ? +1 : -1;
					pWindowItem->setIndexInParent( nIndex );
				}
			}

			++aIndexAdjust;
		}

		if ( _bItemAdded )
		{
			// TODO: we should make this dependent on the existence of event listeners
			// with the current implementation, we always create accessible object
			Any aNewChild = makeAny( getAccessibleChild( (sal_Int32)_nPos ) );
			NotifyAccessibleEvent( AccessibleEventId::CHILD, Any(), aNewChild );
		}
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateAllItems_Impl()
{
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
		// deregister the old items
    	for ( ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.begin();
		  	  aIter != m_aAccessibleChildren.end(); ++aIter )
		{
			implReleaseToolboxItem( aIter, true, true );
		}
		m_aAccessibleChildren.clear();

		// register the new items
	    USHORT i, nCount = pToolBox->GetItemCount();
		for ( i = 0; i < nCount; ++i )
		{
			Any aNewValue;
			aNewValue <<= getAccessibleChild( (sal_Int32)i );;
			NotifyAccessibleEvent( AccessibleEventId::CHILD, Any(), aNewValue );
		}
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateItemName_Impl( sal_Int32 _nPos )
{
	VCLXAccessibleToolBoxItem* pItem = GetItem_Impl( _nPos, false );
	if ( pItem )
		pItem->NameChanged();
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::UpdateItemEnabled_Impl( sal_Int32 _nPos )
{
	VCLXAccessibleToolBoxItem* pItem = GetItem_Impl( _nPos, false );
	if ( pItem )
		pItem->ToggleEnableState();
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::FillAccessibleStateSet( utl::AccessibleStateSetHelper& rStateSet )
{
	VCLXAccessibleComponent::FillAccessibleStateSet( rStateSet );

    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
        rStateSet.AddState( AccessibleStateType::FOCUSABLE );
		if ( pToolBox->IsHorizontal() )
	        rStateSet.AddState( AccessibleStateType::HORIZONTAL );
		else
	        rStateSet.AddState( AccessibleStateType::VERTICAL );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::ProcessWindowEvent( const VclWindowEvent& rVclWindowEvent )
{
	// to prevent an early release of the toolbox (VCLEVENT_OBJECT_DYING)
	Reference< XAccessible > xTemp = this;

	switch ( rVclWindowEvent.GetId() )
	{
		case VCLEVENT_TOOLBOX_CLICK:
        {
			if ( rVclWindowEvent.GetData() )
            {
				UpdateChecked_Impl( (sal_Int32)rVclWindowEvent.GetData() );
                UpdateIndeterminate_Impl( (sal_Int32)rVclWindowEvent.GetData() );
            }
			break;
        }
		case VCLEVENT_TOOLBOX_DOUBLECLICK:
		case VCLEVENT_TOOLBOX_ACTIVATE:
		case VCLEVENT_TOOLBOX_DEACTIVATE:
    	case VCLEVENT_TOOLBOX_SELECT:
			break;

		case VCLEVENT_TOOLBOX_HIGHLIGHT:
			UpdateFocus_Impl();
			break;

		case VCLEVENT_TOOLBOX_HIGHLIGHTOFF:
			ReleaseFocus_Impl( (sal_Int32)rVclWindowEvent.GetData() );
			break;

		case VCLEVENT_TOOLBOX_ITEMADDED :
		case VCLEVENT_TOOLBOX_ITEMREMOVED :
			UpdateItem_Impl( (sal_Int32)rVclWindowEvent.GetData(), VCLEVENT_TOOLBOX_ITEMADDED == rVclWindowEvent.GetId() );
			break;

		case VCLEVENT_TOOLBOX_ALLITEMSCHANGED :
		{
			UpdateAllItems_Impl();
			break;
		}
		case VCLEVENT_TOOLBOX_ITEMWINDOWCHANGED:
		{
			sal_Int32 nPos = (sal_Int32)rVclWindowEvent.GetData();
			ToolBoxItemsMap::iterator aAccessiblePos( m_aAccessibleChildren.find( nPos ) );
			if ( m_aAccessibleChildren.end() != aAccessiblePos )
            {
				implReleaseToolboxItem( aAccessiblePos, false, true );
                m_aAccessibleChildren.erase (aAccessiblePos);
            }

			Any aNewValue;
			aNewValue <<= getAccessibleChild(nPos);
			NotifyAccessibleEvent( AccessibleEventId::CHILD, Any(), aNewValue );
			break;
		}
		case VCLEVENT_TOOLBOX_ITEMTEXTCHANGED :
			UpdateItemName_Impl( (sal_Int32)rVclWindowEvent.GetData() );
			break;

		case VCLEVENT_TOOLBOX_ITEMENABLED :
		case VCLEVENT_TOOLBOX_ITEMDISABLED :
		{
			UpdateItemEnabled_Impl( (sal_Int32)rVclWindowEvent.GetData() );
			break;
		}

		case VCLEVENT_OBJECT_DYING :
		{
			// dispose all items
    		for ( ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.begin();
				  aIter != m_aAccessibleChildren.end(); ++aIter )
			{
				implReleaseToolboxItem( aIter, false, true );
			}
			m_aAccessibleChildren.clear();

			//!!! no break to call base class
		}

		default:
			VCLXAccessibleComponent::ProcessWindowEvent( rVclWindowEvent );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBox::ProcessWindowChildEvent( const VclWindowEvent& rVclWindowEvent )
{
	switch ( rVclWindowEvent.GetId() )
	{
        case VCLEVENT_WINDOW_SHOW:  // send create on show for direct accessible children
			{
				Reference< XAccessible > xReturn = GetItemWindowAccessible(rVclWindowEvent);
				if ( xReturn.is() )
				{
					NotifyAccessibleEvent( AccessibleEventId::CHILD, Any(), makeAny(xReturn) );
				}
			}
			break;
		default:
			VCLXAccessibleComponent::ProcessWindowChildEvent( rVclWindowEvent );

	}
}
// -----------------------------------------------------------------------------
// XInterface
// -----------------------------------------------------------------------------
IMPLEMENT_FORWARD_XINTERFACE2( VCLXAccessibleToolBox, VCLXAccessibleComponent, VCLXAccessibleToolBox_BASE )
// -----------------------------------------------------------------------------
// XTypeProvider
// -----------------------------------------------------------------------------
IMPLEMENT_FORWARD_XTYPEPROVIDER2( VCLXAccessibleToolBox, VCLXAccessibleComponent, VCLXAccessibleToolBox_BASE )
// -----------------------------------------------------------------------------
// XComponent
// -----------------------------------------------------------------------------
void SAL_CALL VCLXAccessibleToolBox::disposing()
{
	VCLXAccessibleComponent::disposing();

	// release the items
	for ( ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.begin();
		  aIter != m_aAccessibleChildren.end(); ++aIter )
	{
		implReleaseToolboxItem( aIter, false, true );
	}
	m_aAccessibleChildren.clear();
}
// -----------------------------------------------------------------------------
// XServiceInfo
// -----------------------------------------------------------------------------
::rtl::OUString VCLXAccessibleToolBox::getImplementationName() throw (RuntimeException)
{
	return ::rtl::OUString::createFromAscii( "com.sun.star.comp.toolkit.AccessibleToolBox" );
}
// -----------------------------------------------------------------------------
Sequence< ::rtl::OUString > VCLXAccessibleToolBox::getSupportedServiceNames() throw (RuntimeException)
{
	Sequence< ::rtl::OUString > aNames = VCLXAccessibleComponent::getSupportedServiceNames();
	sal_Int32 nLength = aNames.getLength();
	aNames.realloc( nLength + 1 );
	aNames[nLength] = ::rtl::OUString::createFromAscii( "com.sun.star.accessibility.AccessibleToolBox" );
	return aNames;
}
// -----------------------------------------------------------------------------
// XAccessible
// -----------------------------------------------------------------------------
Reference< XAccessibleContext > SAL_CALL VCLXAccessibleToolBox::getAccessibleContext(  ) throw (RuntimeException)
{
	comphelper::OContextEntryGuard aGuard( this );

	return this;
}
// -----------------------------------------------------------------------------
// XAccessibleContext
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBox::getAccessibleChildCount(  ) throw (RuntimeException)
{
	comphelper::OExternalLockGuard aGuard( this );

	sal_Int32 nCount = 0;
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
    	nCount = pToolBox->GetItemCount();

    return nCount;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > SAL_CALL VCLXAccessibleToolBox::getAccessibleChild( sal_Int32 i ) throw (IndexOutOfBoundsException, RuntimeException)
{
	if ( i < 0 || i >= getAccessibleChildCount() )
		throw IndexOutOfBoundsException();

	comphelper::OExternalLockGuard aGuard( this );

    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
		USHORT nHighlightItemId = pToolBox->GetHighlightItemId();
		Reference< XAccessible > xChild;
		// search for the child
		ToolBoxItemsMap::iterator aIter = m_aAccessibleChildren.find(i);
		if ( m_aAccessibleChildren.end() == aIter )
		{
			USHORT nItemId = pToolBox->GetItemId( (USHORT)i );
			Window* pItemWindow = pToolBox->GetItemWindow( nItemId );
			// not found -> create a new child
    		VCLXAccessibleToolBoxItem* pChild = new VCLXAccessibleToolBoxItem( pToolBox, i, this );
			Reference< XAccessible> xParent = pChild;
			if ( pItemWindow )
			{
				xChild = new OToolBoxWindowItem(0,::comphelper::getProcessServiceFactory(),pItemWindow->GetAccessible(),xParent);
				pItemWindow->SetAccessible(xChild);
				pChild->SetChild( xChild );
			}
			xChild = pChild;
			if ( nHighlightItemId > 0 && nItemId == nHighlightItemId )
				pChild->SetFocus( sal_True );
			if ( pToolBox->IsItemChecked( nItemId ) )
				pChild->SetChecked( sal_True );
            if ( pToolBox->GetItemState( nItemId ) == STATE_DONTKNOW )
                pChild->SetIndeterminate( true );
			m_aAccessibleChildren.insert( ToolBoxItemsMap::value_type( i, xChild ) );
		}
		else
		{
			// found it
			xChild = aIter->second;
		}
		return xChild;
	}

    return NULL;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > SAL_CALL VCLXAccessibleToolBox::getAccessibleAtPoint( const awt::Point& _rPoint ) throw (RuntimeException)
{
	comphelper::OExternalLockGuard aGuard( this );

	Reference< XAccessible > xAccessible;
    ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
    if ( pToolBox )
	{
		USHORT nItemPos = pToolBox->GetItemPos( VCLPoint( _rPoint ) );
		if ( nItemPos != TOOLBOX_ITEM_NOTFOUND )
			xAccessible = getAccessibleChild( nItemPos );
	}

	return xAccessible;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > VCLXAccessibleToolBox::GetItemWindowAccessible( const VclWindowEvent& rVclWindowEvent )
{
	Reference< XAccessible > xReturn;
	Window* pChildWindow = (Window *) rVclWindowEvent.GetData();
	ToolBox* pToolBox = static_cast< ToolBox* >( GetWindow() );
	if ( pChildWindow && pToolBox )
	{
		USHORT nCount = pToolBox->GetItemCount();
		for (USHORT i = 0 ; i < nCount && !xReturn.is() ; ++i)
		{
			USHORT nItemId = pToolBox->GetItemId( i );
			Window* pItemWindow = pToolBox->GetItemWindow( nItemId );
			if ( pItemWindow == pChildWindow )
				xReturn = getAccessibleChild(i);
		}
	}
	return xReturn;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > VCLXAccessibleToolBox::GetChildAccessible( const VclWindowEvent& rVclWindowEvent )
{
	Reference< XAccessible > xReturn = GetItemWindowAccessible(rVclWindowEvent);

	if ( !xReturn.is() )
		xReturn = VCLXAccessibleComponent::GetChildAccessible(rVclWindowEvent);
	return xReturn;
}
// -----------------------------------------------------------------------------


