/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: memmgr.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:28:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _NEW_HXX
#include "new.hxx"
#endif

#if defined(_MSC_VER) && (_MSC_VER <= 1310)
#include <new.h>
#else
#include <new>
#endif /* _MSC_VER */

// =======================================================================
// See comment below for this _MSC_VER woodoo :-(
// =======================================================================
/*
*new_handler set_new_handler - set the ANSI C++ new handler
*
*Purpose:
*       Set the ANSI C++ per-thread new handler.
*
*Entry:
*       Pointer to the new handler to be installed.
*
*       WARNING: set_new_handler is a stub function that is provided to
*       allow compilation of the Standard Template Library (STL).
*
*       Do NOT use it to register a new handler. Use _set_new_handler instead.
*
*       However, it can be called to remove the current handler:
*
*           set_new_handler(NULL); // calls _set_new_handler(NULL)
*
*Return:
*       Previous ANSI C++ new handler
*/
// =======================================================================

_NEW_HANDLER SetNewHandler (_NEW_HANDLER pfnHandler)
{
#if defined(_MSC_VER) && (_MSC_VER <= 1310)
	return (_NEW_HANDLER)_set_new_handler ((_PNH)pfnHandler);
#else
	return std::set_new_handler (pfnHandler);
#endif /* _MSC_VER */
}

// =======================================================================

void* SvMemAlloc (ULONG nBytes, USHORT nFlags)
{
	return ::operator new (size_t(nBytes));
}

// =======================================================================

void SvMemFree (void * p)
{
	::operator delete (p);
}

// =======================================================================
