/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: export2.cxx,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:59:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "export.hxx"
#include "utf8conv.hxx"
#include <tools/datetime.hxx>
#include <bootstrp/appdef.hxx>
#include <tools/isofallback.hxx>
#include <stdio.h>
#include <osl/file.hxx>
#include <osl/file.h>
#include <rtl/ustring.hxx>
#include <iostream>
#include <tools/urlobj.hxx>

using namespace std;
//
// class ResData();
//

/*****************************************************************************/
ResData::~ResData()
/*****************************************************************************/
{
	if ( pStringList ) {
		// delete existing res. of type StringList
		for ( ULONG i = 0; i < pStringList->Count(); i++ ) {
            ExportListEntry* test = pStringList->GetObject( i );
            if( test != NULL ) delete test;
		}
		delete pStringList;
	}
	if ( pFilterList ) {
		// delete existing res. of type FilterList
		for ( ULONG i = 0; i < pFilterList->Count(); i++ ) {
			ExportListEntry* test = pFilterList->GetObject( i );
            delete test;
		}
		delete pFilterList;
	}
	if ( pItemList ) {
		// delete existing res. of type ItemList
		for ( ULONG i = 0; i < pItemList->Count(); i++ ) {
			ExportListEntry* test = pItemList->GetObject( i );
            delete test;
		}
		delete pItemList;
	}
	if ( pUIEntries ) {
		// delete existing res. of type UIEntries
		for ( ULONG i = 0; i < pUIEntries->Count(); i++ ) {
			ExportListEntry* test = pUIEntries->GetObject( i );
            delete test;
		}
		delete pUIEntries;
	}
}

//
// class Export
//

/*****************************************************************************/
ByteString Export::sLanguages;
ByteString Export::sForcedLanguages;
ByteString Export::sIsoCode99;
/*****************************************************************************/


/*****************************************************************************/
USHORT Export::GetLangIndex( USHORT nLangId )
/*****************************************************************************/
{
    // removeme
    return 0xFFFF;
}

/*****************************************************************************/
CharSet Export::GetCharSet( USHORT nLangId )
/*****************************************************************************/
{
    // removeme
    //return Langcode2TextEncoding( nLangId );
    return 0;
}

void Export::DumpExportList( ByteString& sListName , ExportList& aList ){
	printf( "%s\n", sListName.GetBuffer() );
	ByteString l("");
	ExportListEntry* aEntry;
	for( int x = 0; x < aList.Count() ; x++ ){
		aEntry = (ExportListEntry*) aList.GetObject( x );
		Export::DumpMap( l , *aEntry );
	}
	printf("\n");
}
ByteString Export::DumpMap( ByteString& sMapName , ByteStringHashMap& aMap ){
	ByteStringHashMap::const_iterator idbg;
    ByteString sReturn;
	
	if( sMapName.Len() )
		printf("MapName %s\n", sMapName.GetBuffer());
//	sReturn+= ByteString("MapName ") ;
//	sReturn+= sMapName ;
//	sReturn+= ByteString("\n") ;
	if( aMap.size() < 1 ) return ByteString();
	for( idbg = aMap.begin() ; idbg != aMap.end(); ++idbg ){
		ByteString a( idbg->first );
		ByteString b( idbg->second );
		printf("[%s]= %s",a.GetBuffer(),b.GetBuffer());
/*		sReturn+= ByteString("[") ;
		sReturn+= a ;
		sReturn+= ByteString("]= ") ;
		sReturn+= b ;
		sReturn+= ByteString("\n") ;*/
		printf("\n");
	}
	printf("\n");
	//sReturn+= "\n" ;
	return sReturn;
}
/*****************************************************************************/
USHORT Export::GetLangByIsoLang( const ByteString &rIsoLang )
/*****************************************************************************/
{
	// removeme
    ByteString sLang( rIsoLang );
	sLang.ToUpperAscii();
	return 0xFFFF;
}
/*****************************************************************************/
void Export::SetLanguages( std::vector<ByteString> val ){
/*****************************************************************************/
    aLanguages = val;
    isInitialized = true;
}
/*****************************************************************************/
std::vector<ByteString> Export::GetLanguages(){ 
/*****************************************************************************/
    return aLanguages; 
}
/*****************************************************************************/
std::vector<ByteString> Export::GetForcedLanguages(){ 
/*****************************************************************************/
    return aForcedLanguages; 
}
std::vector<ByteString> Export::aLanguages       = std::vector<ByteString>();
std::vector<ByteString> Export::aForcedLanguages = std::vector<ByteString>();

/*****************************************************************************/
ByteString Export::GetIsoLangByIndex( USHORT nIndex )
/*****************************************************************************/
{
// remove me
    return "";
}

/*****************************************************************************/
void Export::QuotHTML( ByteString &rString )
/*****************************************************************************/
{
	ByteString sReturn;
	BOOL bBreak = FALSE;
	for ( USHORT i = 0; i < rString.Len(); i++ ) {
		ByteString sTemp = rString.Copy( i );
		if ( sTemp.Search( "<Arg n=" ) == 0 ) {
			while ( i < rString.Len() && rString.GetChar( i ) != '>' ) {
		 		sReturn += rString.GetChar( i );
				i++;
			}
			if ( rString.GetChar( i ) == '>' ) {
				sReturn += ">";
				i++;
			}
		}
		if ( i < rString.Len()) {
			switch ( rString.GetChar( i )) {
				case '<':
					sReturn += "&lt;";
				break;

				case '>':
					sReturn += "&gt;";
				break;

				case '\"':
					sReturn += "&quot;";
				break;

				case '\'':
					sReturn += "&apos;";
				break;

				case '&':
					if ((( i + 4 ) < rString.Len()) &&
						( rString.Copy( i, 5 ) == "&amp;" ))
							sReturn += rString.GetChar( i );
					else
						sReturn += "&amp;";
				break;

				default:
					sReturn += rString.GetChar( i );
				break;
			}
		}
	}
	rString = sReturn;
}

void Export::RemoveUTF8ByteOrderMarker( ByteString &rString ){
    if( hasUTF8ByteOrderMarker( rString ) )
        rString.Erase( 0 , 3 );
}

bool Export::hasUTF8ByteOrderMarker( const ByteString &rString ){
    // Byte order marker signature
    const char bom[ 3 ] = { 0xEF , 0xBB , 0xBF };

    return      rString.Len() >= 3 &&
                rString.GetChar( 0 ) == bom[ 0 ] &&
                rString.GetChar( 1 ) == bom[ 1 ] &&
                rString.GetChar( 2 ) == bom[ 2 ] ;
}
bool Export::fileHasUTF8ByteOrderMarker( const ByteString &rString ){
    SvFileStream aFileIn( String( rString , RTL_TEXTENCODING_ASCII_US ) , STREAM_READ );
    ByteString sLine;
    if( !aFileIn.IsEof() ) {
        aFileIn.ReadLine( sLine );
        if( aFileIn.IsOpen() ) aFileIn.Close();
        return hasUTF8ByteOrderMarker( sLine );
    }
    if( aFileIn.IsOpen() ) aFileIn.Close();
    return false;
}
void Export::RemoveUTF8ByteOrderMarkerFromFile( const ByteString &rFilename ){
    SvFileStream aFileIn( String( rFilename , RTL_TEXTENCODING_ASCII_US ) , STREAM_READ );
    ByteString sLine;
    if( !aFileIn.IsEof() ) {
        aFileIn.ReadLine( sLine );
        // Test header
        if( hasUTF8ByteOrderMarker( sLine ) ){
            //cout << "UTF8 Header found!\n";
            DirEntry aTempFile = Export::GetTempFile();
            ByteString sTempFile = ByteString( aTempFile.GetFull() , RTL_TEXTENCODING_ASCII_US );
            SvFileStream aNewFile( String( sTempFile , RTL_TEXTENCODING_ASCII_US ) , STREAM_WRITE );
            // Remove header
            RemoveUTF8ByteOrderMarker( sLine );
            //cout << "Copy stripped stuff to " << sTempFile.GetBuffer() << endl;
            aNewFile.WriteLine( sLine );
            // Copy the rest
            while( !aFileIn.IsEof() ){
                aFileIn.ReadLine( sLine );
                aNewFile.WriteLine( sLine );
            }
            if( aFileIn.IsOpen() ) aFileIn.Close();
            if( aNewFile.IsOpen() ) aNewFile.Close();
            DirEntry aEntry( rFilename.GetBuffer() );
            //cout << "Removing file " << rFilename.GetBuffer() << "\n";
            aEntry.Kill();
            //cout << "Renaming file " << sTempFile.GetBuffer() << " to " << rFilename.GetBuffer() << "\n";
            DirEntry( sTempFile ).MoveTo( DirEntry( rFilename.GetBuffer() ) );
        }
    }
    if( aFileIn.IsOpen() ) aFileIn.Close();
}

// Merge it into source code!
bool Export::isMergingGermanAllowed( const ByteString& rPrj ){
    ByteString sFile = GetEnv( "SRC_ROOT" ) ;
    sFile.Append("/");
    sFile.Append( rPrj );
    sFile.Append("/prj/l10n");
#ifdef WNT
    sFile.SearchAndReplaceAll('/','\\');
#endif
    DirEntry aFlagfile( sFile );
    return !aFlagfile.Exists();
}
/*****************************************************************************/
void Export::UnquotHTML( ByteString &rString )
/*****************************************************************************/
{
	ByteString sReturn;
	while ( rString.Len()) {
		if ( rString.Copy( 0, 5 ) == "&amp;" ) {
			sReturn += "&";
			rString.Erase( 0, 5 );
		}
		else if ( rString.Copy( 0, 4 ) == "&lt;" ) {
			sReturn += "<";
			rString.Erase( 0, 4 );
		}
		else if ( rString.Copy( 0, 4 ) == "&gt;" ) {
			sReturn += ">";
			rString.Erase( 0, 4 );
		}
		else if ( rString.Copy( 0, 6 ) == "&quot;" ) {
			sReturn += "\"";
			rString.Erase( 0, 6 );
		}
		else if ( rString.Copy( 0, 6 ) == "&apos;" ) {
			sReturn += "\'";
			rString.Erase( 0, 6 );
		}
		else {
			sReturn += rString.GetChar( 0 );
			rString.Erase( 0, 1 );
		}
	}
	rString = sReturn;
}

/*****************************************************************************/
bool Export::LanguageAllowed( const ByteString &nLanguage )
/*****************************************************************************/
{
    return std::find( aLanguages.begin() , aLanguages.end() , nLanguage ) != aLanguages.end();
}

bool Export::isInitialized = false;

/*****************************************************************************/
void Export::InitLanguages( bool bMergeMode ){
/*****************************************************************************/
    if( !isInitialized ){
        ByteString sTmp;
        ByteStringBoolHashMap aEnvLangs;
        for ( USHORT x = 0; x < sLanguages.GetTokenCount( ',' ); x++ ){
            sTmp = sLanguages.GetToken( x, ',' ).GetToken( 0, '=' );
            sTmp.EraseLeadingAndTrailingChars();
            if( bMergeMode && ( sTmp.EqualsIgnoreCaseAscii("de") || sTmp.EqualsIgnoreCaseAscii("en-US") )){}
            else if( !( (sTmp.GetChar(0)=='x' || sTmp.GetChar(0)=='X') && sTmp.GetChar(1)=='-' ) ){
                aLanguages.push_back( sTmp );
            }
        }
        InitForcedLanguages( bMergeMode );
        isInitialized = true;
    }
}
/*****************************************************************************/
void Export::InitForcedLanguages( bool bMergeMode ){
/*****************************************************************************/
    ByteString sTmp;
    ByteStringBoolHashMap aEnvLangs;
    for ( USHORT x = 0; x < sForcedLanguages.GetTokenCount( ',' ); x++ ){
        sTmp = sForcedLanguages.GetToken( x, ',' ).GetToken( 0, '=' );
        sTmp.EraseLeadingAndTrailingChars();
        if( bMergeMode && ( sTmp.EqualsIgnoreCaseAscii("de") || sTmp.EqualsIgnoreCaseAscii("en-US") )){}
        else if( !( (sTmp.GetChar(0)=='x' || sTmp.GetChar(0)=='X') && sTmp.GetChar(1)=='-' ) )
            aForcedLanguages.push_back( sTmp );
    }
}

/*****************************************************************************/
ByteString Export::GetFallbackLanguage( const ByteString nLanguage )
/*****************************************************************************/
{
    ByteString sFallback=nLanguage;
    GetIsoFallback( sFallback );
    return sFallback;
}

/*****************************************************************************/
void Export::FillInFallbacks( ResData *pResData )
/*****************************************************************************/
{
    ByteString sCur;
    for( long int n = 0; n < aLanguages.size(); n++ ){
        sCur = aLanguages[ n ];
        if( !sCur.EqualsIgnoreCaseAscii("de") && !sCur.EqualsIgnoreCaseAscii("en-US") ){
            ByteString nFallbackIndex = GetFallbackLanguage( sCur );		
            if( nFallbackIndex.Len() ){
				if ( !pResData->sText[ sCur ].Len())
					pResData->sText[ sCur ] = 
						pResData->sText[ nFallbackIndex ];

                if ( !pResData->sHelpText[ sCur ].Len())
					pResData->sHelpText[ sCur ] = 
						pResData->sHelpText[ nFallbackIndex ];

                if ( !pResData->sQuickHelpText[ sCur ].Len())
					pResData->sQuickHelpText[ sCur ] = 
						pResData->sQuickHelpText[ nFallbackIndex ];

                if ( !pResData->sTitle[ sCur ].Len())
					pResData->sTitle[ sCur ] =
						pResData->sTitle[ nFallbackIndex ];

				if ( pResData->pStringList )
					FillInListFallbacks(
						pResData->pStringList, sCur, nFallbackIndex );
				
				if ( pResData->pPairedList )
					FillInListFallbacks(
						pResData->pPairedList, sCur, nFallbackIndex );
                
				if ( pResData->pFilterList )
					FillInListFallbacks(
						pResData->pFilterList, sCur, nFallbackIndex );

                if ( pResData->pItemList )
					FillInListFallbacks(
						pResData->pItemList, sCur, nFallbackIndex );

                if ( pResData->pUIEntries )
					FillInListFallbacks(
						pResData->pUIEntries, sCur, nFallbackIndex );
			}
        }
    }
}        

/*****************************************************************************/
void Export::FillInListFallbacks(
    ExportList *pList, const ByteString &nSource, const ByteString &nFallback )
/*****************************************************************************/
{ 

	for ( ULONG i = 0; i < pList->Count(); i++ ) {
		ExportListEntry *pEntry = pList->GetObject( i );
		if ( !( *pEntry )[ nSource ].Len()){
 			( *pEntry )[ nSource ] = ( *pEntry )[ nFallback ];
			ByteString x = ( *pEntry )[ nSource ];
			ByteString y = ( *pEntry )[ nFallback ];
		}
    }
}

/*****************************************************************************/
ByteString Export::GetTimeStamp()
/*****************************************************************************/
{
//	return "xx.xx.xx";
    char buf[20];
	Time aTime;
        
	snprintf(buf, sizeof(buf), "%8d %02d:%02d:%02d", Date().GetDate(),
		aTime.GetHour(), aTime.GetMin(), aTime.GetSec());
	return ByteString(buf);
}

/*****************************************************************************/
BOOL Export::ConvertLineEnds(
	ByteString sSource, ByteString sDestination )
/*****************************************************************************/
{
	String sSourceFile( sSource, RTL_TEXTENCODING_ASCII_US );
	String sDestinationFile( sDestination, RTL_TEXTENCODING_ASCII_US );

	SvFileStream aSource( sSourceFile, STREAM_READ );
	if ( !aSource.IsOpen())
		return FALSE;
	SvFileStream aDestination( sDestinationFile, STREAM_STD_WRITE | STREAM_TRUNC );
	if ( !aDestination.IsOpen()) {
		aSource.Close();
		return FALSE;
	}

	ByteString sLine;

	while ( !aSource.IsEof()) {
		aSource.ReadLine( sLine );
		if ( !aSource.IsEof()) {
			sLine.EraseAllChars( '\r' );
			aDestination.WriteLine( sLine );
		}
		else
			aDestination.WriteByteString( sLine );
	}

	aSource.Close();
	aDestination.Close();

	return TRUE;
}

/*****************************************************************************/
ByteString Export::GetNativeFile( ByteString sSource )
/*****************************************************************************/
{
	DirEntry aTemp( GetTempFile());
	ByteString sReturn( aTemp.GetFull(), RTL_TEXTENCODING_ASCII_US );

	for ( USHORT i = 0; i < 10; i++ )
		if ( ConvertLineEnds( sSource, sReturn ))
			return sReturn;

	return "";
}

/*****************************************************************************/
DirEntry Export::GetTempFile()
/*****************************************************************************/
{
#ifdef WNT
	String sTempDir( GetEnv( "TEMP" ), RTL_TEXTENCODING_ASCII_US );
#else
//	String sTempDir( GetEnv( "HOME" ), RTL_TEXTENCODING_ASCII_US );
	String sTempDir( String::CreateFromAscii( "/tmp" ));
#endif
    rtl::OUString* sTempFilename = new rtl::OUString();
    
    // Create a temp file
    int nRC = osl::FileBase::createTempFile( 0 , 0 , sTempFilename );
    if( nRC ) printf(" osl::FileBase::createTempFile RC = %d",nRC);
    
    String strTmp( *sTempFilename  );
    
    INetURLObject::DecodeMechanism eMechanism = INetURLObject::DECODE_TO_IURI;
    String sDecodedStr = INetURLObject::decode( strTmp , '%' , eMechanism ); 
    ByteString sTmp( sDecodedStr , RTL_TEXTENCODING_UTF8 );
    
#ifdef WNT
    sTmp.SearchAndReplace("file:///","");
    sTmp.SearchAndReplaceAll('/','\\');
#else
    // Set file permission to 644
 	const sal_uInt64 nPerm = osl_File_Attribute_OwnRead | osl_File_Attribute_OwnWrite | 
                             osl_File_Attribute_GrpRead | osl_File_Attribute_OthRead ;

    nRC = osl::File::setAttributes( *sTempFilename , nPerm );
    if( nRC ) printf(" osl::File::setAttributes RC = %d",nRC);

    sTmp.SearchAndReplace("file://","");
#endif
    DirEntry aDirEntry( sTmp );
    delete sTempFilename;
    return aDirEntry;
}
