/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ftpdownloadthread.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:35:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#ifndef _FTP_FTPDOWNLOADTHREAD_HXX_
#define _FTP_FTPDOWNLOADTHREAD_HXX_ 


#include "ftpurl.hxx"
#ifndef _UCBHELPER_BACKGROUNDDOWNLOAD_HXX_
#include <ucbhelper/backgrounddownload.hxx>
#endif


namespace ftp {


    class FTPDownloadThread
        : public ucb::DownloadThread
    {
    public:

        FTPDownloadThread::FTPDownloadThread(
            const rtl::OUString& aIdent,
			FTPHandleProvider* pFCP
        )
            throw(
                malformed_exception,
                curl_exception
            );
        
        curl_exception GetException();
        
    protected:
        
        void work();
        
    private:
        
		osl::Mutex m_mutex;
		FTPHandleProvider *m_pFCP;
		mutable rtl::OUString m_aUsername;
        bool m_bShowPassword;
		mutable rtl::OUString m_aHost;
		mutable rtl::OUString m_aPort;
		mutable rtl::OUString m_aType;
		
		/** Contains the decoded pathsegments of the url.
		 */
		std::vector<rtl::OUString> m_aPathSegmentVec;

        curl_exception m_e;

		void parse(const rtl::OUString& url)
            throw(
                malformed_exception
			);
        
        rtl::OUString ident(bool withslash,bool internal) const;
    };

}


#endif
