package com.sun.star.help;

import com.sun.xmlsearch.xml.qe.QueryResults;

import com.sun.star.uno.*;
import com.sun.star.lang.*;
import com.sun.star.ucb.*;
import com.sun.star.beans.*;
import com.sun.star.sdbc.*;

/**
 * 	This class is the result of an open on a with query constructed content
 */

public class HelpDynamicResultSet implements XDynamicResultSet // extends XComponent
{
	boolean isCached = false,isFetched = false,listenerSet = false;
	HelpResultSetFactory _factory = null;
	XResultSet _result = null;
	XMultiServiceFactory _xMsgr;
	
	HelpDynamicResultSet( HelpResultSetFactory factory,XMultiServiceFactory xMsgr )
 	{
  		_factory = factory;
		_xMsgr = xMsgr;
    }
	
	private QueryResults m_xResult;
 	private HelpProvider m_xProvider;
	private Property     m_xProperties[];


	public HelpDynamicResultSet( HelpProvider xProvider,QueryResults xResult,Property xProperties[] )
 	{
  		m_xProvider = xProvider;
  		m_xResult = xResult;
    	m_xProperties = xProperties;
  	}


  	// Methods from XComponent

  	public void addEventListener( XEventListener p0 ) throws com.sun.star.uno.RuntimeException
  	{
   		return;
  	}


  	public void dispose() throws com.sun.star.uno.RuntimeException
  	{
   		return;
  	}


  	public void removeEventListener(XEventListener p0) throws com.sun.star.uno.RuntimeException
  	{
   		return;
  	}


   	// Methods from XDynamicResultSet

  	public void connectToCache( XDynamicResultSet p0 )
   		throws ListenerAlreadySetException,AlreadyInitializedException,ServiceNotFoundException,com.sun.star.uno.RuntimeException
    {
		if( isFetched || isCached )
			throw new ListenerAlreadySetException();
		
		// Now initialize the cache
		
		XSourceInitialization xTarget = 
			( XSourceInitialization ) UnoRuntime.queryInterface( XSourceInitialization.class,
																 p0 );
		
		if( xTarget != null )
		{
			XCachedDynamicResultSetStubFactory xStubFactory = null;
			try
			{
				xStubFactory = 
					( XCachedDynamicResultSetStubFactory )
					UnoRuntime.queryInterface( XCachedDynamicResultSetStubFactory.class,
											   _xMsgr.createInstance(
												   "com.sun.star.ucb.CachedDynamicResultSetStubFactory" ) );
			}
			catch( com.sun.star.uno.Exception e )
			{
				e.printStackTrace();
			}
			
			if ( xStubFactory != null  )
			{
//				xStubFactory.connectToCache( this,p0,m_aCommand.SortingInfo,0 );
				xStubFactory.connectToCache( this,p0,null,null );
				isCached = true;
				return;
			}
		}
		
		throw new ServiceNotFoundException();
    }




  	public short getCapabilities() throws com.sun.star.uno.RuntimeException
   	{
		return 0;
    }


  	public synchronized XResultSet getStaticResultSet()
   		throws ListenerAlreadySetException, com.sun.star.uno.RuntimeException
    {
		if( listenerSet || isCached ) 
			throw new ListenerAlreadySetException();
		
		isFetched = true;
		if( _result == null )
			_result = _factory.createResultSet();
		
		return _result;
	}


  	public synchronized void setListener( XDynamicResultSetListener p0 )
   		throws ListenerAlreadySetException,com.sun.star.uno.RuntimeException
	{
		if( listenerSet || isFetched )
			throw new ListenerAlreadySetException();
		
		listenerSet = true;
		
		if( p0 != null )
		{
			if( _result == null )
				_result = _factory.createResultSet();
			
			ListAction a[] = new ListAction[1];
			a[0] = new ListAction( 0,
								   0,
								   ListActionType.WELCOME,
								   new WelcomeDynamicResultSetStruct( _result,
																	  _result ) );
			
			p0.notify( new ListEvent( this,a ) );
		}
	}

}



