package com.sun.star.help;

import java.io.*;
import java.net.URL;
import java.util.*;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

import org.w3c.dom.*;
import com.sun.xml.tree.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import com.jclark.xsl.sax.*;

import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.xml.qe.*;
import com.sun.xmlsearch.xml.indexer.*;

public class PreTransformer
{
	String XMLDir;
	String XSLFile;
	String HelpRoot;
	int nTransformations;
	JarOutputStream ZipStream;
	HelpIndexer.ParseStuff Transformer;

	PreTransformer( String TheXMLDir, String TheXSLFile, String TheHelpRoot )
	{
		nTransformations = 0;
		XMLDir = TheXMLDir;
		HelpRoot = TheHelpRoot;

        XSLFile = "file://";
        if ( TheXSLFile.charAt(0) != '/' )
            XSLFile += '/';
		XSLFile += TheXSLFile;
	}

 	private void transform()
  	{
		Transformer = new HelpIndexer.ParseStuff( XSLFile );
		// Transformer = new HelpIndexer.ParseStuff( XSLFile, false );

  		String JarFileName = XMLDir + ".jar";
		System.out.println( "" );
		System.out.println( "JarFileName: " + JarFileName );
		System.out.println( "" );

        try
        {
            // FileOutputStream outStream = new FileOutputStream( JarFileName, false );
		    FileOutputStream outStream = new FileOutputStream( JarFileName );
            ZipStream = new JarOutputStream( outStream );
        }
        catch (FileNotFoundException e )
        {
            System.err.println("Error creating jar file!" );
            System.exit(1);
        }
        catch( java.lang.Exception e )
        {
            System.out.println( "Unknown exception" );
            System.exit(1);
        }

  		File StartDir = new File( XMLDir );
  		if( StartDir.isDirectory() )
  			transformFiles( StartDir );
  		else
			System.out.println( "Error - Not a directory: " + XMLDir );

        try
        {
		    ZipStream.close();
        }
        catch( java.lang.Exception e )
        {
            System.out.println( "error closing jar file" );
        }
  	}

 	private void transformFiles( File Directory )
  	{
  		if( !Directory.isDirectory() )
  		{
			System.out.println( "Error - Not a directory: " + Directory.getName() );
			return;
		}

  		File[] Entries = Directory.listFiles();
  		int nEntries = Entries.length;
  		for( int nEntry = 0; nEntry < nEntries; nEntry++ )
  		{
  			if ( Entries[nEntry].isFile() )
  			{
  				nTransformations++;
    			try
        		{
                    String EntryName = Entries[nEntry].getAbsolutePath();
                    EntryName = EntryName.replace( '\\', '/' );

                    String EntryURL = "file://";
                    if ( EntryName.charAt(0) != '/' )
                        EntryURL += '/';
                    EntryURL += EntryName;

					System.out.println( "Transforming #" + nTransformations + ": " +  EntryURL );

					byte[] XHTMLStream = Transformer.parse( EntryURL );

                    String ZipEntryName = EntryName.substring( HelpRoot.length()+1 ).toLowerCase();
                    ZipEntry ze = new ZipEntry( ZipEntryName );

                    CRC32 crc= new CRC32();
                    crc.update( XHTMLStream );
                    ze.setCrc( crc.getValue() );
                    ze.setSize( XHTMLStream.length );
                    ze.setMethod( ZipEntry.DEFLATED );
                    ZipStream.putNextEntry( ze );
                    if (XHTMLStream.length > 0)
                        ZipStream.write( XHTMLStream );
                    ZipStream.closeEntry();
				}
				catch( Exception e )
       			{
					System.out.println( "Exception: Msg=" + e.getMessage() );
					System.out.println( "File:" + Entries[nEntry].getName() );
					e.printStackTrace();
				}
  			}
  			else
  			{
  				transformFiles( Entries[nEntry] );
  			}
  		}
  	}

	public static void main( String[] args ) throws Exception
	{
		if( args.length < 2 )
  		{
    		System.out.println( "PreTransformer <XMLDir> <XSLFile> [HelpRoot]" );
      		System.exit( 1 );
    	}

     	String XMLDir = args[0];
     	String XSLFile = args[1];
     	String HelpRoot = XMLDir;
		if( args.length > 2 )
			HelpRoot = args[2];

		System.out.println( "------------------------" );
		System.out.println( "Starting Transformation:" );
		System.out.println( "------------------------" );
		System.out.println( "HelpRoot= " + HelpRoot );
		System.out.println( "XMLDir=   " + XMLDir );
		System.out.println( "XSLFile=  " + XSLFile );

		try
  		{
        	PreTransformer XMLTransformer = new PreTransformer( XMLDir, XSLFile, HelpRoot );
         	XMLTransformer.transform();
      	}
    	catch( Exception e )
    	{
      		e.printStackTrace();
    	}
	}
}
