/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_undobj.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:43:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _TXTFTN_HXX //autogen
#include <txtftn.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FTNIDX_HXX //autogen
#include <ftnidx.hxx>
#endif
#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
// auto strip #ifndef _NDNOTXT_HXX
// auto strip #include <ndnotxt.hxx>
// auto strip #endif
#ifndef _BOOKMRK_HXX
#include <bookmrk.hxx>
#endif
// auto strip #ifndef _MVSAVE_HXX
// auto strip #include <mvsave.hxx>
// auto strip #endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
namespace binfilter {


/*N*/ class SwRedlineSaveData : public SwUndRng, public SwRedlineData,
/*N*/ 						  private SwUndoSaveSection
/*N*/ {
/*N*/ public:
/*N*/ 	SwRedlineSaveData( SwComparePosition eCmpPos,
/*N*/ 						const SwPosition& rSttPos, const SwPosition& rEndPos,
/*N*/ 						SwRedline& rRedl, BOOL bCopyNext );
~SwRedlineSaveData(){DBG_BF_ASSERT(0, "STRIP"); };//STRIP001 /*N*/ 	~SwRedlineSaveData();
//STRIP001 	void RedlineToDoc( SwPaM& rPam );
//STRIP001 	SwNodeIndex* GetMvSttIdx() const
//STRIP001 		{ return SwUndoSaveSection::GetMvSttIdx(); }
//STRIP001 
//STRIP001 #ifndef PRODUCT
//STRIP001     USHORT nRedlineCount;
//STRIP001 #endif
/*N*/ };

/*N*/ SV_IMPL_PTRARR( SwUndos, SwUndo*)
/*N*/ SV_IMPL_PTRARR( SwRedlineSaveDatas, SwRedlineSaveDataPtr )

//STRIP001 SwUndoIter::SwUndoIter( SwPaM* pPam, USHORT nId )
//STRIP001 {
//STRIP001 	nUndoId = nId;
//STRIP001 	bWeiter = nId ? TRUE : FALSE;
//STRIP001 	bUpdateAttr = FALSE;
//STRIP001 	pAktPam = pPam;
//STRIP001 	nEndCnt = 0;
//STRIP001 	pSelFmt = 0;
//STRIP001 	pMarkList = 0;
//STRIP001 }
//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }

//------------------------------------------------------------

// Diese Klasse speichert den Pam als USHORT's und kann diese wieder zu

// einem PaM zusammensetzen
/*?*/ SwUndRng::SwUndRng()
/*?*/ 	: nSttNode( 0 ), nEndNode( 0 ), nSttCntnt( 0 ), nEndCntnt( 0 )
/*?*/ {
/*?*/ }

/*N*/ SwUndRng::SwUndRng( const SwPaM& rPam )
/*N*/ {
/*N*/ 	SetValues( rPam );
/*N*/ }

/*N*/ void SwUndRng::SetValues( const SwPaM& rPam )
/*N*/ {
/*N*/ 	const SwPosition *pStt = rPam.Start();
/*N*/ 	if( rPam.HasMark() )
/*N*/ 	{
/*N*/ 		const SwPosition *pEnd = rPam.GetPoint() == pStt
/*N*/ 						? rPam.GetMark()
/*N*/ 						: rPam.GetPoint();
/*N*/ 		nEndNode = pEnd->nNode.GetIndex();
/*N*/ 		nEndCntnt = pEnd->nContent.GetIndex();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		// keine Selektion !!
/*N*/ 		nEndNode = 0, nEndCntnt = STRING_MAXLEN;
/*N*/ 
/*N*/ 	nSttNode = pStt->nNode.GetIndex();
/*N*/ 	nSttCntnt = pStt->nContent.GetIndex();
/*N*/ }

//STRIP001 void SwUndRng::SetPaM( SwPaM & rPam, BOOL bCorrToCntnt ) const
//STRIP001 {
//STRIP001 	rPam.DeleteMark();
//STRIP001 	rPam.GetPoint()->nNode = nSttNode;
//STRIP001 	SwNode* pNd = rPam.GetNode();
//STRIP001 	if( pNd->IsCntntNode() )
//STRIP001 		rPam.GetPoint()->nContent.Assign( pNd->GetCntntNode(), nSttCntnt );
//STRIP001 	else if( bCorrToCntnt )
//STRIP001 		rPam.Move( fnMoveForward, fnGoCntnt );
//STRIP001 	else
//STRIP001 		rPam.GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 
//STRIP001 	if( !nEndNode && STRING_MAXLEN == nEndCntnt )		// keine Selection
//STRIP001 		return ;
//STRIP001 
//STRIP001 	rPam.SetMark();
//STRIP001 	if( nSttNode == nEndNode && nSttCntnt == nEndCntnt )
//STRIP001 		return;								// nichts mehr zu tun
//STRIP001 
//STRIP001 	rPam.GetPoint()->nNode = nEndNode;
//STRIP001 	if( (pNd = rPam.GetNode())->IsCntntNode() )
//STRIP001 		rPam.GetPoint()->nContent.Assign( pNd->GetCntntNode(), nEndCntnt );
//STRIP001 	else if( bCorrToCntnt )
//STRIP001 		rPam.Move( fnMoveBackward, fnGoCntnt );
//STRIP001 	else
//STRIP001 		rPam.GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 }

//STRIP001 void SwUndRng::SetPaM( SwUndoIter& rIter, BOOL bCorrToCntnt ) const
//STRIP001 {
//STRIP001 	if( rIter.pAktPam )
//STRIP001 		SetPaM( *rIter.pAktPam, bCorrToCntnt );
//STRIP001 }

//------------------------------------------------------------


//STRIP001 void SwUndo::RemoveIdxFromSection( SwDoc& rDoc, ULONG nSttIdx,
//STRIP001 									ULONG* pEndIdx )
//STRIP001 {
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nSttIdx );
//STRIP001 	SwNodeIndex aEndIdx( rDoc.GetNodes(), pEndIdx ? *pEndIdx
//STRIP001 									: aIdx.GetNode().EndOfSectionIndex() );
//STRIP001 	SwPosition aPos( rDoc.GetNodes().GetEndOfPostIts() );
//STRIP001 	rDoc.CorrAbs( aIdx, aEndIdx, aPos, TRUE );
//STRIP001 }

//STRIP001 void SwUndo::RemoveIdxFromRange( SwPaM& rPam, BOOL bMoveNext )
//STRIP001 {
//STRIP001 	const SwPosition* pEnd = rPam.End();
//STRIP001 	if( bMoveNext )
//STRIP001 	{
//STRIP001 		if( pEnd != rPam.GetPoint() )
//STRIP001 			rPam.Exchange();
//STRIP001 
//STRIP001 		SwNodeIndex aStt( rPam.GetMark()->nNode );
//STRIP001 		SwNodeIndex aEnd( rPam.GetPoint()->nNode );
//STRIP001 
//STRIP001 		if( !rPam.Move( fnMoveForward ) )
//STRIP001 		{
//STRIP001 			rPam.Exchange();
//STRIP001 			if( !rPam.Move( fnMoveBackward ) )
//STRIP001 			{
//STRIP001 				rPam.GetPoint()->nNode = rPam.GetDoc()->GetNodes().GetEndOfPostIts();
//STRIP001 				rPam.GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		rPam.GetDoc()->CorrAbs( aStt, aEnd, *rPam.GetPoint(), TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rPam.GetDoc()->CorrAbs( rPam, *pEnd, TRUE );
//STRIP001 }

//STRIP001 void SwUndo::RemoveIdxRel( ULONG nIdx, const SwPosition& rPos )
//STRIP001 {
//STRIP001 	// nur die Crsr verschieben; die Bookmarks/TOXMarks/.. werden vom
//STRIP001 	// entsp. JoinNext/JoinPrev erledigt!
//STRIP001 	SwNodeIndex aIdx( rPos.nNode.GetNode().GetNodes(), nIdx );
//STRIP001 	::PaMCorrRel( aIdx, rPos );
//STRIP001 }

/*N*/ SwUndo::~SwUndo()
/*N*/ {
/*N*/ }

//STRIP001 void SwUndo::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	rIter.pLastUndoObj = this;
//STRIP001 }

//------------------------------------------------------------

/*N*/ SwUndoSaveCntnt::SwUndoSaveCntnt()
/*N*/ 	: pHistory( 0 )
/*N*/ {}

/*N*/ SwUndoSaveCntnt::~SwUndoSaveCntnt()
/*N*/ {
/*N*/ 	delete pHistory;
/*N*/ }

	// wird fuer das Loeschen von Inhalt benoetigt. Fuer das ReDo werden
	// Inhalte in das UndoNodesArray verschoben. Diese Methoden fuegen
	// am Ende eines TextNodes fuer die Attribute einen Trenner ein.
	// Dadurch werden die Attribute nicht expandiert.
	// MoveTo.. 	verschiebt aus dem NodesArray in das UndoNodesArray
	// MoveFrom..	verschiebt aus dem UndoNodesArray in das NodesArray

	// 2.8.93:	ist pEndNdIdx angebenen, wird vom Undo/Redo -Ins/DelFly
	//			aufgerufen. Dann soll die gesamte Section verschoben werden.

/*N*/void SwUndoSaveCntnt::MoveToUndoNds( SwPaM& rPaM, SwNodeIndex* pNodeIdx,
/*N*/					SwIndex* pCntIdx, ULONG* pEndNdIdx, xub_StrLen* pEndCntIdx )
/*N*/{
DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	SwDoc& rDoc = *rPaM.GetDoc();
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwNoTxtNode* pCpyNd = rPaM.GetNode()->GetNoTxtNode();
//STRIP001 
//STRIP001 	// jetzt kommt das eigentliche Loeschen(Verschieben)
//STRIP001 	SwNodes& rNds = (SwNodes&)*rDoc.GetUndoNds();
//STRIP001 	SwPosition aPos( pEndNdIdx ? rNds.GetEndOfPostIts()
//STRIP001 							   : rNds.GetEndOfExtras() );
//STRIP001 	aPos.nNode--;
//STRIP001 
//STRIP001 	const SwPosition* pStt = rPaM.Start(), *pEnd = rPaM.End();
//STRIP001 
//STRIP001 	if( pCpyNd || pEndNdIdx || !aPos.nNode.GetNode().GetCntntNode() ||
//STRIP001 		(!pStt->nContent.GetIndex() && (pStt->nNode != pEnd->nNode ||
//STRIP001 				(!pStt->nNode.GetNode().GetCntntNode() ||
//STRIP001 					pStt->nNode.GetNode().GetCntntNode()->Len() ==
//STRIP001 						pEnd->nContent.GetIndex() ) ) ) )
//STRIP001 	{
//STRIP001 		aPos.nNode++;
//STRIP001 		aPos.nContent = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aPos.nNode.GetNode().GetCntntNode()->MakeEndIndex( &aPos.nContent );
//STRIP001 
//STRIP001 	// als USHORT merken; die Indizies verschieben sich !!
//STRIP001 	ULONG nTmpMvNode = aPos.nNode.GetIndex();
//STRIP001 	xub_StrLen nTmpMvCntnt = aPos.nContent.GetIndex();
//STRIP001 
//STRIP001 	if( pCpyNd || pEndNdIdx )
//STRIP001 	{
//STRIP001 		SwNodeRange aRg( pStt->nNode, 0, pEnd->nNode, 1 );
//STRIP001 		rDoc.GetNodes()._MoveNodes( aRg, rNds, aPos.nNode, FALSE );
//STRIP001 		aPos.nContent = 0;
//STRIP001 		aPos.nNode--;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rDoc.GetNodes().Move( rPaM, aPos, rNds, FALSE );
//STRIP001 
//STRIP001 		SwTxtNode* pTxtNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 		if( pTxtNd )		// fuege einen Trenner fuer die Attribute ein !
//STRIP001 		{
//STRIP001 			// weil aber beim Insert die Attribute angefasst/sprich
//STRIP001 			// aus dem Array geloescht und wieder eingefuegt werden, koennen
//STRIP001 			// dadurch Attribute verschwinden (z.B "Fett aus" von 10-20,
//STRIP001 			// "Fett an" von 12-15, dann wird durchs Insert/Delete das
//STRIP001 			// "Fett an" geloescht !! Ist hier aber nicht erwuenscht !!)
//STRIP001 			// DARUM: nicht die Hints anfassen, direct den String manipulieren
//STRIP001 
//STRIP001 			String& rStr = (String&)pTxtNd->GetTxt();
//STRIP001 			// Zur Sicherheit lieber nur wenn wirklich am Ende steht
//STRIP001 			if( rStr.Len() == aPos.nContent.GetIndex() )
//STRIP001 			{
//STRIP001 				rStr.Insert( ' ' );
//STRIP001 				++aPos.nContent;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pTxtNd->Insert( ' ', aPos.nContent, INS_NOHINTEXPAND);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pEndNdIdx )
//STRIP001 		*pEndNdIdx = aPos.nNode.GetIndex();
//STRIP001 	if( pEndCntIdx )
//STRIP001 		*pEndCntIdx = aPos.nContent.GetIndex();
//STRIP001 
//STRIP001 	// alte Position
//STRIP001 	aPos.nNode = nTmpMvNode;
//STRIP001 	if( pNodeIdx )
//STRIP001 		*pNodeIdx = aPos.nNode;
//STRIP001 
//STRIP001 	if( pCntIdx )
//STRIP001 	{
//STRIP001 		SwCntntNode* pCNd = aPos.nNode.GetNode().GetCntntNode();
//STRIP001 		if( pCNd )
//STRIP001 			pCntIdx->Assign( pCNd, nTmpMvCntnt );
//STRIP001 		else
//STRIP001 			pCntIdx->Assign( 0, 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	rDoc.DoUndo( bUndo );
/*N*/ }

//STRIP001 void SwUndoSaveCntnt::MoveFromUndoNds( SwDoc& rDoc, ULONG nNodeIdx,
//STRIP001 							xub_StrLen nCntIdx, SwPosition& rInsPos,
//STRIP001 							ULONG* pEndNdIdx, xub_StrLen* pEndCntIdx )
//STRIP001 {
//STRIP001 	// jetzt kommt das wiederherstellen
//STRIP001 	SwNodes& rNds = (SwNodes&)*rDoc.GetUndoNds();
//STRIP001 	if( nNodeIdx == rNds.GetEndOfPostIts().GetIndex() )
//STRIP001 		return;		// nichts gespeichert
//STRIP001 
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwPaM aPaM( rInsPos );
//STRIP001 	if( pEndNdIdx )			// dann hole aus diesem den Bereich
//STRIP001 		aPaM.GetPoint()->nNode.Assign( rNds, *pEndNdIdx );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aPaM.GetPoint()->nNode = rNds.GetEndOfExtras();
//STRIP001 		GoInCntnt( aPaM, fnMoveBackward );
//STRIP001 	}
//STRIP001 
//STRIP001 	SwTxtNode* pTxtNd = aPaM.GetNode()->GetTxtNode();
//STRIP001 	if( !pEndNdIdx && pTxtNd )	// loesche den Trenner wieder
//STRIP001 	{
//STRIP001 		if( pEndCntIdx )
//STRIP001 			aPaM.GetPoint()->nContent.Assign( pTxtNd, *pEndCntIdx );
//STRIP001 		if( pTxtNd->GetTxt().Len() )
//STRIP001 		{
//STRIP001 			GoInCntnt( aPaM, fnMoveBackward );
//STRIP001 			pTxtNd->Erase( aPaM.GetPoint()->nContent, 1 );
//STRIP001 		}
//STRIP001 
//STRIP001 		aPaM.SetMark();
//STRIP001 		aPaM.GetPoint()->nNode = nNodeIdx;
//STRIP001 		aPaM.GetPoint()->nContent.Assign( aPaM.GetCntntNode(), nCntIdx );
//STRIP001 
//STRIP001 		_SaveRedlEndPosForRestore aRedlRest( rInsPos.nNode );
//STRIP001 
//STRIP001 		rNds.Move( aPaM, rInsPos, rDoc.GetNodes() );
//STRIP001 
//STRIP001 		// noch den letzen Node loeschen.
//STRIP001 		if( !aPaM.GetPoint()->nContent.GetIndex() ||
//STRIP001 			( aPaM.GetPoint()->nNode++ && 		// noch leere Nodes am Ende ??
//STRIP001 			&rNds.GetEndOfExtras() != &aPaM.GetPoint()->nNode.GetNode() ))
//STRIP001 		{
//STRIP001 			aPaM.GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 			aPaM.SetMark();
//STRIP001 			rNds.Delete( aPaM.GetPoint()->nNode,
//STRIP001 						rNds.GetEndOfExtras().GetIndex() -
//STRIP001 						aPaM.GetPoint()->nNode.GetIndex() );
//STRIP001 		}
//STRIP001 
//STRIP001 		aRedlRest.Restore();
//STRIP001 	}
//STRIP001 	else if( pEndNdIdx || !pTxtNd )
//STRIP001 	{
//STRIP001 		SwNodeRange aRg( rNds, nNodeIdx, rNds, (pEndNdIdx
//STRIP001 						? ((*pEndNdIdx) + 1)
//STRIP001 						: rNds.GetEndOfExtras().GetIndex() ) );
//STRIP001 		rNds._MoveNodes( aRg, rDoc.GetNodes(), rInsPos.nNode, 0 == pEndNdIdx );
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ASSERT( FALSE, "was ist es denn nun?" );
//STRIP001 
//STRIP001 	rDoc.DoUndo( bUndo );
//STRIP001 }

// diese beiden Methoden bewegen den Point vom Pam zurueck/vor. Damit
// kann fuer ein Undo/Redo ein Bereich aufgespannt werden. (Der
// Point liegt dann vor dem manipuliertem Bereich !!)
// Das Flag gibt an, ob noch vorm Point Inhalt steht.

//STRIP001 BOOL SwUndoSaveCntnt::MovePtBackward( SwPaM& rPam )
//STRIP001 {
//STRIP001 	rPam.SetMark();
//STRIP001 	if( rPam.Move( fnMoveBackward ))
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001 	// gibt es nach vorne keinen Inhalt mehr, so setze den Point einfach
//STRIP001 	// auf die vorherige Position (Node und Content, damit der Content
//STRIP001 	// abgemeldet wird !!)
//STRIP001 	rPam.GetPoint()->nNode--;
//STRIP001 	rPam.GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void SwUndoSaveCntnt::MovePtForward( SwPaM& rPam, BOOL bMvBkwrd )
//STRIP001 {
//STRIP001 	// gab es noch Inhalt vor der Position ?
//STRIP001 	if( bMvBkwrd )
//STRIP001 		rPam.Move( fnMoveForward );
//STRIP001 	else
//STRIP001 	{                       // setzen Point auf die naechste Position
//STRIP001 		rPam.GetPoint()->nNode++;
//STRIP001 		SwCntntNode* pCNd = rPam.GetCntntNode();
//STRIP001 		if( pCNd )
//STRIP001 			pCNd->MakeStartIndex( &rPam.GetPoint()->nContent );
//STRIP001 		else
//STRIP001 			rPam.Move( fnMoveForward );
//STRIP001 	}
//STRIP001 }


/*
   JP 21.03.94: loesche alle Objecte, die ContentIndizies auf den ang.
				Bereich besitzen.
				Zur Zeit gibts folgende Objecte
					- Fussnoten
					- Flys
					- Bookmarks
					- Verzeichnisse
*/

/*N*/ void SwUndoSaveCntnt::DelCntntIndex( const SwPosition& rMark,
/*N*/ 								     const SwPosition& rPoint,
/*N*/ 									 DelCntntType nDelCntntType )
/*N*/ {
/*N*/ 	const SwPosition *pStt = rMark < rPoint ? &rMark : &rPoint,
/*N*/ 					*pEnd = &rMark == pStt ? &rPoint : &rMark;
/*N*/ 
/*N*/ 	SwDoc* pDoc = rMark.nNode.GetNode().GetDoc();
/*N*/ 	BOOL bDoesUndo = pDoc->DoesUndo();
/*N*/ 	pDoc->DoUndo( FALSE );
/*N*/ 
/*N*/ 	// 1. Fussnoten
/*N*/ 	if( DELCNT_FTN & nDelCntntType )
/*N*/ 	{
/*N*/ 		SwFtnIdxs& rFtnArr = pDoc->GetFtnIdxs();
/*N*/ 		if( rFtnArr.Count() )
/*N*/ 		{
/*N*/ 			const SwNode* pFtnNd;
/*N*/ 			USHORT nPos;
/*N*/ 			rFtnArr.SeekEntry( pStt->nNode, &nPos );
/*N*/ 			SwTxtFtn* pSrch;
/*N*/ 
/*N*/ 			// loesche erstmal alle, die dahinter stehen
/*N*/ 			while( nPos < rFtnArr.Count() && ( pFtnNd =
/*N*/ 				&( pSrch = rFtnArr[ nPos ] )->GetTxtNode())->GetIndex()
/*N*/ 						<= pEnd->nNode.GetIndex() )
/*N*/ 			{
/*?*/ 				xub_StrLen nFtnSttIdx = *pSrch->GetStart();
/*?*/ 				if( (DELCNT_CHKNOCNTNT & nDelCntntType )
/*?*/ 					? (&pEnd->nNode.GetNode() == pFtnNd )
/*?*/ 					: (( &pStt->nNode.GetNode() == pFtnNd &&
/*?*/ 					pStt->nContent.GetIndex() > nFtnSttIdx) ||
/*?*/ 					( &pEnd->nNode.GetNode() == pFtnNd &&
/*?*/ 					nFtnSttIdx >= pEnd->nContent.GetIndex() )) )
/*?*/ 				{
/*?*/ 					++nPos;		// weiter suchen
/*?*/ 					continue;
/*?*/ 				}
/*?*/ 
/*?*/ 				// es muss leider ein Index angelegt werden. Sonst knallts im
/*?*/ 				// TextNode, weil im DTOR der SwFtn dieser geloescht wird !!
/*?*/ 				SwTxtNode* pTxtNd = (SwTxtNode*)pFtnNd;
/*?*/ 				if( !pHistory )
/*?*/ 					pHistory = new SwHistory;
/*?*/ 				SwTxtAttr* pFtnHnt = pTxtNd->GetTxtAttr( nFtnSttIdx );
/*?*/ 				ASSERT( pFtnHnt, "kein FtnAttribut" );
/*?*/ 				SwIndex aIdx( pTxtNd, nFtnSttIdx );
/*?*/ 				pHistory->Add( pFtnHnt, pTxtNd->GetIndex(), FALSE );
/*?*/ 				pTxtNd->Erase( aIdx, 1 );
/*N*/ 			}
/*N*/ 
/*N*/ 			while( nPos-- && ( pFtnNd = &( pSrch = rFtnArr[ nPos ] )->
/*N*/ 					GetTxtNode())->GetIndex() >= pStt->nNode.GetIndex() )
/*N*/ 			{
/*?*/ 				xub_StrLen nFtnSttIdx = *pSrch->GetStart();
/*?*/ 				if( !(DELCNT_CHKNOCNTNT & nDelCntntType) && (
/*?*/ 					( &pStt->nNode.GetNode() == pFtnNd &&
/*?*/ 					pStt->nContent.GetIndex() > nFtnSttIdx ) ||
/*?*/ 					( &pEnd->nNode.GetNode() == pFtnNd &&
/*?*/ 					nFtnSttIdx >= pEnd->nContent.GetIndex() )))
/*?*/ 					continue;				// weiter suchen
/*?*/ 
/*?*/ 				// es muss leider ein Index angelegt werden. Sonst knallts im
/*?*/ 				// TextNode, weil im DTOR der SwFtn dieser geloescht wird !!
/*?*/ 				SwTxtNode* pTxtNd = (SwTxtNode*)pFtnNd;
/*?*/ 				if( !pHistory )
/*?*/ 					pHistory = new SwHistory;
/*?*/ 				SwTxtAttr* pFtnHnt = pTxtNd->GetTxtAttr( nFtnSttIdx );
/*?*/ 				ASSERT( pFtnHnt, "kein FtnAttribut" );
/*?*/ 				SwIndex aIdx( pTxtNd, nFtnSttIdx );
/*?*/ 				pHistory->Add( pFtnHnt, pTxtNd->GetIndex(), FALSE );
/*?*/ 				pTxtNd->Erase( aIdx, 1 );
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}

	// 2. Flys
/*N*/ 	if( DELCNT_FLY & nDelCntntType )
/*N*/ 	{
/*N*/ 		USHORT nChainInsPos = pHistory ? pHistory->Count() : 0;
/*N*/ 		const SwSpzFrmFmts& rSpzArr = *pDoc->GetSpzFrmFmts();
/*N*/ 		if( rSpzArr.Count() )
/*N*/ 		{
/*N*/ 			const BOOL bDelFwrd = rMark.nNode.GetIndex() <= rPoint.nNode.GetIndex();
/*N*/ 			SwFlyFrmFmt* pFmt;
/*N*/ 			const SwFmtAnchor* pAnchor;
/*N*/ 			USHORT n = rSpzArr.Count();
/*N*/ 			const SwPosition* pAPos;
/*N*/ 
/*N*/ 			while( n && rSpzArr.Count() )
/*N*/ 			{
/*N*/ 				pFmt = (SwFlyFrmFmt*)rSpzArr[--n];
/*N*/ 				pAnchor = &pFmt->GetAnchor();
/*N*/ 				switch( pAnchor->GetAnchorId() )
/*N*/ 				{
/*N*/ 				case FLY_IN_CNTNT:
/*N*/ 					if( 0 != (pAPos = pAnchor->GetCntntAnchor() ) &&
/*N*/ 						(( DELCNT_CHKNOCNTNT & nDelCntntType )
/*N*/ 						? ( pStt->nNode <= pAPos->nNode &&
/*N*/ 							pAPos->nNode < pEnd->nNode )
/*N*/ 						: ( *pStt <= *pAPos && *pAPos < *pEnd )) )
/*N*/ 					{
/*?*/ 						if( !pHistory )
/*?*/ 							pHistory = new SwHistory;
/*?*/ 						SwTxtNode* pTxtNd = pDoc->GetNodes()[ pAPos->nNode]->GetTxtNode();
/*?*/ 						SwTxtAttr* pFlyHnt = pTxtNd->GetTxtAttr( pAPos->nContent.GetIndex());
/*?*/ 						ASSERT( pFlyHnt, "kein FlyAttribut" );
/*?*/ 						pHistory->Add( pFlyHnt, 0, FALSE );
/*?*/ 						// n wieder zurueck, damit nicht ein Format uebesprungen wird !
/*?*/ 						n = n >= rSpzArr.Count() ? rSpzArr.Count() : n+1;
/*N*/ 					}
/*N*/ 					break;
/*N*/ 				case FLY_AT_CNTNT:
/*N*/ 
/*N*/ 					if( 0 != (pAPos = pAnchor->GetCntntAnchor() ) &&
/*N*/ 						(( DELCNT_CHKNOCNTNT & nDelCntntType )
/*N*/ 						? ( pStt->nNode <= pAPos->nNode &&
/*N*/ 							pAPos->nNode < pEnd->nNode )
/*N*/ 						: ( bDelFwrd
/*N*/ 							? rMark.nNode < pAPos->nNode &&
/*N*/ 										pAPos->nNode <= rPoint.nNode
/*N*/ 							: rPoint.nNode <= pAPos->nNode &&
/*N*/ 										pAPos->nNode < rMark.nNode )) )
/*N*/ 					{
/*?*/ 						if( !pHistory )
/*?*/ 							pHistory = new SwHistory;
/*?*/ 
/*?*/ 						// nur den Anker verchieben ??
/*?*/ 						if( !( DELCNT_CHKNOCNTNT & nDelCntntType ) &&
/*?*/ 							rPoint.nNode.GetIndex() == pAPos->nNode.GetIndex())
/*?*/ 						{
/*?*/ 							pHistory->Add( *pFmt );
/*?*/ 
/*?*/ 							SwFmtAnchor aAnch( *pAnchor );
/*?*/ 							SwPosition aPos( rMark.nNode );
/*?*/ 							aAnch.SetAnchor( &aPos );
/*?*/ 							pFmt->SetAttr( aAnch );
/*?*/ 						}
/*?*/ 						else
/*?*/ 						{
/*?*/ 							pHistory->Add( *pFmt, nChainInsPos );
/*?*/ 							// n wieder zurueck, damit nicht ein Format uebesprungen wird !
/*?*/ 							n = n >= rSpzArr.Count() ? rSpzArr.Count() : n+1;
/*?*/ 						}
/*N*/ 					}
/*N*/ 					break;
/*N*/ 				case FLY_AUTO_CNTNT:
/*?*/ 					if( 0 != (pAPos = pAnchor->GetCntntAnchor() ) &&
/*?*/ 						(( DELCNT_CHKNOCNTNT & nDelCntntType )
/*?*/ 						? ( pStt->nNode <= pAPos->nNode &&
/*?*/ 							pAPos->nNode < pEnd->nNode )
/*?*/ 						: ( *pStt <= *pAPos && *pAPos < *pEnd )) )
/*?*/ 					{
/*?*/ 						if( !pHistory )
/*?*/ 							pHistory = new SwHistory;
/*?*/ 						if( ( DELCNT_CHKNOCNTNT & nDelCntntType ) ||
/*?*/ 							( ( pAPos->nNode < pEnd->nNode ) &&
/*?*/ 								( pStt->nNode < pAPos->nNode ||
/*?*/ 								  !pStt->nContent.GetIndex() ) ) )
/*?*/ 						{
/*?*/ 							pHistory->Add( *pFmt, nChainInsPos );
/*?*/ 							n = n >= rSpzArr.Count() ? rSpzArr.Count() : n+1;
/*?*/ 						}
/*?*/ 						else
/*?*/ 						{
/*?*/ 							pHistory->Add( *pFmt );
/*?*/ 
/*?*/ 							SwFmtAnchor aAnch( *pAnchor );
/*?*/ 							aAnch.SetAnchor( &rMark );
/*?*/ 							pFmt->SetAttr( aAnch );
/*?*/ 						}
/*?*/ 					}
/*?*/ 					break;
/*?*/ 				case FLY_AT_FLY:
/*?*/ 
/*?*/ 					if( 0 != (pAPos = pAnchor->GetCntntAnchor() ) &&
/*?*/ 						pStt->nNode == pAPos->nNode )
/*?*/ 					{
/*?*/ 						if( !pHistory )
/*?*/ 							pHistory = new SwHistory;
/*?*/ 
/*?*/ 						pHistory->Add( *pFmt, nChainInsPos );
/*?*/ 
/*?*/ 						// n wieder zurueck, damit nicht ein Format uebesprungen wird !
/*?*/ 						n = n >= rSpzArr.Count() ? rSpzArr.Count() : n+1;
/*?*/ 					}
/*?*/ 					break;
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}

	// 3. Bookmarks
/*N*/ 	if( DELCNT_BKM & nDelCntntType )
/*N*/ 	{
/*N*/ 		const SwBookmarks& rBkmkTbl = pDoc->GetBookmarks();
/*N*/ 		if( rBkmkTbl.Count() )
/*N*/ 		{
/*N*/ 			const SwBookmark* pBkmk;
/*N*/ 
/*N*/ 			for( USHORT n = 0; n < rBkmkTbl.Count(); ++n )
/*N*/ 			{
/*N*/ 				BYTE nTyp = 0;
/*N*/ 				if( ( DELCNT_CHKNOCNTNT & nDelCntntType )
/*N*/ 					? (pStt->nNode <= ( pBkmk = rBkmkTbl[ n ])->GetPos().nNode &&
/*N*/ 									pBkmk->GetPos().nNode < pEnd->nNode )
/*N*/ 					: (*pStt <= ( pBkmk = rBkmkTbl[ n ])->GetPos() &&
/*N*/ 									pBkmk->GetPos() < *pEnd ) )
/*N*/ 					nTyp = SwHstryBookmark::BKMK_POS;
/*N*/ 
/*N*/ 				if( pBkmk->GetOtherPos() &&
/*N*/ 					(( DELCNT_CHKNOCNTNT & nDelCntntType )
/*N*/ 					? (pStt->nNode <= pBkmk->GetOtherPos()->nNode &&
/*N*/ 						pBkmk->GetOtherPos()->nNode < pEnd->nNode )
/*N*/ 					: ( *pStt <= *pBkmk->GetOtherPos() &&
/*N*/ 						*pBkmk->GetOtherPos() < *pEnd )) )
/*?*/ 					nTyp |= SwHstryBookmark::BKMK_OTHERPOS;
/*N*/ 
/*N*/ 				if( nTyp )
/*N*/ 				{
/*N*/ 					if( !pHistory )
/*?*/ 						pHistory = new SwHistory;
/*N*/ 
/*N*/ 					pHistory->Add( *pBkmk, nTyp );
/*N*/ 					if( (SwHstryBookmark::BKMK_OTHERPOS|
/*N*/ 						SwHstryBookmark::BKMK_POS) == nTyp ||
/*N*/ 						( SwHstryBookmark::BKMK_POS == nTyp
/*N*/ 							&& !pBkmk->GetOtherPos() ))
/*N*/ 						pDoc->DelBookmark( n-- );
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pDoc->DoUndo( bDoesUndo );
/*N*/ }


// sicher eine vollstaendige Section im Undo-Nodes-Array

/*N*/ SwUndoSaveSection::SwUndoSaveSection()
/*N*/ 	: nStartPos( ULONG_MAX ), pMvStt( 0 ), nMvLen( 0 ), pRedlSaveData( 0 )
/*N*/ {
/*N*/ }

/*N*/ SwUndoSaveSection::~SwUndoSaveSection()
/*N*/ {
/*N*/ 	if( pMvStt )		// loesche noch den Bereich aus dem UndoNodes Array
/*N*/ 	{
/*?*/ 		// SaveSection speichert den Inhalt in der PostIt-Section
/*?*/ 		SwNodes& rUNds = pMvStt->GetNode().GetNodes();
/*?*/ 		rUNds.Delete( *pMvStt, nMvLen );
/*?*/ 
/*?*/ 		delete pMvStt;
/*N*/ 	}
/*N*/ 	delete pRedlSaveData;
/*N*/ }

/*N*/ void SwUndoSaveSection::SaveSection( SwDoc* pDoc, const SwNodeIndex& rSttIdx )
/*N*/ {
/*N*/ 	SwNodeRange aRg( rSttIdx.GetNode(), *rSttIdx.GetNode().EndOfSectionNode() );
/*N*/ 	SaveSection( pDoc, aRg );
/*N*/ }


/*N*/ void SwUndoSaveSection::SaveSection( SwDoc* pDoc, const SwNodeRange& rRange )
/*N*/ {
/*N*/ 	SwPaM aPam( rRange.aStart, rRange.aEnd );
/*N*/ 
/*N*/ 	// loesche alle Fussnoten / FlyFrames / Bookmarks / Verzeichnisse
/*N*/ 	DelCntntIndex( *aPam.GetMark(), *aPam.GetPoint() );
/*N*/ 
/*N*/ 	pRedlSaveData = new SwRedlineSaveDatas;
/*N*/ 	if( !SwUndo::FillSaveData( aPam, *pRedlSaveData, TRUE, TRUE ))
/*N*/ 		delete pRedlSaveData, pRedlSaveData = 0;
/*N*/ 
/*N*/ 	nStartPos = rRange.aStart.GetIndex();
/*N*/ 
/*N*/ 	aPam.GetPoint()->nNode--;
/*N*/ 	aPam.GetMark()->nNode++;
/*N*/ 
/*N*/ 	SwCntntNode* pCNd = aPam.GetCntntNode( FALSE );
/*N*/ 	if( pCNd )
/*N*/ 		aPam.GetMark()->nContent.Assign( pCNd, 0 );
/*N*/ 	if( 0 != ( pCNd = aPam.GetCntntNode( TRUE )) )
/*N*/ 		aPam.GetPoint()->nContent.Assign( pCNd, pCNd->Len() );
/*N*/ 
/*N*/ 	// Positionen als SwIndex merken, damit im DTOR dieser Bereich
/*N*/ 	// entfernt werden kann !!
/*N*/ 	ULONG nEnd;
/*N*/ 	pMvStt = new SwNodeIndex( rRange.aStart );
/*N*/ 	MoveToUndoNds( aPam, pMvStt, 0, &nEnd, 0 );
/*N*/ 	nMvLen = nEnd - pMvStt->GetIndex() + 1;
/*N*/ }

//STRIP001 void SwUndoSaveSection::RestoreSection( SwDoc* pDoc, SwNodeIndex* pIdx,
//STRIP001 										USHORT nSectType )
//STRIP001 {
//STRIP001 	if( ULONG_MAX != nStartPos )		// gab es ueberhaupt Inhalt ?
//STRIP001 	{
//STRIP001 		// ueberpruefe, ob der Inhalt an der alten Position steht
//STRIP001 		SwNodeIndex aSttIdx( pDoc->GetNodes(), nStartPos );
//STRIP001 		ASSERT( !pDoc->GetNodes()[ aSttIdx ]->GetCntntNode(),
//STRIP001 				"Position in irgendeiner Section" );
//STRIP001 
//STRIP001 		// move den Inhalt aus dem UndoNodes-Array in den Fly
//STRIP001 		SwStartNode* pSttNd = pDoc->GetNodes().MakeEmptySection( aSttIdx,
//STRIP001 												(SwStartNodeType)nSectType );
//STRIP001 
//STRIP001 		RestoreSection( pDoc, SwNodeIndex( *pSttNd->EndOfSectionNode() ));
//STRIP001 
//STRIP001 		if( pIdx )
//STRIP001 			*pIdx = *pSttNd;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoSaveSection::RestoreSection( SwDoc* pDoc, const SwNodeIndex& rInsPos )
//STRIP001 {
//STRIP001 	if( ULONG_MAX != nStartPos )		// gab es ueberhaupt Inhalt ?
//STRIP001 	{
//STRIP001 		SwPosition aInsPos( rInsPos );
//STRIP001 		ULONG nEnd = pMvStt->GetIndex() + nMvLen - 1;
//STRIP001 		MoveFromUndoNds( *pDoc, pMvStt->GetIndex(), 0, aInsPos, &nEnd, 0 );
//STRIP001 
//STRIP001 		// Indizies wieder zerstoren, Inhalt ist aus dem UndoNodes-Array
//STRIP001 		// entfernt worden.
//STRIP001 		DELETEZ( pMvStt );
//STRIP001 		nMvLen = 0;
//STRIP001 
//STRIP001 		if( pRedlSaveData )
//STRIP001 		{
//STRIP001 			SwUndo::SetSaveData( *pDoc, *pRedlSaveData );
//STRIP001 			delete pRedlSaveData, pRedlSaveData = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


// START
/*N*/ SwUndoStart::SwUndoStart( USHORT nId )
/*N*/ 	: SwUndo( UNDO_START ), nUserId( nId ), nEndOffset( 0 )
/*N*/ {
/*N*/ }

//STRIP001 void SwUndoStart::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( !( --rUndoIter.nEndCnt ) && rUndoIter.bWeiter &&
//STRIP001 		( rUndoIter.GetId() ? ( rUndoIter.GetId() == nUserId ||
//STRIP001 		( UNDO_END == rUndoIter.GetId() && UNDO_START == GetId() )) : TRUE ))
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 }

//STRIP001 void SwUndoStart::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.bWeiter = TRUE;
//STRIP001 	++rUndoIter.nEndCnt;
//STRIP001 }

//STRIP001 void SwUndoStart::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.bWeiter = FALSE;
//STRIP001 }


// END
/*N*/ SwUndoEnd::SwUndoEnd( USHORT nId )
/*N*/ 	: SwUndo( UNDO_END ), nUserId( nId ), nSttOffset( 0 )
/*N*/ {
/*N*/ }

//STRIP001 void SwUndoEnd::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( rUndoIter.GetId() == GetId() || !rUndoIter.GetId() )
//STRIP001 		rUndoIter.bWeiter = TRUE;
//STRIP001 	if( rUndoIter.bWeiter )
//STRIP001 		++rUndoIter.nEndCnt;
//STRIP001 }

//STRIP001 void SwUndoEnd::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( !( --rUndoIter.nEndCnt ) && rUndoIter.bWeiter &&
//STRIP001 		( rUndoIter.GetId() ? ( rUndoIter.GetId() == nUserId ||
//STRIP001 		( UNDO_END == rUndoIter.GetId() && UNDO_START == GetId() )) : TRUE ))
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 }

//STRIP001 void SwUndoEnd::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.bWeiter = FALSE;
//STRIP001 }

/*  */
		// sicher und setze die RedlineDaten

/*N*/ SwRedlineSaveData::SwRedlineSaveData( SwComparePosition eCmpPos,
/*N*/ 										const SwPosition& rSttPos,
/*N*/ 										const SwPosition& rEndPos,
/*N*/ 										SwRedline& rRedl,
/*N*/ 										BOOL bCopyNext )
/*N*/ 	: SwUndRng( rRedl ),
/*N*/ 	SwRedlineData( rRedl.GetRedlineData(), bCopyNext )
/*N*/ {
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	ASSERT( POS_OUTSIDE == eCmpPos ||
//STRIP001 			!rRedl.GetContentIdx(), "Redline mit Content" );
//STRIP001 
//STRIP001 	switch( eCmpPos )
//STRIP001 	{
//STRIP001 	case POS_OVERLAP_BEFORE:		// Pos1 ueberlappt Pos2 am Anfang
//STRIP001 		nEndNode = rEndPos.nNode.GetIndex();
//STRIP001 		nEndCntnt = rEndPos.nContent.GetIndex();
//STRIP001 		break;
//STRIP001 	case POS_OVERLAP_BEHIND: 		// Pos1 ueberlappt Pos2 am Ende
//STRIP001 		nSttNode = rSttPos.nNode.GetIndex();
//STRIP001 		nSttCntnt = rSttPos.nContent.GetIndex();
//STRIP001 		break;
//STRIP001 
//STRIP001 	case POS_INSIDE:				// Pos1 liegt vollstaendig in Pos2
//STRIP001 		nSttNode = rSttPos.nNode.GetIndex();
//STRIP001 		nSttCntnt = rSttPos.nContent.GetIndex();
//STRIP001 		nEndNode = rEndPos.nNode.GetIndex();
//STRIP001 		nEndCntnt = rEndPos.nContent.GetIndex();
//STRIP001 		break;
//STRIP001 
//STRIP001 	case POS_OUTSIDE:				// Pos2 liegt vollstaendig in Pos1
//STRIP001 		if( rRedl.GetContentIdx() )
//STRIP001 		{
//STRIP001 			// dann den Bereich ins UndoArray verschieben und merken
//STRIP001 			SaveSection( rRedl.GetDoc(), *rRedl.GetContentIdx() );
//STRIP001 			rRedl.SetContentIdx( 0 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case POS_EQUAL:					// Pos1 ist genauso gross wie Pos2
//STRIP001 		break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		ASSERT( !this, "keine gueltigen Daten!" )
//STRIP001 	}
//STRIP001 			
//STRIP001 #ifndef PRODUCT
//STRIP001     nRedlineCount = rSttPos.nNode.GetNode().GetDoc()->GetRedlineTbl().Count();
//STRIP001 #endif
/*N*/ }

//STRIP001 SwRedlineSaveData::~SwRedlineSaveData()
//STRIP001 {
//STRIP001 }

//STRIP001 void SwRedlineSaveData::RedlineToDoc( SwPaM& rPam )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = *rPam.GetDoc();
//STRIP001 	SwRedline* pRedl = new SwRedline( *this, rPam );
//STRIP001 
//STRIP001 	if( GetMvSttIdx() )
//STRIP001 	{
//STRIP001 		SwNodeIndex aIdx( rDoc.GetNodes() );
//STRIP001 		RestoreSection( &rDoc, &aIdx, SwNormalStartNode );
//STRIP001 		if( GetHistory() )
//STRIP001 			GetHistory()->Rollback( &rDoc );
//STRIP001 		pRedl->SetContentIdx( &aIdx );
//STRIP001 	}
//STRIP001 	SetPaM( *pRedl );
//STRIP001 	// erstmal die "alten" entfernen, damit im Append keine unerwarteten
//STRIP001 	// Dinge passieren, wie z.B. eine Delete in eigenen Insert. Dann wird
//STRIP001 	// naehmlich das gerade restaurierte wieder geloescht - nicht das gewollte
//STRIP001 	rDoc.DeleteRedline( *pRedl, FALSE );
//STRIP001 
//STRIP001 	SwRedlineMode eOld = rDoc.GetRedlineMode();
//STRIP001 	rDoc.SetRedlineMode_intern( eOld | REDLINE_DONTCOMBINE_REDLINES );
//STRIP001 	rDoc.AppendRedline( pRedl );
//STRIP001 	rDoc.SetRedlineMode_intern( eOld );
//STRIP001 }

/*N*/ BOOL SwUndo::FillSaveData( const SwPaM& rRange, SwRedlineSaveDatas& rSData,
/*N*/ 							BOOL bDelRange, BOOL bCopyNext )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 	if( rSData.Count() )
//STRIP001 		rSData.DeleteAndDestroy( 0, rSData.Count() );
//STRIP001 
//STRIP001 	SwRedlineSaveData* pNewData;
//STRIP001 	const SwPosition *pStt = rRange.Start(), *pEnd = rRange.End();
//STRIP001 	const SwRedlineTbl& rTbl = rRange.GetDoc()->GetRedlineTbl();
//STRIP001 	USHORT n = 0;
//STRIP001 	rRange.GetDoc()->GetRedline( *pStt, &n );
//STRIP001 	for( ; n < rTbl.Count(); ++n )
//STRIP001 	{
//STRIP001 		SwRedline* pRedl = rTbl[ n ];
//STRIP001 		const SwPosition *pRStt = pRedl->Start(), *pREnd = pRedl->End();
//STRIP001 
//STRIP001 		SwComparePosition eCmpPos = ComparePosition( *pStt, *pEnd, *pRStt, *pREnd );
//STRIP001 		if( POS_BEFORE != eCmpPos && POS_BEHIND != eCmpPos &&
//STRIP001 			POS_COLLIDE_END != eCmpPos && POS_COLLIDE_START != eCmpPos )
//STRIP001 		{
//STRIP001 			pNewData = new SwRedlineSaveData( eCmpPos, *pStt, *pEnd,
//STRIP001 												*pRedl, bCopyNext );
//STRIP001 			rSData.Insert( pNewData, rSData.Count() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( rSData.Count() && bDelRange )
//STRIP001 		rRange.GetDoc()->DeleteRedline( rRange, FALSE );
//STRIP001 	return 0 != rSData.Count();
/*N*/ }

//STRIP001 BOOL SwUndo::FillSaveDataForFmt( const SwPaM& rRange, SwRedlineSaveDatas& rSData )
//STRIP001 {
//STRIP001 	if( rSData.Count() )
//STRIP001 		rSData.DeleteAndDestroy( 0, rSData.Count() );
//STRIP001 
//STRIP001 	SwRedlineSaveData* pNewData;
//STRIP001 	const SwPosition *pStt = rRange.Start(), *pEnd = rRange.End();
//STRIP001 	const SwRedlineTbl& rTbl = rRange.GetDoc()->GetRedlineTbl();
//STRIP001 	USHORT n = 0;
//STRIP001 	rRange.GetDoc()->GetRedline( *pStt, &n );
//STRIP001 	for( ; n < rTbl.Count(); ++n )
//STRIP001 	{
//STRIP001 		SwRedline* pRedl = rTbl[ n ];
//STRIP001 		if( REDLINE_FORMAT == pRedl->GetType() )
//STRIP001 		{
//STRIP001 			const SwPosition *pRStt = pRedl->Start(), *pREnd = pRedl->End();
//STRIP001 
//STRIP001 			SwComparePosition eCmpPos = ComparePosition( *pStt, *pEnd, *pRStt, *pREnd );
//STRIP001 			if( POS_BEFORE != eCmpPos && POS_BEHIND != eCmpPos &&
//STRIP001 				POS_COLLIDE_END != eCmpPos && POS_COLLIDE_START != eCmpPos )
//STRIP001 			{
//STRIP001 				pNewData = new SwRedlineSaveData( eCmpPos, *pStt, *pEnd,
//STRIP001 													*pRedl, TRUE );
//STRIP001 				rSData.Insert( pNewData, rSData.Count() );
//STRIP001 			}
//STRIP001 
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0 != rSData.Count();
//STRIP001 }

//STRIP001 void SwUndo::SetSaveData( SwDoc& rDoc, const SwRedlineSaveDatas& rSData )
//STRIP001 {
//STRIP001 	SwRedlineMode eOld = rDoc.GetRedlineMode();
//STRIP001 	rDoc.SetRedlineMode_intern( ( eOld & ~REDLINE_IGNORE) | REDLINE_ON );
//STRIP001 	SwPaM aPam( rDoc.GetNodes().GetEndOfContent() );
//STRIP001 
//STRIP001 	for( USHORT n = rSData.Count(); n; )
//STRIP001 		rSData[ --n ]->RedlineToDoc( aPam );
//STRIP001 
//STRIP001     // check redline count against count saved in RedlineSaveData object
//STRIP001     DBG_ASSERT( (rSData.Count() == 0) ||
//STRIP001                 (rSData[0]->nRedlineCount == rDoc.GetRedlineTbl().Count()), 
//STRIP001                 "redline count not restored properly" );
//STRIP001 
//STRIP001 	rDoc.SetRedlineMode_intern( eOld );
//STRIP001 }

//STRIP001 BOOL SwUndo::HasHiddenRedlines( const SwRedlineSaveDatas& rSData )
//STRIP001 {
//STRIP001 	for( USHORT n = rSData.Count(); n; )
//STRIP001 		if( rSData[ --n ]->GetMvSttIdx() )
//STRIP001 			return TRUE;
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL SwUndo::CanRedlineGroup( SwRedlineSaveDatas& rCurr,
//STRIP001 						const SwRedlineSaveDatas& rCheck, BOOL bCurrIsEnd )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( rCurr.Count() == rCheck.Count() )
//STRIP001 	{
//STRIP001 		bRet = TRUE;
//STRIP001 		for( USHORT n = 0; n < rCurr.Count(); ++n )
//STRIP001 		{
//STRIP001 			const SwRedlineSaveData& rSet = *rCurr[ n ];
//STRIP001 			const SwRedlineSaveData& rGet = *rCheck[ n ];
//STRIP001 			if( rSet.nSttNode != rGet.nSttNode ||
//STRIP001 				rSet.GetMvSttIdx() || rGet.GetMvSttIdx() ||
//STRIP001 				( bCurrIsEnd ? rSet.nSttCntnt != rGet.nEndCntnt
//STRIP001 							 : rSet.nEndCntnt != rGet.nSttCntnt ) ||
//STRIP001 				!rGet.CanCombine( rSet ) )
//STRIP001 			{
//STRIP001 				bRet = FALSE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bRet )
//STRIP001 			for( n = 0; n < rCurr.Count(); ++n )
//STRIP001 			{
//STRIP001 				SwRedlineSaveData& rSet = *rCurr[ n ];
//STRIP001 				const SwRedlineSaveData& rGet = *rCheck[ n ];
//STRIP001 				if( bCurrIsEnd )
//STRIP001 					rSet.nSttCntnt = rGet.nSttCntnt;
//STRIP001 				else
//STRIP001 					rSet.nEndCntnt = rGet.nEndCntnt;
//STRIP001 			}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

}
