/* ----------------------------------------------------------------------------
 * pbbuttons.c
 * Daemon to put the Apple Powerbook special keys into action.
 * This version works as deamon without any interface.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <syslog.h>
#include <signal.h>
#include <sys/types.h>

#include <pbb.h>

#include "init.h"
#include "input_manager.h"
#include "gettext_macros.h"

volatile sig_atomic_t prgexit = 0;
volatile sig_atomic_t reloadcfg = 0;
volatile sig_atomic_t reset = 0;

int main(int argc, char *argv[])
{
	struct serverdata sdata, *sd = &sdata;
	int val, maxfd, rc = 1;
	fd_set inset;
	struct timeval tv;
	long tval;

#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain(PACKAGE);
#endif
	init_libpbb();              /* initialising pbblib */
	init_serverdata (sd);        /* fill serverdata structure with default values */
	if ((rc = evaluate_args(sd, argc, argv)) == 0) {  /* evaluate command line */
		if ((rc = init_modules (sd)) == 0) {      /* call known modules for initialisation */
			if (!install_sighandler ()) {
				tval = process_queue_single (QUERYQUEUE, TAG_IDENTITY, 0);
				if (!sd->quiet && tval)
					printf ("%s %s: %s\n", PACKAGE, VERSION, (char*) tval);

				if ((create_daemon ()) == 0) {
					if (tval) syslog (LOG_INFO, "INFO: %s %s: %s\n", PACKAGE, VERSION, (char*) tval);
					tval = process_queue_single (QUERYQUEUE, TAG_POWERSOURCE, 0);
					process_queue_single (CONFIGQUEUE, TAG_POWERCHANGED, tval); /* start profile changed script */

					while (prgexit == 0) {
						tv.tv_sec = 0; tv.tv_usec = 10000;  /* 10ms polling timeout */
						maxfd = create_fdset(&inset);    /* prepare filehandles for select */
						if ((val = select (maxfd+1, &inset, NULL, NULL, &tv)) >= 0) {
							if (val == 0)
								call_timertick();        /* call timer handler */
							else
								call_inputhandler(&inset); /* call input handler */
						}
						if (reloadcfg == 1) {      /* SIGHUP received ? */
							scanEventDevices ();   /* look which HID are available */
							reconfig_modules (sd); /* load config file again */
							reloadcfg = 0;
						}
						if (reset == 1) {          /* SIGUSR1 received ? */
							process_queue_single (CONFIGQUEUE, TAG_REINIT, 0);
							reset = 0;
						}
					}
				}
				rc = 0;
			}
			exit_modules (sd);  /* let modules cleanup their stuff */
		}
	}
	exit_libpbb();            /* cleanup library */
	if (rc == E_INFO) rc = 0; /* E_INFO isn't a real error */
	exit (rc);
}
