/* ----------------------------------------------------------------------------
 * pbbuttons.c
 * Daemon to put the Apple Powerbook special keys into action.
 * This version works as deamon without any interface.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <syslog.h>
#include <signal.h>
#include <sys/types.h>

#include <glib.h>
#include <pbb.h>

#include "init.h"
#include "input_manager.h"
#include "gettext_macros.h"

int main(int argc, char *argv[])
{
	struct serverdata sdata, *sd = &sdata;
	gint timerid10, timerid100, timerid1000;
	int rc = 1;
	long tval;

#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain(PACKAGE);
#endif
	init_libpbb();              /* initialising pbblib */
	init_serverdata (sd);        /* fill serverdata structure with default values */
	if ((rc = evaluate_args(sd, argc, argv)) == 0) {  /* evaluate command line */
		if ((rc = init_modules (sd)) == 0) {      /* call known modules for initialisation */
			tval = process_queue_single (QUERYQUEUE, TAG_IDENTITY, 0);
			if (!sd->quiet && tval)
				printf ("%s %s: %s\n", PACKAGE, VERSION, (char*) tval);

			if ((create_daemon ()) == 0) {
				if (tval) syslog (LOG_INFO, "INFO: %s %s: %s\n", PACKAGE, VERSION, (char*) tval);
				tval = process_queue_single (QUERYQUEUE, TAG_POWERSOURCE, 0);
				process_queue_single (CONFIGQUEUE, TAG_POWERCHANGED, tval); /* start profile changed script */

				sd->mainloop = g_main_loop_new (NULL, TRUE);
				installSigHandler (sd);

				timerid10 = g_timeout_add (10, cb_timer10, NULL);
				timerid100 = g_timeout_add (100, cb_timer100, NULL);
				timerid1000 = g_timeout_add (1000, cb_timer1000, NULL);
					
				g_main_loop_run (sd->mainloop);
				
				g_source_remove (timerid10);
				g_source_remove (timerid100);
				g_source_remove (timerid1000);
				g_main_loop_unref (sd->mainloop);
			}
			exit_modules (sd);  /* let modules cleanup their stuff */
			rc = 0;
		}
	}
	exit_libpbb();            /* cleanup library */
	if (rc == E_INFO) rc = 0; /* E_INFO isn't a real error */
	exit (rc);
}
