# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding multiple viewports example
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>

import sys, pgm

# Terminate the mainloop on a delete event
def on_delete(viewport, event):
    pgm.main_quit()

# Display the event and the viewport on a motion-notify event
def on_motion_notify(viewport, event):
    print 'Received', event, 'on', viewport

def main(args):
    factory = pgm.ViewportFactory('opengl')

    # OpenGL viewport 1 creation
    gl1 = factory.create()
    gl1.title = 'OpenGL viewport <1>'
    gl1.connect('delete-event', on_delete)
    gl1.connect('motion-notify-event', on_motion_notify)

    # OpenGL viewport 2 creation
    gl2 = factory.create()
    gl2.title = 'OpenGL viewport <2>'
    gl2.connect('delete-event', on_delete)
    gl2.connect('motion-notify-event', on_motion_notify)

    # Canvas and image drawable creation
    cvs = pgm.Canvas()
    img = pgm.Image()

    # Load an image from a file descriptor
    img.set_from_file('examples/pictures/fluendo.png')

    # Center the image
    img.position = (1.5, 1.0, 0.0)

    # A drawable needs to be shown
    img.show()

    # Add it to the middle layer of the canvas
    cvs.add(pgm.DRAWABLE_MIDDLE, img)

    # Bind the canvas to the viewports
    gl1.set_canvas(cvs)
    gl2.set_canvas(cvs)

    # Let's start the mainloop
    gl1.show()
    gl2.show()
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
