/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_IMAGE_H__
#define __PGM_GLES_IMAGE_H__

#include "pgmglesdrawable.h"
#include "pgmglestexture.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_IMAGE (pgm_gles_image_get_type())
#define PGM_GLES_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_IMAGE, PgmGlesImage))
#define PGM_GLES_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_IMAGE, PgmGlesImageClass))
#define PGM_IS_GLES_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_IMAGE))
#define PGM_IS_GLES_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_IMAGE))
#define PGM_GLES_IMAGE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_IMAGE, PgmGlesImageClass))

typedef struct _PgmGlesImage      PgmGlesImage;
typedef struct _PgmGlesImageClass PgmGlesImageClass;

struct _PgmGlesImage {
  PgmGlesDrawable parent;

  /* Aspect ratios */
  gfloat drawable_ratio;
  gfloat image_ratio;

  /* Last position */
  gfloat last_x, last_y, last_z;

  /* Alignment coeficients */
  gfloat h_align, v_align;

  /* Drawing condition */
  gboolean empty;

  /* Textures */
  PgmGlesTexture *native_texture;
  PgmGlesTexture *texture;

  /* Image vertex arrays */
  PgmGlesFloat fg_color[16];
  PgmGlesFloat coord[8];
  PgmGlesFloat vertex[12];

  /* Image border vertex arrays */
  PgmGlesFloat border_vertex[36];
  PgmGlesFloat border_color[48];
  gfloat       border_width;
};

struct _PgmGlesImageClass {
  PgmGlesDrawableClass parent_class;
};

GType            pgm_gles_image_get_type               (void) G_GNUC_CONST;

PgmGlesDrawable *pgm_gles_image_new                    (PgmDrawable *drawable,
                                                        PgmGlesViewport *glesviewport);

void             pgm_gles_image_register               (GTypeModule *module);

void             pgm_gles_image_clear                  (PgmGlesImage *glesimage);
void             pgm_gles_image_set_from_buffer        (PgmGlesImage *glesimage);
void             pgm_gles_image_set_from_gst_buffer    (PgmGlesImage *glesimage);
void             pgm_gles_image_set_from_pixbuf        (PgmGlesImage *glesimage);
void             pgm_gles_image_set_from_image         (PgmGlesImage *glesimage);
void             pgm_gles_image_set_mapping_matrix     (PgmGlesImage *glesimage);
void             pgm_gles_image_set_alignment          (PgmGlesImage *glesimage);
void             pgm_gles_image_set_layout             (PgmGlesImage *glesimage);
void             pgm_gles_image_set_interp             (PgmGlesImage *glesimage);
void             pgm_gles_image_set_aspect_ratio       (PgmGlesImage *glesimage);
void             pgm_gles_image_set_border_width       (PgmGlesImage *glesimage);
void             pgm_gles_image_set_border_inner_color (PgmGlesImage *glesimage);
void             pgm_gles_image_set_border_outer_color (PgmGlesImage *glesimage);

G_END_DECLS

#endif /* __PGM_GLES_IMAGE_H__ */
