#ifndef _PS3PF_PCI_RES_H_
#define _PS3PF_PCI_RES_H_

//#define PS3PF_PCI_DEBUG

#define PS3PF_PCI_INT_MAX    4
#define PS3PF_PCI_REGION_MAX 4
#define PS3PF_PCI_DEV_MAX    32
#define PS3PF_PCI_IRQ_MAX    64 

#define PS3PF_PCI_BUS_MAX    3
#define PS3PF_PCI_ID_IPCI    1
#define PS3PF_PCI_ID_EPCI    2
#define PS3PF_PCI_ID_PCIEX   3
#define PS3PF_PCI_ID_STORAGE 4

#define PS3PF_PCI_DEV_TYPE_UNKNOWN 0
#define PS3PF_PCI_DEV_TYPE_UHC     4

#define PS3PF_PCI_REGION_TYPE_MEM  1
#define PS3PF_PCI_REGION_TYPE_IO   2

#define PS3PF_PCI_IO_PAGESIZE      24         /* 16M pages */

#ifdef CONFIG_PPC_64K_PAGES
#define PS3PF_PCI_MMIO_PAGESIZE    16         /* 64k pages */
#else
#define PS3PF_PCI_MMIO_PAGESIZE    12         /* 4k pages */
#endif

#define PS3PF_BUS_REPOSITORY_BUS		"bus"
#define PS3PF_BUS_REPOSITORY_DEVICE		"dev"
#define PS3PF_BUS_REPOSITORY_REGION		"reg"
#define PS3PF_BUS_REPOSITORY_ID			"id"
#define PS3PF_BUS_REPOSITORY_INTERRUPT		"intr"
#define PS3PF_BUS_REPOSITORY_TYPE		"type"
#define PS3PF_BUS_REPOSITORY_DATA		"data"
#define PS3PF_BUS_REPOSITORY_PCI_BUS		"pci_bus"
#define PS3PF_BUS_REPOSITORY_PCI_DEV		"pci_dev"
#define PS3PF_BUS_REPOSITORY_PCI_FUNC		"pci_fun"
#define PS3PF_BUS_REPOSITORY_NUM_DEV		"num_dev"

#define PS3PF_BUS_REPOSITORY_PLAT		"plat"


#ifdef PS3PF_PCI_DEBUG 
#define DPRINTK(fmt, args...) \
	do { printk("PS3PF PCI " fmt, ## args); } while (0)
#else
#define DPRINTK(fmt, args...) do { } while (0)
#endif

/* read resources functions */
extern int ps3pf_pci_read_platform_id(uint64_t *);
extern int ps3pf_pci_read_bus_id(uint64_t, uint64_t *);
extern int ps3pf_pci_read_bus_type(uint64_t, uint64_t *);
extern int ps3pf_pci_read_num_of_dev(uint64_t, uint64_t *);
extern int ps3pf_pci_read_device_id(uint64_t, uint64_t, uint64_t *);
extern int ps3pf_pci_read_device_type(uint64_t, uint64_t, uint64_t *);
extern int ps3pf_pci_read_pci_bus(uint64_t, uint64_t, uint64_t *);
extern int ps3pf_pci_read_pci_device(uint64_t, uint64_t, uint64_t *);
extern int ps3pf_pci_read_pci_func(uint64_t, uint64_t, uint64_t *);
extern int ps3pf_pci_read_interrupt(uint64_t, uint64_t, uint64_t, 
					uint64_t *, uint64_t *);
extern int ps3pf_pci_read_region_type(uint64_t, uint64_t, 
					uint64_t, uint64_t *);
extern int ps3pf_pci_read_region_data(uint64_t, uint64_t, 
					uint64_t, uint64_t *, uint64_t *);

#endif // _PS3PF_PCI_RES_H_

