
#ifndef __SPU_PRIV_H__
#define __SPU_PRIV_H__

#include <asm/spu.h>

struct spu_shadow {
	u8 padding_0000[0x0140];

	u64 int_status_class0_RW;	/* 0x0140 */
	u64 int_status_class1_RW;	/* 0x0148 */
	u64 int_status_class2_RW;	/* 0x0150 */

	u8 padding_0158[0x0610-0x0158];

	u64 mfc_dsisr_RW;		/* 0x0610 */

	u8 padding_0618[0x0620-0x0618];

	u64 mfc_dar_RW;			/* 0x0620 */

	u8 padding_0628[0x0800-0x0628];

	u64 mfc_dsipr_R;		/* 0x0800 */

	u8 padding_0808[0x0810-0x0808];

	u64 mfc_lscrr_R;		/* 0x0810 */

	u8 padding_0818[0x0c00-0x0818];

	u64 mfc_cer_R;			/* 0x0c00 */

	u8 padding_0c08[0x0f00-0x0c08];

	u64 spu_execution_status;	/* 0x0f00 */

	u8 padding_0f08[0x1000-0x0f08];
};

struct spu_priv_data {
	char name[20];
	u64 lspu_id;

	unsigned long irq_outlet[3];
	unsigned int irq_no[3];
	unsigned int irq_cpu[3];

	u64 irq_mask[3];
	u64 mfc_sr1;
	u64 mfc_tclass_id;
	spinlock_t regs_lock;

	u64 ls_phys;
	u64 problem_phys;
	u64 priv2_phys;
	u64 shadow_phys;
	struct spu_shadow __iomem *shadow;
};

extern struct spu_priv_data spu_data[];

extern void ps3pf_spu_release_all(void);

#endif /* __SPU_PRIV_H__ */
