import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored
from launchpadbugs.lpconstants import HTTPCONNECTION
from launchpadbugs.html_projectlist import ProjectPackagePage, ProjectPage, PInfo, PKGInfo, ProjectList, ProjectPackageList
from launchpadbugs.http_connection import HTTPConnection

con = None

class HTMLProjectPackagePageTestCase(PyLPBugsTestCase):
    
    def test_001_setup_HTTPConnection(self):
        """ prepare the HTTPConnection object """
        global con
        con = HTTPConnection()
            
    def test_002_package(self):
        """[STABLE/EDGE] test packages of distro"""
        url = "https://launchpad.net/ubuntu/+allpackages"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            packageiter, next, batchsize, length = ProjectPackagePage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                package = packageiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(package, PKGInfo), "wrong type of 'package' in mode '%s'" %k)
            
    def test_003_projects(self):
        """[STABLE/EDGE] test project list"""
        url = "https://launchpad.net/projects/+all"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            projectiter, next, batchsize, length = ProjectPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                project = projectiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(project, PInfo), "wrong type of 'project' in mode '%s'" %k)
        

if __name__ == '__main__':
    import unittest
    
    HTMLProjectPackagePageTestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLProjectPackagePageTestCase)
    
    alltests = PyLPBugsTestSuite((HTMLProjectPackagePageTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
