import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, SkipSuiteError

from launchpadbugs.connector import ConnectBug
from launchpadbugs.lpconstants import HTTPCONNECTION

COOKIEFILE = ConfigTest()["test_examples"]["cookiefile"]
TestBug = None

class HTMLBugParse_STABLE_TestCase(PyLPBugsTestCase):
    """ [STABLE] parsing bugreports in html mode """
    
    def test_000_get_bugreport(self):
        """[STABLE] load bugreport"""
        HBug = ConnectBug()
        if COOKIEFILE:
            HBug.authentication = COOKIEFILE
        HBug.set_connection_mode(HTTPCONNECTION.MODE.STABLE)
        global TestBug
        try:
            TestBug = HBug(1)
        except:
            raise SkipSuiteError
        
    def test_001_1_check_url(self):
        """[STABLE] check bug url"""
        self.assert_(TestBug.url, "https://bugs.launchpad.net/ubuntu/+bug/1")
        
    def test_001_2_parse_bugreport(self):
        """[STABLE] parse bug.bugreport"""
        self.failIfRaises(Exception, TestBug._Bug__bugreport.parse)
        
    def test_002_parse_infotable(self):
        """[STABLE] parse bug.infotable"""
        self.failIfRaises(Exception, TestBug._Bug__infotable.parse)
        
    def test_003_parse_comments(self):
        """[STABLE] parse bug.comments"""
        self.failIfRaises(Exception, TestBug._Bug__comments.parse)
        
    def test_004_parse_attachments(self):
        """[STABLE] parse bug.attachments"""
        self.failIfRaises(Exception, TestBug._Bug__attachments.parse)
        
    def test_005_parse_duplicates(self):
        """[STABLE] parse bug.duplicates"""
        self.failIfRaises(Exception, TestBug._Bug__duplicates.parse)
        
    def test_006_parse_secrecy(self):
        """[STABLE] parse bug.secrecy"""
        self.failIfRaises(Exception, TestBug._Bug__secrecy.parse)
        
    def test_007_parse_subscribers(self):
        """[STABLE] parse bug.subscribers"""
        self.failIfRaises(Exception, TestBug._Bug__subscribers.parse)
        
    def test_008_parse_mentor(self):
        """[STABLE] parse bug.mentor"""
        self.failIfRaises(Exception, TestBug._Bug__mentor.parse)
        
    def test_009_parse_activity(self):
        """[STABLE] parse bug.activity"""
        self.failIfRaises(Exception, TestBug._Bug__activity.parse)
    
class HTMLBugParse_EDGE_TestCase(PyLPBugsTestCase):
    """ [EDGE] parsing bugreports in html mode """
    
    def test_000_get_bugreport(self):
        """[EDGE] load bugreport"""
        HBug = ConnectBug()
        if COOKIEFILE:
            HBug.authentication = COOKIEFILE
        HBug.set_connection_mode(HTTPCONNECTION.MODE.EDGE)
        global TestBug
        try:
            TestBug = HBug(1)
        except:
            raise SkipSuiteError
        
    def test_001_1_check_url(self):
        """[EDGE] check bug url"""
        self.assert_(TestBug.url, "https://bugs.edge.launchpad.net/ubuntu/+bug/1")
        
    def test_001_2_parse_bugreport(self):
        """[EDGE] parse bug.bugreport"""
        self.failIfRaises(Exception, TestBug._Bug__bugreport.parse)
        
    def test_002_parse_infotable(self):
        """[EDGE] parse bug.infotable"""
        self.failIfRaises(Exception, TestBug._Bug__infotable.parse)
        
    def test_003_parse_comments(self):
        """[EDGE] parse bug.comments"""
        self.failIfRaises(Exception, TestBug._Bug__comments.parse)
        
    def test_004_parse_attachments(self):
        """[EDGE] parse bug.attachments"""
        self.failIfRaises(Exception, TestBug._Bug__attachments.parse)
        
    def test_005_parse_duplicates(self):
        """[EDGE] parse bug.duplicates"""
        self.failIfRaises(Exception, TestBug._Bug__duplicates.parse)
        
    def test_006_parse_secrecy(self):
        """[EDGE] parse bug.secrecy"""
        self.failIfRaises(Exception, TestBug._Bug__secrecy.parse)
        
    def test_007_parse_subscribers(self):
        """[EDGE] parse bug.subscribers"""
        self.failIfRaises(Exception, TestBug._Bug__subscribers.parse)
        
    def test_008_parse_mentor(self):
        """[EDGE] parse bug.mentor"""
        self.failIfRaises(Exception, TestBug._Bug__mentor.parse)
        
    def test_009_parse_activity(self):
        """[EDGE] parse bug.activity"""
        self.failIfRaises(Exception, TestBug._Bug__activity.parse)
        
        
        
        
if __name__ == '__main__':
    import unittest
    
    HTMLBugParse_STABLE_TestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLBugParse_STABLE_TestCase)
    HTMLBugParse_EDGE_TestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLBugParse_EDGE_TestCase)
    
    alltests = PyLPBugsTestSuite((HTMLBugParse_STABLE_TestSuite, HTMLBugParse_EDGE_TestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
