#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored

from datetime import datetime
from launchpadbugs.lptime import LPTime


    
    
def _gen_test_valid_time(time_str, result):
    def _testcase(self):
        self.failIfRaises(ValueError, LPTime, time_str)
        x = LPTime(time_str)
        self.assert_(str(x) == result, "returns '%s' but '%s' is expected" %(x, result))
        self.assert_(isinstance(x, datetime), "unable to parse '%s'" %time_str)
    return _testcase

def _gen_test_invalid_time(time_str):
    def _testcase(self):
        self.assertRaises(ValueError, LPTime, time_str)
    return _testcase

class TimeTestCase(PyLPBugsTestCase):
    valid_time = (
        ('Tue, 27 Nov 2007 11:15:12 -0000', "2007-11-27 11:15:12 UTC"),
        ('2007-11-27 11:15:12 UTC', "2007-11-27 11:15:12 UTC"),
        ('28 Nov 07 20:10', "2007-11-28 20:10:00 UTC"),
        ('2007-04-24 10:58:24 CEST', "2007-04-24 10:58:24 UTC"),
        ('2008-06-06 20:20:20 EST', "2008-06-06 20:20:20 UTC"),
    )
    invalid_time = (
        'Tue, 27 Nofghdfv 2007 11:15:12 -0000',
        '2007-11-27 55:15:12 UTC',
        '28 Nov 07 20:100',
    )
            
for i, (input, result) in enumerate(TimeTestCase.valid_time):
    _testcase = _gen_test_valid_time(input, result)
    _testcase.__doc__ = "parse time '%s'" %input
    setattr(TimeTestCase, "test_%.3d_valid_time" %i, _testcase)
        
for j, input in enumerate(TimeTestCase.invalid_time):
    _testcase = _gen_test_invalid_time(input)
    _testcase.__doc__ = "parse invalid time '%s'" %input
    setattr(TimeTestCase, "test_%.3d_invalid_time" %(i+j+1), _testcase)
    

if __name__ == '__main__':
    import unittest
    
    TimeTestSuite = unittest.TestLoader().loadTestsFromTestCase(TimeTestCase)
    
    alltests = PyLPBugsTestSuite((TimeTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
