[
  [
    "https://www.bathstudent.com/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bonsall"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:helpdesk@ukmsl.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "James"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bonsall"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:helpdesk@ukmsl.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "James"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://www.bathstudent.com/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Membership Solutions Limited: BathStudent.com"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.bathstudent.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Membership Solutions Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.bathstudent.com/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC7jCCAdagAwIBAgIJALorwOxJ9felMA0GCSqGSIb3DQEBBQUAMBgxFjAUBgNV\n\t\t\t\t\t\tBAMTDXJlZC51a21zbC5uZXQwHhcNMTIwMTE2MTQyMDI2WhcNMjIwMTEzMTQyMDI2\n\t\t\t\t\t\tWjAYMRYwFAYDVQQDEw1yZWQudWttc2wubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOC\n\t\t\t\t\t\tAQ8AMIIBCgKCAQEAt6/w1DLbf7yP1Ds/hbckh6UpvPP21vzMBxe6Lbf83wKx5FOq\n\t\t\t\t\t\tFxV138Riyr0lgjIjMaXjTq5LK/JV+6HDGq8jJjxYAaOU+R2ZtLC6C0rGT7tQrU1l\n\t\t\t\t\t\tZkg5pRz7mu+QNL1SzXxNu/62wpik3Htzk9eaf7v6MaXUqnvXz8QiGeVMcGrazjHG\n\t\t\t\t\t\tkzCDhme9/s01FVXBsryzFtTsKOMk08ynKVtqDdNYxL5sR4pnkfsd2dfFpFYYurT7\n\t\t\t\t\t\t0YWChpPt2hUZ3cG6oVuWPtExRfynR+DVhDMrQ8lZqTVYS+nkK9GaY48Z+kLelzPf\n\t\t\t\t\t\t5aJ5IOwIYGXXYmQxhqZK9BibifIavWcCoaz7HwIDAQABozswOTAYBgNVHREEETAP\n\t\t\t\t\t\tgg1yZWQudWttc2wubmV0MB0GA1UdDgQWBBTkJ2an+ISi623AA1DyKy+U/G2OdzAN\n\t\t\t\t\t\tBgkqhkiG9w0BAQUFAAOCAQEACEY1LH3ovYmB3S5+LSXWcA+J7L+s0GoWtwDALVEL\n\t\t\t\t\t\tEYLUyKUMkoyWzFA/kQ6fJoKVlYzftF6pAarqcF/EKAHP8B2205EMlnlwordaqJ5A\n\t\t\t\t\t\t70H/KTXpbec9awr/w/AEq9aDKQf0LbrrBCt5R2Eq+FsUwaYzdPb4NNOk2iwOuKRb\n\t\t\t\t\t\tQgGBOVxn/IHmkkF2nx/lmISlrTw3w/8t14OwRKtokdIkTCRYdJdPeXY4Lux8nDEC\n\t\t\t\t\t\tMVdMuxTmukTJxZ2jyg3jw03chH+na+7V14PgcxA5wmVkl2Dbk54rf4B8+lKZn9Qs\n\t\t\t\t\t\tRc5i1bGCRL38Kj86NSizDS+KVMrx3J48sPExehT3PUM8og=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.bathstudent.com/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.bathstudent.com/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.bathstudent.com/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.bathstudent.com/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://www.bathstudent.com/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "11"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://wifi.espci.fr/saml/metadata",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Emmanuel Dreyfus"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "Emmanuel.Dreyfus@espci.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Jean-Jacques Puig"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "Jean-Jacques.Puig@espci.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://wifi.espci.fr/saml/metadata",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://services.renater.fr/federation/en/metadata_registration_practice_statement"
              }
            ],
            "registration_instant": "2011-04-05T10:14:28Z",
            "registration_authority": "https://federation.renater.fr/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "https://federation.renater.fr/category/wifi"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "https://federation.renater.fr/scope/national"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Ecole Sup\u00e9rieure de Physique et de Chimie Industrielles de la Ville de Paris"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.espci.fr"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Ecole Sup\u00e9rieure de Physique et de Chimie Industrielles de la Ville de Paris"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://wifi.espci.fr"
                  }
                ],
                "description": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Acc\u00e8s au portail captif WiFi \u00e0 l'ESPCI ParisTech, ouvert \u00e0 tous les usagers de la f\u00e9d\u00e9ration."
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "ESPCI ParisTech - Acc\u00e8s WiFi"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "ESPCI ParisTech - Acc\u00e8s WiFi"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFaDCCBFCgAwIBAgIRAIaYj8BPcZAQKLmv64xhNrYwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xNDA0MDgwMDAwMDBaFw0xNzA0MDcyMzU5NTlaMDsxITAfBgNV\nBAsTGERvbWFpbiBDb250cm9sIFZhbGlkYXRlZDEWMBQGA1UEAxMNd2lmaS5lc3Bj\naS5mcjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBANg1N9YQejPppU6s\nvgTVJm78QhVwG1qelsOkcrpG4bzhcJN95zBV/ERuyuJ3YjwqZSYsvgcZcdOJymwf\nzVKLKh7AvDuPL+x6Iz3VSqdl3/n0SfnQP3wCM6upabxikEhLg2mROQEDN2ZnKnNq\nNMWzy0oIuf9TBhbJDddJewQtvHS/OJxqOO3f9S76xqLq9dZhKbMNE8GqWXakAr8f\noItuYZvc5UapiqngRjB78aOsHjETH3vkE200Gk97wrjIeN0LrBhKcofG88NDeJhN\nzczseS5FwoawYsgA5AAGTFDkg2dydnvZF6hhd/EJ1uEgguCWVCSZQmPSXkzlaoSg\nGAHKx+qdCFkQDipZqVRRpdWCLfRK+qvchu1E+dhzqkvTe4kX/xcvCwKWUJ0I+vlM\ndwzd8o637i6yn736TMnZG6hSMTFDhv9WN5VjD19RkIA5mETXp3KzpMNG+tmn8TPN\nuIPFpcreqQyD+qbRAH5XX5GNATY5P5HWKd+V3QJtqW0QCjen/Viq7o0avEVgmLCi\ndFuabXZo9ta/GgOIsi0n8D3uQiJ0V1snLPFjBemfXevwoI5PyHA+Yya1lLdFQ2QT\nwHyh7B0I/IoTyMoWQI9pixbiyWel6JkLRPzNJqhlB8bKqnH4HR7kgq9itZkFEz2G\nebZXFLgYWCMvkvj8vXCCYy69I4orAgMBAAGjggFqMIIBZjAfBgNVHSMEGDAWgBQM\nvZNoDPPeq6NJays3V0fqkOO57TAdBgNVHQ4EFgQUFJC/ROWw0QdJWifZ4Eo9CDHp\nMiswDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMCIGA1UdIAQbMBkwDQYLKwYBBAGyMQECAh0wCAYGZ4EM\nAQIBMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcv\nVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0\ncDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUH\nMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMBgGA1UdEQQRMA+CDXdpZmku\nZXNwY2kuZnIwDQYJKoZIhvcNAQEFBQADggEBACcP3xTaWd7EVf5hDvqI7vqrbbor\nzjvEAwdsMXGxtDqJm0Y9G3qk0Cin3vf0beZDWK2DtcYfTf1QIjJT23d+434W457S\nFj2gVppPEgZ4eFoPIH7KChRul4LXBkyvY4vLw67fQGk8/sr44j9KBUA7vUTsaqIy\n/NW6SgLNx+/NtLF5w5odwoZc6YLfj/YEIc/pLv5wwK556+2jf0p2YnmO99Up+G2U\ngE9rxe6IbLS5rd9eqf0PzBg/1OS1EYOWmdbnkODnpBi2mcBWfHKVBL2IKbyfFHul\naczMFss205TH+mugaX6YVXl77eIw9xzO7G4SZn+P9tPo0xalGN15rIoQJ1Q="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFaDCCBFCgAwIBAgIRAIaYj8BPcZAQKLmv64xhNrYwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xNDA0MDgwMDAwMDBaFw0xNzA0MDcyMzU5NTlaMDsxITAfBgNV\nBAsTGERvbWFpbiBDb250cm9sIFZhbGlkYXRlZDEWMBQGA1UEAxMNd2lmaS5lc3Bj\naS5mcjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBANg1N9YQejPppU6s\nvgTVJm78QhVwG1qelsOkcrpG4bzhcJN95zBV/ERuyuJ3YjwqZSYsvgcZcdOJymwf\nzVKLKh7AvDuPL+x6Iz3VSqdl3/n0SfnQP3wCM6upabxikEhLg2mROQEDN2ZnKnNq\nNMWzy0oIuf9TBhbJDddJewQtvHS/OJxqOO3f9S76xqLq9dZhKbMNE8GqWXakAr8f\noItuYZvc5UapiqngRjB78aOsHjETH3vkE200Gk97wrjIeN0LrBhKcofG88NDeJhN\nzczseS5FwoawYsgA5AAGTFDkg2dydnvZF6hhd/EJ1uEgguCWVCSZQmPSXkzlaoSg\nGAHKx+qdCFkQDipZqVRRpdWCLfRK+qvchu1E+dhzqkvTe4kX/xcvCwKWUJ0I+vlM\ndwzd8o637i6yn736TMnZG6hSMTFDhv9WN5VjD19RkIA5mETXp3KzpMNG+tmn8TPN\nuIPFpcreqQyD+qbRAH5XX5GNATY5P5HWKd+V3QJtqW0QCjen/Viq7o0avEVgmLCi\ndFuabXZo9ta/GgOIsi0n8D3uQiJ0V1snLPFjBemfXevwoI5PyHA+Yya1lLdFQ2QT\nwHyh7B0I/IoTyMoWQI9pixbiyWel6JkLRPzNJqhlB8bKqnH4HR7kgq9itZkFEz2G\nebZXFLgYWCMvkvj8vXCCYy69I4orAgMBAAGjggFqMIIBZjAfBgNVHSMEGDAWgBQM\nvZNoDPPeq6NJays3V0fqkOO57TAdBgNVHQ4EFgQUFJC/ROWw0QdJWifZ4Eo9CDHp\nMiswDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMCIGA1UdIAQbMBkwDQYLKwYBBAGyMQECAh0wCAYGZ4EM\nAQIBMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcv\nVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0\ncDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUH\nMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMBgGA1UdEQQRMA+CDXdpZmku\nZXNwY2kuZnIwDQYJKoZIhvcNAQEFBQADggEBACcP3xTaWd7EVf5hDvqI7vqrbbor\nzjvEAwdsMXGxtDqJm0Y9G3qk0Cin3vf0beZDWK2DtcYfTf1QIjJT23d+434W457S\nFj2gVppPEgZ4eFoPIH7KChRul4LXBkyvY4vLw67fQGk8/sr44j9KBUA7vUTsaqIy\n/NW6SgLNx+/NtLF5w5odwoZc6YLfj/YEIc/pLv5wwK556+2jf0p2YnmO99Up+G2U\ngE9rxe6IbLS5rd9eqf0PzBg/1OS1EYOWmdbnkODnpBi2mcBWfHKVBL2IKbyfFHul\naczMFss205TH+mugaX6YVXl77eIw9xzO7G4SZn+P9tPo0xalGN15rIoQJ1Q="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFpjCCBI6gAwIBAgIRAOE+20QrI5x/Eygq7lsxhZAwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xMjAzMTkwMDAwMDBaFw0xNTAzMTkyMzU5NTlaMIGCMQswCQYD\nVQQGEwJGUjE8MDoGA1UEChMzRWNvbGUgU3VwZXJpZXVyZSBkZSBQaHlzaXF1ZSBl\ndCBDaGltaWUgSW5kdXN0cmllbGxlMR0wGwYDVQQLExRTZXJ2aWNlIEluZm9ybWF0\naXF1ZTEWMBQGA1UEAxMNd2lmaS5lc3BjaS5mcjCCAiIwDQYJKoZIhvcNAQEBBQAD\nggIPADCCAgoCggIBALok3W16b6iUybJIMb7NeUtTv0h5ygPqEZRH1vVm/tsDE027\n16hrdkpSsSwP7fi2xm8x5vH7BSOjV0EtzTWsYG6R6pWkLQ+ktMGvQe3VbdmNrCAa\n/dBK2vKtwDAHES91rcQkM6mO8JTtXWrO2V+N15ttlt70gS3OgJI9Uhi8jl3JgHBq\nlEGhJz58NI1cVwDeUD0agxoz+KkPve5FB+PHASypzPZZ7GyVx5y9CE+p2+bvD+KL\nEKZR5WjXJi+nhycFsRizWAnCCAf2t0I8oky8PzQSf/eaayv+EuUnkvJNR8UXIhWE\nn6mfee+omYOoSnEgivHHJbVuJIgo1QK/+r2dYrGNPmhA7ApQqQvtjwciwwczjpe+\nvCLsrfl+jT8WFgS118huBWUS6itNG+h5pdifLdB56Y4xg+lxdsRV8XRKTZu5ttzt\nnrfkZivVtJ+1/GOcpFsvD/IHM8Z0pARxhZDbI6flbEFw7Vx2HfLiPfmWwWMK6tSL\n7IU0slg+K2ANtxhhBiFrCn0FAieCVyGHdfR7fDvzJcAYYSUyiumF00tWNDfa8Ac7\nEpbcb2/sNwfoXrLJPAL+Bhgry4kn4k6isN8RtyU6t+MaZ179VWZkOJi4e5Sy4PBx\nERkMP7oD89UZa1sDyzBJ01CNidl83zEp+yVQrhLZb3gpVCJ74ogyazqa59SrAgMB\nAAGjggFgMIIBXDAfBgNVHSMEGDAWgBQMvZNoDPPeq6NJays3V0fqkOO57TAdBgNV\nHQ4EFgQUMNLf8y6GUobcx6Q1ie9thLI8LUkwDgYDVR0PAQH/BAQDAgWgMAwGA1Ud\nEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMBgGA1UdIAQR\nMA8wDQYLKwYBBAGyMQECAh0wOgYDVR0fBDMwMTAvoC2gK4YpaHR0cDovL2NybC50\nY3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcmwwbQYIKwYBBQUHAQEEYTBfMDUG\nCCsGAQUFBzAChilodHRwOi8vY3J0LnRjcy50ZXJlbmEub3JnL1RFUkVOQVNTTENB\nLmNydDAmBggrBgEFBQcwAYYaaHR0cDovL29jc3AudGNzLnRlcmVuYS5vcmcwGAYD\nVR0RBBEwD4INd2lmaS5lc3BjaS5mcjANBgkqhkiG9w0BAQUFAAOCAQEAY3w5yCh9\n6lr26I9dpFUQsVkiAJdMaKzXcGnLoI3wUA7CcYG76ae0m7QxNbbIjxXdhYbDgyn8\nPVGsMLejGWbjgePf5UhvVyaPWQVB/burU95HfD6pDS2D+/NJYQowVjgf8Meh4Nb6\n1tURmrwzVkwLkIHvTSQ011dZJEQe6aockASx6GMtd7hlm87Rndk0Jm9a6pQtzHjY\npAVuaQQi/FxV7jkz+Rm4HD8R3bhRdVSCpe+2ukW91t385ZQCJuFawcdTDEeHGaDI\n1bjPX+IrBAd71rGTiMlhH5VUaYUNPJkTxVWJwhCimQztzNGk0CY+ze424o3soWOZ\n2JBnPLINws7O5w=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://wifi.espci.fr/saml/postResponse",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "fr",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "ESPCI ParisTech - Acc\u00e8s WiFi"
                }
              ],
              "service_description": [
                {
                  "lang": "fr",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Acc\u00e8s au portail captif WiFi \u00e0 l'ESPCI ParisTech, ouvert \u00e0 tous les usagers de la f\u00e9d\u00e9ration."
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "mail",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "displayName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.16.840.1.113730.3.1.241",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "cn",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "https://shibboleth.unisi.it/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:idem@unisi.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibboleth.unisi.it/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.idem.garr.it/idem-metadata-registration-practice-statement"
              }
            ],
            "registration_instant": "2016-03-17T08:30:00Z",
            "registration_authority": "http://www.idem.garr.it/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDbDCCAlQCCQDCQNjXPb+J3zANBgkqhkiG9w0BAQUFADB4MQswCQYDVQQGEwJJ\nVDEOMAwGA1UECAwFU2llbmExDjAMBgNVBAcMBVNpZW5hMRwwGgYDVQQKDBNVbml2\nZXJzaXRhIGRpIFNpZW5hMQ0wCwYDVQQLDARTUlNTMRwwGgYDVQQDDBNzaGliYm9s\nZXRoLnVuaXNpLml0MB4XDTE1MDgxNDExMjIyMFoXDTI1MDYyMjExMjIyMFoweDEL\nMAkGA1UEBhMCSVQxDjAMBgNVBAgMBVNpZW5hMQ4wDAYDVQQHDAVTaWVuYTEcMBoG\nA1UECgwTVW5pdmVyc2l0YSBkaSBTaWVuYTENMAsGA1UECwwEU1JTUzEcMBoGA1UE\nAwwTc2hpYmJvbGV0aC51bmlzaS5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC\nAQoCggEBAM0DwZPtLOcfVuSGNh9CXbV00bzCF/jQ8lIX9cmsfzg8Z4mqvRCW9TKo\nJNwn1+o+xqbwnnNY+IfbrHcHx0uoOaweQBzJi8CtMFLIvg//r59cCHP3+T/RbT0Q\ndUrDv/eWggyVIW52hqaofkjFXiL7mnp5Mh4hXsTn43TfJx9fQnPBrGVsMIxAT0AW\nbNTFgtukD1d3tCx4sImQU0MGyQb2k3W/eu4GddNZs/Krox7zabiJC+ENcU5uduaV\nlIwi5vJ/f+7qP3Z6dH/SVWZfFeP1+AFn51iAGuj/6/U8XFF8VBt+mfM2ADdmUguN\nbMWz2zeZeXKEMqNaWurjp8fjF4D/NccCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEA\nTQj+v5d1bx1ctes1sCTIUa6ctqBj5qOh4zFEXNxkMNoCLoCMaVlx4pgu8b8B0bow\nalaHWn2QicrHhu7wVxIGG7FEu0QnTNY6trnft5Ps6skXJuVJjqdJEf1fz1cMTv+b\nhoRp5PTM0xq15JlZTkpJxUtEVhWiPBUUxGwBGHRSgZ87tnQfw5+TX54iRahJOfer\nFcOVtK1g+0cycim0THv3bf8BQXzhhFBNEXDAqkch+Kxp56dV51j+KUZtDKCQpCkL\nBQq/XNsdesbvmPiOtFXYzb7QwydoOR+pPqfHP+MyAbv0aZnyGOv8jtCwpb7KNeX2\nzI5NIIy574GrFouiXR+GCQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "unisi.it"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.unisi.it:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibboleth.unisi.it:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.unisi.it/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.unisi.it/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shibboleth.unisi.it/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shibboleth.unisi.it/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.unisi.it:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibboleth.unisi.it:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "unisi.it"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://shibboleth.unisi.it/idem-info-eng.html"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://shibboleth.unisi.it/idem-info.html"
                  }
                ],
                "display_name": [
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Universit\u00e0 degli Studi di Siena"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of Siena"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo",
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider for users of University of Siena"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider per gli utenti dell'Universit\u00e0 degli Studi di Siena"
                  }
                ],
                "logo": [
                  {
                    "text": "https://shibboleth.unisi.it/idp/images/logo_unisi_60px.png",
                    "height": "59",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "60"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "https://shibboleth.unisi.it/idem-privacy-eng.html"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "https://shibboleth.unisi.it/idem-privacy.html"
                  }
                ]
              },
              {
                "domain_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint",
                    "text": "unisi.it"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDbDCCAlQCCQDCQNjXPb+J3zANBgkqhkiG9w0BAQUFADB4MQswCQYDVQQGEwJJ\nVDEOMAwGA1UECAwFU2llbmExDjAMBgNVBAcMBVNpZW5hMRwwGgYDVQQKDBNVbml2\nZXJzaXRhIGRpIFNpZW5hMQ0wCwYDVQQLDARTUlNTMRwwGgYDVQQDDBNzaGliYm9s\nZXRoLnVuaXNpLml0MB4XDTE1MDgxNDExMjIyMFoXDTI1MDYyMjExMjIyMFoweDEL\nMAkGA1UEBhMCSVQxDjAMBgNVBAgMBVNpZW5hMQ4wDAYDVQQHDAVTaWVuYTEcMBoG\nA1UECgwTVW5pdmVyc2l0YSBkaSBTaWVuYTENMAsGA1UECwwEU1JTUzEcMBoGA1UE\nAwwTc2hpYmJvbGV0aC51bmlzaS5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC\nAQoCggEBAM0DwZPtLOcfVuSGNh9CXbV00bzCF/jQ8lIX9cmsfzg8Z4mqvRCW9TKo\nJNwn1+o+xqbwnnNY+IfbrHcHx0uoOaweQBzJi8CtMFLIvg//r59cCHP3+T/RbT0Q\ndUrDv/eWggyVIW52hqaofkjFXiL7mnp5Mh4hXsTn43TfJx9fQnPBrGVsMIxAT0AW\nbNTFgtukD1d3tCx4sImQU0MGyQb2k3W/eu4GddNZs/Krox7zabiJC+ENcU5uduaV\nlIwi5vJ/f+7qP3Z6dH/SVWZfFeP1+AFn51iAGuj/6/U8XFF8VBt+mfM2ADdmUguN\nbMWz2zeZeXKEMqNaWurjp8fjF4D/NccCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEA\nTQj+v5d1bx1ctes1sCTIUa6ctqBj5qOh4zFEXNxkMNoCLoCMaVlx4pgu8b8B0bow\nalaHWn2QicrHhu7wVxIGG7FEu0QnTNY6trnft5Ps6skXJuVJjqdJEf1fz1cMTv+b\nhoRp5PTM0xq15JlZTkpJxUtEVhWiPBUUxGwBGHRSgZ87tnQfw5+TX54iRahJOfer\nFcOVtK1g+0cycim0THv3bf8BQXzhhFBNEXDAqkch+Kxp56dV51j+KUZtDKCQpCkL\nBQq/XNsdesbvmPiOtFXYzb7QwydoOR+pPqfHP+MyAbv0aZnyGOv8jtCwpb7KNeX2\nzI5NIIy574GrFouiXR+GCQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Universit\u00e0 degli Studi di Siena"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Siena"
          }
        ],
        "organization_url": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.unisi.it"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://en.unisi.it/"
          }
        ],
        "organization_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Universit\u00e0 degli Studi di Siena"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Siena"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp-v2.suni.se/adfs/services/trust",
    {
      "contact_person": [
        {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "contact_type": "support",
          "telephone_number": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber",
              "text": "+46(0)8-6084000"
            }
          ],
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Legat"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "server@sh.se"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tomas"
          }
        }
      ],
      "entity_id": "https://idp-v2.suni.se/adfs/services/trust",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "regexp": "false",
            "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
            "text": "suni.se"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp-v2.suni.se/adfs/services/trust/artifactresolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "0"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "suni.se"
              },
              {
                "information_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://www.sh.se/"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://www.sh.se/p3/ext/content.nsf/aget?openagent&key=startsideportal_engelsk_1308725461229"
                  }
                ],
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ny Identitetshanterare f\u00f6r S\u00f6dert\u00f6rns h\u00f6gskola"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "New Identity Provider for S\u00f6dert\u00f6rn University"
                  }
                ],
                "logo": [
                  {
                    "text": "https://www.sh.se/p3/ext/res.nsf/vRes/global_1448973984543_sh_ny_logo_eng_png/$File/sh-ny-logo-eng.png",
                    "height": "100",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "100"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "S\u00f6dert\u00f6rns h\u00f6gskola"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "S\u00f6dert\u00f6rn University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute": [
            {
              "friendly_name": "E-Mail Address",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Given Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "UPN",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Common Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/CommonName",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "AD FS 1.x E-Mail Address",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/EmailAddress",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Group",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/Group",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "AD FS 1.x UPN",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/UPN",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Role",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/role",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Surname",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "PPID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Name ID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Authentication time stamp",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/authenticationinstant",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Authentication method",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/authenticationmethod",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Deny only group SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/denyonlysid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Deny only primary SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarysid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Deny only primary group SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarygroupsid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Group SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/groupsid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Primary group SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/primarygroupsid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Primary SID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/primarysid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Windows account name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Is Registered User",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/isregistereduser",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Device Identifier",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/identifier",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Device Registration Identifier",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/registrationid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Device Registration DisplayName",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/displayname",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Device OS type",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/ostype",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Device OS Version",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/osversion",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Is Managed Device",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/devicecontext/claims/ismanaged",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Forwarded Client IP",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-forwarded-client-ip",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Client Application",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-client-application",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Client User Agent",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-client-user-agent",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Client IP",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-client-ip",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Endpoint Path",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-endpoint-absolute-path",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Proxy",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/x-ms-proxy",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Application Identifier",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/relyingpartytrustid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Application policies",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/applicationpolicy",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Authority Key Identifier",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/authoritykeyidentifier",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Basic Constraint",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/basicconstraints",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Enhanced Key Usage",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/eku",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Issuer",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/issuer",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Issuer Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/issuername",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Key Usage",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/keyusage",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Not After",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/notafter",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Not Before",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/notbefore",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Certificate Policies",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/certificatepolicy",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Public Key",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/rsa",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Certificate Raw Data",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/rawdata",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Subject Alternative Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/san",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Serial Number",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2008/06/identity/claims/serialnumber",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Signature Algorithm",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/signaturealgorithm",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Subject",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/subject",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Subject Key Identifier",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/subjectkeyidentifier",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Subject Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/subjectname",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "V2 Template Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/certificatetemplateinformation",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "V1 Template Name",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/extension/certificatetemplatename",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Thumbprint",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/thumbprint",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "X.509 Version",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/12/certificatecontext/field/x509version",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Inside Corporate Network",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2012/01/insidecorporatenetwork",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Password Expiration Time",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2012/01/passwordexpirationtime",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Password Expiration Days",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2012/01/passwordexpirationdays",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Update Password URL",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2012/01/passwordchangeurl",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Authentication Methods References",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/claims/authnmethodsreferences",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Client Request ID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/2012/01/requestcontext/claims/client-request-id",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "Alternate Login ID",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.microsoft.com/ws/2013/11/alternateloginid",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "norEduPersonNIN",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/norEduPersonNIN",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "eduPersonEntitlement",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/eduPersonEntitlement",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            },
            {
              "friendly_name": "eduPersonScopedAffiliation",
              "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
              "name": "http://schemas.xmlsoap.org/claims/eduPersonScopedAffiliation",
              "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
            }
          ],
          "key_descriptor": [
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFMjCCBBqgAwIBAgIQAm3ZwLUL7U5eOFDOgDO7bDANBgkqhkiG9w0BAQsFADBkMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wgQ0EgMzAeFw0xNjAzMTUwMDAwMDBaFw0xOTAzMjAxMjAwMDBaMHsxCzAJBgNVBAYTAlNFMRIwEAYDVQQIEwlTdG9ja2hvbG0xETAPBgNVBAcTCEh1ZGRpbmdlMR8wHQYDVQQKDBZTw7ZkZXJ0w7ZybnMgaMO2Z3Nrb2xhMQswCQYDVQQLEwJJVDEXMBUGA1UEAxMOaWRwLXYyLnN1bmkuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDOXlJ5/dL14M8QLLElvZWd3UQYlu5Ofu5amzIWCbxSisc2dga7auPgo4q+NDWhQMFI1kVYKD5T4AaKVbM6FSwW1alOsaDmVYkqv/z21bTa4bzqwg/GXtlIoxgQI3spHoVCqn2lB4iWD9YHb+85F+BlY4OBgLzUCpXM2w6eIMEfqghRc0XaDUvX1+eymVkKMQ+UNpc9IDkwvaKgQVaEo1hRl76bEVytBtAerMylEvAa7AFs5VBXCA6aoW4hXvYNnL6jJv5gh4kD1vH1WvOA0WlR0wRaO5nRwwPm1kMREXhweP9/l2AXPB9FuceGBz3P16SZKZ2TO4zXhqiEXZFIMqn5AgMBAAGjggHHMIIBwzAfBgNVHSMEGDAWgBRn/YggFCeYxwnSJRm76VERY3VQYjAdBgNVHQ4EFgQUWx+gXBAJLGLQqiZF+QPFw1TJmbgwGQYDVR0RBBIwEIIOaWRwLXYyLnN1bmkuc2UwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0EzLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENBMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEEYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYBBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggEBAEyWyos2TCFAjsW4+VnJikhoydbbI8h/gMpvJImJbsQBhCCN/j0oJi6wDJ08vWC5gKlLG2YHOlhXN5piygmfIXcfF/BkTL++RuF072Ve7pL0NAcETL3xSXnKHqfKzxqjg9t2gInnqdkowtlx7RZdXIabHYCA3tY6r7cg0MCKQJjJvsMfgqYZjSVnZB1AXiJf0NNkH4Dd0zJPW3FjUa7c1pHW4IQFKZkPFlwT5G1VwGJXxJD/oZBgh5dXB/FE1wAJtQyCneg0yKP6T77dPXG96ev15NV7qcFeo7haDeMbGCtDNjzCP/vhiUo1gHYXOUKMkeIIlsyOnWYZApO96h0WfDk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFMjCCBBqgAwIBAgIQAm3ZwLUL7U5eOFDOgDO7bDANBgkqhkiG9w0BAQsFADBkMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wgQ0EgMzAeFw0xNjAzMTUwMDAwMDBaFw0xOTAzMjAxMjAwMDBaMHsxCzAJBgNVBAYTAlNFMRIwEAYDVQQIEwlTdG9ja2hvbG0xETAPBgNVBAcTCEh1ZGRpbmdlMR8wHQYDVQQKDBZTw7ZkZXJ0w7ZybnMgaMO2Z3Nrb2xhMQswCQYDVQQLEwJJVDEXMBUGA1UEAxMOaWRwLXYyLnN1bmkuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDOXlJ5/dL14M8QLLElvZWd3UQYlu5Ofu5amzIWCbxSisc2dga7auPgo4q+NDWhQMFI1kVYKD5T4AaKVbM6FSwW1alOsaDmVYkqv/z21bTa4bzqwg/GXtlIoxgQI3spHoVCqn2lB4iWD9YHb+85F+BlY4OBgLzUCpXM2w6eIMEfqghRc0XaDUvX1+eymVkKMQ+UNpc9IDkwvaKgQVaEo1hRl76bEVytBtAerMylEvAa7AFs5VBXCA6aoW4hXvYNnL6jJv5gh4kD1vH1WvOA0WlR0wRaO5nRwwPm1kMREXhweP9/l2AXPB9FuceGBz3P16SZKZ2TO4zXhqiEXZFIMqn5AgMBAAGjggHHMIIBwzAfBgNVHSMEGDAWgBRn/YggFCeYxwnSJRm76VERY3VQYjAdBgNVHQ4EFgQUWx+gXBAJLGLQqiZF+QPFw1TJmbgwGQYDVR0RBBIwEIIOaWRwLXYyLnN1bmkuc2UwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0EzLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENBMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEEYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYBBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggEBAEyWyos2TCFAjsW4+VnJikhoydbbI8h/gMpvJImJbsQBhCCN/j0oJi6wDJ08vWC5gKlLG2YHOlhXN5piygmfIXcfF/BkTL++RuF072Ve7pL0NAcETL3xSXnKHqfKzxqjg9t2gInnqdkowtlx7RZdXIabHYCA3tY6r7cg0MCKQJjJvsMfgqYZjSVnZB1AXiJf0NNkH4Dd0zJPW3FjUa7c1pHW4IQFKZkPFlwT5G1VwGJXxJD/oZBgh5dXB/FE1wAJtQyCneg0yKP6T77dPXG96ev15NV7qcFeo7haDeMbGCtDNjzCP/vhiUo1gHYXOUKMkeIIlsyOnWYZApO96h0WfDk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "S\u00f6dert\u00f6rns h\u00f6gskola"
          }
        ],
        "organization_url": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.sh.se/"
          }
        ],
        "organization_name": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "S\u00f6dert\u00f6rns h\u00f6gskola"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "want_assertions_signed": "true",
          "key_descriptor": [
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFMjCCBBqgAwIBAgIQAm3ZwLUL7U5eOFDOgDO7bDANBgkqhkiG9w0BAQsFADBkMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wgQ0EgMzAeFw0xNjAzMTUwMDAwMDBaFw0xOTAzMjAxMjAwMDBaMHsxCzAJBgNVBAYTAlNFMRIwEAYDVQQIEwlTdG9ja2hvbG0xETAPBgNVBAcTCEh1ZGRpbmdlMR8wHQYDVQQKDBZTw7ZkZXJ0w7ZybnMgaMO2Z3Nrb2xhMQswCQYDVQQLEwJJVDEXMBUGA1UEAxMOaWRwLXYyLnN1bmkuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDOXlJ5/dL14M8QLLElvZWd3UQYlu5Ofu5amzIWCbxSisc2dga7auPgo4q+NDWhQMFI1kVYKD5T4AaKVbM6FSwW1alOsaDmVYkqv/z21bTa4bzqwg/GXtlIoxgQI3spHoVCqn2lB4iWD9YHb+85F+BlY4OBgLzUCpXM2w6eIMEfqghRc0XaDUvX1+eymVkKMQ+UNpc9IDkwvaKgQVaEo1hRl76bEVytBtAerMylEvAa7AFs5VBXCA6aoW4hXvYNnL6jJv5gh4kD1vH1WvOA0WlR0wRaO5nRwwPm1kMREXhweP9/l2AXPB9FuceGBz3P16SZKZ2TO4zXhqiEXZFIMqn5AgMBAAGjggHHMIIBwzAfBgNVHSMEGDAWgBRn/YggFCeYxwnSJRm76VERY3VQYjAdBgNVHQ4EFgQUWx+gXBAJLGLQqiZF+QPFw1TJmbgwGQYDVR0RBBIwEIIOaWRwLXYyLnN1bmkuc2UwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0EzLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENBMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEEYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYBBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggEBAEyWyos2TCFAjsW4+VnJikhoydbbI8h/gMpvJImJbsQBhCCN/j0oJi6wDJ08vWC5gKlLG2YHOlhXN5piygmfIXcfF/BkTL++RuF072Ve7pL0NAcETL3xSXnKHqfKzxqjg9t2gInnqdkowtlx7RZdXIabHYCA3tY6r7cg0MCKQJjJvsMfgqYZjSVnZB1AXiJf0NNkH4Dd0zJPW3FjUa7c1pHW4IQFKZkPFlwT5G1VwGJXxJD/oZBgh5dXB/FE1wAJtQyCneg0yKP6T77dPXG96ev15NV7qcFeo7haDeMbGCtDNjzCP/vhiUo1gHYXOUKMkeIIlsyOnWYZApO96h0WfDk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFMjCCBBqgAwIBAgIQAm3ZwLUL7U5eOFDOgDO7bDANBgkqhkiG9w0BAQsFADBkMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wgQ0EgMzAeFw0xNjAzMTUwMDAwMDBaFw0xOTAzMjAxMjAwMDBaMHsxCzAJBgNVBAYTAlNFMRIwEAYDVQQIEwlTdG9ja2hvbG0xETAPBgNVBAcTCEh1ZGRpbmdlMR8wHQYDVQQKDBZTw7ZkZXJ0w7ZybnMgaMO2Z3Nrb2xhMQswCQYDVQQLEwJJVDEXMBUGA1UEAxMOaWRwLXYyLnN1bmkuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDOXlJ5/dL14M8QLLElvZWd3UQYlu5Ofu5amzIWCbxSisc2dga7auPgo4q+NDWhQMFI1kVYKD5T4AaKVbM6FSwW1alOsaDmVYkqv/z21bTa4bzqwg/GXtlIoxgQI3spHoVCqn2lB4iWD9YHb+85F+BlY4OBgLzUCpXM2w6eIMEfqghRc0XaDUvX1+eymVkKMQ+UNpc9IDkwvaKgQVaEo1hRl76bEVytBtAerMylEvAa7AFs5VBXCA6aoW4hXvYNnL6jJv5gh4kD1vH1WvOA0WlR0wRaO5nRwwPm1kMREXhweP9/l2AXPB9FuceGBz3P16SZKZ2TO4zXhqiEXZFIMqn5AgMBAAGjggHHMIIBwzAfBgNVHSMEGDAWgBRn/YggFCeYxwnSJRm76VERY3VQYjAdBgNVHQ4EFgQUWx+gXBAJLGLQqiZF+QPFw1TJmbgwGQYDVR0RBBIwEIIOaWRwLXYyLnN1bmkuc2UwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0EzLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENBMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEEYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYBBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggEBAEyWyos2TCFAjsW4+VnJikhoydbbI8h/gMpvJImJbsQBhCCN/j0oJi6wDJ08vWC5gKlLG2YHOlhXN5piygmfIXcfF/BkTL++RuF072Ve7pL0NAcETL3xSXnKHqfKzxqjg9t2gInnqdkowtlx7RZdXIabHYCA3tY6r7cg0MCKQJjJvsMfgqYZjSVnZB1AXiJf0NNkH4Dd0zJPW3FjUa7c1pHW4IQFKZkPFlwT5G1VwGJXxJD/oZBgh5dXB/FE1wAJtQyCneg0yKP6T77dPXG96ev15NV7qcFeo7haDeMbGCtDNjzCP/vhiUo1gHYXOUKMkeIIlsyOnWYZApO96h0WfDk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "index": "0",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "is_default": "true"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp-v2.suni.se/adfs/ls/",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://conext.authenticatie.ru.nl/simplesaml/saml2/idp/metadata.php",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "help@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://conext.authenticatie.ru.nl/simplesaml/saml2/idp/metadata.php",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://wiki.surfnet.nl/display/eduGAIN/EduGAIN"
              }
            ],
            "registration_instant": "2015-04-29T16:00:00Z",
            "registration_authority": "http://www.surfconext.nl/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://engine.surfconext.nl/authentication/idp/single-sign-on/0d04b328623873aa5fb671116f91cb73",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "An IdP operated by Radboud University Nijmegen"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "An IdP operated by Radboud University Nijmegen"
                  }
                ],
                "logo": [
                  {
                    "text": "https://static.surfconext.nl/logos/idp/radboudlogo120.png",
                    "height": "26",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "120"
                  }
                ],
                "display_name": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Radboud Universiteit"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Radboud University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID3zCCAsegAwIBAgIJAMVC9xn1ZfsuMA0GCSqGSIb3DQEBCwUAMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTAeFw0xNDA1MDUxNDIyMzVaFw0xOTA1MDUxNDIyMzVaMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKthMDbB0jKHefPzmRu9t2h7iLP4wAXr42bHpjzTEk6gttHFb4l/hFiz1YBI88TjiH6hVjnozo/YHA2c51us+Y7g0XoS7653lbUN/EHzvDMuyis4Xi2Ijf1A/OUQfH1iFUWttIgtWK9+fatXoGUS6tirQvrzVh6ZstEp1xbpo1SF6UoVl+fh7tM81qz+Crr/Kroan0UjpZOFTwxPoK6fdLgMAieKSCRmBGpbJHbQ2xxbdykBBrBbdfzIX4CDepfjE9h/40ldw5jRn3e392jrS6htk23N9BWWrpBT5QCk0kH3h/6F1Dm6TkyG9CDtt73/anuRkvXbeygI4wml9bL3rE8CAwEAAaNQME4wHQYDVR0OBBYEFD+Ac7akFxaMhBQAjVfvgGfY8hNKMB8GA1UdIwQYMBaAFD+Ac7akFxaMhBQAjVfvgGfY8hNKMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAC8L9D67CxIhGo5aGVu63WqRHBNOdo/FAGI7LURDFeRmG5nRw/VXzJLGJksh4FSkx7aPrxNWF1uFiDZ80EuYQuIv7bDLblK31ZEbdg1R9LgiZCdYSr464I7yXQY9o6FiNtSKZkQO8EsscJPPy/Zp4uHAnADWACkOUHiCbcKiUUFu66dX0Wr/v53Gekz487GgVRs8HEeT9MU1reBKRgdENR8PNg4rbQfLc3YQKLWK7yWnn/RenjDpuCiePj8N8/80tGgrNgK/6fzM3zI18sSywnXLswxqDb/J+jgVxnQ6MrsTf1urM8MnfcxG/82oHIwfMh/sXPCZpo+DTLkhQxctJ3M="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Radboud Universiteit"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Radboud University"
          }
        ],
        "organization_url": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ru.nl/"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ru.nl/english/"
          }
        ],
        "organization_name": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Radboud Universiteit"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Radboud University"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://login.bme.hu/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Gyenes Tam\u00e1s"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tom@impulzus.bme.hu"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Gyenes Tam\u00e1s"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tom@impulzus.bme.hu"
            }
          ],
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Gyenes Tam\u00e1s"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tom@impulzus.bme.hu"
            }
          ],
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://login.bme.hu/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "urn:schac:homeOrganizationType:hu:other"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              },
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "bme"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "href"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "href-edugain"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "href-idps"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "urn:geant:niif.hu:eduid.hu:entity-attributes:processing-info",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          },
          {
            "registration_policy": [
              {
                "lang": "hu",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://metadata.eduid.hu/registration_policy_1_0.txt"
              }
            ],
            "registration_instant": "2013-08-01T07:17:19.807Z",
            "registration_authority": "http://eduid.hu",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://login.bme.hu:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "login.bme.hu"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHDCCAgSgAwIBAgIVALPowTex/0kkPUAX6SJu1p93b0VwMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNVBAMTDGxvZ2luLmJtZS5odTAeFw0xMTEwMDMwMTE0MzVaFw0zMTEwMDMwMTE0MzVaMBcxFTATBgNVBAMTDGxvZ2luLmJtZS5odTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALFQWz8d0dz50J5zJVgQPv739xAPTQjQV6RwQdE9u+ajgytrDy+VuCrBGluvGspGekOjhlEESc7sZ0l92wzEdcdG0McLeg7PL9V4JE9qwKJO289t403EFbxCqekjeZWp3KDhHpDefLOUywYMQ1mPNfYbVRRFg82VtPL+G3FMTSQBWrnjWYLshVjexbHwbK1rMiy8MHBbjVAF27v6RvGHLhzPhNNW11+lqweogXc3d73fgkIBMicKm5SgW/jQvBtlODy49xeoef1GD6MUgckPRpqIyXdd01rqpdGqeDJOyjamB5VI+LMjjpNr6h2pA0LjNNm0RZJVobbgzfFpdzwI09ECAwEAAaNfMF0wPAYDVR0RBDUwM4IMbG9naW4uYm1lLmh1hiNodHRwczovL2xvZ2luLmJtZS5odS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUbB8MWrjcjCvj3wlxfUMUsdRjYd4wDQYJKoZIhvcNAQEFBQADggEBAK1vfjY8DTLVqrZm7G5g+PSDRalpmk5Iwg5c/flDtGJG8LoHaX5y9AGNyXNOqgfzWw/UITQnl6J1L5o8n/AHYv6B1BHY0VqGBdIg/JvIzX1sODAdbOlYvLdhYqACjK+S/KNW7H0ASh2sY1OVSc4/nOLfdJYgoZ2YZphvWu3zn7oEAaEBL1G1kaHYRTuJcRrS6QtL2P2jj+McxtRwaC5QgcMyewJW6I/608AV0/0++UUqWpb29HUit4H03Mt/7qc2ekLuPcOk+AEXajE97z8Ia99IrBj/n3N4edS+Oj570z1SMzhtuCKzErQeySAtySu6EbCabd0L2JXIDLr2fjc8B+s="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor"
        }
      ],
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://login.bme.hu/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://login.bme.hu/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://login.bme.hu/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://login.bme.hu/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://login.bme.hu/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://login.bme.hu:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Budapesti M\u0171szaki \u00e9s Gazdas\u00e1gtudom\u00e1nyi Egyetem"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Budapest University of Technology and Economics"
                  }
                ],
                "display_name": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Budapesti M\u0171szaki \u00e9s Gazdas\u00e1gtudom\u00e1nyi Egyetem"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Budapest University of Technology and Economics"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "bme.hu"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "login.bme.hu"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHDCCAgSgAwIBAgIVALPowTex/0kkPUAX6SJu1p93b0VwMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNVBAMTDGxvZ2luLmJtZS5odTAeFw0xMTEwMDMwMTE0MzVaFw0zMTEwMDMwMTE0MzVaMBcxFTATBgNVBAMTDGxvZ2luLmJtZS5odTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALFQWz8d0dz50J5zJVgQPv739xAPTQjQV6RwQdE9u+ajgytrDy+VuCrBGluvGspGekOjhlEESc7sZ0l92wzEdcdG0McLeg7PL9V4JE9qwKJO289t403EFbxCqekjeZWp3KDhHpDefLOUywYMQ1mPNfYbVRRFg82VtPL+G3FMTSQBWrnjWYLshVjexbHwbK1rMiy8MHBbjVAF27v6RvGHLhzPhNNW11+lqweogXc3d73fgkIBMicKm5SgW/jQvBtlODy49xeoef1GD6MUgckPRpqIyXdd01rqpdGqeDJOyjamB5VI+LMjjpNr6h2pA0LjNNm0RZJVobbgzfFpdzwI09ECAwEAAaNfMF0wPAYDVR0RBDUwM4IMbG9naW4uYm1lLmh1hiNodHRwczovL2xvZ2luLmJtZS5odS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUbB8MWrjcjCvj3wlxfUMUsdRjYd4wDQYJKoZIhvcNAQEFBQADggEBAK1vfjY8DTLVqrZm7G5g+PSDRalpmk5Iwg5c/flDtGJG8LoHaX5y9AGNyXNOqgfzWw/UITQnl6J1L5o8n/AHYv6B1BHY0VqGBdIg/JvIzX1sODAdbOlYvLdhYqACjK+S/KNW7H0ASh2sY1OVSc4/nOLfdJYgoZ2YZphvWu3zn7oEAaEBL1G1kaHYRTuJcRrS6QtL2P2jj+McxtRwaC5QgcMyewJW6I/608AV0/0++UUqWpb29HUit4H03Mt/7qc2ekLuPcOk+AEXajE97z8Ia99IrBj/n3N4edS+Oj570z1SMzhtuCKzErQeySAtySu6EbCabd0L2JXIDLr2fjc8B+s="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Budapesti M\u0171szaki \u00e9s Gazdas\u00e1gtudom\u00e1nyi Egyetem"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Budapest University of Technology and Economics"
          }
        ],
        "organization_url": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://bme.hu"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://bme.hu"
          }
        ],
        "organization_name": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Budapesti M\u0171szaki \u00e9s Gazdas\u00e1gtudom\u00e1nyi Egyetem"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Budapest University of Technology and Economics"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://cafe.udesc.br/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Setor de Infraestrutura - SETIC"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "seinfra.setic@udesc.br"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://cafe.udesc.br/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf"
              }
            ],
            "registration_instant": "2010-01-01T00:00:00Z",
            "registration_authority": "http://cafe.rnp.br",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEgDCCA2gCAQAwDQYJKoZIhvcNAQEFBQAwggEEMTkwNwYDVQQKEzBVREVTQyAt\nIFVuaXZlcnNpZGFkZSBkbyBFc3RhZG8gZGUgU2FudGEgQ2F0YXJpbmExSTBHBgNV\nBAsUQFNFVElDIC0gU2VjcmV0YXJpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWHD\np8OjbyBlIENvbXVuaWNhw6fDo28xJTAjBgkqhkiG9w0BCQEWFnNlaW5mcmEuc2V0\naWNAdWRlc2MuYnIxFzAVBgNVBAcUDkZsb3JpYW7Ds3BvbGlzMRcwFQYDVQQIEw5T\nYW50YSBDYXRhcmluYTELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUudWRlc2Mu\nYnIwHhcNMTQwNTE1MjAxMjEyWhcNMTcwNTE0MjAxMjEyWjCCAQQxOTA3BgNVBAoT\nMFVERVNDIC0gVW5pdmVyc2lkYWRlIGRvIEVzdGFkbyBkZSBTYW50YSBDYXRhcmlu\nYTFJMEcGA1UECxRAU0VUSUMgLSBTZWNyZXRhcmlhIGRlIFRlY25vbG9naWEgZGEg\nSW5mb3JtYcOnw6NvIGUgQ29tdW5pY2HDp8OjbzElMCMGCSqGSIb3DQEJARYWc2Vp\nbmZyYS5zZXRpY0B1ZGVzYy5icjEXMBUGA1UEBxQORmxvcmlhbsOzcG9saXMxFzAV\nBgNVBAgTDlNhbnRhIENhdGFyaW5hMQswCQYDVQQGEwJCUjEWMBQGA1UEAxMNY2Fm\nZS51ZGVzYy5icjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL9PTe5l\nWC7jplN9PsFwipaPk1bB5UPXxEOeJgr/6xf5RMT//l1L6T/X4uOj+lK6KI8a4pRc\noD+a83AlKb8cvYzDIQEBCDOPqjruIy+TyTwQ358x45mPM/aNivkugPKMaK8Aidma\nnUgeiRuZ1rtFyVqenDkH7qs9SwExR4NnJ/1l7DNkP6znKksBq7PGlYkj0mryxNCV\n1CAEZT6zEIyptWwd0TRHaybJc2uDD5Kl8HE54IvCwxfdKgJVQ/9FK2W9vvZowUQl\nbOGdUHqFvtudcU6VWOPxuRv4NgmkFGRaNBisnfZ3XfUah8yMIvlYXgkAevQNBjnz\ng3P3o8BU5YU6ieECAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAUu6oCJTJ51HQeuiD\n06G3V1HddwBdddkaHK+WVNux+s8fVQH1Z6ZvkIH2xgmi9ZI9jK7OoBv1H0TfM27g\n4i8RC4jkVM9SHJFR5YFlNs/5tMaohIMZ2zURG72tRLtq603OqSzaeZPIthDasWww\nVEfbfbckLrCcjuLzb608J8d0brg+Cgn8YxQY17r/4GbkXYuC9k9zYshOCZelS703\nC7ZdXXJuI6/VXffvbqifT9BsY3SmAPw/JQAiSxpp2+ZTwauq3YLwxDcIq9b5YX35\nqcmfM3D3mVPH/aUvLhgtMSlmaGYm8o1mD9LUIR5b5C4A+j/qmzu1IIf3JYqMjb/V\nWiKadQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "udesc.br"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://cafe.udesc.br:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://cafe.udesc.br:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://cafe.udesc.br/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://cafe.udesc.br/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://cafe.udesc.br/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://cafe.udesc.br/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://cafe.udesc.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://cafe.udesc.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "udesc.br"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.udesc.br/"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.udesc.br/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UDESC - Universidade do Estado de Santa Catarina"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UDESC - Universidade do Estado de Santa Catarina"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UDESC - Universidade do Estado de Santa Catarina"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UDESC - Universidade do Estado de Santa Catarina"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEgDCCA2gCAQAwDQYJKoZIhvcNAQEFBQAwggEEMTkwNwYDVQQKEzBVREVTQyAt\nIFVuaXZlcnNpZGFkZSBkbyBFc3RhZG8gZGUgU2FudGEgQ2F0YXJpbmExSTBHBgNV\nBAsUQFNFVElDIC0gU2VjcmV0YXJpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWHD\np8OjbyBlIENvbXVuaWNhw6fDo28xJTAjBgkqhkiG9w0BCQEWFnNlaW5mcmEuc2V0\naWNAdWRlc2MuYnIxFzAVBgNVBAcUDkZsb3JpYW7Ds3BvbGlzMRcwFQYDVQQIEw5T\nYW50YSBDYXRhcmluYTELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUudWRlc2Mu\nYnIwHhcNMTQwNTE1MjAxMjEyWhcNMTcwNTE0MjAxMjEyWjCCAQQxOTA3BgNVBAoT\nMFVERVNDIC0gVW5pdmVyc2lkYWRlIGRvIEVzdGFkbyBkZSBTYW50YSBDYXRhcmlu\nYTFJMEcGA1UECxRAU0VUSUMgLSBTZWNyZXRhcmlhIGRlIFRlY25vbG9naWEgZGEg\nSW5mb3JtYcOnw6NvIGUgQ29tdW5pY2HDp8OjbzElMCMGCSqGSIb3DQEJARYWc2Vp\nbmZyYS5zZXRpY0B1ZGVzYy5icjEXMBUGA1UEBxQORmxvcmlhbsOzcG9saXMxFzAV\nBgNVBAgTDlNhbnRhIENhdGFyaW5hMQswCQYDVQQGEwJCUjEWMBQGA1UEAxMNY2Fm\nZS51ZGVzYy5icjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL9PTe5l\nWC7jplN9PsFwipaPk1bB5UPXxEOeJgr/6xf5RMT//l1L6T/X4uOj+lK6KI8a4pRc\noD+a83AlKb8cvYzDIQEBCDOPqjruIy+TyTwQ358x45mPM/aNivkugPKMaK8Aidma\nnUgeiRuZ1rtFyVqenDkH7qs9SwExR4NnJ/1l7DNkP6znKksBq7PGlYkj0mryxNCV\n1CAEZT6zEIyptWwd0TRHaybJc2uDD5Kl8HE54IvCwxfdKgJVQ/9FK2W9vvZowUQl\nbOGdUHqFvtudcU6VWOPxuRv4NgmkFGRaNBisnfZ3XfUah8yMIvlYXgkAevQNBjnz\ng3P3o8BU5YU6ieECAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAUu6oCJTJ51HQeuiD\n06G3V1HddwBdddkaHK+WVNux+s8fVQH1Z6ZvkIH2xgmi9ZI9jK7OoBv1H0TfM27g\n4i8RC4jkVM9SHJFR5YFlNs/5tMaohIMZ2zURG72tRLtq603OqSzaeZPIthDasWww\nVEfbfbckLrCcjuLzb608J8d0brg+Cgn8YxQY17r/4GbkXYuC9k9zYshOCZelS703\nC7ZdXXJuI6/VXffvbqifT9BsY3SmAPw/JQAiSxpp2+ZTwauq3YLwxDcIq9b5YX35\nqcmfM3D3mVPH/aUvLhgtMSlmaGYm8o1mD9LUIR5b5C4A+j/qmzu1IIf3JYqMjb/V\nWiKadQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UDESC - Universidade do Estado de Santa Catarina"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UDESC - Universidade do Estado de Santa Catarina"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.udesc.br/"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.udesc.br/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UDESC - Universidade do Estado de Santa Catarina"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UDESC - Universidade do Estado de Santa Catarina"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://lobo2.lab.sunet.se/shibboleth",
    {
      "entity_id": "https://lobo2.lab.sunet.se/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "0"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "lobo2.lab.sunet.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC/TCCAeWgAwIBAgIJAML/7NVXPHgMMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEmxvYm8yLmxhYi5zdW5ldC5zZTAeFw0xNDA2MzAxMjQ2MjlaFw0yNDA2Mjcx\nMjQ2MjlaMB0xGzAZBgNVBAMTEmxvYm8yLmxhYi5zdW5ldC5zZTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANv+IOxBi0J3ZFp4X+8iAinKpojT4LII8Ost\nwllFgGcjrbarjDe9fZyOP0QJkw8BzQIRRveSrB8hcX/2ekKG6uTOc1klKjE8RfIo\nPUeIDm1qodd5VJKkoejbQZ/PF1Y3gBPdLmXkh1E1k+XlxuvBiC+GLRgwCljCP+Jp\nXJ5p4kP46xNzQeXBAExHgz0zNtOQVBnYJlmT18hoHAvNy1GGXfazXOX5bmDgrzKD\nfZXSsv0dMwJeH/mtkp6zcMMIG8awKSQVB4r7Ps/ok8iDfKU43JXNAbwMywWd7ooj\nf0TVA9VXVxb2sJIEwX96z1l4YqoVTNxdeagPXSNZG3hKjluCyp8CAwEAAaNAMD4w\nHQYDVR0RBBYwFIISbG9ibzIubGFiLnN1bmV0LnNlMB0GA1UdDgQWBBRZkMZIMbgy\nuc/8wmPJMdQ7hqRMRDANBgkqhkiG9w0BAQUFAAOCAQEAR4SDw2aQcOx2/eKYyeYp\nOP/Q/pTfDCwm/iu76kI6wufj7PdL2/4ovTRZaKv0jnzd5RP364wRCyzS+OQZHHaS\nLbeYrsJmBfKKGdXL9ESh2svL8Z6NVBmfDF/Kmxm6Xgd/BRrgmz/qSH0v3iaMyCpH\n5yro+XDI5AfteZfQg0AZDox+mMoR7wzFcymQpVA1Z5RWoRuPVC8oO9ILYcCrq+6M\nNr4loPU74SFod1O6Y7SZ5A6Cz1JXaeAy0AXpvFXx8mK31mIVx3yjnFa9im4Sqraf\nMLNKAa3vUl765Wt8I1Q9p7FvbV0qki2rEk8Q/D6qnquI06uajRRybcH+qEoUFqRX\npA=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=lobo2.lab.sunet.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://lobo2.lab.sunet.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://federation.umontpellier.fr/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Boz Franck"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "franck.boz@univ-montp1.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Aurelien MORAT"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "aurelien.morat@univ-montp1.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://federation.umontpellier.fr/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://services.renater.fr/federation/en/metadata_registration_practice_statement"
              }
            ],
            "registration_instant": "2014-11-26T15:40:57Z",
            "registration_authority": "https://federation.renater.fr/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://federation.umontpellier.fr/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://federation.umontpellier.fr/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://federation.umontpellier.fr/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "umontpellier.fr"
              },
              {
                "information_url": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.univ-montp1.fr"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Montpellier University idp"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "IDP de l'universite de montpellier"
                  }
                ],
                "logo": [
                  {
                    "text": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAABk0lEQVQ4y6WTu06CQRCFv1nUQhsT/VvBzkujEqzQ/DbGhMJLJCYkBB4BSiv1CYA3wBBtJEYLErURL5WGhMZLp9ZY0GhjcC2W8F9QY+I0szkz5+yeyazwTej1ZAYIgp4ygDyjuZDDUtHfK11EzRbCIN8q00TYkXIp3yWg15M5IMPfIi/lUhZAAei1ZNpDHg1CbMlpjy3BQL9bINPm0KPjiSk+yXn04ysQCcP9AwSDkE6ANQTFPbf5nI4n6godSHk8W5YhA8QWYSFqzvacf3qD6EBKgbY9hQVX48Q4TIzB27uxYM/7p2ortIQ8mB01hOI+9Ld9HxyZPDvt40tIeYDZMFjDUL2C6qW5tfEKlRO4fzTWLMut0FSIfnYEZky+uIbJcXO+qZl8ft1tUWgqtNQ9A3x7N0+PrxqscmZy9dLU7KjbQl2hWoUOcPdonr29CaERqJxCo+EQqlfOXABUqyDQ2f1cZ4kiYbitwdMLv0RWyqX8v1e5+zPh28ofbnbm6Au9vBGit28FdMpbkV0+VFGOd5tu9AudaICSH77WlwAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0wNy0yMFQxMDo1MDowMyswMjowMNhLLKEAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMDctMjBUMTA6NTA6MDMrMDI6MDCpFpQdAAAAAElFTkSuQmCC",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Montpellier University"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Universit\u00e9 de Montpellier"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDVDCCAjygAwIBAgIVANLpEjQnKlSmtfHEGcM1f/W7i4lpMA0GCSqGSIb3DQEB\nBQUAMCUxIzAhBgNVBAMMGmZlZGVyYXRpb24udW1vbnRwZWxsaWVyLmZyMB4XDTE0\nMTEyNjE0MDA1OVoXDTM0MTEyNjE0MDA1OVowJTEjMCEGA1UEAwwaZmVkZXJhdGlv\nbi51bW9udHBlbGxpZXIuZnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQCmmImK4S7w7kBZ7+B6u08+SVar2WziXT2HeFII+NcAWeSwMIcu8ZqJeIB6wO9M\nbupXiAmXtRC0iICDKbL1AlDdyL3NrGvwWPNyha5xvDHCxT3lDCWeJpTb8RH/9sFj\nkPHOCE9VMU43GO+5r01Kequm7Nq6uocH7vCxUedZt+wUb7pEJLRR7U8IvC2kQoNX\nkdILYF9njDlEiTl2ypmzh650gtp7lrmUuE/7aOmvwfJ+yThUkOVjcyOB0O1pvmub\nhujVpYLm8QhLY+YQvziw7K5FyAGcsodDoVFbYQX2w9A0k4qvMbhqMCpAW5vIXyH9\nI7DboeEAd1Hx+UddYu5ZsXj/AgMBAAGjezB5MB0GA1UdDgQWBBSmZeTS5ODCHv+N\nlkOHEz7PvbycwDBYBgNVHREEUTBPghpmZWRlcmF0aW9uLnVtb250cGVsbGllci5m\ncoYxaHR0cHM6Ly9mZWRlcmF0aW9uLnVtb250cGVsbGllci5mci9pZHAvc2hpYmJv\nbGV0aDANBgkqhkiG9w0BAQUFAAOCAQEAnBA+peFmxiPlU2s9zj3md7Yq2zNbWYBz\nGz5Ur5EvuVarCOx5aigdHrjHtORDVCHOuB6BgHqfDAK15V3qLSZEx4jjMJ4w5xi4\nsLcm4kn+j/wYaIZkTOxyUp57ECNrhwGJT2SbnYKmmlD9mxNnjNGGuLFSxfxcqNCm\nf6yIOQbKNi+Q/JSTc5ma6qtjO4u3darPGaP83/MYulHEjx+Zy4yiAntw0oPk3ZxY\noz6GW83/GNoyFh4u65Ay8Cox65Hk17SVMxHhc/LPv7rII1uLSoLmTTA/aJN9zyEf\n9EnaolCTqrzcOMIMPXkxzbx4oep11GrkLknLljw3wLfQkaBe0fBs2Q=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Universit\u00e9 de Montpellier"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.univ-montp1.fr"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Universit\u00e9 de Montpellier"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://ubas-test.srv.lu.se/shibboleth",
    {
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "\u00c5hfeldt"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "martin.ahfeldt@lu.se"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Martin"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://ubas-test.srv.lu.se/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ubas-test.srv.lu.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://ubas-test.srv.lu.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://ubas-test.srv.lu.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            }
          ],
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDvjCCAqagAwIBAgIJAOfZjMApPqeXMA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNV\nBAYTAlNFMQ8wDQYDVQQIEwZTd2VkZW4xDTALBgNVBAcTBEx1bmQxEjAQBgNVBAoT\nCUxEQyBkcmlmdDERMA8GA1UECxMIVEVTVC1zc2wxHDAaBgNVBAMTE3ViYXMtdGVz\ndC5zcnYubHUuc2UwHhcNMTUxMDE0MDkwMDAxWhcNMjAxMDEzMDkwMDAxWjByMQsw\nCQYDVQQGEwJTRTEPMA0GA1UECBMGU3dlZGVuMQ0wCwYDVQQHEwRMdW5kMRIwEAYD\nVQQKEwlMREMgZHJpZnQxETAPBgNVBAsTCFRFU1Qtc3NsMRwwGgYDVQQDExN1YmFz\nLXRlc3Quc3J2Lmx1LnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nma6sd5S7fy4QMP1oV3BB8QO92cd/JAIbvgduiOf6JIbwXoamIlpKX8VK0HhXm1Cr\nTrbUBk1cStapjj+bb6DMEmN/YoPcwXDiS7O4Rngm9O2gD4FwFjSxZwOjSfme0FPz\nb9e9XdUd0wcAYn5jOvESB+OdtSDpzGmoOiaobm+5dvnje31bod1GDyxgoWDx201u\nQyVM+10tnRiex5Hrk7WWYnhMEv02PLIx+6cO2ms9a/qqzNfUYt699q5IkfU2yQKI\nXU554jrS3Md0HDGich8TBphtLMzQ8Ot3SVkJza48u9L3Fpk6ANk8lkKM5E7ywaD2\nIS6RKHxEdOaYi+WvyMWMsQIDAQABo1cwVTAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF\n4DA7BgNVHREENDAyghN1YmFzLXRlc3Quc3J2Lmx1LnNlght0MDIyMS11YmFzLWx1\nLXRzdC5zcnYubHUuc2UwDQYJKoZIhvcNAQELBQADggEBAHM/29XBSwCIyROueQ1y\nFmit577cWeazp1+NBL3NRHtesFJdMftMCGncQxGmLrLtM7BTXOo3VIESzKYMl1Xm\n95IX1G1n38VkoVqJvTeVaSC6ICdphoRzoS3RIdZVFZ5h7VYz7zhqwmS5b8sXGvhH\niJQJq7XXtua5AkQnhyg4S2Tvl+OGXXM02d3DYLAfnn9Hqwh2OYK++J1FJUsnRFy9\nMq8mcNGZ3w2+BrFczNJ+C23CGJ2dxQS77hAPIB8fOTPKt8zFbsFRk4TeDwFUlQ1m\nES+MzAaLWpKSnGkIsyHbz5P8oek6Suc5ewoxo/7lMBXDpwS1YSEets0i0s6OHM5C\n5iU="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "uBAS och luBAS testmilj\u00f6 / utbildningsplaner och kusrplaner"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "uBAS and luBAS testing"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "uBAS test"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "uBAS test"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }
        }
      ]
    }
  ],
  [
    "http://shastacollege.instructure.com/saml2",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@instructure.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Canvas Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@instructure.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Canvas Support"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@instructure.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Canvas Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@instructure.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Canvas Support"
          },
          "contact_type": "other",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ],
      "entity_id": "http://shastacollege.instructure.com/saml2",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Instructure, Inc"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.instructure.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Instructure, Inc"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shastacollege.instructure.com/login/saml/logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shastacollege.test.instructure.com/login/saml/logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shastacollege.beta.instructure.com/login/saml/logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.canvaslms.com/"
                  }
                ],
                "logo": [
                  {
                    "text": "https://canvas.instructure.com/images/canvas/header_canvas_logo@2x.png",
                    "lang": "en",
                    "height": "220",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "220"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://www.canvaslms.com/policies/privacy-policy"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "OEI - Shasta College - Canvas"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE8TCCA9mgAwIBAgIJAOBms/PYWcPLMA0GCSqGSIb3DQEBCwUAMIGrMQswCQYD\nVQQGEwJVUzENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENpdHkx\nGTAXBgNVBAoTEEluc3RydWN0dXJlLCBJbmMxEzARBgNVBAsTCk9wZXJhdGlvbnMx\nIDAeBgNVBAMTF0NhbnZhcyBTQU1MIENlcnRpZmljYXRlMSIwIAYJKoZIhvcNAQkB\nFhNvcHNAaW5zdHJ1Y3R1cmUuY29tMB4XDTE1MDQxNTAxMDAwMFoXDTE3MDQyMjAx\nMDAwMFowgasxCzAJBgNVBAYTAlVTMQ0wCwYDVQQIEwRVdGFoMRcwFQYDVQQHEw5T\nYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5zdHJ1Y3R1cmUsIEluYzETMBEGA1UE\nCxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2FudmFzIFNBTUwgQ2VydGlmaWNhdGUx\nIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVjdHVyZS5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDckDPQGWedlVGC2Z9fn1wNFmN+0IPNi6OSE1nM\nvoTWx2oZlQepaAu4zI5QqOfnV0rW2V1volpoJbu0WelH0DkGzdOEQdWJjAs3nRBf\ny0evxtpg0tK5kIvGsnN6YcD41YmkfWzvwbMf0cEq1Y0wCmymF6XzOUUE4zsi0nhP\nm2Z7WiuongDQdR01UsDN13YcpD/i1JXr3YtkNnJ/a1Kc9OXNycI8M5NVo5QQgdx/\nQ7zAmTk8p9E0ZRthdOQ/PBicWx39mNmBij5KpqCWlHu3NWdgcG8KXSv5atXU8Crd\nTRJ3aGIEN9vBYIHe8MHGCzs1QlRfJmXFMkeUSOTnJJx78rMDAgMBAAGjggEUMIIB\nEDAdBgNVHQ4EFgQUo0WWVlJ1SxZOs11L85ZAuZGyuzEwgeAGA1UdIwSB2DCB1YAU\no0WWVlJ1SxZOs11L85ZAuZGyuzGhgbGkga4wgasxCzAJBgNVBAYTAlVTMQ0wCwYD\nVQQIEwRVdGFoMRcwFQYDVQQHEw5TYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5z\ndHJ1Y3R1cmUsIEluYzETMBEGA1UECxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2Fu\ndmFzIFNBTUwgQ2VydGlmaWNhdGUxIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVj\ndHVyZS5jb22CCQDgZrPz2FnDyzAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBCwUA\nA4IBAQBV3EmmnzYqYQ5fXNZymG2WaspEW0NeFMhDXa3p3AMIQJbnnU14lR7bqIvf\n/bLW1YE0fw1kSzsw8VrkQp7k1U+kaYA3i5/FQBy2WtqUCVq2GXZA2gs5YD4nvJB/\nF57E//0kEhbATZH9+wJqDkqyIgsrSIlJjiXDth1BppGK8weboPtr9sWV24Ui0+ls\nw16XTsGlnRRO19g+gXKOZp5ApXkDrB+HwZQvZxiCuSgvJlcBzMdxVvWSL+vPtg8Y\nshIKzobIhaQ2MzXHLcxrDhW10YFPwDXh8Tfn5iU9ONsaJivuvVhtDYZD1ZzSoPpm\nq4vYqxxY/6rFJhrCtnlLepSaxlXM"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.instructure.com/saml_consume",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.instructure.com/login/saml",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.beta.instructure.com/saml_consume",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.beta.instructure.com/login/saml",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.test.instructure.com/saml_consume",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shastacollege.test.instructure.com/login/saml",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "OEI - Shasta College - Canvas"
                }
              ],
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://miunidp.miun.se/idp/shibboleth",
    {
      "contact_person": [
        {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "contact_type": "administrative",
          "telephone_number": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber",
              "text": "+46 771 975 000"
            }
          ],
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "SystemDrift, IT-avdelningen, Mittuniversitetet"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:SystemDriftIT@miun.se"
            }
          ],
          "company": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company",
            "text": "Mid Sweden University"
          }
        },
        {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "contact_type": "technical",
          "telephone_number": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber",
              "text": "+46 10 142 7888"
            }
          ],
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "M\u00e5rtensson"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:roger.martensson@miun.se"
            }
          ],
          "company": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company",
            "text": "Mid Sweden University"
          },
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Roger"
          }
        },
        {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "contact_type": "support",
          "telephone_number": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber",
              "text": "+46 771 976130"
            }
          ],
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "IT Helpdesk"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:helpdesk@miun.se"
            }
          ],
          "company": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company",
            "text": "Mid Sweden University"
          }
        }
      ],
      "entity_id": "https://miunidp.miun.se/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/policy/assurance/al1"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "urn:oasis:names:tc:SAML:attribute:assurance-certification",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              },
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/hide-from-discovery"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://miunidp.miun.se/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://miunidp.miun.se/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://miunidp.miun.se/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://miunidp.miun.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://miunidp.miun.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "miun.se"
              },
              {
                "information_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.miun.se"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.miun.se/en/"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Mittuniversitetet PRODTEST"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Mid Sweden University PRODTEST"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo",
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "IDP p\u00e5 Mittuniversitetet"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "IDP at Mid Sweden University"
                  }
                ],
                "logo": [
                  {
                    "text": "https://www.miun.se/imagevault/publishedmedia/x4bl7padufcm1j4td3d7/logo.png",
                    "lang": "sv",
                    "height": "111",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "225"
                  },
                  {
                    "text": "https://www.miun.se/imagevault/publishedmedia/x4bl7padufcm1j4td3d7/logo.png",
                    "lang": "en",
                    "height": "111",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "225"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://www.miun.se/sv/Helpdesk/Student/MittNets-regler/"
                  }
                ]
              },
              {
                "domain_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint",
                    "text": "miun.se"
                  }
                ],
                "geolocation_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint",
                    "text": "geo:63.176762,14.651352"
                  },
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint",
                    "text": "geo:62.394626,17.284259"
                  },
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint",
                    "text": "geo:62.630989,17.946473"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDNzCCAh+gAwIBAgIUDopqrwr+8ysNjsx8WcAQU0xgFqYwDQYJKoZIhvcNAQEL\nBQAwHjEcMBoGA1UEAwwTbWl1bmlkcHRlc3QubWl1bi5zZTAeFw0xNjAzMTQxMDQ4\nMzRaFw0zNjAzMTQxMDQ4MzRaMB4xHDAaBgNVBAMME21pdW5pZHB0ZXN0Lm1pdW4u\nc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDSfUra2csPm7zfml2+\n+FLWgZ3C3W7V77ogOuOd/5+79XywWdtHD1WrJntmL4eGvytW8vU6/DOo0c4UVKxt\nDKB2LSIy6uwd+OPbnWl6IQbk2ylb0UOIMV1pLMgBmrBoKt2dtpUH0T3Oqg2D7r9r\nCH8nk7rgrT5INIQDCS1NNVWEgRqltMH1Mmn90J2XzoGZrl6ZmEZ8uWURcypuPZcT\nQY9VvbVP8PKz1Bo9Qhh0LjXOumIGCdQoH0sQytePjcroLpL1HSAvX7DDsPNl4/Qh\nsnILrHdK2z601oN1Ngu1rxrqWz0H2j9Z8U+zYjxdGOpvjXPg8iOIZJW0YM36SbcB\nSfKZAgMBAAGjbTBrMB0GA1UdDgQWBBQC5zJpccPPIWSbMiJAkQHQ39PBNTBKBgNV\nHREEQzBBghNtaXVuaWRwdGVzdC5taXVuLnNlhipodHRwczovL21pdW5pZHB0ZXN0\nLm1pdW4uc2UvaWRwL3NoaWJib2xldGgwDQYJKoZIhvcNAQELBQADggEBACdM6Gcf\nmHA0Hr1zC4T18vXqj2todlOm/wBoisGcJ8Yvz5YDozE0Ginn1RpjaUab/v10s8BK\nxBwVnyzTupIJMl0pW7XEHzVEWStpn69m+iNFtDuCe8gVvILI0dRt1NVUD/+b3d1U\n/QePhM43hJVGWi7/yyP12INV98P4HdZ91VMxafGzFVCh/cgLjYxwVaAYt0kCzZqE\noAK9ajxQTMEz7h5ebJDfi+eydnDmzUFuFYzjB4CIPs0YLvyr5R1wXOxzZcpPE7c5\nqjqmAlpXZIozlPXNuM5NG2qX5fs+okW0ZvDzp7uGthyxxTchBR8PxTfSnE2ImX2a\nQ2DB2f7ifMpnsvw="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDODCCAiCgAwIBAgIVAPRwsS0jawwgnaLnIOydT5jeXjVhMA0GCSqGSIb3DQEB\nCwUAMB4xHDAaBgNVBAMME21pdW5pZHB0ZXN0Lm1pdW4uc2UwHhcNMTYwMzE0MTA0\nODMyWhcNMzYwMzE0MTA0ODMyWjAeMRwwGgYDVQQDDBNtaXVuaWRwdGVzdC5taXVu\nLnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4EPO2E98M79WKFHy\nAPjeQALlMgPuAkrVa9aiC84V7q3hgfdbD0wbNJTGA9uj7an2Fz5uNfUWS1Rg/7DT\nuEjrGpsWXn3mlBuH2wOZe9wHqFwVf5NUos/00gLxs6WIjaNv6gxnbnVss0pKURTL\n+bl4mn7XSPpbNosWlHkn4IbnXBi8zTwQ7Us2+klu15YfAPnlkMYgzOl1YkxqB3cM\nzxnejzBjzpG1VJWkLUOEFxlFYUwEsn5aOMpT4DXEq1PSSZfDmtz6tN+WQiV8W1rt\nQYyThOUwvF+L6Z9N960IFfiirCVk30doFfu5P/KmzciFWKcRHH2Jce3R/pC0SVNs\n56Z63QIDAQABo20wazAdBgNVHQ4EFgQUhtV3ZMcE4JWqlNJJVYkqB5inKUEwSgYD\nVR0RBEMwQYITbWl1bmlkcHRlc3QubWl1bi5zZYYqaHR0cHM6Ly9taXVuaWRwdGVz\ndC5taXVuLnNlL2lkcC9zaGliYm9sZXRoMA0GCSqGSIb3DQEBCwUAA4IBAQCKf/Z8\nm1RMKsiP56XEBD/KlZToM23WF+i3xw7IPlo6a+bMT2emxKBCVv3CU6oMe55TMUeu\nRHzNHB3g0oa/xH+APxLbP64FMvDrJAPFDsltRX97C9UyO47rBL983Jcjo20fjCt1\n03xMipYa9aYc6miUSXKSP0zLu8XoyRo8Vlx0+4y1hI1B/vfgw2I850thSfM/TepO\neHLpC5j1cjhz+omgj8KtOu4iwRShXmOTb3/MPKYQ0BezIuI99QfavE3jkdVg4+bb\nsEjpTEgCNeNotsnug8EzSf3jMac7QVsKk/ZUjpMUiH1QWeXQSzpkT+BfEjcXUm23\np8Zy6HNa1RvGgW8P"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDNzCCAh+gAwIBAgIUPMQjIIrMt+goB+uHSwi2oO14KAgwDQYJKoZIhvcNAQEL\nBQAwHjEcMBoGA1UEAwwTbWl1bmlkcHRlc3QubWl1bi5zZTAeFw0xNjAzMTQxMDQ4\nMzRaFw0zNjAzMTQxMDQ4MzRaMB4xHDAaBgNVBAMME21pdW5pZHB0ZXN0Lm1pdW4u\nc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCgqMKF+EDtjw74HWSy\nt2SU4fV4734PyV9gsPBJph8VQ32cAB7tqkqhIQbkHJKhJ4XeladH+ifk+BOdje9n\nEwIKIehxdujW832NAlMkEXfo3M2wt8UCBATCoWsxexkFUtNhZQnvtUm7dW0GuDYE\nNaZd0W6JMz0vBl83+JatCHu30kHu6CDgo/D6S9RL4pj3KiN08oR5Rjn5jHdNgMTf\ndNuYn2jsvKiR9EtcXC2KgvtYwqzGpjmcFxthBPBF3lzAza8ES16UVCPxVuH9DSJ5\ngB20wTMzP9xKSWQ/NKjh4AqEZ0hLH4dXGDzA3G3h/IkSgfaB+XalZDC6vzfuXXnv\ndE2HAgMBAAGjbTBrMB0GA1UdDgQWBBREfhKvA2DRE1mKkZfCgjAyiwegWzBKBgNV\nHREEQzBBghNtaXVuaWRwdGVzdC5taXVuLnNlhipodHRwczovL21pdW5pZHB0ZXN0\nLm1pdW4uc2UvaWRwL3NoaWJib2xldGgwDQYJKoZIhvcNAQELBQADggEBAGl9GoKC\ngm7ywKn8I5eAF+MEUkDPPPt5KMSfIe7SZmI975vceeCDaPOZ8gvKuAHHC3yG6fgf\nFLqNffN26y4k6EYg4XVGq5u8SmEwDktTn4wRJyj4NN9cqg3EZbw7wa10jTVTGEWm\n13Hf0TEi2qAkU3Xb8K7hHDy//BnKHo1FZLcIPMUGrIpaCl32klb5fAwvE+E6QgCB\naFup4A/f+gTnofyIo1gi8TmMs/7v+A5Ty39VdmU15eXvA2TBhGEDFmVAQWnZvSQ2\nYAe2eCFJhzuNutfMyzzH4ZE1da+vfxQX0yLQpKiK4XRIH4Jr1THM/12L+YNmlRPF\n7RI4YGkyabhUuiM="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Mittuniversitetet PRODTEST"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Mid Sweden University PRODTEST"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.miun.se"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "MIUN"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://bismarck.nyme.hu/simplesaml/saml2/idp/metadata.php",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Nemeth Tamas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tamas.nemeth.net@eik.nyme.hu"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Nemeth Tamas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tamas.nemeth.net@eik.nyme.hu"
            }
          ],
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Nemeth Tamas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tamas.nemeth.net@eik.nyme.hu"
            }
          ],
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://bismarck.nyme.hu/simplesaml/saml2/idp/metadata.php",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "urn:schac:homeOrganizationType:hu:university"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              },
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "href"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "href-edugain"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "nyme"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "urn:geant:niif.hu:eduid.hu:entity-attributes:processing-info",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          },
          {
            "registration_policy": [
              {
                "lang": "hu",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://metadata.eduid.hu/registration_policy_1_0.txt"
              }
            ],
            "registration_instant": "2013-08-01T07:17:19.807Z",
            "registration_authority": "http://eduid.hu",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://bismarck.nyme.hu/simplesaml/saml2/idp/SingleLogoutService.php",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://bismarck.nyme.hu/simplesaml/saml2/idp/SSOService.php",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.nyme.hu"
                  }
                ],
                "display_name": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Nyugat-magyarorsz\u00e1gi Egyetem"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "The University of West Hungary (Sopron), Hungary"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo",
                "description": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Nyugat-magyarorsz\u00e1gi Egyetem"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "The University of West Hungary (Sopron), Hungary"
                  }
                ],
                "logo": [
                  {
                    "text": "https://bismarck.nyme.hu/simplesaml/black_on_white.png",
                    "height": "145",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "143"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "hu",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://www.nyme.hu/fileadmin/dokumentumok/rektori/szmszm/adatvedelmi_adatkezelesi_szab_20150128.pdf"
                  }
                ]
              },
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "nyme.hu"
              },
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "eik.nyme.hu"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "bismarck.nyme.hu"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFcTCCBFmgAwIBAgIJAKBNphZ7hjc7MA0GCSqGSIb3DQEBCwUAMIHVMQswCQYDVQQGEwJIVTEaMBgGA1UECBMRR3lvci1Nb3Nvbi1Tb3Byb24xDzANBgNVBAcTBlNvcHJvbjEnMCUGA1UEChMeVGhlIFVuaXZlcnNpdHkgb2YgV2VzdCBIdW5nYXJ5MTcwNQYDVQQLEy5EZXBhcnRtZW50IG9mIEluZm9ybWF0aW9uIFN5c3RlbXMgYW5kIFNlcnZpY2VzMRkwFwYDVQQDExBiaXNtYXJjay5ueW1lLmh1MRwwGgYJKoZIhvcNAQkBFg1hZG1pbkBueW1lLmh1MB4XDTE0MDUyOTExNTQyMloXDTI0MDUyODExNTQyMlowgdUxCzAJBgNVBAYTAkhVMRowGAYDVQQIExFHeW9yLU1vc29uLVNvcHJvbjEPMA0GA1UEBxMGU29wcm9uMScwJQYDVQQKEx5UaGUgVW5pdmVyc2l0eSBvZiBXZXN0IEh1bmdhcnkxNzA1BgNVBAsTLkRlcGFydG1lbnQgb2YgSW5mb3JtYXRpb24gU3lzdGVtcyBhbmQgU2VydmljZXMxGTAXBgNVBAMTEGJpc21hcmNrLm55bWUuaHUxHDAaBgkqhkiG9w0BCQEWDWFkbWluQG55bWUuaHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC15ZMAePJn6n30uTqOILsewup8QM52/8oNiphDFjWHiZT2/06rAeFK+nAMz06Jn3Q+Thu9fjr5o/ZCY6v2v+ivjLvAd66jH0EGQwNUsHuGP/vWt2BGP2p5tAn7lX3O7oxdZYBEWgB0j+e7hqaDZ7C6ckDCsH7221IgvClo4G78Y9SnrDqlLGhmju+wZINAwQAvtwchF1ffxZFUwVZ/Zm9+nHw4ilxrK0vcKc/PfoNFrSqxOs2GFz5kDz99NBKpc9Np+xBqMNl6QV49VULN1ooZHzO/G52KcAYTEIBUQwGkKFyAmN2jDpOr56cmTJaRI+P9aT60YUBMfhxczKa9KJM1AgMBAAGjggFAMIIBPDAdBgNVHQ4EFgQUJNKwaCbN3djK5kT8wEq72IhGxgAwggELBgNVHSMEggECMIH/gBQk0rBoJs3d2MrmRPzASrvYiEbGAKGB26SB2DCB1TELMAkGA1UEBhMCSFUxGjAYBgNVBAgTEUd5b3ItTW9zb24tU29wcm9uMQ8wDQYDVQQHEwZTb3Byb24xJzAlBgNVBAoTHlRoZSBVbml2ZXJzaXR5IG9mIFdlc3QgSHVuZ2FyeTE3MDUGA1UECxMuRGVwYXJ0bWVudCBvZiBJbmZvcm1hdGlvbiBTeXN0ZW1zIGFuZCBTZXJ2aWNlczEZMBcGA1UEAxMQYmlzbWFyY2subnltZS5odTEcMBoGCSqGSIb3DQEJARYNYWRtaW5AbnltZS5odYIJAKBNphZ7hjc7MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAHvCr7f69ZP77xevakfeh2Kg/Q4OjT4mAYTVahI6ayGGgLvKDzXBxAKNX1gUyH6RNbT4NUQVPXa4jQzrrQC0WDr6lb8zejIyetkat91gkYAisUvFZSWHaTB/wOk9WSnw6spJb/4kCNEqnEMB/RwG2vATDzcfDdqRNkcjy/2qlD8Cj3KkH4joUgmJH925dC8B2c+LtggGNvqHds9JXLhbmj5cw6wRQk0B+1W1IVjEmhCZmHjtltop5pka2cgJ2qqkEnQnjwh4aBIUlk7G6P4x6xElT+jOQEzMyfVGsJ18a3FhXcL2zjoLu2g6buTMGQo/JIcWEEUWvb3QvmGEDjkewto="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Nyugat-magyarorsz\u00e1gi Egyetem"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "The University of West Hungary (Sopron), Hungary"
          }
        ],
        "organization_url": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.nyme.hu"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uniwest.hu"
          }
        ],
        "organization_name": [
          {
            "lang": "hu",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Nyugat-magyarorsz\u00e1gi Egyetem"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "The University of West Hungary (Sopron), Hungary"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.glasgowkelvin.ac.uk/openathens",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Campbell"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:MCampbell@glasgowkelvin.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Matt"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "McBride"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:amcbride@glasgowkelvin.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Andrew"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.glasgowkelvin.ac.uk/openathens",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2014-09-22T14:18:15Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.glasgowkelvin.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.glasgowkelvin.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "glasgowkelvin.ac.uk"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Glasgow Kelvin College"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDWDCCAkCgAwIBAgIIEcxlhYHW7FYwDQYJKoZIhvcNAQEFBQAwQzEfMB0GA1UE\n\t\t\t\t\t\tCgwWR2xhc2dvdyBLZWx2aW4gQ29sbGVnZTEgMB4GA1UEAwwXaWRwLmdsYXNnb3dr\n\t\t\t\t\t\tZWx2aW4uYWMudWswHhcNMTQwODI5MTMyODUyWhcNMjQwODI5MTMyODUyWjBDMR8w\n\t\t\t\t\t\tHQYDVQQKDBZHbGFzZ293IEtlbHZpbiBDb2xsZWdlMSAwHgYDVQQDDBdpZHAuZ2xh\n\t\t\t\t\t\tc2dvd2tlbHZpbi5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\n\t\t\t\t\t\tAOxm3dLSX+UNx+aVR24NNhE03L/lpOpLPxU+COARq2kuD8AGv6OxUWt0tdDYskJp\n\t\t\t\t\t\tSwMQRQmqP2R32ulYMQBeeD0e+Kale+b9uX/Zkut8PohQZeSkCMpV0lEmkK07ivOB\n\t\t\t\t\t\tMh6FiViWZ0XWAQ/6RfnSC/9L+PJcqpRkAwr0qkGo7k2eaE7ffIhZY7ImKVAiPS7r\n\t\t\t\t\t\tYAgZPCiWHtC8eN6+h9kJJo7FyFacKMO82lid+rHdUq+X3335xHL7tFjOCzk/AcI8\n\t\t\t\t\t\t9DSdgvrL3rB/bMmsko7+tz/DbEfrFwMqwpVuX1Cs7YWl88E7VB+FBJZsTLJH2XDQ\n\t\t\t\t\t\tm9930Nq2iULafPahz+IHhgECAwEAAaNQME4wHQYDVR0OBBYEFGZmAoJCe7wdXY7f\n\t\t\t\t\t\t/pFKFpXXbwZDMB8GA1UdIwQYMBaAFGZmAoJCe7wdXY7f/pFKFpXXbwZDMAwGA1Ud\n\t\t\t\t\t\tEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEPUdwYfF7ElyNcGzmGgCz0sqZAC\n\t\t\t\t\t\tUaNoersFgCvSzrc2BWmeivgBUy0VVt5tU2YZKTAcIhvh/ZXNbJzoc+YH/KuLJ1hi\n\t\t\t\t\t\t7b/jDBPH7QZZ4uv4U/WkSr4n/1tRpUnLrY505X/hCxpH11MOs2OHd5edwiIDuiUA\n\t\t\t\t\t\t3hDuvyCQYLy386VhX3UZVBtew16Z5KUhPcbtW/k+RhYuH/j2Inq/4W1UpmsNR2Ug\n\t\t\t\t\t\tl2RyOBeMBakzxmb2R6y3nWcxAidG42LV8DLVUbqwoEcIg4Mt5jbZDrlEhPvW4zal\n\t\t\t\t\t\tTWIuR+MKKnSlSNym/jSdIEVMIQ/mmLy8Pmqg/bdX5zgOHNLQEtGgpX0ReOo="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDWDCCAkCgAwIBAgIIEcxlhYHW7FYwDQYJKoZIhvcNAQEFBQAwQzEfMB0GA1UE\n\t\t\t\t\t\tCgwWR2xhc2dvdyBLZWx2aW4gQ29sbGVnZTEgMB4GA1UEAwwXaWRwLmdsYXNnb3dr\n\t\t\t\t\t\tZWx2aW4uYWMudWswHhcNMTQwODI5MTMyODUyWhcNMjQwODI5MTMyODUyWjBDMR8w\n\t\t\t\t\t\tHQYDVQQKDBZHbGFzZ293IEtlbHZpbiBDb2xsZWdlMSAwHgYDVQQDDBdpZHAuZ2xh\n\t\t\t\t\t\tc2dvd2tlbHZpbi5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\n\t\t\t\t\t\tAOxm3dLSX+UNx+aVR24NNhE03L/lpOpLPxU+COARq2kuD8AGv6OxUWt0tdDYskJp\n\t\t\t\t\t\tSwMQRQmqP2R32ulYMQBeeD0e+Kale+b9uX/Zkut8PohQZeSkCMpV0lEmkK07ivOB\n\t\t\t\t\t\tMh6FiViWZ0XWAQ/6RfnSC/9L+PJcqpRkAwr0qkGo7k2eaE7ffIhZY7ImKVAiPS7r\n\t\t\t\t\t\tYAgZPCiWHtC8eN6+h9kJJo7FyFacKMO82lid+rHdUq+X3335xHL7tFjOCzk/AcI8\n\t\t\t\t\t\t9DSdgvrL3rB/bMmsko7+tz/DbEfrFwMqwpVuX1Cs7YWl88E7VB+FBJZsTLJH2XDQ\n\t\t\t\t\t\tm9930Nq2iULafPahz+IHhgECAwEAAaNQME4wHQYDVR0OBBYEFGZmAoJCe7wdXY7f\n\t\t\t\t\t\t/pFKFpXXbwZDMB8GA1UdIwQYMBaAFGZmAoJCe7wdXY7f/pFKFpXXbwZDMAwGA1Ud\n\t\t\t\t\t\tEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEPUdwYfF7ElyNcGzmGgCz0sqZAC\n\t\t\t\t\t\tUaNoersFgCvSzrc2BWmeivgBUy0VVt5tU2YZKTAcIhvh/ZXNbJzoc+YH/KuLJ1hi\n\t\t\t\t\t\t7b/jDBPH7QZZ4uv4U/WkSr4n/1tRpUnLrY505X/hCxpH11MOs2OHd5edwiIDuiUA\n\t\t\t\t\t\t3hDuvyCQYLy386VhX3UZVBtew16Z5KUhPcbtW/k+RhYuH/j2Inq/4W1UpmsNR2Ug\n\t\t\t\t\t\tl2RyOBeMBakzxmb2R6y3nWcxAidG42LV8DLVUbqwoEcIg4Mt5jbZDrlEhPvW4zal\n\t\t\t\t\t\tTWIuR+MKKnSlSNym/jSdIEVMIQ/mmLy8Pmqg/bdX5zgOHNLQEtGgpX0ReOo="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Glasgow Kelvin College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.glasgowkelvin.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Glasgow Kelvin College"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://shibb-prod.eseo.fr/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Duclos Philippe"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "philippe.duclos@eseo.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Tessier Fabien"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "fabien.tessier@eseo.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibb-prod.eseo.fr/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://services.renater.fr/federation/en/metadata_registration_practice_statement"
              }
            ],
            "registration_instant": "2014-06-11T17:24:23Z",
            "registration_authority": "https://federation.renater.fr/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibb-prod.eseo.fr/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibb-prod.eseo.fr/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shibb-prod.eseo.fr/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "eseo.fr"
              },
              {
                "information_url": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.eseo.fr"
                  }
                ],
                "description": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "\u00c9cole d'ing\u00e9nieurs"
                  }
                ],
                "logo": [
                  {
                    "text": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACjklEQVQoz22PW0iTYRzGn/f9Pr/t29lDzkxZWDdF4rEiCKQIw1AMjIiitMKoSK3AqGsvQgoxyA7eNMIIBLsyM89JmTp1GlPLnJOZ20xt2pzTbd/eLhxh0v/yx/Pj+T9gjPVbZm2zbrtrubnPyhh70zEelCS7Y8nuXAoEgvWto4yx1s/WYFBijPEAIjVyEKKQR+wxRAOIj1VTQkAJz1FCyNHMnQAS9BrGAIACSIzTWGw/u0fsPEf7xx3Lq+sA1gPB3rHZtgGbWinUtVrUKoHnKQAeQG3jcNnTdkJQfSXrnrFnzR/orDx9ubrV6nQbopUXspMrXvemJW3re1zIcRwFsLDsKz+ZOvWiWKtSHNkXV5qf0W6e/uXxDVSd6a4699HiqL+T41j0zrs94QYAWpXMEB/FjztFGa9Vy/2+NQA79NrYGJ0UYvooJaXUa/6yYpsIC5uv/NQBSZKevx/dwkM+r5if8x9BIQpbiORysWW3LHM/p4+hG6jhk/Xus3ZKYPo+X/zwnd21FGIoe9LZYpoEsNbWBVGxkQwLMwuewYnZg15HAl1rNE0am4cBZppw/phbAiDmHieC7B/hZn5q043DUWMj3S9vXc1NW/cHKCE91Wcv5WYCoLrIv++FBcaY11inuV1KCAUQ/PaVra4CkBbmQ7apzXvCo/2DZkVhbvPQTJd5SqEU+V27iXV8xWgU5heJPnGzQAEgFBJSkoWM9N8+v83lBkAiIsBxqqIiXWUFVarCUUoA8J5HNaTP+WA1urZjsiQvpWlopmXEUXMtS+C59JJXhhhVclJswf23Ik+jNAoAvDwv+/r57YEGkz8QPJZukMtk9rnFgqy9WrXqg3lapxQunkgLSKGCQ0miKAfwB8CbFDy3w6N2AAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTA3LTIwVDEwOjQ5OjAxKzAyOjAwck/JggAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0wNy0yMFQxMDo0OTowMSswMjowMAMScT4AAAAASUVORK5CYII=",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Groupe ESEO"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Groupe ESEO"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDODCCAiCgAwIBAgIVAPKv3AMhxdHV3jWXxqMbNKHYz0KVMA0GCSqGSIb3DQEB\nBQUAMB4xHDAaBgNVBAMTE3NoaWJib3VsZXRoLmVzZW8uZnIwHhcNMTQwNTEzMTI0\nNDQ4WhcNMzQwNTEzMTI0NDQ4WjAeMRwwGgYDVQQDExNzaGliYm91bGV0aC5lc2Vv\nLmZyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmCTC2H03ZXvDs4Io\na1d+L6ggwRUqGwP45mlW5l6Nuti5JBqjDLBvP1tPqAeh1V6boPufnkd2ZquVCZDP\n1WFjLKyL015a81gLeWvJMId1yWq4+7s4s1HBFgaftNM6z6Hl/sTt1UL/dFM3DrNH\nZ1fUHe+TWGv8e60KA4DqhjdphtM+Q0dsZNVDGGp5d0zLOPhrikoZE8pqXvbOD7r/\nW9I8jWEX4RIBJkvpeBI5zpGZVRbq5LKNVaccEJW3dx9v1MyI7JQbT90hmUdBYIOl\nb+vQ5fgJCj9RlgK+tEMJsB67w2SvD7YsG3w/DqogoZBeQUgolwPKteAyKGZIh0Y2\n5pyMSQIDAQABo20wazBKBgNVHREEQzBBghNzaGliYm91bGV0aC5lc2VvLmZyhipo\ndHRwczovL3NoaWJib3VsZXRoLmVzZW8uZnIvaWRwL3NoaWJib2xldGgwHQYDVR0O\nBBYEFMR3J/ymlt+tWJbLpfaFrrhqC2qZMA0GCSqGSIb3DQEBBQUAA4IBAQAzJ0MU\njZjJiOzYrQkeSkDw0kl2drKEOW1/54ANucqNSko1MQ2QXbOiL2bcgOXC8jDgOyEX\n+G0QO8YdGio1CCirUVPTWSIsxpRM9nI2FbhpGk+DXe2wgPTYnJPN94kdVJrWEE/Y\nBtBvR1BzklAZ6sLrXQMWerGNHAQIyQ8+SInFpqtbB9yJuWuc9oVaoGYIm3TI2N8S\n/Uo1+w4j8jXAl7tXaUnoZ1oKW36H+0sRVhZ2Ys4eH3Vk6nvf5qHPdgUCNjh6txmf\nom24YGvt8hL3ZCb5y2+jFCIZyCf853CuTiEjLyT7c1KZzUPzvDVqf0gL5n3twqxj\ncE2NlFME1N0tqRVC"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Groupe ESEO"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.eseo.fr"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Groupe ESEO"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/metadata.php/default-sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "NOC"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "noc@sunet.se"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SUNET"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/metadata.php/default-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/eu-adequate-protection"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/nren-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Swedish University Network (SUNET)"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.sunet.se"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "SUNET"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/discoresp.php",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "SUNET Box Service Access"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "SUNET Box Service Access"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "SUNET Box Service Access"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "SUNET Box Service Access"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDjjCCAnagAwIBAgIJAKbtZfJN7G7eMA0GCSqGSIb3DQEBBQUAMDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZTAeFw0xMjA0MTkwNzAxMTBaFw0yMjA0MTkwNzAxMTBaMDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAO+53L5J4zaSe/ot/CU+fX/xsE0q2Vsvgs6Jrz4bgPtkiXcCCRcp1kV9wRxBEohK75DtumowRN9P0qL5SsawM5o6XflMpL9vhO1Xvi8NnrFp/utUnjwevgbxsi5efetqIezE+B8cimv1MEfN4/XxiCuKbqluEC4HYuopf9Cn32ob2VnQA31WYwW42+pfS733M4EIMYkpBdaacpJKFmCsu9BHnGgFTiSgJsvX9OGG7iwSB31Jp817BFOB0yhvx7Y2yFLSnRyyg/20BJ0t9R8UFVB4rx5bjyTlTGwvPg048UV8Go3wDSax18OT0AoTfE7O3QoXNOhPr1qi4bs0KL92R7sCAwEAAaOBmjCBlzAdBgNVHQ4EFgQUluTZFj+ee4BZ0slOOiUpsZG/KjwwaAYDVR0jBGEwX4AUluTZFj+ee4BZ0slOOiUpsZG/KjyhPKQ6MDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZYIJAKbtZfJN7G7eMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADPhDcfQDwHGhTeQuSDaBfa1/gbJkuiNRZSN000CIM1BalnuK5unV05SvBMG4t7mSj9oO+NnpjEBfV393I2XV5ICRuHbUpoX8tezGOA3I8amItR6WzJtFSn/Dv230KRcEuCAWz/A7LKog16eOPPDj64vBI9Lk5gYpXRB3y1Pnv+5IUgXb2YnS6XAEduHpm2dkj2CuSmpsWTPJapm/opsJvmrkZbvwQN1POPDyWW8Rb/gSr7XpFsDQ7lXObd2ADv82WENB6DLuUq1ilAkVR8Zs4OkFnLYASFUC25GtfUdUap/anb5gHF7a8MKN+NYlfNQWE1dm1jccCnA3eIBxkArDdU="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDjjCCAnagAwIBAgIJAKbtZfJN7G7eMA0GCSqGSIb3DQEBBQUAMDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZTAeFw0xMjA0MTkwNzAxMTBaFw0yMjA0MTkwNzAxMTBaMDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAO+53L5J4zaSe/ot/CU+fX/xsE0q2Vsvgs6Jrz4bgPtkiXcCCRcp1kV9wRxBEohK75DtumowRN9P0qL5SsawM5o6XflMpL9vhO1Xvi8NnrFp/utUnjwevgbxsi5efetqIezE+B8cimv1MEfN4/XxiCuKbqluEC4HYuopf9Cn32ob2VnQA31WYwW42+pfS733M4EIMYkpBdaacpJKFmCsu9BHnGgFTiSgJsvX9OGG7iwSB31Jp817BFOB0yhvx7Y2yFLSnRyyg/20BJ0t9R8UFVB4rx5bjyTlTGwvPg048UV8Go3wDSax18OT0AoTfE7O3QoXNOhPr1qi4bs0KL92R7sCAwEAAaOBmjCBlzAdBgNVHQ4EFgQUluTZFj+ee4BZ0slOOiUpsZG/KjwwaAYDVR0jBGEwX4AUluTZFj+ee4BZ0slOOiUpsZG/KjyhPKQ6MDgxCzAJBgNVBAYTAlNFMQ4wDAYDVQQKEwVTVU5FVDEZMBcGA1UEAxMQYm94LWlkcC5zdW5ldC5zZYIJAKbtZfJN7G7eMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADPhDcfQDwHGhTeQuSDaBfa1/gbJkuiNRZSN000CIM1BalnuK5unV05SvBMG4t7mSj9oO+NnpjEBfV393I2XV5ICRuHbUpoX8tezGOA3I8amItR6WzJtFSn/Dv230KRcEuCAWz/A7LKog16eOPPDj64vBI9Lk5gYpXRB3y1Pnv+5IUgXb2YnS6XAEduHpm2dkj2CuSmpsWTPJapm/opsJvmrkZbvwQN1POPDyWW8Rb/gSr7XpFsDQ7lXObd2ADv82WENB6DLuUq1ilAkVR8Zs4OkFnLYASFUC25GtfUdUap/anb5gHF7a8MKN+NYlfNQWE1dm1jccCnA3eIBxkArDdU="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://box-idp.sunet.se/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://shibboleth.kcollege.ac.uk/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Mitchell"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:garethmitchell@kcollege.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Gareth"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Mitchell"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:garethmitchell@kcollege.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Gareth"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibboleth.kcollege.ac.uk/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2011-03-08T17:52:30Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEVDCCAzygAwIBAgIJAIt8JpQ7ds27MA0GCSqGSIb3DQEBBQUAMIGqMQswCQYD\n\t\t\t\t\t\tVQQGEwJHQjENMAsGA1UECBMES2VudDESMBAGA1UEBxMJVG9uYnJpZGdlMRIwEAYD\n\t\t\t\t\t\tVQQKEwlLIENvbGxlZ2UxFjAUBgNVBAsTDUlUIERlcGFydG1lbnQxIjAgBgNVBAMT\n\t\t\t\t\t\tGXNoaWJib2xldGgua2NvbGxlZ2UuYWMudWsxKDAmBgkqhkiG9w0BCQEWGWl0c2Vy\n\t\t\t\t\t\tdmljZXNAa2NvbGxlZ2UuYWMudWswHhcNMTQwMjEyMDk1MDA5WhcNMjQwMjEwMDk1\n\t\t\t\t\t\tMDA5WjCBqjELMAkGA1UEBhMCR0IxDTALBgNVBAgTBEtlbnQxEjAQBgNVBAcTCVRv\n\t\t\t\t\t\tbmJyaWRnZTESMBAGA1UEChMJSyBDb2xsZWdlMRYwFAYDVQQLEw1JVCBEZXBhcnRt\n\t\t\t\t\t\tZW50MSIwIAYDVQQDExlzaGliYm9sZXRoLmtjb2xsZWdlLmFjLnVrMSgwJgYJKoZI\n\t\t\t\t\t\thvcNAQkBFhlpdHNlcnZpY2VzQGtjb2xsZWdlLmFjLnVrMIIBIjANBgkqhkiG9w0B\n\t\t\t\t\t\tAQEFAAOCAQ8AMIIBCgKCAQEAyUONnw9FNuYKcET6VNifgEdvZOAOZXlyJTOmS+dR\n\t\t\t\t\t\ttEhyW8TBc5gFjyPyc12Odj3qelGj/IwN0UuvN9XSZwVXVfTfxShmAxfA4jGp9/QS\n\t\t\t\t\t\t3GDvDJRaIEpZBXdnnj1/mBtXUc3kz8bATlKK2iOyl+M4YtwxoHzDyFhlsu+h4A2Y\n\t\t\t\t\t\tLOl3ippTtSql++pgoRAITDLuALIgF/BSzWV/wv1l11AzPauPONJTPWH8uBZ8e85H\n\t\t\t\t\t\tkcgm2+psZwP3NYGrgzWmR2OKFZg/4buis+S1LDTX66zuwaMnCwnK7y6jcgQ8piB0\n\t\t\t\t\t\tY5ypSZCq4fOUc7vNiYmA/EJVq5c6//cyfo4OHUxMgOStHwIDAQABo3sweTAJBgNV\n\t\t\t\t\t\tHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZp\n\t\t\t\t\t\tY2F0ZTAdBgNVHQ4EFgQUhvOVaHPTsggHRCxEXm6G8hfJbVswHwYDVR0jBBgwFoAU\n\t\t\t\t\t\thvOVaHPTsggHRCxEXm6G8hfJbVswDQYJKoZIhvcNAQEFBQADggEBALIGgkvNn9fX\n\t\t\t\t\t\tHlxH5CiHKVOSwEHE7MlnkJLOemlMv/n4jjWJyKOQ1XR6nZ7Q9UQl0v5cHZKJMMYq\n\t\t\t\t\t\tchJebSDsho3kb9LkibDEAO6b2b8ZUGMf0F/6hqETy5Qj/w9YFRHqsIHkDMbCZAKd\n\t\t\t\t\t\t8fm5chrfV2op269TzIrs0LLiCqGE7Jak0ZafxxHUofxQb2d31OdT5xga47ReJI1n\n\t\t\t\t\t\tCwTAsqXJlK6Zt6T5x29G94U0l5jgYlIrkbGI5ybdfCmOI7NIk+N6uadQ0CLx4sbH\n\t\t\t\t\t\tTGHu0K6ZOPVhjPVgBOVGFbmVDx9WrGCSliwiYBc8hzurYDhZFH323wiUja7yrCUs\n\t\t\t\t\t\tzGCgMnWgl18="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "kcollege.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibboleth.kcollege.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.kcollege.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shibboleth.kcollege.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.kcollege.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shibboleth.kcollege.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.kcollege.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibboleth.kcollege.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.kcollege.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "kcollege.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEVDCCAzygAwIBAgIJAIt8JpQ7ds27MA0GCSqGSIb3DQEBBQUAMIGqMQswCQYD\n\t\t\t\t\t\tVQQGEwJHQjENMAsGA1UECBMES2VudDESMBAGA1UEBxMJVG9uYnJpZGdlMRIwEAYD\n\t\t\t\t\t\tVQQKEwlLIENvbGxlZ2UxFjAUBgNVBAsTDUlUIERlcGFydG1lbnQxIjAgBgNVBAMT\n\t\t\t\t\t\tGXNoaWJib2xldGgua2NvbGxlZ2UuYWMudWsxKDAmBgkqhkiG9w0BCQEWGWl0c2Vy\n\t\t\t\t\t\tdmljZXNAa2NvbGxlZ2UuYWMudWswHhcNMTQwMjEyMDk1MDA5WhcNMjQwMjEwMDk1\n\t\t\t\t\t\tMDA5WjCBqjELMAkGA1UEBhMCR0IxDTALBgNVBAgTBEtlbnQxEjAQBgNVBAcTCVRv\n\t\t\t\t\t\tbmJyaWRnZTESMBAGA1UEChMJSyBDb2xsZWdlMRYwFAYDVQQLEw1JVCBEZXBhcnRt\n\t\t\t\t\t\tZW50MSIwIAYDVQQDExlzaGliYm9sZXRoLmtjb2xsZWdlLmFjLnVrMSgwJgYJKoZI\n\t\t\t\t\t\thvcNAQkBFhlpdHNlcnZpY2VzQGtjb2xsZWdlLmFjLnVrMIIBIjANBgkqhkiG9w0B\n\t\t\t\t\t\tAQEFAAOCAQ8AMIIBCgKCAQEAyUONnw9FNuYKcET6VNifgEdvZOAOZXlyJTOmS+dR\n\t\t\t\t\t\ttEhyW8TBc5gFjyPyc12Odj3qelGj/IwN0UuvN9XSZwVXVfTfxShmAxfA4jGp9/QS\n\t\t\t\t\t\t3GDvDJRaIEpZBXdnnj1/mBtXUc3kz8bATlKK2iOyl+M4YtwxoHzDyFhlsu+h4A2Y\n\t\t\t\t\t\tLOl3ippTtSql++pgoRAITDLuALIgF/BSzWV/wv1l11AzPauPONJTPWH8uBZ8e85H\n\t\t\t\t\t\tkcgm2+psZwP3NYGrgzWmR2OKFZg/4buis+S1LDTX66zuwaMnCwnK7y6jcgQ8piB0\n\t\t\t\t\t\tY5ypSZCq4fOUc7vNiYmA/EJVq5c6//cyfo4OHUxMgOStHwIDAQABo3sweTAJBgNV\n\t\t\t\t\t\tHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZp\n\t\t\t\t\t\tY2F0ZTAdBgNVHQ4EFgQUhvOVaHPTsggHRCxEXm6G8hfJbVswHwYDVR0jBBgwFoAU\n\t\t\t\t\t\thvOVaHPTsggHRCxEXm6G8hfJbVswDQYJKoZIhvcNAQEFBQADggEBALIGgkvNn9fX\n\t\t\t\t\t\tHlxH5CiHKVOSwEHE7MlnkJLOemlMv/n4jjWJyKOQ1XR6nZ7Q9UQl0v5cHZKJMMYq\n\t\t\t\t\t\tchJebSDsho3kb9LkibDEAO6b2b8ZUGMf0F/6hqETy5Qj/w9YFRHqsIHkDMbCZAKd\n\t\t\t\t\t\t8fm5chrfV2op269TzIrs0LLiCqGE7Jak0ZafxxHUofxQb2d31OdT5xga47ReJI1n\n\t\t\t\t\t\tCwTAsqXJlK6Zt6T5x29G94U0l5jgYlIrkbGI5ybdfCmOI7NIk+N6uadQ0CLx4sbH\n\t\t\t\t\t\tTGHu0K6ZOPVhjPVgBOVGFbmVDx9WrGCSliwiYBc8hzurYDhZFH323wiUja7yrCUs\n\t\t\t\t\t\tzGCgMnWgl18="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "K College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.kcollege.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "South and West Kent College"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "urn:urkund:shibboleth:sp",
    {
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/eu-adequate-protection"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/research-and-scholarship"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Witasp"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:peter.witasp@prioinfo.se"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Peter"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Otter"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:samuel@onposition.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Samuel"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "urn:urkund:shibboleth:sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://secure.urkund.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://secure.urkund.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://secure.urkund.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://secure.urkund.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "URKUND"
                }
              ],
              "requested_attribute": [
                {
                  "friendly_name": "displayName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.16.840.1.113730.3.1.241",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "mail",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonScopedAffiliation",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://secure.urkund.com/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "information_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.urkund.com/se/om-urkund"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.urkund.com/en/about-urkund"
                  }
                ],
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "URKUND is an online plagiarism checker service reserved for teachers"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "URKUND is an online plagiarism checker service reserved for teachers"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://static.urkund.com/documents/URKUND_SP_privacy.pdf"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "URKUND"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "URKUND"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "urkundweb.urkund.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDADCCAeigAwIBAgIJAL61GoCfz8heMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3Vya3VuZHdlYi51cmt1bmQuc2UwHhcNMDkwMzAzMTU1NjQyWhcNMTkwMzAx\nMTU1NjQyWjAeMRwwGgYDVQQDExN1cmt1bmR3ZWIudXJrdW5kLnNlMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3RwMFJu304/B3qtfLT8r2vKBOugNcfyZ\nEDsf4Q4ZHFDFhWOh6VAuywjpixKBm/LYCrRyKqnM2hRVWKIIKpTvlu7TD1Se/G/g\nm6VxdXi02oc+7d6Q18SXmqHjFCaxh73HiEqwarofgRKXrVWupruUv/5//nIXeNWC\nu9GuFWYEug5Vj0lw7SoVZC3B0fsbVjQGHEpl4ybc6aCAleuyndWbaa+HXEmSr/d6\nsVjSu2F1d/OCPoeZ9U3Q5lLzLwpV67oXY1dLzwSLu17KiP6bzyqsopHAaac34rZ1\nIa5m722Sdv55LA2JXX0k/D9QXduyLVnmzEhAvzyiyUKo9hMAhFwjrwIDAQABo0Ew\nPzAeBgNVHREEFzAVghN1cmt1bmR3ZWIudXJrdW5kLnNlMB0GA1UdDgQWBBTWCFlV\niTs20fc8BncRSVYrqXdS8jANBgkqhkiG9w0BAQUFAAOCAQEAQnPM81umUT9cokgv\nd7qjClP5S4ufKMgscVIu5umiV3aOSpDTsCAxvfSp3z5tywF1EQ/6FRrTSVIZiS+e\nwbR9+JEVOnxV3D81Xv4p23zj0p1g2d6gdlpfbOmGiCWqx75QosHqfP6ENFDFCwxl\nCasucZK1gv2h3Sat232poJYdoDcmDKZt7DRIcs88k+85/TG3CnB6LUWjv35NrMGq\nYcF3FDUEnWCpXVoOF3bB84M9zlrggkBlhid47DpJZ54EcMl8qrMQmOJDcw4/1Jc1\nidGXqKfeI6/eA5cV6Kvyy63eSji0hOvD1CKIhufI3w6R1+DU0pSVsv+t7ND9KWBl\ngEln3A=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=urkundweb.urkund.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "urkundweb.urkund.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDADCCAeigAwIBAgIJAL61GoCfz8heMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3Vya3VuZHdlYi51cmt1bmQuc2UwHhcNMDkwMzAzMTU1NjQyWhcNMTkwMzAx\nMTU1NjQyWjAeMRwwGgYDVQQDExN1cmt1bmR3ZWIudXJrdW5kLnNlMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3RwMFJu304/B3qtfLT8r2vKBOugNcfyZ\nEDsf4Q4ZHFDFhWOh6VAuywjpixKBm/LYCrRyKqnM2hRVWKIIKpTvlu7TD1Se/G/g\nm6VxdXi02oc+7d6Q18SXmqHjFCaxh73HiEqwarofgRKXrVWupruUv/5//nIXeNWC\nu9GuFWYEug5Vj0lw7SoVZC3B0fsbVjQGHEpl4ybc6aCAleuyndWbaa+HXEmSr/d6\nsVjSu2F1d/OCPoeZ9U3Q5lLzLwpV67oXY1dLzwSLu17KiP6bzyqsopHAaac34rZ1\nIa5m722Sdv55LA2JXX0k/D9QXduyLVnmzEhAvzyiyUKo9hMAhFwjrwIDAQABo0Ew\nPzAeBgNVHREEFzAVghN1cmt1bmR3ZWIudXJrdW5kLnNlMB0GA1UdDgQWBBTWCFlV\niTs20fc8BncRSVYrqXdS8jANBgkqhkiG9w0BAQUFAAOCAQEAQnPM81umUT9cokgv\nd7qjClP5S4ufKMgscVIu5umiV3aOSpDTsCAxvfSp3z5tywF1EQ/6FRrTSVIZiS+e\nwbR9+JEVOnxV3D81Xv4p23zj0p1g2d6gdlpfbOmGiCWqx75QosHqfP6ENFDFCwxl\nCasucZK1gv2h3Sat232poJYdoDcmDKZt7DRIcs88k+85/TG3CnB6LUWjv35NrMGq\nYcF3FDUEnWCpXVoOF3bB84M9zlrggkBlhid47DpJZ54EcMl8qrMQmOJDcw4/1Jc1\nidGXqKfeI6/eA5cV6Kvyy63eSji0hOvD1CKIhufI3w6R1+DU0pSVsv+t7ND9KWBl\ngEln3A=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=urkundweb.urkund.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://secure.urkund.com/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://secure.urkund.com/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://secure.urkund.com/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://secure.urkund.com/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://secure.urkund.com/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://secure.urkund.com/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://secure.urkund.com/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://secure.urkund.com/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://secure.urkund.com/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://portalservices.miun.se/shibboleth",
    {
      "entity_id": "https://portalservices.miun.se/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://portalservices.miun.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "rosalind.miun.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9zCCAd+gAwIBAgIJAIIQvcjXtAm5MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHJvc2FsaW5kLm1pdW4uc2UwHhcNMTMwNTI5MjIyOTMzWhcNMjMwNTI3MjIy\nOTMzWjAbMRkwFwYDVQQDExByb3NhbGluZC5taXVuLnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAnT/D8qoQnoI3I8898z/vg4a/LlQfYv/DkRIAqbxZ\n8JuXcBHCflsTlUas/2pTtNY+FJwRLF4IKLJojaOF5vsg3Xcd7Y8jrC4EMvUfkoVK\n5cTx/uz6Xf4ejmAMDDmYHvWqyIRfERVvSARwTjpRX4Gt94so2n6vdJErP0Rl61Ho\nI3nJwSlcRP5Wn1Y3l/uw1r/ZhUUv6yGgWVWXmV+6qlH3rq3nULNrzohHbuODr6rR\nAUOik1SaiERnx5koy7/CF12MwDdQAYp1+YFL2xT6+vcF3FwhDppL7lkoFrd0ihNI\nX/hdkecVrpnj5ykle7g7xABsJEOTfPiGBOefkR0y2AXtpQIDAQABoz4wPDAbBgNV\nHREEFDASghByb3NhbGluZC5taXVuLnNlMB0GA1UdDgQWBBQ3oI6Zshdu4dz7v2+6\nxa5Rvh8KBTANBgkqhkiG9w0BAQUFAAOCAQEAikkMrClX/tjmENc+SIAgnKjYS8Z8\nmdEJGtRZr47tcc/Qb84gfslLvfa6bJuzzWeVvoXj1+92m8tcM32s45yUiCmmL9Oq\nqJxdaTqatW5za2RdaI2Kr0pIO0z2UUfbYd5i5wyLKsp85VMk3RlKsEnyaq8RaYK8\n6qz4HKXoYiX7gqwlrVRDOZr0vvNhe8vcCYihxnLEv5WolJzM4wqz0CoKKO/ZwrW3\nXEJzWYfbXhiq0WDNbmFY7WWKlfTjKwD3088PGcA8/AdosEB66Xs0K3PTVyJWcB3r\nTeyoCQ24KR1X/NqeCJndNrh9MFFO1D14hF64NWpRKRybaB2lzrgIiIWvlw=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=rosalind.miun.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "rosalind.miun.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9zCCAd+gAwIBAgIJAIIQvcjXtAm5MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHJvc2FsaW5kLm1pdW4uc2UwHhcNMTMwNTI5MjIyOTMzWhcNMjMwNTI3MjIy\nOTMzWjAbMRkwFwYDVQQDExByb3NhbGluZC5taXVuLnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAnT/D8qoQnoI3I8898z/vg4a/LlQfYv/DkRIAqbxZ\n8JuXcBHCflsTlUas/2pTtNY+FJwRLF4IKLJojaOF5vsg3Xcd7Y8jrC4EMvUfkoVK\n5cTx/uz6Xf4ejmAMDDmYHvWqyIRfERVvSARwTjpRX4Gt94so2n6vdJErP0Rl61Ho\nI3nJwSlcRP5Wn1Y3l/uw1r/ZhUUv6yGgWVWXmV+6qlH3rq3nULNrzohHbuODr6rR\nAUOik1SaiERnx5koy7/CF12MwDdQAYp1+YFL2xT6+vcF3FwhDppL7lkoFrd0ihNI\nX/hdkecVrpnj5ykle7g7xABsJEOTfPiGBOefkR0y2AXtpQIDAQABoz4wPDAbBgNV\nHREEFDASghByb3NhbGluZC5taXVuLnNlMB0GA1UdDgQWBBQ3oI6Zshdu4dz7v2+6\nxa5Rvh8KBTANBgkqhkiG9w0BAQUFAAOCAQEAikkMrClX/tjmENc+SIAgnKjYS8Z8\nmdEJGtRZr47tcc/Qb84gfslLvfa6bJuzzWeVvoXj1+92m8tcM32s45yUiCmmL9Oq\nqJxdaTqatW5za2RdaI2Kr0pIO0z2UUfbYd5i5wyLKsp85VMk3RlKsEnyaq8RaYK8\n6qz4HKXoYiX7gqwlrVRDOZr0vvNhe8vcCYihxnLEv5WolJzM4wqz0CoKKO/ZwrW3\nXEJzWYfbXhiq0WDNbmFY7WWKlfTjKwD3088PGcA8/AdosEB66Xs0K3PTVyJWcB3r\nTeyoCQ24KR1X/NqeCJndNrh9MFFO1D14hF64NWpRKRybaB2lzrgIiIWvlw=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=rosalind.miun.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://portalservices.miun.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://portalservices.miun.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://portalservices.miun.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://portalservices.miun.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://portalservices.miun.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://idp1.utpa.edu/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "zecca@utpa.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Frank Zecca"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "jnunez@utpa.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Jaime Nunez"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "helpdesk@utpa.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "IT Helpdesk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp1.utpa.edu/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.utpa.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.utpa.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHzCCAgegAwIBAgIUdKkzW01lvdyal9wyJMIhLH5ZWwQwDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNaWRwMS51dHBhLmVkdTAeFw0xMDA3MjEyMTI1MTlaFw0z\nMDA3MjEyMTI1MTlaMBgxFjAUBgNVBAMTDWlkcDEudXRwYS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCNr/xhq+UAztUMJytS7SVqGJx2gaxW0xNU\nOfT5OPFA12tLUPYXnf3WA/fHv8WD3jgPNgGSQPgYX0WZaOYr19o6/+iQtuLCPaXD\nLuDBjY3TmflArRS7uRzUy5nl98QJcIhlssp60sDWhz/uPI8BCnKLvo35KisJ+aLH\nYGB1tzenVmR6kjuZA1VNC3lmsPjTBqAc8yPm7w9jk+ZmHbmW5fDWetnMmxpHzjQf\nUlP55ddm30sxZxAGC9/N253RVKuPy8NvYuVzvCYk86AS2mVmvneJ1S2KT77GCAmr\nx1ags31zP4B/VJIsWQ9znlfAgpcrVVt1jcYFd0EVBiIoBmK6DkFPAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWlkcDEudXRwYS5lZHWGJGh0dHBzOi8vaWRwMS51dHBhLmVk\ndS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQURat8zqRPL/gEEcB95AU0ZGwRBu0w\nDQYJKoZIhvcNAQEFBQADggEBAIP6l5tAs2w6Otty6UaPb1MghRRx/75GLW7lYmvV\n1W/Yfz6cNuhqwimY3p84NvHbwFnQFFlVIrzImDoYPuLoQwrUAahDZGsdgMZ51apV\nLsI6TJr7WmTxJEGZSQq7iRC6Kf+XyV7/Qa/1wPR0iy90O0/4yNkzlQIoRoIPUK7+\nMMxVRpFaUpwJwIpNA3WID0JTeDaJ2YT9OFLgUeS/N0B2lIp5ClPktl71LJkwpv4C\noie3XK/NlMnqzjcF/dvCwDhsSHE1a6eSOJTHeP8y49js+sV4i4wcl0Inbf+8+EOh\nDzZqtIw6JsdQP1xYSJp98NUDw6qHGVfuUGUNLW1KeKmwsio="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "utpa.edu"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp1.utpa.edu/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp1.utpa.edu/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp1.utpa.edu/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp1.utpa.edu/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.utpa.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.utpa.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "utpa.edu"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.utpa.edu/dit"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://www.utpa.edu/policies/privacy"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of Texas-Pan American"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHzCCAgegAwIBAgIUdKkzW01lvdyal9wyJMIhLH5ZWwQwDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNaWRwMS51dHBhLmVkdTAeFw0xMDA3MjEyMTI1MTlaFw0z\nMDA3MjEyMTI1MTlaMBgxFjAUBgNVBAMTDWlkcDEudXRwYS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCNr/xhq+UAztUMJytS7SVqGJx2gaxW0xNU\nOfT5OPFA12tLUPYXnf3WA/fHv8WD3jgPNgGSQPgYX0WZaOYr19o6/+iQtuLCPaXD\nLuDBjY3TmflArRS7uRzUy5nl98QJcIhlssp60sDWhz/uPI8BCnKLvo35KisJ+aLH\nYGB1tzenVmR6kjuZA1VNC3lmsPjTBqAc8yPm7w9jk+ZmHbmW5fDWetnMmxpHzjQf\nUlP55ddm30sxZxAGC9/N253RVKuPy8NvYuVzvCYk86AS2mVmvneJ1S2KT77GCAmr\nx1ags31zP4B/VJIsWQ9znlfAgpcrVVt1jcYFd0EVBiIoBmK6DkFPAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWlkcDEudXRwYS5lZHWGJGh0dHBzOi8vaWRwMS51dHBhLmVk\ndS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQURat8zqRPL/gEEcB95AU0ZGwRBu0w\nDQYJKoZIhvcNAQEFBQADggEBAIP6l5tAs2w6Otty6UaPb1MghRRx/75GLW7lYmvV\n1W/Yfz6cNuhqwimY3p84NvHbwFnQFFlVIrzImDoYPuLoQwrUAahDZGsdgMZ51apV\nLsI6TJr7WmTxJEGZSQq7iRC6Kf+XyV7/Qa/1wPR0iy90O0/4yNkzlQIoRoIPUK7+\nMMxVRpFaUpwJwIpNA3WID0JTeDaJ2YT9OFLgUeS/N0B2lIp5ClPktl71LJkwpv4C\noie3XK/NlMnqzjcF/dvCwDhsSHE1a6eSOJTHeP8y49js+sV4i4wcl0Inbf+8+EOh\nDzZqtIw6JsdQP1xYSJp98NUDw6qHGVfuUGUNLW1KeKmwsio="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Texas-Pan American"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.utpa.edu/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Texas-Pan American"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://birk.wayf.dk/birk.php/wayf.aau.dk",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Operations"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "operations@wayf.dk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "WAYF"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://birk.wayf.dk/birk.php/wayf.aau.dk",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://wayf.dk/images/stories/WAYF-filer/metadataregistrationpracticestatementwayf.pdf"
              }
            ],
            "registration_instant": "2010-12-06T14:25:53Z",
            "registration_authority": "https://www.wayf.dk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://birk.wayf.dk/birk.php/wayf.aau.dk/simplesaml/saml2/idp/SSOService.php",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "aau.dk"
              },
              {
                "description": [
                  {
                    "lang": "da",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Aalborg Universitet"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Aalborg University"
                  }
                ],
                "display_name": [
                  {
                    "lang": "da",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Aalborg Universitet"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Aalborg University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "domain_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint",
                    "text": "aau.dk"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIICsDCCAZgCAQcwDQYJKoZIhvcNAQELBQAwHjEcMBoGA1UEAwwTaHR0cHM6Ly93\nYXlmLmFhdS5kazAeFw0xNTAxMDEwMDAwMDBaFw0yNTEyMzEyMzU5NTlaMB4xHDAa\nBgNVBAMME2h0dHBzOi8vd2F5Zi5hYXUuZGswggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQDHiAwKahBTuI4Z+IJ1rgOeEiCCy3bR9QIe3BpCsejFCU5rSzkW\nANqVuc1PDfp0JdIZhrPXsmDJQMmidPCGPIDQKo+bk+af3+EUFS/I/+35sSBX2vf+\nh1DHvZV9jsznmpSVjp7HZ/WoPWBykWBJO0AOVmzB5zlaqkS36J76+wxerwdpuExV\nnYSNd73S+AyT/EZ+tXAO+6lQ8FL/YMlJnUkSaSqLSHFy01D2qBNmYRwBpCS6/dUZ\nyxi0t5j8ghKUD4BHOZVavn65J62cJdXiOcMRyUAIp57GXQrL63KtrjIcXddq+CZy\nZ5t37EdUOIz42joFcy73MFOntynlKEvOw1BJAgMBAAEwDQYJKoZIhvcNAQELBQAD\nggEBAEurW2Zf6aCXWNDIV04ht39P4MlhI8ut1QL0TPoAjUKlTk9ybvxQcN1XkOVQ\nZYXsyhHWjWhmpBpZS7KaAbJzhBUCMpwAdsDOxLsF7+VZo3BPVGnH2lKSHPCDCGex\n++rithjuctIdtKqlK5/82/xb7/eftgZycF+slf3cFosOAAYb3oprtWVEx0KUmEq8\nB2TSJQMdX/r6TW7h69X94MOXA8ad4Ukgo0rnhZhbcUtURQeI51RFtfVGWu1g9ZDd\nx/eM6He+xeVltiNDy7VLsdrvA4KVYDZpR5ZOzDL6pE5u+yb3Wg8rgUOoZUcPVB47\nYNCobCjLM8GtgKPZGSBhP+avu6w="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "da",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Aalborg Universitet"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Aalborg University"
          }
        ],
        "organization_url": [
          {
            "lang": "da",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.aau.dk"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.en.aau.dk"
          }
        ],
        "organization_name": [
          {
            "lang": "da",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Aalborg Universitet"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Aalborg University"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://www.uusuvote.com/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:support@ukmsl.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "MSL support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bonsall"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:james.bonsall@ukmsl.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "James"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://www.uusuvote.com/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2014-10-17T09:15:38Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Ulster SU Voting"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uusuvote.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Membership Solutions Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.uusuvote.com/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://www.uusuvote.com/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9zCCAd+gAwIBAgIJAN0Uxjm5stWsMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\n\t\t\t\t\t\tBAMTEHllbGxvdy51a21zbC5uZXQwHhcNMTEwODI1MTEwMDIxWhcNMjEwODIyMTEw\n\t\t\t\t\t\tMDIxWjAbMRkwFwYDVQQDExB5ZWxsb3cudWttc2wubmV0MIIBIjANBgkqhkiG9w0B\n\t\t\t\t\t\tAQEFAAOCAQ8AMIIBCgKCAQEAtFMa6Gs4goG8AQMCG6E/ESnBnRXVA6U4twXZwojK\n\t\t\t\t\t\t6WTD6USmloihRaZ6v27J54vEIkIxkZuGfN6LW0e93gLFCyM+LHu7UdOBLmOANek0\n\t\t\t\t\t\thx1eN/x5FIa/+hB2mTkw2OFvNAvb7fYvVkEY/XrRFJHxgkjTgYndptXTfxhRAyhI\n\t\t\t\t\t\tMrXYHedowBnTSX5J5/tV5eyi/pnNYrqe9IUWqVfREe8nSqLGmjMqU4ge5B+OTLUh\n\t\t\t\t\t\taNyQTMstDSVFaZTy5wBNStWpLeJF0faXwdiX1oAJiMD2aM/djw9CeCkBx/UEMIjn\n\t\t\t\t\t\tIpu6ZDrsF7afIMdzaZqBtS71lRcgTRAXq9f07LIUI1CatwIDAQABoz4wPDAbBgNV\n\t\t\t\t\t\tHREEFDASghB5ZWxsb3cudWttc2wubmV0MB0GA1UdDgQWBBSYe9hob4wACE6/WbTT\n\t\t\t\t\t\tdaFXvasZxjANBgkqhkiG9w0BAQUFAAOCAQEAU5RF7k0a0SVdgUivXdgpJI549su7\n\t\t\t\t\t\tFGECVI177+zyWl9+TMNRIiIyvvfbZ2zoUVcXxLqTcDL7akaQ51u9v9u2QaJHx0Ex\n\t\t\t\t\t\twbjfuCVXmIghq/2Cuo1Tt48mEEwD9Jnqdtl37Ajqchd6CpmIh1Gr7k7zMQ6zARrv\n\t\t\t\t\t\t4lARD/ryWB8WoK7gy0LlV/AQaLukAudxHmtqqnabu546xoETvY0r9b/wug7D4uzs\n\t\t\t\t\t\trcyOEnW1CT29ftdLvhclQAr3NM5Vwd/a6r67Ng9yU77qlZmacQ9OV4tllf5Nd0gH\n\t\t\t\t\t\teWVjyrg/8qUvf9xyC0AokyN5upRH2FYmdGs2vtnL4cA+Vum/TRGgdvyEFA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9zCCAd+gAwIBAgIJAN0Uxjm5stWsMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\n\t\t\t\t\t\tBAMTEHllbGxvdy51a21zbC5uZXQwHhcNMTEwODI1MTEwMDIxWhcNMjEwODIyMTEw\n\t\t\t\t\t\tMDIxWjAbMRkwFwYDVQQDExB5ZWxsb3cudWttc2wubmV0MIIBIjANBgkqhkiG9w0B\n\t\t\t\t\t\tAQEFAAOCAQ8AMIIBCgKCAQEAtFMa6Gs4goG8AQMCG6E/ESnBnRXVA6U4twXZwojK\n\t\t\t\t\t\t6WTD6USmloihRaZ6v27J54vEIkIxkZuGfN6LW0e93gLFCyM+LHu7UdOBLmOANek0\n\t\t\t\t\t\thx1eN/x5FIa/+hB2mTkw2OFvNAvb7fYvVkEY/XrRFJHxgkjTgYndptXTfxhRAyhI\n\t\t\t\t\t\tMrXYHedowBnTSX5J5/tV5eyi/pnNYrqe9IUWqVfREe8nSqLGmjMqU4ge5B+OTLUh\n\t\t\t\t\t\taNyQTMstDSVFaZTy5wBNStWpLeJF0faXwdiX1oAJiMD2aM/djw9CeCkBx/UEMIjn\n\t\t\t\t\t\tIpu6ZDrsF7afIMdzaZqBtS71lRcgTRAXq9f07LIUI1CatwIDAQABoz4wPDAbBgNV\n\t\t\t\t\t\tHREEFDASghB5ZWxsb3cudWttc2wubmV0MB0GA1UdDgQWBBSYe9hob4wACE6/WbTT\n\t\t\t\t\t\tdaFXvasZxjANBgkqhkiG9w0BAQUFAAOCAQEAU5RF7k0a0SVdgUivXdgpJI549su7\n\t\t\t\t\t\tFGECVI177+zyWl9+TMNRIiIyvvfbZ2zoUVcXxLqTcDL7akaQ51u9v9u2QaJHx0Ex\n\t\t\t\t\t\twbjfuCVXmIghq/2Cuo1Tt48mEEwD9Jnqdtl37Ajqchd6CpmIh1Gr7k7zMQ6zARrv\n\t\t\t\t\t\t4lARD/ryWB8WoK7gy0LlV/AQaLukAudxHmtqqnabu546xoETvY0r9b/wug7D4uzs\n\t\t\t\t\t\trcyOEnW1CT29ftdLvhclQAr3NM5Vwd/a6r67Ng9yU77qlZmacQ9OV4tllf5Nd0gH\n\t\t\t\t\t\teWVjyrg/8qUvf9xyC0AokyN5upRH2FYmdGs2vtnL4cA+Vum/TRGgdvyEFA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.uusuvote.com/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.uusuvote.com/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.uusuvote.com/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.uusuvote.com/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://www.uusuvote.com/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "11"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://idp.arts.ac.uk/entity",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:servicedesk@arts.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "UAL Service desk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:shib-support@arts.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Technical Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.arts.ac.uk/entity",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID5DCCAswCCQD996epTPDENDANBgkqhkiG9w0BAQUFADCBszELMAkGA1UEBhMC\n\t\t\t\t\t\tR0IxFzAVBgNVBAgMDkdyZWF0ZXIgTG9uZG9uMQ8wDQYDVQQHDAZMb25kb24xJzAl\n\t\t\t\t\t\tBgNVBAoMHlVuaXZlcnNpdHkgb2YgdGhlIEFydHMsIExvbmRvbjEUMBIGA1UECwwL\n\t\t\t\t\t\tSVQgU2VydmljZXMxFzAVBgNVBAMMDmlkcC5hcnRzLmFjLnVrMSIwIAYJKoZIhvcN\n\t\t\t\t\t\tAQkBFhNzc2xhZG1pbkBhcnRzLmFjLnVrMB4XDTE0MDEwODExMjAzMVoXDTM0MDEy\n\t\t\t\t\t\tMzExMjAzMVowgbMxCzAJBgNVBAYTAkdCMRcwFQYDVQQIDA5HcmVhdGVyIExvbmRv\n\t\t\t\t\t\tbjEPMA0GA1UEBwwGTG9uZG9uMScwJQYDVQQKDB5Vbml2ZXJzaXR5IG9mIHRoZSBB\n\t\t\t\t\t\tcnRzLCBMb25kb24xFDASBgNVBAsMC0lUIFNlcnZpY2VzMRcwFQYDVQQDDA5pZHAu\n\t\t\t\t\t\tYXJ0cy5hYy51azEiMCAGCSqGSIb3DQEJARYTc3NsYWRtaW5AYXJ0cy5hYy51azCC\n\t\t\t\t\t\tASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM6O2rZ7nuoylsc2Zd9Mahbc\n\t\t\t\t\t\tyvGGqZMmx+mO414AqbuMn4R0kat5rKpuaq2kj/M18NBJaNti2UzYBvfEx+SPOZDl\n\t\t\t\t\t\tzCFAup8NqJwZXGPP5NGNXeAFQWCzIfDZpcOqrrjDA5/dJtDpIST4kGLaFUUwfmE3\n\t\t\t\t\t\t6Ikpye28h3v4oYPH4bxGkodWsVkU2AMAObbsFu2C5FxRP9jXE42q7AjRyZNOM5jt\n\t\t\t\t\t\tizy1jjFEhdsU1gYJyaN/XEpMZA2x1h+t+DcCEqlp9+BFn24t2krubxfXo6fy/zqH\n\t\t\t\t\t\ttUPPMHElAALmzFZyhz4BMtfxGmuYu5+5nROjz7wh0QANgo5s2chALSVBhN1coMsC\n\t\t\t\t\t\tAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAvL41pZYkDiD0qBQK+ndeXOsBSQbHXLEl\n\t\t\t\t\t\tWwQttoLoo23kRPU+Q1guFwk2pIgKb6SDSSflwrT+SjeCAmNOnBE5+J2fXqynj/CW\n\t\t\t\t\t\tup2U9ejHg5ZEn4GPwLOftqycM/2tOzxjY/6/5NbM+BEZs+T15XqhsBQacPMg2PSJ\n\t\t\t\t\t\ti+e8IPQeKWZlpBRf4NMghdfb7+vfTpDqOFB4kik+VesdEBE/zgGSTdcUNaAB1Hqq\n\t\t\t\t\t\t+QSJKGU5LkUlhzDceN+QA/RuIuTUF0VSi283LNzyyp2q9ya+mv7UYVaGJs7AYuNR\n\t\t\t\t\t\tmUNMMO4EcXmyJkn6gSTesu0OCj76227/ss3Ni3p+nehxcBY9R/olXg=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "arts.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.arts.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.arts.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.arts.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.arts.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.arts.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.arts.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.arts.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.arts.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "arts.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID5DCCAswCCQD996epTPDENDANBgkqhkiG9w0BAQUFADCBszELMAkGA1UEBhMC\n\t\t\t\t\t\tR0IxFzAVBgNVBAgMDkdyZWF0ZXIgTG9uZG9uMQ8wDQYDVQQHDAZMb25kb24xJzAl\n\t\t\t\t\t\tBgNVBAoMHlVuaXZlcnNpdHkgb2YgdGhlIEFydHMsIExvbmRvbjEUMBIGA1UECwwL\n\t\t\t\t\t\tSVQgU2VydmljZXMxFzAVBgNVBAMMDmlkcC5hcnRzLmFjLnVrMSIwIAYJKoZIhvcN\n\t\t\t\t\t\tAQkBFhNzc2xhZG1pbkBhcnRzLmFjLnVrMB4XDTE0MDEwODExMjAzMVoXDTM0MDEy\n\t\t\t\t\t\tMzExMjAzMVowgbMxCzAJBgNVBAYTAkdCMRcwFQYDVQQIDA5HcmVhdGVyIExvbmRv\n\t\t\t\t\t\tbjEPMA0GA1UEBwwGTG9uZG9uMScwJQYDVQQKDB5Vbml2ZXJzaXR5IG9mIHRoZSBB\n\t\t\t\t\t\tcnRzLCBMb25kb24xFDASBgNVBAsMC0lUIFNlcnZpY2VzMRcwFQYDVQQDDA5pZHAu\n\t\t\t\t\t\tYXJ0cy5hYy51azEiMCAGCSqGSIb3DQEJARYTc3NsYWRtaW5AYXJ0cy5hYy51azCC\n\t\t\t\t\t\tASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM6O2rZ7nuoylsc2Zd9Mahbc\n\t\t\t\t\t\tyvGGqZMmx+mO414AqbuMn4R0kat5rKpuaq2kj/M18NBJaNti2UzYBvfEx+SPOZDl\n\t\t\t\t\t\tzCFAup8NqJwZXGPP5NGNXeAFQWCzIfDZpcOqrrjDA5/dJtDpIST4kGLaFUUwfmE3\n\t\t\t\t\t\t6Ikpye28h3v4oYPH4bxGkodWsVkU2AMAObbsFu2C5FxRP9jXE42q7AjRyZNOM5jt\n\t\t\t\t\t\tizy1jjFEhdsU1gYJyaN/XEpMZA2x1h+t+DcCEqlp9+BFn24t2krubxfXo6fy/zqH\n\t\t\t\t\t\ttUPPMHElAALmzFZyhz4BMtfxGmuYu5+5nROjz7wh0QANgo5s2chALSVBhN1coMsC\n\t\t\t\t\t\tAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAvL41pZYkDiD0qBQK+ndeXOsBSQbHXLEl\n\t\t\t\t\t\tWwQttoLoo23kRPU+Q1guFwk2pIgKb6SDSSflwrT+SjeCAmNOnBE5+J2fXqynj/CW\n\t\t\t\t\t\tup2U9ejHg5ZEn4GPwLOftqycM/2tOzxjY/6/5NbM+BEZs+T15XqhsBQacPMg2PSJ\n\t\t\t\t\t\ti+e8IPQeKWZlpBRf4NMghdfb7+vfTpDqOFB4kik+VesdEBE/zgGSTdcUNaAB1Hqq\n\t\t\t\t\t\t+QSJKGU5LkUlhzDceN+QA/RuIuTUF0VSi283LNzyyp2q9ya+mv7UYVaGJs7AYuNR\n\t\t\t\t\t\tmUNMMO4EcXmyJkn6gSTesu0OCj76227/ss3Ni3p+nehxcBY9R/olXg=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of the Arts London"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.arts.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of the Arts London"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://shibboleth.bbaw.de/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Zimmer"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:zimmer@bbaw.de"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Kai"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Krauth"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:krauth@bbaw.de"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dr. Wolf-Hagen"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Zimmer"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:zimmer@bbaw.de"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Kai"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibboleth.bbaw.de/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.aai.dfn.de/en/join/"
              },
              {
                "lang": "de",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.aai.dfn.de/teilnahme/"
              }
            ],
            "registration_instant": "2015-03-13T16:23:00Z",
            "registration_authority": "https://www.aai.dfn.de",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/research-and-scholarship"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://clarin.eu/category/clarin-member"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "de",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Berlin-Brandenburgische Akademie der Wissenschaften"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Berlin-Brandenburgische Akademie der Wissenschaften"
          }
        ],
        "organization_url": [
          {
            "lang": "de",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.bbaw.de"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.bbaw.de"
          }
        ],
        "organization_name": [
          {
            "lang": "de",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "e209"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "e209"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "de",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "BBAW - CLARIN Dienste"
                },
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "BBAW - CLARIN services"
                }
              ],
              "service_description": [
                {
                  "lang": "de",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Verschiedene Dienste der Berlin-Brandenburgischen Akademie der Wissenschaften (BBAW) im Rahmen der CLARIN-Initiative."
                },
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Various services provided by the Berlin-Brandenburg Academy of Sciences and Humanities (BBAW) in the context of the CLARIN initiative."
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonTargetedID",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://shibboleth.bbaw.de/Shibboleth.sso/DiscoJuice",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "information_url": [
                  {
                    "lang": "de",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.bbaw.de"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.bbaw.de"
                  }
                ],
                "display_name": [
                  {
                    "lang": "de",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "BBAW - CLARIN Dienste"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "BBAW - CLARIN services"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo",
                "description": [
                  {
                    "lang": "de",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Verschiedene Dienste der Berlin-Brandenburgischen Akademie der Wissenschaften (BBAW) im Rahmen der CLARIN-Initiative."
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Various services provided by the Berlin-Brandenburg Academy of Sciences and Humanities (BBAW) in the context of the CLARIN initiative."
                  }
                ],
                "logo": [
                  {
                    "text": "https://shibboleth.bbaw.de/bbaw_logo.png",
                    "height": "104",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "234"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://shibboleth.bbaw.de/privacy.html"
                  }
                ]
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "shibboleth.bbaw.de"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIF3TCCBMWgAwIBAgIHGFtty9nuvzANBgkqhkiG9w0BAQsFADCBnDELMAkGA1UE\nBhMCREUxPDA6BgNVBAoTM0Jlcmxpbi1CcmFuZGVuYnVyZ2lzY2hlIEFrYWRlbWll\nIGRlciBXaXNzZW5zY2hhZnRlbjEgMB4GA1UECxMXSW5mb3JtYXRpb25zdGVjaG5v\nbG9naWUxEjAQBgNVBAMTCUJCQVctQ0EgMTEZMBcGCSqGSIb3DQEJARYKY2FAYmJh\ndy5kZTAeFw0xNDEwMTMxNTMxMDdaFw0xOTA3MDkyMzU5MDBaMIGKMQswCQYDVQQG\nEwJERTEPMA0GA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xPDA6BgNVBAoT\nM0Jlcmxpbi1CcmFuZGVuYnVyZ2lzY2hlIEFrYWRlbWllIGRlciBXaXNzZW5zY2hh\nZnRlbjEbMBkGA1UEAxMSc2hpYmJvbGV0aC5iYmF3LmRlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAtciZovXzGD+K7C5bwgQl29CGss8jg8NoLco1C+h7\nREVbgOZo9ipf4OUoI8XieicXewor2hTF89Iy5nt/HuTQuKDW8q3edn+C/DNJgu4B\n0gmdZmZ+ubXcOd/1hnjRRLS9wxvgq2Q+mBLZwV8wMMJA/tEkO1xd0yGAysl4tcu2\nBcV/2SM+oI9rdWNuGK2m4lOsouEi0mIvm9v4aJBIfknOXm0cfC7xJB1fV5Q59gBL\n74PYTB99XKjQ3jVTzu3j1lOq9UgwbhYNXOiw2rWT2wY64LFAuNrk2j0tFnIIBLYM\nws2DLo4AXOeDUR6TY5xWfMRg6rHEKYY8s/ggeEj5KG+HNwIDAQABo4ICMjCCAi4w\nTwYDVR0gBEgwRjARBg8rBgEEAYGtIYIsAQEEAwIwEQYPKwYBBAGBrSGCLAIBBAMB\nMA8GDSsGAQQBga0hgiwBAQQwDQYLKwYBBAGBrSGCLB4wCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTr7kmL7423Mx9V5mu8Ukx5vyME0zAfBgNVHSMEGDAWgBSMpo/xPxQ7ArX5J1RM\nqzyh2BuQmDAdBgNVHREEFjAUghJzaGliYm9sZXRoLmJiYXcuZGUweQYDVR0fBHIw\ncDA2oDSgMoYwaHR0cDovL2NkcDEucGNhLmRmbi5kZS9iYmF3LWNhL3B1Yi9jcmwv\nY2FjcmwuY3JsMDagNKAyhjBodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2JiYXctY2Ev\ncHViL2NybC9jYWNybC5jcmwwgckGCCsGAQUFBwEBBIG8MIG5MDMGCCsGAQUFBzAB\nhidodHRwOi8vb2NzcC5wY2EuZGZuLmRlL09DU1AtU2VydmVyL09DU1AwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmJhdy1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUv\nYmJhdy1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQELBQADggEB\nAIcuZcIEBKtbbf/OOTxBfEiZ2iGfu3kLO2QXYR5oqh6D7ZVjrjXfWjyCR6beFosY\nM/2YkWIzRwfI/DAwXhiwXByqyYFcB6ICnqtIenuxgrhgcZcY5nOrV5NJ+kS8ivv8\njLdayhH+CBCA/UpDbyujMdeVjlJWPwaSacD51FIm6Ao3T+DBdXArNSphcGV+y2jD\n5JLMDjRaj/g29jQuJNhTvNajJFfVdNZt8KPEbYvJwwOk9rD9P3BEyAT9At/V6LyY\ngP+LmoAAhHE052Fg3khXrQ8qLV5ubP7DKZtIWA7nGg8v7/9iynjoUJ6yZn8Gx4s4\nWdNzDxmjE9EyFPvbQdfnOkE="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=shibboleth.bbaw.de,O=Berlin-Brandenburgische Akademie der Wissenschaften,L=Berlin,ST=Berlin,C=DE"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "shibboleth.bbaw.de"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIF3TCCBMWgAwIBAgIHGFtty9nuvzANBgkqhkiG9w0BAQsFADCBnDELMAkGA1UE\nBhMCREUxPDA6BgNVBAoTM0Jlcmxpbi1CcmFuZGVuYnVyZ2lzY2hlIEFrYWRlbWll\nIGRlciBXaXNzZW5zY2hhZnRlbjEgMB4GA1UECxMXSW5mb3JtYXRpb25zdGVjaG5v\nbG9naWUxEjAQBgNVBAMTCUJCQVctQ0EgMTEZMBcGCSqGSIb3DQEJARYKY2FAYmJh\ndy5kZTAeFw0xNDEwMTMxNTMxMDdaFw0xOTA3MDkyMzU5MDBaMIGKMQswCQYDVQQG\nEwJERTEPMA0GA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xPDA6BgNVBAoT\nM0Jlcmxpbi1CcmFuZGVuYnVyZ2lzY2hlIEFrYWRlbWllIGRlciBXaXNzZW5zY2hh\nZnRlbjEbMBkGA1UEAxMSc2hpYmJvbGV0aC5iYmF3LmRlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAtciZovXzGD+K7C5bwgQl29CGss8jg8NoLco1C+h7\nREVbgOZo9ipf4OUoI8XieicXewor2hTF89Iy5nt/HuTQuKDW8q3edn+C/DNJgu4B\n0gmdZmZ+ubXcOd/1hnjRRLS9wxvgq2Q+mBLZwV8wMMJA/tEkO1xd0yGAysl4tcu2\nBcV/2SM+oI9rdWNuGK2m4lOsouEi0mIvm9v4aJBIfknOXm0cfC7xJB1fV5Q59gBL\n74PYTB99XKjQ3jVTzu3j1lOq9UgwbhYNXOiw2rWT2wY64LFAuNrk2j0tFnIIBLYM\nws2DLo4AXOeDUR6TY5xWfMRg6rHEKYY8s/ggeEj5KG+HNwIDAQABo4ICMjCCAi4w\nTwYDVR0gBEgwRjARBg8rBgEEAYGtIYIsAQEEAwIwEQYPKwYBBAGBrSGCLAIBBAMB\nMA8GDSsGAQQBga0hgiwBAQQwDQYLKwYBBAGBrSGCLB4wCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTr7kmL7423Mx9V5mu8Ukx5vyME0zAfBgNVHSMEGDAWgBSMpo/xPxQ7ArX5J1RM\nqzyh2BuQmDAdBgNVHREEFjAUghJzaGliYm9sZXRoLmJiYXcuZGUweQYDVR0fBHIw\ncDA2oDSgMoYwaHR0cDovL2NkcDEucGNhLmRmbi5kZS9iYmF3LWNhL3B1Yi9jcmwv\nY2FjcmwuY3JsMDagNKAyhjBodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2JiYXctY2Ev\ncHViL2NybC9jYWNybC5jcmwwgckGCCsGAQUFBwEBBIG8MIG5MDMGCCsGAQUFBzAB\nhidodHRwOi8vb2NzcC5wY2EuZGZuLmRlL09DU1AtU2VydmVyL09DU1AwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmJhdy1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUv\nYmJhdy1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQELBQADggEB\nAIcuZcIEBKtbbf/OOTxBfEiZ2iGfu3kLO2QXYR5oqh6D7ZVjrjXfWjyCR6beFosY\nM/2YkWIzRwfI/DAwXhiwXByqyYFcB6ICnqtIenuxgrhgcZcY5nOrV5NJ+kS8ivv8\njLdayhH+CBCA/UpDbyujMdeVjlJWPwaSacD51FIm6Ao3T+DBdXArNSphcGV+y2jD\n5JLMDjRaj/g29jQuJNhTvNajJFfVdNZt8KPEbYvJwwOk9rD9P3BEyAT9At/V6LyY\ngP+LmoAAhHE052Fg3khXrQ8qLV5ubP7DKZtIWA7nGg8v7/9iynjoUJ6yZn8Gx4s4\nWdNzDxmjE9EyFPvbQdfnOkE="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=shibboleth.bbaw.de,O=Berlin-Brandenburgische Akademie der Wissenschaften,L=Berlin,ST=Berlin,C=DE"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://shibboleth.bbaw.de/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://ladok3-p00.ladok.umu.se/student-frontend-sp",
    {
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/sfs-1993-1153"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "entity_id": "https://ladok3-p00.ladok.umu.se/student-frontend-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ladok3 \u00e4r n\u00e4sta generation av studieadministrativt systemst\u00f6d f\u00f6r universitet och h\u00f6gskolor i Sverige"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ladok3 is the next generation of the administration system for higher education in Sweden."
                  }
                ],
                "logo": [
                  {
                    "text": "https://nya.ladok.umu.se/md/logos/ladok3_64x64.png",
                    "height": "64",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "64"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok3 testsystem studentgr\u00e4nssnitt ladok3#x2011;p00"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok3 testsite student web ladok3#x2011;p00"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "https://ladok3-p00.ladok.umu.se/student-frontend-sp"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "ladok3-p00.ladok.umu.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDQTCCAimgAwIBAgIJALxPd7mRqLHWMA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNV\nBAMTF2xhZG9rMy1wMDAubGFkb2sudW11LnNlMB4XDTE0MTAwNzE0NDUwN1oXDTI0\nMTAwNDE0NDUwN1owIjEgMB4GA1UEAxMXbGFkb2szLXAwMC5sYWRvay51bXUuc2Uw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC5eQWoo0jvq5ezBDlf44cN\nsbWxAK+OkxeRrIgazZz3BgFO7F+RTuEFyWbVCuwjltGqhugKwXWG+Sw6hK1HCJh7\n7EhxlXiiFZjsl0UYIvh4fk2YDSHnFX1gvF/8SvUJ6y3XXfq+NFcm79wbw7JCcHon\nimO50gTfcX+f8vOEmx7T39vdCMJinwZFfgwdSAgKI2u99hF7Fh6MoREL69rWtOn5\nSMKu6aOMz61fxI0+mQw0YPpdix0z8q6qTgfgWa6q1TXo7a5hEvooCXbfvG0EcBt9\nWe59FKDHqOco4q8O7W/+CfTh3chrqvIgd1ySno4PUofrQpZx43U6jPUwIppDlmq3\nAgMBAAGjejB4MFcGA1UdEQRQME6CF2xhZG9rMy1wMDAubGFkb2sudW11LnNlhjNo\ndHRwczovL2xhZG9rMy1wMDAubGFkb2sudW11LnNlL3N0dWRlbnQtZnJvbnRlbmQt\nc3AwHQYDVR0OBBYEFPYqHe1zEaIMRzs3f0sxAtAwo7lwMA0GCSqGSIb3DQEBBQUA\nA4IBAQCvy0qQ/FqDy6C1g5ECxZViC8/VPRBKnlnVXzmUWSjbF7KMTbfsM/LXKs2z\nyqtu4vOZ3HjUyL8ZB0MUhvBRZZKJEU+ybkNRll71Lmi7G7pjF0lppFRNt0DIxQ4t\nB3ZmRqC36gtRXx9Sw3utpX3EPkUDh2ahit3dqXBF2befvQRgXLo6Bdcy0+2t1vzm\noIn5DFz+1jZCpTHuVuRKNJPVuks8RWzBV0QUgeiO9vzg8JMbyDJx0DU3azGuNrBH\nrJDif3ojo11aT4Nrn7xehC+cV0yIqTFPNiAuZ/MWyDUBH5MIw3blavnllojr8+PG\nUEpDZ+oqJxcdV7QpvC9PesO5oSvH"
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=ladok3-p00.ladok.umu.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://ladok3-p00.ladok.umu.se:446/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://www.twigonglow.com/shibboleth-sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Kemp"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:pkemp@twig-world.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Patricia"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Munn"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:dmunn@twig-world.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "David"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://www.twigonglow.com/shibboleth-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2012-11-22T15:15:58Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Twig World Limited: Glow Science"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.twigonglow.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Twig World Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.twigonglow.com/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.twigonglow.com/Shibboleth.sso/shibtest",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.twigonglow.com/Shibboleth.sso/Glow",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.twigonglow.com/Shibboleth.sso/RMUnify",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.twigonglow.com/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDJzCCAg+gAwIBAgIJAMTlVAXkOmrZMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\n\t\t\t\t\t\tBAMTEnd3dy50d2lnb25nbG93LmNvbTAeFw0xMjExMTMxMTAxNDVaFw0yMjExMTEx\n\t\t\t\t\t\tMTAxNDVaMB0xGzAZBgNVBAMTEnd3dy50d2lnb25nbG93LmNvbTCCASIwDQYJKoZI\n\t\t\t\t\t\thvcNAQEBBQADggEPADCCAQoCggEBAKZvpD5K0jQvz3y9mkhLylUzqC+bZrGmyuIE\n\t\t\t\t\t\t9LAdDXh/9LpxgxnY+an/FnIQzrKFLyw+4t8H1QSLWyTLK8MA8b6tJjBxznvUv8Qk\n\t\t\t\t\t\tIpBAmBXWSkPQSHgbIoTFivb6iIVJq9h7yLi0JM7GpM4SS/ed+JiYiBM1C89/iaks\n\t\t\t\t\t\ts1kpbN9TYrqN0YBkogTe1NIJMDp13SagmR2WjmnzQKtCH8z3DQDA3MrrP+KIbp5Z\n\t\t\t\t\t\tQm6Nlk+XQv51Mg5b/8qMgBoekB6cTI+HEIXJauJyPfCPL0hysnNUzR57BGG04ol4\n\t\t\t\t\t\tVx/eIKKvzRSwRowSGIxIcIGzUk9lg1PIt7RXPcTHANqppLGZIusCAwEAAaNqMGgw\n\t\t\t\t\t\tRwYDVR0RBEAwPoISd3d3LnR3aWdvbmdsb3cuY29thihodHRwczovL3d3dy50d2ln\n\t\t\t\t\t\tb25nbG93LmNvbS9zaGliYm9sZXRoLXNwMB0GA1UdDgQWBBRHiLe+VeAuCc/Ly0mK\n\t\t\t\t\t\tI5tvs+uuujANBgkqhkiG9w0BAQUFAAOCAQEAJZHQuo5dFz0F77boWcIjUTH9eHtH\n\t\t\t\t\t\tHUYbLsotM1Xin8k0vQIwkqQcIByBHLlM/ScVKku4u8a5maAawSr6IZVvBbpYgYsO\n\t\t\t\t\t\tO0GZpHD45GFBIMQsgd+tTGlHus/t0048J5j3GPqx1NTMGs80DnCXAq9fLKjpil4i\n\t\t\t\t\t\t/mfAfP6CSrguh2rCvVndSrTLIHJfQ+d6Up8h24LYKzhHVQmdqgsSQAWg1yUacFER\n\t\t\t\t\t\tud1Wodm6t+Nrbyh4XA3YbekaxHPRO9bBIjo+sncONDf6JfFL57s4i74LeZVOMeQC\n\t\t\t\t\t\tyFFf/Cs64qzIILqKQWM0wqZq1vOavCR+OhOTdyjjKejhDKb9CWLzXSuOFw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.twigonglow.com/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.twigonglow.com/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.twigonglow.com/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.twigonglow.com/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.twigonglow.com/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://sdn-openstack.oit.duke.edu",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "rob@duke.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Rob Carter"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "shilen@duke.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Shilen Patel"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://sdn-openstack.oit.duke.edu",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Duke University"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.duke.edu/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Duke University"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://sdn-openstack-dev-01.oit.duke.edu/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "http://sdn-openstack-dev-01.oit.duke.edu:5000/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "OpenStack for Research"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDKjCCAhKgAwIBAgIJAOJfno4EnLE6MA0GCSqGSIb3DQEBBQUAMCwxKjAoBgNV\nBAMTIXNkbi1vcGVuc3RhY2stZGV2LTAxLm9pdC5kdWtlLmVkdTAeFw0xNjAxMTIx\nODEyMTZaFw0yNjAxMDkxODEyMTZaMCwxKjAoBgNVBAMTIXNkbi1vcGVuc3RhY2st\nZGV2LTAxLm9pdC5kdWtlLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAMVe4zmeL0wgsAe9egTdVQk3B6aqbsGc6PQ/twlFzMFDFc3hlC8RLw4YIpnx\n2ScFpuI1DVPqsKsC7l2wsXbBO7THYRGmmEjNjVbuYFXUC7mt8A4lluXzJjROJDBx\ndT6++d48bD81SnoLpU5wrr0JXiYNy3JxeVKshdGt9YutLLmlF91D4jOwxLt2s7op\nXXNBqspAHkZvK+TZIboUPHoycjHrFYW1xqjarwpTEpkfzyKmb12faqr78nWLISID\nUrd90Ysdwl+nPbg93Ce/zmpX1jVHnNb3zKhISYTk85uUgLYF0j6+jz9XDqZVCA7b\nBwlkwOFFG1yHMatuDRk+hlJ66DECAwEAAaNPME0wLAYDVR0RBCUwI4Ihc2RuLW9w\nZW5zdGFjay1kZXYtMDEub2l0LmR1a2UuZWR1MB0GA1UdDgQWBBSSiEcxZhDYi+9c\nSDTGY+oXd35CoDANBgkqhkiG9w0BAQUFAAOCAQEAKMnx2FRBy7I8kIJZy3TIuCEC\nIMqyOyCo7WxVBFcA3nJPurO2SNrvC2nNWG/WKvaga+ggMos5IcDiGwNPOtRiC3MS\nfApVKRbwBCb6vxkwnM3rtLzPVGL+5Hsmsxjk82Xy8m6+JubK0XTP4xkhrIwyqj3O\nCriPKh1LYjUQ7p2mF0qQnw0mFvkCgHgKeqx7llzFMKzxk+xAXDcnunXGRB2xVHDL\nJJ7lo9u+ITPEMRXy4dr9NjWXfHVDRBdIq12HG5OR+KBomJSSLoF4B/+Lw8e5UA4k\nhqZYCJefeTUol0vkdULhuiJHN1eaOWijZo9sbu1cYeHxwVXo1hN00PS4WuJ+hg=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sdn-openstack-dev-01.oit.duke.edu/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "http://sdn-openstack-dev-01.oit.duke.edu:5000/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "http://sdn-openstack-dev-01.oit.duke.edu:5000/v3/auth/OS-FEDERATION/websso/saml2",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sdn-openstack.oit.duke.edu/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "http://sdn-openstack.oit.duke.edu:5000/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "http://sdn-openstack.oit.duke.edu:5000/v3/auth/OS-FEDERATION/websso/saml2",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "OpenStack for Research"
                }
              ],
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://gw-astronomy.org/shibboleth-sp",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "uwm-help@gravity.phys.uwm.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "UWM CGCA Help"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "stephenb@uwm.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Branson Stephens"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "anders15@uwm.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Warren Anderson"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "lsc-seccomm@ligo.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "LIGO Scientific Collaboration Security Committee"
          },
          "contact_type": "other",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson",
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ],
      "entity_id": "https://gw-astronomy.org/shibboleth-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/research-and-scholarship"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Wisconsin-Milwaukee"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uwm.edu/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Wisconsin-Milwaukee"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://gw-astronomy.org/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://gw-astronomy.org/registry/pages/public/sp_info"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Gravitational Wave Astronomy Community Registry used to support collaboration across astronomy and astrophysics projects."
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "https://gw-astronomy.org/registry/pages/public/privacy_info"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Gravitational Wave Astronomy Community Registry"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEWDCCA0CgAwIBAgIBPjANBgkqhkiG9w0BAQUFADCBhzETMBEGCgmSJomT8ixk\nARkWA29yZzEUMBIGCgmSJomT8ixkARkWBGxpZ28xDTALBgNVBAoTBExJR08xIDAe\nBgNVBAsTF0NlcnRpZmljYXRlIEF1dGhvcml0aWVzMRUwEwYDVQQLEwxXZWIgU2Vy\ndmljZXMxEjAQBgNVBAMTCUxJR08gQ0EgMTAeFw0xMTA0MjkxNzI0MTJaFw0yMTA0\nMjgxNzI0MTJaMGoxEzARBgoJkiaJk/IsZAEZFgNvcmcxFDASBgoJkiaJk/IsZAEZ\nFgRsaWdvMQ0wCwYDVQQKEwRMSUdPMRUwEwYDVQQLEwxXZWIgU2VydmljZXMxFzAV\nBgNVBAMTDmd1ZXN0LmxpZ28ub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEApxrDaMIRCnagFhhjD4rY47JBOHKjA4IS6EG1MvqG6kMXm73ZdYRhRraQ\nonVmFMUPPlkR5zTlok+qvb+Iy58s6PqguQe0Tz3eEnfRlVqLaXniKNGxkef5pXFY\nhndYXzkfeoclycdYZGwu12ANoG5wjADhYcWEuiyJKprfWXF/msa65rkczuMd5WFw\nlde6hnpZTXa6FaeYb1Hi8Me36pHFCU3DfhARdup7DQ4t3QDEttQY1mn/pnY6vd2o\noa/jmL1iHkJbTDT6+EWhk/3XdrC1tfo1VKQ+B4RebTyzRY8Wsgn3CAyAz9K5nA7w\naYBOYhK26Z6envlE+vXviDI89J/C7QIDAQABo4HqMIHnMAwGA1UdEwEB/wQCMAAw\nDgYDVR0PAQH/BAQDAgSwMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAZ\nBgNVHSAEEjAQMA4GDCsGAQQBgfpGAgECATA5BgNVHR8EMjAwMC6gLKAqhihodHRw\nOi8vY2EubGlnby5vcmcvNTQxNDA0YzMvNTQxNDA0YzMuY3JsMB8GA1UdIwQYMBaA\nFFJu3Xuqb4VcCCLTl5+tfyNWHmrRMDEGA1UdEQQqMCiCDmd1ZXN0LmxpZ28ub3Jn\ngRZzY290dC5rb3JhbmRhQGxpZ28ub3JnMA0GCSqGSIb3DQEBBQUAA4IBAQBXTyxj\nWEiIQ4kG8I9ujY9AssDMi63g9m4AT7uAm6mbNJVRaYkYVy7lnRi227fBjIXr8rku\ngfUhzwRULi9OUuY5eO713iB/urMn3mysch9R6heciYGzccnn5nN3gWrUN3kZ0AWd\nXaIE5G8rZOACTDp7SCVyNH1eZNkk6apK9LJgblo44XppU8gZk1OIzBzeknCuZhGz\n6Lnu58KItVKI+8w7FepUsXIdF6pHRLevhzW7d61QZ5iW8o2qW0TG24RDY4JJE45m\ny6qIv7HErgRcZZrxupRI6NfHLBxJx22n8rBD7gmVoCLXkAftIKQZ8pBKF4c74ErF\nxWUYS9G3JfMMW9UY"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://gw-astronomy.org/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://gw-astronomy.org/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://gw-astronomy.org/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://gw-astronomy.org/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "Gravitational Wave Astronomy Community Registry"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Gravitational Wave Astronomy Community Registry used to support collaboration across astronomy and astrophysics projects."
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "displayName",
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri",
                  "name": "urn:mace:dir:attribute-def:displayName",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "displayName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.16.840.1.113730.3.1.241",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri",
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonPrincipalName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "givenName",
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri",
                  "name": "urn:mace:dir:attribute-def:givenName",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "givenName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "mail",
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri",
                  "name": "urn:mace:dir:attribute-def:mail",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "mail",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "sn",
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri",
                  "name": "urn:mace:dir:attribute-def:sn",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "sn",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "http://adfs.stw.nl/adfs/services/trust",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "help@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "http://adfs.stw.nl/adfs/services/trust",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://wiki.surfnet.nl/display/eduGAIN/EduGAIN"
              }
            ],
            "registration_instant": "2015-07-08T15:00:00Z",
            "registration_authority": "http://www.surfconext.nl/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://engine.surfconext.nl/authentication/idp/single-sign-on/64b3a9ee71b20e9b46d4a6a5ac5e98ba",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Technologiestichting STW realiseert kennisoverdracht tussen technische wetenschappen en gebruikers. Dat doet zij door excellent technisch-wetenschappelijk onderzoek te financieren en bij elk project onderzoekers en gebruikers letterlijk bij elkaar te bren"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Technology Foundation STW realises knowledge transfer between the technical sciences and users. It does that by funding excellent technical sciences research and for each project literally bringing researchers and users together."
                  }
                ],
                "logo": [
                  {
                    "text": "https://static.surfconext.nl/logos/idp/stw.png",
                    "height": "194",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "259"
                  }
                ],
                "display_name": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Technologiestichting STW"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Technologiestichting STW"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID3zCCAsegAwIBAgIJAMVC9xn1ZfsuMA0GCSqGSIb3DQEBCwUAMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTAeFw0xNDA1MDUxNDIyMzVaFw0xOTA1MDUxNDIyMzVaMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKthMDbB0jKHefPzmRu9t2h7iLP4wAXr42bHpjzTEk6gttHFb4l/hFiz1YBI88TjiH6hVjnozo/YHA2c51us+Y7g0XoS7653lbUN/EHzvDMuyis4Xi2Ijf1A/OUQfH1iFUWttIgtWK9+fatXoGUS6tirQvrzVh6ZstEp1xbpo1SF6UoVl+fh7tM81qz+Crr/Kroan0UjpZOFTwxPoK6fdLgMAieKSCRmBGpbJHbQ2xxbdykBBrBbdfzIX4CDepfjE9h/40ldw5jRn3e392jrS6htk23N9BWWrpBT5QCk0kH3h/6F1Dm6TkyG9CDtt73/anuRkvXbeygI4wml9bL3rE8CAwEAAaNQME4wHQYDVR0OBBYEFD+Ac7akFxaMhBQAjVfvgGfY8hNKMB8GA1UdIwQYMBaAFD+Ac7akFxaMhBQAjVfvgGfY8hNKMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAC8L9D67CxIhGo5aGVu63WqRHBNOdo/FAGI7LURDFeRmG5nRw/VXzJLGJksh4FSkx7aPrxNWF1uFiDZ80EuYQuIv7bDLblK31ZEbdg1R9LgiZCdYSr464I7yXQY9o6FiNtSKZkQO8EsscJPPy/Zp4uHAnADWACkOUHiCbcKiUUFu66dX0Wr/v53Gekz487GgVRs8HEeT9MU1reBKRgdENR8PNg4rbQfLc3YQKLWK7yWnn/RenjDpuCiePj8N8/80tGgrNgK/6fzM3zI18sSywnXLswxqDb/J+jgVxnQ6MrsTf1urM8MnfcxG/82oHIwfMh/sXPCZpo+DTLkhQxctJ3M="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Technologiestichting STW"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.stw.nl/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Technologiestichting STW"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.shibboleth.net/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:contact@shibboleth.net"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Shibboleth.Net Technical Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Cantor"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:cantor.2@osu.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Scott"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Young"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:ukfed@iay.org.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Ian"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.shibboleth.net/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2011-01-06T16:22:29Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.net/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shibboleth.net/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.net/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "shibboleth.net"
              },
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "An identity provider hosted and used by the\n\t\t\t\t\tdevelopers of Shibboleth."
                  }
                ],
                "logo": [
                  {
                    "text": "https://shibboleth.net/images/gryphon_64x82.png",
                    "height": "82",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "64"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Shibboleth.net"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDNDCCAhygAwIBAgIVAKyBWnv1/h1U11C7kHvV33FIrEsJMA0GCSqGSIb3DQEB\n\t\t\t\t\t\tBQUAMB0xGzAZBgNVBAMTEmlkcC5zaGliYm9sZXRoLm5ldDAeFw0xMDEyMjkwMDA5\n\t\t\t\t\t\tMTlaFw0zMDEyMjkwMDA5MTlaMB0xGzAZBgNVBAMTEmlkcC5zaGliYm9sZXRoLm5l\n\t\t\t\t\t\tdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKjWAdpUx/82FUzrRMfA\n\t\t\t\t\t\tM63PkZZYCm3RnT3eiL+DeJcbGdcEJx/o+32vgHXJgJOBt14YdVam5GErIYgk4SGq\n\t\t\t\t\t\t5Z5RYl0PpQn6HQG/9prGnYCu6p5zfb0557o51Eh8TcVehS6Y2ruyCjAF0jgVMwh5\n\t\t\t\t\t\t/0Oh8EE9wG93pSpm70DAiiaTVCb8WoT1aZYtxbBmmuH10bU+wge/NMmaHuVAe599\n\t\t\t\t\t\tpyezFIL4FoI2g+1Q6nG4Yl1Z07I81tTApXKVMWRt/4/M3m2D7PUMOQ9qsxthp2L/\n\t\t\t\t\t\tLovIeNo0bTyeW290T2Y/JRZhKOgeDqkhuu82DPri2Vm5G/unB69KfRB7CF9QWIc3\n\t\t\t\t\t\ty80CAwEAAaNrMGkwSAYDVR0RBEEwP4ISaWRwLnNoaWJib2xldGgubmV0hilodHRw\n\t\t\t\t\t\tczovL2lkcC5zaGliYm9sZXRoLm5ldC9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQU\n\t\t\t\t\t\t3uZ32tKXJBzPCTp2dtHSLV0FvGgwDQYJKoZIhvcNAQEFBQADggEBAAYXYuzp0UTj\n\t\t\t\t\t\t3yLRvUCbEtaw9b80+weOELkVv3WFY3QAG8pIKEblrMMtzrzLFWZwYwwMZDab/HnH\n\t\t\t\t\t\tegmgjZBthrOedEmoJ+OHRmIiS8zdZxVGEadJhTUaeIkO6kwK7Ht3nQePoiXV7TI5\n\t\t\t\t\t\t+A9SpmZGoukC85Za4wGDw4xWGs5t5l6tBuuV+1s0oC6T8ih5n/NyThfpbihSW0d7\n\t\t\t\t\t\tiBfSUickgpoM2BLM3FCnbO8HOsX1rGV4ypG9ZGDDvr2jrzalXXmc05gSlL2qd9ce\n\t\t\t\t\t\tQ1M+9vavusPCqlj2zZf2/HfzhyiFcb/OgA0oTFWW2ynXji6UarIV5QaPoi/XmGmx\n\t\t\t\t\t\tBXD36HfGBXk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Shibboleth.net"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.shibboleth.net/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "JISC Collections and Janet Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://ladok3-p12.ladok.umu.se/student-sp",
    {
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/sfs-1993-1153"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "entity_id": "https://ladok3-p12.ladok.umu.se/student-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ladok3 \u00e4r n\u00e4sta generation av studieadministrativt systemst\u00f6d f\u00f6r universitet och h\u00f6gskolor i Sverige"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ladok3 is the next generation of the administration system for higher education in Sweden."
                  }
                ],
                "logo": [
                  {
                    "text": "https://nya.ladok.umu.se/md/logos/ladok3_64x64.png",
                    "height": "64",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "64"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok3 testsystem studentgr\u00e4nssnitt ladok3#x2011;p12"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok3 testsite student web ladok3#x2011;p12"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "https://ladok3-p12.ladok.umu.se/student-sp"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "ladok3-p12.ladok.umu.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDQTCCAimgAwIBAgIJAJwfFHHm4QTAMA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNV\nBAMTF2xhZG9rMy1wMTIubGFkb2sudW11LnNlMB4XDTE1MDIwOTEwNDE0NloXDTI1\nMDIwNjEwNDE0NlowIjEgMB4GA1UEAxMXbGFkb2szLXAxMi5sYWRvay51bXUuc2Uw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC1hH5bfM0hd5d2hD4Na6LP\nGBeBX337nRyUU0tJaLVQj2fZMygo2zV6fE9ht4dIEzUaS0u8C8HhY2ASHMVYYsb4\nE5L1Jx9fosv8L6tqoX+hL8QZQ2w2SCYGHjRaAEkmhdjMSTp9O3n3q5lFG8jA+unf\nSA9CDvL/R//Imq2oqNrf3cgbfifhD5XnOZRc0gj2THlq0E/fpqXK6XYOIc1ZO9dx\nr2tNw1Zu3zY+c1BbQ42gMa43O1L9S9szfQfJZC6cMa3C5DXHCidJ/sFJ5ITLmxur\nR6pteZI9vyHaIPC+zX4Ta5kn50rhqeITajNExyWo1fA5ebVlRlQ5Jl9L5l6scnMR\nAgMBAAGjejB4MFcGA1UdEQRQME6CF2xhZG9rMy1wMTIubGFkb2sudW11LnNlhjNo\ndHRwczovL2xhZG9rMy1wMTIubGFkb2sudW11LnNlL3N0dWRlbnQtZnJvbnRlbmQt\nc3AwHQYDVR0OBBYEFIl6Hqs8E9quQ9zh8x5nn5SzlqF8MA0GCSqGSIb3DQEBBQUA\nA4IBAQCFZ9SxV0u3FYj8PTzaDa6unPRH/0qzZ4LuD87Hmx87n4NL3XFu2e5ocgvf\nlHY3XEr23zWm0u7vZu2M9lD3No/y4wmFPxpv4uSt27EcLPbD8u1LA0q+xzO6/T5j\nNKnxy7NcK+a17PXnsp/XXzOfRtFqkPByitZIbD9KWkuDg6ri2gws1BPc/fHV9V1i\nDWuaLVpBYp5vMqIr5esITLLVNIwk0A68PZy05J87SEr7Gepyg1zyX4AYa52rqkY0\nXQHW0Eym6LKaJ2wLzF/Il9WlgBNOFr7nN2344wyG3cq8Qd1d/zWyms+sauuZxZz7\nuqxBQkCvnX33vrqLW5c3nz5GznAD"
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=ladok3-p12.ladok.umu.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://ladok3-p12.ladok.umu.se:446/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://ashiok.ufpe.br/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Fabio Chicout"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "fabio.chicout@ufpe.br"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://ashiok.ufpe.br/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf"
              }
            ],
            "registration_instant": "2010-01-01T00:00:00Z",
            "registration_authority": "http://cafe.rnp.br",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEKjCCAxICAQAwDQYJKoZIhvcNAQEFBQAwgdoxMTAvBgNVBAoTKFVGUEUgLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBQZXJubWJ1Y28xNTAzBgNVBAsULE5USSAt\nIE7DumNsZW8gZGUgVGVjb25vbG9naWEgZGEgSW5mb3JtYcOnw6NvMSIwIAYJKoZI\nhvcNAQkBFhNhbG1pci5waXJlc0B1ZnBlLmJyMQ8wDQYDVQQHEwZSZWNpZmUxEzAR\nBgNVBAgTClBlcm5hbWJ1Y28xCzAJBgNVBAYTAkJSMRcwFQYDVQQDEw5hc2hpb2su\ndWZwZS5icjAeFw0xNTA3MDgxNTE3MDBaFw0xODA3MDcxNTE3MDBaMIHaMTEwLwYD\nVQQKEyhVRlBFIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgUGVybm1idWNvMTUw\nMwYDVQQLFCxOVEkgLSBOw7pjbGVvIGRlIFRlY29ub2xvZ2lhIGRhIEluZm9ybWHD\np8OjbzEiMCAGCSqGSIb3DQEJARYTYWxtaXIucGlyZXNAdWZwZS5icjEPMA0GA1UE\nBxMGUmVjaWZlMRMwEQYDVQQIEwpQZXJuYW1idWNvMQswCQYDVQQGEwJCUjEXMBUG\nA1UEAxMOYXNoaW9rLnVmcGUuYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQCpJtnXex0EfajEm2mxs7SbI095tfMKoBYKm+oX2Rh0LG9Dqv2tkz8zlrGz\n65MX7J0T83f2XXCtwn8+QeFWIPjZeCrhXqiV+cd/8zT48mat8jjvlPXQUBT9l7CF\nui7Ck3nKgAuyRmLZS0VRWa5Fe7jQVenb0ukfWjlkqA0HA3aG76d/5/Re/JHCuhoX\nJ/B8Hk3r4RnUqAR5v9p+wvVlIfuMgZ2PoMpOEFnLRST/IAYYu6sfNF+/OGYnNOVt\nHaodpJiODntW7N58a7LUvmMDQcuZNk/gEFFa7lpc1lUxZ21/xjzt8hoM5JaKalRp\nWvoGp7ebIAjU5XAAB9D617WrhRaHAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAB7u\nICGu5gqybOHxpZOVMhL7Vc5ZkHKk07gFzlMeDcrm4FEi9NSC+ACSZOw4Y65hzlML\n3Mqvwa27U2Uf9+g8cXKvmjEImZTX+1DpWcgfslS6ZZlXPX751+c+0G5HCMvHQotT\neouE1EENazDBi7+JHPH0dVX5EQwo/TghbjWwZn0XauScEQQSfcb5ncHWV62IlpjP\nHRjJA1oHM/BcHqi1Gld3QuKZ6Mz0AWAjsXlbwvcOUNjtPdgghHZzL/2PZQwErMw3\n3p9yrXX8gzzfzibmLwq3vu7eqXmz40Q1GyzzFVBcHdOTYRKON7g0Gj7rYzPVzw6m\ngJlqm/h9oLN/JBPHKNI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "ufpe.br"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ashiok.ufpe.br:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://ashiok.ufpe.br:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://ashiok.ufpe.br/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://ashiok.ufpe.br/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://ashiok.ufpe.br/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://ashiok.ufpe.br/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://ashiok.ufpe.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://ashiok.ufpe.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "ufpe.br"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.ufpe.br/"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.ufpe.br/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UFPE - Universidade Federal de Pernambuco"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UFPE - Universidade Federal de Pernambuco"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UFPE - Universidade Federal de Pernambuco"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UFPE - Universidade Federal de Pernambuco"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEKjCCAxICAQAwDQYJKoZIhvcNAQEFBQAwgdoxMTAvBgNVBAoTKFVGUEUgLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBQZXJubWJ1Y28xNTAzBgNVBAsULE5USSAt\nIE7DumNsZW8gZGUgVGVjb25vbG9naWEgZGEgSW5mb3JtYcOnw6NvMSIwIAYJKoZI\nhvcNAQkBFhNhbG1pci5waXJlc0B1ZnBlLmJyMQ8wDQYDVQQHEwZSZWNpZmUxEzAR\nBgNVBAgTClBlcm5hbWJ1Y28xCzAJBgNVBAYTAkJSMRcwFQYDVQQDEw5hc2hpb2su\ndWZwZS5icjAeFw0xNTA3MDgxNTE3MDBaFw0xODA3MDcxNTE3MDBaMIHaMTEwLwYD\nVQQKEyhVRlBFIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgUGVybm1idWNvMTUw\nMwYDVQQLFCxOVEkgLSBOw7pjbGVvIGRlIFRlY29ub2xvZ2lhIGRhIEluZm9ybWHD\np8OjbzEiMCAGCSqGSIb3DQEJARYTYWxtaXIucGlyZXNAdWZwZS5icjEPMA0GA1UE\nBxMGUmVjaWZlMRMwEQYDVQQIEwpQZXJuYW1idWNvMQswCQYDVQQGEwJCUjEXMBUG\nA1UEAxMOYXNoaW9rLnVmcGUuYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQCpJtnXex0EfajEm2mxs7SbI095tfMKoBYKm+oX2Rh0LG9Dqv2tkz8zlrGz\n65MX7J0T83f2XXCtwn8+QeFWIPjZeCrhXqiV+cd/8zT48mat8jjvlPXQUBT9l7CF\nui7Ck3nKgAuyRmLZS0VRWa5Fe7jQVenb0ukfWjlkqA0HA3aG76d/5/Re/JHCuhoX\nJ/B8Hk3r4RnUqAR5v9p+wvVlIfuMgZ2PoMpOEFnLRST/IAYYu6sfNF+/OGYnNOVt\nHaodpJiODntW7N58a7LUvmMDQcuZNk/gEFFa7lpc1lUxZ21/xjzt8hoM5JaKalRp\nWvoGp7ebIAjU5XAAB9D617WrhRaHAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAB7u\nICGu5gqybOHxpZOVMhL7Vc5ZkHKk07gFzlMeDcrm4FEi9NSC+ACSZOw4Y65hzlML\n3Mqvwa27U2Uf9+g8cXKvmjEImZTX+1DpWcgfslS6ZZlXPX751+c+0G5HCMvHQotT\neouE1EENazDBi7+JHPH0dVX5EQwo/TghbjWwZn0XauScEQQSfcb5ncHWV62IlpjP\nHRjJA1oHM/BcHqi1Gld3QuKZ6Mz0AWAjsXlbwvcOUNjtPdgghHZzL/2PZQwErMw3\n3p9yrXX8gzzfzibmLwq3vu7eqXmz40Q1GyzzFVBcHdOTYRKON7g0Gj7rYzPVzw6m\ngJlqm/h9oLN/JBPHKNI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UFPE - Universidade Federal de Pernambuco"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UFPE - Universidade Federal de Pernambuco"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ufpe.br/"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ufpe.br/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UFPE - Universidade Federal de Pernambuco"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UFPE - Universidade Federal de Pernambuco"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://aktivera-test.su.se/Shibboleth.sso",
    {
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/sfs-1993-1153"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "entity_id": "https://aktivera-test.su.se/Shibboleth.sso",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://aktivera-test.su.se/Shibboleth.sso/WAYF",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://aktivera-test.su.se/Shibboleth.sso/WAYF/wavelan",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "signuptool-test-app1"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDAzCCAeugAwIBAgIJAK5pPeHRZOXtMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFHNpZ251cHRvb2wtdGVzdC1hcHAxMB4XDTExMDIyMTE1MjYxNloXDTIxMDIx\nODE1MjYxNlowHzEdMBsGA1UEAxMUc2lnbnVwdG9vbC10ZXN0LWFwcDEwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDY+owzEC+S0BF0nCbN13lR0CHlp7mg\n/7YhK3ESVboh9kUtM4/awXRjvJFMfcuFbaJV2DXCX85hFvBIw0D4u6bjNNPye9oS\nVPAFenaFnHAE75O5C3FYnuB5X3P9HDdBoc5m21CDwLmGek7KwPTxpJtqevNUAO2C\n/EEtdk1xe+2T4+fikdRMP9uvf6xz7/WgGzm1V/olbV3tgph7ye4KEB2F6Z/hsyyn\nJaekNZD3oKOk3DsXfxHKRhD/nUjqXoGoUwkD4HLT1fKdP5VYb+T/SzdxLSaoUoJJ\nfVv2Xs/wlD3Vx3zvV5l3x8EJ4paySeh4RdNsUAylbshYUXN9frk5g/WzAgMBAAGj\nQjBAMB8GA1UdEQQYMBaCFHNpZ251cHRvb2wtdGVzdC1hcHAxMB0GA1UdDgQWBBSt\ncBtmU+scg9g8iK1x07dqKTh+QDANBgkqhkiG9w0BAQUFAAOCAQEAw0NLLpKeYIhn\nrL0edePtkGr3sFNmOyg8k9qkPxgwrozjLg/+AkssNft+rs7nZp87IIhZUiNZxr7w\nqnRPJXoxq56IfsbZpQwAH0QIRc9gl5BjzvdqByGH76Z5dDPFUaTrxnd7XdWybOiZ\nbX4d2LgWklI0aTw7xQEjw0qX/nWW0guZRC/nJfgiHjV7xEJLcoxcyn0+dqo1+XkU\ny60nYKhdp2qnCnRCR8by5ykruSaDJ4c/OCsGh9WIE6HvpDunTTzisfqrdZ22LTLR\nvaJm+7MsfXQvQZz6YUW2MGSYOa6G9v2dS4Dz9v/9JQjn6bBqqSouw3spYPDAbzGp\nu/S7d9rEGQ=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=signuptool-test-app1"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "signuptool-test-app1"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDAzCCAeugAwIBAgIJAK5pPeHRZOXtMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFHNpZ251cHRvb2wtdGVzdC1hcHAxMB4XDTExMDIyMTE1MjYxNloXDTIxMDIx\nODE1MjYxNlowHzEdMBsGA1UEAxMUc2lnbnVwdG9vbC10ZXN0LWFwcDEwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDY+owzEC+S0BF0nCbN13lR0CHlp7mg\n/7YhK3ESVboh9kUtM4/awXRjvJFMfcuFbaJV2DXCX85hFvBIw0D4u6bjNNPye9oS\nVPAFenaFnHAE75O5C3FYnuB5X3P9HDdBoc5m21CDwLmGek7KwPTxpJtqevNUAO2C\n/EEtdk1xe+2T4+fikdRMP9uvf6xz7/WgGzm1V/olbV3tgph7ye4KEB2F6Z/hsyyn\nJaekNZD3oKOk3DsXfxHKRhD/nUjqXoGoUwkD4HLT1fKdP5VYb+T/SzdxLSaoUoJJ\nfVv2Xs/wlD3Vx3zvV5l3x8EJ4paySeh4RdNsUAylbshYUXN9frk5g/WzAgMBAAGj\nQjBAMB8GA1UdEQQYMBaCFHNpZ251cHRvb2wtdGVzdC1hcHAxMB0GA1UdDgQWBBSt\ncBtmU+scg9g8iK1x07dqKTh+QDANBgkqhkiG9w0BAQUFAAOCAQEAw0NLLpKeYIhn\nrL0edePtkGr3sFNmOyg8k9qkPxgwrozjLg/+AkssNft+rs7nZp87IIhZUiNZxr7w\nqnRPJXoxq56IfsbZpQwAH0QIRc9gl5BjzvdqByGH76Z5dDPFUaTrxnd7XdWybOiZ\nbX4d2LgWklI0aTw7xQEjw0qX/nWW0guZRC/nJfgiHjV7xEJLcoxcyn0+dqo1+XkU\ny60nYKhdp2qnCnRCR8by5ykruSaDJ4c/OCsGh9WIE6HvpDunTTzisfqrdZ22LTLR\nvaJm+7MsfXQvQZz6YUW2MGSYOa6G9v2dS4Dz9v/9JQjn6bBqqSouw3spYPDAbzGp\nu/S7d9rEGQ=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=signuptool-test-app1"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://aktivera-test.su.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://halfback.cnaf.infn.it/casshib/app2",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:igi-portal-admin@lists.italiangrid.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://halfback.cnaf.infn.it/casshib/app2",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.idem.garr.it/idem-metadata-registration-practice-statement"
              }
            ],
            "registration_instant": "2012-07-04T15:00:00Z",
            "registration_authority": "http://www.idem.garr.it/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "IGI Grid Portal erogato da INFN"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "IGI Grid Portal provided by INFN"
          }
        ],
        "organization_url": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.infn.it"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.infn.it/indexen.php"
          }
        ],
        "organization_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Istituto Nazionale di Fisica Nucleare"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Istituto Nazionale di Fisica Nucleare"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "IGI Grid Portal provided by INFN"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "IGI is the Italian Grid infrastructure, run for the benefit of the research and education communities in Italy and worldwide"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonTargetedID",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "givenName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "sn",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "mail",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "eduPersonOrgDN",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "localityName",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.7",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://wiki.italiangrid.it/IGIPortal"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "IGI is the Italian Grid infrastructure, run for the benefit of the research and education communities in Italy and worldwide."
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "https://wiki.italiangrid.it/IGIPortal/Federation-info"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "IGI Grid Portal"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEhzCCA2+gAwIBAgIQYJH5E+/63l61Qiby7wHhYjANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEyMDYyNTAwMDAwMFoXDTE1MDYyNTIzNTk1OVowXTELMAkGA1UE\nBhMCSVQxLjAsBgNVBAoTJUlzdGl0dXRvIE5hemlvbmFsZSBkaSBGaXNpY2EgTnVj\nbGVhcmUxHjAcBgNVBAMTFWhhbGZiYWNrLmNuYWYuaW5mbi5pdDCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAOH0IRtQc7utWIumhJaEwwBdovpOu3eUH3X5\nDK7/OaQYHpo2+E1tnoHdG1JU+QgZocacuw3oJz74tGdknUsvDj9MCdp2lGYLpPW9\np4WMK5+ElpVFjLcKdxndPNME8SF0nOcRoM9aMQhpOSnSLX3Ybeov/MO0dT9iVVmW\nKAau3hSeUZ2renaL/oQp+bK3+EoYImYV/5R1rkpTTf0brmaQg3GBdxADnAdwFBgG\nY93qnKsYQjPsOg7ik7kf0jUSrITGo7rgLHvkElm4ySG01jOOtfw4AoglUppUan2x\nhlHYWrUhdqzNV2uasqHP3t7EA4tITv8IrgJj3k2coinPbB9s1mUCAwEAAaOCAWgw\nggFkMB8GA1UdIwQYMBaAFAy9k2gM896ro0lrKzdXR+qQ47ntMB0GA1UdDgQWBBTz\nkh/WAe7TMeep782t7Dy4EX8J/DAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIw\nADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwGAYDVR0gBBEwDzANBgsr\nBgEEAbIxAQICHTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnRjcy50ZXJl\nbmEub3JnL1RFUkVOQVNTTENBLmNybDBtBggrBgEFBQcBAQRhMF8wNQYIKwYBBQUH\nMAKGKWh0dHA6Ly9jcnQudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3J0MCYG\nCCsGAQUFBzABhhpodHRwOi8vb2NzcC50Y3MudGVyZW5hLm9yZzAgBgNVHREEGTAX\nghVoYWxmYmFjay5jbmFmLmluZm4uaXQwDQYJKoZIhvcNAQEFBQADggEBAHW8TsHv\nD7EM9iMprOIH+5VeRSh0cYEdttX033scsifCFCArRJvhofIkR/1F23DIWRnc8//4\n7MKSrLoC9PNeIjXa6anC3O9IZNCeBxb9UEcRvPW3Yc1wEe4ATp1aR8EXtH3G2Sef\nEELgyGnKzScgkUSGIbgf9P05XOyok0RuKWTHDvYNHr/GW/NW5optwXz6apDDE2mX\nicFWqRortYglbk+s6VO0hcYN6ORR5UBgOR6VULrT9r6mDQykItMVhBgt4peAeOss\n+6acaFTdJZHMD+Z3KkvA7yfD4IWulPnTaT+o1n7X1V6oAEVHn6SfpuBeP+wXeu+f\nyVxNpwv+OOJLtns="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://halfback.cnaf.infn.it/casshib/shib/app2/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "11"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://equinoxjournals.com/shibboleth-sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Willis"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:mwillis@equinoxpub.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Michael"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Willis"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:mwillis@equinoxpub.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Michael"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://equinoxjournals.com/shibboleth-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_instant": "2012-04-03T09:28:24Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Equinox Publishing"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.equinoxpub.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Equinox Publishing Ltd"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "0"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Publishing academic journals, textbooks, anthologies, monographs and reference books in the areas of archaeology, linguistics, cultural history, religious studies, theology, biblical studies, cookery and popular music."
                  }
                ],
                "logo": [
                  {
                    "text": "https://www.equinoxpub.com/equinox/images/home_logo.gif",
                    "height": "79",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "363"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Equinox Publishing"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.equinoxpub.com/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://www.equinoxpub.com/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.equinoxpub.com/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://www.equinoxpub.com/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEXDCCA0SgAwIBAgIJAI+ovrSiKZbIMA0GCSqGSIb3DQEBBQUAMIGuMQswCQYD\n\t\t\t\t\t\tVQQGEwJHQjEYMBYGA1UECBMPU291dGggWW9ya3NoaXJlMRIwEAYDVQQHEwlTaGVm\n\t\t\t\t\t\tZmllbGQxHzAdBgNVBAoTFkVxdWlub3ggUHVibGlzaGluZyBMdGQxCzAJBgNVBAsT\n\t\t\t\t\t\tAklUMRwwGgYDVQQDExNlcXVpbm94am91cm5hbHMuY29tMSUwIwYJKoZIhvcNAQkB\n\t\t\t\t\t\tFhZzdXBwb3J0QGVxdWlub3hwdWIuY29tMB4XDTEyMDQwMzIyMjkzOFoXDTIyMDQw\n\t\t\t\t\t\tMTIyMjkzOFowga4xCzAJBgNVBAYTAkdCMRgwFgYDVQQIEw9Tb3V0aCBZb3Jrc2hp\n\t\t\t\t\t\tcmUxEjAQBgNVBAcTCVNoZWZmaWVsZDEfMB0GA1UEChMWRXF1aW5veCBQdWJsaXNo\n\t\t\t\t\t\taW5nIEx0ZDELMAkGA1UECxMCSVQxHDAaBgNVBAMTE2VxdWlub3hqb3VybmFscy5j\n\t\t\t\t\t\tb20xJTAjBgkqhkiG9w0BCQEWFnN1cHBvcnRAZXF1aW5veHB1Yi5jb20wggEiMA0G\n\t\t\t\t\t\tCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDGZpYDMaxM9v0cDM+JkoNQSMRPwOUo\n\t\t\t\t\t\tiwl45P9jJh1zwJRi++9/uu9e/kQIEJmiZYowkyea2wPDYZVAukOgfkk4m+0VVoV6\n\t\t\t\t\t\tRo/mNO1jBCsVXXQ6DeT8Aq/UCI1N4LlBD9DHPp+neQZvhoQp1V1zouXqMUBTRtW+\n\t\t\t\t\t\t77h2IIidOGlaU6OS7qJLqGLQQCWZD1mxb6Sms+5Sa1xdf9WOUq3inB6gB6GReJdC\n\t\t\t\t\t\ttWInflUNrFS8mvM0lHUQs18SmulMokgb+s8xSJljpcbCMpSWKshHZjWuOmzc15a4\n\t\t\t\t\t\ta3rSgZxZDJMqioQzpGMOyd7FZEIgnBY6KFurNkha7ddISbaSmrWtnytBAgMBAAGj\n\t\t\t\t\t\tezB5MAkGA1UdEwQCMAAwLAYJYIZIAYb4QgENBB8WHU9wZW5TU0wgR2VuZXJhdGVk\n\t\t\t\t\t\tIENlcnRpZmljYXRlMB0GA1UdDgQWBBRoLYcAzpJhhw9sBy/6ACALL0qpczAfBgNV\n\t\t\t\t\t\tHSMEGDAWgBRoLYcAzpJhhw9sBy/6ACALL0qpczANBgkqhkiG9w0BAQUFAAOCAQEA\n\t\t\t\t\t\tSqIXjnqGhkkRA5cSJherE2uyt7eDmA7VXbJjGV+KgM4dWf+R+Y81NzYuddknTeGZ\n\t\t\t\t\t\teQTcGy67dYnzDan8ZN+AfS98NgHx4qaTI+rwq5/0Vo+MaG57NiGUt6pkR1LKTbtw\n\t\t\t\t\t\tZf8QgAhLAWH66w4tK+/507XY5GS+Cfkjznnm2hT6pftCg13mMO4YFGzH7LUwPYSR\n\t\t\t\t\t\tUdH7G5kkGwV0FhZaDP0e5SKWfHGjihDcw5RbOLiD5hv7m1Ls7PDKPR+izh+40wf/\n\t\t\t\t\t\td0RO7oiZKGZjtKMvJPh++lYFflUPLH/lmg3nzKYmwTdJFmC4m9NL+9QRn0Ned2D8\n\t\t\t\t\t\tpztQ4C1nPvNFJOO9MeGj6g=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.equinoxpub.com/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://eduspot.ens-cachan.fr/authsaml2/metadata",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "eduspot@ens-cachan.fr"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://eduspot.ens-cachan.fr/authsaml2/metadata",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://services.renater.fr/federation/en/metadata_registration_practice_statement"
              }
            ],
            "registration_instant": "2012-04-12T10:48:28Z",
            "registration_authority": "https://federation.renater.fr/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "https://federation.renater.fr/category/wifi"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "https://federation.renater.fr/scope/national"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Ecole Normale Sup\u00e9rieure de Cachan"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ens-cachan.fr"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Ecole Normale Sup\u00e9rieure de Cachan"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://eduspot.ens-cachan.fr"
                  }
                ],
                "description": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Acc\u00e8s aux Wifi pour les participants au projet Eduspot via le portail captif Univnautes."
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "ENS de Cachan - Portail Eduspot"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "ENS de Cachan - Portail Eduspot"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEpDCCA4ygAwIBAgIQeTFgbQWRlGanItIwtJ/w0jANBgkqhkiG9w0BAQsFADBk\nMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJ\nQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wg\nQ0EgMjAeFw0xNDEwMTcwMDAwMDBaFw0xNzEwMTYyMzU5NTlaMEMxITAfBgNVBAsT\nGERvbWFpbiBDb250cm9sIFZhbGlkYXRlZDEeMBwGA1UEAxMVZWR1c3BvdC5lbnMt\nY2FjaGFuLmZyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuNjLcYRU\nVIYvwbFG89dp+n0NMsDR6SrHZ/AMit0airV2ReNm1H+Wcuq0UGQKLsrhytQsL3vK\nlgBCbUi2LbIFlPubTIBx8pNoH8AkBcOyfg1kiN2yJ4z+gaqjoy+gp7zChSKhga3D\nLsIkAfBK2hKiw+t1Cod/LCgbeBdGKnB4gDTZScYf8r3rSIyE1mtDI93VJfsMHkKD\nj3WOmhAnoT1KDXFHI1utdUwyM/u2nGgAjgupEbDTAOfx/N56/yUkR88Q22itXKdS\nEr3v66gp0CJluEPUFTmmCCdklnv12rFR16hrgm/fiZWyj6z9BtRQUW6cC35fDtmq\n9CMXI8aYdpMTEwIDAQABo4IBcTCCAW0wHwYDVR0jBBgwFoAUW9CKHJoyW+C13ZZU\nG+GGKLD9tr0wHQYDVR0OBBYEFHeYAb+69vprObDtE1PM63PWKio0MA4GA1UdDwEB\n/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEF\nBQcDAjAiBgNVHSAEGzAZMA0GCysGAQQBsjEBAgIdMAgGBmeBDAECATA6BgNVHR8E\nMzAxMC+gLaArhilodHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVEVSRU5BU1NMQ0Ey\nLmNybDBsBggrBgEFBQcBAQRgMF4wNQYIKwYBBQUHMAKGKWh0dHA6Ly9jcnQudXNl\ncnRydXN0LmNvbS9URVJFTkFTU0xDQTIuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8v\nb2NzcC51c2VydHJ1c3QuY29tMCAGA1UdEQQZMBeCFWVkdXNwb3QuZW5zLWNhY2hh\nbi5mcjANBgkqhkiG9w0BAQsFAAOCAQEANOYe63FGB6CrqW/Hl8uRbBrJsYHnzknp\nh6NjKRuvnzeOOOrDVW75T3//6AepZzJ0k1ZzzYIYJ0crBavEEo9L5AvwMPvs7mYw\nRAUTEMhGTm/nYQct1jwbCgNKCDgYuydZUcixtiq3LXz1SglHXGNhg+SLGCGXrHrJ\nJxuaneWu5FgReUB3EDUC0bCrM9nx2cHitLtox3aXU/fhiPXCEkP2HV4DnjLu3fBJ\nS5gBayfEa2U6VDzvwdEk71Pw3PKsdEl7f9N5mp3rpjvr36r5TH5LXhbk0utRGo7u\nyn+WFioypXnVKl7dgWzQsVdGI4NnnsfGgmah+vJMEtRPPnBtjRrV3A=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEpDCCA4ygAwIBAgIQeTFgbQWRlGanItIwtJ/w0jANBgkqhkiG9w0BAQsFADBk\nMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJ\nQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wg\nQ0EgMjAeFw0xNDEwMTcwMDAwMDBaFw0xNzEwMTYyMzU5NTlaMEMxITAfBgNVBAsT\nGERvbWFpbiBDb250cm9sIFZhbGlkYXRlZDEeMBwGA1UEAxMVZWR1c3BvdC5lbnMt\nY2FjaGFuLmZyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuNjLcYRU\nVIYvwbFG89dp+n0NMsDR6SrHZ/AMit0airV2ReNm1H+Wcuq0UGQKLsrhytQsL3vK\nlgBCbUi2LbIFlPubTIBx8pNoH8AkBcOyfg1kiN2yJ4z+gaqjoy+gp7zChSKhga3D\nLsIkAfBK2hKiw+t1Cod/LCgbeBdGKnB4gDTZScYf8r3rSIyE1mtDI93VJfsMHkKD\nj3WOmhAnoT1KDXFHI1utdUwyM/u2nGgAjgupEbDTAOfx/N56/yUkR88Q22itXKdS\nEr3v66gp0CJluEPUFTmmCCdklnv12rFR16hrgm/fiZWyj6z9BtRQUW6cC35fDtmq\n9CMXI8aYdpMTEwIDAQABo4IBcTCCAW0wHwYDVR0jBBgwFoAUW9CKHJoyW+C13ZZU\nG+GGKLD9tr0wHQYDVR0OBBYEFHeYAb+69vprObDtE1PM63PWKio0MA4GA1UdDwEB\n/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEF\nBQcDAjAiBgNVHSAEGzAZMA0GCysGAQQBsjEBAgIdMAgGBmeBDAECATA6BgNVHR8E\nMzAxMC+gLaArhilodHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVEVSRU5BU1NMQ0Ey\nLmNybDBsBggrBgEFBQcBAQRgMF4wNQYIKwYBBQUHMAKGKWh0dHA6Ly9jcnQudXNl\ncnRydXN0LmNvbS9URVJFTkFTU0xDQTIuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8v\nb2NzcC51c2VydHJ1c3QuY29tMCAGA1UdEQQZMBeCFWVkdXNwb3QuZW5zLWNhY2hh\nbi5mcjANBgkqhkiG9w0BAQsFAAOCAQEANOYe63FGB6CrqW/Hl8uRbBrJsYHnzknp\nh6NjKRuvnzeOOOrDVW75T3//6AepZzJ0k1ZzzYIYJ0crBavEEo9L5AvwMPvs7mYw\nRAUTEMhGTm/nYQct1jwbCgNKCDgYuydZUcixtiq3LXz1SglHXGNhg+SLGCGXrHrJ\nJxuaneWu5FgReUB3EDUC0bCrM9nx2cHitLtox3aXU/fhiPXCEkP2HV4DnjLu3fBJ\nS5gBayfEa2U6VDzvwdEk71Pw3PKsdEl7f9N5mp3rpjvr36r5TH5LXhbk0utRGo7u\nyn+WFioypXnVKl7dgWzQsVdGI4NnnsfGgmah+vJMEtRPPnBtjRrV3A=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDTDCCAjQCCQCR6CZCuHxqRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJG\nUjErMCkGA1UEChMiRUNPTEUgTk9STUFMRSBTVVBFUklFVVJFIERFIENBQ0hBTjEM\nMAoGA1UECxMDRFNJMR4wHAYDVQQDExVlZHVzcG90LmVucy1jYWNoYW4uZnIwHhcN\nMTQwNDE0MTIzNjI4WhcNMTUwNDE0MTIzNjI4WjBoMQswCQYDVQQGEwJGUjErMCkG\nA1UEChMiRUNPTEUgTk9STUFMRSBTVVBFUklFVVJFIERFIENBQ0hBTjEMMAoGA1UE\nCxMDRFNJMR4wHAYDVQQDExVlZHVzcG90LmVucy1jYWNoYW4uZnIwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaN/r/9eegiIWfM7W+cBepylzyQKasGNVV\npOGqQtClO+RDnHw1e+VjLofvQkCrkXqO0Yk2+3fFluaVEKefRhz87KkfCwqmmMVv\nN7QPL7wdjefp7z0QQQd500er/lWzNEZ16noFKNAKIVQ7L8nwEID2szf2o7lwiHUM\nI0/WYrcHtglX+KFiKCajf8lMQHQlnLvrODzBvZPuY+hcjyPMet8C77jsQs9KcBa/\nWOZ0XHwpfP6qSedCp1feHWNG/6H/ngPhFH+Yfh8dCYvnf8evL+WKL+b2L22s009K\n6pGpup0ZJaS2UbMblHeOCRf9kfT6peLwcOawPi9M7W68vSBtNd4DAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAAm4J2729rV0T1ZHR7GhruA+x8Kt0SXeXwvng8Zuaijz\nNSNK9Ej3j9Y/NRYKPTPAm2fGCrbbr89lZ+0680b6ZqicZU2c4juHe0u5/5zN1wmV\nh98Us4F37tUL4aT6fvi+FTJUkeHR3ZV/wGkdbzTLWqKqVQ8POO8Q55DZEjIrFiq3\nLmIbOYK8bfdAZTc2XWVsU1bNQyJMY6Qiu2mA1VTc61b5gUI94RmMpfEP0hl7DBgh\nKIz/GZRjl9UB3x6EEgmPi+ihRwPs/tQORLZpaS9pyqdPzrH3NuP/iVO5Dv/D7Ss9\nU3vIxlLV3X9ESLFrZiZgFRyKOqQOri3RHniJ7Yt9v+k="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://eduspot.ens-cachan.fr/authsaml2/singleSignOnPost",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "fr",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "ENS de Cachan - Portail Eduspot"
                }
              ],
              "service_description": [
                {
                  "lang": "fr",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Acc\u00e8s aux Wifi pour les participants au projet Eduspot via le portail captif Univnautes."
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "mail",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "displayName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.16.840.1.113730.3.1.241",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "https://sp.uk-plc.net/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:support@cloudbuy.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "@UK PLC Customer Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Roberts"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:paul.roberts@cloudbuy.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Paul"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://sp.uk-plc.net/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2011-01-18T18:08:20Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "@UK PLC"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uk-plc.net/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Cloudbuy PLC"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "authn_requests_signed": "1",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC7jCCAdagAwIBAgIJAIV70zuQ2vBVMA0GCSqGSIb3DQEBBQUAMBgxFjAUBgNV\n\t\t\t\t\t\tBAMTDXNwLnVrLXBsYy5uZXQwHhcNMTEwMTE3MTEwNDU5WhcNMjEwMTE0MTEwNDU5\n\t\t\t\t\t\tWjAYMRYwFAYDVQQDEw1zcC51ay1wbGMubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOC\n\t\t\t\t\t\tAQ8AMIIBCgKCAQEAm69+UMm20EyOMmETcniHi59ED3GW+f1B+qNgCQZpP+PRNnLA\n\t\t\t\t\t\tZ0+lLrrBrAb1oDjUqt3ya45AUVcHxDuEtpQnbIsvSvQztQr/J7Il9rBAHa7MKQVl\n\t\t\t\t\t\t6vWt8VQA8njt/Zy3Zwed6CvbPyB6jBe6KrrHdqfdXBXqxXt5KbcNb4nTKUIe081p\n\t\t\t\t\t\twMkNThERBLbFg48FDsSytT2D+ERsz4Ivg8fW6kTEl7Fvx35lK4rBUQjIBcsWNuFN\n\t\t\t\t\t\thTy29mfVAZOWq0TnrzE84uYioNf5LrZiZSdmPFDarqyl9/T2Lo7OeG+8ZGxpOe8f\n\t\t\t\t\t\tBRVhqpY/xHev7S1hdHTn8f+fM59PiWA8IUN+xwIDAQABozswOTAYBgNVHREEETAP\n\t\t\t\t\t\tgg1zcC51ay1wbGMubmV0MB0GA1UdDgQWBBQm+W+pJIIr4Gh6H9Hl7CXWBYnjYTAN\n\t\t\t\t\t\tBgkqhkiG9w0BAQUFAAOCAQEAhN9iAGeAhzrOkYr5wRWcZmJTaD1XCMZsgfB2sF/Z\n\t\t\t\t\t\t+Xu8dlJ2wHw+xubq2PU7aYZRGb3QblGODdowyDzV1/hQ43/psakSBmm14VDqKu7M\n\t\t\t\t\t\t/+ZvM5hCUoGfTgXRaUXPVhDbNLJyoFewg9IEYS1UXQo6GuXoFqOf602Bd9SWpfgM\n\t\t\t\t\t\tWrjGCgrkN7arw85MqyiWoP5lEH9NMw3yyrYqEjV5L15ciszslzRCLsMF2viSpJDH\n\t\t\t\t\t\trmLaDUQp1MFaZc8ulVkIJIc2vvj4AdZ5BS3N8qsPc6+l4E7aunsP/WXxxFqT8VVa\n\t\t\t\t\t\tvkVcbTLRcJHyGdZsf++gt0fT+WmWbQsVC0Y1ILG/LNkfaA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC7jCCAdagAwIBAgIJAIV70zuQ2vBVMA0GCSqGSIb3DQEBBQUAMBgxFjAUBgNV\n\t\t\t\t\t\tBAMTDXNwLnVrLXBsYy5uZXQwHhcNMTEwMTE3MTEwNDU5WhcNMjEwMTE0MTEwNDU5\n\t\t\t\t\t\tWjAYMRYwFAYDVQQDEw1zcC51ay1wbGMubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOC\n\t\t\t\t\t\tAQ8AMIIBCgKCAQEAm69+UMm20EyOMmETcniHi59ED3GW+f1B+qNgCQZpP+PRNnLA\n\t\t\t\t\t\tZ0+lLrrBrAb1oDjUqt3ya45AUVcHxDuEtpQnbIsvSvQztQr/J7Il9rBAHa7MKQVl\n\t\t\t\t\t\t6vWt8VQA8njt/Zy3Zwed6CvbPyB6jBe6KrrHdqfdXBXqxXt5KbcNb4nTKUIe081p\n\t\t\t\t\t\twMkNThERBLbFg48FDsSytT2D+ERsz4Ivg8fW6kTEl7Fvx35lK4rBUQjIBcsWNuFN\n\t\t\t\t\t\thTy29mfVAZOWq0TnrzE84uYioNf5LrZiZSdmPFDarqyl9/T2Lo7OeG+8ZGxpOe8f\n\t\t\t\t\t\tBRVhqpY/xHev7S1hdHTn8f+fM59PiWA8IUN+xwIDAQABozswOTAYBgNVHREEETAP\n\t\t\t\t\t\tgg1zcC51ay1wbGMubmV0MB0GA1UdDgQWBBQm+W+pJIIr4Gh6H9Hl7CXWBYnjYTAN\n\t\t\t\t\t\tBgkqhkiG9w0BAQUFAAOCAQEAhN9iAGeAhzrOkYr5wRWcZmJTaD1XCMZsgfB2sF/Z\n\t\t\t\t\t\t+Xu8dlJ2wHw+xubq2PU7aYZRGb3QblGODdowyDzV1/hQ43/psakSBmm14VDqKu7M\n\t\t\t\t\t\t/+ZvM5hCUoGfTgXRaUXPVhDbNLJyoFewg9IEYS1UXQo6GuXoFqOf602Bd9SWpfgM\n\t\t\t\t\t\tWrjGCgrkN7arw85MqyiWoP5lEH9NMw3yyrYqEjV5L15ciszslzRCLsMF2viSpJDH\n\t\t\t\t\t\trmLaDUQp1MFaZc8ulVkIJIc2vvj4AdZ5BS3N8qsPc6+l4E7aunsP/WXxxFqT8VVa\n\t\t\t\t\t\tvkVcbTLRcJHyGdZsf++gt0fT+WmWbQsVC0Y1ILG/LNkfaA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://sp.uk-plc.net/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "http://adfs.hanze.nl/adfs/services/trust",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "help@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "http://adfs.hanze.nl/adfs/services/trust",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://wiki.surfnet.nl/display/eduGAIN/EduGAIN"
              }
            ],
            "registration_instant": "2015-05-12T10:50:00Z",
            "registration_authority": "http://www.surfconext.nl/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://engine.surfconext.nl/authentication/idp/single-sign-on/f5401f60caf9e9a56c1517c24d5c0546",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Hanzehogeschool Groningen"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Hanzehogeschool Groningen"
                  }
                ],
                "logo": [
                  {
                    "text": "https://static.surfconext.nl/logos/idp/hanze.png",
                    "height": "26",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "108"
                  }
                ],
                "display_name": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Hanzehogeschool Groningen"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Hanze University Groningen"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID3zCCAsegAwIBAgIJAMVC9xn1ZfsuMA0GCSqGSIb3DQEBCwUAMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTAeFw0xNDA1MDUxNDIyMzVaFw0xOTA1MDUxNDIyMzVaMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKthMDbB0jKHefPzmRu9t2h7iLP4wAXr42bHpjzTEk6gttHFb4l/hFiz1YBI88TjiH6hVjnozo/YHA2c51us+Y7g0XoS7653lbUN/EHzvDMuyis4Xi2Ijf1A/OUQfH1iFUWttIgtWK9+fatXoGUS6tirQvrzVh6ZstEp1xbpo1SF6UoVl+fh7tM81qz+Crr/Kroan0UjpZOFTwxPoK6fdLgMAieKSCRmBGpbJHbQ2xxbdykBBrBbdfzIX4CDepfjE9h/40ldw5jRn3e392jrS6htk23N9BWWrpBT5QCk0kH3h/6F1Dm6TkyG9CDtt73/anuRkvXbeygI4wml9bL3rE8CAwEAAaNQME4wHQYDVR0OBBYEFD+Ac7akFxaMhBQAjVfvgGfY8hNKMB8GA1UdIwQYMBaAFD+Ac7akFxaMhBQAjVfvgGfY8hNKMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAC8L9D67CxIhGo5aGVu63WqRHBNOdo/FAGI7LURDFeRmG5nRw/VXzJLGJksh4FSkx7aPrxNWF1uFiDZ80EuYQuIv7bDLblK31ZEbdg1R9LgiZCdYSr464I7yXQY9o6FiNtSKZkQO8EsscJPPy/Zp4uHAnADWACkOUHiCbcKiUUFu66dX0Wr/v53Gekz487GgVRs8HEeT9MU1reBKRgdENR8PNg4rbQfLc3YQKLWK7yWnn/RenjDpuCiePj8N8/80tGgrNgK/6fzM3zI18sSywnXLswxqDb/J+jgVxnQ6MrsTf1urM8MnfcxG/82oHIwfMh/sXPCZpo+DTLkhQxctJ3M="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Hanzehogeschool Groningen"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Hanze University Groningen"
          }
        ],
        "organization_url": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.hanze.nl"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.hanze.nl"
          }
        ],
        "organization_name": [
          {
            "lang": "nl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Hanzehogeschool Groningen"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Hanze University Groningen"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://federation.upf.pf/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "dsi@upf.pf"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://federation.upf.pf/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://services.renater.fr/federation/en/metadata_registration_practice_statement"
              }
            ],
            "registration_instant": "2013-05-31T22:29:12Z",
            "registration_authority": "https://federation.renater.fr/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://federation.upf.pf/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://federation.upf.pf/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://federation.upf.pf/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "upf.pf"
              },
              {
                "information_url": [
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.upf.pf"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Employee, Student"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Personnels, Etudiants"
                  }
                ],
                "logo": [
                  {
                    "text": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACj0lEQVQ4y32ROWhUURSGv3vfe8mbyUycJGqhIIiCksLCFSyChagYOxuLFDYi2AmWFjYWYqMgYiVYiBEsRERDIm4gKBGNO65xmzczbzJZZiYzb7v3WsQ4UdG/+Ytzznd+zhH8IfNyUCCdvdjuAFF1HfUS1EuvaE5ewnIui91n1MJ+8cdwF7mVgxp2mEYRM1tAVz101UPN+HQk9VHs9F4xcP3bXwDz+opLz+r7WqtNBCVMUICmh254mHoBVfVR01NkjPUR3I3i4ONpAPlrfbrnqBFiE0kF9ASCMsIqYaw80i0g0x5WdpK6qK3C1I/Nj0kA8+qiQ3v2EFEFkUwgjI8RHkfP3kG4X9HueypxHis7jZVtop1ovznf67QS2GKtVrNdxGUwPsgiNx+84O7oFHbnW/YfF5DWyEyITM/StMJFdHSvbQFU0yEsY5Iy6CJCejx/V2T8G5y66HDnYRs1JZEpEO0Bsj0G104D2ACUbhNVn2AvtrA6DWRqNMMmQjg8fekghODCtTTHD8wgbAWWAqlpAXSCDsqYRgVcAwrCKAc4v25cq//2cX47IgrC2MUoiYmBGJJo/r8/XYNJgMQCZYGWCxLYizEqi0lCdNRABEAyV0LNudE2OupAJylUnAHZswDQdzKayVdwly1jZHiYZDKm0TYEXMWkdwEjqK59hFtOE8cxY2PP2LZ1A2DPAfw4RbmpOHH4CFgOYRCQ615C365+Vvb2sqd7KZlcjkdvxhFS8t6bYHnNaiXIB1CILDo278T3fSr5r3z2p1AmRfljgbZUBj92+X7jHuu39+PFKTprtABDkzBWdXmQWUPkroYVW/mXbn2YIv4yzaeJBYBzHomf10W8IqiE/0orqCYEs8QAPwDg+DjjvXHUEgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0wNy0yMFQxMDo1MDowNSswMjowMLubGZsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMDctMjBUMTA6NTA6MDUrMDI6MDDKxqEnAAAAAElFTkSuQmCC",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of French Polynesia"
                  },
                  {
                    "lang": "fr",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Universit\u00e9 de Polyn\u00e9sie fran\u00e7aise"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDLzCCAhegAwIBAgIUFC0XwDnBlYK71GiAUaF7vx7MRXIwDQYJKoZIhvcNAQEF\nBQAwHDEaMBgGA1UEAxMRZmVkZXJhdGlvbi51cGYucGYwHhcNMTMwNDE4MDI1NjA5\nWhcNMzMwNDE4MDI1NjA5WjAcMRowGAYDVQQDExFmZWRlcmF0aW9uLnVwZi5wZjCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMKdTj5nsNnLZKNJKeb8m9lf\neGVP3AjbhAJo0Fc0KjE3mFUUOc8ScnvT5ms3tD3fvY4OM57ysI+6fXIfqks+K3fU\np6dbTUUA7EayO/AXEeEZIYmGobqhFbf/+HL+XbaNj6Fu66otgU83ENyz9hWKsd7L\nUoKc/IpYYb5lxRiZObLsD3cZLkQUdaEKmVqBnsl4QBRFgqbbujg9+b9yGc7S6tWt\ntiz0VU9mmDzYz7RvUg3rlxrt/XHTdv9pyNIBfXyWbHwBl20x9RLWantPh5B/gzMg\nNG9Gsxrg2s6jOJkWExAaJui9udv6ZG4Om006MXimSQQJQjefxaFf5tMPkohQuQMC\nAwEAAaNpMGcwRgYDVR0RBD8wPYIRZmVkZXJhdGlvbi51cGYucGaGKGh0dHBzOi8v\nZmVkZXJhdGlvbi51cGYucGYvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFErV+rWb\ndP0OnShtmHsMw4ScsryqMA0GCSqGSIb3DQEBBQUAA4IBAQCQtbM/X3jSinJzQ/iM\nGssEbM/bT5sysN1Y1rsSXCn/Voy27ikk5WN5dbfWZZ1KIYnZtFvJwk3JUUpAXvYS\nTjDkoYhatlfdXSR0ZDJUrtGeo+Rpf8s4Y1UX6EuiywKKU/rxUaGs5m4sG94Xixys\n+/WSNcRFx+Oub984KlUVGNJdFsW4QJhLm0SIlzhn1XmHyF8Zk6111bBBVXVGqO7r\nbA2FN5TC8+oLwbU4vngFuLBu3cNt0xDE5C3760iVBLU++kah8FBjAZQsK0dnXyM3\nJlfc1EsNYvnxkLXlrcZIC5yU8s+4ht45VLUahR9HNHB+sCw9hGlcbV3QigKTlJav\npbip"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Universit\u00e9 de Polyn\u00e9sie fran\u00e7aise"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.upf.pf"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Universit\u00e9 de Polyn\u00e9sie fran\u00e7aise"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://manage.federations.renam.md",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Pocotilenco"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:leaf@renam.md"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Valentin"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://manage.federations.renam.md",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://federations.renam.md"
              }
            ],
            "registration_instant": "2015-12-01T08:00:00Z",
            "registration_authority": "http://federations.renam.md/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "ro",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "RENAM"
          },
          {
            "lang": "ru",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "RENAM"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "RENAM"
          }
        ],
        "organization_url": [
          {
            "lang": "ro",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://renam.md"
          },
          {
            "lang": "ru",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://renam.md"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://renam.md"
          }
        ],
        "organization_name": [
          {
            "lang": "ro",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "RENAM"
          },
          {
            "lang": "ru",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "RENAM"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "RENAM"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml2-logout.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml2-logout.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://manage.federations.renam.md"
                  },
                  {
                    "lang": "ro",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://manage.federations.renam.md"
                  },
                  {
                    "lang": "ru",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://manage.federations.renam.md"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Federation Management Board - used to manage federation entitites and generate metadata"
                  },
                  {
                    "lang": "ro",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Sistem de Management al Federatiei - necesara pentru managementul entitatilor federative si generarea metadatelor"
                  },
                  {
                    "lang": "ru",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043c\u0435\u043d\u0435\u0434\u0436\u043c\u0435\u043d\u0442\u0430 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 - \u043d\u0435\u043e\u0434\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c\u0438 \u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043c\u0430\u0442\u0430-\u0434\u0430\u043d\u043d\u044b\u0445"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Federation Management Board"
                  },
                  {
                    "lang": "ro",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Sistem de Management al Federatiei"
                  },
                  {
                    "lang": "ru",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043c\u0435\u043d\u0435\u0434\u0436\u043c\u0435\u043d\u0442\u0430 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE6zCCA9OgAwIBAgICANMwDQYJKoZIhvcNAQELBQAwdDESMBAGCgmSJomT8ixk\nARkTAk1EMRcwFQYKCZImiZPyLGQBGRMHTUQtR3JpZDEOMAwGA1UEChMFUkVOQU0x\nIDAeBgNVBAsTF0NlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQDEwpNRC1H\ncmlkIENBMB4XDTE1MTEyNTA4MzEyNFoXDTI1MTEyMjA4MzEyNFowYDESMBAGCgmS\nJomT8ixkARkWAk1EMRowGAYKCZImiZPyLGQBGRYKRmVkZXJhdGlvbjEOMAwGA1UE\nChMFUkVOQU0xHjAcBgNVBAMTFU1hbmFnZVNlcnZpY2VNZXRhU2lnbjCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN0ctV8e4QOli52mhR6sc4MImsPDodie\nhe/uqVoAfhsxumuf6vR5oHvgy4QQGC/zJxEfWbI2hKlCCkH9tRBerYgu90vMMCZe\nd+INTGvskp28hDXki1Luj5DnzcTjuF9M7M8PRfa/nmYp5e33+Kh87UX6Jo9ekWMr\npEKMEgR2UeJt+2vzQGDCYrI2NhDX1u20eZfVBP+gJNkxFSLH+cXICMe2P3z8vy5g\nL22wdJC+ep7XCqPPpRn50qKJF2nT0aopMggY7cCBxo0QAkt9t3qCvwTnHasMU+Ov\n9I0+TLJ2exn8/vBA1nicToanXyZNlYjD1kJHsw0gWh+a+1wHG/kkfe8CAwEAAaOC\nAZkwggGVMB0GA1UdDgQWBBRgFwRz+fla6Dkajz7A+0RDKvolTjAfBgNVHSMEGDAW\ngBQHQ26bo1u5q+z02L86Gw2jKbg1YjA6BggrBgEFBQcBAQQuMCwwKgYIKwYBBQUH\nMAKGHmh0dHA6Ly9jYS5ncmlkLm1kL2ZpbGVzL2NhLmNydDAzBgNVHR8ELDAqMCig\nJqAkhiJodHRwOi8vY2EuZ3JpZC5tZC9maWxlcy9jcmwtdjIuY3JsMCkGA1UdEgQi\nMCCBC2NhQHJlbmFtLm1khhFodHRwOi8vY2EuZ3JpZC5tZDCBtgYDVR0gBIGuMIGr\nMA4GDCsGAQQBgfNaCgEBBDCBmAYKKoZIhvdMBQICATCBiTA2BggrBgEFBQcCARYq\naHR0cDovL2NhLmdyaWQubWQvZmlsZXMvTUQtR3JpZC1DUC1DUFMucGRmME8GCCsG\nAQUFBwICMEMaQUxpbWl0ZWQgTGlhYmlsaXR5LCBzZWUgaHR0cDovL2NhLmdyaWQu\nbWQvZmlsZXMvTUQtR3JpZC1DUC1DUFMucGRmMA0GCSqGSIb3DQEBCwUAA4IBAQC6\nKJuZeroALfPd32ft7vDVrU2olrWlK83Xvgjy6BRbd9ksBxuFUCAYbZxYWhWiNCUG\n2xn7nKLWjs51sSeDqFPVzNsAaU/MGr3TvFcxH1gyaIZQNkXVZcRbi93SdVfmnl9Z\n1R86aJxShVN6wOTAWyMSkzh3VGVGK9IeA57WoDAGuxvDVgxURO+lpkY0QztOMK9m\nDOFfR5TiqEahO0z7zUInQbg7LEgwDazK7BuDbirKdQhncGYCVG1dg3Qq09vJdSS4\nUgVNSVjlMzKBjhjGa9KhyOQZozleonKnk1o/cblzPGClGgcZeqElC6YXDpJzlSqt\nQDG9g0AnMyza3V7kLiDz"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE6zCCA9OgAwIBAgICANMwDQYJKoZIhvcNAQELBQAwdDESMBAGCgmSJomT8ixk\nARkTAk1EMRcwFQYKCZImiZPyLGQBGRMHTUQtR3JpZDEOMAwGA1UEChMFUkVOQU0x\nIDAeBgNVBAsTF0NlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQDEwpNRC1H\ncmlkIENBMB4XDTE1MTEyNTA4MzEyNFoXDTI1MTEyMjA4MzEyNFowYDESMBAGCgmS\nJomT8ixkARkWAk1EMRowGAYKCZImiZPyLGQBGRYKRmVkZXJhdGlvbjEOMAwGA1UE\nChMFUkVOQU0xHjAcBgNVBAMTFU1hbmFnZVNlcnZpY2VNZXRhU2lnbjCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN0ctV8e4QOli52mhR6sc4MImsPDodie\nhe/uqVoAfhsxumuf6vR5oHvgy4QQGC/zJxEfWbI2hKlCCkH9tRBerYgu90vMMCZe\nd+INTGvskp28hDXki1Luj5DnzcTjuF9M7M8PRfa/nmYp5e33+Kh87UX6Jo9ekWMr\npEKMEgR2UeJt+2vzQGDCYrI2NhDX1u20eZfVBP+gJNkxFSLH+cXICMe2P3z8vy5g\nL22wdJC+ep7XCqPPpRn50qKJF2nT0aopMggY7cCBxo0QAkt9t3qCvwTnHasMU+Ov\n9I0+TLJ2exn8/vBA1nicToanXyZNlYjD1kJHsw0gWh+a+1wHG/kkfe8CAwEAAaOC\nAZkwggGVMB0GA1UdDgQWBBRgFwRz+fla6Dkajz7A+0RDKvolTjAfBgNVHSMEGDAW\ngBQHQ26bo1u5q+z02L86Gw2jKbg1YjA6BggrBgEFBQcBAQQuMCwwKgYIKwYBBQUH\nMAKGHmh0dHA6Ly9jYS5ncmlkLm1kL2ZpbGVzL2NhLmNydDAzBgNVHR8ELDAqMCig\nJqAkhiJodHRwOi8vY2EuZ3JpZC5tZC9maWxlcy9jcmwtdjIuY3JsMCkGA1UdEgQi\nMCCBC2NhQHJlbmFtLm1khhFodHRwOi8vY2EuZ3JpZC5tZDCBtgYDVR0gBIGuMIGr\nMA4GDCsGAQQBgfNaCgEBBDCBmAYKKoZIhvdMBQICATCBiTA2BggrBgEFBQcCARYq\naHR0cDovL2NhLmdyaWQubWQvZmlsZXMvTUQtR3JpZC1DUC1DUFMucGRmME8GCCsG\nAQUFBwICMEMaQUxpbWl0ZWQgTGlhYmlsaXR5LCBzZWUgaHR0cDovL2NhLmdyaWQu\nbWQvZmlsZXMvTUQtR3JpZC1DUC1DUFMucGRmMA0GCSqGSIb3DQEBCwUAA4IBAQC6\nKJuZeroALfPd32ft7vDVrU2olrWlK83Xvgjy6BRbd9ksBxuFUCAYbZxYWhWiNCUG\n2xn7nKLWjs51sSeDqFPVzNsAaU/MGr3TvFcxH1gyaIZQNkXVZcRbi93SdVfmnl9Z\n1R86aJxShVN6wOTAWyMSkzh3VGVGK9IeA57WoDAGuxvDVgxURO+lpkY0QztOMK9m\nDOFfR5TiqEahO0z7zUInQbg7LEgwDazK7BuDbirKdQhncGYCVG1dg3Qq09vJdSS4\nUgVNSVjlMzKBjhjGa9KhyOQZozleonKnk1o/cblzPGClGgcZeqElC6YXDpJzlSqt\nQDG9g0AnMyza3V7kLiDz"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml1-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://manage.federations.renam.md/ssphp/module.php/saml/sp/saml1-acs.php/default-sp/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "Federation Management Board"
                },
                {
                  "lang": "ro",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "Sistem de Management al Federatiei"
                },
                {
                  "lang": "ru",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043c\u0435\u043d\u0435\u0434\u0436\u043c\u0435\u043d\u0442\u0430 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Federation Management Board - used to manage federation entitites and generate metadata"
                },
                {
                  "lang": "ro",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Sistem de Management al Federatiei - necesara pentru managementul entitatilor federative si generarea metadatelor"
                },
                {
                  "lang": "ru",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043c\u0435\u043d\u0435\u0434\u0436\u043c\u0435\u043d\u0442\u0430 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 - \u043d\u0435\u043e\u0434\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c\u0438 \u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043c\u0430\u0442\u0430-\u0434\u0430\u043d\u043d\u044b\u0445"
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "surname",
                  "is_required": "false",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "givenName",
                  "is_required": "false",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "uid",
                  "is_required": "false",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.1",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "commonName",
                  "is_required": "false",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "transientId",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.2.3.4.5.6.7.8.9.10",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "urn:mace:incommon:rock.k12.nc.us",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "ksensenich@rock.k12.nc.us"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Kacey Sensenich"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "wgoins@rock.k12.nc.us"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Wanda Goins"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "urn:mace:incommon:rock.k12.nc.us",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDPjCCAiagAwIBAgIJAPmR55t2JpqLMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWIucm9jay5rMTIubmMudXMwHhcNMTMxMjE4MTcxMzAxWhcNMzQwMTA4\nMTcxMzAxWjAeMRwwGgYDVQQDExNzaGliLnJvY2suazEyLm5jLnVzMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlBZdzVkY+qjXvyQSQ+OWA6fTFgvtmAZW\nw9KIs5IvL0trjOwMZLjGYWzUpRcirb9EW6XLC5A2ZW/FuVfIHYO70EOczz+7pW4h\n8JTHbhdm3nqC1OWeRv3RpKL0N+MHBVIV+3F85xPpWVqVTzpePA98HRKaJkjLPtcm\nHWYrA1+j6jUXIpdOs4BKuywQCTF62NHovNyV7Q+Dq2x3RmXRNSNCobXgvja1jXnC\nDISVtj52UDsjZC8WONKbQ+Rx7qWlFGYqiCJ77m0+rj7HCDaxIWC5qzRSfY8T1DIn\nNUS8bR50+JhV76cIzgvkq9K1uvlZoXkAMdo1t4G2otTJC8HjnSRvdwIDAQABo38w\nfTAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5zJIowTgYDVR0jBEcwRYAUruM5\ns76Piz3hAqGOEkjj+R5zJIqhIqQgMB4xHDAaBgNVBAMTE3NoaWIucm9jay5rMTIu\nbmMudXOCCQD5keebdiaaizAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBs9xg8DRa/Ph2e+ysJCjFAbo13N0C9tKHEjZlxQsuRVCFVsjBSB6RSMpKJdhlU\nJ7D11R7XhUR/w6dMlz1Wa03FOYbLh4xEACQ2KOhilYXFEF5ucrRbtc/RmfnFf2ag\n+ENPkZ+gwZytp9W7XWQQ9xYVe3jw8nNH5/+D9PKDHaoPCxLMzqFcUL6NNOC6HQ6n\nrUL38YTy5o779bOJWt7b7V3V/u4/Ckc5xIYHTgZWBo9o1GWpgNkszitRBBiQryZf\n8b7euuy4mlqaPv6zyudJOcHupn8GhHdekfNicDem60M4vl96TpHurp9ifSH2NGEb\nj0Gw0iewVqKmJYc2NtrfKI3T"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDPjCCAiagAwIBAgIJANtc2N1zb53NMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWIucm9jay5rMTIubmMudXMwHhcNMTEwNDA3MTQxMDU3WhcNMTQwNDA2\nMTQxMDU3WjAeMRwwGgYDVQQDExNzaGliLnJvY2suazEyLm5jLnVzMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlBZdzVkY+qjXvyQSQ+OWA6fTFgvtmAZW\nw9KIs5IvL0trjOwMZLjGYWzUpRcirb9EW6XLC5A2ZW/FuVfIHYO70EOczz+7pW4h\n8JTHbhdm3nqC1OWeRv3RpKL0N+MHBVIV+3F85xPpWVqVTzpePA98HRKaJkjLPtcm\nHWYrA1+j6jUXIpdOs4BKuywQCTF62NHovNyV7Q+Dq2x3RmXRNSNCobXgvja1jXnC\nDISVtj52UDsjZC8WONKbQ+Rx7qWlFGYqiCJ77m0+rj7HCDaxIWC5qzRSfY8T1DIn\nNUS8bR50+JhV76cIzgvkq9K1uvlZoXkAMdo1t4G2otTJC8HjnSRvdwIDAQABo38w\nfTAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5zJIowTgYDVR0jBEcwRYAUruM5\ns76Piz3hAqGOEkjj+R5zJIqhIqQgMB4xHDAaBgNVBAMTE3NoaWIucm9jay5rMTIu\nbmMudXOCCQDbXNjdc2+dzTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBsz6rnvJbbWYSsOW1ZQRa6d4MwOQJyC1MSlVBWgkF78tROYcd4odLNJPWB26Vs\nVJOlu173WyK26NdTPk35aAI0Y6Hl927DTyoa+GQM//JKM9CUXvhBGr9Ly5+fcKYO\nylAMffw3Mgw18H6IejfhvJZgF64Dysp+IZe+8WPhPuzqJwSlkLdS9HXNHyxBHtBl\nagNbI0Gj1/d2JrAMlId3wZu1Z/tbZHndIypnUTW/PToLtkUjlrH8naMXYx3oTuP6\nOzXh12tNCnBxCY6icNDRtdN30nH0uDt11VfENHv5C5mKxr7w2uDTLdBjEL0HPh0m\nr1ynZK4DSpncepmCHNLOHwCG"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "rock.k12.nc.us"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shib.rock.k12.nc.us/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "rock.k12.nc.us"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Rockingham County Schools"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDPjCCAiagAwIBAgIJAPmR55t2JpqLMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWIucm9jay5rMTIubmMudXMwHhcNMTMxMjE4MTcxMzAxWhcNMzQwMTA4\nMTcxMzAxWjAeMRwwGgYDVQQDExNzaGliLnJvY2suazEyLm5jLnVzMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlBZdzVkY+qjXvyQSQ+OWA6fTFgvtmAZW\nw9KIs5IvL0trjOwMZLjGYWzUpRcirb9EW6XLC5A2ZW/FuVfIHYO70EOczz+7pW4h\n8JTHbhdm3nqC1OWeRv3RpKL0N+MHBVIV+3F85xPpWVqVTzpePA98HRKaJkjLPtcm\nHWYrA1+j6jUXIpdOs4BKuywQCTF62NHovNyV7Q+Dq2x3RmXRNSNCobXgvja1jXnC\nDISVtj52UDsjZC8WONKbQ+Rx7qWlFGYqiCJ77m0+rj7HCDaxIWC5qzRSfY8T1DIn\nNUS8bR50+JhV76cIzgvkq9K1uvlZoXkAMdo1t4G2otTJC8HjnSRvdwIDAQABo38w\nfTAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5zJIowTgYDVR0jBEcwRYAUruM5\ns76Piz3hAqGOEkjj+R5zJIqhIqQgMB4xHDAaBgNVBAMTE3NoaWIucm9jay5rMTIu\nbmMudXOCCQD5keebdiaaizAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBs9xg8DRa/Ph2e+ysJCjFAbo13N0C9tKHEjZlxQsuRVCFVsjBSB6RSMpKJdhlU\nJ7D11R7XhUR/w6dMlz1Wa03FOYbLh4xEACQ2KOhilYXFEF5ucrRbtc/RmfnFf2ag\n+ENPkZ+gwZytp9W7XWQQ9xYVe3jw8nNH5/+D9PKDHaoPCxLMzqFcUL6NNOC6HQ6n\nrUL38YTy5o779bOJWt7b7V3V/u4/Ckc5xIYHTgZWBo9o1GWpgNkszitRBBiQryZf\n8b7euuy4mlqaPv6zyudJOcHupn8GhHdekfNicDem60M4vl96TpHurp9ifSH2NGEb\nj0Gw0iewVqKmJYc2NtrfKI3T"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDPjCCAiagAwIBAgIJANtc2N1zb53NMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWIucm9jay5rMTIubmMudXMwHhcNMTEwNDA3MTQxMDU3WhcNMTQwNDA2\nMTQxMDU3WjAeMRwwGgYDVQQDExNzaGliLnJvY2suazEyLm5jLnVzMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlBZdzVkY+qjXvyQSQ+OWA6fTFgvtmAZW\nw9KIs5IvL0trjOwMZLjGYWzUpRcirb9EW6XLC5A2ZW/FuVfIHYO70EOczz+7pW4h\n8JTHbhdm3nqC1OWeRv3RpKL0N+MHBVIV+3F85xPpWVqVTzpePA98HRKaJkjLPtcm\nHWYrA1+j6jUXIpdOs4BKuywQCTF62NHovNyV7Q+Dq2x3RmXRNSNCobXgvja1jXnC\nDISVtj52UDsjZC8WONKbQ+Rx7qWlFGYqiCJ77m0+rj7HCDaxIWC5qzRSfY8T1DIn\nNUS8bR50+JhV76cIzgvkq9K1uvlZoXkAMdo1t4G2otTJC8HjnSRvdwIDAQABo38w\nfTAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5zJIowTgYDVR0jBEcwRYAUruM5\ns76Piz3hAqGOEkjj+R5zJIqhIqQgMB4xHDAaBgNVBAMTE3NoaWIucm9jay5rMTIu\nbmMudXOCCQDbXNjdc2+dzTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBsz6rnvJbbWYSsOW1ZQRa6d4MwOQJyC1MSlVBWgkF78tROYcd4odLNJPWB26Vs\nVJOlu173WyK26NdTPk35aAI0Y6Hl927DTyoa+GQM//JKM9CUXvhBGr9Ly5+fcKYO\nylAMffw3Mgw18H6IejfhvJZgF64Dysp+IZe+8WPhPuzqJwSlkLdS9HXNHyxBHtBl\nagNbI0Gj1/d2JrAMlId3wZu1Z/tbZHndIypnUTW/PToLtkUjlrH8naMXYx3oTuP6\nOzXh12tNCnBxCY6icNDRtdN30nH0uDt11VfENHv5C5mKxr7w2uDTLdBjEL0HPh0m\nr1ynZK4DSpncepmCHNLOHwCG"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Rockingham County Schools"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.rock.k12.nc.us/rockingham/site/default.asp"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Rockingham County Schools"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://capuccino.info.ufrn.br/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "SINFO"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "redes@info.ufrn.br"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://capuccino.info.ufrn.br/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf"
              }
            ],
            "registration_instant": "2010-01-01T00:00:00Z",
            "registration_authority": "http://cafe.rnp.br",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC0jCCAboCAQAwDQYJKoZIhvcNAQEFBQAwLzEMMAoGA1UECxMDQ1BEMQswCQYD\n               VQQGEwJCUjESMBAGA1UEAxMJY2FwdWNjaW5vMB4XDTE0MDYwNTEzMTQ0OVoXDTE5\n               MDYwNDEzMTQ0OVowLzEMMAoGA1UECxMDQ1BEMQswCQYDVQQGEwJCUjESMBAGA1UE\n               AxMJY2FwdWNjaW5vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n               +5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\n               Wg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\n               rMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\n               g2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\n               rtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\n               U8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQAv43rE0bYSXgqb\n               PUkmyZn/EfLe9dsr6RFGfRWU3eSPIbcaZTf6cXuwWBc3sMURUMjRRNX1DsNpK9Yr\n               pFrHXusucXsnBz/1owJyFSNq2m0NZhSabKJvXS8KgvH237db1OP4hbqbZZ7PcTm/\n               CjCtIiYSn4O/xil76jd7B0vFMcICdWmojoJXJOuVuMGGERXhpI2pFC2X9LVafY1q\n               HiaTJ8XDtqq27T9Q2BYJBQoIjPPBF9wF3L4OCAJUCIs/I2vTaG3oR6gPVRo4AP01\n               XkH1cct5hhIN0719bcHVK1Rp9xpSWZT3DFO0qggrszg/du71sHZOQgW+z0tGH3BK\n               EnZQnP4F"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "ufrn.br"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://capuccino.info.ufrn.br/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "ufrn.br"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.ufrn.br/"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.ufrn.br/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte"
                  },
                  {
                    "lang": "pt-br",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC0jCCAboCAQAwDQYJKoZIhvcNAQEFBQAwLzEMMAoGA1UECxMDQ1BEMQswCQYD\n               VQQGEwJCUjESMBAGA1UEAxMJY2FwdWNjaW5vMB4XDTE0MDYwNTEzMTQ0OVoXDTE5\n               MDYwNDEzMTQ0OVowLzEMMAoGA1UECxMDQ1BEMQswCQYDVQQGEwJCUjESMBAGA1UE\n               AxMJY2FwdWNjaW5vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n               +5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\n               Wg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\n               rMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\n               g2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\n               rtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\n               U8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQAv43rE0bYSXgqb\n               PUkmyZn/EfLe9dsr6RFGfRWU3eSPIbcaZTf6cXuwWBc3sMURUMjRRNX1DsNpK9Yr\n               pFrHXusucXsnBz/1owJyFSNq2m0NZhSabKJvXS8KgvH237db1OP4hbqbZZ7PcTm/\n               CjCtIiYSn4O/xil76jd7B0vFMcICdWmojoJXJOuVuMGGERXhpI2pFC2X9LVafY1q\n               HiaTJ8XDtqq27T9Q2BYJBQoIjPPBF9wF3L4OCAJUCIs/I2vTaG3oR6gPVRo4AP01\n               XkH1cct5hhIN0719bcHVK1Rp9xpSWZT3DFO0qggrszg/du71sHZOQgW+z0tGH3BK\n               EnZQnP4F"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UFRN - Universidade Federal do Rio Grande do Norte"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "UFRN - Universidade Federal do Rio Grande do Norte"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ufrn.br/"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ufrn.br/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UFRN - Universidade Federal do Rio Grande do Norte"
          },
          {
            "lang": "pt-br",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "UFRN - Universidade Federal do Rio Grande do Norte"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://journals.bmj.com/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Biasotti"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:shibboleth-admin@highwire.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Olga"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Biasotti"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:shibboleth-admin@highwire.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Olga"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://journals.bmj.com/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2008-08-27T11:16:15Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "BMJ Journals"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://journals.bmj.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "HighWire Press, Inc."
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEfDCCA2SgAwIBAgIJAMTRVlqTJ11lMA0GCSqGSIb3DQEBBQUAMIG+MQswCQYD\n\t\t\t\t\t\tVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEVMBMGA1UEBxMMUmVkd29vZCBD\n\t\t\t\t\t\taXR5MRcwFQYDVQQKEw5IaWdoV2lyZSBQcmVzczERMA8GA1UECxMISGlnaFdpcmUx\n\t\t\t\t\t\tIDAeBgNVBAMTF3NoaWJib2xldGguaGlnaHdpcmUub3JnMTUwMwYJKoZIhvcNAQkB\n\t\t\t\t\t\tFiZzaGliYm9sZXRoLWFkbWluQGhpZ2h3aXJlLnN0YW5mb3JkLmVkdTAeFw0xNDA0\n\t\t\t\t\t\tMTUxOTQzMDNaFw0yNDA0MTIxOTQzMDNaMIG+MQswCQYDVQQGEwJVUzETMBEGA1UE\n\t\t\t\t\t\tCBMKQ2FsaWZvcm5pYTEVMBMGA1UEBxMMUmVkd29vZCBDaXR5MRcwFQYDVQQKEw5I\n\t\t\t\t\t\taWdoV2lyZSBQcmVzczERMA8GA1UECxMISGlnaFdpcmUxIDAeBgNVBAMTF3NoaWJi\n\t\t\t\t\t\tb2xldGguaGlnaHdpcmUub3JnMTUwMwYJKoZIhvcNAQkBFiZzaGliYm9sZXRoLWFk\n\t\t\t\t\t\tbWluQGhpZ2h3aXJlLnN0YW5mb3JkLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEP\n\t\t\t\t\t\tADCCAQoCggEBALPB99M9iWjentrddY/rLgzKn1X0j4Ao191iyiowBBt/r/pmn2oz\n\t\t\t\t\t\tfrbONkkTVBB++mNtiufK6jyKnBM5mffPOkXHRo+K1DQec7TvpQ1PmLv/BpBgPrr9\n\t\t\t\t\t\tldViOSUnYJuB0IgJVV8oylgeH2Ay0XRkNPlBUjBA2fUPWVpXcvFe+aD2tLdVR9uO\n\t\t\t\t\t\tXvfTMxAEGqzxTU+OxO6pW2sBXNBmGvZQ0TRyovQh5+pTURY/lm0V/iWvRmRe51WE\n\t\t\t\t\t\tO/nhYyvRuMmNj8EL38o10S9TXuCkVzY00hK5cclaFge7gz/tfjmadVVcbe8xCVxc\n\t\t\t\t\t\tnb1lhmt1kH2XtKvU5hyZMTO+VUfXQvqcQyECAwEAAaN7MHkwCQYDVR0TBAIwADAs\n\t\t\t\t\t\tBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYD\n\t\t\t\t\t\tVR0OBBYEFJpUZq/XaW9/bPvjffkxX0IDvuPiMB8GA1UdIwQYMBaAFJpUZq/XaW9/\n\t\t\t\t\t\tbPvjffkxX0IDvuPiMA0GCSqGSIb3DQEBBQUAA4IBAQCq/FF56ZB1cL3KbniEJP99\n\t\t\t\t\t\tU9wTD6KpOrWxvqNbUSV1cefLf5cYHonOjy6oAJSSBSNuP7U5Q//0tXtkvlJoqGUY\n\t\t\t\t\t\tvqngmeg9wLZ/Fla3tXcDdTj0n1F+NZOx9vBDacIk0Ua4aHXDA4bdytzkV1QyZDRq\n\t\t\t\t\t\tQ8vq7RoQ8E5IF7Cll+kt2dZXQk8o6Qp3w2ppoMRtYdKOQassqn+V1MYcMPgdxZkS\n\t\t\t\t\t\tDrcgzktR/JMb5OmPrp4mSy1OWDGrFvUIigsLBPZV9tw1f7y42lnbmQas3RCS30yr\n\t\t\t\t\t\tCtUPT/PQDkCdBRViGmmMkYwjdaOTiHOJveWtrVXu8vLvO36pqFF4Kft0pgqlfvAE"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.highwire.org/applications/bmjjournals/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://fed.p.lodz.pl/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Team"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:bok@p.lodz.pl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Biura Obs\u0142ugi Klient\u00f3w Centrum Komputerowego"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://fed.p.lodz.pl/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://aai.pionier.net.pl/en/index.php?page=rps"
              }
            ],
            "registration_instant": "2015-08-03T00:00:00Z",
            "registration_authority": "https://aai.pionier.net.pl",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/research-and-scholarship"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category-support",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/POST-SimpleSign/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://fed.p.lodz.pl:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://fed.p.lodz.pl/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://fed.p.lodz.pl/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://fed.p.lodz.pl:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://fed.p.lodz.pl:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "p.lodz.pl"
              },
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Lodz University of Technology"
                  },
                  {
                    "lang": "pl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Politechnika \u0141\u00f3dzka"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Lodz University of Technology"
                  },
                  {
                    "lang": "pl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Politechnika \u0141\u00f3dzka"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHzCCAgegAwIBAgIUf92tx4MSZkG0nD2gvKf1684tQsYwDQYJKoZIhvcNAQEL\nBQAwGDEWMBQGA1UEAwwNZmVkLnAubG9kei5wbDAeFw0xNTAzMTkxMjIzNTJaFw0z\nNTAzMTkxMjIzNTJaMBgxFjAUBgNVBAMMDWZlZC5wLmxvZHoucGwwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClJEvUpbTZ2twCfK6BPayJ+NOosjc+5yQQ\n82+oQPkK9AUBj3L5nG1d8S0ytNrP023FBEPHqlKrrP1IYFr6//tZMG77pz4iJkAI\nbP3ALXmd0DkDbEk5f0lZRbgicRsNUqG/XZ+YU2vptTM+qjeRN6oC4kTfy2hyT6ZT\nl0QFQudrh8DXXnC//2PcIp2LJOVpi/s0bkx17CsFe1wXKGiE+IRjxREwMPsjhZcL\n0kRyOWvNFgZJdYA7QwbwpX2r4JO9QtPJlj0r5a+AlmqFvXRrYHoZRY/xjiFsE5da\nLhA3/T/qpJTSuOLq/OAKdg7btY3NXyUVEA96YjLM7sB+3pH5f0LvAgMBAAGjYTBf\nMB0GA1UdDgQWBBSMCHpJHpAfliH4Oas5962Zaj4F9jA+BgNVHREENzA1gg1mZWQu\ncC5sb2R6LnBshiRodHRwczovL2ZlZC5wLmxvZHoucGwvaWRwL3NoaWJib2xldGgw\nDQYJKoZIhvcNAQELBQADggEBAFMj2tTRqW2cjCBtUrYQvkrbS9ThyMeskXqBlv8Z\nyuK5649zIrA3A9u/DYHum9bVf+gfvcIPfMTmBdcthMVTJIz4jD0B+Q6UdYO+YLnb\nGIHo5I6+5YcaiHG3vDJ8bwQQ0c3y2BV+xXazoPUHMQAQhw657P3zVVmXQrBL81S8\njrKFuLnw92jEyfvJvanV5hGLq6/sFIlFYMIXjVp60rkn/jYiVRy46GPZXzyuTQfN\nwnHFEgO9IZFWIfExNj8Vs2cWxZd4P6r6D7IXbeEtPz53yfi3t28vATtQKi12JHEC\n16rusRPe4GqH6oWfMN55z6Hl6dBDSFxv0xuqLKZZQOA5sa4="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDIDCCAgigAwIBAgIVALBJ54FSifljTYxqdKs9piNvZRmGMA0GCSqGSIb3DQEB\nCwUAMBgxFjAUBgNVBAMMDWZlZC5wLmxvZHoucGwwHhcNMTUwMzE5MTIyMzQ5WhcN\nMzUwMzE5MTIyMzQ5WjAYMRYwFAYDVQQDDA1mZWQucC5sb2R6LnBsMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAht1Z4j3LNunoGUj0Xg1mVFm1pC9G2h/W\nKJx9e6hpsQNeOV164mLeDocnSPZz0sN8yMOdtPKgRp11pqjxY80Y62fbmL4Z5VzR\nS5LSPb4RwK8bDt+Y5VrpEQfahyhKn4FTv0ONx3ayQHhBkeVtwv6m5OcKbohTP4KL\nGa//7AA1yUuSHOMsNs5Jl0+Qw+pnrqq0NdxuJNUVvpzmsy/LECw4yT1TYPtmKIT0\nBRoKFnptuAvUeuzI8X4Sk7nHPmnwkEVTCXm5KlCdRrrRAXOv75rCMnoHwlljGArW\nN8pr5Bi95j2/JTspzdD+Sd4ZJ2KL0RbLB7WJzxwdxdU2brJmzvyAHQIDAQABo2Ew\nXzAdBgNVHQ4EFgQU5pnJ2LRleP5CXaU7Q3p13pllUXQwPgYDVR0RBDcwNYINZmVk\nLnAubG9kei5wbIYkaHR0cHM6Ly9mZWQucC5sb2R6LnBsL2lkcC9zaGliYm9sZXRo\nMA0GCSqGSIb3DQEBCwUAA4IBAQAqca7YchwV5OSyMoKyVAka7UJfaUiL45t4lhjx\nGQK715ftzkPITSuOnt+xrx5JHLWyw47xNIj+W+HckkhnWpeQ4QQrEAO8T63pZrUv\nH+gOYWqKOaYum0D1+CaBen29Unts9Ie9hiqFg5yUy40LG10JYZeGcYMLw4f5b+Sz\nK9z2eS9vbYBf7F2snpz/PG2XWXhh3qgQAvQfgNhlT81IjRyYZQhjFKdw+Oiklp+Z\nJ25Z/5z3Qt2aL7DuQC5/9xfyPmI0K6fHnMIkpE+t9XGXLCvQgVmCzzudXLdaVIwf\nNzpyfHJJG9+8ns6iv60kTPTWKis5/IMSjcdeGmyUvDzEqs8I"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHzCCAgegAwIBAgIUNXScWBo43xj5lpqlUdGPP9YZL3QwDQYJKoZIhvcNAQEL\nBQAwGDEWMBQGA1UEAwwNZmVkLnAubG9kei5wbDAeFw0xNTAzMTkxMjIzNTBaFw0z\nNTAzMTkxMjIzNTBaMBgxFjAUBgNVBAMMDWZlZC5wLmxvZHoucGwwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQChdv4HP1QY4J29sh1jYKp5J0NAVAOyc1wv\nMBAtrEQYoVT3QETu5380X/ZBVwpOrxUa5andF6XcNxhK3TlTj6XqbOeEboL9yGqc\nHhu5GRFjHfTUmPKsEsuIPT7g8yVuR/kqVq7CvNkbi1hse2ZPDf0WXDmDJeG+DdXc\ntxyuRtG+mn/b5/faxneH7lNgK/Vv/ciM66ezNBtjqB94QtZNmCosuHJmzuEYbwMF\nNEFLBfNeaxdu5GPnHXZJdGRcoKzYIL3f5tEKMXV0OFnE5PekRiWl1rkPgDyLgY41\nwwz5l9J1lere/jSxRTJJxXdg9KVc9CtRyCSKh41Z7jlaAP7Oy3mdAgMBAAGjYTBf\nMB0GA1UdDgQWBBTuGHz++Xnn/VzfXKWxhyTT+h9CXTA+BgNVHREENzA1gg1mZWQu\ncC5sb2R6LnBshiRodHRwczovL2ZlZC5wLmxvZHoucGwvaWRwL3NoaWJib2xldGgw\nDQYJKoZIhvcNAQELBQADggEBAFi7u1NDWSQzg9qV3Jfc6kXX/JoBYw4fD0E4dUSg\ne4Dt2jDy42Psv1lBedpDN9Z/SWCl5C9X5qFRh6aGOTC1Az/j0XNuU4l9lx4DBXyO\n8Go9+znYd2l5bLkekCh2FF/EhCCHikhG0BAzc/m3n/FI+SC+pR3noUkTFChsj/YO\nv+rTqPYf+nXDtjzxOTy7iXJewLd0AaC4cK9BeOED5RyZADtK76zhv9pkUJwK1mWr\nnneqUZTQqcy82KLNUIk6u943LlhuqCXzy/idqKydkbAMxo4ZtL6mLFIBuAgU8Tm7\n4J3XCqnActMT97Zf5r6j4RjYBhiuFU30SvNV857zAr+/noQ="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Lodz University of Technology"
          },
          {
            "lang": "pl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Politechnika \u0141\u00f3dzka"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.p.lodz.pl"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Lodz University of Technology"
          },
          {
            "lang": "pl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Politechnika \u0141\u00f3dzka"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://shibb.ws.seemis.gov.scot/shibboleth-sp",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:letters@seemis.gov.scot"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SEEMIS Helpdesk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Mountfort"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:ian.mountfort@seemis.gov.scot"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Ian"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibb.ws.seemis.gov.scot/shibboleth-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "SEEMIS Group LLP: Glow Services"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.seemis.gov.scot/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "SEEMIS Group LLP"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC1jCCAb6gAwIBAgIJANnFj5LehaRsMA0GCSqGSIb3DQEBBQUAMBAxDjAMBgNV\n\t\t\t\t\t\tBAMTBXNoaWJiMB4XDTEwMDkxMzE0MjEyMloXDTIwMDkxMDE0MjEyMlowEDEOMAwG\n\t\t\t\t\t\tA1UEAxMFc2hpYmIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtSXC9\n\t\t\t\t\t\t5Iq68ruXAxPoscW47pepV3+UBJne3/lJ5VxdI3n3QbmM0GfMrd3jDkS4r2BgnYF1\n\t\t\t\t\t\tveTqa9BCCGKh5Hp6ISDo9dZ4Si/zllypDYhOmcBBbuUr/bjAj7y7hjp9Q18yHBnO\n\t\t\t\t\t\tFmeYQIXfI5Q5gbEaTT3JCON+65nVMH3rifQvoGU9Dbxwo2INR0lmZtLBpPgeq+2i\n\t\t\t\t\t\tGt+FKLOOOey0ydB0eKD2qDASoqQhOKKNTvgxmWGWiXQwswRQNygLyvbnJ+pIf0GG\n\t\t\t\t\t\tYyHCyplLkq99nEeChSx7wSjaiD9J5uUDEICJAZo6V6vqNC+DJu6Ztx4Tq1w39m0A\n\t\t\t\t\t\tQuwgWV4d5XQTLnftAgMBAAGjMzAxMBAGA1UdEQQJMAeCBXNoaWJiMB0GA1UdDgQW\n\t\t\t\t\t\tBBTuy95SjJcKxjwAb2d7iwYOHVJMETANBgkqhkiG9w0BAQUFAAOCAQEAOeOhi+4R\n\t\t\t\t\t\tGhqXhKLiw8yUCOSff4x+dDfjzseeWUeBhVyYeMsAklANvDE7nlKB8gcQv9HgHaLC\n\t\t\t\t\t\tfbo2bGQegAumPYkNBbLbHk5wMM9lcKV+h08ak54ufgY5dxdKN2YYl9EC56egzuJg\n\t\t\t\t\t\thTWoSRbwML5X6CGKuKMLSCiEVJXS8hmZHJl1kxmwXKAqArUhFwhfFMYxBbXnBUSV\n\t\t\t\t\t\tgI3Rbjt43XXJJEt6BhLaLVxqmzndyabdI2u3zx6CdtvFynSPDOA/p8Rifcrfzt20\n\t\t\t\t\t\tl5nkqOEMNUx0VHYCZ/W+pt8AmPMWGRWjL2wcUndgwrdBVqaeT7Dmz7ozeniJbF1n\n\t\t\t\t\t\tmCaszq2WwCToAw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC1jCCAb6gAwIBAgIJANnFj5LehaRsMA0GCSqGSIb3DQEBBQUAMBAxDjAMBgNV\n\t\t\t\t\t\tBAMTBXNoaWJiMB4XDTEwMDkxMzE0MjEyMloXDTIwMDkxMDE0MjEyMlowEDEOMAwG\n\t\t\t\t\t\tA1UEAxMFc2hpYmIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtSXC9\n\t\t\t\t\t\t5Iq68ruXAxPoscW47pepV3+UBJne3/lJ5VxdI3n3QbmM0GfMrd3jDkS4r2BgnYF1\n\t\t\t\t\t\tveTqa9BCCGKh5Hp6ISDo9dZ4Si/zllypDYhOmcBBbuUr/bjAj7y7hjp9Q18yHBnO\n\t\t\t\t\t\tFmeYQIXfI5Q5gbEaTT3JCON+65nVMH3rifQvoGU9Dbxwo2INR0lmZtLBpPgeq+2i\n\t\t\t\t\t\tGt+FKLOOOey0ydB0eKD2qDASoqQhOKKNTvgxmWGWiXQwswRQNygLyvbnJ+pIf0GG\n\t\t\t\t\t\tYyHCyplLkq99nEeChSx7wSjaiD9J5uUDEICJAZo6V6vqNC+DJu6Ztx4Tq1w39m0A\n\t\t\t\t\t\tQuwgWV4d5XQTLnftAgMBAAGjMzAxMBAGA1UdEQQJMAeCBXNoaWJiMB0GA1UdDgQW\n\t\t\t\t\t\tBBTuy95SjJcKxjwAb2d7iwYOHVJMETANBgkqhkiG9w0BAQUFAAOCAQEAOeOhi+4R\n\t\t\t\t\t\tGhqXhKLiw8yUCOSff4x+dDfjzseeWUeBhVyYeMsAklANvDE7nlKB8gcQv9HgHaLC\n\t\t\t\t\t\tfbo2bGQegAumPYkNBbLbHk5wMM9lcKV+h08ak54ufgY5dxdKN2YYl9EC56egzuJg\n\t\t\t\t\t\thTWoSRbwML5X6CGKuKMLSCiEVJXS8hmZHJl1kxmwXKAqArUhFwhfFMYxBbXnBUSV\n\t\t\t\t\t\tgI3Rbjt43XXJJEt6BhLaLVxqmzndyabdI2u3zx6CdtvFynSPDOA/p8Rifcrfzt20\n\t\t\t\t\t\tl5nkqOEMNUx0VHYCZ/W+pt8AmPMWGRWjL2wcUndgwrdBVqaeT7Dmz7ozeniJbF1n\n\t\t\t\t\t\tmCaszq2WwCToAw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibb.ws.seemis.gov.scot/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://shibb.ws.seemis.gov.scot/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://meta.swamid.se/shibboleth",
    {
      "entity_id": "https://meta.swamid.se/shibboleth",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/nren-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Swedish Academic Identity Federation (SWAMID)"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.swamid.se"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "SWAMID"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://meta.swamid.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://meta.swamid.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://meta.swamid.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://meta.swamid.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://meta.swamid.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://meta.swamid.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://meta.swamid.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Metadata service at SWAMID"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Metadata service at SWAMID"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "meta.swamid.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC8TCCAdmgAwIBAgIJAO86gLrkwwP3MA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDm1ldGEuc3dhbWlkLnNlMB4XDTE0MDMxMzEyMjYzNloXDTI0MDMxMDEyMjYz\nNlowGTEXMBUGA1UEAxMObWV0YS5zd2FtaWQuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDZVfts97pzO7DCqNPgK3do1xRdwwJ85kbhzb0azMGZHTqh\nBowZu+DgMPPeZ4/YFT8hO1HOoW9oEvV0qFgSrPYclFxTWrzlbHnika1wEBc8ukIX\nmdjdI1yGrk3bh50DTnkljuWbnwYPiWARIzyEL3vT4HP+5z+If5T0eaaL7u6qNZX7\nDKqhPnyF0OKT8am6MnN/VGS1FehKOulnHrkVgOeb43Rf5YbMy/2+UT6noaaJb28/\na4fwMp7uFJ7Nvx5O7AIeAmdy5eg5lqlHslQEIsD5K/KCRk1m2h0uMm5i6hSddjTR\ne7p42tXVBb8UbSUFNdne8jO+IVajxXRlBPw4S/bXAgMBAAGjPDA6MBkGA1UdEQQS\nMBCCDm1ldGEuc3dhbWlkLnNlMB0GA1UdDgQWBBTxCjCev8NEnf0Hqn+16Y9roCLU\nSzANBgkqhkiG9w0BAQUFAAOCAQEAnjDzcj7BU2afxo5h6OtV4a7zhfBMeq3S3gyw\nkLjbk1BRAJ7vWS2juhnVTP78g5sAkjIDbq/7V77mLBBt/7xqbwgOkPh5/i9lWTOV\nLAwqyhW3dEAqDAKQ3oTKPQR9OiHZ3wShNvHU+/7jKeecEShKb9ZUgGZGYYF6VTz7\nVWDuymgW+e7fOSXixyTpB3ED7kg24w4WaM7n59xlA3+Y9E5d+snpf8e7yrqwCZP1\novvypDjeN1LIIK6K1u6a+IpQDdBgkes//gOqD5/RTR3RPSAhZu/46eoCWxX4o8Xx\n4cWL7ZsFtqVIs30fEZPu0cco2tW8iiRcMYolr6q3vi5xtOH1Bg=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=meta.swamid.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://meta.swamid.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://meta.swamid.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://meta.swamid.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://meta.swamid.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://meta.swamid.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://meta.swamid.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://meta.swamid.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://meta.swamid.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://meta.swamid.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://idp.dias.ie/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bucas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:jfbucas@stp.dias.ie"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Jean Francois"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bucas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:jfbucas@stp.dias.ie"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Jean Francois"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bucas"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:jfbucas@stp.dias.ie"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Jean Francois"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.dias.ie/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.heanet.ie/services/identity-access/edugate#join"
              }
            ],
            "registration_instant": "2013-11-15T00:00:00Z",
            "registration_authority": "http://www.heanet.ie",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.dias.ie/idp/profile/Logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.dias.ie/idp/profile/Logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.dias.ie/idp/profile/Logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://idp.dias.ie/idp/profile/Logout",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.dias.ie/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.dias.ie/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.dias.ie/idp/profile/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.dias.ie/idp/profile/SAML2/SOAP/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.dias.ie/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "dias.ie"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.dias.ie"
                  }
                ],
                "logo": [
                  {
                    "text": "https://edugate.heanet.ie/rr3/logos/dias_logo.png",
                    "height": "112",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "136"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Dublin Institute for Advanced Studies"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDFzCCAf+gAwIBAgIUD82Rv6ZhMvwGESzIOJRkEtryOk4wDQYJKoZIhvcNAQEF\nBQAwFjEUMBIGA1UEAxMLaWRwLmRpYXMuaWUwHhcNMTMxMTE1MTAxODExWhcNMzMx\nMTE1MTAxODExWjAWMRQwEgYDVQQDEwtpZHAuZGlhcy5pZTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAINbJEvXC7qeIqXcCt3l6qrIw7ckk6FIy/rBBbO0\n0HkzFWd6JsOO3QZ8ymRgVeap9N1SycxIuox63M8sa89KwNVXAvNyDfrbvmbqIxzJ\nT5RmHl4ISgrsQubAWJ7eNiqVXiMvQe+e2A7iPpplPJYGqhvG/TB6F/4QDfGO+G9/\ntK+EdCvntS8wEy/s0UrDVOo+upvJnypzNJLcavfZWWwfjzR57Rcx48jTlRjZRe0R\n4/2rWS5yAJ8UhjBksoGD36ZHIpc1GFI5JeSNbGA7V501qhhjK9X09A+/NAlLGIj3\ns2ZJPfNGMPaY6Uc7u6sfEvwUJoz8kUnIV7Ac8HNw/d8Joi8CAwEAAaNdMFswOgYD\nVR0RBDMwMYILaWRwLmRpYXMuaWWGImh0dHBzOi8vaWRwLmRpYXMuaWUvaWRwL3No\naWJib2xldGgwHQYDVR0OBBYEFJ8KCzRdsORXHfsuXHNeCrKqR4owMA0GCSqGSIb3\nDQEBBQUAA4IBAQBPyzwZNTdiO9/RRp0f8hBqP0rOsO7mueuDbGvZoCPUEYiBkYiG\nzYB2DHkcfAYQls/vuI7DiuLWQC5COLsoDVgAW59VBrRKTRwpIjktvTM3C2aexomw\nGW7M9XqyiTdArQb3Inyl8Jca4HiniDEorh7OqjGEIakT4cIj8Vfu43b+E0L28otA\nGphiaINCWGdfHDfbsuc6fLoJp4WzSQHxGQEkkHE/XO6zWQLXPNuO9eU3MWwqw+or\nLlHiaoyxj0hM9NnJIllv1huBF7CHL4EadiizxS/nK2mx0vZgJVvQAOG6Kir3lbME\nh8KMdglIpPQmLF1/JtTN3QNn8SZmE7iel3kB"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Dublin Institute for Advanced Studies"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.dias.ie"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Dublin Institute for Advanced Studies"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.kmc.ac.uk/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:athenshelp@eduserv.org.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Athens Helpdesk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:athenshelp@eduserv.org.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Athens Helpdesk"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.kmc.ac.uk/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://login.openathens.net/saml/2/sso/kmc.ac.uk/c/ukfed",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://login.openathens.net/saml/1/sso/kmc.ac.uk/c/ukfed",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "kmc.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDvjCCAqagAwIBAgIEVOxCIjANBgkqhkiG9w0BAQsFADCBoDEoMCYGCSqGSIb3\n\t\t\t\t\t\tDQEJARYZYXRoZW5zaGVscEBlZHVzZXJ2Lm9yZy51azELMAkGA1UEBhMCR0IxETAP\n\t\t\t\t\t\tBgNVBAgMCFNvbWVyc2V0MQ0wCwYDVQQHDARCYXRoMRAwDgYDVQQKDAdFZHVzZXJ2\n\t\t\t\t\t\tMRMwEQYDVQQLDApPcGVuQXRoZW5zMR4wHAYDVQQDDBVnYXRld2F5LmF0aGVuc2Ft\n\t\t\t\t\t\tcy5uZXQwHhcNMTUwMjI0MDkyMDA2WhcNMjUwMjI0MDkyMDA2WjCBoDEoMCYGCSqG\n\t\t\t\t\t\tSIb3DQEJARYZYXRoZW5zaGVscEBlZHVzZXJ2Lm9yZy51azELMAkGA1UEBhMCR0Ix\n\t\t\t\t\t\tETAPBgNVBAgMCFNvbWVyc2V0MQ0wCwYDVQQHDARCYXRoMRAwDgYDVQQKDAdFZHVz\n\t\t\t\t\t\tZXJ2MRMwEQYDVQQLDApPcGVuQXRoZW5zMR4wHAYDVQQDDBVnYXRld2F5LmF0aGVu\n\t\t\t\t\t\tc2Ftcy5uZXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCandpa4o0N\n\t\t\t\t\t\tjtw1DqbrrNTfOVe1PqyXIIVmDrJ6VUR/mokXXu+m5Gm+1f+3lyN5IA2YMn9Z8Yo3\n\t\t\t\t\t\t7JQjIHs+xVS3q4nT1ewS7S3en1pdXKsH1WnUnVWUmpl9WJZrUwi5i8X80LNyr7Pm\n\t\t\t\t\t\tudhuKNEATGUXkA/xWCkk2d8jf91hy7Qu+HA8LOKtdbbNigErh2IY/YuNWUVUqgGb\n\t\t\t\t\t\tMH5BGr7ZEhPrz+Vwcf9lhPW+tKpKpZEzJfQiq8EoPaeMXEpKWBEErm67gkWFCA5V\n\t\t\t\t\t\thfcJLqFjQEC3pWOxt5rZVS8gl/Z33VSJZVzY5jWcQzmGaLXPHXyiKPmixl6+DjGl\n\t\t\t\t\t\tUM0ylNF7GvtDAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAFhmhujLZueiJ6F7mQCp\n\t\t\t\t\t\tfB0Hj4Y8FyFUUc8NMAt5Set7H4DKSSl4shcqisZBa5yTdyenYwkmBszvCWs6Yeep\n\t\t\t\t\t\t+zJmCR62cb/f1M32oMzLm02OlznWMkE8/IajGmdxTnB6Z/XcdMMIiCeok4kqe5KM\n\t\t\t\t\t\td5oRAyNskHYZ+8kzhs2zTveR+rqCtYxa/AYpwf7n0VQR9clBSNCIT4BCRi10aPE5\n\t\t\t\t\t\t31VIxl4ljY3CwNoZ4lQTU/0aj8O4j68V2neiQb8lewAii0b2xoyOGYP4okd7T2tl\n\t\t\t\t\t\t4gl2noVbCvYNjd6GYze/w4lgwiemkby7wu5sN1lEudgKDV+H54wU29ZIyDEFM6DD\n\t\t\t\t\t\tNE4="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Kingston Maurward College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.kmc.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Eduserv"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://shib.mdanderson.org/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "idm@mdanderson.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "MDACC IdM Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "4info@mdanderson.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "MDACC 4Info"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shib.mdanderson.org/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib.mdanderson.org:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib.mdanderson.org:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDODCCAiCgAwIBAgIVAN9NaOe859o4m2yJ5DUijMku+q4tMA0GCSqGSIb3DQEB\nBQUAMB4xHDAaBgNVBAMTE3NoaWIubWRhbmRlcnNvbi5vcmcwHhcNMDkxMDAxMjI0\nNjAyWhcNMjkxMDAxMjI0NjAyWjAeMRwwGgYDVQQDExNzaGliLm1kYW5kZXJzb24u\nb3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiKDahIBcn1K0mp5A\nmT2zcPTNaRITSnkgajXbN12Wzwk2CFLJZ6QekzoeyhKGuUNgYXHcPnWJuoclpmXo\neX8C3egYAWorgC2LMjKvBMPCaSmH3ioe9avwOSCpG37Zw4ydWPJod2hy7h5NQedq\n9ath8J9I7U2q/Y5a/khlttR7o/7lGJHBCumAp+VnUEgLzUkAYbXo9gbdwC+GhdI1\nWx+msDZwq8qIgT679SUm6RHUfkHKZD352zCaP+VHxuX4uMUj/ue/2BnN0Z9RnHZ/\nxgDmURoSwokxnbLWodMV0Ny0eDvcpS9eEf5Zx04YFMJ3XpjnOxvvO4WaXt8WPcRT\nCHtEQwIDAQABo20wazBKBgNVHREEQzBBghNzaGliLm1kYW5kZXJzb24ub3Jnhipo\ndHRwczovL3NoaWIubWRhbmRlcnNvbi5vcmcvaWRwL3NoaWJib2xldGgwHQYDVR0O\nBBYEFALOifNwK+8AFuidZ/PXBFI5+j5BMA0GCSqGSIb3DQEBBQUAA4IBAQAzMZSH\n2QsL5RGHaHkM9+2fLesMDjPzd35RnbR1iRkcBi9eFvQah3pH1ITWNWRNsUbs+UUH\nuO44upcOk6VCbZ88rNeS6kE1BgSRNsRNTy/wJth/rsvIoAVek9arZNEMoBCCixGP\n81YR1OzjO2Egmcan0GsYCdPDowRcYEzEtLZGq8S5+0pa8vtEpa6UtakWsfTAZqFP\nt0OioSV7pwA9szQp2fCqvp61B5RP1zeUfWJIcjpKYlRCejwboHTN/S40bjxsXJ32\nc6j5VoHLH/WEfXJ262osyqeyDwVPyJZx7WWPWlYY3GCKYxwhrAZSA7A1u8VHe3wD\nqHwdXzHWzbbPX5x9"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "mdanderson.org"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shib.mdanderson.org/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shib.mdanderson.org/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shib.mdanderson.org/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shib.mdanderson.org/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib.mdanderson.org:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib.mdanderson.org:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "mdanderson.org"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of Texas M.D. Anderson Cancer Center"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDODCCAiCgAwIBAgIVAN9NaOe859o4m2yJ5DUijMku+q4tMA0GCSqGSIb3DQEB\nBQUAMB4xHDAaBgNVBAMTE3NoaWIubWRhbmRlcnNvbi5vcmcwHhcNMDkxMDAxMjI0\nNjAyWhcNMjkxMDAxMjI0NjAyWjAeMRwwGgYDVQQDExNzaGliLm1kYW5kZXJzb24u\nb3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiKDahIBcn1K0mp5A\nmT2zcPTNaRITSnkgajXbN12Wzwk2CFLJZ6QekzoeyhKGuUNgYXHcPnWJuoclpmXo\neX8C3egYAWorgC2LMjKvBMPCaSmH3ioe9avwOSCpG37Zw4ydWPJod2hy7h5NQedq\n9ath8J9I7U2q/Y5a/khlttR7o/7lGJHBCumAp+VnUEgLzUkAYbXo9gbdwC+GhdI1\nWx+msDZwq8qIgT679SUm6RHUfkHKZD352zCaP+VHxuX4uMUj/ue/2BnN0Z9RnHZ/\nxgDmURoSwokxnbLWodMV0Ny0eDvcpS9eEf5Zx04YFMJ3XpjnOxvvO4WaXt8WPcRT\nCHtEQwIDAQABo20wazBKBgNVHREEQzBBghNzaGliLm1kYW5kZXJzb24ub3Jnhipo\ndHRwczovL3NoaWIubWRhbmRlcnNvbi5vcmcvaWRwL3NoaWJib2xldGgwHQYDVR0O\nBBYEFALOifNwK+8AFuidZ/PXBFI5+j5BMA0GCSqGSIb3DQEBBQUAA4IBAQAzMZSH\n2QsL5RGHaHkM9+2fLesMDjPzd35RnbR1iRkcBi9eFvQah3pH1ITWNWRNsUbs+UUH\nuO44upcOk6VCbZ88rNeS6kE1BgSRNsRNTy/wJth/rsvIoAVek9arZNEMoBCCixGP\n81YR1OzjO2Egmcan0GsYCdPDowRcYEzEtLZGq8S5+0pa8vtEpa6UtakWsfTAZqFP\nt0OioSV7pwA9szQp2fCqvp61B5RP1zeUfWJIcjpKYlRCejwboHTN/S40bjxsXJ32\nc6j5VoHLH/WEfXJ262osyqeyDwVPyJZx7WWPWlYY3GCKYxwhrAZSA7A1u8VHe3wD\nqHwdXzHWzbbPX5x9"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Texas M.D. Anderson Cancer Center"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.mdanderson.org/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Texas M.D. Anderson Cancer Center"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://test.stir.unidesk.ac.uk/tas/secure/login/verify",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:is.helpline@ed.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "IS Helpline"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:apps-certs@mlist.is.ed.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "IS Apps Technology Management"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://test.stir.unidesk.ac.uk/tas/secure/login/verify",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2016-04-05T13:49:49Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Test Unidesk - Stirling"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ed.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Edinburgh"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "authn_requests_signed": "true",
          "want_assertions_signed": "true",
          "key_descriptor": [
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID2jCCAsKgAwIBAgIJALr8CP8PS5BEMA0GCSqGSIb3DQEBCwUAMFExIDAeBgNV\n\t\t\t\t\t\tBAMTF3Rlc3Quc3Rpci51bmlkZXNrLmFjLnVrMSAwHgYDVQQKExd0ZXN0LnN0aXIu\n\t\t\t\t\t\tdW5pZGVzay5hYy51azELMAkGA1UEBhMCVUswHhcNMTYwNDAxMTIzNzE5WhcNMjYw\n\t\t\t\t\t\tMzMwMTIzNzE5WjBRMSAwHgYDVQQDExd0ZXN0LnN0aXIudW5pZGVzay5hYy51azEg\n\t\t\t\t\t\tMB4GA1UEChMXdGVzdC5zdGlyLnVuaWRlc2suYWMudWsxCzAJBgNVBAYTAlVLMIIB\n\t\t\t\t\t\tIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApgFf2q8W/UjaWOZdNqr9EmOa\n\t\t\t\t\t\tWG0l2hEosA+IAHcKkdBNdMhNGzED45WLadguUY1F+Irnft2DF/52/rukG/XuFkM1\n\t\t\t\t\t\tSybLxZdme3ozG91w+TB86/BPTNOl16P2Q3QQ90FdkqZY/rWPMwIRVA5mjKuf6+1T\n\t\t\t\t\t\t5PL9/XpQC9JFwXmUXNsNsLJryDgm+13wugMPymrgWmFGZN2HYlSv5TF5mIxVQOYC\n\t\t\t\t\t\tSjsGZhu88GmRjMxHN1T6OAn7a4HA7/wlEfnl8SQ5TIWPRjQukN9hg/CpYC2zI17G\n\t\t\t\t\t\t/606x/P4lkJ37/NErZ/u4ueA4ymhyWSbLFX8MsFDymiTghJu/7N1Z9nY/ePklQID\n\t\t\t\t\t\tAQABo4G0MIGxMB0GA1UdDgQWBBRa1jo5LhT5i8tbKUA76iynFS7CnDCBgQYDVR0j\n\t\t\t\t\t\tBHoweIAUWtY6OS4U+YvLWylAO+ospxUuwpyhVaRTMFExIDAeBgNVBAMTF3Rlc3Qu\n\t\t\t\t\t\tc3Rpci51bmlkZXNrLmFjLnVrMSAwHgYDVQQKExd0ZXN0LnN0aXIudW5pZGVzay5h\n\t\t\t\t\t\tYy51azELMAkGA1UEBhMCVUuCCQC6/Aj/D0uQRDAMBgNVHRMEBTADAQH/MA0GCSqG\n\t\t\t\t\t\tSIb3DQEBCwUAA4IBAQAx2Xfd1pfAlPepfSX4KUPbhJaq+Z2695FVOW+KqBC/L6db\n\t\t\t\t\t\tjyUYQtoi1X9yge4FaVNt1GMMUv9XVcvH6O7UTLdXBiSXXW/BbhLzRgnf09Mtta0y\n\t\t\t\t\t\tskCRNaStwWbIrDFRegIk0rFUya3n2oR5B5ZW0ah7C93sxYbVbSMZmVfUpf/oZY79\n\t\t\t\t\t\tUZhImwhWAzMfvKgzPySFAXOmoShseo6hrOTyeWJgVxT4EKtifhyhdTZDkT8XykbX\n\t\t\t\t\t\tCA34rv87jODyi+dYGhbegFiuJoDo/9/weL0BH5N48yW18sSjRkURF5VXGbPMUx96\n\t\t\t\t\t\t8Knhux1hK+cTlx1vIfHtJa81w/f3BtS7gweYmKp4"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID2jCCAsKgAwIBAgIJALr8CP8PS5BEMA0GCSqGSIb3DQEBCwUAMFExIDAeBgNV\n\t\t\t\t\t\tBAMTF3Rlc3Quc3Rpci51bmlkZXNrLmFjLnVrMSAwHgYDVQQKExd0ZXN0LnN0aXIu\n\t\t\t\t\t\tdW5pZGVzay5hYy51azELMAkGA1UEBhMCVUswHhcNMTYwNDAxMTIzNzE5WhcNMjYw\n\t\t\t\t\t\tMzMwMTIzNzE5WjBRMSAwHgYDVQQDExd0ZXN0LnN0aXIudW5pZGVzay5hYy51azEg\n\t\t\t\t\t\tMB4GA1UEChMXdGVzdC5zdGlyLnVuaWRlc2suYWMudWsxCzAJBgNVBAYTAlVLMIIB\n\t\t\t\t\t\tIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApgFf2q8W/UjaWOZdNqr9EmOa\n\t\t\t\t\t\tWG0l2hEosA+IAHcKkdBNdMhNGzED45WLadguUY1F+Irnft2DF/52/rukG/XuFkM1\n\t\t\t\t\t\tSybLxZdme3ozG91w+TB86/BPTNOl16P2Q3QQ90FdkqZY/rWPMwIRVA5mjKuf6+1T\n\t\t\t\t\t\t5PL9/XpQC9JFwXmUXNsNsLJryDgm+13wugMPymrgWmFGZN2HYlSv5TF5mIxVQOYC\n\t\t\t\t\t\tSjsGZhu88GmRjMxHN1T6OAn7a4HA7/wlEfnl8SQ5TIWPRjQukN9hg/CpYC2zI17G\n\t\t\t\t\t\t/606x/P4lkJ37/NErZ/u4ueA4ymhyWSbLFX8MsFDymiTghJu/7N1Z9nY/ePklQID\n\t\t\t\t\t\tAQABo4G0MIGxMB0GA1UdDgQWBBRa1jo5LhT5i8tbKUA76iynFS7CnDCBgQYDVR0j\n\t\t\t\t\t\tBHoweIAUWtY6OS4U+YvLWylAO+ospxUuwpyhVaRTMFExIDAeBgNVBAMTF3Rlc3Qu\n\t\t\t\t\t\tc3Rpci51bmlkZXNrLmFjLnVrMSAwHgYDVQQKExd0ZXN0LnN0aXIudW5pZGVzay5h\n\t\t\t\t\t\tYy51azELMAkGA1UEBhMCVUuCCQC6/Aj/D0uQRDAMBgNVHRMEBTADAQH/MA0GCSqG\n\t\t\t\t\t\tSIb3DQEBCwUAA4IBAQAx2Xfd1pfAlPepfSX4KUPbhJaq+Z2695FVOW+KqBC/L6db\n\t\t\t\t\t\tjyUYQtoi1X9yge4FaVNt1GMMUv9XVcvH6O7UTLdXBiSXXW/BbhLzRgnf09Mtta0y\n\t\t\t\t\t\tskCRNaStwWbIrDFRegIk0rFUya3n2oR5B5ZW0ah7C93sxYbVbSMZmVfUpf/oZY79\n\t\t\t\t\t\tUZhImwhWAzMfvKgzPySFAXOmoShseo6hrOTyeWJgVxT4EKtifhyhdTZDkT8XykbX\n\t\t\t\t\t\tCA34rv87jODyi+dYGhbegFiuJoDo/9/weL0BH5N48yW18sSjRkURF5VXGbPMUx96\n\t\t\t\t\t\t8Knhux1hK+cTlx1vIfHtJa81w/f3BtS7gweYmKp4"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://test.stir.unidesk.ac.uk/tas/secure/login/verify",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor"
        }
      ]
    }
  ],
  [
    "https://connect-beta.sunet.se/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:noc@nordu.net"
            }
          ],
          "company": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company",
            "text": "NORDUnet NOC"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://connect-beta.sunet.se/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/nren-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/eu-adequate-protection"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "NORDUnet A/S"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.nordu.net"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "NORDUnet"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "SUNET E-Meeting Service (beta)"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "SUNET E-Meeting Service (beta)"
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.16.840.1.113730.3.1.241",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://connect-beta.sunet.se/Shibboleth.sso/DS/ds.swamid.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://connect-beta.sunet.se/Shibboleth.sso/DS/ds.sunet.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://connect-beta.sunet.se/Shibboleth.sso/DS/kalmar2",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "3"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://connect-beta.sunet.se/Shibboleth.sso/DS/nordu.net",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "4"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "connect-beta.sunet.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDBjCCAe6gAwIBAgIJAPlfAgYiS2HzMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFWNvbm5lY3QtYmV0YS5zdW5ldC5zZTAeFw0xNDExMjkxMTE4NTVaFw0yNDEx\nMjYxMTE4NTVaMCAxHjAcBgNVBAMTFWNvbm5lY3QtYmV0YS5zdW5ldC5zZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANMhbRolAnPwqhMMJvS76dzc0tLp\neEjwS5GTMFIZSic54pnHHEnBGgQAZkPmputFdioAV6eZw2qHAGvROcQTRk4jeIXo\naULWXN9fNq+EZa/1SdzdtC3z5WqoyV+DYNWgOh0jI+iCh9mQpCEs8TtImWWZbVFY\nUev5+Cf3wJCi5RMYSU6oBD0/zpHq/+7fDjXCs7Coe7q9o1mQqw08mDCH8/Gb+mgg\nUPjQWL6U7oGWBJ0s4Bclc9WPUQQQVE8C6wt+CvQw6Eg1maV2f28si3ez1ybZv27w\nXgH/pTnib1FmLWBTSETkFOZs4ZRxoKgU838lRUktc58CEGKQhwisaKqfd+ECAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVY29ubmVjdC1iZXRhLnN1bmV0LnNlMB0GA1UdDgQW\nBBS4cKd+yNhVRbYHclbmpNeBJySm6TANBgkqhkiG9w0BAQUFAAOCAQEAHnWZUpzK\nFU+MdGvtwH249x7sQtj7mXSISsX1rnfy6M1Zz7SWtkSeFgijQvpNEDsIfRXtMApS\nzegZMJEAbnVQ9OVXcVD1zgoHdob0qjJ3KXlc/lByeosty1Q6TLI1NtGZzS23COmP\nH/AVOR5U++JOt28OOfoi7mtxOFPxkge3AooWLNFOEOGMSF78BG8NCrT0l59OnAtN\n3sN7PXo740wv8cQLou3/kv+NHOMwdhdiCTvY9JttcRsT55rHbWRpgDbqYTvyEhkD\n3Zul4UGjlp2ilyjkZqr+qOUEAdjC63hNBmNMEtJGi2vhEyi2BN+F1PfoB5mot7A0\n15RMslPZtWnEtQ=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=connect-beta.sunet.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "connect-beta.sunet.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDBjCCAe6gAwIBAgIJAPlfAgYiS2HzMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFWNvbm5lY3QtYmV0YS5zdW5ldC5zZTAeFw0xNDExMjkxMTE4NTVaFw0yNDEx\nMjYxMTE4NTVaMCAxHjAcBgNVBAMTFWNvbm5lY3QtYmV0YS5zdW5ldC5zZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANMhbRolAnPwqhMMJvS76dzc0tLp\neEjwS5GTMFIZSic54pnHHEnBGgQAZkPmputFdioAV6eZw2qHAGvROcQTRk4jeIXo\naULWXN9fNq+EZa/1SdzdtC3z5WqoyV+DYNWgOh0jI+iCh9mQpCEs8TtImWWZbVFY\nUev5+Cf3wJCi5RMYSU6oBD0/zpHq/+7fDjXCs7Coe7q9o1mQqw08mDCH8/Gb+mgg\nUPjQWL6U7oGWBJ0s4Bclc9WPUQQQVE8C6wt+CvQw6Eg1maV2f28si3ez1ybZv27w\nXgH/pTnib1FmLWBTSETkFOZs4ZRxoKgU838lRUktc58CEGKQhwisaKqfd+ECAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVY29ubmVjdC1iZXRhLnN1bmV0LnNlMB0GA1UdDgQW\nBBS4cKd+yNhVRbYHclbmpNeBJySm6TANBgkqhkiG9w0BAQUFAAOCAQEAHnWZUpzK\nFU+MdGvtwH249x7sQtj7mXSISsX1rnfy6M1Zz7SWtkSeFgijQvpNEDsIfRXtMApS\nzegZMJEAbnVQ9OVXcVD1zgoHdob0qjJ3KXlc/lByeosty1Q6TLI1NtGZzS23COmP\nH/AVOR5U++JOt28OOfoi7mtxOFPxkge3AooWLNFOEOGMSF78BG8NCrT0l59OnAtN\n3sN7PXo740wv8cQLou3/kv+NHOMwdhdiCTvY9JttcRsT55rHbWRpgDbqYTvyEhkD\n3Zul4UGjlp2ilyjkZqr+qOUEAdjC63hNBmNMEtJGi2vhEyi2BN+F1PfoB5mot7A0\n15RMslPZtWnEtQ=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=connect-beta.sunet.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://connect-beta.sunet.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://idp.uniroma3.it/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Technical Support"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:idem@uniroma3.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.uniroma3.it/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.idem.garr.it/idem-metadata-registration-practice-statement"
              }
            ],
            "registration_instant": "2009-12-31T15:00:00Z",
            "registration_authority": "http://www.idem.garr.it/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFQTCCBCmgAwIBAgIQBTxw+2vP6xm5lPNGi9q8AzANBgkqhkiG9w0BAQ0FADBk\nMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJ\nQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wg\nQ0EgMzAeFw0xNjAxMjUwMDAwMDBaFw0xOTAxMjkxMjAwMDBaMHExCzAJBgNVBAYT\nAklUMQ4wDAYDVQQIEwVJdGFseTENMAsGA1UEBxMEUm9tZTEpMCcGA1UECgwgVW5p\ndmVyc2l0w6AgZGVnbGkgU3R1ZGkgUm9tYSBUUkUxGDAWBgNVBAMTD2lkcC51bmly\nb21hMy5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKJYlicKcg0O\nYFbsM608K0gczymf4q0Wwt1xK3NDNVdLNTxLEB1yYDSo5KaXTPREeigN/KEcEI0q\nmx2NkMg2Gp3Rxfo0V+l1/cILd6BygxvI0YLVCYqO2D6Guna5QZxSAzhnTcPoTpte\neWAPtqCeOSlpZ9woztQGQJEF9i5pQN6eVPGvIaB4Dxq24AI64uFwuOarhtDauvk/\nKA9hy6pAbSkXgsabdSHytR/vTvfK4e8WIc5pMa8W7apIWHX9bj2G0ElzYIsB89Zl\ne05QVjCCcJ7jfTjuVMFDc4ef816vLq6vmRjQi57tGieyjH0tTFb0tX39P2fJ90/e\nDCg7v/lCVIECAwEAAaOCAeAwggHcMB8GA1UdIwQYMBaAFGf9iCAUJ5jHCdIlGbvp\nURFjdVBiMB0GA1UdDgQWBBROeTzj9F4M6HIC/gAVKpJOQWKmajAyBgNVHREEKzAp\ngg9pZHAudW5pcm9tYTMuaXSCFnNoaWJib2xldGgudW5pcm9tYTMuaXQwDgYDVR0P\nAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8E\nZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0Ez\nLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENB\nMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0\ncHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEE\nYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYB\nBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMu\nY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQENBQADggEBABJgwxpy4mqcAR7C\nql/pvWh1dJ6UqyKlMmuvqf2q1A6XmsSEDD/3SP43+Eoxl/tNMKOTN+UPd8hBjgUH\njeVHzJ3AGAFPuuQ5fR9Ix1kMpgz4TqiqAwfslEFGog0iJbztjwGNcxVvuu3nGqYn\nV0IBzXEahifLGtRI52rgG7nJv/n0PmIcmn/DzEPlwm6DhGsa2e82U/OtbyEEfxZ+\nNDVBxYV/3T+NqEEaACLHePhzY8bUg4WTrToZa/I2/+cKiyXOsbYVr1ZKsOUtcLxL\nVG+4Km92F9fZ4aFwmSvZZKs65ZhSh7Re6fwiExrnQRFAgN8aZx9k++IFyC6cK0/g\n5iHa3Cc="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "uniroma3.it"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.uniroma3.it:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.uniroma3.it:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.uniroma3.it/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.uniroma3.it/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.uniroma3.it/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.uniroma3.it/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.uniroma3.it:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.uniroma3.it:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "uniroma3.it"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.idem.uniroma3.it/EN"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.idem.uniroma3.it/IT"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider for Roma TRE members"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider per gli utenti di Roma Tre"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University Roma TRE IdP"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Universit\u00e0 di Roma Tre IdP"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFQTCCBCmgAwIBAgIQBTxw+2vP6xm5lPNGi9q8AzANBgkqhkiG9w0BAQ0FADBk\nMQswCQYDVQQGEwJOTDEWMBQGA1UECBMNTm9vcmQtSG9sbGFuZDESMBAGA1UEBxMJ\nQW1zdGVyZGFtMQ8wDQYDVQQKEwZURVJFTkExGDAWBgNVBAMTD1RFUkVOQSBTU0wg\nQ0EgMzAeFw0xNjAxMjUwMDAwMDBaFw0xOTAxMjkxMjAwMDBaMHExCzAJBgNVBAYT\nAklUMQ4wDAYDVQQIEwVJdGFseTENMAsGA1UEBxMEUm9tZTEpMCcGA1UECgwgVW5p\ndmVyc2l0w6AgZGVnbGkgU3R1ZGkgUm9tYSBUUkUxGDAWBgNVBAMTD2lkcC51bmly\nb21hMy5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKJYlicKcg0O\nYFbsM608K0gczymf4q0Wwt1xK3NDNVdLNTxLEB1yYDSo5KaXTPREeigN/KEcEI0q\nmx2NkMg2Gp3Rxfo0V+l1/cILd6BygxvI0YLVCYqO2D6Guna5QZxSAzhnTcPoTpte\neWAPtqCeOSlpZ9woztQGQJEF9i5pQN6eVPGvIaB4Dxq24AI64uFwuOarhtDauvk/\nKA9hy6pAbSkXgsabdSHytR/vTvfK4e8WIc5pMa8W7apIWHX9bj2G0ElzYIsB89Zl\ne05QVjCCcJ7jfTjuVMFDc4ef816vLq6vmRjQi57tGieyjH0tTFb0tX39P2fJ90/e\nDCg7v/lCVIECAwEAAaOCAeAwggHcMB8GA1UdIwQYMBaAFGf9iCAUJ5jHCdIlGbvp\nURFjdVBiMB0GA1UdDgQWBBROeTzj9F4M6HIC/gAVKpJOQWKmajAyBgNVHREEKzAp\ngg9pZHAudW5pcm9tYTMuaXSCFnNoaWJib2xldGgudW5pcm9tYTMuaXQwDgYDVR0P\nAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBrBgNVHR8E\nZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vVEVSRU5BU1NMQ0Ez\nLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL1RFUkVOQVNTTENB\nMy5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAQEwKjAoBggrBgEFBQcCARYcaHR0\ncHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBAgIwbgYIKwYBBQUHAQEE\nYjBgMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wOAYIKwYB\nBQUHMAKGLGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9URVJFTkFTU0xDQTMu\nY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQENBQADggEBABJgwxpy4mqcAR7C\nql/pvWh1dJ6UqyKlMmuvqf2q1A6XmsSEDD/3SP43+Eoxl/tNMKOTN+UPd8hBjgUH\njeVHzJ3AGAFPuuQ5fR9Ix1kMpgz4TqiqAwfslEFGog0iJbztjwGNcxVvuu3nGqYn\nV0IBzXEahifLGtRI52rgG7nJv/n0PmIcmn/DzEPlwm6DhGsa2e82U/OtbyEEfxZ+\nNDVBxYV/3T+NqEEaACLHePhzY8bUg4WTrToZa/I2/+cKiyXOsbYVr1ZKsOUtcLxL\nVG+4Km92F9fZ4aFwmSvZZKs65ZhSh7Re6fwiExrnQRFAgN8aZx9k++IFyC6cK0/g\n5iHa3Cc="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Roma TRE"
          },
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Universit\u00e0 di Roma TRE"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uniroma3.it/en2/"
          },
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uniroma3.it/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Roma TRE"
          },
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Universit\u00e0 di Roma TRE"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.merthyr.ac.uk/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Watkins"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:a.watkins@merthyr.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Adam"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Watkins"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:a.watkins@merthyr.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Adam"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.merthyr.ac.uk/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDLzCCAhegAwIBAgIURCB/tUHtc3A/ovYJbLippy5MADIwDQYJKoZIhvcNAQEF\n\t\t\t\t\t\tBQAwHDEaMBgGA1UEAxMRaWRwLm1lcnRoeXIuYWMudWswHhcNMTEwNzA1MTExMjMx\n\t\t\t\t\t\tWhcNMzEwNzA1MTExMjMxWjAcMRowGAYDVQQDExFpZHAubWVydGh5ci5hYy51azCC\n\t\t\t\t\t\tASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJFAsCItsP8+n3dD74AGDmML\n\t\t\t\t\t\tLHA+qOSCF9QzNbyG6eUUmbbtq2YL03KomYlI0wV21lK9TDcUIVDwionhN+J5gzp/\n\t\t\t\t\t\tj0XQ6/aTWIPeT5Igyw6rpYQJHR0F4hSMkZPHgoEIf+pJ4KsOxcS8v45Hs5G5jobz\n\t\t\t\t\t\tKtksWzWz2saCt4Y0Dkbz1AhZuHeWRYkwx5HT231AdCgEOaCOieYqJizq+LGTNM9r\n\t\t\t\t\t\tiakEZEoQ1iBwzwOEeeWTCLAdq74nLg1IqvldRE9qrzMD383wp8QDcnFrpRG0FpAP\n\t\t\t\t\t\tzYDLciyZ6IehEB/197cVjAFhMBcR0g5LdWZRmchLYCIM5IRVeboxSOLJMzeRKUsC\n\t\t\t\t\t\tAwEAAaNpMGcwRgYDVR0RBD8wPYIRaWRwLm1lcnRoeXIuYWMudWuGKGh0dHBzOi8v\n\t\t\t\t\t\taWRwLm1lcnRoeXIuYWMudWsvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFCnF7X1W\n\t\t\t\t\t\tOJhryeXx3KqcXqwmzOMAMA0GCSqGSIb3DQEBBQUAA4IBAQBE9l2CvybnLgrucYfg\n\t\t\t\t\t\tXucF8nJ6iXP2co2/L4YnA9psqMNvHlFGmtqsRGcByS+XlYX1cKGCJ2UHj/0Zti0W\n\t\t\t\t\t\tRkjM0MT2NS/hBUv321UfMxJ6h7e/Xlrv4CTTxRO6kh5/9nXk8lfT6pcYFSGtC9b6\n\t\t\t\t\t\tKHr+IQ726FM2L2VCsoH/3htHDM5L89KhzVg8iQmyxpQBNcj3MgURzr9AtBlWRvK0\n\t\t\t\t\t\taMsJOAqGAm5SC+E7ckFz57KHdVRYNl+PzG2tsQa491vYhpNAxGb4zHc6xITNZ315\n\t\t\t\t\t\t0eUpscAC9+6x+Q53jgbzcKJ0011YisfPRo5mS0bMw1eMC849PJeX2p8MZeGgXuf8\n\t\t\t\t\t\twQ0d"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "merthyr.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.merthyr.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.merthyr.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.merthyr.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.merthyr.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.merthyr.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.merthyr.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.merthyr.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.merthyr.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "merthyr.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDLzCCAhegAwIBAgIURCB/tUHtc3A/ovYJbLippy5MADIwDQYJKoZIhvcNAQEF\n\t\t\t\t\t\tBQAwHDEaMBgGA1UEAxMRaWRwLm1lcnRoeXIuYWMudWswHhcNMTEwNzA1MTExMjMx\n\t\t\t\t\t\tWhcNMzEwNzA1MTExMjMxWjAcMRowGAYDVQQDExFpZHAubWVydGh5ci5hYy51azCC\n\t\t\t\t\t\tASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJFAsCItsP8+n3dD74AGDmML\n\t\t\t\t\t\tLHA+qOSCF9QzNbyG6eUUmbbtq2YL03KomYlI0wV21lK9TDcUIVDwionhN+J5gzp/\n\t\t\t\t\t\tj0XQ6/aTWIPeT5Igyw6rpYQJHR0F4hSMkZPHgoEIf+pJ4KsOxcS8v45Hs5G5jobz\n\t\t\t\t\t\tKtksWzWz2saCt4Y0Dkbz1AhZuHeWRYkwx5HT231AdCgEOaCOieYqJizq+LGTNM9r\n\t\t\t\t\t\tiakEZEoQ1iBwzwOEeeWTCLAdq74nLg1IqvldRE9qrzMD383wp8QDcnFrpRG0FpAP\n\t\t\t\t\t\tzYDLciyZ6IehEB/197cVjAFhMBcR0g5LdWZRmchLYCIM5IRVeboxSOLJMzeRKUsC\n\t\t\t\t\t\tAwEAAaNpMGcwRgYDVR0RBD8wPYIRaWRwLm1lcnRoeXIuYWMudWuGKGh0dHBzOi8v\n\t\t\t\t\t\taWRwLm1lcnRoeXIuYWMudWsvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFCnF7X1W\n\t\t\t\t\t\tOJhryeXx3KqcXqwmzOMAMA0GCSqGSIb3DQEBBQUAA4IBAQBE9l2CvybnLgrucYfg\n\t\t\t\t\t\tXucF8nJ6iXP2co2/L4YnA9psqMNvHlFGmtqsRGcByS+XlYX1cKGCJ2UHj/0Zti0W\n\t\t\t\t\t\tRkjM0MT2NS/hBUv321UfMxJ6h7e/Xlrv4CTTxRO6kh5/9nXk8lfT6pcYFSGtC9b6\n\t\t\t\t\t\tKHr+IQ726FM2L2VCsoH/3htHDM5L89KhzVg8iQmyxpQBNcj3MgURzr9AtBlWRvK0\n\t\t\t\t\t\taMsJOAqGAm5SC+E7ckFz57KHdVRYNl+PzG2tsQa491vYhpNAxGb4zHc6xITNZ315\n\t\t\t\t\t\t0eUpscAC9+6x+Q53jgbzcKJ0011YisfPRo5mS0bMw1eMC849PJeX2p8MZeGgXuf8\n\t\t\t\t\t\twQ0d"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Merthyr Tydfil College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.merthyr.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of South Wales"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/metadata.php/default-sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Oepen"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "lap-developers@ifi.uio.no"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Stephan"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/metadata.php/default-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/research-and-scholarship"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.feide.no/files/feide/metadata-registration-practice-statement.pdf"
              }
            ],
            "registration_instant": "2016-03-11T16:15:49Z",
            "registration_authority": "http://feide.no/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Oslo"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uio.no"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Oslo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.mn.uio.no/ifi/english/research/projects/clarino/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Ready-to-Run and State-of-the-Art Language Analysis Tools in the Cloud"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://www.mn.uio.no/ifi/english/research/projects/clarino/user/privacy/"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "LAP: UiO Language Analysis Portal (Production)"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE/zCCA+egAwIBAgIRAJIQa4w218rFk4verorM7VswDQYJKoZIhvcNAQELBQAwZDELMAkGA1UEBhMCTkwxFjAUBgNVBAgTDU5vb3JkLUhvbGxhbmQxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMRgwFgYDVQQDEw9URVJFTkEgU1NMIENBIDIwHhcNMTUwNjMwMDAwMDAwWhcNMTgwNjI5MjM1OTU5WjA8MSEwHwYDVQQLExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxFzAVBgNVBAMTDmNsYXJpbm8udWlvLm5vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzWtCRL9wf3nor/dUkG00Xg4jmr6nZX5qxOCHDX0rRJB8VWU52kfQyKWViv5BtcsnIweBqJ75sobprZuKcDILRf36F4i4D6lPcxFvDac1DA6smlfP+sMyf5ntfJkc6sMjgDQ/2CQKFvcwYlhJSXStR1Hc95+GRXK4ou30XXv6MaU98OR+laQuOqsQB6VBh60iRDXNrKhrePG3HJujn79VcLB4N79Tk5GV+BuqvZP8Mh+cTK6q/XN5EM13/CMXdPtng0Fh9RPJNBYgA/cmXHFdEM+/9HfdUOfyByeYEHOuKXUr/dLJQ7tYUds494qxCdkEckt0o92OxpRTztsvI+YcDQIDAQABo4IB0jCCAc4wHwYDVR0jBBgwFoAUW9CKHJoyW+C13ZZUG+GGKLD9tr0wHQYDVR0OBBYEFMUNIwQsUMuAUNhNsROf0SU9l2aZMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAiBgNVHSAEGzAZMA0GCysGAQQBsjEBAgIdMAgGBmeBDAECATA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVEVSRU5BU1NMQ0EyLmNybDBsBggrBgEFBQcBAQRgMF4wNQYIKwYBBQUHMAKGKWh0dHA6Ly9jcnQudXNlcnRydXN0LmNvbS9URVJFTkFTU0xDQTIuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMIGABgNVHREEeTB3gg5jbGFyaW5vLnVpby5ub4ISZWRkLmNsYXJpbm8udWlvLm5vghVnbG9zc2EuY2xhcmluby51aW8ubm+CEmxhcC5jbGFyaW5vLnVpby5ub4ISc3ZuLmNsYXJpbm8udWlvLm5vghJ3d3cuY2xhcmluby51aW8ubm8wDQYJKoZIhvcNAQELBQADggEBADHuVaZ2ymF0bhfypJB0w2XfTXTcO7wbkuRLcrvv+3BQgHGv5j5xTjK6AesSxXE0KCtpJnTrR8TEQFbLhuUs0m4VyHlW8DivkccYbSzGvTewkxWSuxUFQhBWKhfNX4bPV88w9aLog358lHQBiqwY+cJYW8+Y48w49noiZDTCY7Z8jMbVj8jTVqC6bMELBMeV4stgzkT/RBFc1rroBhDeyjElugiph5RUtjwP/H/tAlLO241jMtIfbzRV/CwF9aEfpe/fAj4PXAWnK+KYz3ZqG4Q9s3GRNQZQfuLoEilwGvLSfhmdDXHQdDlubsO6iCUOwH0YwVRHP2OY95WzeMuD+H8="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE/zCCA+egAwIBAgIRAJIQa4w218rFk4verorM7VswDQYJKoZIhvcNAQELBQAwZDELMAkGA1UEBhMCTkwxFjAUBgNVBAgTDU5vb3JkLUhvbGxhbmQxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMRgwFgYDVQQDEw9URVJFTkEgU1NMIENBIDIwHhcNMTUwNjMwMDAwMDAwWhcNMTgwNjI5MjM1OTU5WjA8MSEwHwYDVQQLExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxFzAVBgNVBAMTDmNsYXJpbm8udWlvLm5vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzWtCRL9wf3nor/dUkG00Xg4jmr6nZX5qxOCHDX0rRJB8VWU52kfQyKWViv5BtcsnIweBqJ75sobprZuKcDILRf36F4i4D6lPcxFvDac1DA6smlfP+sMyf5ntfJkc6sMjgDQ/2CQKFvcwYlhJSXStR1Hc95+GRXK4ou30XXv6MaU98OR+laQuOqsQB6VBh60iRDXNrKhrePG3HJujn79VcLB4N79Tk5GV+BuqvZP8Mh+cTK6q/XN5EM13/CMXdPtng0Fh9RPJNBYgA/cmXHFdEM+/9HfdUOfyByeYEHOuKXUr/dLJQ7tYUds494qxCdkEckt0o92OxpRTztsvI+YcDQIDAQABo4IB0jCCAc4wHwYDVR0jBBgwFoAUW9CKHJoyW+C13ZZUG+GGKLD9tr0wHQYDVR0OBBYEFMUNIwQsUMuAUNhNsROf0SU9l2aZMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAiBgNVHSAEGzAZMA0GCysGAQQBsjEBAgIdMAgGBmeBDAECATA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVEVSRU5BU1NMQ0EyLmNybDBsBggrBgEFBQcBAQRgMF4wNQYIKwYBBQUHMAKGKWh0dHA6Ly9jcnQudXNlcnRydXN0LmNvbS9URVJFTkFTU0xDQTIuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMIGABgNVHREEeTB3gg5jbGFyaW5vLnVpby5ub4ISZWRkLmNsYXJpbm8udWlvLm5vghVnbG9zc2EuY2xhcmluby51aW8ubm+CEmxhcC5jbGFyaW5vLnVpby5ub4ISc3ZuLmNsYXJpbm8udWlvLm5vghJ3d3cuY2xhcmluby51aW8ubm8wDQYJKoZIhvcNAQELBQADggEBADHuVaZ2ymF0bhfypJB0w2XfTXTcO7wbkuRLcrvv+3BQgHGv5j5xTjK6AesSxXE0KCtpJnTrR8TEQFbLhuUs0m4VyHlW8DivkccYbSzGvTewkxWSuxUFQhBWKhfNX4bPV88w9aLog358lHQBiqwY+cJYW8+Y48w49noiZDTCY7Z8jMbVj8jTVqC6bMELBMeV4stgzkT/RBFc1rroBhDeyjElugiph5RUtjwP/H/tAlLO241jMtIfbzRV/CwF9aEfpe/fAj4PXAWnK+KYz3ZqG4Q9s3GRNQZQfuLoEilwGvLSfhmdDXHQdDlubsO6iCUOwH0YwVRHP2OY95WzeMuD+H8="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://lap.clarino.uio.no/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "LAP: UiO Language Analysis Portal (Production)"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Ready-to-Run and State-of-the-Art Language Analysis Tools in the Cloud"
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "https://www.123library.org/oa/metadata",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Benjamin"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:timbenjamin@123doc.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tim"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Benjamin"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:timbenjamin@123doc.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tim"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://www.123library.org/oa/metadata",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_instant": "2012-11-02T10:40:16Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "123 Library"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.123library.org/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "123Doc Education Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "authn_requests_signed": "false",
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDfDCCAmSgAwIBAgIJAOqpAln6yGDwMA0GCSqGSIb3DQEBBQUAMDIxEzARBgNV\n\t\t\t\t\t\tBAoTCjEyM0xpYnJhcnkxGzAZBgNVBAMTEnd3dy4xMjNsaWJyYXJ5Lm9yZzAeFw0x\n\t\t\t\t\t\tNTAxMDkxNjI0NTVaFw0yNTAxMDYxNjI0NTVaMDIxEzARBgNVBAoTCjEyM0xpYnJh\n\t\t\t\t\t\tcnkxGzAZBgNVBAMTEnd3dy4xMjNsaWJyYXJ5Lm9yZzCCASIwDQYJKoZIhvcNAQEB\n\t\t\t\t\t\tBQADggEPADCCAQoCggEBALNX0cg2tfg5w/8mF6+jaYx5vJYaY2viY90ZPZD4YiVF\n\t\t\t\t\t\tEvr0yHv40gdZoDaPrQpI/z+krN1Hv8zz2aFi2jkSJ6udzVCmzV1fxVSeUtAyW7j/\n\t\t\t\t\t\tdQDuApuBmReKdsBKbUUH0cOehMdPwJM5jUm8BUpUKd1jO5/b3AhNZWQnxeDJVmzy\n\t\t\t\t\t\tCdHGc3BJhe7RBi7hLJTlX/1AbD1dHLMjU/U2813rt+MB+QfPVzuCkajNNA5pY6OJ\n\t\t\t\t\t\tksDx/Q9SGZLgrGvFUE64MH/ffvQ8/jR33aJAQ7v1y463MpVQqxZLlxh/GtSPu9nD\n\t\t\t\t\t\tzqYSl80fTFns7omQ/uOQv1y91SMe42M8qGysv3HaRL0CAwEAAaOBlDCBkTAdBgNV\n\t\t\t\t\t\tHQ4EFgQUrxHW4/Azow1MEfosgbCPRp3DNacwYgYDVR0jBFswWYAUrxHW4/Azow1M\n\t\t\t\t\t\tEfosgbCPRp3DNaehNqQ0MDIxEzARBgNVBAoTCjEyM0xpYnJhcnkxGzAZBgNVBAMT\n\t\t\t\t\t\tEnd3dy4xMjNsaWJyYXJ5Lm9yZ4IJAOqpAln6yGDwMAwGA1UdEwQFMAMBAf8wDQYJ\n\t\t\t\t\t\tKoZIhvcNAQEFBQADggEBAATMW4Py6IHcQbxj26vK9mQNlpWAy/Ah2fp5CFhpm2PK\n\t\t\t\t\t\tDsGjjf4Wn4NWQyc2G7bmCPLRYQa2douIBzWpZ1n3S/tnaf2855LHsa/WV8gKuoN4\n\t\t\t\t\t\txFpGWiS8c7KOZvhJuvqP1K9mAMBbCeEocFB+OpzwvpVn0chSzBfs89aVDO7iHXpJ\n\t\t\t\t\t\tYHz4dJsJ76McTVdPTAKila/Hjgq4dt4xRodj45MlgX3SApqQLQnLJPZoF40Ug478\n\t\t\t\t\t\tFZl7Wye00MsuE+Rphr+nsnbjKJquxjSUe1K/Ayb4RfoQz5Z4G9g0skthUkl0IsUr\n\t\t\t\t\t\tOoPW3kslUwruNUj/IpAl13p9ahFKw3C83XJgOQmtZog="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "want_assertions_signed": "false",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "index": "1",
              "location": "https://www.123library.org/oa/auth/rcv/shib/post",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "is_default": "true"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.123library.org/oa/auth/rcv/shib/art",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.123library.org/oa/auth/rcv/saml2/post",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.123library.org/oa/auth/rcv/saml2/art",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor"
        }
      ]
    }
  ],
  [
    "https://science-gateway.chain-project.eu/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:credentials-admin@ct.infn.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://science-gateway.chain-project.eu/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.idem.garr.it/idem-metadata-registration-practice-statement"
              }
            ],
            "registration_instant": "2014-10-10T07:30:00Z",
            "registration_authority": "http://www.idem.garr.it/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "INFN ROMA3"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.roma3.infn.it/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "INFN ROMA3"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://science-gateway.chain-project.eu/service"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://science-gateway.chain-project.eu/service"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "The CHAIN-REDS Science Gateway is a standard-based web 2.0 platform to show the use cases and other demonstrative applications identified by the CHAIN-REDS project (www.chain-project.eu) and execute them on a worldwide e-Infrastructure based on different paradigms (Grid, Cloud and local HPC Cluster Computing)"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Il Sciece Gateway del progetto CHAIN-REDS e' una piattaforma web 2.0 basata su standard avente la finilita'  di mostrare speciali casi d'uso ed appicazioni identificate all'interno del progetto (www.chain-project.eu) ed eseguire queste su una infrastruttura di calcolo distribuita su base mondiale e con differenti paradigmi (grid, cloud, HPC)"
                  }
                ],
                "privacy_statement_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://science-gateway.chain-project.eu/policy"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL",
                    "text": "http://science-gateway.chain-project.eu/policy"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "CHAIN-REDS Science Gateway"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "CHAIN-REDS Science Gateway"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIE8TCCA9mgAwIBAgIRAJkwiwyfpx7usj9S/zvy7rIwDQYJKoZIhvcNAQELBQAw\nZDELMAkGA1UEBhMCTkwxFjAUBgNVBAgTDU5vb3JkLUhvbGxhbmQxEjAQBgNVBAcT\nCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMRgwFgYDVQQDEw9URVJFTkEgU1NM\nIENBIDIwHhcNMTUwNTA3MDAwMDAwWhcNMTgwNTA2MjM1OTU5WjBLMSEwHwYDVQQL\nExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxJjAkBgNVBAMTHXNjaWVuY2UtZ2F0\nZXdheS5yb21hMy5pbmZuLml0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAyzvRvoZbRbXCb5eTXKcL9zK6ZQGX/e4ccq5S+3FWoydzIjkU9LZ79o3hkwHU\ng+OSIJFs9GKYrMvVBgiG3+BY2DGyCmH+XEigqw43pmkC9VTK8bl6J8sOWjFbGC/X\nAq3Z7gcpzA6kjCkGqTszC/Duid/J/rBHoFJXZrWljAnbYFEeYm9v9IgYtOOQzYtU\nGx4qBSMfCgFl4OcpfRre+UPNA0+2srdcX88HxtdRNBODoIsD9o4d8f0LkSVXVwv1\nWzJycCGsUTPOTAExrjQGvK1Ufsfy8I/yRTgTc9SnwTixyQ+nSLjdR3I4EsrPEUUx\n8bAAAhwjctyC6rz9hjIBdjRDVQIDAQABo4IBtTCCAbEwHwYDVR0jBBgwFoAUW9CK\nHJoyW+C13ZZUG+GGKLD9tr0wHQYDVR0OBBYEFBD3hmwITDYUQR2HIerZcvF9dMsX\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAiBgNVHSAEGzAZMA0GCysGAQQBsjEBAgIdMAgGBmeBDAEC\nATA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVEVS\nRU5BU1NMQ0EyLmNybDBsBggrBgEFBQcBAQRgMF4wNQYIKwYBBQUHMAKGKWh0dHA6\nLy9jcnQudXNlcnRydXN0LmNvbS9URVJFTkFTU0xDQTIuY3J0MCUGCCsGAQUFBzAB\nhhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMGQGA1UdEQRdMFuCHXNjaWVuY2Ut\nZ2F0ZXdheS5yb21hMy5pbmZuLml0ghhncmlkc3J2LTAzLnJvbWEzLmluZm4uaXSC\nIHNjaWVuY2UtZ2F0ZXdheS5jaGFpbi1wcm9qZWN0LmV1MA0GCSqGSIb3DQEBCwUA\nA4IBAQBRQFOhixQr232gE3iNYIth4OzlMwK3pftdxdsgt3rrOHQBHFv5QBbZL42m\n0KH+EwUtk1fjDtg4FHWqnEC+GgLgNouvSiFCR0Sa/mQPx7aya+j4F0kslz/7yazI\n9bdgXkwuetwmHX1lGtbw3aUKokULJhPUu2yvxPe5fC+YwJYBzeuVn6EOITXdjHRQ\n/1e8otsVnM4pm8JDKkS1ZXWPrQf4XrmYhUDC5vyIaVJNONlWVeUaHxkLf4mP2d2x\nyfCKbqhsoCXGNbLT2AgzayLYMJRckuTX3VNGFDTdbiFiv62Z842eKkLYlpRYxUi/\n+3A6Rx0nC5V7eKNZwLSToOSPSEQA"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://science-gateway.chain-project.eu/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "CHAIN-REDS Science Gateway"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "The CHAIN-REDS Science Gateway is a standard-based web 2.0 platform to show the use cases and other demonstrative applications identified by the CHAIN-REDS project (www.chain-project.eu) and execute them on a worldwide e-Infrastructure based on different paradigms (Grid, Cloud and local HPC Cluster Computing)"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "mail",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  [
    "https://openathens.keele.ac.uk/oala/metadata",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Carter"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:n.carter@keele.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Neil"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bridges"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:n.w.bridges@keele.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Norman"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://openathens.keele.ac.uk/oala/metadata",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2011-06-23T16:46:00Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://openathens.keele.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://openathens.keele.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "keele.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID5zCCAs+gAwIBAgIJAJYE6X8FdcoOMA0GCSqGSIb3DQEBBQUAMIGJMQswCQYD\n\t\t\t\t\t\tVQQGEwJHQjEWMBQGA1UECAwNU3RhZmZvcmRzaGlyZTEOMAwGA1UEBwwFS2VlbGUx\n\t\t\t\t\t\tHDAaBgNVBAoME1VuaXZlcnNpdHkgb2YgS2VlbGUxEzARBgNVBAsMCm9wZW5hdGhl\n\t\t\t\t\t\tbnMxHzAdBgNVBAMMFm9wZW5hdGhlbnMua2VlbGUuYWMudWswHhcNMTMxMjE2MTYy\n\t\t\t\t\t\tMTMyWhcNMjMxMjE3MTYyMTMyWjCBiTELMAkGA1UEBhMCR0IxFjAUBgNVBAgMDVN0\n\t\t\t\t\t\tYWZmb3Jkc2hpcmUxDjAMBgNVBAcMBUtlZWxlMRwwGgYDVQQKDBNVbml2ZXJzaXR5\n\t\t\t\t\t\tIG9mIEtlZWxlMRMwEQYDVQQLDApvcGVuYXRoZW5zMR8wHQYDVQQDDBZvcGVuYXRo\n\t\t\t\t\t\tZW5zLmtlZWxlLmFjLnVrMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\n\t\t\t\t\t\toJKbr6JC7sgMXeXfP7Sj721oLA9jhqan0QnG/5NTm6v/HgkgQnjezp/uBD9OirA+\n\t\t\t\t\t\tpyCmYUhQWLBgiD8JxH5bhhmfTGUD3iLcUeo4yKPJPzyWhHjCru2iPSAbnvl6yzAQ\n\t\t\t\t\t\t7pBZFJktxfO4Dx6iOQsiaCC93z04GPdqL0eNt2NZNNX/X5r3HdYkzonf6DvYTEfR\n\t\t\t\t\t\tk/xkzj35q70jDKwIrIiMUFr+xzUeQUYzVE4gysoYoaIfDvcO3kPKUgTuIZvbDsBm\n\t\t\t\t\t\tQIkjOb3MQcqXL3JXrhv6nwCahJOTvORHxEBzD4LAaowVbtJsfU/FRKQph98FGvdZ\n\t\t\t\t\t\t9Sef14MLaj6OLM/0CTH8vQIDAQABo1AwTjAdBgNVHQ4EFgQUxaJLsEIgT0EQ9l/i\n\t\t\t\t\t\tX0XT8xDk764wHwYDVR0jBBgwFoAUxaJLsEIgT0EQ9l/iX0XT8xDk764wDAYDVR0T\n\t\t\t\t\t\tBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAExw2HRuHuKy63i3dBx7siDE333dA\n\t\t\t\t\t\tWote0EBhijBShMcGmfNl1I1n9clrfHlm/yBuOyZABwysuTsjmNVWnaYOPGX53sxP\n\t\t\t\t\t\tGz2ibT6mPhZKVu0XiMaeoMnW0KO/SBCdYlLP6Z0J9NWU5c5prP9Nwmz+lcDH2qB8\n\t\t\t\t\t\tCIjUT62cW6wo0WKs4QuucTw5zDlZCqT62yWqhb5RAlB0yy0nHDZfi69RXl5y8vhx\n\t\t\t\t\t\thwcXwYvkeiw1BrLJj80Qw1LvBn1M6oqZ6TfYLrX8ub2JdhGudeFY8K2XZS2p0oEu\n\t\t\t\t\t\tdfpSmtW4JDyR0X8mLpFU61SdoVKWIZ+1UOtRO1YbGVbeQntrmy3E5LGStw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Keele University"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.keele.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Keele"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://sp.swamid.se/shibboleth",
    {
      "entity_id": "https://sp.swamid.se/shibboleth",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/nren-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/sfs-1993-1153"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Swedish Academic Identity Federation (SWAMID)"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.swamid.se"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "SWAMID"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.swamid.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://sp.swamid.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.swamid.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.swamid.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "SWAMID Test SP"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "SWAMID Test SP"
                }
              ],
              "index": "0",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.swamid.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://sp.swamid.se/Shibboleth.sso/DS/ds.swamid.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://sp.swamid.se/Shibboleth.sso/DS/ds.sunet.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              },
              {
                "information_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.swamid.se"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.swamid.se"
                  }
                ],
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Detta \u00e4r en applikation som l\u00e5ter dig testa federerad inloggning."
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "This is an application for testing federated authentication."
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "SWAMID Test SP"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "SWAMID Test SP"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "https://sp.swamid.se/shibboleth"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "sp.swamid.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDDDCCAfSgAwIBAgIJAKP67GrfYHgtMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDHNwLnN3YW1pZC5zZTAeFw0wOTA2MTYxMTA3NTRaFw0xOTA2MTQxMTA3NTRa\nMBcxFTATBgNVBAMTDHNwLnN3YW1pZC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAOVNkKXqQZrXXNCk7nE7JTsqyjuwbshkafxDCI7XN6HSaRcnR+OY\nswVYkSvGXfMr4XQLzAGyIOfYDcHwOqZina11Zf8sOdD5t6mygGKza+LzbGZN9d4y\nSosskTH1NiCVBCTdJVpfwU2+K87DKrT9xtuRf7TMDDKA3gjPtN+/IxT6hw2+oZZi\nUgQgJoGN68WO9C4c/WMfcFf7hgC7fSt4fji9MFNpJoOw9MsuaRgYEVkCaHubLj46\nYa3NbyY48zzAuc4ix8hoLJ9dP+nUCyGKtkY81HprKGtuiu8kYSo+pC20nv1Qr8xP\nFhSU14YvXPUIVOGfX9zsGVLOQKpkb4Z4AkUCAwEAAaNbMFkwOAYDVR0RBDEwL4IM\nc3Auc3dhbWlkLnNlhh9odHRwczovL3NwLnN3YW1pZC5zZS9zaGliYm9sZXRoMB0G\nA1UdDgQWBBTpV1dUBMfW7y2/Rjo17VSql2/AijANBgkqhkiG9w0BAQUFAAOCAQEA\nSsYAA5tq6JjKqI5u2gvZfhM5S6ZKgrvciayGoezdTI6FfvpS3kWtCTZlu+CGDYIW\nVBpMtgQ84HpTrGbr3X1w25mspK+hsXi3K7SKqdfMdc0JynwNPrlL4GgmTuR/fgoo\ntuE0Wnbi7xdxpQ1qd0SFzw4gFWp1wC1+FsGtB9HLksSskgnNxniG9Z9+9WxgU6hD\nfJbH6eFgMDUPe2FpKiJ7LXqgiJWJRuK4zgFyGIZ5OFstLpkT/cXa8qNhtsbp2BPO\njxcbsxoUpA7Qgl/OFu7gzxLkLrl4iRSwk8MTj2bjVBvqvisLJAmuiYDBd9iZvqXB\nIznEEJKY8IltpfdkKGE20g=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=sp.swamid.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "https://sp.swamid.se/shibboleth"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "sp.swamid.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDDDCCAfSgAwIBAgIJAKP67GrfYHgtMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDHNwLnN3YW1pZC5zZTAeFw0wOTA2MTYxMTA3NTRaFw0xOTA2MTQxMTA3NTRa\nMBcxFTATBgNVBAMTDHNwLnN3YW1pZC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAOVNkKXqQZrXXNCk7nE7JTsqyjuwbshkafxDCI7XN6HSaRcnR+OY\nswVYkSvGXfMr4XQLzAGyIOfYDcHwOqZina11Zf8sOdD5t6mygGKza+LzbGZN9d4y\nSosskTH1NiCVBCTdJVpfwU2+K87DKrT9xtuRf7TMDDKA3gjPtN+/IxT6hw2+oZZi\nUgQgJoGN68WO9C4c/WMfcFf7hgC7fSt4fji9MFNpJoOw9MsuaRgYEVkCaHubLj46\nYa3NbyY48zzAuc4ix8hoLJ9dP+nUCyGKtkY81HprKGtuiu8kYSo+pC20nv1Qr8xP\nFhSU14YvXPUIVOGfX9zsGVLOQKpkb4Z4AkUCAwEAAaNbMFkwOAYDVR0RBDEwL4IM\nc3Auc3dhbWlkLnNlhh9odHRwczovL3NwLnN3YW1pZC5zZS9zaGliYm9sZXRoMB0G\nA1UdDgQWBBTpV1dUBMfW7y2/Rjo17VSql2/AijANBgkqhkiG9w0BAQUFAAOCAQEA\nSsYAA5tq6JjKqI5u2gvZfhM5S6ZKgrvciayGoezdTI6FfvpS3kWtCTZlu+CGDYIW\nVBpMtgQ84HpTrGbr3X1w25mspK+hsXi3K7SKqdfMdc0JynwNPrlL4GgmTuR/fgoo\ntuE0Wnbi7xdxpQ1qd0SFzw4gFWp1wC1+FsGtB9HLksSskgnNxniG9Z9+9WxgU6hD\nfJbH6eFgMDUPe2FpKiJ7LXqgiJWJRuK4zgFyGIZ5OFstLpkT/cXa8qNhtsbp2BPO\njxcbsxoUpA7Qgl/OFu7gzxLkLrl4iRSwk8MTj2bjVBvqvisLJAmuiYDBd9iZvqXB\nIznEEJKY8IltpfdkKGE20g=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=sp.swamid.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://sp.swamid.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://sp.swamid.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.swamid.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.swamid.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://sp.swamid.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://xploreuat.ieee.org/shibboleth-sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Caldwell"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:d.caldwell@ieee.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Don"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Trivedi"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:mh.trivedi@ieee.org"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Mehul"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://xploreuat.ieee.org/shibboleth-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "IEEE Xplore Digital Library Test SP"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ieee.org/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "The Institute of Electrical And Electronics Engineers, Incorporated"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIICtjCCAZ6gAwIBAgIEUcCIQjANBgkqhkiG9w0BAQUFADAdMRswGQYDVQQDExJ4cGxvcmV1YXQu\n\t\t\t\t\t\taWVlZS5vcmcwHhcNMTMwNjE4MTYxODEwWhcNMTYwNjE3MTYxODEwWjAdMRswGQYDVQQDExJ4cGxv\n\t\t\t\t\t\tcmV1YXQuaWVlZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCMJ0TBsTib1e6j\n\t\t\t\t\t\t9YowCopEZ42Qa2Sie35zYvVOPBYQtPaFH8vnCvRZM83gVKxj3G8LCyu7XnHfjm8unR5jUn6tmI4N\n\t\t\t\t\t\tH+G13cIwC12p1dkot2SxPTh7H6rWMdJiQMQJ00INgpeKE3dB3D6GxcuWjwYLsts8lvk8IuhCjuIh\n\t\t\t\t\t\t5FwDrFPD0T1HNIArg3y7iE9mMAPWr6lAFwHkHfGl9fb6Ic6ihxeFyDwOfPlmSZV0ivUq7+rteEQY\n\t\t\t\t\t\tb8h4Rr2pSLkL7ZTcYMrLjXFzca8cOdlaf+oTGWFik7/vGrsCAPSdF4tZnJ1xFl+EqOBJyCsGabYi\n\t\t\t\t\t\tTlVsq0dLwi35ewh0/tgTFMiJAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAH5knWR/f9aq52LG1uQO\n\t\t\t\t\t\tYnqWj7GwU+6MT9UxPZllvUVrb0icSxiAAlQ0+PqmQtL59vOYnP/ndFMKR0cYFKBoLMKIGfuo8/4q\n\t\t\t\t\t\taUyBHHvMbPErbc2518DH4BnD4e6nHY1+2EqispzNkohx2cyHRM/LuvQGjHEFPgV0eadjKT75rPKQ\n\t\t\t\t\t\td10xGdIKPL1f38NkoMsALGAPI5vhXnMD3xihF1VgIk1jFV96FQh6TBY7TwRBeAwv0MsKx9njtST1\n\t\t\t\t\t\tGiru0Nun+Co7b5Wj3MMzLfAIpvVZEZSPKf7x/BO0Wht7QWpVQQ6jxe4k8oRa9Sze4gIRNPVr5p2W\n\t\t\t\t\t\tYbSvqmDBZaFbuvrNaD4="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://xploreuat.ieee.org/Shibboleth/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://xploreuat.ieee.org/Shibboleth/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://xploreuat.ieee.org/Shibboleth/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://xploreuat.ieee.org/Shibboleth/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://sp.tools.sunet.se/shibboleth",
    {
      "entity_id": "https://sp.tools.sunet.se/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://tools.sunet.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://tools.sunet.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://tools.sunet.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://tools.sunet.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://tools.sunet.se/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "sampo.sunet.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC8TCCAdmgAwIBAgIJAI+J1ypxJJViMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDnNhbXBvLnN1bmV0LnNlMB4XDTEwMDMxNjEyNDg0NloXDTIwMDMxMzEyNDg0\nNlowGTEXMBUGA1UEAxMOc2FtcG8uc3VuZXQuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/ptcTBImyhr19TLXOQ3D2TmMvIVPY1o1xcFiqUPdQrsPV\nN/gNBH296AKnnrNvD5q6fCDug6I08VwiBa5FFtzcUAT7bMf0Vgvh4Cnun3PiHnTJ\nAWfdI6yuSXyf3rIiUcJAXQWpNkR1vbl7w18GiU21T7GFjUTcXsr1vsLpdaWG4+/I\nIYpZmK3CtQcI7Rv/uCQLRVWdOzp3Ds/TRmXeF4q7QV17nEnz/02WOaEZsCJurPOg\nsgzgemBXd8VE/vobqYTfn7yUvmgJKcHFpVqwwkIoVyNoVoIKBjiKYbRjuXThdDfp\nEYv5gtevD6szDBRNskTrzbPWpXnA/yne8yaspNgrAgMBAAGjPDA6MBkGA1UdEQQS\nMBCCDnNhbXBvLnN1bmV0LnNlMB0GA1UdDgQWBBT5t2mmKUW7CUXjzz7ewQVxdSMf\nmjANBgkqhkiG9w0BAQUFAAOCAQEALmHceqzrAarhcb7qAc8RfR3sezshQhMd6roh\nL3xFzwkAHeUnw4ZbMkbvnl+R8LUrbJRiLEPFFtNbUqa68TcS3c/B2dDK+qpbu6nC\njBc2tZW8Nz9ZCfxArqLn6WfJGg4Yhgo9OlfJxZbmdc0Ld0tp0d/F2FHYkVc1SbXk\nVWCSzQ48/y05mpXMcbhdp5PJuLOfX1R6VFvu04oWuA1J9NN03IYF5DwqupZIhN7i\n3+2PmYs4x/dZ1/1cYva9JUCwffmjo7sx6LbedNkKYQL/skTlL8CHo9snghUSYJSZ\nXyNIJHaDalIvdnrWnQFVketJt+fje9CgALP1Btsk1g0AyD7tYw=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=sampo.sunet.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "sampo.sunet.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC8TCCAdmgAwIBAgIJAI+J1ypxJJViMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDnNhbXBvLnN1bmV0LnNlMB4XDTEwMDMxNjEyNDg0NloXDTIwMDMxMzEyNDg0\nNlowGTEXMBUGA1UEAxMOc2FtcG8uc3VuZXQuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/ptcTBImyhr19TLXOQ3D2TmMvIVPY1o1xcFiqUPdQrsPV\nN/gNBH296AKnnrNvD5q6fCDug6I08VwiBa5FFtzcUAT7bMf0Vgvh4Cnun3PiHnTJ\nAWfdI6yuSXyf3rIiUcJAXQWpNkR1vbl7w18GiU21T7GFjUTcXsr1vsLpdaWG4+/I\nIYpZmK3CtQcI7Rv/uCQLRVWdOzp3Ds/TRmXeF4q7QV17nEnz/02WOaEZsCJurPOg\nsgzgemBXd8VE/vobqYTfn7yUvmgJKcHFpVqwwkIoVyNoVoIKBjiKYbRjuXThdDfp\nEYv5gtevD6szDBRNskTrzbPWpXnA/yne8yaspNgrAgMBAAGjPDA6MBkGA1UdEQQS\nMBCCDnNhbXBvLnN1bmV0LnNlMB0GA1UdDgQWBBT5t2mmKUW7CUXjzz7ewQVxdSMf\nmjANBgkqhkiG9w0BAQUFAAOCAQEALmHceqzrAarhcb7qAc8RfR3sezshQhMd6roh\nL3xFzwkAHeUnw4ZbMkbvnl+R8LUrbJRiLEPFFtNbUqa68TcS3c/B2dDK+qpbu6nC\njBc2tZW8Nz9ZCfxArqLn6WfJGg4Yhgo9OlfJxZbmdc0Ld0tp0d/F2FHYkVc1SbXk\nVWCSzQ48/y05mpXMcbhdp5PJuLOfX1R6VFvu04oWuA1J9NN03IYF5DwqupZIhN7i\n3+2PmYs4x/dZ1/1cYva9JUCwffmjo7sx6LbedNkKYQL/skTlL8CHo9snghUSYJSZ\nXyNIJHaDalIvdnrWnQFVketJt+fje9CgALP1Btsk1g0AyD7tYw=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=sampo.sunet.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://tools.sunet.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://tools.sunet.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://tools.sunet.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://tools.sunet.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://tools.sunet.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://myconcern.thinkiteducation.co.uk/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Bennett"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:nick.bennett@logicsoftware.co.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Nick"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Tucker"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:ian.tucker@logicsoftware.co.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Ian"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://myconcern.thinkiteducation.co.uk/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2014-12-12T09:37:03Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "MyConcern ThinkIT Integrated Demo Site"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.oneteamlogic.co.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "One Team Logic Ltd"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "The MyConcern ThinkIT Integrated Demo Site is used for demonstrating the joined up ThinkIT solution"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "MyConcern ThinkIT Integrated Demo Site"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDDzCCAfegAwIBAgIJAKF0PyvuaE7mMA0GCSqGSIb3DQEBBQUAMCMxITAfBgNV\n\t\t\t\t\t\tBAMTGHRoaW5rLW15Yy0wMS5zZXJlbi5sb2NhbDAeFw0xNDEyMDkxMTQwMTJaFw0y\n\t\t\t\t\t\tNDEyMDYxMTQwMTJaMCMxITAfBgNVBAMTGHRoaW5rLW15Yy0wMS5zZXJlbi5sb2Nh\n\t\t\t\t\t\tbDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAP5SUqhHh8zasv2aaTdf\n\t\t\t\t\t\tjkchvuKO0YzniwI3PNBg9NpL+cNiDyzQ/Qk9X625jQBj7rMD+IIR2XVg4SLChTjK\n\t\t\t\t\t\tS/+bkNDmq1eki/4pHQH/91fkOIscLpJvhp7OyGOKzWqors7REAWnJw1EeTurrV0B\n\t\t\t\t\t\tRXpX5wQLBnV8zKfEyBG12Q5nIP7LDg/+YRDV2EKYeLVcYWzgDzdi2xnRwuUigeiF\n\t\t\t\t\t\t00uMF+AWeen+0kjr9YNUnDbaECJ42m+DCjRGNuZ/Ty4hcCMXTlm1PoHQZf8B/CTj\n\t\t\t\t\t\tQQFx1VbMKUwtfLSF52TGH76iu21oIIuyS8AmHPyacEH1hjOkRgsO6odLo98AoBxO\n\t\t\t\t\t\tegkCAwEAAaNGMEQwIwYDVR0RBBwwGoIYdGhpbmstbXljLTAxLnNlcmVuLmxvY2Fs\n\t\t\t\t\t\tMB0GA1UdDgQWBBQ6KbEs1aIG7ZMKVkd2A/hR3MlT/zANBgkqhkiG9w0BAQUFAAOC\n\t\t\t\t\t\tAQEAO9Oe6XOW3B2zdbT8ayBlxGcHiOorP7GcE5nf6WI1h4FpWub11HIm+N3Wn+lI\n\t\t\t\t\t\tKlhihanbVe4My9QTwk67di82CDzjWSqVQe33rUiDyt9vG26XhPDM6znyzaJHD9V+\n\t\t\t\t\t\tCZ0ucm1cXKLna5recIfbZC1ezYWvQqQIaAQQ1rCuvGr8vB8W21dPnEMKORKJTOOd\n\t\t\t\t\t\tzXvof96kNX/JUr7jBRfw+XTgNZKgJGR3U8GlOKO1f6g/A9eLAoqzeb0s+Rtllczv\n\t\t\t\t\t\t2RMdnVWWAjZaLLMOTVmBF8ndB3CUurWfisv2GBVTHsmgKVtbUdHIS6o8NlQdnPk3\n\t\t\t\t\t\t9AfqjY3J5+HrbC8v/CbVhkudJw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://myconcern.thinkiteducation.co.uk/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://login.stolaf.edu/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "root@stolaf.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "St. Olaf Systems Team"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://login.stolaf.edu/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://login.stolaf.edu/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://login.stolaf.edu/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://login.stolaf.edu/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://login.stolaf.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://login.stolaf.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "stolaf.edu"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "St. Olaf College"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIEBTCCAu2gAwIBAgIJAIpCACOSmm5jMA0GCSqGSIb3DQEBBQUAMIGYMQswCQYD\nVQQGEwJVUzESMBAGA1UECAwJTWlubmVzb3RhMRMwEQYDVQQHDApOb3J0aGZpZWxk\nMRgwFgYDVQQKDA9TdCBPbGFmIENvbGxlZ2UxCzAJBgNVBAsMAklUMRkwFwYDVQQD\nDBBsb2dpbi5zdG9sYWYuZWR1MR4wHAYJKoZIhvcNAQkBFg9yb290QHN0b2xhZi5l\nZHUwHhcNMTIwODA4MTUzODM4WhcNMzIwODA4MTUzODM4WjCBmDELMAkGA1UEBhMC\nVVMxEjAQBgNVBAgMCU1pbm5lc290YTETMBEGA1UEBwwKTm9ydGhmaWVsZDEYMBYG\nA1UECgwPU3QgT2xhZiBDb2xsZWdlMQswCQYDVQQLDAJJVDEZMBcGA1UEAwwQbG9n\naW4uc3RvbGFmLmVkdTEeMBwGCSqGSIb3DQEJARYPcm9vdEBzdG9sYWYuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs6mj0mZ9xeLDbuGLO6ugsJWM\n5hN5Smi+MejkIv+Q95SVZP7tROG2kwMhMl8mPdV+xf8+vNG6GPLA58kyr5ShgLdf\nCAGYnoardWVvp9HVB4kcQA8CgizRmhupCKZqNqQOKg+7qejxHA863dWmPr4a62pS\nddoMuhAOl9yZBpnGHusHy8+Cfbdan8NqUXBX33STQVqA3980oUxLxpo+ywF0prV2\nbCy/54dgIScVT66TDuGZAwdmToRE6Yi4FePI4FFRh7ohOajadkmG1Ni/uEbWXYwl\nl6ehDhTkm0lo0uZ8D1LtCe6ydKE6UAE1ACAZfrfyEh6LfnzoiFJCrJoOzTHlrQID\nAQABo1AwTjAdBgNVHQ4EFgQUt/02+LxZnPfKIg3hVKI774yeF9IwHwYDVR0jBBgw\nFoAUt/02+LxZnPfKIg3hVKI774yeF9IwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEAAq57xrup7Jtuy0u2GCcTyqF44T6wPPXwMTmy8R1104gT8AQh7VHh\nUqBU4OUHx3ZUaXNkGOVFQUftc9BSBxKBuyK+6m1yLQyY1zV/WI9UG7wjtUBcu2Vn\nPEKSb+LrqVee+0fm1kMLa7BBH2eDOF3L+7A88JhWnLmpXZIPv/iLoqqibZuw+nDU\ncYnf3BffmuLLX119fYL+023+7YDfXolEbyd0nYVeWV2e33xt6RJtmWuO1VbQsPQZ\nGq8AofetoybsRS9b+CrRWiYzUvjZ0zkjDe9PMzvsXcS7xGD8/90X9damUttErlld\nYj2frn/AgpSfFIR4btP5vc0jd8Qy85QoDg=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "error_url": "http://www.stolaf.edu/services/iit/shibboleth/error.html"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "St. Olaf College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://stolaf.edu/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "St. Olaf College"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.prz.edu.pl/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "sysadmin@prz.edu.pl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Administrative Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.prz.edu.pl/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://aai.pionier.net.pl/en/index.php?page=rps"
              }
            ],
            "registration_instant": "2016-03-17T00:00:00Z",
            "registration_authority": "https://aai.pionier.net.pl",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category-support",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/POST-SimpleSign/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.prz.edu.pl:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.prz.edu.pl/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.prz.edu.pl/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.prz.edu.pl:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.prz.edu.pl:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "prz.edu.pl"
              },
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Rzeszow University of Technology Identity Provider"
                  },
                  {
                    "lang": "pl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Dostawca To\u017csamo\u015bci Politechniki Rzeszowskiej"
                  }
                ],
                "logo": [
                  {
                    "text": "https://w.prz.edu.pl/themes/prz/images/logop_prz.png",
                    "lang": "en",
                    "height": "88",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "222"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Rzeszow University of Technology"
                  },
                  {
                    "lang": "pl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Politechnika Rzeszowska"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDIzCCAgugAwIBAgIUSxn45JYq8osLNyE19Vpt1mgep1kwDQYJKoZIhvcNAQEL\nBQAwGTEXMBUGA1UEAwwOaWRwLnByei5lZHUucGwwHhcNMTUwNDE0MDczMDM4WhcN\nMzUwNDE0MDczMDM4WjAZMRcwFQYDVQQDDA5pZHAucHJ6LmVkdS5wbDCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJ9/JwepuJgIlNBrtzjdnaLe6iJ7YCXH\nO/1InUZSIr3P9R0Jm2/eCJI39RbpS/Ddrd1eseb2RzELS67HZ5+JM6phmQ5GZicY\nY+bb8ftaBJek/jog6nLk+cx1cE7mxi9HP0gK5nosb1fnvFwtOE7qTYjf8mhYR5Zq\nZTKKHgU+kvpsWVBRh3zFCF39/iShOAhmdFRzrzz7wMYMKxG4pb9qqoM30c7Qc6eE\nXTTkgVCayxsoeZaup7Y/j2Z+U24Q1x7F/Jb0rCmmlDzZX0STYDxXV3ETw+QWBPv+\nQfYgx62L6mU3MOEdkWZRoqmth2Gtk3FCqBxD2etTi5TZXAsTlahurpkCAwEAAaNj\nMGEwHQYDVR0OBBYEFEugE4pRaRLf0csd5sExw+gTuaeIMEAGA1UdEQQ5MDeCDmlk\ncC5wcnouZWR1LnBshiVodHRwczovL2lkcC5wcnouZWR1LnBsL2lkcC9zaGliYm9s\nZXRoMA0GCSqGSIb3DQEBCwUAA4IBAQAU2PaN4KI0DZRU1Ti0yEIhC6D+OvGwBw85\nInPAJ2G1LTt7f9lxeL5f/pXbIGcjdlwfdu2yPaXb1loEbztI2ZeA1SD2XCVjxtlk\nfyBH/DdAi/e2JzvdJRllwYFZXyqbjphcdDbQRPMJDwX64IsLgz3qhshKGMSrPT4e\n9xoJYZBjraB+IecjmjVkTFS9M9nDRbd7D3gDsBG4YO065XbcXnDpe/e+vmM8D8rQ\nqRtuTFz7D6/iwuNxyweebhuSDrOesH0kHEue9NVjyLLezHjGSifWTnAjn3KHB3H9\ny+8rrRJX8fOM6kTfnrL40Ir6vu9ZQacVERazVeNuhthXjAEgTdLx"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDJDCCAgygAwIBAgIVAPJvJR0LcPazVISXYG6X06yC9ndaMA0GCSqGSIb3DQEB\nCwUAMBkxFzAVBgNVBAMMDmlkcC5wcnouZWR1LnBsMB4XDTE1MDQxNDA3MzAyOVoX\nDTM1MDQxNDA3MzAyOVowGTEXMBUGA1UEAwwOaWRwLnByei5lZHUucGwwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxul11b+7eT3TYYtGBRbrwDzZ6jsYx\n59PNKBCGxKV3JuAWTATANitah0zsuQVS8FY6hM9WIC1UO/XZtCo0tPf8RJc2xrwK\nyv+ZUuF2lX6dQ6OKKGW0WpitFWWY7VfwNgMz0/gums1v4tFQ9+lk4XMqbHiOJB+p\nUvqZssipI9jIa++cQcpamYLjjV52rLMwzfHl476T789DPYEF+ItN81dsaTiUSMXj\nVTHqp9cbUH/D+vAlFusBkvrzzQL3P/Aayykck2bajMyWO80U9E9wh7hdMU0Bc8i2\nV6naK2EYMatNJjDI7u0XhUuRSsDpWLrNJZ6PEBKaU+95jaJVdUGw7kwjAgMBAAGj\nYzBhMB0GA1UdDgQWBBQ3HnYKwH8P/Xp/oIV1HuDHb1hsFzBABgNVHREEOTA3gg5p\nZHAucHJ6LmVkdS5wbIYlaHR0cHM6Ly9pZHAucHJ6LmVkdS5wbC9pZHAvc2hpYmJv\nbGV0aDANBgkqhkiG9w0BAQsFAAOCAQEAmckDWhG2l6ZzhQ3oFSSCBwlejjDF2ySB\nHw/6fNA+2ZCrj9i6Zwa0hMywWagkWz5km0PThN7cVxA+jC4d8odU6cL/+zvLOQjI\nP0T49HtMESp2YGxf4JijLV22mF9oqljBqpbZoNxGNTJ7IOXGXP7NFzVglm8RdvKU\nDdebvnqXiSjSewgIuLCn+CINvW9SybvcatlJ+M2/6t2N07WgnbJN9uixvscnRepm\n0IDe6O9v5abiq2VG7AIViFWC+a9ccNIzuxyOjYfY9iPLnP838xTbuQ0MSN8eBDEZ\nUneQJVy3VT/nkjcAT7M6lhk0XgexjrWz1AoKMtbCkuNNGVkm2K+QmA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDIzCCAgugAwIBAgIUTHsEb6D9StQBPMYXHN1HAZ3bU5YwDQYJKoZIhvcNAQEL\nBQAwGTEXMBUGA1UEAwwOaWRwLnByei5lZHUucGwwHhcNMTUwNDE0MDczMDM3WhcN\nMzUwNDE0MDczMDM3WjAZMRcwFQYDVQQDDA5pZHAucHJ6LmVkdS5wbDCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIcoQVIFyOSxlVChDHohFju8zTLhOlAA\nTXrjj1AIyzgiw9FplT+8lRFeNct6tntLUDmSD9jbuxFCrxlxHB2ovvVuXuAiIieG\n7rPc2y0fBG4UgdbOtFN9UH5Gr7kkxM3mrQ71mXwwNjj/ilUHgkh1y7GfAEiB4WMw\nCbVB2FlxeJBW1kU9ERA1ZTGUwM1Arwg2pMGKZYEmdQYSH91Wv3M/lBMgQUulktJA\nuyyO+7D72qCDZOZaX8CIFv/etCM+Ihg7f8CAw+N6Iwj+HOd5PFii5PWpcqS+jpKO\nxFWbt43UVNKqxV4OERU/2RAnW+PXQ92KgRlo6s93xtS6Rv/LAIT+6o0CAwEAAaNj\nMGEwHQYDVR0OBBYEFDK/6wBsCmjZko2HLmDi6/CMvxCtMEAGA1UdEQQ5MDeCDmlk\ncC5wcnouZWR1LnBshiVodHRwczovL2lkcC5wcnouZWR1LnBsL2lkcC9zaGliYm9s\nZXRoMA0GCSqGSIb3DQEBCwUAA4IBAQBiGT4n6ocJ29HSVKE0dvqrrMS9dxSNxpTP\nNi8/WMDJCzmeStxGzSa0RP6B86Se1p0EnJEVX7mXe6Qtw5Fr3x7Doid1b2uTzfC1\nNoPhmJte28CariucCtJv7SHWNxTi7YtOJnkjbOE99gpffDiOnF51xwyMQ096aYxj\nYRyeJfn5DyUaMdXA1APINzZNCeq47d4DSiV+f587VJ37w3n6/ySYzc2lQYlYvAkT\nVsFx2s8OuccXXNppTDaVgdDGlLpk8LNHyT2IuOacxwOmbuYVqzwipW/k082UbRc+\n3/XMEQRfdUtgr6G7tbTDuzIkfIsuD6LQwCLHrpKhPb9IgBO7VlCu"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "pl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Politechnika Rzeszowska"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Rzeszow University of Technology"
          }
        ],
        "organization_url": [
          {
            "lang": "pl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://portal.prz.edu.pl/"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://portal.prz.edu.pl/en/"
          }
        ],
        "organization_name": [
          {
            "lang": "pl",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Politechnika Rzeszowska"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Rzeszow University of Technology"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://test-dcs.cla.co.uk/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:dev@cloudspringtech.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dev Team"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:dev@cloudspringtech.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dev Team"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Amyotte"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:phil@cloudspringtech.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Phil"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://test-dcs.cla.co.uk/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2015-05-28T08:35:42Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Digital Content Store"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://cla.co.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "The Copyright Licensing Agency Ltd"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC3zCCAcegAwIBAgIJANN7j8TZENUbMA0GCSqGSIb3DQEBBQUAMBMxETAPBgNV\n\t\t\t\t\t\tBAMTCG5zMzczMTUzMB4XDTE1MDQyNzEzNDMzOVoXDTI1MDQyNDEzNDMzOVowEzER\n\t\t\t\t\t\tMA8GA1UEAxMIbnMzNzMxNTMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\n\t\t\t\t\t\tAQDe0s9fwQ9v4NajnGwDJkesWo7Py4ufH/5qJsYUPcForz10FATKQtlGZZvb1Gzq\n\t\t\t\t\t\t1TaenINx4QqSjUjdyVUN3N25LWCVXW7IKmL+cxJPXx0R8Nng86ZCtYmA1epphESy\n\t\t\t\t\t\tPTXHLDOst7B4LdtxdlfqMaSr7xRo+1tBvY4G3Lqpt2l085R13XSvVfpbevQZSD4p\n\t\t\t\t\t\tnqi9vAiFUM4NDvycm0Yil/dPk4fGWlpMNT01JR50rpFnntJJVfab7I9Qf5cxboBw\n\t\t\t\t\t\t5mOPwqA8w4BI4o1gFqeH/vBXwrbA8zX9Ehgkfn1Rl8Aa0ZSMgoNjhzzwwLvjAuxT\n\t\t\t\t\t\tbWxPlVUwr7soX+RK9JRRgEMbAgMBAAGjNjA0MBMGA1UdEQQMMAqCCG5zMzczMTUz\n\t\t\t\t\t\tMB0GA1UdDgQWBBSp4HYFPmzOFP8q8RG2pBi0PerD3TANBgkqhkiG9w0BAQUFAAOC\n\t\t\t\t\t\tAQEAU9s2EhAdQudGpXpw6Ozw4tmEvg1IKDbUxUNEKkfUMOnlqPIeYvYhk5LN5ttD\n\t\t\t\t\t\tYTBcGaA8tIh5UIlQpNUh2Eb89FgZ2UqNgyx9OGMaiP7nl5ZV8HHckiTcrFKOnG6X\n\t\t\t\t\t\t+nuyOTeIYjgvpldbLZxRMlCt5fSQzqwwYX6SyK6PWsqQTZhvzpwdpbGrUj4mKEcV\n\t\t\t\t\t\tvs9mlOgKFkqvzXLr+I4D8XVYbIxBCeh7X82ooPv4r6d7kzJJo9pRf+qi0RNKJmWZ\n\t\t\t\t\t\tvI2el1erTkBgTf/qHvtskD/N1KTxz9oZV/bTpkype7gRaya8jguEmXqz0fyt9ohB\n\t\t\t\t\t\tkep+2TUr/H4eYqGM0KNkWWD8FA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://test-dcs.cla.co.uk/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://shibidp.polimi.it/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Gaffuri"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:roberto.gaffuri@polimi.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:idem@polimi.it"
            }
          ],
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibidp.polimi.it/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://www.idem.garr.it/idem-metadata-registration-practice-statement"
              }
            ],
            "registration_instant": "2009-12-31T15:00:00Z",
            "registration_authority": "http://www.idem.garr.it/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDjTCCAnWgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBiTELMAkGA1UEBhMCSVQx\nCzAJBgNVBAgTAk1JMQ4wDAYDVQQHEwVNaWxhbjEPMA0GA1UEChMGUE9MSU1JMQ4w\nDAYDVQQLEwVBU0lDVDEaMBgGA1UEAxMRc2hpYmlkcC5wb2xpbWkuaXQxIDAeBgkq\nhkiG9w0BCQEWEWhvc3RpbmdAcG9saW1pLml0MB4XDTE0MDIyMDExMDcwMFoXDTI2\nMDIyMDExMDcwMFowgYkxCzAJBgNVBAYTAklUMQswCQYDVQQIEwJNSTEOMAwGA1UE\nBxMFTWlsYW4xDzANBgNVBAoTBlBPTElNSTEOMAwGA1UECxMFQVNJQ1QxGjAYBgNV\nBAMTEXNoaWJpZHAucG9saW1pLml0MSAwHgYJKoZIhvcNAQkBFhFob3N0aW5nQHBv\nbGltaS5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKhtqK271QYD\nCWbYMZSqPdm29Oh3yeOVC+6FyoU9i3DIHaiqRxa1yKlYHLx5oLgtPi8ASDzXPfMo\n6MGVGYLOzCe/Y2efdJyz1Pqguna+8jfDtm1MeNCrjYd/cTp5gr/HGZGz262dSmIM\nWrWloF7Zg3jwsXvJYO0wCHLsKVRul7vdosPX7Jy9pIxTO1ZJMZCa/NASWMqf1i+B\ntYVpJqMQZJ85H9pEnu+6dBJMz6QM67zL9WnncMUz1ANkCkLX6mAFV9sydjTXPKrK\nhBBCZF44HOdiIbeZ+NKBZLeirVNALptmTxMg1bNYR2eeys9pdht7qdrvDcBziy5E\ntVFwmsFxMF8CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEApV/JH6zxNIBuB/8zTbO7\nK/uJsh14u/ihkWxCwGJoZTKSttIwlH2Y0+R8fQW/+ZV/aOT3vzJzxJJ/WL6x9Bku\nmlaYSnZ+zD0fQWWWSGK/ncqELDCE35h2B5/hmJ0wSHZewPTPRhvptIYsEFzr9Gr4\nhja1IylB5u+kXNOgR5XJvoojnI1855S/N1p6Y+JUfJKCTciw/0w8Kqlz5Hs9/GHt\nWRQMqSSzXV/Ti6l+6Mu2wvg0LSH2F9XZjN49ZX1E4LPcB8ChCzmrMf87+9+tru9C\nY00stxLKVpXdX8pXFj3zFusdHk7fSeE4cCUYQvN7+Jyy7uSEM10eED6xOqvPw31n\noA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "polimi.it"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibidp.polimi.it:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibidp.polimi.it:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shibidp.polimi.it/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibidp.polimi.it/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shibidp.polimi.it/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibidp.polimi.it/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibidp.polimi.it:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibidp.polimi.it:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "polimi.it"
              },
              {
                "information_url": [
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://aunicalogin.polimi.it/aunicalogin/idem.jsp"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.polimi.it/en/english-version/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider for Politecnico di Milano users"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider per gli utenti del Politecnico di Milano"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Politecnico di Milano"
                  },
                  {
                    "lang": "it",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Politecnico di Milano"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDjTCCAnWgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBiTELMAkGA1UEBhMCSVQx\nCzAJBgNVBAgTAk1JMQ4wDAYDVQQHEwVNaWxhbjEPMA0GA1UEChMGUE9MSU1JMQ4w\nDAYDVQQLEwVBU0lDVDEaMBgGA1UEAxMRc2hpYmlkcC5wb2xpbWkuaXQxIDAeBgkq\nhkiG9w0BCQEWEWhvc3RpbmdAcG9saW1pLml0MB4XDTE0MDIyMDExMDcwMFoXDTI2\nMDIyMDExMDcwMFowgYkxCzAJBgNVBAYTAklUMQswCQYDVQQIEwJNSTEOMAwGA1UE\nBxMFTWlsYW4xDzANBgNVBAoTBlBPTElNSTEOMAwGA1UECxMFQVNJQ1QxGjAYBgNV\nBAMTEXNoaWJpZHAucG9saW1pLml0MSAwHgYJKoZIhvcNAQkBFhFob3N0aW5nQHBv\nbGltaS5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKhtqK271QYD\nCWbYMZSqPdm29Oh3yeOVC+6FyoU9i3DIHaiqRxa1yKlYHLx5oLgtPi8ASDzXPfMo\n6MGVGYLOzCe/Y2efdJyz1Pqguna+8jfDtm1MeNCrjYd/cTp5gr/HGZGz262dSmIM\nWrWloF7Zg3jwsXvJYO0wCHLsKVRul7vdosPX7Jy9pIxTO1ZJMZCa/NASWMqf1i+B\ntYVpJqMQZJ85H9pEnu+6dBJMz6QM67zL9WnncMUz1ANkCkLX6mAFV9sydjTXPKrK\nhBBCZF44HOdiIbeZ+NKBZLeirVNALptmTxMg1bNYR2eeys9pdht7qdrvDcBziy5E\ntVFwmsFxMF8CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEApV/JH6zxNIBuB/8zTbO7\nK/uJsh14u/ihkWxCwGJoZTKSttIwlH2Y0+R8fQW/+ZV/aOT3vzJzxJJ/WL6x9Bku\nmlaYSnZ+zD0fQWWWSGK/ncqELDCE35h2B5/hmJ0wSHZewPTPRhvptIYsEFzr9Gr4\nhja1IylB5u+kXNOgR5XJvoojnI1855S/N1p6Y+JUfJKCTciw/0w8Kqlz5Hs9/GHt\nWRQMqSSzXV/Ti6l+6Mu2wvg0LSH2F9XZjN49ZX1E4LPcB8ChCzmrMf87+9+tru9C\nY00stxLKVpXdX8pXFj3zFusdHk7fSeE4cCUYQvN7+Jyy7uSEM10eED6xOqvPw31n\noA=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Politecnico di Milano"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Politecnico di Milano"
          }
        ],
        "organization_url": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://shibidp.polimi.it/"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://shibidp.polimi.it/en"
          }
        ],
        "organization_name": [
          {
            "lang": "it",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Politecnico di Milano Identity Provider"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Politecnico di Milano Identity Provider"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp0.abertay.ac.uk/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:isservicedesk@abertay.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "IS Service Desk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Christie"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:ISSADTeam@abertay.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Brian"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp0.abertay.ac.uk/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2014-07-31T11:05:00Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDMzCCAhugAwIBAgIUc7OjIBg0Vhfh00MlmEXTDJVaD5kwDQYJKoZIhvcNAQEF\n\t\t\t\t\t\tBQAwHTEbMBkGA1UEAxMSaWRwMS5hYmVydGF5LmFjLnVrMB4XDTE0MDYyNzEwNTQz\n\t\t\t\t\t\tM1oXDTM0MDYyNzEwNTQzM1owHTEbMBkGA1UEAxMSaWRwMS5hYmVydGF5LmFjLnVr\n\t\t\t\t\t\tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhy85D7Rk1W5IrIatuD01\n\t\t\t\t\t\tbZaUq5/6fagpzqXeprRh8NafBqASLj9+Rzda5lJfMrFmvV9Q5JcyXKXdvnL9vaQi\n\t\t\t\t\t\to61t2sAwKTHrmOT8nIHCVLJGIx8wclEUQZifdDzQNIj9MiLL40nN6tD0WQIXcO/e\n\t\t\t\t\t\t4nmBA4havm437GGuFOdP7ZkY2Xuex1AufaJq144mqNHhk4rYplbkpVS+M+NLbRLX\n\t\t\t\t\t\tvooF2zl+CxGwHF1pYiKdbb8+Kf+v9uFX5wMGNZMfpymMprLf6m7dBLxVur2g1pcF\n\t\t\t\t\t\tvvzRddBlKCshg6a3zh6RXgRf8ZmfU//HpBCPQdQ1d09gqUt0hJ8Mf89S65+fTB+Y\n\t\t\t\t\t\twQIDAQABo2swaTBIBgNVHREEQTA/ghJpZHAxLmFiZXJ0YXkuYWMudWuGKWh0dHBz\n\t\t\t\t\t\tOi8vaWRwMS5hYmVydGF5LmFjLnVrL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRe\n\t\t\t\t\t\tnf9RmkNw8n4n58D1CDsey26VnTANBgkqhkiG9w0BAQUFAAOCAQEAIG2zPbZsoZxE\n\t\t\t\t\t\taj2ZH6TxNRkR+l8N86WXWn0AdITwU1PX2+5w38sSOuNb0FNA1MesY643dZOUM0TK\n\t\t\t\t\t\t/JpPlGT8GPFAq+Pq3XKCMyLnPJd3WXqEzpbjRUsFmn9Pylsc3uQ27+kuYQ+SCPnS\n\t\t\t\t\t\ttcU8ObI0Zcdk/ZfAn0P3R0DjmzypCt7qC/vqQbskGtniDGPlo9uqYTKxKZW5Xj5z\n\t\t\t\t\t\tQaP8CP68+ECeTyyJs2E9IyjwU3r8e1ruNmLgXlIrZvLcyoc5TcnKgmuj+VhDho9s\n\t\t\t\t\t\tDZWQqoz3Cs2kX3tT0BeVdPiHLZ+Vwc8Bi+WWqioz6oGI16NJYTrhWuMCG3rB7lXZ\n\t\t\t\t\t\tkYaFXYT6DQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "uad.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.abertay.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.abertay.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp1.abertay.ac.uk/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp1.abertay.ac.uk/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.abertay.ac.uk:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp1.abertay.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp1.abertay.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp1.abertay.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp1.abertay.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.abertay.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.abertay.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "uad.ac.uk"
              },
              {
                "logo": [
                  {
                    "text": "https://idp1.abertay.ac.uk/icons/colour-abertay-uni-logo.png",
                    "height": "23",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "80"
                  },
                  {
                    "text": "https://idp1.abertay.ac.uk/icons/small/shield_16x16.ico",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Abertay University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDMzCCAhugAwIBAgIUc7OjIBg0Vhfh00MlmEXTDJVaD5kwDQYJKoZIhvcNAQEF\n\t\t\t\t\t\tBQAwHTEbMBkGA1UEAxMSaWRwMS5hYmVydGF5LmFjLnVrMB4XDTE0MDYyNzEwNTQz\n\t\t\t\t\t\tM1oXDTM0MDYyNzEwNTQzM1owHTEbMBkGA1UEAxMSaWRwMS5hYmVydGF5LmFjLnVr\n\t\t\t\t\t\tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhy85D7Rk1W5IrIatuD01\n\t\t\t\t\t\tbZaUq5/6fagpzqXeprRh8NafBqASLj9+Rzda5lJfMrFmvV9Q5JcyXKXdvnL9vaQi\n\t\t\t\t\t\to61t2sAwKTHrmOT8nIHCVLJGIx8wclEUQZifdDzQNIj9MiLL40nN6tD0WQIXcO/e\n\t\t\t\t\t\t4nmBA4havm437GGuFOdP7ZkY2Xuex1AufaJq144mqNHhk4rYplbkpVS+M+NLbRLX\n\t\t\t\t\t\tvooF2zl+CxGwHF1pYiKdbb8+Kf+v9uFX5wMGNZMfpymMprLf6m7dBLxVur2g1pcF\n\t\t\t\t\t\tvvzRddBlKCshg6a3zh6RXgRf8ZmfU//HpBCPQdQ1d09gqUt0hJ8Mf89S65+fTB+Y\n\t\t\t\t\t\twQIDAQABo2swaTBIBgNVHREEQTA/ghJpZHAxLmFiZXJ0YXkuYWMudWuGKWh0dHBz\n\t\t\t\t\t\tOi8vaWRwMS5hYmVydGF5LmFjLnVrL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRe\n\t\t\t\t\t\tnf9RmkNw8n4n58D1CDsey26VnTANBgkqhkiG9w0BAQUFAAOCAQEAIG2zPbZsoZxE\n\t\t\t\t\t\taj2ZH6TxNRkR+l8N86WXWn0AdITwU1PX2+5w38sSOuNb0FNA1MesY643dZOUM0TK\n\t\t\t\t\t\t/JpPlGT8GPFAq+Pq3XKCMyLnPJd3WXqEzpbjRUsFmn9Pylsc3uQ27+kuYQ+SCPnS\n\t\t\t\t\t\ttcU8ObI0Zcdk/ZfAn0P3R0DjmzypCt7qC/vqQbskGtniDGPlo9uqYTKxKZW5Xj5z\n\t\t\t\t\t\tQaP8CP68+ECeTyyJs2E9IyjwU3r8e1ruNmLgXlIrZvLcyoc5TcnKgmuj+VhDho9s\n\t\t\t\t\t\tDZWQqoz3Cs2kX3tT0BeVdPiHLZ+Vwc8Bi+WWqioz6oGI16NJYTrhWuMCG3rB7lXZ\n\t\t\t\t\t\tkYaFXYT6DQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Abertay University"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.abertay.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Abertay Dundee"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://www.test.ladok.se/gui-sp",
    {
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "entity_id": "https://www.test.ladok.se/gui-sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.test.ladok.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://www.test.ladok.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://www.test.ladok.se/Shibboleth.sso/Login",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "information_url": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "https://www.ladok.se/"
                  }
                ],
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Studieadministrativt systemst\u00f6d f\u00f6r universitet och h\u00f6gskolor i Sverige (Ladok)"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Administration system for higher education in Sweden (Ladok)"
                  }
                ],
                "logo": [
                  {
                    "text": "https://www.test.ladok.se/_system/00/images/logo-00.jpg",
                    "height": "64",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "64"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok www.test.ladok.se"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ladok www.test.ladok.se"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "https://www.test.ladok.se/gui-sp"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "www.test.ladok.se"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFHDCCAwSgAwIBAgIJAIbDYkZWg5D9MA0GCSqGSIb3DQEBCwUAMBwxGjAYBgNV\nBAMTEXd3dy50ZXN0LmxhZG9rLnNlMB4XDTE2MDIxMDEzMzUzNloXDTI2MDIwNzEz\nMzUzNlowHDEaMBgGA1UEAxMRd3d3LnRlc3QubGFkb2suc2UwggIiMA0GCSqGSIb3\nDQEBAQUAA4ICDwAwggIKAoICAQC+W5Gi4u6RApYh068l1O/jZB1LKHMYfBa7BeR1\nnGjZXTI15BhJJDeaIqiIyZCwmPiki66Ma5frzSERCki1u7rfP38/bddLtvCCpYhP\nxmQhOFWXQ3SXaWQETSZ3mVLnZmUk7rrnANnfKFLst0AGAAZGJ1M2CTT9yLXhzm4v\n/klsaoVjpOmfpmNlMV+wWj35fpm2Ni8XL1aSQnz0Q6/vUtbP+zbRUwMpXFC/8NO/\n+JT5HMOq6fAJpVJvozwOcPQ83ZaZRYYk2dcOPWgEG5Y4ooEnGdLNfiKQ6DyaMEev\nKGfaLdapWntSi4aeQoqDnGU13nbaRAMvOs389phEHQDpq28qGL3Njwgdg+yLGzJj\n9jUlkYkz7CvR+GQLsZqOeudX/3P1EhavPpk1aG7bGhUUhuLI67m0I5u6axXZi7UQ\nHKqOL4zjNvz1YpL4fel/47WcteYHarumJmuBpmvCqJAfjn9hZMqOkCLbY3NW/qai\nTRznyxNiK+bYZ0VfUcDCvsac0+NcU9a42j5fo1a2Y9q/7MMq76TJ3176t+rYWqJi\n199jmKfyffcrriV4HXkYwYywDyWAn+imSuso+PW7SNDxFu7gY7pPgU2Dnov31lq8\nzJVpN3ssOEWaAJcbPcS4Ho/9o2kL6Hpp42yhNn0ZCnTeOQKpariM8BRN/12v9zXD\naoPC6QIDAQABo2EwXzA+BgNVHREENzA1ghF3d3cudGVzdC5sYWRvay5zZYYgaHR0\ncHM6Ly93d3cudGVzdC5sYWRvay5zZS9ndWktc3AwHQYDVR0OBBYEFHtJ6TbmFAeA\n4BaaLUhwxUHgEszoMA0GCSqGSIb3DQEBCwUAA4ICAQCnQhO2mDJe2HGQzC0Hts9r\nCxgSUQSR23e8FbXWFBniYByYPc786HJsoeDI3YvEO00rOSIRX45Mya5Iapbnj4F3\nf/ya6agLSjMk6ce9u+kqIeXii3JvFcV/biDdHSEdVgOEr39YMWP5tyaJhmesZLfy\n1SnJzlW3PrvFdgaKIfVJ2lfukx3OESJ10/CgRllf91eKpfTPB2g8vU0RAUq+odkk\nX7tSbGDpRtOYfym6FXZpdh2ZBft1QJV7E7jMJZ1dWx7gvp7w06JJozaXaiyIPKCl\nEIYvEppBO+Hs7IbDS4kUSKdzF14wof7qpzQQ+yULmOkrfC80MHGXkKaYNB+mzQ2C\nAm+tmUDwu+6JNeNDlrN72AlojvsDObgsCHoQIVsSx2wFYDM2zTvA/MR71KHASEi8\neGdXcOgn3UMS/ehYrnDq0m/bAjsn/AHjGjIqsFQUpzwqG3N2djGtOD2dzcxOOKCL\n31aHDlUTgv1hdCpa5+NiIzRrahJoJrfmli/NBlX5wQbQ0s1UVlbgy5Xw0Ttr4IIy\nLDCJR8LVHDuZcx5GKkrwQE6fWwLJM8JI8JZF0w9j8bsrU3WUfCwfMaCKvwFlYgQQ\nY6TwKaxgtHgm3WFnPMMTXkKWeKq3sp5fajwzptV1MA/uS2aOuboQ7qm6J2aFy0yX\nQOr7nPNnNq2e/M/T2ugEMg=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=www.test.ladok.se"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.test.ladok.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.test.ladok.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.test.ladok.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.test.ladok.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://www.test.ladok.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://filesender.cesnet.cz/saml/sp",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Kopecky - administrator"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "du-support@cesnet.cz"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Lubos"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://filesender.cesnet.cz/saml/sp",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.eduid.cz/wiki/_media/en/eduid/policy/policy_eduid_en-1_1.pdf"
              },
              {
                "lang": "cs",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.eduid.cz/wiki/_media/eduid/policy/policy_eduid_cz-1_1-3.pdf"
              }
            ],
            "registration_instant": "2011-11-04T10:27:36Z",
            "registration_authority": "http://www.eduid.cz/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://eduid.cz/uri/sp-group/aa.cesnet.cz"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "CESNET"
          },
          {
            "lang": "cs",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "CESNET"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.ces.net/"
          },
          {
            "lang": "cs",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.cesnet.cz/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "CESNET"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://filesender.cesnet.cz/simplesaml/module.php/saml/sp/saml2-logout.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://filesender.du1.cesnet.cz/simplesaml/module.php/saml/sp/saml2-logout.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://filesender4elixir.cesnet.cz/simplesaml/module.php/saml/sp/saml2-logout.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://filesender6.cesnet.cz/simplesaml/module.php/saml/sp/saml2-logout.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://filesender.cesnet.cz/"
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://filesender.cesnet.cz/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "CESNETs servis for sending files."
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Cesnet\u00ed slu\u017eba pro pos\u00edl\u00e1n\u00ed soubor\u016f."
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "FileSender"
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "FileSender"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9jCCAd4CCQDdhtc4WQjM2jANBgkqhkiG9w0BAQsFADA9MQswCQYDVQQGEwJDWjEPMA0GA1UEChMGQ2VzbmV0MR0wGwYDVQQDExRmaWxlc2VuZGVyLmNlc25ldC5jejAeFw0xNTA0MDMwNTU1MjdaFw0zNTA0MDIwNTU1MjdaMD0xCzAJBgNVBAYTAkNaMQ8wDQYDVQQKEwZDZXNuZXQxHTAbBgNVBAMTFGZpbGVzZW5kZXIuY2VzbmV0LmN6MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAv1WBCUZpXFxBpJ0AxFKGuJtdm3MY0PlKNELuzUvVTfiOMqHt19dmuixMzlbk8oPliCI69E6TndBMYnTucueFOgaPi/W7eWEN1p74liVgQQXTypBt8JiIhiHUf4b5AShmNPaWh+IrGtzQ9oFPBdVgU542pT5oLje84ZbfiXMQAwkJ/1lgW0UDVFQTyRrge+aPN89V9Sq5MaHxjzzLvCX0i3BTtUInYUqXOb3E15zTnHiiNtZZOcc9p3QNcEiBpUMyrD/SfGgfAME6wZga4v029vxLDyYCvlArkSCocEgWRISwr4uXK1GiDJ7VKsbO6rSnc//yLz2vt6RYSGrNBimHXQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQChn/lKZGjGsWUav7wlYjAcXND6D8knafWr7LkB/YP819UQJyj+V+Spi+crr/UGQp3anPvh7ZE5Z+/YwuwuuL7r8a9OnKPEZ9jt1XMK7QLNegQcypv0ZhGEprWFPR+B0myu4HaTvqEDZN1Dp4JVbhv5AH+wJUDBJmjnQQYY+ipthydPcXJkiT7S6zlNrSnPEtd1ZigIA5aOpJqQY9OzKZJtH8L30ydGNHCpqu97MxTSyNsP55yQRl+cR8BxOPHvqZQy1lxOhvdciI73pSvhOGz4QWOQ4UJr6BYn4pSRSSeHeySL3iBD1xYFvai+yTeAgEOOYO4SSq9h6Dq8D4THqU4Y"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIC9jCCAd4CCQDdhtc4WQjM2jANBgkqhkiG9w0BAQsFADA9MQswCQYDVQQGEwJDWjEPMA0GA1UEChMGQ2VzbmV0MR0wGwYDVQQDExRmaWxlc2VuZGVyLmNlc25ldC5jejAeFw0xNTA0MDMwNTU1MjdaFw0zNTA0MDIwNTU1MjdaMD0xCzAJBgNVBAYTAkNaMQ8wDQYDVQQKEwZDZXNuZXQxHTAbBgNVBAMTFGZpbGVzZW5kZXIuY2VzbmV0LmN6MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAv1WBCUZpXFxBpJ0AxFKGuJtdm3MY0PlKNELuzUvVTfiOMqHt19dmuixMzlbk8oPliCI69E6TndBMYnTucueFOgaPi/W7eWEN1p74liVgQQXTypBt8JiIhiHUf4b5AShmNPaWh+IrGtzQ9oFPBdVgU542pT5oLje84ZbfiXMQAwkJ/1lgW0UDVFQTyRrge+aPN89V9Sq5MaHxjzzLvCX0i3BTtUInYUqXOb3E15zTnHiiNtZZOcc9p3QNcEiBpUMyrD/SfGgfAME6wZga4v029vxLDyYCvlArkSCocEgWRISwr4uXK1GiDJ7VKsbO6rSnc//yLz2vt6RYSGrNBimHXQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQChn/lKZGjGsWUav7wlYjAcXND6D8knafWr7LkB/YP819UQJyj+V+Spi+crr/UGQp3anPvh7ZE5Z+/YwuwuuL7r8a9OnKPEZ9jt1XMK7QLNegQcypv0ZhGEprWFPR+B0myu4HaTvqEDZN1Dp4JVbhv5AH+wJUDBJmjnQQYY+ipthydPcXJkiT7S6zlNrSnPEtd1ZigIA5aOpJqQY9OzKZJtH8L30ydGNHCpqu97MxTSyNsP55yQRl+cR8BxOPHvqZQy1lxOhvdciI73pSvhOGz4QWOQ4UJr6BYn4pSRSSeHeySL3iBD1xYFvai+yTeAgEOOYO4SSq9h6Dq8D4THqU4Y"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://filesender.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "0"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://filesender.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://filesender.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "2"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://filesender.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "3"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://filesender.du1.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "4"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://filesender.du1.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://filesender.du1.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://filesender.du1.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://filesender4elixir.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://filesender4elixir.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://filesender4elixir.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://filesender4elixir.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "11"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://filesender6.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "12"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://filesender6.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "13"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://filesender6.cesnet.cz/simplesaml/module.php/saml/sp/saml2-acs.php/filesender.cesnet.cz",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "14"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://filesender6.cesnet.cz/simplesaml/module.php/saml/sp/saml1-acs.php/filesender.cesnet.cz/artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "15"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://login.uea.ac.uk/entity",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:web@uea.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "UEA Web Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:web@uea.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "UEA Web Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://login.uea.ac.uk/entity",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_instant": "2012-03-01T10:16:25Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://login.uea.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://login.uea.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "uea.ac.uk"
              },
              {
                "logo": [
                  {
                    "text": "https://login.uea.ac.uk/oala/uea-uk-fed-logo.png",
                    "height": "60",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "80"
                  },
                  {
                    "text": "https://login.uea.ac.uk/oala/uea-uk-fed-icon-16.png",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of East Anglia (UEA)"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "ip_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint",
                    "text": "139.222.0.0/16"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDoDCCAoigAwIBAgIJAIuKNtoJUQjXMA0GCSqGSIb3DQEBBQUAMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51azAeFw0xMDExMDkwNzU3NTJaFw0yMDExMDYwNzU3NTJaMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM9oeuK7k5dK\n\t\t\t\t\t\tbp97dCPSq7gqVrm3Rq2fyW62SFx1IVwFBtoW1CIQOkDJF8bVkKa2U+dMmwLHvfEP\n\t\t\t\t\t\tqVnXXA59eDJeGRib2ME6o1q90McllqBVWhuBoR08GFEdXhbt1lpUpBNOF+V9lv+y\n\t\t\t\t\t\tf37bDm2ii+iaCaOcaT5sO9g0krqw/mlWsSPUIhAG7TzndSECH4lHdqBEWPlk87gn\n\t\t\t\t\t\t5LeuezjWpgQmdPD6PaB2fuTyQyP+BeNeIK8EiJvCpBzA92EKitTHxTa6ON3LEy0L\n\t\t\t\t\t\tqzJCDWx7rq0R0ch7TmzGw8DLrKIWRHbfH2nMWMFMp7Hf1EhB/Z1+R7nhgIV6HxQi\n\t\t\t\t\t\td+DmuhrLJB8CAwEAAaOBoDCBnTAdBgNVHQ4EFgQUREAlXs64Gbcn4E+0R5mumL5k\n\t\t\t\t\t\t+MwwbgYDVR0jBGcwZYAUREAlXs64Gbcn4E+0R5mumL5k+MyhQqRAMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51a4IJAIuKNtoJUQjXMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQAD\n\t\t\t\t\t\tggEBAKhau/vUIiWf7K2ILlfdK89NKLuvUwndns9sYEcIFAqTMWnGlpXogPzFUqvd\n\t\t\t\t\t\tPTEjYSkffvr5xHPIasBpaouVmqsr245P1aX9qZh4f6K7FLS+hUHdJvaFrGl6oxEe\n\t\t\t\t\t\tWPILAJimme/YZqVCmyyLeYAB+l9Yt81wd+xkaajOrbNalv2f1fxIwQpGp3oosR3b\n\t\t\t\t\t\tWXVQwwCnZX7KrZHmIfiRvY9yYctOsXs1xlbZoR8m0F5Tq3xOZIoHjOoWyl4AARFM\n\t\t\t\t\t\tNpCaUKSy/eK1MvlZph0VK6QY4P7xlZMvEnMQscrf/bEBblQ+dGyfM664mnPAvWgR\n\t\t\t\t\t\tnIhXWvtGhtoIysHU01bNRSH11OA="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDoDCCAoigAwIBAgIJAIuKNtoJUQjXMA0GCSqGSIb3DQEBBQUAMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51azAeFw0xMDExMDkwNzU3NTJaFw0yMDExMDYwNzU3NTJaMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM9oeuK7k5dK\n\t\t\t\t\t\tbp97dCPSq7gqVrm3Rq2fyW62SFx1IVwFBtoW1CIQOkDJF8bVkKa2U+dMmwLHvfEP\n\t\t\t\t\t\tqVnXXA59eDJeGRib2ME6o1q90McllqBVWhuBoR08GFEdXhbt1lpUpBNOF+V9lv+y\n\t\t\t\t\t\tf37bDm2ii+iaCaOcaT5sO9g0krqw/mlWsSPUIhAG7TzndSECH4lHdqBEWPlk87gn\n\t\t\t\t\t\t5LeuezjWpgQmdPD6PaB2fuTyQyP+BeNeIK8EiJvCpBzA92EKitTHxTa6ON3LEy0L\n\t\t\t\t\t\tqzJCDWx7rq0R0ch7TmzGw8DLrKIWRHbfH2nMWMFMp7Hf1EhB/Z1+R7nhgIV6HxQi\n\t\t\t\t\t\td+DmuhrLJB8CAwEAAaOBoDCBnTAdBgNVHQ4EFgQUREAlXs64Gbcn4E+0R5mumL5k\n\t\t\t\t\t\t+MwwbgYDVR0jBGcwZYAUREAlXs64Gbcn4E+0R5mumL5k+MyhQqRAMD4xIjAgBgNV\n\t\t\t\t\t\tBAoTGVVuaXZlcnNpdHkgb2YgRWFzdCBBbmdsaWExGDAWBgNVBAMTD2xvZ2luLnVl\n\t\t\t\t\t\tYS5hYy51a4IJAIuKNtoJUQjXMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQAD\n\t\t\t\t\t\tggEBAKhau/vUIiWf7K2ILlfdK89NKLuvUwndns9sYEcIFAqTMWnGlpXogPzFUqvd\n\t\t\t\t\t\tPTEjYSkffvr5xHPIasBpaouVmqsr245P1aX9qZh4f6K7FLS+hUHdJvaFrGl6oxEe\n\t\t\t\t\t\tWPILAJimme/YZqVCmyyLeYAB+l9Yt81wd+xkaajOrbNalv2f1fxIwQpGp3oosR3b\n\t\t\t\t\t\tWXVQwwCnZX7KrZHmIfiRvY9yYctOsXs1xlbZoR8m0F5Tq3xOZIoHjOoWyl4AARFM\n\t\t\t\t\t\tNpCaUKSy/eK1MvlZph0VK6QY4P7xlZMvEnMQscrf/bEBblQ+dGyfM664mnPAvWgR\n\t\t\t\t\t\tnIhXWvtGhtoIysHU01bNRSH11OA="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of East Anglia (UEA)"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.uea.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of East Anglia"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp1.hogent.be/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Technical Support"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "helpdesk@hogent.be"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Technical Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp1.hogent.be/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://federation.belnet.be/files/Belnet-metadata-registration-practice-statement.txt"
              }
            ],
            "registration_instant": "2012-03-27T12:00:00Z",
            "registration_authority": "http://federation.belnet.be/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDJDCCAgygAwIBAgIVAKN8lW+W0bwU2Fgdizh1Fc78eC1cMA0GCSqGSIb3DQEB\nBQUAMBkxFzAVBgNVBAMTDmlkcDEuaG9nZW50LmJlMB4XDTEzMTAwNzE0MzI1M1oX\nDTMzMTAwNzE0MzI1M1owGTEXMBUGA1UEAxMOaWRwMS5ob2dlbnQuYmUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpFqqWVjzACwe3pHH4Z+zxtqD0UjIF\nupRkh8638dhdPTsEAS/dIdoG9vI5Bo0o/3Mds/2Vcasih1aEtLpOZA5szGjbQyF3\nBif6ExfNRc07D9o4o1wEzkkOEaNV6edkBJAENNnuFBZVES13FIhvyW673sdFMU26\nq/PTgXt+DVejhpdgkMtqTLaAbD3G4aViVeNIstuJcrIXwZv3YgD4lgU/fXNjjLDE\nHk8DuL+aGVmalg37cnxNtq+i7O6lW3/yrLxExCOiFkdvcQq2lCfwECU41ira4M2o\nYuB0CDsYqK8rk3Btk4VueIDJsnivARPrJiRNSN7z1WhDjNe7M5pkC4E9AgMBAAGj\nYzBhMEAGA1UdEQQ5MDeCDmlkcDEuaG9nZW50LmJlhiVodHRwczovL2lkcDEuaG9n\nZW50LmJlL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBQC4xxZFlWHXKtFqS2uu3pI\n8k+42jANBgkqhkiG9w0BAQUFAAOCAQEAXFNa7quzgSZt+SBCYhjI/5L5EF5ZkZv1\nVSViW5l/vIyFNfMZiXKKsZXZ55WfGePMbrnWh7l0GPlLzgRpFnLuBRS2+VwzWpzA\nH5KAS7a7R0rgvKd7/21l7XrRcBr6z/TNewOb8mpySJTH5M3in2PejUd5+Ae6PsU9\nPY4KiNwdLjzlzJPo/IBFLxiu70X5hTxip+OxTp7bxMleEG7PnlTzQIWMmBehHnDa\nYCtYQpTwBizo6WlwrYOpE/KWQRYL5BB/Q3aW2KeUy87jEpbgU/SojjBrp5y8wRsp\n4rV7/SlPD5jEYnPfqLEiiXz/yXbN2dNfvlO47aV2d/GdWvKDGnijBw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "hogent.be"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.hogent.be:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.hogent.be:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp1.hogent.be/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp1.hogent.be/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.hogent.be:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp1.hogent.be/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp1.hogent.be/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp1.hogent.be/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp1.hogent.be/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp1.hogent.be:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp1.hogent.be:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "hogent.be"
              },
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Hogeschool Gent"
                  }
                ],
                "logo": [
                  {
                    "text": "data:image/png;base64,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",
                    "height": "75",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "153"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Hogent"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "domain_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint",
                    "text": "hogent.be"
                  }
                ],
                "geolocation_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint",
                    "text": "geo:51.032894, 3.703396"
                  }
                ],
                "ip_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint",
                    "text": "193.190.172.0/26"
                  },
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint",
                    "text": "2001:6a8:1c60:d000::/64"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDJDCCAgygAwIBAgIVAKN8lW+W0bwU2Fgdizh1Fc78eC1cMA0GCSqGSIb3DQEB\nBQUAMBkxFzAVBgNVBAMTDmlkcDEuaG9nZW50LmJlMB4XDTEzMTAwNzE0MzI1M1oX\nDTMzMTAwNzE0MzI1M1owGTEXMBUGA1UEAxMOaWRwMS5ob2dlbnQuYmUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpFqqWVjzACwe3pHH4Z+zxtqD0UjIF\nupRkh8638dhdPTsEAS/dIdoG9vI5Bo0o/3Mds/2Vcasih1aEtLpOZA5szGjbQyF3\nBif6ExfNRc07D9o4o1wEzkkOEaNV6edkBJAENNnuFBZVES13FIhvyW673sdFMU26\nq/PTgXt+DVejhpdgkMtqTLaAbD3G4aViVeNIstuJcrIXwZv3YgD4lgU/fXNjjLDE\nHk8DuL+aGVmalg37cnxNtq+i7O6lW3/yrLxExCOiFkdvcQq2lCfwECU41ira4M2o\nYuB0CDsYqK8rk3Btk4VueIDJsnivARPrJiRNSN7z1WhDjNe7M5pkC4E9AgMBAAGj\nYzBhMEAGA1UdEQQ5MDeCDmlkcDEuaG9nZW50LmJlhiVodHRwczovL2lkcDEuaG9n\nZW50LmJlL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBQC4xxZFlWHXKtFqS2uu3pI\n8k+42jANBgkqhkiG9w0BAQUFAAOCAQEAXFNa7quzgSZt+SBCYhjI/5L5EF5ZkZv1\nVSViW5l/vIyFNfMZiXKKsZXZ55WfGePMbrnWh7l0GPlLzgRpFnLuBRS2+VwzWpzA\nH5KAS7a7R0rgvKd7/21l7XrRcBr6z/TNewOb8mpySJTH5M3in2PejUd5+Ae6PsU9\nPY4KiNwdLjzlzJPo/IBFLxiu70X5hTxip+OxTp7bxMleEG7PnlTzQIWMmBehHnDa\nYCtYQpTwBizo6WlwrYOpE/KWQRYL5BB/Q3aW2KeUy87jEpbgU/SojjBrp5y8wRsp\n4rV7/SlPD5jEYnPfqLEiiXz/yXbN2dNfvlO47aV2d/GdWvKDGnijBw=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Hogeschool Gent"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.hogent.be"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Hogeschool Gent"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.esh.se/idp/shibboleth",
    {
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDFDCCAfygAwIBAgIVALaN98IcoLX3UQ+fKlQVmqP23WvBMA0GCSqGSIb3DQEB\nBQUAMBUxEzARBgNVBAMTCmlkcC5lc2guc2UwHhcNMTMwODA3MDkwOTU4WhcNMzMw\nODA3MDkwOTU4WjAVMRMwEQYDVQQDEwppZHAuZXNoLnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAn2ZQb1kuPTXtueUtR79lZa5hCV2fMlOlfFJFMyC3\n+6qQR6CGGZ7GvntHtIKpbfFqIeCsWNGXLttNDmGroG6koge0CEKv6z6JVD5tHert\nUVRA7GpDZpZLR7qRYcrbZp1tLrk9gKL3/PaudZhwAKuWiMz5HNyqk9Ojh3YRWJUD\n1O3RX6l2tvc8MjT8JYE2D+TpqqiT5k1WgV7zgCv3QVnazfuANKZ2qjxiKVi3bh1w\nV/3VDJiN9DYhN1NvU412QBZR1AU1XJL36qkKmeTOi8qhhlxh6abl2oEpgyjR0lxn\no1HwkDipkIJJiN/h7CKlUnEHpPidI5tMy/PezW78h2znfwIDAQABo1swWTA4BgNV\nHREEMTAvggppZHAuZXNoLnNlhiFodHRwczovL2lkcC5lc2guc2UvaWRwL3NoaWJi\nb2xldGgwHQYDVR0OBBYEFDGWVB2qNc/D6uRZt2wqI4/SM3Y6MA0GCSqGSIb3DQEB\nBQUAA4IBAQCMaKhHwEwcXTM7/HO6RbavAsisMab0TsCmuYsrCtYFccdrFNEUs+R5\nqGwHre8J+0cMi0WgSIHXLnbhvjG3JPmBeLkZdSw/rOGtF6w6VSVpT2iGvfjNbsBq\nwFGkaEnsDKzhiBaIOcJyAJoh97PJygz7yriziwxDZrB7b0xnBHVs6u4HNuQjd/NA\ngeGI3bNTbXj3Fgu9lanUQE7DbWETQEnrqI2QH+8tr4vVnhG7jaET+qP/ya+XXPJ1\n+PUaqX2b8yCDIeHr7NkqtYf1nqphQ71OvdKe1R6Pzw9N19ny10FJcZypisRt/ghv\n9SqhISRU1eEjg6GtcLZCkvdVGag/E4qO"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "esh.se"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.esh.se:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.esh.se:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.esh.se/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.esh.se/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.esh.se/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.esh.se/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.esh.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.esh.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "esh.se"
              },
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider f\u00f6r Ersta Sk\u00f6ndal University College"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider for the Royal Swedish Academy of Sciences"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ersta Sk\u00f6ndal H\u00f6gskola"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Ersta Sk\u00f6ndal University College"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDFDCCAfygAwIBAgIVALaN98IcoLX3UQ+fKlQVmqP23WvBMA0GCSqGSIb3DQEB\nBQUAMBUxEzARBgNVBAMTCmlkcC5lc2guc2UwHhcNMTMwODA3MDkwOTU4WhcNMzMw\nODA3MDkwOTU4WjAVMRMwEQYDVQQDEwppZHAuZXNoLnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAn2ZQb1kuPTXtueUtR79lZa5hCV2fMlOlfFJFMyC3\n+6qQR6CGGZ7GvntHtIKpbfFqIeCsWNGXLttNDmGroG6koge0CEKv6z6JVD5tHert\nUVRA7GpDZpZLR7qRYcrbZp1tLrk9gKL3/PaudZhwAKuWiMz5HNyqk9Ojh3YRWJUD\n1O3RX6l2tvc8MjT8JYE2D+TpqqiT5k1WgV7zgCv3QVnazfuANKZ2qjxiKVi3bh1w\nV/3VDJiN9DYhN1NvU412QBZR1AU1XJL36qkKmeTOi8qhhlxh6abl2oEpgyjR0lxn\no1HwkDipkIJJiN/h7CKlUnEHpPidI5tMy/PezW78h2znfwIDAQABo1swWTA4BgNV\nHREEMTAvggppZHAuZXNoLnNlhiFodHRwczovL2lkcC5lc2guc2UvaWRwL3NoaWJi\nb2xldGgwHQYDVR0OBBYEFDGWVB2qNc/D6uRZt2wqI4/SM3Y6MA0GCSqGSIb3DQEB\nBQUAA4IBAQCMaKhHwEwcXTM7/HO6RbavAsisMab0TsCmuYsrCtYFccdrFNEUs+R5\nqGwHre8J+0cMi0WgSIHXLnbhvjG3JPmBeLkZdSw/rOGtF6w6VSVpT2iGvfjNbsBq\nwFGkaEnsDKzhiBaIOcJyAJoh97PJygz7yriziwxDZrB7b0xnBHVs6u4HNuQjd/NA\ngeGI3bNTbXj3Fgu9lanUQE7DbWETQEnrqI2QH+8tr4vVnhG7jaET+qP/ya+XXPJ1\n+PUaqX2b8yCDIeHr7NkqtYf1nqphQ71OvdKe1R6Pzw9N19ny10FJcZypisRt/ghv\n9SqhISRU1eEjg6GtcLZCkvdVGag/E4qO"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Ersta Sk\u00f6ndal H\u00f6gskola"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Ersta Sk\u00f6ndal University College"
          }
        ],
        "organization_url": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.esh.se/"
          }
        ],
        "organization_name": [
          {
            "lang": "sv",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Ersta Sk\u00f6ndal H\u00f6gskola"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "entity_id": "https://idp.esh.se/idp/shibboleth"
    }
  ],
  [
    "https://shibboleth.gmu.edu/idp/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "holt@gmu.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tracy Holt"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "wallyg@gmu.edu"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Wally Grotophorst"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibboleth.gmu.edu/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "https://incommon.org",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/research-and-scholarship"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category-support",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              },
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://id.incommon.org/category/registered-by-incommon"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shibboleth.gmu.edu/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shibboleth.gmu.edu/idp/profile/Shibboleth/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shibboleth.gmu.edu/idp/profile/Shibboleth/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shibboleth.gmu.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shibboleth.gmu.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "gmu.edu"
              },
              {
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "George Mason University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDMzCCAhugAwIBAgIUepAw2N9+pmX9TWoDp/ZsdB/L1yEwDQYJKoZIhvcNAQEF\nBQAwHTEbMBkGA1UEAxMSc2hpYmJvbGV0aC5nbXUuZWR1MB4XDTEwMDYyNDE0NTMy\nMVoXDTMwMDYyNDE0NTMyMVowHTEbMBkGA1UEAxMSc2hpYmJvbGV0aC5nbXUuZWR1\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgp2Dn6k3UuILLaGWGcyQ\nenA31AxjXOoCM7zrhPpSJFzUSPHs2mC/fEqUhqmHJnPxGNalPpW9BH6SN1U2/C+e\nrfVL/OcO/x+Var0Pt+GodnlMsf+f7jcyLMzQB+xG+4/iKPoPByyOlThM+dO7/j/w\nQuclJu6f5iUTYyQM5u+DnvGzCmEA7Oq6E6c/FPegTAXCTnhQie9ZOOKjYfc/Y+y/\n1r7JYP4wkyk6ldk/Jt3xlP7eSvREIzMb5cetg1CbX6NmBsrBiSixMUDbOShDf01/\n8X6ebsaDIFCocE44/UAEM7xAQHUB/wHa7lhsVXI4pHUQ4eE5+9cjAq6/KkioOHnZ\naQIDAQABo2swaTBIBgNVHREEQTA/ghJzaGliYm9sZXRoLmdtdS5lZHWGKWh0dHBz\nOi8vc2hpYmJvbGV0aC5nbXUuZWR1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBSM\nUsKgJtDJoCxpwHtips8ra+EF+TANBgkqhkiG9w0BAQUFAAOCAQEAcpGmKUvfmyI7\nhbGONBpP3O5hTDeVe5Xiq5CHsfpduhsknht6uEWa8Z4dUg0QfAQKfaHvan4rg9Wl\nCHk4CnbLvB31Bbvz+TGjepNldfGeY2D0O4O2bxSjanFUAo1Kh+dUKSECtTEbwYdC\n2NcU2TQN4y5aEnC0jE8rj8VhvK3ynej8xJbqjVEY4Q6ndcvkUieqphdFOxBzIgk5\nIHEk7lPD0ggHR2Rp8nKE5xbCnL0j6WLTi+MbyMSZKlaNijMJJsybnB7L7dTXOR0z\n07DA0lAnAjYsa5Y/+xYddE7hlz3BkcttcuOgsEuLUtpd2wrWUGmJcOR7GUBTYfm4\ng750I0EPsQ=="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "George Mason University"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.gmu.edu/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "George Mason University"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://katalog.svkos.cz/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Zavilov\u00e1"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "zavilova@svkos.cz"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Magda"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://katalog.svkos.cz/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.eduid.cz/wiki/_media/en/eduid/policy/policy_eduid_en-1_1.pdf"
              },
              {
                "lang": "cs",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://www.eduid.cz/wiki/_media/eduid/policy/policy_eduid_cz-1_1-3.pdf"
              }
            ],
            "registration_instant": "2014-01-08T16:18:12Z",
            "registration_authority": "http://www.eduid.cz/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://eduid.cz/uri/idp-group/library"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://katalog.svkos.cz:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://katalog.svkos.cz:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDKzCCAhOgAwIBAgIUOaQEEERrbashpZa05w//pJQCTE0wDQYJKoZIhvcNAQEL\nBQAwGzEZMBcGA1UEAwwQa2F0YWxvZy5zdmtvcy5jejAeFw0xNTA4MTIyMTE4NTla\nFw0yNTA4MTIyMTE4NTlaMBsxGTAXBgNVBAMMEGthdGFsb2cuc3Zrb3MuY3owggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClR0WK0cmbSWU8RArh2svrRpft\nS4nHdg41jsbx0uKJWmpjVpxzIO8t1fpvgQEdjSM2mIBBuSeCpBX+O1Hogk8H7d1Y\nh4LLEkGKiBLQNZRxKueDGc1Pc54+iYy6oMcl1fhaoqphSkW9CqJXGb8lGEnfa8+t\n+MO62kESeTV/9L1fHb0exJgqzCrml/Byev7uXdaqRWqRVeXxy6eXlWhlLGwkPXMf\n9CbIyE5DyXHUupoJu8aiNh11JuR1VgZLUoOOS3yHE53HK200pISag+PIqc2g6hAw\nGHOjKJRcUrZSaqKKRvv39TLwqq9gPL3pSUVJ+G7GYc+mBFpclz/g+H/cCt0vAgMB\nAAGjZzBlMB0GA1UdDgQWBBQx4EEeJ3tf34XxGVnEpsE1hXAfTjBEBgNVHREEPTA7\nghBrYXRhbG9nLnN2a29zLmN6hidodHRwczovL2thdGFsb2cuc3Zrb3MuY3ovaWRw\nL3NoaWJib2xldGgwDQYJKoZIhvcNAQELBQADggEBACPiFGXFPzxPH/eTQKbJT5lP\nyOcSE2rtal8W4QDrkE4hU220t/JjQVsRzKMnvsv/rgY6CzEYcMkPitPjJoJXmLWY\nJZaaTxx0LosXA0MU8wBj6JKTMSDJ/EEkJOQuak+2lxxwv6greAAe/Ye+6x1fqN1h\nJE6TMVker9+t4OjM0aTX5LeBvJs7ZKwbTDsnm9y9I8EPwtPnX96M3cd/D7H5h4mF\nUUObFs5lyLqvErUgn3FwKNMmi2FrTI0J1HQtLx87hfeUvriApTOW/apm+kqWE6P5\niZxetNC82lCt7vGHOz5cXzYN2MEuqqCvAM2dTLO7rRhrSctONV0qrHlg1vZ4Vbw="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "svkos.cz"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }
        }
      ],
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/POST-SimpleSign/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://katalog.svkos.cz:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://katalog.svkos.cz/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://katalog.svkos.cz/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://katalog.svkos.cz:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://katalog.svkos.cz:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "svkos.cz"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.svkos.cz/en/"
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.svkos.cz/"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider for patrons and staff of Moravian-Silesian Research Library in Ostrava"
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Identity Provider pro \u010dten\u00e1\u0159e a zam\u011bstance Moravskoslezsk\u00e9 v\u011bdeck\u00e9 knihovny v Ostrav\u011b"
                  }
                ],
                "logo": [
                  {
                    "text": "https://katalog.svkos.cz/logo/logo_40.png",
                    "height": "40",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "40"
                  },
                  {
                    "text": "https://katalog.svkos.cz/logo/logo_90.png",
                    "height": "90",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "91"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Moravian-Silesian Research Library in Ostrava"
                  },
                  {
                    "lang": "cs",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Moravskoslezsk\u00e1 v\u011bdeck\u00e1 knihovna v Ostrav\u011b"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDKzCCAhOgAwIBAgIUOaQEEERrbashpZa05w//pJQCTE0wDQYJKoZIhvcNAQEL\nBQAwGzEZMBcGA1UEAwwQa2F0YWxvZy5zdmtvcy5jejAeFw0xNTA4MTIyMTE4NTla\nFw0yNTA4MTIyMTE4NTlaMBsxGTAXBgNVBAMMEGthdGFsb2cuc3Zrb3MuY3owggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClR0WK0cmbSWU8RArh2svrRpft\nS4nHdg41jsbx0uKJWmpjVpxzIO8t1fpvgQEdjSM2mIBBuSeCpBX+O1Hogk8H7d1Y\nh4LLEkGKiBLQNZRxKueDGc1Pc54+iYy6oMcl1fhaoqphSkW9CqJXGb8lGEnfa8+t\n+MO62kESeTV/9L1fHb0exJgqzCrml/Byev7uXdaqRWqRVeXxy6eXlWhlLGwkPXMf\n9CbIyE5DyXHUupoJu8aiNh11JuR1VgZLUoOOS3yHE53HK200pISag+PIqc2g6hAw\nGHOjKJRcUrZSaqKKRvv39TLwqq9gPL3pSUVJ+G7GYc+mBFpclz/g+H/cCt0vAgMB\nAAGjZzBlMB0GA1UdDgQWBBQx4EEeJ3tf34XxGVnEpsE1hXAfTjBEBgNVHREEPTA7\nghBrYXRhbG9nLnN2a29zLmN6hidodHRwczovL2thdGFsb2cuc3Zrb3MuY3ovaWRw\nL3NoaWJib2xldGgwDQYJKoZIhvcNAQELBQADggEBACPiFGXFPzxPH/eTQKbJT5lP\nyOcSE2rtal8W4QDrkE4hU220t/JjQVsRzKMnvsv/rgY6CzEYcMkPitPjJoJXmLWY\nJZaaTxx0LosXA0MU8wBj6JKTMSDJ/EEkJOQuak+2lxxwv6greAAe/Ye+6x1fqN1h\nJE6TMVker9+t4OjM0aTX5LeBvJs7ZKwbTDsnm9y9I8EPwtPnX96M3cd/D7H5h4mF\nUUObFs5lyLqvErUgn3FwKNMmi2FrTI0J1HQtLx87hfeUvriApTOW/apm+kqWE6P5\niZxetNC82lCt7vGHOz5cXzYN2MEuqqCvAM2dTLO7rRhrSctONV0qrHlg1vZ4Vbw="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "cs",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Moravskoslezsk\u00e1 v\u011bdeck\u00e1 knihovna v Ostrav\u011b"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Moravian-Silesian Research Library in Ostrava"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.svkos.cz/en/"
          },
          {
            "lang": "cs",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.svkos.cz/"
          }
        ],
        "organization_name": [
          {
            "lang": "cs",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Moravskoslezsk\u00e1 v\u011bdeck\u00e1 knihovna v Ostrav\u011b"
          },
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Moravian-Silesian Research Library in Ostrava"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://edugate.itb.ie/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Curran"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:dave.curran@itb.ie"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dave"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "O'Brien"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:Eamonn.OBrien@itb.ie"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Eamonn"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://edugate.itb.ie/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_instant": "2011-03-08T00:00:00Z",
            "registration_authority": "http://www.heanet.ie",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://edugate.itb.ie/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://edugate.itb.ie/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://edugate.itb.ie/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "itb.ie"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.itb.ie"
                  }
                ],
                "logo": [
                  {
                    "text": "https://edugate.heanet.ie/rr3/logos/itb.png",
                    "height": "65",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "235"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Institute of Technology Blanchardstown"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "geolocation_hint": [
                  {
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint",
                    "text": "geo:53.40572644015631,-6.378046274185181"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDIzCCAgugAwIBAgIUWE0VPYPdB8l/5af8W6PkkZDYFm4wDQYJKoZIhvcNAQEF\nBQAwGTEXMBUGA1UEAxMOZWR1Z2F0ZS5pdGIuaWUwHhcNMTEwNjAxMTQ1NjA1WhcN\nMzEwNjAxMTQ1NjA1WjAZMRcwFQYDVQQDEw5lZHVnYXRlLml0Yi5pZTCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJg3AH4MXYhZXU7pdFdV6lhsNB0/Qjqg\neYSiWfLoZydHcJXTJw7Tfk2/8iX/NkLiyX+zouYTuw99HJtb+oZ4WzW3vwD0pupy\neM4eteWkGycQBoW7aE+KAH8Qrsj3xiGSv0A6Yod6wHn7KyCAmxUb7wPOCf/yuj5z\nSvxZwdQWUXRqlirDhJgLsOSedru92hVRXbo8uMvnkdkWbwggBd5UMNGPZsPRBPKN\nP+nw5Ccvw2GWCZkpel4nqoIFu+8GbJVHYOrUliVLgNcv+lL22SlmI4ahqZDHTToC\nAzfRGuYUOtkpHlBp/H3ZQLEQ/61o5HWYB7RAtQNRCMU0u145/2uJ2TcCAwEAAaNj\nMGEwQAYDVR0RBDkwN4IOZWR1Z2F0ZS5pdGIuaWWGJWh0dHBzOi8vZWR1Z2F0ZS5p\ndGIuaWUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFARmPTDY2ovy8VOaLRwUc5al\nPqZNMA0GCSqGSIb3DQEBBQUAA4IBAQAZIThM8v0IQ++IyxuLKCPziFcDdl3Cptbv\n0LHvMWnVhskz5hxqaFBIyCCXtBwsVOMMGX5gNWtUm+7l+toa3AWC6bvjzDTCU64Z\nLW30XFU05arBASH+s1VNeOVnKHunsK1PN6qDH1VrXKkREyfDNWhQDHm1TE8JlBxY\ngbKMqJzGMLYTLc7xwiEn2qRh4Yh9TaoYwBHlPVTKR0Zd+p4N1xh3Bu5hr/V3MeHD\n6H4JYebKv15gO1dpxnngMQsnFs9lUqkcoMvPsJXj81AAO2WQUK4RC8SH+CL+pzqZ\nhj8bmirIgUuG9EBuz/X57eigHOWaytDx61rjjuvtKOWT2LgfwXqY"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Institute of Technology Blanchardstown"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.itb.ie"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Institute of Technology Blanchardstown"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://oala-dev.leedsbeckett.ac.uk/oala",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:ITServiceDesk@leedsbeckett.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "IT Service Desk"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Taylor"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:d.v.taylor@leedsbeckett.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "David"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://oala-dev.leedsbeckett.ac.uk/oala",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/hide-from-discovery"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2015-08-17T09:27:56Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://oala-dev.leedsbeckett.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://oala-dev.leedsbeckett.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "leedsbeckett.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDZDCCAkygAwIBAgIICY7brWx6wwgwDQYJKoZIhvcNAQEFBQAwSTEhMB8GA1UE\n\t\t\t\t\t\tCgwYTGVlZHMgQmVja2V0dCBVbml2ZXJzaXR5MSQwIgYDVQQDDBtvYWxhLWRldi5s\n\t\t\t\t\t\tZWVkc2JlY2tldHQuYWMudWswHhcNMTUwNzEzMTcwODU1WhcNMjUwNzEzMTcwODU1\n\t\t\t\t\t\tWjBJMSEwHwYDVQQKDBhMZWVkcyBCZWNrZXR0IFVuaXZlcnNpdHkxJDAiBgNVBAMM\n\t\t\t\t\t\tG29hbGEtZGV2LmxlZWRzYmVja2V0dC5hYy51azCCASIwDQYJKoZIhvcNAQEBBQAD\n\t\t\t\t\t\tggEPADCCAQoCggEBAJRvAT4MDeSjDJcqXiiMM8xYND6dAESfmu8rl5Glf0sCpkbn\n\t\t\t\t\t\t9/cVtSlZBUj12rjSlz5MKjLVB9IlJVP6LDmXi+VhEYt6y5+cnSSPOGz8vcA+FKic\n\t\t\t\t\t\tqyIMCsOqsOps/s/XvUHvMhn1DRrP9ABzJ7FMh07WJZmeAzdWFjwPa9pStLL5c+Tj\n\t\t\t\t\t\tzX6MXtEb0CorkdO3AOfA7W/105xyNdjY1mpGVNYh8ghmUsUbknWv1IV5wvvm14OU\n\t\t\t\t\t\t0FHxVlTOm/Gn9NE9kyZJ/0llfUzjklDwcdbPF97RYQkIPPXAGtSoQG4NKHXdfXOq\n\t\t\t\t\t\tHdZkHrw8uXFAXCACxgm3ySahQaVxxEMumONUNd8CAwEAAaNQME4wHQYDVR0OBBYE\n\t\t\t\t\t\tFAPEW0ahiwDvlwZaB+PIrnPRtdxPMB8GA1UdIwQYMBaAFAPEW0ahiwDvlwZaB+PI\n\t\t\t\t\t\trnPRtdxPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAHjbalsxsvOh\n\t\t\t\t\t\tl45Neg5IQrMmEZKkMYzCh7cMHVtQbMruF1KJQU70wB/aPh6qaGXdouvH4QqI4zAy\n\t\t\t\t\t\tbN68NsZUbBOv5W8j9rnQ8m6XvCAYBdeYFrASqiS2i378/g8RtCFAIwkgerDyl6SZ\n\t\t\t\t\t\tB7i1VPnDjQ77RigIZNsWgrYiT/nl7+v/67xLj6avdWuf9DadminHKxDsD1iwee3z\n\t\t\t\t\t\tR1ye3k2HIsyY7Hjdip04Lo7aMibXMu7z/1jR5MpFC8uMxd24uNa+lEZspTkuKMgY\n\t\t\t\t\t\t00OrkNXmwj/zp+J7ytw55N5v7ZImISb2jhaZ1r1iP7sH1dqcsjgWgVnajThtvRwN\n\t\t\t\t\t\t11uM54JtSeI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDZDCCAkygAwIBAgIICY7brWx6wwgwDQYJKoZIhvcNAQEFBQAwSTEhMB8GA1UE\n\t\t\t\t\t\tCgwYTGVlZHMgQmVja2V0dCBVbml2ZXJzaXR5MSQwIgYDVQQDDBtvYWxhLWRldi5s\n\t\t\t\t\t\tZWVkc2JlY2tldHQuYWMudWswHhcNMTUwNzEzMTcwODU1WhcNMjUwNzEzMTcwODU1\n\t\t\t\t\t\tWjBJMSEwHwYDVQQKDBhMZWVkcyBCZWNrZXR0IFVuaXZlcnNpdHkxJDAiBgNVBAMM\n\t\t\t\t\t\tG29hbGEtZGV2LmxlZWRzYmVja2V0dC5hYy51azCCASIwDQYJKoZIhvcNAQEBBQAD\n\t\t\t\t\t\tggEPADCCAQoCggEBAJRvAT4MDeSjDJcqXiiMM8xYND6dAESfmu8rl5Glf0sCpkbn\n\t\t\t\t\t\t9/cVtSlZBUj12rjSlz5MKjLVB9IlJVP6LDmXi+VhEYt6y5+cnSSPOGz8vcA+FKic\n\t\t\t\t\t\tqyIMCsOqsOps/s/XvUHvMhn1DRrP9ABzJ7FMh07WJZmeAzdWFjwPa9pStLL5c+Tj\n\t\t\t\t\t\tzX6MXtEb0CorkdO3AOfA7W/105xyNdjY1mpGVNYh8ghmUsUbknWv1IV5wvvm14OU\n\t\t\t\t\t\t0FHxVlTOm/Gn9NE9kyZJ/0llfUzjklDwcdbPF97RYQkIPPXAGtSoQG4NKHXdfXOq\n\t\t\t\t\t\tHdZkHrw8uXFAXCACxgm3ySahQaVxxEMumONUNd8CAwEAAaNQME4wHQYDVR0OBBYE\n\t\t\t\t\t\tFAPEW0ahiwDvlwZaB+PIrnPRtdxPMB8GA1UdIwQYMBaAFAPEW0ahiwDvlwZaB+PI\n\t\t\t\t\t\trnPRtdxPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAHjbalsxsvOh\n\t\t\t\t\t\tl45Neg5IQrMmEZKkMYzCh7cMHVtQbMruF1KJQU70wB/aPh6qaGXdouvH4QqI4zAy\n\t\t\t\t\t\tbN68NsZUbBOv5W8j9rnQ8m6XvCAYBdeYFrASqiS2i378/g8RtCFAIwkgerDyl6SZ\n\t\t\t\t\t\tB7i1VPnDjQ77RigIZNsWgrYiT/nl7+v/67xLj6avdWuf9DadminHKxDsD1iwee3z\n\t\t\t\t\t\tR1ye3k2HIsyY7Hjdip04Lo7aMibXMu7z/1jR5MpFC8uMxd24uNa+lEZspTkuKMgY\n\t\t\t\t\t\t00OrkNXmwj/zp+J7ytw55N5v7ZImISb2jhaZ1r1iP7sH1dqcsjgWgVnajThtvRwN\n\t\t\t\t\t\t11uM54JtSeI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Leeds Beckett University (Development)"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.leedsbeckett.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Leeds Beckett University"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://rutcathens.rutc.ac.uk/oala/metadata",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Ball"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:jane.ball@rutc.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Jane"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Kayes"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:tom.kayes@rutc.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tom"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://rutcathens.rutc.ac.uk/oala/metadata",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "want_authn_requests_signed": "false",
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://rutcathens.rutc.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://rutcathens.rutc.ac.uk/oala/sso",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "rutc.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDuzCCAqOgAwIBAgIJAN1WsDggoMVvMA0GCSqGSIb3DQEBBQUAMEcxJTAjBgNV\n\t\t\t\t\t\tBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxlZ2UxHjAcBgNVBAMTFXJ1dGNh\n\t\t\t\t\t\tdGhlbnMucnV0Yy5hYy51azAeFw0xMDExMTExMTM0MTZaFw0yMDExMDgxMTM0MTZa\n\t\t\t\t\t\tMEcxJTAjBgNVBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxlZ2UxHjAcBgNV\n\t\t\t\t\t\tBAMTFXJ1dGNhdGhlbnMucnV0Yy5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEP\n\t\t\t\t\t\tADCCAQoCggEBALqStCmUSU8IaQxOwt2Ou+wphpG1cqQYzY/17w8G0ftlzo5+mSJf\n\t\t\t\t\t\tAoPIBYSKmqvJtAqPww4TSrePmQihLopDHHlj6FcFywWYMoGf0JDk/piGgNF/Clj6\n\t\t\t\t\t\tmSXdu/VSuanx2uq5V512W+5A9clJqmBPIAZiglMaHcxDgR5cG7K75it3iSAX81wA\n\t\t\t\t\t\tPX9+T0TbvLGvqVSeSqQ2UVy728uLF53I2eSYta24l99yrSnOziNVHCD6+b0l7t1K\n\t\t\t\t\t\tOKrkuOLLSfuwTzxLeMlq67VOgymL1FrNWvWaySrh1NWWKAdND11Vgk7z4+hFbbfL\n\t\t\t\t\t\tersUW6JBGJUGysvTIFlrpnp81ibXAO28mTUCAwEAAaOBqTCBpjAdBgNVHQ4EFgQU\n\t\t\t\t\t\tnUoRxGM/pC8cQmwmpxUhC8V8wikwdwYDVR0jBHAwboAUnUoRxGM/pC8cQmwmpxUh\n\t\t\t\t\t\tC8V8wimhS6RJMEcxJTAjBgNVBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxl\n\t\t\t\t\t\tZ2UxHjAcBgNVBAMTFXJ1dGNhdGhlbnMucnV0Yy5hYy51a4IJAN1WsDggoMVvMAwG\n\t\t\t\t\t\tA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAKwWAWDeDlDvy8ROsFlboPkl\n\t\t\t\t\t\tR0Kq4+4fYhf6/1ihswDC/81AsYtT+2+J7ddNt2mQ8ElBJIvPxFGo9nrfh0OAEQqE\n\t\t\t\t\t\t/SFzabz7Co6EZrTjaq6w0Ga4SLGllKtDtHV/OgvNhNk0HdkHP4EHueq4KJl+ZWoS\n\t\t\t\t\t\tk3F+XEpmVs7e8DSGPY2CQO1cKYqFZF/4mqs1dcmXWqK4FLU8xlR4urtwxPybYRd3\n\t\t\t\t\t\tkTNdyaLJMlqWpe/LumRJ323OxgwDDUxgadxQ99CpcsRN8fn3CyiW5vnf3jjMl91r\n\t\t\t\t\t\t/N50CdH4cNvfaDEqHTiucQkIxjF+VsVX3S3Q5xGnLOJex9/Li8kVqnR1hZOkxi0="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDuzCCAqOgAwIBAgIJAN1WsDggoMVvMA0GCSqGSIb3DQEBBQUAMEcxJTAjBgNV\n\t\t\t\t\t\tBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxlZ2UxHjAcBgNVBAMTFXJ1dGNh\n\t\t\t\t\t\tdGhlbnMucnV0Yy5hYy51azAeFw0xMDExMTExMTM0MTZaFw0yMDExMDgxMTM0MTZa\n\t\t\t\t\t\tMEcxJTAjBgNVBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxlZ2UxHjAcBgNV\n\t\t\t\t\t\tBAMTFXJ1dGNhdGhlbnMucnV0Yy5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEP\n\t\t\t\t\t\tADCCAQoCggEBALqStCmUSU8IaQxOwt2Ou+wphpG1cqQYzY/17w8G0ftlzo5+mSJf\n\t\t\t\t\t\tAoPIBYSKmqvJtAqPww4TSrePmQihLopDHHlj6FcFywWYMoGf0JDk/piGgNF/Clj6\n\t\t\t\t\t\tmSXdu/VSuanx2uq5V512W+5A9clJqmBPIAZiglMaHcxDgR5cG7K75it3iSAX81wA\n\t\t\t\t\t\tPX9+T0TbvLGvqVSeSqQ2UVy728uLF53I2eSYta24l99yrSnOziNVHCD6+b0l7t1K\n\t\t\t\t\t\tOKrkuOLLSfuwTzxLeMlq67VOgymL1FrNWvWaySrh1NWWKAdND11Vgk7z4+hFbbfL\n\t\t\t\t\t\tersUW6JBGJUGysvTIFlrpnp81ibXAO28mTUCAwEAAaOBqTCBpjAdBgNVHQ4EFgQU\n\t\t\t\t\t\tnUoRxGM/pC8cQmwmpxUhC8V8wikwdwYDVR0jBHAwboAUnUoRxGM/pC8cQmwmpxUh\n\t\t\t\t\t\tC8V8wimhS6RJMEcxJTAjBgNVBAoTHFJpY2htb25kIHVwb24gVGhhbWVzIENvbGxl\n\t\t\t\t\t\tZ2UxHjAcBgNVBAMTFXJ1dGNhdGhlbnMucnV0Yy5hYy51a4IJAN1WsDggoMVvMAwG\n\t\t\t\t\t\tA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAKwWAWDeDlDvy8ROsFlboPkl\n\t\t\t\t\t\tR0Kq4+4fYhf6/1ihswDC/81AsYtT+2+J7ddNt2mQ8ElBJIvPxFGo9nrfh0OAEQqE\n\t\t\t\t\t\t/SFzabz7Co6EZrTjaq6w0Ga4SLGllKtDtHV/OgvNhNk0HdkHP4EHueq4KJl+ZWoS\n\t\t\t\t\t\tk3F+XEpmVs7e8DSGPY2CQO1cKYqFZF/4mqs1dcmXWqK4FLU8xlR4urtwxPybYRd3\n\t\t\t\t\t\tkTNdyaLJMlqWpe/LumRJ323OxgwDDUxgadxQ99CpcsRN8fn3CyiW5vnf3jjMl91r\n\t\t\t\t\t\t/N50CdH4cNvfaDEqHTiucQkIxjF+VsVX3S3Q5xGnLOJex9/Li8kVqnR1hZOkxi0="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Richmond upon Thames College"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.rutc.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Richmond upon Thames College"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://utwente.nl/",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "support@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "help@surfconext.nl"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "SURFconext support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://utwente.nl/",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "https://wiki.surfnet.nl/display/eduGAIN/EduGAIN"
              }
            ],
            "registration_instant": "2014-09-09T08:40:00Z",
            "registration_authority": "http://www.surfconext.nl/",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://engine.surfconext.nl/authentication/idp/single-sign-on/771fcfef97ddd691af69d7a52b7d2457",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor",
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Universiteit Twente"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Universiteit Twente"
                  }
                ],
                "logo": [
                  {
                    "text": "https://static.surfconext.nl/logos/idp/utwente.png",
                    "height": "48",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "108"
                  }
                ],
                "display_name": [
                  {
                    "lang": "nl",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Universiteit Twente"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of Twente"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIID3zCCAsegAwIBAgIJAMVC9xn1ZfsuMA0GCSqGSIb3DQEBCwUAMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTAeFw0xNDA1MDUxNDIyMzVaFw0xOTA1MDUxNDIyMzVaMIGFMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEQMA4GA1UEBwwHVXRyZWNodDEVMBMGA1UECgwMU1VSRm5ldCBCLlYuMRMwEQYDVQQLDApTVVJGY29uZXh0MSYwJAYDVQQDDB1lbmdpbmUuc3VyZmNvbmV4dC5ubCAyMDE0MDUwNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKthMDbB0jKHefPzmRu9t2h7iLP4wAXr42bHpjzTEk6gttHFb4l/hFiz1YBI88TjiH6hVjnozo/YHA2c51us+Y7g0XoS7653lbUN/EHzvDMuyis4Xi2Ijf1A/OUQfH1iFUWttIgtWK9+fatXoGUS6tirQvrzVh6ZstEp1xbpo1SF6UoVl+fh7tM81qz+Crr/Kroan0UjpZOFTwxPoK6fdLgMAieKSCRmBGpbJHbQ2xxbdykBBrBbdfzIX4CDepfjE9h/40ldw5jRn3e392jrS6htk23N9BWWrpBT5QCk0kH3h/6F1Dm6TkyG9CDtt73/anuRkvXbeygI4wml9bL3rE8CAwEAAaNQME4wHQYDVR0OBBYEFD+Ac7akFxaMhBQAjVfvgGfY8hNKMB8GA1UdIwQYMBaAFD+Ac7akFxaMhBQAjVfvgGfY8hNKMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAC8L9D67CxIhGo5aGVu63WqRHBNOdo/FAGI7LURDFeRmG5nRw/VXzJLGJksh4FSkx7aPrxNWF1uFiDZ80EuYQuIv7bDLblK31ZEbdg1R9LgiZCdYSr464I7yXQY9o6FiNtSKZkQO8EsscJPPy/Zp4uHAnADWACkOUHiCbcKiUUFu66dX0Wr/v53Gekz487GgVRs8HEeT9MU1reBKRgdENR8PNg4rbQfLc3YQKLWK7yWnn/RenjDpuCiePj8N8/80tGgrNgK/6fzM3zI18sSywnXLswxqDb/J+jgVxnQ6MrsTf1urM8MnfcxG/82oHIwfMh/sXPCZpo+DTLkhQxctJ3M="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "Universiteit Twente"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.utwente.nl/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "Universiteit Twente"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://shibboleth3.liv.ac.uk/idp/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Pretlove"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:T.Pretlove@liverpool.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tim"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Pretlove"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:T.Pretlove@liverpool.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Tim"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://shibboleth3.liv.ac.uk/idp/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://refeds.org/category/hide-from-discovery"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          },
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2014-05-14T11:14:00Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDQDCCAiigAwIBAgIVANlUxUdyvt878JJZeQqXZAX2ZiW9MA0GCSqGSIb3DQEB\n\t\t\t\t\t\tBQUAMCAxHjAcBgNVBAMTFXNoaWJib2xldGgzLmxpdi5hYy51azAeFw0xNDAzMjEx\n\t\t\t\t\t\tNjMxNDlaFw0zNDAzMjExNjMxNDlaMCAxHjAcBgNVBAMTFXNoaWJib2xldGgzLmxp\n\t\t\t\t\t\tdi5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKtlHz1hrD0F\n\t\t\t\t\t\tf0M6F1zN8ZBoY5qI2wYwfjcRuXVfZlSJVhODsOUWWxUnfdqV7KBA0HcgRCK008g2\n\t\t\t\t\t\th/sjZXH/VU8M0EHhaYHHkyQxSBwEjWhbVcOT9iI1TkZqHNqZtJQIw7rnybskkv/3\n\t\t\t\t\t\t6IiBtGZgkZL3CZjp0kkqsOh19k/cioEsNsd4cKUyvhVEUvqtO1VULemasTnkmUtk\n\t\t\t\t\t\txJegTZXyW2W6TYMlTxeTwJQWe97WNxpCvV/3ounzXnLTUG5Te4i2ptA67JItknmw\n\t\t\t\t\t\tkS1p/a6d9B63gvHch27jFzollXccq4Gb2VSNLq3B8eAo8+Hnny9vLYYlKH1H7H9q\n\t\t\t\t\t\tgAo8OSA2ZbUCAwEAAaNxMG8wTgYDVR0RBEcwRYIVc2hpYmJvbGV0aDMubGl2LmFj\n\t\t\t\t\t\tLnVrhixodHRwczovL3NoaWJib2xldGgzLmxpdi5hYy51ay9pZHAvc2hpYmJvbGV0\n\t\t\t\t\t\taDAdBgNVHQ4EFgQU7Cmjd6WsvyQ90NQeufSKvO/8yVIwDQYJKoZIhvcNAQEFBQAD\n\t\t\t\t\t\tggEBAIhTLBoOX4fvW9dYMfvjD77y8lyo2UFdATt6G6KWlCosBDkOwDTGK4N5g7CU\n\t\t\t\t\t\t/AxoGWBYLtd+KHy5ii5oV781aMLPa3ClDs1UYE/NuwkylvoSO0+agpeH6oF7IJxH\n\t\t\t\t\t\tN7EsSimVuaLi/R2ghs0KLwv6JfFUkhO2G2S5VTS/FZn/B8NgmBo+fLuJ6DLCQwJJ\n\t\t\t\t\t\tvnqXf9DPozHSBUOQAEkZcjKRSl+QTO6SleKLg5ahHNC3kT+dzF2ACKJMC7f4WzAL\n\t\t\t\t\t\trA/YOcNxfwUB/eiEgmw9dDwpUvOuH+NDET/ASLH3mXUA1w7DkzzHTZkMn9k/Up6O\n\t\t\t\t\t\tSX7ypoc/4IGOgkCbLMA/5Z8ZidI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "liv.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib3-test.liv.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib3-test.liv.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/SAML2/Redirect/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/SAML2/POST/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib3-test.liv.ac.uk:8443/idp/profile/SAML2/SOAP/SLO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://shib3-test.liv.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://shib3-test.liv.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://shib3-test.liv.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "liv.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDQDCCAiigAwIBAgIVANlUxUdyvt878JJZeQqXZAX2ZiW9MA0GCSqGSIb3DQEB\n\t\t\t\t\t\tBQUAMCAxHjAcBgNVBAMTFXNoaWJib2xldGgzLmxpdi5hYy51azAeFw0xNDAzMjEx\n\t\t\t\t\t\tNjMxNDlaFw0zNDAzMjExNjMxNDlaMCAxHjAcBgNVBAMTFXNoaWJib2xldGgzLmxp\n\t\t\t\t\t\tdi5hYy51azCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKtlHz1hrD0F\n\t\t\t\t\t\tf0M6F1zN8ZBoY5qI2wYwfjcRuXVfZlSJVhODsOUWWxUnfdqV7KBA0HcgRCK008g2\n\t\t\t\t\t\th/sjZXH/VU8M0EHhaYHHkyQxSBwEjWhbVcOT9iI1TkZqHNqZtJQIw7rnybskkv/3\n\t\t\t\t\t\t6IiBtGZgkZL3CZjp0kkqsOh19k/cioEsNsd4cKUyvhVEUvqtO1VULemasTnkmUtk\n\t\t\t\t\t\txJegTZXyW2W6TYMlTxeTwJQWe97WNxpCvV/3ounzXnLTUG5Te4i2ptA67JItknmw\n\t\t\t\t\t\tkS1p/a6d9B63gvHch27jFzollXccq4Gb2VSNLq3B8eAo8+Hnny9vLYYlKH1H7H9q\n\t\t\t\t\t\tgAo8OSA2ZbUCAwEAAaNxMG8wTgYDVR0RBEcwRYIVc2hpYmJvbGV0aDMubGl2LmFj\n\t\t\t\t\t\tLnVrhixodHRwczovL3NoaWJib2xldGgzLmxpdi5hYy51ay9pZHAvc2hpYmJvbGV0\n\t\t\t\t\t\taDAdBgNVHQ4EFgQU7Cmjd6WsvyQ90NQeufSKvO/8yVIwDQYJKoZIhvcNAQEFBQAD\n\t\t\t\t\t\tggEBAIhTLBoOX4fvW9dYMfvjD77y8lyo2UFdATt6G6KWlCosBDkOwDTGK4N5g7CU\n\t\t\t\t\t\t/AxoGWBYLtd+KHy5ii5oV781aMLPa3ClDs1UYE/NuwkylvoSO0+agpeH6oF7IJxH\n\t\t\t\t\t\tN7EsSimVuaLi/R2ghs0KLwv6JfFUkhO2G2S5VTS/FZn/B8NgmBo+fLuJ6DLCQwJJ\n\t\t\t\t\t\tvnqXf9DPozHSBUOQAEkZcjKRSl+QTO6SleKLg5ahHNC3kT+dzF2ACKJMC7f4WzAL\n\t\t\t\t\t\trA/YOcNxfwUB/eiEgmw9dDwpUvOuH+NDET/ASLH3mXUA1w7DkzzHTZkMn9k/Up6O\n\t\t\t\t\t\tSX7ypoc/4IGOgkCbLMA/5Z8ZidI="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Liverpool - Test"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.liv.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Liverpool"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://idp.sussex.ac.uk/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Lewney"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:d.m.lewney@sussex.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dave"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Lewney"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:d.m.lewney@sussex.ac.uk"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Dave"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://idp.sussex.ac.uk/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "attribute_authority_descriptor": [
        {
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDKDCCAhCgAwIBAgIVAL/cBrEESZ0ZPT7d+5iLH4sqVPESMA0GCSqGSIb3DQEB\n\t\t\t\t\t\tBQUAMBsxGTAXBgNVBAMTEGlkcC5zdXNzZXguYWMudWswHhcNMTMwODAxMTQ0NzE2\n\t\t\t\t\t\tWhcNMzMwODAxMTQ0NzE2WjAbMRkwFwYDVQQDExBpZHAuc3Vzc2V4LmFjLnVrMIIB\n\t\t\t\t\t\tIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAofHugvoV3CedXGuTc3l8gbwJ\n\t\t\t\t\t\tMU0hCP2TetJq7VXqKOXfedqQ5wDagYUvHhi+PqzakJhVridhguoywOiQQHSuGRhc\n\t\t\t\t\t\t4YhYo0kZe6w9PU4NGJztKwIoc90pMGfP9F0MlnyFL4UFEtdMVKhMWl0uPJJec3EH\n\t\t\t\t\t\tMnzTAeakGSENoVAasX3m+vaDoldAeIy7agcQ38K/MaVAskiF4QzP2k+uVFfjC91w\n\t\t\t\t\t\trVKDi6xyDGbFiBkgIlkpXhnjkoIyWSdaKKxAR+3V39pMFkrhznptHBk+Nm6lc5Rs\n\t\t\t\t\t\tIsQFxeoWp8YpFDWjatkTJAid6GCVxIMn7iA04fe7WNknFERgTcVe76mFa5895QID\n\t\t\t\t\t\tAQABo2MwYTBABgNVHREEOTA3ghBpZHAuc3Vzc2V4LmFjLnVrhiNodHRwczovL2lk\n\t\t\t\t\t\tcC5zdXNzZXguYWMudWsvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUW2CGoKuq5ytmpRKk\n\t\t\t\t\t\tvK0UKWA0PZIwDQYJKoZIhvcNAQEFBQADggEBABYQwDDUPodVsJLXP1+4RYXzcALB\n\t\t\t\t\t\tGD+URWmXudUbkmvVyPBFlG61W7aritNYPswnsMkeTsWGceygRZDduiDhImMk3psM\n\t\t\t\t\t\ttfjPPZsCNYNPj+E5kXrxj5S4y0wBPCUA5li9avuUwyiv7Cj41x0R/MBsTOzZymM1\n\t\t\t\t\t\tWAdfk2BWiiO76mGt0T5JtkEvyMR2oOguM3rHyQvSprZwixI5iC51Jgz8hi9/g6uB\n\t\t\t\t\t\thXl7a/FvOINuTcakieicxaKoY8SLwlPSohC5MY7JrRYuoGc72ROnYh41NN7DKmcl\n\t\t\t\t\t\t9i3j/XWPg4DPCgnybKfTsjUDXFGJsKprFqXkTm2t9sAytMmdCHUYvCGzbMk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor",
          "extensions": {
            "extension_elements": [
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "sussex.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.sussex.ac.uk:8443/idp/profile/SAML1/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.sussex.ac.uk:8443/idp/profile/SAML2/SOAP/AttributeQuery",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ]
        }
      ],
      "idpsso_descriptor": [
        {
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest",
              "location": "https://idp.sussex.ac.uk/idp/profile/Shibboleth/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://idp.sussex.ac.uk/idp/profile/SAML2/POST/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://idp.sussex.ac.uk/idp/profile/SAML2/POST-SimpleSign/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://idp.sussex.ac.uk/idp/profile/SAML2/Redirect/SSO",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding",
              "location": "https://idp.sussex.ac.uk:8443/idp/profile/SAML1/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://idp.sussex.ac.uk:8443/idp/profile/SAML2/SOAP/ArtifactResolution",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "2"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "University of Sussex"
                  }
                ],
                "logo": [
                  {
                    "text": "https://www.sussex.ac.uk/includes/images/external/logo.jpg",
                    "height": "60",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "147"
                  },
                  {
                    "text": "https://www.sussex.ac.uk/includes/images/external/favicon.gif",
                    "height": "16",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo",
                    "width": "16"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "University of Sussex"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              },
              {
                "regexp": "false",
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope",
                "text": "sussex.ac.uk"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDKDCCAhCgAwIBAgIVAL/cBrEESZ0ZPT7d+5iLH4sqVPESMA0GCSqGSIb3DQEB\n\t\t\t\t\t\tBQUAMBsxGTAXBgNVBAMTEGlkcC5zdXNzZXguYWMudWswHhcNMTMwODAxMTQ0NzE2\n\t\t\t\t\t\tWhcNMzMwODAxMTQ0NzE2WjAbMRkwFwYDVQQDExBpZHAuc3Vzc2V4LmFjLnVrMIIB\n\t\t\t\t\t\tIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAofHugvoV3CedXGuTc3l8gbwJ\n\t\t\t\t\t\tMU0hCP2TetJq7VXqKOXfedqQ5wDagYUvHhi+PqzakJhVridhguoywOiQQHSuGRhc\n\t\t\t\t\t\t4YhYo0kZe6w9PU4NGJztKwIoc90pMGfP9F0MlnyFL4UFEtdMVKhMWl0uPJJec3EH\n\t\t\t\t\t\tMnzTAeakGSENoVAasX3m+vaDoldAeIy7agcQ38K/MaVAskiF4QzP2k+uVFfjC91w\n\t\t\t\t\t\trVKDi6xyDGbFiBkgIlkpXhnjkoIyWSdaKKxAR+3V39pMFkrhznptHBk+Nm6lc5Rs\n\t\t\t\t\t\tIsQFxeoWp8YpFDWjatkTJAid6GCVxIMn7iA04fe7WNknFERgTcVe76mFa5895QID\n\t\t\t\t\t\tAQABo2MwYTBABgNVHREEOTA3ghBpZHAuc3Vzc2V4LmFjLnVrhiNodHRwczovL2lk\n\t\t\t\t\t\tcC5zdXNzZXguYWMudWsvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUW2CGoKuq5ytmpRKk\n\t\t\t\t\t\tvK0UKWA0PZIwDQYJKoZIhvcNAQEFBQADggEBABYQwDDUPodVsJLXP1+4RYXzcALB\n\t\t\t\t\t\tGD+URWmXudUbkmvVyPBFlG61W7aritNYPswnsMkeTsWGceygRZDduiDhImMk3psM\n\t\t\t\t\t\ttfjPPZsCNYNPj+E5kXrxj5S4y0wBPCUA5li9avuUwyiv7Cj41x0R/MBsTOzZymM1\n\t\t\t\t\t\tWAdfk2BWiiO76mGt0T5JtkEvyMR2oOguM3rHyQvSprZwixI5iC51Jgz8hi9/g6uB\n\t\t\t\t\t\thXl7a/FvOINuTcakieicxaKoY8SLwlPSohC5MY7JrRYuoGc72ROnYh41NN7DKmcl\n\t\t\t\t\t\t9i3j/XWPg4DPCgnybKfTsjUDXFGJsKprFqXkTm2t9sAytMmdCHUYvCGzbMk="
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "name_id_format": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:mace:shibboleth:1.0:nameIdentifier"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"
            },
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat",
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor"
        }
      ],
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "University of Sussex"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.sussex.ac.uk/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "University of Sussex"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }
    }
  ],
  [
    "https://vfuportalportfolio-test.su.se/Shibboleth.sso",
    {
      "extensions": {
        "extension_elements": [
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmlenc#sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&DigestMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2009/xmldsig11#dsa-sha256",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#rsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "algorithm": "http://www.w3.org/2000/09/xmldsig#dsa-sha1",
            "__class__": "urn:oasis:names:tc:SAML:metadata:algsupport&SigningMethod"
          },
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/hei-service"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/research-and-education"
                  },
                  {
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    },
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue",
                    "text": "http://www.swamid.se/category/sfs-1993-1153"
                  }
                ],
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                "name": "http://macedir.org/entity-category",
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "entity_id": "https://vfuportalportfolio-test.su.se/Shibboleth.sso",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF/wavelan",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF/wavelan",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF/idp.it.su.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/WAYF/idp-test.it.su.se",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:request-init",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SWAMID",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:request-init&RequestInitiator"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SWAMID",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "3"
              },
              {
                "description": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "SP \u00e4r f\u00f6r ny vfuportalportfolio milj\u00f6 (som ska speglas vfu-test.su.se)."
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "SP is for new vfuportalportfolio environment (Mirror environment for vfu-test.su.se )"
                  }
                ],
                "display_name": [
                  {
                    "lang": "sv",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Test Verksamhetsf\u00f6rlagd utbildning Stockholms universitet"
                  },
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Test Workplace Situated Education at Stockholm University"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes128-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes192-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#aes256-gcm",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                },
                {
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod"
                }
              ],
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "vfuportalportfolio-test-app01"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDHjCCAgagAwIBAgIJAIx7KH7z5CJWMA0GCSqGSIb3DQEBBQUAMCgxJjAkBgNV\nBAMTHXZmdXBvcnRhbHBvcnRmb2xpby10ZXN0LWFwcDAxMB4XDTE2MDQxODA5MzA1\nOFoXDTI2MDQxNjA5MzA1OFowKDEmMCQGA1UEAxMddmZ1cG9ydGFscG9ydGZvbGlv\nLXRlc3QtYXBwMDEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClgyOH\n4iU73ym+JGI9Gdra3uunqlmvIFVe9SvA7bXaV6g0Ew1vLO8kId+zpxf26PZSPnbV\nXspO03vp8yLa7Xuxb50CtvBCWYyo1d56G/hNl7Eky6VOyGPhYS8iYdZneoLf7hs7\nXxpsR2ML6FrRT1at+kPa/sDA8yOXbuXsbbASOFxtQP1RRFPVoAcC+qWx73WeLrnL\nYr+70Dmme6kvXPKZT9yg/s/IkhOb4frY8Gzv1apnEyxRVSAwf4N9QE07KEZP5QiB\nBYgIAOK1hQl/bggcpJoQgNDAxKd6+Ko+1ZQMKSdrZ7qmpEj+GZqFME2mgjZzASZJ\nWaDcYzc8tr+hzuJdAgMBAAGjSzBJMCgGA1UdEQQhMB+CHXZmdXBvcnRhbHBvcnRm\nb2xpby10ZXN0LWFwcDAxMB0GA1UdDgQWBBSG1ecYic2UxOhGiceG2PEOJkAalDAN\nBgkqhkiG9w0BAQUFAAOCAQEAnDXs8Q5+FeixXwuKhBSqE83s1FUPcobGkDRrtkcA\nKTIRWRtB/G7A7hNL6rrfripKddoKgxqEEz89xfR9LS0jt/RIaC6ansmFplBeBMnD\nHfnEL7a3tPUeMcZTYn+HYcFgDC7tSNfP/awmeuErweVCDSdrnidHYJE8LP0Ai5ZC\nk215wjr2WUf/IV03yroF2sykwMWLiAdpW+WccO/rBuTZsvq4+qugiE07DM8d2jv+\nwPTYRmTfKywcuDCB2/hUqex1uft/RNfE7JwgS1UblSJLxyrdF12RRzxbnCHoel/x\njuv3gekXlDpGuCilsBc8x619HHAJMerrhiJBiVwRhGTxnQ=="
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=vfuportalportfolio-test-app01"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "5"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://vfuportalportfolio-test.su.se/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://wiki2.redclara.net/shibboleth",
    {
      "contact_person": [
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "seg@redclara.net"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Authentication Support"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "seg@redclara.net"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Technical Support"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Urban"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mark.urban@redclara.net"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Mark"
          },
          "contact_type": "administrative",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://wiki2.redclara.net/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "es",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://cofre.reuna.cl/index.php/es/reglas-federacion"
              }
            ],
            "registration_instant": "2014-02-21T00:00:00Z",
            "registration_authority": "http://cofre.reuna.cl",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "RedCLARA"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.redclara.net/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "RedCLARA"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "attribute_consuming_service": [
            {
              "service_name": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName",
                  "text": "Wiki - RedCLARA"
                }
              ],
              "service_description": [
                {
                  "lang": "en",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription",
                  "text": "Wiki - RedCLARA"
                }
              ],
              "index": "1",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService",
              "requested_attribute": [
                {
                  "friendly_name": "mail",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:0.9.2342.19200300.100.1.3",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "surname",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.4",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                },
                {
                  "friendly_name": "givenName",
                  "is_required": "true",
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
                  "name": "urn:oid:2.5.4.42",
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute"
                }
              ]
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "extensions": {
            "extension_elements": [
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://wiki2.redclara.net/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "1"
              },
              {
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol",
                "location": "https://wiki2.redclara.net/Shibboleth.sso/DS",
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse",
                "index": "2"
              },
              {
                "information_url": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.redclara.net/index.php?lang=en"
                  },
                  {
                    "lang": "es",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL",
                    "text": "http://www.redclara.net/index.php?lang=es"
                  }
                ],
                "description": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "RedCLARA's Wiki Service"
                  },
                  {
                    "lang": "es",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description",
                    "text": "Servicio de Wiki de RedCLARA"
                  }
                ],
                "display_name": [
                  {
                    "lang": "en",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Wiki - RedCLARA"
                  },
                  {
                    "lang": "es",
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName",
                    "text": "Wiki - RedCLARA"
                  }
                ],
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ],
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          },
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "*.redclara.net"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "redclara.net"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFJzCCBA+gAwIBAgIQAycc1VlqLQ1YMhUWYD69ajANBgkqhkiG9w0BAQsFADBN\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMScwJQYDVQQDEx5E\naWdpQ2VydCBTSEEyIFNlY3VyZSBTZXJ2ZXIgQ0EwHhcNMTQxMTI4MDAwMDAwWhcN\nMTcxMjA2MTIwMDAwWjB1MQswCQYDVQQGEwJVWTETMBEGA1UEBxMKTW9udGV2aWRl\nbzE4MDYGA1UECgwvQ29vcGVyYWNpw7NuIExhdGlub2FtZXJpY2FuYSBkZSBSZWRl\ncyBBdmFuemFkYXMxFzAVBgNVBAMMDioucmVkY2xhcmEubmV0MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4ciHwzKgzkUxp9PSRy9gV4WfIAmIjugbR8f9\nRJD9GwoMPTA173v4Rzjbnl8h/3e+iDfdzetHRM+gkOXwPCaGFpBQa2EPnxtFaaH6\nl8xtfHlsl8D2lqRkOE2OjvP8GzgpT3ikMBXoNr4TL7RQqzinwYCCJzLMSflwNbtk\n/a04k3l9FyxJ4mqEFP6aUsPJA0YRLVrYOIyppRzcHbRng/pNPE0R+JhNC3Kx2SbJ\nUvKtjQfvMJCn2T2dn5hg5mFnyMl78pgmRjppgxWEWkti+4eZoLg0OwVEFyGEgmEU\namd6JmRZTDs04BtstymJNXdkTsCP7yk92lpAc9C3NZ3FvrR0eQIDAQABo4IB2TCC\nAdUwHwYDVR0jBBgwFoAUD4BhHIIxYdUvKOeNRji0LOHG2eIwHQYDVR0OBBYEFBFj\nG3+tyY7afXZLfXNuYoGnE0nEMCcGA1UdEQQgMB6CDioucmVkY2xhcmEubmV0ggxy\nZWRjbGFyYS5uZXQwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMB\nBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2Vy\ndC5jb20vc3NjYS1zaGEyLWczLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNl\ncnQuY29tL3NzY2Etc2hhMi1nMy5jcmwwQgYDVR0gBDswOTA3BglghkgBhv1sAQEw\nKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzB8Bggr\nBgEFBQcBAQRwMG4wJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv\nbTBGBggrBgEFBQcwAoY6aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lD\nZXJ0U0hBMlNlY3VyZVNlcnZlckNBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3\nDQEBCwUAA4IBAQB3WePP9QxLi7OdtCbfR6kqIPDvfVX3aMvJ3/LQW9GhugwkV+ay\n8GyG17Dbm6Y2YSn1vl36lf/Nas4Lxf5jaVKXXoPUfANaDlJkK3E+cMsh1xrs8Uef\nMgiRll8Q28jA1RH+vmA+hzHOhuNqM8xHl2c/9Eq7FmFYoP4A1Lo/N9dEHHlHhSkG\nI6kBgBW/MAPvSLLPWr4v0u+/ynH9v+PEo60skvnrQPH0wFPoyJd/zxOMaomleJEv\nyL8CtS8Jo8/gqJ76zITM2JD1Cd+NBrPLk41I/hcfQ7Eewb/lkKe8/tpNm3e3bXJG\ns5W/0Lq2GRjQh9nrDfVs2IuE1c5zeqToyp98"
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=*.redclara.net,O=Cooperaci\\C3\\B3n Latinoamericana de Redes Avanzadas,L=Montevideo,C=UY"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            },
            {
              "use": "encryption",
              "key_info": {
                "key_name": [
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "*.redclara.net"
                  },
                  {
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName",
                    "text": "redclara.net"
                  }
                ],
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo",
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIFJzCCBA+gAwIBAgIQAycc1VlqLQ1YMhUWYD69ajANBgkqhkiG9w0BAQsFADBN\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMScwJQYDVQQDEx5E\naWdpQ2VydCBTSEEyIFNlY3VyZSBTZXJ2ZXIgQ0EwHhcNMTQxMTI4MDAwMDAwWhcN\nMTcxMjA2MTIwMDAwWjB1MQswCQYDVQQGEwJVWTETMBEGA1UEBxMKTW9udGV2aWRl\nbzE4MDYGA1UECgwvQ29vcGVyYWNpw7NuIExhdGlub2FtZXJpY2FuYSBkZSBSZWRl\ncyBBdmFuemFkYXMxFzAVBgNVBAMMDioucmVkY2xhcmEubmV0MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4ciHwzKgzkUxp9PSRy9gV4WfIAmIjugbR8f9\nRJD9GwoMPTA173v4Rzjbnl8h/3e+iDfdzetHRM+gkOXwPCaGFpBQa2EPnxtFaaH6\nl8xtfHlsl8D2lqRkOE2OjvP8GzgpT3ikMBXoNr4TL7RQqzinwYCCJzLMSflwNbtk\n/a04k3l9FyxJ4mqEFP6aUsPJA0YRLVrYOIyppRzcHbRng/pNPE0R+JhNC3Kx2SbJ\nUvKtjQfvMJCn2T2dn5hg5mFnyMl78pgmRjppgxWEWkti+4eZoLg0OwVEFyGEgmEU\namd6JmRZTDs04BtstymJNXdkTsCP7yk92lpAc9C3NZ3FvrR0eQIDAQABo4IB2TCC\nAdUwHwYDVR0jBBgwFoAUD4BhHIIxYdUvKOeNRji0LOHG2eIwHQYDVR0OBBYEFBFj\nG3+tyY7afXZLfXNuYoGnE0nEMCcGA1UdEQQgMB6CDioucmVkY2xhcmEubmV0ggxy\nZWRjbGFyYS5uZXQwDgYDVR0PAQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMB\nBggrBgEFBQcDAjBrBgNVHR8EZDBiMC+gLaArhilodHRwOi8vY3JsMy5kaWdpY2Vy\ndC5jb20vc3NjYS1zaGEyLWczLmNybDAvoC2gK4YpaHR0cDovL2NybDQuZGlnaWNl\ncnQuY29tL3NzY2Etc2hhMi1nMy5jcmwwQgYDVR0gBDswOTA3BglghkgBhv1sAQEw\nKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzB8Bggr\nBgEFBQcBAQRwMG4wJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv\nbTBGBggrBgEFBQcwAoY6aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lD\nZXJ0U0hBMlNlY3VyZVNlcnZlckNBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3\nDQEBCwUAA4IBAQB3WePP9QxLi7OdtCbfR6kqIPDvfVX3aMvJ3/LQW9GhugwkV+ay\n8GyG17Dbm6Y2YSn1vl36lf/Nas4Lxf5jaVKXXoPUfANaDlJkK3E+cMsh1xrs8Uef\nMgiRll8Q28jA1RH+vmA+hzHOhuNqM8xHl2c/9Eq7FmFYoP4A1Lo/N9dEHHlHhSkG\nI6kBgBW/MAPvSLLPWr4v0u+/ynH9v+PEo60skvnrQPH0wFPoyJd/zxOMaomleJEv\nyL8CtS8Jo8/gqJ76zITM2JD1Cd+NBrPLk41I/hcfQ7Eewb/lkKe8/tpNm3e3bXJG\ns5W/0Lq2GRjQh9nrDfVs2IuE1c5zeqToyp98"
                    },
                    "x509_subject_name": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName",
                      "text": "CN=*.redclara.net,O=Cooperaci\\C3\\B3n Latinoamericana de Redes Avanzadas,L=Montevideo,C=UY"
                    },
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ]
              },
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ],
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor",
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/NIM/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/NIM/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/NIM/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/NIM/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService"
            }
          ],
          "assertion_consumer_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "6"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "7"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML2/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "8"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML2/ECP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "9"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML2/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "10"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign",
              "location": "https://wiki2.redclara.net/Shibboleth.sso/SAML2/POST-SimpleSign",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService",
              "index": "11"
            }
          ]
        }
      ]
    }
  ],
  [
    "https://www.bridgemaneducation.com/shibboleth",
    {
      "contact_person": [
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Chambers"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:sean.chambers@bridgemanimages.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Sean"
          },
          "contact_type": "support",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        },
        {
          "sur_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName",
            "text": "Chambers"
          },
          "email_address": [
            {
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress",
              "text": "mailto:sean.chambers@bridgemanimages.com"
            }
          ],
          "given_name": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName",
            "text": "Sean"
          },
          "contact_type": "technical",
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson"
        }
      ],
      "entity_id": "https://www.bridgemaneducation.com/shibboleth",
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor",
      "extensions": {
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en",
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy",
                "text": "http://ukfederation.org.uk/doc/mdrps-20130902"
              }
            ],
            "registration_instant": "2010-09-03T16:48:00Z",
            "registration_authority": "http://ukfederation.org.uk",
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      },
      "organization": {
        "organization_display_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName",
            "text": "The Bridgeman Art Library Limited: Bridgeman Education"
          }
        ],
        "organization_url": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL",
            "text": "http://www.bridgemaneducation.com/"
          }
        ],
        "organization_name": [
          {
            "lang": "en",
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName",
            "text": "The Bridgeman Art Library Limited"
          }
        ],
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      },
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.bridgemaneducation.com/Shibboleth.sso/SLO/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
              "location": "https://www.bridgemaneducation.com/Shibboleth.sso/SLO/Redirect",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
              "location": "https://www.bridgemaneducation.com/Shibboleth.sso/SLO/POST",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            },
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact",
              "location": "https://www.bridgemaneducation.com/Shibboleth.sso/SLO/Artifact",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService"
            }
          ],
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol",
          "artifact_resolution_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP",
              "location": "https://www.bridgemaneducation.com/Shibboleth.sso/Artifact/SOAP",
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService",
              "index": "1"
            }
          ],
          "key_descriptor": [
            {
              "use": "signing",
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate",
                      "text": "MIIDZDCCAkwCCQDwazyRKFeJxDANBgkqhkiG9w0BAQUFADB0MQswCQYDVQQGEwJH\n\t\t\t\t\t\tQjEPMA0GA1UECBMGTG9uZG9uMQ8wDQYDVQQHEwZMb25kb24xHjAcBgNVBAoTFUJy\n\t\t\t