BEGIN TRANSACTION;
CREATE TABLE calflora (	
-- Name		Type	        -- Example 
---------------------------------------
calrecnum	INTEGER PRIMARY KEY,  -- 345
calname		varchar(255),	-- Abronia villosa S. Watson var. aurita (Abrams) Jepson
taxon		varchar(128),	-- Abronia villosa var. aurita
genus		varchar(64),	-- Abronia
species		varchar(64),	-- villosa
author1		varchar(128),	-- S. Watson
rank		varchar(4),		-- var. (or ssp.)
ssp_var		varchar(64),	-- aurita
author2		varchar(128),	-- (Abrams) Jepson
family		varchar(64),	-- Nyctaginaceae
category	varchar(32),	-- dicot
parent_child	varchar(16),-- child (or parent)
parent_rec	integer,		-- 21 (calrec -- of parent if "child")
parent_name	varchar(128),	-- Abronia villosa
treatment	varchar(128),	-- optional in Jeps.
jep_incl	varchar(128),   -- Abies concolor
cnps_note	varchar(128),	-- CNPS spelling:
cnps_name	varchar(128),	-- Achnatherum diegoense (Sw.) Barkworth
munz_note	varchar(64),	-- Munz:
munz_name	varchar(255),	-- Stipa diegoensis Swallen
plants_spel	varchar(128),	-- Erechtites hieraciifolia var. hieraciifolia
cf_cname	varchar(255),   -- pink verbena (CalFlora common name)
plants_cname	varchar(255),	-- pink sand verbena
usfs_cname	varchar(255),	-- Ginger's verbena
lifeform	varchar(64),	-- Annual, Perennial herb (aquatic) 
range		varchar(255),	-- CA, OR
regionlist	varchar(255),	-- DNT HUM MEN SON -- list of observed counties, from occ. 
							-- Altered 5/1/01 max 232 char for 58 counties (really 231) TM.
extinctlist	varchar(255),	-- ALA
plant_community	varchar(255),	-- m16m17m15 Medws
lower_elev_ft	integer,	-- 0
upper_elev_ft	integer, 	-- 9500
rarity		varchar(16),	-- 2
ca_status	varchar(64),	-- CE (as of 1997)
fed_status	varchar(64),	-- SOC (as of 1997)
habitats	varchar(64),	-- riparian
substrate	varchar(64),	-- serpentine
soil		varchar(64),	-- alkaline
moisture	varchar(64),	-- moist
reg_source	varchar(64),	-- Lum/Munz68,Dennis/CNPS94
regioncode	varchar(255),	-- 111111111111FFFFFFFFFFFFF [...]
extinctreg	varchar(255),	-- FFFFF3FF4FFFFFFFFFFFFFFFF [...]
cnps_matcher	varchar(128),	-- ABRONIA MARITIMA
rarerec		integer,		-- 5
cdfa_weed_status varchar(16),	-- CDFA Weed Status (A, B, C, D or Q) http://pi.cdfa.ca.gov/weedinfo/weedratings.html
fed_nox_weed	varchar(32),	-- Y if Federal Noxious weed status, matching notes in parenthesis
plants_code	varchar(16),	-- ABCOL
namesoup	varchar(255),	-- upper case: taxon jep_incl cnps_name munz_name 
							-- cf_cname plants_cname usfs_cname family
tamu_code	varchar(16),	-- k2305800 
wetland		varchar(32),   	-- FACW
numregions	integer, 		-- 12 (number of non-Fs in regioncode)
pic		boolean, 			-- is there a picture in Brousseau collection?
caleppc_code	varchar(32),-- CalEPPC Noxious weed List Status (max length 25?)
occ_count	integer,  		-- number of occ records
native		boolean,  		-- true or false
lelev_src_units varchar(16),-- Jepson (m)
uelev_src_units	varchar(16),-- Jepson (m)
itis_tsn	integer, 		-- ITIS Taxonomic Serial Number
u_taxon		varchar(128),  	-- Upper Case taxon name
u_allcnames	varchar(255),	-- Upper Case all common names
allcnames       varchar(255),	-- all common names  (added 2/24/99 G.O.)
kwid            char(19)        --  1111 2222 3333 0002  kwid for representative photo (added 8/9/00 TM)
);

INSERT INTO calflora VALUES(1,'Salix prolixa Andersson','Salix prolixa','Salix','prolixa','Andersson',NULL,NULL,NULL,'Salicaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Salix mackenziana (Hook.) Barratt ex Anderss.',NULL,NULL,NULL,NULL,'Tree, Shrub','NAm/WW','ALP AMA BUT CAL ELD FRE INY LAS MAD MNO MOD MPA NEV PLA PLU SHA SIE SIS TEH TUL TUO YUB',NULL,'m15',0,7000,0,NULL,NULL,NULL,NULL,NULL,'moist wet','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','SAPR3',"SALIX PROLIXA MACKENZIE\'S WILLOW MACKENZIE\'S WILLOW SALICACEAE SALIX MACKENZIANA (HOOK.) BARRATT EX ANDERSS.",NULL,'OBL',31,'f',NULL,42,'t','Munz (ft.)','Munz (ft.)',22572,'SALIX PROLIXA',"MACKENZIE\'S WILLOW, MACKENZIE\'S WILLOW","MacKenzie\'s willow, Mackenzie\'s willow",NULL);
INSERT INTO calflora VALUES(2,'Lycium verrucosum Eastw.','Lycium verrucosum','Lycium','verrucosum','Eastw.',NULL,NULL,NULL,'Solanaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','extct?','VEN',NULL,'m05',NULL,NULL,'?',NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'LYCIUM VERRUCOSUM',1160,'not listed','not listed','LYVE','LYCIUM VERRUCOSUM SAN NICHOLAS DESERT-THORN SAN NICOLAS ISLAND DESERT-THORN SAN NICOLAS THORN SOLANACEAE',NULL,'NI',1,'f',NULL,2,'t',NULL,NULL,30550,'LYCIUM VERRUCOSUM','SAN NICHOLAS DESERT-THORN, SAN NICOLAS ISLAND DESERT-THORN, SAN NICOLAS THORN','San Nicholas desert-thorn, San Nicolas Island desert-thorn, San nicolas thorn',NULL);
INSERT INTO calflora VALUES(3,'Ophioglossum californicum Prantl','Ophioglossum californicum','Ophioglossum','californicum','Prantl',NULL,NULL,NULL,'Ophioglossaceae','pteridophyte',NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Includes Munz\'s",'Ophioglossum lusitanicum L. ssp. californicum (Prantl) R.T. Clausen',NULL,NULL,NULL,NULL,'Fern (rhizomatous)','CA+, BA, CA','AMA BUT MER MNT MPA ORA SBD SDG STA TUO',NULL,'m23m25m80 VnPls',NULL,NULL,0,NULL,NULL,'vernal-pools edges',NULL,NULL,'vernally-flooded','Dennis/CNPS94, Lum/Munz68',NULL,NULL,NULL,1311,'not listed','not listed','OPCA8',"OPHIOGLOSSUM CALIFORNICUM CALIFORNIA ADDER\'S-TONGUE CALIFORNIA ADDERSTONGUE OPHIOGLOSSACEAE OPHIOGLOSSUM LUSITANICUM L. SSP. CALIFORNICUM (PRANTL) R.T. CLAUSEN",NULL,'FAC*',17,'f',NULL,24,'t',NULL,NULL,504031,'OPHIOGLOSSUM CALIFORNICUM',"CALIFORNIA ADDER\'S-TONGUE, CALIFORNIA ADDERSTONGUE","California adder\'s-tongue, California adderstongue",NULL);
INSERT INTO calflora VALUES(4,'Stephanomeria spinosa (Nutt.) Tomb','Stephanomeria spinosa','Stephanomeria','spinosa','(Nutt.) Tomb',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Lygodesmia spinosa Nutt.',NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALP INY LAS LAX MNO MOD PLU SBD SIE SIS TUL',NULL,'m06m28m14',5000,9400,0,NULL,NULL,NULL,NULL,'sandy rocky','dry','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','STSP6','STEPHANOMERIA SPINOSA THORN SKELETONWEED THORNY SKELETON-PLANT ASTERACEAE LYGODESMIA SPINOSA NUTT.',NULL,'NI',13,'t',NULL,70,'t','Munz (ft.)','Munz (ft.)',38454,'STEPHANOMERIA SPINOSA','THORN SKELETONWEED, THORNY SKELETON-PLANT','thorn skeletonweed, thorny skeleton-plant',NULL);
INSERT INTO calflora VALUES(5,'Cynosurus cristatus L.','Cynosurus cristatus','Cynosurus','cristatus','L.',NULL,NULL,NULL,'Poaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','HUM LAX MEN MRN NAP SFO SON',NULL,NULL,0,984,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CYCR','CYNOSURUS CRISTATUS CRESTED DOGTAIL CRESTED DOGSTAIL GRASS CRESTED DOGTAIL-GRASS POACEAE',NULL,'FACW*',6,'f',NULL,17,'f','JM (m)','JM (m)',41624,'CYNOSURUS CRISTATUS','CRESTED DOGTAIL, CRESTED DOGSTAIL GRASS, CRESTED DOGTAIL-GRASS','Crested dogtail, crested dogstail grass, crested dogtail-grass',NULL);
INSERT INTO calflora VALUES(6,'Calycanthus occidentalis Hook. & Arn.','Calycanthus occidentalis','Calycanthus','occidentalis','Hook. & Arn.',NULL,NULL,NULL,'Calycanthaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA Endemic','ALA AMA BUT CAL COL FRE GLE HUM KRN LAK MAD MEN MER MPA NAP NEV PLA SAC SCL SDG SHA SJQ SOL SON STA SUT TEH TRI TUL TUO YOL YUB',NULL,'m22m14',0,4000,0,NULL,NULL,'streambanks',NULL,NULL,'moist','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CAOC5','CALYCANTHUS OCCIDENTALIS SPICEBUSH SPICEBUSH SWEET-SHRUB CALYCANTHACEAE',NULL,'FAC',34,'t',NULL,165,'t','Munz (ft.)','Munz (ft.)',18144,'CALYCANTHUS OCCIDENTALIS','SPICEBUSH, SPICEBUSH, SWEET-SHRUB','Spicebush, spicebush, sweet-shrub','5208 1611 1726 0052');
INSERT INTO calflora VALUES(7,'Eriogonum gracile Benth. var. incultum Rev.','Eriogonum gracile var. incultum','Eriogonum','gracile','Benth.','var.','incultum','Rev.','Polygonaceae','dicot','child',3256,'Eriogonum gracile',NULL,NULL,NULL,NULL,"Part of Munz\'s",'Eriogonum gracile Benth.',NULL,NULL,NULL,NULL,'Annual herb',NULL,'RIV SDG',NULL,'m05m23m22m21',3937,6234,0,NULL,NULL,NULL,NULL,NULL,'dry','Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','ERGRI','ERIOGONUM GRACILE VAR. INCULTUM SLENDER BUCKWHEAT SLENDER WOOLLY BUCKWHEAT POLYGONACEAE ERIOGONUM GRACILE BENTH.',NULL,'NI',2,'f',NULL,6,'t','JM (m)','JM (m)',195477,'ERIOGONUM GRACILE VAR. INCULTUM','SLENDER BUCKWHEAT, SLENDER WOOLLY BUCKWHEAT','slender buckwheat, slender woolly buckwheat',NULL);
INSERT INTO calflora VALUES(8,'Cynanchum utahense (Engelm.) Woodson','Cynanchum utahense','Cynanchum','utahense','(Engelm.) Woodson',NULL,NULL,NULL,'Asclepiadaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','IMP RIV SBD SDG',NULL,'m08',NULL,NULL,1,NULL,NULL,NULL,NULL,'sandy gravelly',NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'CYNANCHUM UTAHENSE',560,'not listed','not listed','CYUT','CYNANCHUM UTAHENSE DEBOLTIA UTAH SWALLOW-WORT UTAH VINE MILKWEED VINE MILKWEED ASCLEPIADACEAE',NULL,'NI',10,'f',NULL,13,'t',NULL,NULL,501904,'CYNANCHUM UTAHENSE','DEBOLTIA, UTAH SWALLOW-WORT, UTAH VINE MILKWEED, VINE MILKWEED','Deboltia, Utah swallow-wort, Utah vine milkweed, Vine milkweed',NULL);
INSERT INTO calflora VALUES(9,'Nama dichotomum (Ruiz Lopez & Pavon) Choisy var. dichotomum','Nama dichotomum var. dichotomum','Nama','dichotomum','(Ruiz Lopez & Pavon) Choisy','var.','dichotomum',NULL,'Hydrophyllaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','SBD',NULL,'m28',NULL,NULL,3,NULL,NULL,NULL,'granitic carbonate',NULL,NULL,'Dennis/CNPS94',NULL,NULL,'NAMA DICHOTOMUM VAR. DICHOTOMUM',1281,'not listed','not listed',NULL,'NAMA DICHOTOMUM VAR. DICHOTOMUM FORKED PURPLE MAT HYDROPHYLLACEAE',NULL,'NI',2,'f',NULL,3,'t',NULL,NULL,0,'NAMA DICHOTOMUM VAR. DICHOTOMUM','FORKED PURPLE MAT','forked purple mat',NULL);
INSERT INTO calflora VALUES(10,'Lupinus breweri A. Gray','Lupinus breweri','Lupinus','breweri','A. Gray',NULL,NULL,NULL,'Fabaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SHA SIE SIS SJQ SLO SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m14m15m16m17m26',3281,13124,0,NULL,NULL,'slopes',NULL,NULL,'dry','Lum/Walker/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LUBR3',"LUPINUS BREWERI BREWER\'S LUPINE FABACEAE",NULL,'NI',26,'t',NULL,388,'t','JM (m)','JM (m)',25976,'LUPINUS BREWERI',"BREWER\'S LUPINE","Brewer\'s lupine",'8266 3261 0960 0021');
INSERT INTO calflora VALUES(11,'Acacia baileyana F. Muell.','Acacia baileyana','Acacia','baileyana','F. Muell.',NULL,NULL,NULL,'Fabaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Tree, Shrub','Introd.','CCA KRN LAX MNT MRN NAP SBA SBT SCL SCR SDG SLO SON VEN',NULL,NULL,164,984,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','ACBA','ACACIA BAILEYANA BAILEY ACACIA COOTAMUNDRA WATTLE FABACEAE',NULL,'NI',16,'t',NULL,18,'f','JM (m)','JM (m)',26419,'ACACIA BAILEYANA','BAILEY ACACIA, COOTAMUNDRA WATTLE','Bailey acacia, Cootamundra wattle',NULL);
INSERT INTO calflora VALUES(12,'Erodium brachycarpum (Godron) Thell.','Erodium brachycarpum','Erodium','brachycarpum','(Godron) Thell.',NULL,NULL,NULL,'Geraniaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Erodium obtusiplicatum (Maire, Weiller & Wilczek) J.T. Howell',NULL,NULL,NULL,NULL,'Annual herb','Introd.','ALA AMA BUT CCA COL FRE GLE HUM KNG KRN LAK LAX MAD MEN MER MNT MRN NAP NEV ORA PLA RIV SAC SBA SBD SBT SCL SCR SDG SFO SHA SJQ SLO SMT SOL SON STA SUT TEH TRI TUO VEN YOL',NULL,'m25m22',0,3281,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ERBR14',"ERODIUM BRACHYCARPUM FILAREE FOOTHILL FILAREE WHITE-STEMMED FILAREE SHORT-FRUITED FILAREE SHORTFRUIT STORK\'S BILL GERANIACEAE ERODIUM OBTUSIPLICATUM (MAIRE WEILLER & WILCZEK) J.T. HOWELL",NULL,'NI',43,'f',NULL,142,'f','JM (m)','JM (m)',502424,'ERODIUM BRACHYCARPUM',"FILAREE, FOOTHILL FILAREE, WHITE-STEMMED FILAREE, SHORT-FRUITED FILAREE, SHORTFRUIT STORK\'S BILL","Filaree, Foothill filaree, White-stemmed filaree, short-fruited filaree, shortfruit stork\'s bill",NULL);
INSERT INTO calflora VALUES(13,'Plagiobothrys diffusus (Greene) Jtn.','Plagiobothrys diffusus','Plagiobothrys','diffusus','(Greene) Jtn.',NULL,NULL,NULL,'Boraginaceae','dicot','stepchild',6594,NULL,'CNPS only','Plagiobothrys reticulatus var. rossianorum',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','SCR SFO',NULL,'m24m25',NULL,NULL,3,'SE (Sep 1979)','\ ',NULL,NULL,NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'PLAGIOBOTHRYS DIFFUSUS',1434,'not listed','not listed','PLDI','PLAGIOBOTHRYS DIFFUSUS SAN FRANCISCO POPCORN-FLOWER BORAGINACEAE PLAGIOBOTHRYS RETICULATUS VAR. ROSSIANORUM',NULL,'NI',2,'f',NULL,10,'t',NULL,NULL,31981,'PLAGIOBOTHRYS DIFFUSUS','SAN FRANCISCO POPCORN-FLOWER','San Francisco popcorn-flower',NULL);
INSERT INTO calflora VALUES(14,'Leymus triticoides (Buckley) Pilger','Leymus triticoides','Leymus','triticoides','(Buckley) Pilger',NULL,NULL,NULL,'Poaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Elymus triticoides Buckl.',NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SFO SHA SIE SIS SJQ SLO SMT SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m14m15m16m17m22m23m25m50',0,7500,0,NULL,NULL,NULL,NULL,'alkaline','moist','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LETR5','LEYMUS TRITICOIDES VALLEY WILD-RYE ALKALI RYE BEARDLESS WILDRYE CREEPING WILD-RYE POACEAE ELYMUS TRITICOIDES BUCKL.',NULL,'FAC+',89,'f',NULL,440,'t','Munz (ft.)','Munz (ft.)',503443,'LEYMUS TRITICOIDES','VALLEY WILD-RYE, ALKALI RYE, BEARDLESS WILDRYE, CREEPING WILD-RYE','Valley Wild-rye, alkali rye, beardless wildrye, creeping wild-rye',NULL);
INSERT INTO calflora VALUES(15,'Woodsia oregana D. Eaton','Woodsia oregana','Woodsia','oregana','D. Eaton',NULL,NULL,NULL,'Dryopteridaceae','pteridophyte',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Fern','NAm/WW','ALP AMA BUT CAL ELD FRE HUM INY LAS MAD MNO MOD MPA NEV PLA PLU RIV SBD SHA SIE SIS TUL TUO YUB',NULL,'m28m14m15m16m17',0,5000,0,NULL,NULL,NULL,NULL,'rocky','dry','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','WOOR','WOODSIA OREGANA CLIFF FERN OREGON WOODSIA OREGON CLIFF FERN DRYOPTERIDACEAE',NULL,'NI',27,'t',NULL,78,'t','Munz (ft.)','Munz (ft.)',17745,'WOODSIA OREGANA','CLIFF FERN, OREGON WOODSIA, OREGON CLIFF FERN','Cliff fern, Oregon Woodsia, Oregon cliff fern',NULL);
INSERT INTO calflora VALUES(16,'Amaranthus caudatus L.','Amaranthus caudatus','Amaranthus','caudatus','L.',NULL,NULL,NULL,'Amaranthaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','Introd.','SBA',NULL,'m41',0,656,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','AMCA3','AMARANTHUS CAUDATUS QUILETE AMARANTHACEAE',NULL,'NI',NULL,'f',NULL,1,'f','JM (m)','JM (m)',20726,'AMARANTHUS CAUDATUS','QUILETE','quilete',NULL);
INSERT INTO calflora VALUES(17,'Lathyrus jepsonii E. Greene','Lathyrus jepsonii','Lathyrus','jepsonii','E. Greene',NULL,NULL,NULL,'Fabaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM KNG KRN LAK LAS MAD MEN MER MNT MOD MPA MRN NAP NEV PLA PLU SAC SBA SBT SCL SCR SHA SIE SIS SJQ SLO SMT SOL SON STA SUT TEH TRI TUL TUO YOL YUB',NULL,'m03m14m22m23m25m50',0,5000,0,NULL,NULL,'streambanks freshwater-marsh slopes',NULL,'sandy',NULL,'Lum/monog., Walker, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LAJE',"LATHYRUS JEPSONII DELTA TULE PEA JEPSON\'S PEA TULE PEA FABACEAE",NULL,'OBL',40,'t',NULL,335,'t','Munz (ft.)','Munz (ft.)',25848,'LATHYRUS JEPSONII',"DELTA TULE PEA, JEPSON\'S PEA, TULE PEA","Delta tule pea, Jepson\'s Pea, tule pea",NULL);
INSERT INTO calflora VALUES(18,'Hesperevax acaulis (Kellogg) E. Greene var. acaulis','Hesperevax acaulis var. acaulis','Hesperevax','acaulis','(Kellogg) E. Greene','var.','acaulis',NULL,'Asteraceae','dicot','child',4106,'Hesperevax acaulis',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','AMA BUT CAL COL ELD FRE KRN MAD MPA NEV PLA SAC SCL SHA TUL TUO YUB',NULL,NULL,328,3281,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93 (incomplete transcription)',NULL,NULL,NULL,NULL,'not listed','not listed','HEACA','HESPEREVAX ACAULIS VAR. ACAULIS DWARF EVAX STEMLESS DWARF-CUDWEED ASTERACEAE',NULL,'NI',14,'t',NULL,28,'t','JM (m)','JM (m)',531164,'HESPEREVAX ACAULIS VAR. ACAULIS','DWARF EVAX, STEMLESS DWARF-CUDWEED','dwarf evax, stemless dwarf-cudweed',NULL);
INSERT INTO calflora VALUES(19,'Calystegia macrostegia (E. Greene) Brummitt ssp. intermedia (Abrams) Brummitt','Calystegia macrostegia ssp. intermedia','Calystegia','macrostegia','(E. Greene) Brummitt','ssp.','intermedia','(Abrams) Brummitt','Convolvulaceae','dicot','child',1353,'Calystegia macrostegia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb, Vine',NULL,'LAX ORA RIV SBA SBD SDG VEN',NULL,NULL,0,656,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93 (incomplete transcription)',NULL,NULL,NULL,NULL,'not listed','not listed','CAMAI','CALYSTEGIA MACROSTEGIA SSP. INTERMEDIA ISLAND FALSE BINDWEED SOUTH COAST MORNING-GLORY CONVOLVULACEAE',NULL,'NI',9,'t',NULL,35,'t','JM (m)','JM (m)',30676,'CALYSTEGIA MACROSTEGIA SSP. INTERMEDIA','ISLAND FALSE BINDWEED, SOUTH COAST MORNING-GLORY','island false bindweed, south coast morning-glory','5208 1611 1726 0082');
INSERT INTO calflora VALUES(20,'Lupinus excubitus M.E. Jones var. excubitus','Lupinus excubitus var. excubitus','Lupinus','excubitus','M.E. Jones','var.','excubitus',NULL,'Fabaceae','dicot','child',5139,'Lupinus excubitus',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub',NULL,'INY KRN LAX RIV SBA SBD TUL',NULL,NULL,0,8202,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LUEXE','LUPINUS EXCUBITUS VAR. EXCUBITUS GRAPE LUPINE GRAPE SODA LUPINE FABACEAE',NULL,'NI',10,'f',NULL,17,'t','JM (m)','JM (m)',528980,'LUPINUS EXCUBITUS VAR. EXCUBITUS','GRAPE LUPINE, GRAPE SODA LUPINE','grape lupine, grape soda lupine',NULL);
INSERT INTO calflora VALUES(21,'Fragaria crinita Rydb.','Fragaria crinita','Fragaria','crinita','Rydb.',NULL,NULL,NULL,'Rosaceae','dicot','stepchild',3609,NULL,'optional in JM','Fragaria vesca',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','DNT',NULL,'m19',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','FRCR','FRAGARIA CRINITA PACIFIC STRAWBERRY BEACH STRAWBERRY ROSACEAE FRAGARIA VESCA',NULL,'NI',1,'f',NULL,1,'t',NULL,NULL,502646,'FRAGARIA CRINITA','PACIFIC STRAWBERRY, BEACH STRAWBERRY','Pacific strawberry, beach strawberry',NULL);
INSERT INTO calflora VALUES(22,'Eriogonum deserticola S. Watson','Eriogonum deserticola','Eriogonum','deserticola','S. Watson',NULL,NULL,NULL,'Polygonaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','wNAm','IMP RIV SDG',NULL,'m08',-214,328,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ERDE9','ERIOGONUM DESERTICOLA COLORADO DESERT BUCKWHEAT POLYGONACEAE',NULL,'NI',2,'f',NULL,29,'t','JM (m)','JM (m)',21113,'ERIOGONUM DESERTICOLA','COLORADO DESERT BUCKWHEAT','Colorado Desert buckwheat',NULL);
INSERT INTO calflora VALUES(23,'Navarretia hamata E. Greene ssp. parviloba Day','Navarretia hamata ssp. parviloba','Navarretia','hamata','E. Greene','ssp.','parviloba','Day','Polemoniaceae','dicot','child',5777,'Navarretia hamata',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','ALA CCA MNT MRN NAP SBA SBD SBT SCL SCR SLO SON VEN',NULL,NULL,0,3280,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','NAHAP','NAVARRETIA HAMATA SSP. PARVILOBA HOOKED NAVARRETIA SMALL-LOBE NAVARRETIA POLEMONIACEAE',NULL,'NI',NULL,'f',NULL,51,'t','JM (m)','JM (m)',524972,'NAVARRETIA HAMATA SSP. PARVILOBA','HOOKED NAVARRETIA, SMALL-LOBE NAVARRETIA','hooked navarretia, small-lobe navarretia',NULL);
INSERT INTO calflora VALUES(24,'Nymphaea odorata Aiton','Nymphaea odorata','Nymphaea','odorata','Aiton',NULL,NULL,NULL,'Nymphaeaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','ALP AMA BUT CAL ELD FRE INY KRN LAS MAD MEN MNO MPA NEV PLA PLU RIV SBD SHA SIE SMT TUL TUO YUB',NULL,NULL,0,8858,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93 (incomplete transcription)',NULL,NULL,NULL,NULL,'not listed','not listed','NYOD','NYMPHAEA ODORATA AMERICAN WHITE WATERLILY WATER-LILY NYMPHAEACEAE',NULL,'OBL',NULL,'t',NULL,31,'f','JM (m)','JM (m)',18384,'NYMPHAEA ODORATA','AMERICAN WHITE WATERLILY, WATER-LILY','American white waterlily, water-lily','0175 3301 2362 0065');
INSERT INTO calflora VALUES(25,'Caulanthus amplexicaulis S. Watson var. barbarae (J. Howell) Munz','Caulanthus amplexicaulis var. barbarae','Caulanthus','amplexicaulis','S. Watson','var.','barbarae','(J. Howell) Munz','Brassicaceae','dicot','child',1740,'Caulanthus amplexicaulis',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','SBA',NULL,'m22m11',NULL,NULL,3,NULL,NULL,NULL,'serpentine',NULL,NULL,'Dennis/CNPS94',NULL,NULL,'CAULANTHUS AMPLEXICAULIS VAR. BARBARAE',391,'not listed','not listed','CAAMB','CAULANTHUS AMPLEXICAULIS VAR. BARBARAE SANTA BARBARA JEWELFLOWER CLASPINGLEAF WILD CABBAGE BRASSICACEAE',NULL,'NI',2,'f',NULL,10,'t',NULL,NULL,527220,'CAULANTHUS AMPLEXICAULIS VAR. BARBARAE','SANTA BARBARA JEWELFLOWER, CLASPINGLEAF WILD CABBAGE','Santa Barbara jewelflower, claspingleaf wild cabbage',NULL);
INSERT INTO calflora VALUES(26,'Chamaesyce albomarginata (Torrey & A. Gray) Small','Chamaesyce albomarginata','Chamaesyce','albomarginata','(Torrey & A. Gray) Small',NULL,NULL,NULL,'Euphorbiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Euphorbia albomarginata Torr. & Gray',NULL,NULL,NULL,NULL,'Perennial herb','wNAm','IMP INY KRN LAX ORA RIV SBA SBD SDG SIS VEN',NULL,'m05m23m08m28m29',0,7546,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CHAL11','CHAMAESYCE ALBOMARGINATA RATTLESNAKE WEED WHITEMARGIN SANDMAT EUPHORBIACEAE EUPHORBIA ALBOMARGINATA TORR. & GRAY',NULL,'NI',21,'t',NULL,131,'t','JM (m)','JM (m)',501400,'CHAMAESYCE ALBOMARGINATA','RATTLESNAKE WEED, WHITEMARGIN SANDMAT','rattlesnake weed, whitemargin sandmat','0000 0000 0701 0087');
INSERT INTO calflora VALUES(27,'Allium parvum Kellogg','Allium parvum','Allium','parvum','Kellogg',NULL,NULL,NULL,'Liliaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALP FRE LAS MEN MNO MOD NEV PLA PLU SHA SIE SIS TUL',NULL,'m06m14m15',4500,8000,0,NULL,NULL,NULL,NULL,'gravelly rocky',NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ALPA3','ALLIUM PARVUM DWARF ONION SMALL ONION LILIACEAE',NULL,'NI',11,'t',NULL,45,'t','Munz (ft.)','Munz (ft.)',42690,'ALLIUM PARVUM','DWARF ONION, SMALL ONION','Dwarf Onion, small onion',NULL);
INSERT INTO calflora VALUES(28,'Cryptantha mohavensis (E. Greene) E. Greene','Cryptantha mohavensis','Cryptantha','mohavensis','(E. Greene) E. Greene',NULL,NULL,NULL,'Boraginaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','INY KRN TUL',NULL,'m29m28',1969,9186,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CRMO7','CRYPTANTHA MOHAVENSIS MOJAVE CRYPTANTHA BORAGINACEAE',NULL,'NI',2,'f',NULL,22,'t','JM (m)','JM (m)',31843,'CRYPTANTHA MOHAVENSIS','MOJAVE CRYPTANTHA','Mojave cryptantha',NULL);
INSERT INTO calflora VALUES(29,'Myriophyllum sibiricum V. Komarov','Myriophyllum sibiricum','Myriophyllum','sibiricum','V. Komarov',NULL,NULL,NULL,'Haloragaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Myriophyllum spicatum L. ssp. exalbescens (Fern.) Hulten',NULL,NULL,NULL,NULL,'Perennial herb (aquatic)','NAm/WW','ALA AMA BUT CAL CCA COL DNT ELD FRE GLE HUM KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SFO SHA SIE SIS SJQ SLO SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m14m15m16m17m22m23m25m50',0,8000,0,NULL,NULL,NULL,NULL,NULL,'saturated','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','MYSI','MYRIOPHYLLUM SIBIRICUM SIBERIAN WATER-MILFOIL SIBERIAN MILFOIL SHORTSPIKE WATERMILFOIL HALORAGACEAE MYRIOPHYLLUM SPICATUM L. SSP. EXALBESCENS (FERN.) HULTEN',NULL,'NI',73,'t',NULL,98,'t','Munz (ft.)','Munz (ft.)',503906,'MYRIOPHYLLUM SIBIRICUM','SIBERIAN WATER-MILFOIL, SIBERIAN MILFOIL, SHORTSPIKE WATERMILFOIL','Siberian Water-Milfoil, Siberian milfoil, shortspike watermilfoil','0175 3301 2362 0047');
INSERT INTO calflora VALUES(30,'Salvia pachyphylla Munz','Salvia pachyphylla','Salvia','pachyphylla','Munz',NULL,NULL,NULL,'Lamiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA+','INY KRN RIV SBD SDG TUL',NULL,'m28m14',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','SAPA5','SALVIA PACHYPHYLLA ROSE SAGE BLUE SAGE THICK-LEAVED SAGE LAMIACEAE',NULL,'NI',5,'f',NULL,62,'t',NULL,NULL,32730,'SALVIA PACHYPHYLLA','ROSE SAGE, BLUE SAGE, THICK-LEAVED SAGE','Rose Sage, blue sage, thick-leaved sage',NULL);
INSERT INTO calflora VALUES(31,'Cistus ladanifer L.','Cistus ladanifer','Cistus','ladanifer','L.',NULL,NULL,NULL,'Cistaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Cistus ladaniferus',NULL,NULL,NULL,'Shrub (stem succulent)','Introd.','LAX SBA SBD SLO',NULL,NULL,0,984,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','CILA6','CISTUS LADANIFER GUM ROCKROSE RESINOUS ROCKROSE CISTACEAE',NULL,NULL,5,'f','NMInfo',6,'f','JM (m)','JM (m)',501570,'CISTUS LADANIFER','GUM ROCKROSE, RESINOUS ROCKROSE','gum rockrose, resinous rockrose',NULL);
INSERT INTO calflora VALUES(32,'Galium angustifolium Nutt. ssp. gracillimum Dempster & Stebb.','Galium angustifolium ssp. gracillimum','Galium','angustifolium','Nutt.','ssp.','gracillimum','Dempster & Stebb.','Rubiaceae','dicot','child',3660,'Galium angustifolium',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','RIV SBD',NULL,'m08m29',426,5085,1,NULL,NULL,NULL,NULL,'rocky',NULL,'Dennis/CNPS94, Calflora/JM93',NULL,NULL,'GALIUM ANGUSTIFOLIUM SSP. GRACILLIMUM',837,'not listed','not listed','GAANG3','GALIUM ANGUSTIFOLIUM SSP. GRACILLIMUM NARROW-LEAVED BEDSTRAW SLENDER BEDSTRAW RUBIACEAE',NULL,'NI',6,'f',NULL,18,'t','JM (m)','JM (m)',34820,'GALIUM ANGUSTIFOLIUM SSP. GRACILLIMUM','NARROW-LEAVED BEDSTRAW, SLENDER BEDSTRAW','Narrow-leaved Bedstraw, slender bedstraw',NULL);
INSERT INTO calflora VALUES(33,'Verbena litoralis Kunth','Verbena litoralis','Verbena','litoralis','Kunth',NULL,NULL,NULL,'Verbenaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Includes Munz\'s",'Verbena brasiliensis Vell.',NULL,NULL,NULL,NULL,'Perennial, Biennial herb','Introd.','AMA BUT ELD GLE NEV SAC SCR SJQ SLO SOL SON STA SUT YUB',NULL,'m30',0,656,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','VELI','VERBENA LITORALIS SEASHORE VERVAIN SHORE VERVAIN VERBENACEAE VERBENA BRASILIENSIS VELL.',NULL,'NI',11,'t','NMInfo',32,'f','JM (m)','JM (m)',32130,'VERBENA LITORALIS','SEASHORE VERVAIN, SHORE VERVAIN','seashore vervain, shore vervain',NULL);
INSERT INTO calflora VALUES(34,'Najas guadalupensis (Sprengel) Magnus','Najas guadalupensis','Najas','guadalupensis','(Sprengel) Magnus',NULL,NULL,NULL,'Hydrocharitaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb',NULL,'ALA BUT CCA COL FRE GLE HUM IMP INY KNG KRN LAK LAX MAD MEN MER MNT MPA MRN NAP NEV ORA PLU RIV SAC SBA SBD SBT SCL SCR SDG SFO SJQ SLO SOL SON STA SUT TEH TRI TUL VEN YOL YUB',NULL,NULL,0,3937,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','NAGU','NAJAS GUADALUPENSIS GUADALUPE WATER NYMPH SOUTHERN WATERNYMPH HYDROCHARITACEAE',NULL,'OBL',62,'f',NULL,108,'t','JM (m)','JM (m)',38998,'NAJAS GUADALUPENSIS','GUADALUPE WATER NYMPH, SOUTHERN WATERNYMPH','guadalupe water nymph, southern waternymph',NULL);
INSERT INTO calflora VALUES(35,'Thymophylla pentachaeta (DC.) Small var. belenidium (DC.) Strother','Thymophylla pentachaeta var. belenidium','Thymophylla','pentachaeta','(DC.) Small','var.','belenidium','(DC.) Strother','Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Dyssodia thurberi (Gray) B.L. Robins.',NULL,NULL,NULL,NULL,'Perennial herb','wNAm','INY RIV SBD SDG',NULL,'m08m29',2953,5906,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','THPEB','THYMOPHYLLA PENTACHAETA VAR. BELENIDIUM FIVE-NEEDLED THYMOPHYLLA FIVENEEDLE PRICKLYLEAF ASTERACEAE DYSSODIA THURBERI (GRAY) B.L. ROBINS.',NULL,'NI',4,'f',NULL,25,'t','JM (m)','JM (m)',530674,'THYMOPHYLLA PENTACHAETA VAR. BELENIDIUM','FIVE-NEEDLED THYMOPHYLLA, FIVENEEDLE PRICKLYLEAF','five-needled thymophylla, fiveneedle pricklyleaf',NULL);
INSERT INTO calflora VALUES(36,'Petrorhagia dubia (Raf.) G. Lopez & Romo','Petrorhagia dubia','Petrorhagia','dubia','(Raf.) G. Lopez & Romo',NULL,NULL,NULL,'Caryophyllaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Kohlrauschia velutina (Guss.) Reichenb.',NULL,NULL,NULL,NULL,'Annual herb','Introd.','BUT MEN MRN NEV PLA PLU SAC SDG SHA SOL SUT TEH TRI YOL YUB',NULL,'m30',0,5906,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','PEDU2','PETRORHAGIA DUBIA WILDING PINK WINDMILL PINK HAIRYPINK PINK GRASS CARYOPHYLLACEAE KOHLRAUSCHIA VELUTINA (GUSS.) REICHENB.',NULL,'NI',6,'f',NULL,43,'f','JM (m)','JM (m)',504262,'PETRORHAGIA DUBIA','WILDING PINK, WINDMILL PINK, HAIRYPINK, PINK GRASS','Wilding pink, Windmill pink, hairypink, pink grass',NULL);
INSERT INTO calflora VALUES(37,'Carex livida (Wahlenb.) Willd.','Carex livida','Carex','livida','(Wahlenb.) Willd.',NULL,NULL,NULL,'Cyperaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb (rhizomatous)','NAm/WW','MEN',NULL,'BgFns',NULL,NULL,'?',NULL,NULL,'bogs/fens',NULL,NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'CAREX LIVIDA',359,'not listed','not listed','CALI','CAREX LIVIDA LIVID SEDGE CYPERACEAE','k2365900','OBL',1,'f',NULL,5,'t',NULL,NULL,39675,'CAREX LIVIDA','LIVID SEDGE','livid sedge',NULL);
INSERT INTO calflora VALUES(38,'Gilia aliquanta A.D. Grant & V. Grant','Gilia aliquanta','Gilia','aliquanta','A.D. Grant & V. Grant',NULL,NULL,NULL,'Polemoniaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA+','FRE INY KRN LAX MNO MPA RIV SBD SLO TUL',NULL,'m29m28',2296,5249,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','GIAL','GILIA ALIQUANTA PUFF-CALYX GILIA PUFFCALYX GILIA POLEMONIACEAE',NULL,'NI',5,'f',NULL,75,'t','JM (m)','JM (m)',31098,'GILIA ALIQUANTA','PUFF-CALYX GILIA, PUFFCALYX GILIA','puff-calyx gilia, puffcalyx gilia',NULL);
INSERT INTO calflora VALUES(39,'Lonicera cauriana Fern.','Lonicera cauriana','Lonicera','cauriana','Fern.',NULL,NULL,NULL,'Caprifoliaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','wNAm','AMA BUT CAL ELD FRE MAD MPA NEV PLA PLU SHA SIS TUL TUO',NULL,'m15m16m17',5000,10500,0,NULL,NULL,'streambanks',NULL,NULL,'moist','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LOCA9','LONICERA CAURIANA SWEET-BERRY HONEYSUCKLE BLUE FLY HONEYSUCKLE CAPRIFOLIACEAE',NULL,'FACW',11,'f',NULL,25,'t','Munz (ft.)','Munz (ft.)',516104,'LONICERA CAURIANA','SWEET-BERRY HONEYSUCKLE, BLUE FLY HONEYSUCKLE','Sweet-Berry Honeysuckle, blue fly honeysuckle',NULL);
INSERT INTO calflora VALUES(40,'Phacelia campanularia A. Gray','Phacelia campanularia','Phacelia','campanularia','A. Gray',NULL,NULL,NULL,'Hydrophyllaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','ALA IMP INY KRN LAX RIV SBA SBD SDG SON STA',NULL,'m08',0,5249,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','PHCA3','PHACELIA CAMPANULARIA DESERT BLUEBELLS DESERT-BELLS DESERTBELLS HYDROPHYLLACEAE',NULL,'NI',11,'t',NULL,126,'t','JM (m)','JM (m)',31465,'PHACELIA CAMPANULARIA','DESERT BLUEBELLS, DESERT-BELLS, DESERTBELLS','Desert Bluebells, desert-bells, desertbells','6212 3041 0636 0086');
INSERT INTO calflora VALUES(41,'Lepechinia calycina (Benth.) Epling','Lepechinia calycina','Lepechinia','calycina','(Benth.) Epling',NULL,NULL,NULL,'Lamiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA Endemic','ALA AMA BUT CAL CCA ELD FRE KNG KRN LAK MEN MER MNT MPA MRN NAP NEV PLA SBA SBT SCL SCR SFO SJQ SLO SMT SOL SON STA TUO VEN YOL YUB',NULL,'m23m22',0,3000,0,NULL,NULL,'slopes',NULL,NULL,NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LECA3','LEPECHINIA CALYCINA WHITE PITCHER SAGE WOODBALM PITCHER SAGE WOODBALM LAMIACEAE',NULL,'NI',33,'t',NULL,78,'t','Munz (ft.)','Munz (ft.)',32552,'LEPECHINIA CALYCINA','WHITE PITCHER SAGE, WOODBALM, PITCHER SAGE, WOODBALM','White Pitcher Sage, Woodbalm, pitcher sage, woodbalm','8120 3181 4901 0059');
INSERT INTO calflora VALUES(42,'Antirrhinum filipes A. Gray','Antirrhinum filipes','Antirrhinum','filipes','A. Gray',NULL,NULL,NULL,'Scrophulariaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','IMP INY KRN LAX RIV SBD SDG',NULL,'m08m29',0,4593,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ANFI2','ANTIRRHINUM FILIPES TWINING SNAPDRAGON TANGLED SNAPDRAGON SCROPHULARIACEAE',NULL,'NI',17,'t',NULL,64,'t','JM (m)','JM (m)',33470,'ANTIRRHINUM FILIPES','TWINING SNAPDRAGON, TANGLED SNAPDRAGON','Twining Snapdragon, tangled snapdragon','5161 1631 2512 0004');
INSERT INTO calflora VALUES(43,'Astragalus tener A. Gray var. tener','Astragalus tener var. tener','Astragalus','tener','A. Gray','var.','tener',NULL,'Fabaceae','dicot','child',938,'Astragalus tener',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','ALA CCA MER MNT NAP SBT SCL SFO SJQ SOL SON STA YOL',NULL,'m25m09 VnPls',NULL,NULL,3,NULL,NULL,'playas vernal-pools','alkaline','clay alkaline','vernally-flooded','Dennis/CNPS94',NULL,NULL,'ASTRAGALUS TENER VAR. TENER',224,'not listed','not listed','ASTET2','ASTRAGALUS TENER VAR. TENER ALKALI MILK-VETCH ALKALI MILKVETCH FABACEAE',NULL,'FACW',13,'t',NULL,121,'t',NULL,NULL,192775,'ASTRAGALUS TENER VAR. TENER','ALKALI MILK-VETCH, ALKALI MILKVETCH','alkali milk-vetch, alkali milkvetch',NULL);
INSERT INTO calflora VALUES(44,'Linum lewisii Pursh var. alpicola Jepson','Linum lewisii var. alpicola','Linum','lewisii','Pursh','var.','alpicola','Jepson','Linaceae','dicot','child',4908,'Linum lewisii',NULL,NULL,NULL,NULL,"Part of Munz\'s",'Linum perenne L. ssp. lewisii (Pursh) Hulten',NULL,NULL,NULL,NULL,'Perennial herb',NULL,'ALP AMA BUT CAL ELD FRE INY KRN LAS MAD MNO MPA NEV PLA PLU SIE TUL TUO YUB',NULL,'m14m15m16m17m28m22',6562,11155,0,NULL,NULL,'slopes ridges',NULL,NULL,'dry','Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LILEA',"LINUM LEWISII VAR. ALPICOLA ALPINE LEWIS\' FLAX PRAIRIE FLAX LINACEAE LINUM PERENNE L. SSP. LEWISII (PURSH) HULTEN",NULL,'NI',22,'f',NULL,24,'t','JM (m)','JM (m)',528817,'LINUM LEWISII VAR. ALPICOLA',"ALPINE LEWIS\' FLAX, PRAIRIE FLAX","alpine Lewis\' flax, prairie flax",NULL);
INSERT INTO calflora VALUES(45,'Phacelia vallis-mortae J. Voss var. heliophila (J.F. Macbr.) J. Voss','Phacelia vallis-mortae var. heliophila','Phacelia','vallis-mortae','J. Voss','var.','heliophila','(J.F. Macbr.) J. Voss','Hydrophyllaceae','dicot','stepchild',6410,NULL,'optional in JM','Phacelia vallis-mortae',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb',NULL,'SBT',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'not listed','not listed','PHVAH','PHACELIA VALLIS-MORTAE VAR. HELIOPHILA DEATH VALLEY PHACELIA SUNLOVING PHACELIA HYDROPHYLLACEAE PHACELIA VALLIS-MORTAE',NULL,'NI',NULL,'f',NULL,1,'t',NULL,NULL,531517,'PHACELIA VALLIS-MORTAE VAR. HELIOPHILA','DEATH VALLEY PHACELIA, SUNLOVING PHACELIA','Death Valley phacelia, sunloving phacelia',NULL);
INSERT INTO calflora VALUES(46,'Sinapis arvensis L.','Sinapis arvensis','Sinapis','arvensis','L.',NULL,NULL,NULL,'Brassicaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Brassica kaber (DC.) L.C. Wheeler',NULL,NULL,NULL,NULL,'Annual herb','Introd.','ALA AMA BUT CCA HUM KRN LAX MAD MER MNT MRN NAP NEV ORA PLU SBA SBD SCL SCR SDG SFO SHA SJQ SLO SMT SOL SON STA SUT VEN YOL',NULL,'m30',0,1640,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','SIAR4','SINAPIS ARVENSIS CHARLOCK CHARLOCK MUSTARD BRASSICACEAE BRASSICA KABER (DC.) L.C. WHEELER',NULL,'NI',NULL,'t',NULL,76,'f','JM (m)','JM (m)',23310,'SINAPIS ARVENSIS','CHARLOCK, CHARLOCK MUSTARD','charlock, charlock mustard',NULL);
INSERT INTO calflora VALUES(47,'Delphinium variegatum Torrey & A. Gray ssp. kinkiense (Munz) M. J. Warnock','Delphinium variegatum ssp. kinkiense','Delphinium','variegatum','Torrey & A. Gray','ssp.','kinkiense','(Munz) M. J. Warnock','Ranunculaceae','dicot','child',2678,'Delphinium variegatum',NULL,NULL,NULL,NULL,'Munz:','Delphinium kinkiense Munz',NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','LAX',NULL,'m25m05',NULL,NULL,3,'SE (Sep 1979)','FE (Aug 11,1977)','coastal',NULL,NULL,NULL,'Dennis/CNPS94',NULL,NULL,'DELPHINIUM VARIEGATUM SSP. KINKIENSE',584,'not listed','not listed','DEVAK','DELPHINIUM VARIEGATUM SSP. KINKIENSE SAN CLEMENTE ISLAND LARKSPUR ROYAL LARKSPUR RANUNCULACEAE DELPHINIUM KINKIENSE MUNZ',NULL,'NI',1,'f',NULL,23,'t',NULL,NULL,523954,'DELPHINIUM VARIEGATUM SSP. KINKIENSE','SAN CLEMENTE ISLAND LARKSPUR, ROYAL LARKSPUR','San Clemente Island larkspur, royal larkspur',NULL);
INSERT INTO calflora VALUES(48,'Chaenactis carphoclinia A. Gray var. carphoclinia','Chaenactis carphoclinia var. carphoclinia','Chaenactis','carphoclinia','A. Gray','var.','carphoclinia',NULL,'Asteraceae','dicot','child',1891,'Chaenactis carphoclinia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb',NULL,'ALP IMP INY KRN LAX MNO RIV SBD SDG TUL',NULL,NULL,0,6234,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','CHCAC','CHAENACTIS CARPHOCLINIA VAR. CARPHOCLINIA PEBBLE PINCUSHION ASTERACEAE',NULL,'NI',17,'t',NULL,169,'t','JM (m)','JM (m)',527247,'CHAENACTIS CARPHOCLINIA VAR. CARPHOCLINIA','PEBBLE PINCUSHION','pebble pincushion','5208 1611 1617 0082');
INSERT INTO calflora VALUES(49,'Vaccaria hispanica (Miller) Rauschert','Vaccaria hispanica','Vaccaria','hispanica','(Miller) Rauschert',NULL,NULL,NULL,'Caryophyllaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Vaccaria segetalis Garcke ex Aschers.',NULL,NULL,NULL,NULL,'Annual herb','Introd.','ALA AMA COL HUM KRN LAK LAS MNO MNT MOD PLU SBD SDG SFO SIE SIS SON SUT',NULL,'m30',0,9186,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','VAHI2','VACCARIA HISPANICA COWHERB SPANISH COCKLE COW SOAPWORT CARYOPHYLLACEAE VACCARIA SEGETALIS GARCKE EX ASCHERS.',NULL,'UPL',NULL,'f',NULL,31,'f','JM (m)','JM (m)',505628,'VACCARIA HISPANICA','COWHERB, SPANISH COCKLE, COW SOAPWORT','Cowherb, Spanish cockle, cow soapwort',NULL);
INSERT INTO calflora VALUES(50,'Penstemon labrosus (A. Gray) Hook. f.','Penstemon labrosus','Penstemon','labrosus','(A. Gray) Hook. f.',NULL,NULL,NULL,'Scrophulariaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','KRN LAX RIV SBD SDG VEN',NULL,'m14m15m16',4921,7874,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','PELA6','PENSTEMON LABROSUS SAN GABRIEL BEARDTONGUE SCROPHULARIACEAE',NULL,'NI',5,'t',NULL,61,'t','JM (m)','JM (m)',33928,'PENSTEMON LABROSUS','SAN GABRIEL BEARDTONGUE','San Gabriel beardtongue',NULL);
INSERT INTO calflora VALUES(51,'Verbascum thapsus L.','Verbascum thapsus','Verbascum','thapsus','L.',NULL,NULL,NULL,'Scrophulariaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','ALA ALP AMA BUT CAL COL DNT ELD FRE GLE HUM INY KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SCL SCR SDG SFO SHA SIE SIS SJQ SLO SMT SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m30',4000,15000,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','VETH','VERBASCUM THAPSUS WOOLLY MULLEIN COMMON MULLEIN SCROPHULARIACEAE',NULL,'NI',52,'t','B',193,'f','Munz (ft.)','Munz (ft.)',33394,'VERBASCUM THAPSUS','WOOLLY MULLEIN, COMMON MULLEIN','Woolly Mullein, common mullein','6249 3022 3911 0046');
INSERT INTO calflora VALUES(52,'Anthemis tinctoria L.','Anthemis tinctoria','Anthemis','tinctoria','L.',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','ALA NEV PLU',NULL,'m40',0,6562,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ANTI','ANTHEMIS TINCTORIA GOLDEN MARGEURITE GOLDEN MARGUERITE ASTERACEAE',NULL,'NI',2,'f',NULL,3,'f','JM (m)','JM (m)',36333,'ANTHEMIS TINCTORIA','GOLDEN MARGEURITE, GOLDEN MARGUERITE','golden margeurite, golden marguerite',NULL);
INSERT INTO calflora VALUES(53,'Lewisia cotyledon (S. Watson) Robinson var. heckneri (C. Morton) Munz','Lewisia cotyledon var. heckneri','Lewisia','cotyledon','(S. Watson) Robinson','var.','heckneri','(C. Morton) Munz','Portulacaceae','dicot','child',4766,'Lewisia cotyledon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','DNT HUM SIS TRI',NULL,'m14m10',NULL,NULL,2,NULL,NULL,NULL,NULL,'rocky',NULL,'Dennis/CNPS94',NULL,NULL,'LEWISIA COTYLEDON VAR. HECKNERI',1054,'not listed','not listed','LECOH',"LEWISIA COTYLEDON VAR. HECKNERI HECKNER\'S LEWISIA PORTULACACEAE",NULL,'NI',6,'f',NULL,30,'t',NULL,NULL,528769,'LEWISIA COTYLEDON VAR. HECKNERI',"HECKNER\'S LEWISIA","Heckner\'s lewisia",NULL);
INSERT INTO calflora VALUES(54,'Panicum antidotale Retz.','Panicum antidotale','Panicum','antidotale','Retz.',NULL,NULL,NULL,'Poaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','IMP INY RIV SBD SDG',NULL,NULL,0,328,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'B','not listed','PAAN4','PANICUM ANTIDOTALE BLUE PANICGRASS BLUE PANICUM POACEAE',NULL,'NI',NULL,'t',NULL,13,'f','JM (m)','JM (m)',504098,'PANICUM ANTIDOTALE','BLUE PANICGRASS, BLUE PANICUM','blue panicgrass, blue panicum',NULL);
INSERT INTO calflora VALUES(55,'Crossosoma californicum Nutt.','Crossosoma californicum','Crossosoma','californicum','Nutt.',NULL,NULL,NULL,'Crossosomataceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA, GU','ALA LAX RIV',NULL,'m05',NULL,NULL,1,NULL,NULL,NULL,NULL,'rocky',NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'CROSSOSOMA CALIFORNICUM',530,'not listed','not listed','CRCA4','CROSSOSOMA CALIFORNICUM CALIFORNIA ROCKFLOWER CATALINA CROSSOSOMA CROSSOSOMATACEAE',NULL,'NI',2,'t',NULL,41,'t',NULL,NULL,501799,'CROSSOSOMA CALIFORNICUM','CALIFORNIA ROCKFLOWER, CATALINA CROSSOSOMA','California rockflower, Catalina crossosoma','8120 3181 4563 0107');
INSERT INTO calflora VALUES(56,'Oenothera elata','Oenothera elata','Oenothera','elata',NULL,NULL,NULL,NULL,'Onagraceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','NAm/WW','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM IMP INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SFO SHA SIE SIS SJQ SLO SMT SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,NULL,0,9186,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','OEEL',"OENOTHERA ELATA HOOKER\'S EVENING PRIMROSE HOOKER\'S EVENING-PRIMROSE EVENING-PRIMROSE ONAGRACEAE",NULL,'FACW',NULL,'f',NULL,506,'t','JM (m)','JM (m)',27395,'OENOTHERA ELATA',"HOOKER\'S EVENING PRIMROSE, HOOKER\'S EVENING-PRIMROSE, EVENING-PRIMROSE","Hooker\'s Evening Primrose, Hooker\'s evening-primrose, evening-primrose",NULL);
INSERT INTO calflora VALUES(57,'Soliva sessilis Ruiz Lopez & Pavon','Soliva sessilis','Soliva','sessilis','Ruiz Lopez & Pavon',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Includes Munz\'s",'Soliva daucifolia Nutt., Soliva pterosperma (Juss.) Less.',NULL,NULL,NULL,NULL,'Annual herb','Introd.','ALA AMA BUT CAL CCA COL DNT ELD FRE GLE HUM KNG KRN LAK LAX MEN MER MNT MPA MRN NAP NEV ORA RIV SAC SBA SBT SCL SCR SDG SFO SHA SJQ SLO SMT SOL SON STA SUT TEH TRI TUO VEN YOL YUB',NULL,'m50m80',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','SOSE2','SOLIVA SESSILIS SOUTH AMERICAN SOLIVA COMMON SOLIVA FIELD BURRWEED ASTERACEAE SOLIVA DAUCIFOLIA NUTT. SOLIVA PTEROSPERMA (JUSS.) LESS.',NULL,'FAC*',41,'t',NULL,214,'f',NULL,NULL,38879,'SOLIVA SESSILIS','SOUTH AMERICAN SOLIVA, COMMON SOLIVA, FIELD BURRWEED','South american soliva, common soliva, field burrweed',NULL);
INSERT INTO calflora VALUES(58,'Aubrieta deltoidea (L.) DC.','Aubrieta deltoidea','Aubrieta','deltoidea','(L.) DC.',NULL,NULL,NULL,'Brassicaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb',NULL,'LAK MEN',NULL,NULL,4921,6562,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed',NULL,'AUBRIETA DELTOIDEA GARDEN AUBRIETA BRASSICACEAE',NULL,NULL,3,'f',NULL,5,'t','JM (m)','JM (m)',0,'AUBRIETA DELTOIDEA','GARDEN AUBRIETA','garden aubrieta',NULL);
INSERT INTO calflora VALUES(59,'Dichondra donelliana Tharp & M. Johnston','Dichondra donelliana','Dichondra','donelliana','Tharp & M. Johnston',NULL,NULL,NULL,'Convolvulaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Dichondra repens J.R. Forst.','Dichondra donnelliana',NULL,NULL,NULL,'Perennial herb, Vine','CA Endemic','BUT CAL CCA ELD HUM MEN MNT MRN NAP ORA SAC SBA SCL SCR SFO SLO SMT SON YOL',NULL,'m24m04',164,984,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','DIDO2','DICHONDRA DONELLIANA CALIFORNIA PONYSFOOT DICHONDRA CONVOLVULACEAE DICHONDRA REPENS J.R. FORST.',NULL,NULL,9,'f',NULL,46,'t','JM (m)','JM (m)',30838,'DICHONDRA DONELLIANA','CALIFORNIA PONYSFOOT, DICHONDRA','California ponysfoot, dichondra',NULL);
INSERT INTO calflora VALUES(60,'Eriogonum heermannii Durand & Hilg. var. floccosum Munz','Eriogonum heermannii var. floccosum','Eriogonum','heermannii','Durand & Hilg.','var.','floccosum','Munz','Polygonaceae','dicot','child',3265,'Eriogonum heermannii',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA Endemic','SBD',NULL,'m28',NULL,NULL,1,NULL,NULL,NULL,'carbonate',NULL,NULL,'Dennis/CNPS94',NULL,NULL,'ERIOGONUM HEERMANNII VAR. FLOCCOSUM',723,'not listed','not listed','ERHEF','ERIOGONUM HEERMANNII VAR. FLOCCOSUM CLARK MOUNTAIN BUCKWHEAT CLARK MTN. BUCKWHEAT POLYGONACEAE',NULL,'NI',5,'f',NULL,10,'t',NULL,NULL,527997,'ERIOGONUM HEERMANNII VAR. FLOCCOSUM','CLARK MOUNTAIN BUCKWHEAT, CLARK MTN. BUCKWHEAT','Clark Mountain buckwheat, Clark Mtn. buckwheat',NULL);
INSERT INTO calflora VALUES(61,'Phlox muscoides Nutt.','Phlox muscoides','Phlox','muscoides','Nutt.',NULL,NULL,NULL,'Polemoniaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Phlox bryoides Nutt.',NULL,NULL,NULL,NULL,'Perennial herb','NAm/WW?','MNO SHA SIS',NULL,'m26',NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,'Dennis/CNPS94',NULL,NULL,'PHLOX MUSCOIDES',1415,'not listed','not listed','PHMU4','PHLOX MUSCOIDES MOSS PHLOX POLEMONIACEAE PHLOX BRYOIDES NUTT.',NULL,'NI',2,'f',NULL,5,'t',NULL,NULL,30965,'PHLOX MUSCOIDES','MOSS PHLOX','moss phlox',NULL);
INSERT INTO calflora VALUES(62,'Vulpia octoflora (Walter) Rydb. var. hirtella (Piper) Henrad','Vulpia octoflora var. hirtella','Vulpia','octoflora','(Walter) Rydb.','var.','hirtella','(Piper) Henrad','Poaceae','monocot','child',8333,'Vulpia octoflora',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM IMP INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SHA SIE SIS SJQ SLO SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,NULL,0,4921,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','VUOCH','VULPIA OCTOFLORA VAR. HIRTELLA HAIRY SIX-WEEKS FESCUE SIX-WEEKS FESCUE SIXWEEKS FESCUE POACEAE',NULL,'UPL',NULL,'f',NULL,152,'t','JM (m)','JM (m)',530862,'VULPIA OCTOFLORA VAR. HIRTELLA','HAIRY SIX-WEEKS FESCUE, SIX-WEEKS FESCUE, SIXWEEKS FESCUE','hairy six-weeks fescue, six-weeks fescue, sixweeks fescue',NULL);
INSERT INTO calflora VALUES(63,'Chaenactis suffrutescens A. Gray','Chaenactis suffrutescens','Chaenactis','suffrutescens','A. Gray',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','SHA SIS TRI',NULL,'m14',NULL,NULL,2,NULL,NULL,NULL,'serpentine','sandy',NULL,'Lum/monog.,Dennis/CNPS94',NULL,NULL,'CHAENACTIS SUFFRUTESCENS',418,'not listed','not listed','CHSU','CHAENACTIS SUFFRUTESCENS SHASTA CHAENACTIS ASTERACEAE',NULL,'NI',5,'t',NULL,47,'t',NULL,NULL,36999,'CHAENACTIS SUFFRUTESCENS','SHASTA CHAENACTIS','Shasta chaenactis','5208 1611 1617 0076');
INSERT INTO calflora VALUES(64,'Lilium columbianum Baker','Lilium columbianum','Lilium','columbianum','Baker',NULL,NULL,NULL,'Liliaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','DNT FRE HUM INY MEN MNO PLU SHA SIE SIS SON TRI',NULL,'m04m12',0,4265,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LICO','LILIUM COLUMBIANUM COLUMBIA LILY COLUMBIAN LILY OREGON LILY LILIACEAE',NULL,'NI',3,'t',NULL,40,'t','JM (m)','JM (m)',503452,'LILIUM COLUMBIANUM','COLUMBIA LILY, COLUMBIAN LILY, OREGON LILY','Columbia lily, Columbian lily, Oregon lily',NULL);
INSERT INTO calflora VALUES(65,'Erodium cygnorum Nees','Erodium cygnorum','Erodium','cygnorum','Nees',NULL,NULL,NULL,'Geraniaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','Introd.','RIV SDG',NULL,NULL,0,1640,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','ERCY2',"ERODIUM CYGNORUM AUSTRALIAN FILAREE AUSTRALIAN STORK\'S BILL GERANIACEAE",NULL,'NI',2,'f',NULL,3,'f','JM (m)','JM (m)',29148,'ERODIUM CYGNORUM',"AUSTRALIAN FILAREE, AUSTRALIAN STORK\'S BILL","Australian filaree, Australian stork\'s bill",NULL);
INSERT INTO calflora VALUES(66,'Draba oligosperma Hook.','Draba oligosperma','Draba','oligosperma','Hook.',NULL,NULL,NULL,'Brassicaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALP AMA BUT CAL ELD FRE INY KRN LAS MAD MNO MPA NEV PLA PLU SIE TUL TUO YUB',NULL,'m26',6562,14200,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Walker/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','DROL','DRABA OLIGOSPERMA FEW-SEEDED DRABA FEWSEED DRABA BRASSICACEAE',NULL,'NI',10,'f',NULL,147,'t','JM (m)','Munz (ft.)',22896,'DRABA OLIGOSPERMA','FEW-SEEDED DRABA, FEWSEED DRABA','few-seeded draba, fewseed draba',NULL);
INSERT INTO calflora VALUES(67,'Gentiana sceptrum Griseb.','Gentiana sceptrum','Gentiana','sceptrum','Griseb.',NULL,NULL,NULL,'Gentianaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','DNT HUM MEN SON',NULL,'m04m11m13m12m19m14',0,3937,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','GESC',"GENTIANA SCEPTRUM KING\'S SCEPTER GENTIAN GENTIANACEAE",NULL,'OBL',7,'t',NULL,39,'t','JM (m)','JM (m)',29987,'GENTIANA SCEPTRUM',"KING\'S SCEPTER GENTIAN","king\'s scepter gentian",'8120 3181 4016 0056');
INSERT INTO calflora VALUES(68,'Marah fabaceus (Naudin) E. Greene','Marah fabaceus','Marah','fabaceus','(Naudin) E. Greene',NULL,NULL,NULL,'Cucurbitaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb, Vine','CA Endemic','ALA AMA BUT CAL CCA COL ELD FRE HUM KNG KRN LAK LAX MAD MEN MER MNT MPA MRN NAP NEV PLA SAC SBA SBT SCL SCR SFO SHA SJQ SLO SMT SOL SON STA SUT TRI TUL TUO VEN YOL YUB',NULL,'m01m19m22m23',0,5249,0,NULL,NULL,'coastal',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','MAFA3','MARAH FABACEUS CALIFORNIA MANROOT COAST WILD CUCUMBER MANROOT WILD-CUCUMBER CUCURBITACEAE',NULL,'UPL',44,'t',NULL,252,'t','JM (m)','JM (m)',22391,'MARAH FABACEUS','CALIFORNIA MANROOT, COAST WILD CUCUMBER, MANROOT, WILD-CUCUMBER','California manroot, Coast wild cucumber, Manroot, wild-cucumber','8120 3181 4897 0024');
INSERT INTO calflora VALUES(69,'Antirrhinum subcordatum A. Gray','Antirrhinum subcordatum','Antirrhinum','subcordatum','A. Gray',NULL,NULL,NULL,'Scrophulariaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','COL GLE LAK MEN TEH',NULL,'m23m14',NULL,NULL,2,NULL,NULL,NULL,'serpentine',NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'ANTIRRHINUM SUBCORDATUM',59,'not listed','not listed','ANSU4','ANTIRRHINUM SUBCORDATUM DIMORPHIC SNAPDRAGON SCROPHULARIACEAE',NULL,'NI',4,'f',NULL,60,'t',NULL,NULL,33481,'ANTIRRHINUM SUBCORDATUM','DIMORPHIC SNAPDRAGON','dimorphic snapdragon',NULL);
INSERT INTO calflora VALUES(70,'Trichostema oblongum Benth.','Trichostema oblongum','Trichostema','oblongum','Benth.',NULL,NULL,NULL,'Lamiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','AMA BUT CAL ELD FRE HUM KRN LAK LAS MAD MEN MOD MPA NAP NEV PLA PLU SHA SIE SIS SOL TEH TRI TUL TUO',NULL,'m14m15m16m17m19m10 Medws',0,10000,0,NULL,NULL,'meadows',NULL,NULL,'dry','Lum/monog., Walker',NULL,NULL,NULL,NULL,'not listed','not listed','TROB','TRICHOSTEMA OBLONGUM MOUNTAIN BLUECURLS OBLONG BLUECURLS LAMIACEAE',NULL,'NI',30,'t',NULL,83,'t','Munz (ft.)','Munz (ft.)',32375,'TRICHOSTEMA OBLONGUM','MOUNTAIN BLUECURLS, OBLONG BLUECURLS','Mountain Bluecurls, oblong bluecurls','6249 3022 3908 0059');
INSERT INTO calflora VALUES(71,'Galium grayanum Ehrend. var. nanum Dempster & Ehrend.','Galium grayanum var. nanum','Galium','grayanum','Ehrend.','var.','nanum','Dempster & Ehrend.','Rubiaceae','dicot','child',3693,'Galium grayanum',NULL,NULL,NULL,NULL,"Part of Munz\'s",'Galium grayanum Ehrend.',NULL,NULL,NULL,NULL,'Perennial herb',NULL,'COL HUM LAK MEN MOD TEH TRI YOL',NULL,'m15m16m17',6398,8203,0,NULL,NULL,'slopes',NULL,'rocky','dry','Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','GAGRN',"GALIUM GRAYANUM VAR. NANUM GRAY\'S BEDSTRAW RUBIACEAE GALIUM GRAYANUM EHREND.",NULL,'NI',4,'f',NULL,28,'t','JM (m)','JM (m)',528212,'GALIUM GRAYANUM VAR. NANUM',"GRAY\'S BEDSTRAW","Gray\'s bedstraw",NULL);
INSERT INTO calflora VALUES(72,'Elymus californicus (Bolander) Gould','Elymus californicus','Elymus','californicus','(Bolander) Gould',NULL,NULL,NULL,'Poaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Includes Munz\'s",'Hystrix californica Boland. ex Thurb.',NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','GLE MNT MRN SCR SMT SON',NULL,'m10m11m12m13m19m22 RpWld',NULL,NULL,1,NULL,NULL,'riparian',NULL,NULL,NULL,'Dennis/CNPS94, Lum/Munz68',NULL,NULL,NULL,648,'not listed','not listed','ELCA10','ELYMUS CALIFORNICUS CALIFORNIA BOTTLE GRASS CALIFORNIA BOTTLE-BRUSH GRASS CALIFORNIA BOTTLEBRUSH GRASS POACEAE HYSTRIX CALIFORNICA BOLAND. EX THURB.',NULL,'UPL',7,'t',NULL,34,'t',NULL,NULL,512812,'ELYMUS CALIFORNICUS','CALIFORNIA BOTTLE GRASS, CALIFORNIA BOTTLE-BRUSH GRASS, CALIFORNIA BOTTLEBRUSH GRASS','California Bottle Grass, California bottle-brush grass, California bottlebrush grass',NULL);
INSERT INTO calflora VALUES(73,'Streptanthus albidus E. Greene ssp. albidus','Streptanthus albidus ssp. albidus','Streptanthus','albidus','E. Greene','ssp.','albidus',NULL,'Brassicaceae','dicot','child',7812,'Streptanthus albidus',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','CCA SCL',NULL,'m25',NULL,NULL,3,'\ ','FE (Feb 03,1995)',NULL,'serpentine',NULL,NULL,'Dennis/CNPS94',NULL,NULL,'STREPTANTHUS ALBIDUS SSP. ALBIDUS',1638,'not listed','not listed','STALA','STREPTANTHUS ALBIDUS SSP. ALBIDUS METCALF CANYON JEWEL-FLOWER METCALF CANYON JEWELFLOWER BRASSICACEAE',NULL,'NI',1,'t',NULL,23,'t',NULL,NULL,23336,'STREPTANTHUS ALBIDUS SSP. ALBIDUS','METCALF CANYON JEWEL-FLOWER, METCALF CANYON JEWELFLOWER','Metcalf Canyon jewel-flower, Metcalf Canyon jewelflower',NULL);
INSERT INTO calflora VALUES(74,'Rudbeckia californica A. Gray var. californica','Rudbeckia californica var. californica','Rudbeckia','californica','A. Gray','var.','californica',NULL,'Asteraceae','dicot','child',7207,'Rudbeckia californica',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb',NULL,'ALP AMA BUT CAL DNT ELD FRE HUM INY KRN LAS MAD MNO MPA NEV PLA PLU SHA SIE SIS TRI TUL TUO YUB',NULL,NULL,5413,8530,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','RUCAC3','RUDBECKIA CALIFORNICA VAR. CALIFORNICA CALIFORNIA CONE-FLOWER ASTERACEAE',NULL,'FACW',32,'t',NULL,32,'t','JM (m)','JM (m)',530159,'RUDBECKIA CALIFORNICA VAR. CALIFORNICA','CALIFORNIA CONE-FLOWER','California cone-flower',NULL);
INSERT INTO calflora VALUES(75,'Pellaea andromedifolia (Kaulf.) Fee var. pubescens D. Eaton','Pellaea andromedifolia var. pubescens','Pellaea','andromedifolia','(Kaulf.) Fee','var.','pubescens','D. Eaton','Pteridaceae','pteridophyte','stepchild',6122,NULL,'optional in JM','Pellaea andromedifolia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Fern',NULL,'SLO',NULL,NULL,98,5905,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'not listed','not listed','PEANP','PELLAEA ANDROMEDIFOLIA VAR. PUBESCENS COFFEE FERN PTERIDACEAE PELLAEA ANDROMEDIFOLIA',NULL,'NI',NULL,'f',NULL,1,'t','JM (m)','JM (m)',538457,'PELLAEA ANDROMEDIFOLIA VAR. PUBESCENS','COFFEE FERN','coffee fern',NULL);
INSERT INTO calflora VALUES(76,'Calyptridium roseum S. Watson','Calyptridium roseum','Calyptridium','roseum','S. Watson',NULL,NULL,NULL,'Portulacaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','INY LAS MNO NAP TUL',NULL,'m06m27m15m16',5000,10500,0,NULL,NULL,NULL,NULL,'alkaline','moist','Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CARO','CALYPTRIDIUM ROSEUM ROSY PUSSYPAWS PORTULACACEAE',NULL,'FACU*',6,'t',NULL,34,'t','Munz (ft.)','Munz (ft.)',20472,'CALYPTRIDIUM ROSEUM','ROSY PUSSYPAWS','rosy pussypaws','8076 3101 4742 0045');
INSERT INTO calflora VALUES(77,'Atriplex joaquiniana Nelson','Atriplex joaquiniana','Atriplex','joaquiniana','Nelson',NULL,NULL,NULL,'Chenopodiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Munz:','Atriplex patula L. ssp. spicata (S. Wats.) Hall & Clements',NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','ALA CCA COL GLE MER MNT NAP SAC SBT SCL SFO SJQ SLO SOL TUL YOL',NULL,'m07m25 Medws',NULL,NULL,2,NULL,NULL,'meadows','alkaline','alkaline',NULL,'Dennis/CNPS94',NULL,NULL,'ATRIPLEX JOAQUINIANA',236,'not listed','not listed','ATJO3','ATRIPLEX JOAQUINIANA SAN JOAQUIN ORACHE SAN JOAQUIN SALTBUSH SAN JOAQUIN SPEARSCALE CHENOPODIACEAE ATRIPLEX PATULA L. SSP. SPICATA (S. WATS.) HALL & CLEMENTS',NULL,'NI',13,'t',NULL,126,'t',NULL,NULL,192219,'ATRIPLEX JOAQUINIANA','SAN JOAQUIN ORACHE, SAN JOAQUIN SALTBUSH, SAN JOAQUIN SPEARSCALE','San Joaquin orache, San Joaquin saltbush, San Joaquin spearscale',NULL);
INSERT INTO calflora VALUES(78,'Minuartia nuttallii (Pax) Briq. ssp. fragilis (Maguire & A. Holmgren) McNeill','Minuartia nuttallii ssp. fragilis','Minuartia','nuttallii','(Pax) Briq.','ssp.','fragilis','(Maguire & A. Holmgren) McNeill','Caryophyllaceae','dicot','child',5572,'Minuartia nuttallii',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb',NULL,'ALP IMP INY LAS MNO MOD PLU SHA SIS TEH TRI',NULL,NULL,5413,7874,0,NULL,NULL,NULL,NULL,NULL,NULL,'Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','MINUF','MINUARTIA NUTTALLII SSP. FRAGILIS BRITTLE SANDWORT CARYOPHYLLACEAE',NULL,'NI',15,'f',NULL,33,'t','JM (m)','JM (m)',20005,'MINUARTIA NUTTALLII SSP. FRAGILIS','BRITTLE SANDWORT','brittle sandwort',NULL);
INSERT INTO calflora VALUES(79,'Oenothera deltoides Torrey & Fremont','Oenothera deltoides','Oenothera','deltoides','Torrey & Fremont',NULL,NULL,NULL,'Onagraceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','ALA ALP CCA FRE IMP INY KNG KRN LAS LAX MAD MER MNT MOD MPA PLU RIV SAC SBA SBD SBT SDG SHA SIS SJQ SLO STA TUL',NULL,'m08m29m25m06',0,5905,0,NULL,NULL,NULL,NULL,'sandy',NULL,'Lum/Walker/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','OEDE2','OENOTHERA DELTOIDES DUNE PRIMROSE BIRDCAGE EVENING-PRIMROSE DESERT LANTERN ONAGRACEAE',NULL,'NI',29,'t',NULL,264,'t','Munz (ft.)','JM (m)',27389,'OENOTHERA DELTOIDES','DUNE PRIMROSE, BIRDCAGE EVENING-PRIMROSE, DESERT LANTERN','Dune Primrose, birdcage evening-primrose, desert lantern','0024 3291 2018 0020');
INSERT INTO calflora VALUES(80,'Lomatium stebbinsii M. Schlessman & Constance','Lomatium stebbinsii','Lomatium','stebbinsii','M. Schlessman & Constance',NULL,NULL,NULL,'Apiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','AMA CAL TUO',NULL,'m23m14',NULL,NULL,3,NULL,NULL,NULL,'volcanic','clay gravelly',NULL,'Dennis/CNPS94',NULL,NULL,'LOMATIUM STEBBINSII',1113,'not listed','not listed','LOST5',"LOMATIUM STEBBINSII STEBBINS\' DESERTPARSLEY STEBBINS\'S LOMATIUM APIACEAE",NULL,'NI',4,'t',NULL,57,'t',NULL,NULL,29750,'LOMATIUM STEBBINSII',"STEBBINS\' DESERTPARSLEY, STEBBINS\'S LOMATIUM","Stebbins\' desertparsley, Stebbins\'s lomatium",NULL);
INSERT INTO calflora VALUES(81,'Lupinus ludovicianus E. Greene','Lupinus ludovicianus','Lupinus','ludovicianus','E. Greene',NULL,NULL,NULL,'Fabaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','SLO',NULL,'m23m22',NULL,NULL,3,NULL,NULL,NULL,'carbonate',NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'LUPINUS LUDOVICIANUS',1146,'not listed','not listed','LULU','LUPINUS LUDOVICIANUS SAN LUIS OBISPO COUNTY LUPINE SAN LUIS LUPINE FABACEAE',NULL,'NI',2,'f',NULL,39,'t',NULL,NULL,26054,'LUPINUS LUDOVICIANUS','SAN LUIS OBISPO COUNTY LUPINE, SAN LUIS LUPINE','San Luis Obispo County lupine, San Luis lupine',NULL);
INSERT INTO calflora VALUES(82,'Viola purpurea Kellogg','Viola purpurea','Viola','purpurea','Kellogg',NULL,NULL,NULL,'Violaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM IMP INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SHA SIE SIS SJQ SLO SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m14m15m16m06m27',0,11000,0,NULL,NULL,NULL,NULL,NULL,'dry','Lum/Walker/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','VIPU4','VIOLA PURPUREA MOUNTAIN VIOLET MOUNTAIN VIOLET GOOSEFOOT VIOLET VIOLACEAE',NULL,'NI',47,'t',NULL,960,'t','Munz (ft.)','Munz (ft.)',22145,'VIOLA PURPUREA','MOUNTAIN VIOLET, MOUNTAIN VIOLET, GOOSEFOOT VIOLET','Mountain Violet, Mountain violet, goosefoot violet','8076 3101 3985 0012');
INSERT INTO calflora VALUES(83,'Calochortus monanthus Ownbey','Calochortus monanthus','Calochortus','monanthus','Ownbey',NULL,NULL,NULL,'Liliaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb (bulb)','extct?','SIS',NULL,'Medws',NULL,NULL,'?',NULL,NULL,'meadows',NULL,NULL,NULL,'Lum/monog.,Dennis/CNPS94',NULL,NULL,'CALOCHORTUS MONANTHUS',294,'not listed','not listed','CAMO2','CALOCHORTUS MONANTHUS SINGLE-FLOWERED MARIPOSA LILY LILIACEAE',NULL,'FAC*',1,'f',NULL,4,'t',NULL,NULL,42859,'CALOCHORTUS MONANTHUS','SINGLE-FLOWERED MARIPOSA LILY','single-flowered mariposa lily',NULL);
INSERT INTO calflora VALUES(84,'Lepidium virginicum L.','Lepidium virginicum','Lepidium','virginicum','L.',NULL,NULL,NULL,'Brassicaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','NAm/WW','ALA ALP AMA BUT CAL CCA COL DNT ELD FRE GLE HUM INY KNG KRN LAK LAS LAX MAD MEN MER MNO MNT MOD MPA MRN NAP NEV ORA PLA PLU RIV SAC SBA SBD SBT SCL SCR SDG SFO SHA SIE SIS SJQ SLO SOL SON STA SUT TEH TRI TUL TUO VEN YOL YUB',NULL,'m41m23m05m50',0,8000,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LEVI3','LEPIDIUM VIRGINICUM VIRGINIA PEPPERWEED WILD PEPPER-GRASS BRASSICACEAE',NULL,'FACU',81,'t',NULL,342,'t','Munz (ft.)','Munz (ft.)',22955,'LEPIDIUM VIRGINICUM','VIRGINIA PEPPERWEED, WILD PEPPER-GRASS','Virginia pepperweed, wild pepper-grass','6105 1651 0942 0050');
INSERT INTO calflora VALUES(85,'Epilobium pallidum (Eastw.) P. Hoch & Raven','Epilobium pallidum','Epilobium','pallidum','(Eastw.) P. Hoch & Raven',NULL,NULL,NULL,'Onagraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Includes Munz\'s",'Boisduvalia macrantha Heller, Boisduvalia pallida Eastw.',NULL,NULL,NULL,NULL,'Annual herb','CA+','AMA BUT CAL ELD FRE LAS MAD MOD MPA NEV PLA PLU SHA SIE SIS SON TEH TUO YUB',NULL,'m14m15m22',4000,6000,0,NULL,NULL,NULL,NULL,'sandy gravelly','moist','Lum/Walker/Munz68, Lum/monog.',NULL,NULL,NULL,NULL,'not listed','not listed','EPPA7','EPILOBIUM PALLIDUM LARGEFLOWER SPIKE-PRIMROSE PALE BOISDUVALIA ONAGRACEAE BOISDUVALIA MACRANTHA HELLER BOISDUVALIA PALLIDA EASTW.',NULL,NULL,23,'t',NULL,58,'t','Munz (ft.)','Munz (ft.)',507918,'EPILOBIUM PALLIDUM','LARGEFLOWER SPIKE-PRIMROSE, PALE BOISDUVALIA','largeflower spike-primrose, pale boisduvalia','5208 1611 2177 0070');
INSERT INTO calflora VALUES(86,'Urtica urens L.','Urtica urens','Urtica','urens','L.',NULL,NULL,NULL,'Urticaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','Introd.','ALA BUT CCA HUM KRN LAK LAX MNT MOD MRN NAP NEV ORA RIV SBA SBD SCL SDG SFO SJQ SLO SMT SOL SON STA TUL VEN',NULL,'m30',0,9842,0,NULL,NULL,'disturbed',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','URUR','URTICA URENS ANNUAL STINGING NETTLE DWARF NETTLE URTICACEAE',NULL,'NI',NULL,'t',NULL,113,'f','JM (m)','JM (m)',19158,'URTICA URENS','ANNUAL STINGING NETTLE, DWARF NETTLE','Annual Stinging Nettle, dwarf nettle','6249 3022 3910 0078');
INSERT INTO calflora VALUES(87,'Eriogonum temblorense J. Howell & Twisselm.','Eriogonum temblorense','Eriogonum','temblorense','J. Howell & Twisselm.',NULL,NULL,NULL,'Polygonaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA Endemic','KRN MNT SLO',NULL,'m25',NULL,NULL,1,NULL,NULL,NULL,'sedimentary sandstone','clay',NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'ERIOGONUM TEMBLORENSE',758,'not listed','not listed','ERTE15','ERIOGONUM TEMBLORENSE TEMBLOR BUCKWHEAT POLYGONACEAE',NULL,'NI',3,'f',NULL,17,'t',NULL,NULL,21253,'ERIOGONUM TEMBLORENSE','TEMBLOR BUCKWHEAT','Temblor buckwheat',NULL);
INSERT INTO calflora VALUES(88,'Malacothamnus arcuatus (Greene) Greene','Malacothamnus arcuatus','Malacothamnus','arcuatus','(Greene) Greene',NULL,NULL,NULL,'Malvaceae','dicot','stepchild',5310,NULL,'CNPS only','Malacothamnus fasciculatus',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Shrub','CA Endemic','SCL SCR SMT',NULL,'m23',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68,Dennis/CNPS94',NULL,NULL,'MALACOTHAMNUS ARCUATUS',1179,'not listed','not listed','MAAR','MALACOTHAMNUS ARCUATUS ARCUATE BUSH MALLOW MALVACEAE MALACOTHAMNUS FASCICULATUS',NULL,'NI',3,'f',NULL,7,'t',NULL,NULL,516622,'MALACOTHAMNUS ARCUATUS','ARCUATE BUSH MALLOW','arcuate bush mallow',NULL);
INSERT INTO calflora VALUES(89,'Lepidium oblongum Small','Lepidium oblongum','Lepidium','oblongum','Small',NULL,NULL,NULL,'Brassicaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','NAm/WW','FRE IMP KNG KRN LAX MAD MEN MNT ORA RIV SAC SBA SBD SBT SDG SHA SIS SLO TRI TUL VEN',NULL,'m80',0,1641,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68, Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LEOB','LEPIDIUM OBLONGUM WAYSIDE PEPPERGRASS VEINY PEPPER-GRASS VEINY PEPPERWEED BRASSICACEAE',NULL,'NI',24,'f',NULL,71,'t','JM (m)','JM (m)',22972,'LEPIDIUM OBLONGUM','WAYSIDE PEPPERGRASS, VEINY PEPPER-GRASS, VEINY PEPPERWEED','Wayside peppergrass, veiny pepper-grass, veiny pepperweed',NULL);
INSERT INTO calflora VALUES(90,'Lasthenia macrantha (A. Gray) E. Greene','Lasthenia macrantha','Lasthenia','macrantha','(A. Gray) E. Greene',NULL,NULL,NULL,'Asteraceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','CA+','ALA CCA DNT HUM MEN MNT MRN NAP ORA SBA SCL SCR SLO SMT SOL SON',NULL,'m04',0,1640,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/monog., Calflora/JM93',NULL,NULL,NULL,NULL,'not listed','not listed','LAMA6','LASTHENIA MACRANTHA PERENNIAL GOLDFIELDS PERENNIAL GOLDFIELDS ASTERACEAE',NULL,'NI',7,'f',NULL,119,'t','JM (m)','JM (m)',37847,'LASTHENIA MACRANTHA','PERENNIAL GOLDFIELDS, PERENNIAL GOLDFIELDS','Perennial goldfields, perennial goldfields',NULL);
INSERT INTO calflora VALUES(91,'Hemizonia fitchii A. Gray','Hemizonia fitchii','Hemizonia','fitchii','A. Gray',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','wNAm','ALA AMA BUT CAL CCA COL ELD FRE GLE KNG KRN LAK MAD MEN MER MNT MPA MRN NAP NEV PLA SAC SBA SBD SBT SCL SCR SHA SIS SJQ SLO SOL SON STA SUT TEH TUL TUO YOL YUB',NULL,'m25m22',0,3000,0,NULL,NULL,'slopes',NULL,NULL,NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','HEFI',"HEMIZONIA FITCHII FITCH SPIKEWEED FITCH\'S SPIKEWEED FITCH\'S TARWEED SPIKEWEED ASTERACEAE",NULL,'FACU',48,'t',NULL,141,'t','Munz (ft.)','Munz (ft.)',37619,'HEMIZONIA FITCHII',"FITCH SPIKEWEED, FITCH\'S SPIKEWEED, FITCH\'S TARWEED, SPIKEWEED","Fitch spikeweed, Fitch\'s Spikeweed, Fitch\'s tarweed, spikeweed",'9092 3191 3548 0018');
INSERT INTO calflora VALUES(92,'Lathyrus sulphureus A. Gray','Lathyrus sulphureus','Lathyrus','sulphureus','A. Gray',NULL,NULL,NULL,'Fabaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','AMA BUT CAL ELD FRE GLE HUM KRN LAK MAD MEN MPA NEV PLA PLU SAC SHA SIS SON SUT TEH TRI TUL TUO YUB',NULL,'m22m14m15',0,8000,NULL,NULL,NULL,'slopes',NULL,NULL,'dry','Lum/monog., Walker',NULL,NULL,'LATHYRUS SULPHUREUS VAR. ARGILLACEUS',NULL,'not listed','not listed','LASU',"LATHYRUS SULPHUREUS BREWER\'S PEA SULPHER PEA SNUB PEA FABACEAE",NULL,'NI',23,'t',NULL,156,'t','Munz (ft.)','Munz (ft.)',25880,'LATHYRUS SULPHUREUS',"BREWER\'S PEA, SULPHER PEA, SNUB PEA","Brewer\'s pea, Sulpher pea, snub pea",'0000 0000 0601 0046');
INSERT INTO calflora VALUES(93,'Penstemon cinicola Keck','Penstemon cinicola','Penstemon','cinicola','Keck',NULL,NULL,NULL,'Scrophulariaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA, OR','LAS MOD SHA SIS',NULL,'m14 Medws',4000,5000,1,NULL,NULL,'meadows','volcanic','sandy',NULL,'Lum/Walker/Munz68,Dennis/CNPS94',NULL,NULL,'PENSTEMON CINICOLA',1358,'not listed','not listed','PECI2','PENSTEMON CINICOLA ASH BEARDTONGUE ASH PENSTEMON SCROPHULARIACEAE',NULL,'UPL',4,'t',NULL,15,'t','Munz (ft.)','Munz (ft.)',33851,'PENSTEMON CINICOLA','ASH BEARDTONGUE, ASH PENSTEMON','ash beardtongue, ash penstemon','6212 3041 0632 0049');
INSERT INTO calflora VALUES(94,'Fimbristylis vahlii (Lambert) Link','Fimbristylis vahlii','Fimbristylis','vahlii','(Lambert) Link',NULL,NULL,NULL,'Cyperaceae','monocot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','NAm/WW','FRE IMP KNG KRN MAD MER RIV SBD SJQ STA TUL',NULL,'m80',0,1640,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','FIVA',"FIMBRISTYLIS VAHLII VAHL\'S FIMBRISTYLIS VAHL\'S FIMBRY CYPERACEAE",NULL,'FACW*',12,'f',NULL,24,'t','JM (m)','JM (m)',40122,'FIMBRISTYLIS VAHLII',"VAHL\'S FIMBRISTYLIS, VAHL\'S FIMBRY","Vahl\'s fimbristylis, Vahl\'s fimbry",NULL);
INSERT INTO calflora VALUES(95,'Monardella hypoleuca A. Gray','Monardella hypoleuca','Monardella','hypoleuca','A. Gray',NULL,NULL,NULL,'Lamiaceae','dicot','parent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','CA Endemic','LAX ORA SBA SBD SDG VEN',NULL,'m23',0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','MOHY','MONARDELLA HYPOLEUCA THICKLEAF MONARDELLA WHITE-LEAF MONARDELLA LAMIACEAE',NULL,'NI',8,'t',NULL,41,'t',NULL,NULL,32603,'MONARDELLA HYPOLEUCA','THICKLEAF MONARDELLA, WHITE-LEAF MONARDELLA','thickleaf monardella, white-leaf monardella',NULL);
INSERT INTO calflora VALUES(96,'Polygonum sachalinense Maxim.','Polygonum sachalinense','Polygonum','sachalinense','Maxim.',NULL,NULL,NULL,'Polygonaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','BUT DNT ELD HUM MEN NEV SAC SCR SIS SLO SON YUB',NULL,'m40',0,1640,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'B','not listed','POSA4','POLYGONUM SACHALINENSE SACALINE GIANT KNOTWEED SACALINE POLYGONACEAE',NULL,'FACU*',12,'t',NULL,46,'f','JM (m)','JM (m)',20923,'POLYGONUM SACHALINENSE','SACALINE, GIANT KNOTWEED, SACALINE','Sacaline, giant knotweed, sacaline','0175 3301 2363 0068');
INSERT INTO calflora VALUES(97,'Camassia quamash (Pursh) E. Greene ssp. quamash','Camassia quamash ssp. quamash','Camassia','quamash','(Pursh) E. Greene','ssp.','quamash',NULL,'Liliaceae','monocot','child',1380,'Camassia quamash',NULL,NULL,NULL,NULL,'Munz:','Camassia leichtlinii (Baker) S. Wats. ssp. suksdorfii (Greenm.) Gould',NULL,NULL,NULL,NULL,'Perennial herb','wNAm','ALP AMA BUT CAL COL DNT ELD FRE GLE HUM LAK LAS MAD MEN MNO MOD MPA MRN NAP NEV PLA PLU SHA SIE SIS SON TEH TRI TUL TUO YUB',NULL,'m13m14m15 Medws',2000,8000,0,NULL,NULL,'meadows',NULL,NULL,NULL,'Lum/Walker/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','CAQUQ','CAMASSIA QUAMASH SSP. QUAMASH COMMON CAMAS STAR CAMAS CAMAS LILIACEAE CAMASSIA LEICHTLINII (BAKER) S. WATS. SSP. SUKSDORFII (GREENM.) GOULD',NULL,'FACW',40,'t',NULL,100,'t','Munz (ft.)','Munz (ft.)',42884,'CAMASSIA QUAMASH SSP. QUAMASH','COMMON CAMAS, STAR CAMAS, CAMAS','Common Camas, Star camas, camas','5208 1611 1726 0092');
INSERT INTO calflora VALUES(98,'Psilocarphus elatior (A. Gray) A. Gray','Psilocarphus elatior','Psilocarphus','elatior','(A. Gray) A. Gray',NULL,NULL,NULL,'Asteraceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Annual herb','NAm/WW?','LAS MOD SBD SHA SLO',NULL,'m25 Medws',NULL,NULL,1,NULL,NULL,'meadows',NULL,NULL,'vernally-moist','Dennis/CNPS94',NULL,NULL,'PSILOCARPHUS ELATIOR',1493,'not listed','not listed','PSEL','PSILOCARPHUS ELATIOR MEADOW WOOLLYHEADS TALL WOOLLY-MARBLES ASTERACEAE',NULL,'NI',4,'f',NULL,6,'t',NULL,NULL,38308,'PSILOCARPHUS ELATIOR','MEADOW WOOLLYHEADS, TALL WOOLLY-MARBLES','meadow woollyheads, tall woolly-marbles',NULL);
INSERT INTO calflora VALUES(99,'Clarkia mosquinii E. Small ssp. xerophylla E. Small','Clarkia mosquinii ssp. xerophylla','Clarkia','mosquinii','E. Small','ssp.','xerophylla','E. Small','Onagraceae','dicot','child',2201,'Clarkia mosquinii',NULL,NULL,'CNPS spelling:','Clarkia mosquinii E. Small ssp. xerophila E. Small','Munz:','Clarkia mosquinii E. Small ssp. xerophila E. Small','Clarkia mosquinii ssp. xerophila',NULL,NULL,NULL,'Annual herb','CA Endemic','BUT',NULL,'m22m14',NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'Dennis/CNPS94',NULL,NULL,'CLARKIA MOSQUINII SSP. XEROPHILA',483,'not listed','not listed','CLMOX','CLARKIA MOSQUINII SSP. XEROPHYLLA ONAGRACEAE CLARKIA MOSQUINII E. SMALL SSP. XEROPHILA E. SMALL CLARKIA MOSQUINII E. SMALL SSP. XEROPHILA E. SMALL',NULL,'NI',1,'f',NULL,8,'t',NULL,NULL,27614,'CLARKIA MOSQUINII SSP. XEROPHYLLA','\ ',NULL,NULL);
INSERT INTO calflora VALUES(100,'Lomatium parryi (S. Watson) J.F. Macbr.','Lomatium parryi','Lomatium','parryi','(S. Watson) J.F. Macbr.',NULL,NULL,NULL,'Apiaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','wNAm','INY SBD',NULL,'m28',4921,8202,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LOPA',"LOMATIUM PARRYI PARRY\'S LOMATIUM UTAH DESERTPARSLEY APIACEAE",NULL,'NI',3,'f',NULL,11,'t','JM (m)','JM (m)',29735,'LOMATIUM PARRYI',"PARRY\'S LOMATIUM, UTAH DESERTPARSLEY","Parry\'s lomatium, Utah desertparsley",NULL);
INSERT INTO calflora VALUES(101,'Limonium sinuatum (L.) Miller','Limonium sinuatum','Limonium','sinuatum','(L.) Miller',NULL,NULL,NULL,'Plumbaginaceae','dicot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Perennial herb','Introd.','LAX SBA SCL SCR SDG SLO',NULL,'m01m02',0,984,0,NULL,NULL,'coastal salt-marsh',NULL,NULL,NULL,'Lum/Munz68',NULL,NULL,NULL,NULL,'not listed','not listed','LISI2','LIMONIUM SINUATUM STATICE WAVYLEAF SEALAVENDER PLUMBAGINACEAE',NULL,'FACW',3,'t',NULL,11,'f','JM (m)','JM (m)',21336,'LIMONIUM SINUATUM','STATICE, WAVYLEAF SEALAVENDER','statice, wavyleaf sealavender','0000 0000 0301 0093');
create index allcnames_idx on calflora(allcnames);
create index caleppc_idx on calflora(caleppc_code);
create index calname_idx on calflora(calname);
create index category_idx on calflora(category);
create index cdfa_weed_idx on calflora(cdfa_weed_status);
create index cf_cname_idx on calflora(cf_cname);
create index extinctlist_idx on calflora(extinctlist);
create index family_idx on calflora(family);
create index fed_nox_weed_idx on calflora(fed_nox_weed);
create index genus_idx on calflora(genus);
create index habitats_idx on calflora(habitats);
create index itis_tsn_idx on calflora(itis_tsn);
create index lifeform_idx on calflora(lifeform);
create index lower_elev_ft_idx on calflora(lower_elev_ft);
create index namesoup_idx on calflora(namesoup);
create index native_idx on calflora(native);
create index numregions_idx on calflora(numregions);
create index parent_child_idx on calflora(parent_child);
create index parent_name_idx on calflora(parent_name);
create index parent_rec_idx on calflora(parent_rec);
create index pic_idx on calflora(pic);
create index plant_comunity_idx on calflora(plant_community);
create index plants_cname_idx on calflora(plants_cname);
create index plants_code_idx on calflora(plants_code);
create index range_idx on calflora(range);
create index rank_idx on calflora(rank);
create index rarity_idx on calflora(rarity);
create index regionlist_idx on calflora(regionlist);
create index species_idx on calflora(species);
create index ssp_var_idx on calflora(ssp_var);
create index taxon_idx on calflora(taxon);
create index u_allcnames_idx on calflora(u_allcnames);
create index u_taxon_idx on calflora(u_taxon);
create index upper_elev_ft_idx on calflora(upper_elev_ft);
create index usfs_cname_idx on calflora(usfs_cname);
create index wetland_idx on calflora(wetland);
COMMIT;
