#!/usr/bin/env python

import sys,types,sqlite

class bool:
    def __init__(self, value):
        self.value = value

    def __repr__(self):
        return self.value

conn = sqlite.connect(db="db", mode=077, converters={"bool": bool})
cursor = conn.cursor()

expected = ["int", "str", "str", "str", "str", "str", "str", "str", "str",
            "str", "str", "str", "int", "str", "str", "str", "str", "str",
            "str", "str", "str", "str", "str", "str", "str", "str", "str",
            "str", "str", "int", "int", "str", "str", "str", "str", "str",
            "str", "str", "str", "str", "str", "str", "int", "str", "str",
            "str", "str", "str", "str", "int", "bool", "str", "int", "bool",
            "str", "str", "int", "str", "str", "str", "str"]

cursor.execute("-- types %s" % (", ".join(expected)))
SQL = "select * from calflora order by calrecnum"
cursor.execute(SQL)

for row in cursor.fetchall():
    for field in row:
        if type(field) != types.StringType:
            sys.stdout.write(repr(field))
        else:
            sys.stdout.write(field)

        sys.stdout.write('|')

    sys.stdout.write("\n")

conn.close()
