#!/usr/bin/env python

# Sample SELECT Program.

# Illustrates the use of "-- types", which assigns data types to columns in
# a result set. fetchone() will return row with columns in respective data
# type. This example also illustrates the use of defining custom data types
# as well.

import sqlite

# Custom data type
class my_type:

    def __init__(self,value):
        self.value = value

    def __repr__(self):
        return "float(%.3f)" % float(self.value)

    def __str__(self):
        return "%.3f" % float(self.value)

# Connect to the database. We will be using the my_type in our result set, so we
# register it as a converter here.
conn = sqlite.connect("db", converters={'my_type':my_type})

# Obtain a cursor
cursor = conn.cursor()

# Create the SQL statement
SQL = """
      select category, family, genus, species, upper_elev_ft
      from calflora
      order by category, family, genus, species limit 10"""

# API Extension: Since SQLite is typeless, you can specify data types of columns
# here, and it will set return rows in those respective types. Here we want all
# strings except the last field is to be formatted as string. The last field
# will be typed using our custom type class (my_type).

cursor.execute('-- types str,str,str,str,my_type')

# Execute SQL
cursor.execute(SQL)

# Print SQL
print "SQL: ", cursor.sql + "\n"

# Fetch the first record
row = cursor.fetchone()

# Print Column information per SQLite. Note all column types are TEXT
print "1. Column Information per SQLite:\n"
for col in cursor.description:
    print "\t %15s - %3s bytes" % (col[0], repr(col[3]))

print

# Print column types per extended_type (conforms to that specified by extended_types)
print "2. Column Types per expected_types:\n"
print "\t" + repr(map(type,row)) + "\n"


# Print records
print "3. Records:\n"

for row in cursor.fetchall():
    # API Style Access: list-based
    #print "%14s, %15s, %19s, %8s, %25s" % (row[0], row[1], row[2], row[3], row[4])

    # API Extensions Access: dictionary-based -- field access by column name.
    print "%8s, %17s, %12s, %13s, %s" % ( row['category'],
                                          row['family'],
                                          row['genus'],
                                          row['species'],
                                          row['upper_elev_ft'])

# Close the database.
conn.close()
