#!/usr/bin/env python

import sqlite

# This illustrates the use of functions in SQL. You can create your own
# functions and include them in SQL.

# Function
def times_two(x):
    if x!=None:
        return float(x)*2
    else:
        return 0

conn = sqlite.connect("db", 077)

# Add the aggregate
conn.create_function("times_two", 1, times_two)

cursor = conn.cursor()

# Expect float value for column
cursor.execute('-- types = str, float, float')

# Execute SQL with custom aggregate
cursor.execute("select family, upper_elev_ft, times_two(upper_elev_ft) from calflora limit 10")

# Fetch
row = cursor.fetchone()

for row in cursor.fetchall():
    print row

conn.close()
