#!/usr/bin/env python

# Sample Select Program.
# Illustrates basic select per DB-API Specifications.

import sqlite

# Connect to the database.
conn = sqlite.connect(db="db", mode=755)

# Obtain a cursor
cursor = conn.cursor()

# Create the SQL statement
SQL = """
      select category, family, genus, species
      from calflora order by category, family, genus,
      species limit 10"""

# Execute SQL
cursor.execute(SQL)

# Print SQL
print "SQL: ", cursor.sql + "\n"
print "Results:\n"

for row in cursor.fetchall():
    # API Style Access: list-based
    #print "%14s, %15s, %19s, %8s, %25s" % (row[0], row[1], row[2], row[3], row[4])

    # API Extension: dictionary-based -- field access by column name.
    print "%8s, %19s, %14s, %15s" % ( row['category'],
                                      row['family'],
                                      row['genus'],
                                      row['species'])

    # API Extension: Print fields using list slices                                  
    #print row[2:-1]

    # API Extension: Print fields using mapping
    #print "%(genus)s %(species)s %(family)s %(category)s %(author1)s" \
    #       %(upper_elev_ft)s" % row

# Close the database.
conn.close()
