/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QEdje.
 *
 * QEdje is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QEdje is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QEdje.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QEDJEIMAGE_H__
#define __QEDJEIMAGE_H__

#include "qzion.h"


class QEdjeImage : public QZionImage
{
    Q_OBJECT

public:
    QEdjeImage(QZionAbstractCanvas *canvas = NULL);
    QEdjeImage(QZionAbstractCanvas *canvas,
               const QString &filepath, const QString &key);

    bool load(const QString &filename, const QString &key);
    bool reload();

private:
    QString _key;
    QPixmap loadPixmapFromEetFile(const QString &filename, const QString &fkey);
};


#endif
