/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSStorage.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "JSStorageCustom.h"
#include "KURL.h"
#include "Storage.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSStorage)

/* Hash table */

static const HashTableValue JSStorageTableValues[3] =
{
    { "length", DontDelete|DontEnum|ReadOnly, (intptr_t)jsStorageLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsStorageConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSStorageTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSStorageTableValues, 0 };
#else
    { 5, 3, JSStorageTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSStorageConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSStorageConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStorageConstructorTableValues, 0 };
#else
    { 1, 0, JSStorageConstructorTableValues, 0 };
#endif

class JSStorageConstructor : public DOMObject {
public:
    JSStorageConstructor(ExecState* exec)
        : DOMObject(JSStorageConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSStoragePrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSStorageConstructor::s_info = { "StorageConstructor", 0, &JSStorageConstructorTable, 0 };

bool JSStorageConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageConstructor, DOMObject>(exec, &JSStorageConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSStoragePrototypeTableValues[6] =
{
    { "key", DontDelete|DontEnum|Function, (intptr_t)jsStoragePrototypeFunctionKey, (intptr_t)1 },
    { "getItem", DontDelete|DontEnum|Function, (intptr_t)jsStoragePrototypeFunctionGetItem, (intptr_t)1 },
    { "setItem", DontDelete|DontEnum|Function, (intptr_t)jsStoragePrototypeFunctionSetItem, (intptr_t)2 },
    { "removeItem", DontDelete|DontEnum|Function, (intptr_t)jsStoragePrototypeFunctionRemoveItem, (intptr_t)1 },
    { "clear", DontDelete|DontEnum|Function, (intptr_t)jsStoragePrototypeFunctionClear, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSStoragePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSStoragePrototypeTableValues, 0 };
#else
    { 17, 15, JSStoragePrototypeTableValues, 0 };
#endif

const ClassInfo JSStoragePrototype::s_info = { "StoragePrototype", 0, &JSStoragePrototypeTable, 0 };

JSObject* JSStoragePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorage>(exec, globalObject);
}

bool JSStoragePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSStoragePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSStorage::s_info = { "Storage", 0, &JSStorageTable, 0 };

JSStorage::JSStorage(PassRefPtr<Structure> structure, PassRefPtr<Storage> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSStorage::~JSStorage()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSStorage::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSStoragePrototype(JSStoragePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSStorage::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSStorageTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<Storage*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSStorage, Base>(exec, &JSStorageTable, this, propertyName, slot);
}

JSValuePtr jsStorageLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Storage* imp = static_cast<Storage*>(static_cast<JSStorage*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValuePtr jsStorageConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSStorage*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSStorage::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    if (customPut(exec, propertyName, value, slot))
        return;
    Base::put(exec, propertyName, value, slot);
}

void JSStorage::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    if (customGetPropertyNames(exec, propertyNames))
        return;
     Base::getPropertyNames(exec, propertyNames);
}

JSValuePtr JSStorage::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSStorageConstructor>(exec);
}

JSValuePtr jsStoragePrototypeFunctionKey(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = jsString(exec, imp->key(index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsStoragePrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    const UString& key = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->getItem(key));
    return result;
}

JSValuePtr jsStoragePrototypeFunctionSetItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& key = args.at(exec, 0)->toString(exec);
    const UString& data = args.at(exec, 1)->toString(exec);

    imp->setItem(key, data, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsStoragePrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    const UString& key = args.at(exec, 0)->toString(exec);

    imp->removeItem(key);
    return jsUndefined();
}

JSValuePtr jsStoragePrototypeFunctionClear(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());

    imp->clear();
    return jsUndefined();
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, Storage* object)
{
    return getDOMObjectWrapper<JSStorage>(exec, object);
}
Storage* toStorage(JSC::JSValuePtr value)
{
    return value->isObject(&JSStorage::s_info) ? static_cast<JSStorage*>(asObject(value))->impl() : 0;
}

}
