/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONABSTRACTCANVAS_P_H__
#define __QZIONABSTRACTCANVAS_P_H__

#include "qzionobject.h"
#include "qzionobject_p.h"
#include "qzionabstractcanvas.h"

class QZionAbstractCanvasPrivate
{
public:
    QList<QZionObject*> items;
    QZionAbstractCanvas *owner;
    QGraphicsItem *canvasGroup;

    QZionAbstractCanvasPrivate(QZionAbstractCanvas *owner)
        : owner(owner) {};

    virtual ~QZionAbstractCanvasPrivate() {};

    inline void updateAfterRestack(QZionObject *obj, int from, int to);
};

void QZionAbstractCanvasPrivate::updateAfterRestack(QZionObject *obj,
                                                    int from, int to)
{
    Q_UNUSED(obj);

    /* This function is being used here to reset the ZValue after some
       restacking.  This will trigger updates on the QGV. */
    for (int i = from; i <= to; ++i) {
        QGraphicsItem *item = items[i]->_QZionObject_data->item;
        item->setZValue(i);
    }
}

#endif
