/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "qziontext.h"
#include "qziontext_p.h"

#include <QDebug>
#include <QRegion>
#include <QPainter>
#include <QApplication>
#include <QPaintEvent>
#include <QGraphicsItem>
#include <QGraphicsTextItem>

#include "qzionobject_p.h"


QZionText::QZionText(QZionAbstractCanvas *canvas)
    : QZionObject(canvas)
{
    QZINIT(QZionText, canvas);
}


QZionText::QZionText(QZionAbstractCanvas *canvas, const QString &text,
                     const QFont &font, const QColor &color)
    : QZionObject(canvas)
{
    QZINIT(QZionText, canvas);

    QZD(QZionText);
    d->setText(text);
    d->setFont(font);
    d->setTextColor(color);
}

QZionText::~QZionText()
{
    QZDELETE(QZionText);
}


QZionText::TextStyle QZionText::style() const
{
    QZD(QZionText);
    return (QZionText::TextStyle) d->style();
}


void QZionText::setStyle(QZionText::TextStyle style)
{
    QZD(QZionText);
    d->setStyle((QGraphicsQZionTextItem::TextStyle) style);
}


QSize QZionText::size() const
{
    QZD(QZionText);
    return d->size();
}

void QZionText::setSize(const QSize &size)
{
    QZD(QZionText);
    d->setSize(size);
    QZionObject::setSize(size);
}

QString QZionText::text() const
{
    QZD(QZionText);
    return d->text();
}

void QZionText::setText(const QString &text)
{
    QZD(QZionText);
    d->setText(text);
}

QColor QZionText::color() const
{
    QZD(QZionText);
    return d->baseColor;
}

void QZionText::setColor(const QColor &color)
{
    QZD(QZionText);

    if (d->baseColor.rgb() != color.rgb())
        d->baseColor.setRgb(color.rgb());

    if (opacity() != color.alpha())
        setOpacity(color.alpha());
    else
        changed();
}

void QZionText::setEllipsisAlignment(const qreal alignment)
{
    QZD(QZionText);
    d->setEllipsisAlignment(alignment);
}

qreal QZionText::ellipsisAlignment() const
{
    QZD(QZionText);
    return d->ellipsisAlignment();
}

QColor QZionText::textColor() const
{
    QZD(QZionText);
    return d->myTextColor;
}

void QZionText::setTextColor(const QColor &color)
{
    QZD(QZionText);
    d->myTextColor = color;

    changed();
}

QColor QZionText::outlineColor() const
{
    QZD(QZionText);
    return d->myOutlineColor;
}

void QZionText::setOutlineColor(const QColor &color)
{
    QZD(QZionText);
    d->myOutlineColor = color;

    changed();
}

QColor QZionText::shadowColor() const
{
    QZD(QZionText);
    return d->myShadowColor;
}

void QZionText::setShadowColor(const QColor &color)
{
    QZD(QZionText);
    d->myShadowColor = color;

    changed();
}


QFont QZionText::font() const
{
    QZD(QZionText);
    return d->font();
}

void QZionText::setFont(const QFont &font)
{
    QZD(QZionText);
    d->setFont(font);
}

QPointF QZionText::alignment() const
{
    QZD(QZionText);
    return d->alignment();
}

void QZionText::setAlignment(const QPointF &alignment)
{
    QZD(QZionText);
    d->setAlignment(alignment);
}

QRect QZionText::rect() const
{
    QZD(QZionText);
    return d->sceneBoundingRect().toRect().translated(pos());
}

void QZionText::paint(QPainter *painter)
{
    /* deprecated */
    Q_UNUSED(painter);
}

void QZionText::changed()
{
    QZD(QZionText);

    d->updateColors();

    QZionObject::changed();
}
