/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDebug>
#include <QRegion>
#include <QPainter>
#include <QApplication>
#include <QPaintEvent>

#include "qziontextblock_p.h"
#include "qziontextblock.h"
#include "qzionmacros.h"


QZionTextBlock::QZionTextBlock(QZionAbstractCanvas *canvas)
    : QZionObject(canvas), _QZionTextBlock_data(new QZionTextBlockPrivate())
{
    QZD(QZionTextBlock);
    d->owner = this;
    d->text = "";

    QPalette palette;
    palette.setBrush(QPalette::Window, QBrush(QColor(255, 255, 255, 0)));
    d->page.setPalette(palette);
    d->page.mainFrame()->setHtml(d->text);
    d->page.mainFrame()->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);
    d->page.mainFrame()->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
}

QZionTextBlock::QZionTextBlock(QZionAbstractCanvas *canvas, const QString &text)
    : QZionObject(canvas), _QZionTextBlock_data(new QZionTextBlockPrivate())
{
    QZD(QZionTextBlock);
    d->owner = this;
    d->text = text;

    QPalette palette;
    palette.setBrush(QPalette::Window, QBrush(QColor(255, 255, 255, 0)));
    d->page.setPalette(palette);
    d->page.mainFrame()->setHtml(d->text);
    d->page.mainFrame()->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);
    d->page.mainFrame()->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
}

QZionTextBlock::~QZionTextBlock()
{
    delete _QZionTextBlock_data;
}


QSize QZionTextBlock::size() const
{
    QZD(QZionTextBlock);
    return d->page.viewportSize();
}

void QZionTextBlock::setSize(const QSize &size)
{
    QZD(QZionTextBlock);
    QZionObject::setSize(size);
    d->page.setViewportSize(size);
    d->refresh();
}


QColor QZionTextBlock::color() const
{
    return QColor(255, 255, 255, 0);
}

void QZionTextBlock::setColor(const QColor &color)
{
    Q_UNUSED(color);
}


QString QZionTextBlock::text() const
{
    QZD(QZionTextBlock);
    return d->text;
}

void QZionTextBlock::setText(const QString &text)
{
    QZD(QZionTextBlock);

    if (d->text != text) {
        d->text = text;
        d->page.mainFrame()->setHtml(d->text);
        d->refresh();
    }
}

QRect QZionTextBlock::rect() const
{
    return QRect(pos(), size());
}


void QZionTextBlock::paint(QPainter *painter)
{
    QZD(QZionTextBlock);
    painter->translate(pos());
    d->page.mainFrame()->render(painter);
    painter->translate(-pos());
}
