/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "qziongroup.h"

#include <QDebug>
#include <QPainter>

#include "qzioncommon.h"
#include "qziongroup_p.h"
#include "qzionobject_p.h"
#include "qzionabstractcanvas.h"
#include "qzionabstractcanvas_p.h"


QZionGroup::QZionGroup(QZionAbstractCanvas *canvas)
  : QZionObject(canvas), QZionAbstractCanvas()
{
    QZINIT(QZionGroup, canvas);

    QZD(QZionGroup);
    d->setClipping(false);

    QZDP(QZionAbstractCanvas, da);
    da->canvasGroup = _QZionGroup_data;
}


QZionGroup::~QZionGroup()
{
    QZDELETE(QZionGroup);
}


QRect QZionGroup::rect() const
{
    QZD(QZionGroup);
    return d->boundingRect().toRect().translated(pos());
}

void QZionGroup::setColor(const QColor &color)
{
    setOpacity(color.alpha());
}

QSize QZionGroup::size() const
{
    QZD(QZionGroup);
    return d->size();
}

void QZionGroup::setSize(const QSize &size)
{
    QZD(QZionGroup);
    d->setSize(size);
    QZionObject::setSize(size);
}

int QZionGroup::canvasWidth() const
{
    QZD(QZionObject);
    return d->canvas ? d->canvas->canvasWidth() : 0;
}

int QZionGroup::canvasHeight() const
{
    QZD(QZionObject);
    return d->canvas ? d->canvas->canvasHeight() : 0;
}

QPoint QZionGroup::mapToLocal(const QPoint &pt) const
{
    return pt - pos();
}

void QZionGroup::mouseMoveEvent(QMouseEvent *e)
{
    QZionAbstractCanvas::mouseMoveEvent(e);
}

void QZionGroup::mousePressEvent(QMouseEvent *e)
{
    QZionAbstractCanvas::mousePressEvent(e);
}

void QZionGroup::mouseReleaseEvent(QMouseEvent *e)
{
    QZionAbstractCanvas::mouseReleaseEvent(e);
}

void QZionGroup::wheelEvent(QWheelEvent *e)
{
    QZionAbstractCanvas::wheelEvent(e);
}

bool QZionGroup::contains(const QPoint &point) const
{
    QZD(QZionObject);
    QPointF mappedPt = d->item->mapFromParent(point);
    return d->item->contains(mappedPt) ||
        (testAttribute(HandleOutOfBoundsEvents) &&
         d->item->childrenBoundingRect().contains(mappedPt));
}

void QZionGroup::setClipper(QZionRectangle *rect)
{
    QZionObject::setClipper(rect);
    QZD(QZionGroup);
    d->setClipping(rect != NULL);
}

QColor QZionGroup::effectiveColor()
{
    // optimization candidate (caching)
    return QZionObject::effectiveColor();
}

void QZionGroup::changed()
{
    QZD(QZionAbstractCanvas);
    foreach (QZionObject *obj, d->items)
        if (obj->clipper() == NULL)
            obj->changed();

    QZionObject::changed();
}

//////////////////////////////////////////////////////////////

void QZionGroup::updateChanges() {}
void QZionGroup::ensurePendingUpdate() {}
void QZionGroup::invalidate(const QRect &, bool) {}
void QZionGroup::invalidate(const QRegion &, bool) {}
void QZionGroup::paint(QPainter *) {}
void QZionGroup::paintInternal(QPainter *, const QRect &, const QRegion &,
                               const QPoint &, double) {}
