/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONGROUP_P_H__
#define __QZIONGROUP_P_H__

#include <QGraphicsItem>
#include "qziongroup.h"
#include "qzioncommon.h"
#include "qzionrectangle.h"
#include "qgraphicsziongroup.h"


class QZionGroupPrivate : public QGraphicsZionGroup
{
public:
    QZionGroupPrivate(QGraphicsItem *parent = 0)
        : QGraphicsZionGroup(parent) {}

    virtual ~QZionGroupPrivate() {}

    virtual inline QPainterPath shape() const;
};

inline QPainterPath QZionGroupPrivate::shape() const
{
    QZionGroup *owner = static_cast<QZionGroup *>(this->owner);

    if (owner->clipper()) {
        QRect baseClipper = owner->clipper()->effectiveRect();
        QRect paintClipper = baseClipper.translated(-owner->pos());

        // todo: intersect with boundingRect if clipping is enabled

        QPainterPath path;
        path.addRect(paintClipper);
        return path;
    } else {
        return QGraphicsZionGroup::shape();
    }
}

#endif
