#!/usr/bin/python
# Copyright (C) 2009-2013 Canonical, Ltd.
#
# This library is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License
# version 3.0 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3.0 for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library. If not, see
# <http://www.gnu.org/licenses/>.
"""Setup script for Ubuntu One Music Store plug-in for Rhythmbox."""

import DistUtilsExtra.auto


DistUtilsExtra.auto.setup(
    name='rhythmbox-ubuntuone',
    version='13.10',
    license='LGPL v3',
    author='Ubuntu One Developers',
    author_email='ubuntuone-users@lists.launchpad.net',
    description='Ubuntu One Rhythmbox plug-in',
    long_description=('A plug-in to integrate Ubuntu One in Rhythmbox.'),
    url='https://launchpad.net/rhythmbox-ubuntuone',
    data_files=[('lib/rhythmbox/plugins/ubuntuone',
                 ['ubuntuone/ubuntuone.py',
                  ])],
)
